/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.bmp;

import gnu.javax.imageio.bmp.BMPEncoder;
import gnu.javax.imageio.bmp.BMPException;
import gnu.javax.imageio.bmp.BMPFileHeader;
import gnu.javax.imageio.bmp.BMPInfoHeader;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;

public class BMPImageWriter
extends ImageWriter {
    protected BMPEncoder encoder = null;
    protected BMPFileHeader fileHeader = null;
    protected BMPInfoHeader infoHeader = null;

    protected BMPImageWriter(ImageWriterSpi originatingProvider) {
        super(originatingProvider);
    }

    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        if (inData == null || imageType == null) {
            throw new IllegalArgumentException("IIOMetadata and ImageTypeSpecifier cannot be null.");
        }
        return null;
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        if (inData == null) {
            throw new IllegalArgumentException("IIOMetadata cannot be null.");
        }
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        return null;
    }

    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException, BMPException {
        this.checkStream();
        ImageOutputStream out = (ImageOutputStream)this.output;
        this.fileHeader = new BMPFileHeader(out, image);
        this.infoHeader = new BMPInfoHeader(out, image, param);
        this.encoder = BMPEncoder.getEncoder(this.fileHeader, this.infoHeader);
        if (this.encoder == null) {
            throw new BMPException("Encoder has not been initialized.");
        }
        this.encoder.encode(out, streamMetadata, image, param);
        out.close();
    }

    private void checkStream() throws IOException {
        if (!(this.output instanceof ImageOutputStream)) {
            throw new IllegalStateException("Output not an ImageOutputStream.");
        }
        if (this.output == null) {
            throw new IllegalStateException("No output stream.");
        }
    }
}

