/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.security.auth.callback;

import gnu.java.security.Engine;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.LanguageCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public abstract class AbstractCallbackHandler
implements CallbackHandler {
    private static final String SERVICE = "CallbackHandler";
    protected final ResourceBundle messages = PropertyResourceBundle.getBundle("gnu/javax/security/auth/callback/MessagesBundle");
    private final String name;

    protected AbstractCallbackHandler(String name) {
        this.name = name;
    }

    public static CallbackHandler getInstance(String type) throws NoSuchAlgorithmException {
        Provider[] p = Security.getProviders();
        NoSuchAlgorithmException lastException = null;
        int i = 0;
        while (i < p.length) {
            try {
                return AbstractCallbackHandler.getInstance(type, p[i]);
            }
            catch (NoSuchAlgorithmException x) {
                lastException = x;
                ++i;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        throw new NoSuchAlgorithmException(type);
    }

    public static CallbackHandler getInstance(String type, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (provider == null) {
            throw new IllegalArgumentException("provider MUST NOT be null");
        }
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        return AbstractCallbackHandler.getInstance(type, p);
    }

    public static CallbackHandler getInstance(String type, Provider provider) throws NoSuchAlgorithmException {
        Throwable cause;
        StringBuilder sb = new StringBuilder("CallbackHandler of type [").append(type).append("] from provider[").append(provider).append("] could not be created");
        try {
            return (CallbackHandler)Engine.getInstance(SERVICE, type, provider);
        }
        catch (InvocationTargetException x) {
            cause = x.getCause();
            if (cause instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)cause;
            }
            if (cause == null) {
                cause = x;
            }
        }
        catch (ClassCastException x) {
            cause = x;
        }
        NoSuchAlgorithmException x = new NoSuchAlgorithmException(sb.toString());
        x.initCause(cause);
        throw x;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks == null) {
            throw new NullPointerException();
        }
        int i = 0;
        while (i < callbacks.length) {
            if (callbacks[i] != null) {
                if (callbacks[i] instanceof ChoiceCallback) {
                    this.handleChoice((ChoiceCallback)callbacks[i]);
                } else if (callbacks[i] instanceof ConfirmationCallback) {
                    this.handleConfirmation((ConfirmationCallback)callbacks[i]);
                } else if (callbacks[i] instanceof LanguageCallback) {
                    this.handleLanguage((LanguageCallback)callbacks[i]);
                } else if (callbacks[i] instanceof NameCallback) {
                    this.handleName((NameCallback)callbacks[i]);
                } else if (callbacks[i] instanceof PasswordCallback) {
                    this.handlePassword((PasswordCallback)callbacks[i]);
                } else if (callbacks[i] instanceof TextInputCallback) {
                    this.handleTextInput((TextInputCallback)callbacks[i]);
                } else if (callbacks[i] instanceof TextOutputCallback) {
                    this.handleTextOutput((TextOutputCallback)callbacks[i]);
                } else {
                    this.handleOther(callbacks[i]);
                }
            }
            ++i;
        }
    }

    public final String getName() {
        return this.name;
    }

    protected abstract void handleChoice(ChoiceCallback var1) throws IOException;

    protected abstract void handleConfirmation(ConfirmationCallback var1) throws IOException;

    protected abstract void handleLanguage(LanguageCallback var1) throws IOException;

    protected abstract void handleName(NameCallback var1) throws IOException;

    protected abstract void handlePassword(PasswordCallback var1) throws IOException;

    protected abstract void handleTextInput(TextInputCallback var1) throws IOException;

    protected abstract void handleTextOutput(TextOutputCallback var1) throws IOException;

    protected void handleOther(Callback callback) throws IOException, UnsupportedCallbackException {
        throw new UnsupportedCallbackException(callback);
    }
}

