/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import gnu.xml.dom.DTDAttributeTypeInfo;
import gnu.xml.dom.DomDOMException;
import gnu.xml.dom.DomDoctype;
import gnu.xml.dom.DomDocument;
import gnu.xml.dom.DomElement;
import gnu.xml.dom.DomNode;
import gnu.xml.dom.DomNsNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.events.MutationEvent;

public class DomAttr
extends DomNsNode
implements Attr {
    private boolean specified = true;
    private String value;

    protected DomAttr(DomDocument owner, String namespaceURI, String name) {
        super((short)2, owner, namespaceURI, name);
        this.length = 1;
    }

    public final String getName() {
        return this.getNodeName();
    }

    public final boolean getSpecified() {
        return this.specified;
    }

    public final void setSpecified(boolean value) {
        this.specified = value;
    }

    public String getNodeValue() {
        if (this.first == null) {
            return this.value == null ? "" : this.value;
        }
        StringBuffer buf = new StringBuffer();
        DomNode ctx = this.first;
        while (ctx != null) {
            switch (ctx.nodeType) {
                case 3: {
                    buf.append(ctx.getNodeValue());
                    break;
                }
            }
            ctx = ctx.next;
        }
        return buf.toString();
    }

    public final void setValue(String value) {
        this.setNodeValue(value);
    }

    public final String getValue() {
        return this.getNodeValue();
    }

    public void setNodeValue(String value) {
        if (this.readonly) {
            throw new DomDOMException(7);
        }
        if (value == null) {
            value = "";
        }
        String oldValue = this.getNodeValue();
        while (this.last != null) {
            this.removeChild(this.last);
        }
        this.value = value;
        this.length = 1;
        this.specified = true;
        this.mutating(oldValue, value, (short)1);
    }

    public final Node getFirstChild() {
        if (this.first == null) {
            this.length = 0;
            Text text = this.owner.createTextNode(this.value == null ? "" : this.value);
            this.appendChild(text);
        }
        return this.first;
    }

    public final Node getLastChild() {
        if (this.last == null) {
            this.length = 0;
            Text text = this.owner.createTextNode(this.value == null ? "" : this.value);
            this.appendChild(text);
        }
        return this.last;
    }

    public Node item(int index) {
        if (this.first == null) {
            this.length = 0;
            Text text = this.owner.createTextNode(this.value == null ? "" : this.value);
            this.appendChild(text);
        }
        return super.item(index);
    }

    public final Element getOwnerElement() {
        return (Element)((Object)this.parent);
    }

    public final Node getNextSibling() {
        return null;
    }

    public final Node getPreviousSibling() {
        return null;
    }

    public Node getParentNode() {
        return null;
    }

    public final void setOwnerElement(Element e) {
        if (this.parent != null) {
            throw new DomDOMException(3);
        }
        if (!(e instanceof DomElement)) {
            throw new DomDOMException(4);
        }
        this.parent = (DomElement)e;
        this.depth = this.parent.depth + 1;
    }

    public final String getBaseURI() {
        return null;
    }

    public Object clone() {
        DomAttr retval = (DomAttr)super.clone();
        retval.specified = true;
        return retval;
    }

    private void mutating(String oldValue, String newValue, short why) {
        if (this.parent == null || this.equal(newValue, oldValue)) {
            return;
        }
        MutationEvent event = (MutationEvent)this.createEvent("MutationEvents");
        event.initMutationEvent("DOMAttrModified", true, false, null, oldValue, newValue, this.getNodeName(), why);
        this.parent.dispatchEvent(event);
    }

    public TypeInfo getSchemaTypeInfo() {
        DomDoctype doctype;
        if (this.parent != null && (doctype = (DomDoctype)this.parent.owner.getDoctype()) != null) {
            return doctype.getAttributeTypeInfo(this.parent.getNodeName(), this.getNodeName());
        }
        return null;
    }

    public boolean isId() {
        if (this.parent != null) {
            DTDAttributeTypeInfo info;
            DomDoctype doctype = (DomDoctype)this.parent.owner.getDoctype();
            if (doctype != null && (info = doctype.getAttributeTypeInfo(this.parent.getNodeName(), this.getNodeName())) != null && "ID".equals(info.type)) {
                return true;
            }
            DomElement element = (DomElement)this.parent;
            if (element.userIdAttrs != null && element.userIdAttrs.contains(this)) {
                return true;
            }
        }
        return false;
    }
}

