/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.events.UIEvent;
import org.w3c.dom.views.AbstractView;

public class DomEvent
implements Event {
    String type;
    EventTarget target;
    EventTarget currentNode;
    short eventPhase;
    boolean bubbles;
    boolean cancelable;
    long timeStamp;
    boolean stop;
    boolean doDefault;

    public final String getType() {
        return this.type;
    }

    public final EventTarget getTarget() {
        return this.target;
    }

    public final EventTarget getCurrentTarget() {
        return this.currentNode;
    }

    public final short getEventPhase() {
        return this.eventPhase;
    }

    public final boolean getBubbles() {
        return this.bubbles;
    }

    public final boolean getCancelable() {
        return this.cancelable;
    }

    public final long getTimeStamp() {
        return this.timeStamp;
    }

    public void stopPropagation() {
        this.stop = true;
    }

    public final void preventDefault() {
        this.doDefault = false;
    }

    public void initEvent(String typeArg, boolean canBubbleArg, boolean cancelableArg) {
        this.eventPhase = 0;
        this.type = typeArg;
        this.bubbles = canBubbleArg;
        this.cancelable = cancelableArg;
        this.timeStamp = System.currentTimeMillis();
    }

    public DomEvent(String type) {
        this.type = type;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("[Event ");
        buf.append(this.type);
        switch (this.eventPhase) {
            case 1: {
                buf.append(", CAPTURING");
                break;
            }
            case 2: {
                buf.append(", AT TARGET");
                break;
            }
            case 3: {
                buf.append(", BUBBLING");
                break;
            }
            default: {
                buf.append(", (inactive)");
            }
        }
        if (this.bubbles && this.eventPhase != 3) {
            buf.append(", bubbles");
        }
        if (this.cancelable) {
            buf.append(", can cancel");
        }
        buf.append("]");
        return buf.toString();
    }

    public static final class DomMutationEvent
    extends DomEvent
    implements MutationEvent {
        Node relatedNode;
        private String prevValue;
        private String newValue;
        private String attrName;
        private short attrChange;

        public final Node getRelatedNode() {
            return this.relatedNode;
        }

        public final String getPrevValue() {
            return this.prevValue;
        }

        public final String getNewValue() {
            return this.newValue;
        }

        public final String getAttrName() {
            return this.attrName;
        }

        public final short getAttrChange() {
            return this.attrChange;
        }

        public final void initMutationEvent(String typeArg, boolean canBubbleArg, boolean cancelableArg, Node relatedNodeArg, String prevValueArg, String newValueArg, String attrNameArg, short attrChangeArg) {
            this.eventPhase = 0;
            this.type = typeArg;
            this.bubbles = canBubbleArg;
            this.cancelable = cancelableArg;
            this.timeStamp = System.currentTimeMillis();
            this.relatedNode = relatedNodeArg;
            this.prevValue = prevValueArg;
            this.newValue = newValueArg;
            this.attrName = attrNameArg;
            this.attrChange = attrChangeArg;
        }

        void clear() {
            this.type = null;
            this.target = null;
            this.relatedNode = null;
            this.currentNode = null;
            this.attrName = null;
            this.newValue = null;
            this.prevValue = null;
        }

        public DomMutationEvent(String type) {
            super(type);
        }
    }

    public static class DomUIEvent
    extends DomEvent
    implements UIEvent {
        private AbstractView view;
        private int detail;

        public DomUIEvent(String type) {
            super(type);
        }

        public final AbstractView getView() {
            return this.view;
        }

        public final int getDetail() {
            return this.detail;
        }

        public final void initUIEvent(String typeArg, boolean canBubbleArg, boolean cancelableArg, AbstractView viewArg, int detailArg) {
            super.initEvent(typeArg, canBubbleArg, cancelableArg);
            this.view = viewArg;
            this.detail = detailArg;
        }
    }
}

