/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom.ls;

import gnu.xml.dom.DomDOMException;
import gnu.xml.dom.DomDocument;
import gnu.xml.dom.ls.DomLSException;
import gnu.xml.dom.ls.DomLSInput;
import gnu.xml.dom.ls.FilteredSAXEventSink;
import gnu.xml.dom.ls.SAXEventSink;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMStringList;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSException;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSParserFilter;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class DomLSParser
implements LSParser,
DOMConfiguration,
DOMStringList,
ErrorHandler {
    private static final List SUPPORTED_PARAMETERS = Arrays.asList("cdata-sections", "comments", "element-content-whitespace", "namespaces", "expand-entity-references", "coalescing", "validating", "xinclude-aware", "entity-resolver", "error-handler");
    private LSParserFilter filter;
    private final boolean async;
    private String schemaType;
    private SAXEventSink eventSink;
    private SAXParserFactory factory;
    private XMLReader reader;
    private boolean namespaceAware = true;
    private boolean ignoreWhitespace;
    private boolean expandEntityReferences;
    private boolean ignoreComments;
    private boolean coalescing;
    private boolean validating;
    private boolean xIncludeAware;
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler;

    public DomLSParser(short mode, String schemaType) throws DOMException {
        switch (mode) {
            case 2: {
                this.async = true;
                break;
            }
            case 1: {
                this.async = false;
                break;
            }
            default: {
                throw new DomDOMException(9);
            }
        }
        this.schemaType = schemaType;
        this.factory = SAXParserFactory.newInstance();
    }

    public DOMConfiguration getDomConfig() {
        return this;
    }

    public LSParserFilter getFilter() {
        return this.filter;
    }

    public void setFilter(LSParserFilter filter) {
        this.filter = filter;
    }

    public boolean getAsync() {
        return this.async;
    }

    public boolean getBusy() {
        return this.eventSink != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document parse(LSInput input) throws DOMException, LSException {
        if (this.async) {
            return this.doParse(input);
        }
        DomLSParser domLSParser = this;
        synchronized (domLSParser) {
            return this.doParse(input);
        }
    }

    public Document parseURI(String uri) throws DOMException, LSException {
        DomLSInput input = new DomLSInput();
        input.setSystemId(uri);
        return this.parse(input);
    }

    public Node parseWithContext(LSInput input, Node context, short action) throws DOMException, LSException {
        Document doc = context.getNodeType() == 9 ? (Document)context : context.getOwnerDocument();
        input.setBaseURI(doc.getDocumentURI());
        Document ret = this.parse(input);
        Node root = ret.getDocumentElement();
        root = doc.adoptNode(root);
        switch (action) {
            case 1: {
                context.appendChild(root);
                break;
            }
            case 2: {
                Node c1 = context.getFirstChild();
                while (c1 != null) {
                    Node next = c1.getNextSibling();
                    context.removeChild(c1);
                    c1 = next;
                }
                context.appendChild(root);
                break;
            }
            case 3: {
                Node p1 = context.getParentNode();
                p1.insertBefore(root, context);
                break;
            }
            case 4: {
                Node p2 = context.getParentNode();
                Node r1 = context.getNextSibling();
                if (r1 == null) {
                    p2.appendChild(root);
                    break;
                }
                p2.insertBefore(root, r1);
                break;
            }
            case 5: {
                Node p3 = context.getParentNode();
                Node r2 = context.getNextSibling();
                p3.removeChild(context);
                if (r2 == null) {
                    p3.appendChild(root);
                    break;
                }
                p3.insertBefore(root, r2);
            }
        }
        return root;
    }

    public void abort() {
        if (this.eventSink != null) {
            this.eventSink.interrupt();
        }
    }

    private Document doParse(LSInput input) throws DOMException, LSException {
        XMLReader reader;
        if (this.eventSink != null) {
            throw new LSException(81, "parse in progress");
        }
        InputSource source = this.getInputSource(input);
        this.eventSink = this.filter == null ? new SAXEventSink() : new FilteredSAXEventSink(this.filter);
        this.eventSink.namespaceAware = this.namespaceAware;
        this.eventSink.ignoreWhitespace = this.ignoreWhitespace;
        this.eventSink.expandEntityReferences = this.expandEntityReferences;
        this.eventSink.ignoreComments = this.ignoreComments;
        this.eventSink.coalescing = this.coalescing;
        this.eventSink.reader = reader = this.getXMLReader();
        try {
            reader.setContentHandler(this.eventSink);
            reader.setDTDHandler(this.eventSink);
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", this.eventSink);
            reader.setProperty("http://xml.org/sax/properties/declaration-handler", this.eventSink);
            reader.setFeature("http://xml.org/sax/features/namespaces", this.namespaceAware);
            reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            reader.setFeature("http://xml.org/sax/features/validation", this.validating);
            try {
                reader.setFeature("http://gnu.org/sax/features/coalescing", this.coalescing);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {}
            try {
                reader.setFeature("http://xml.org/sax/features/use-attributes2", true);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {}
            try {
                reader.setFeature("http://xml.org/sax/features/external-general-entities", true);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {}
            reader.setEntityResolver(this.entityResolver);
            reader.setErrorHandler(this.errorHandler);
            reader.parse(source);
        }
        catch (DOMException e) {
            reader = null;
            this.eventSink = null;
            throw e;
        }
        catch (SAXException e) {
            reader = null;
            this.eventSink = null;
            throw new DomLSException(81, e);
        }
        catch (IOException e) {
            reader = null;
            this.eventSink = null;
            throw new DomLSException(81, e);
        }
        DomDocument ret = this.eventSink.doc;
        String systemId = input.getSystemId();
        if (systemId != null && ret instanceof DomDocument) {
            ret.setDocumentURI(systemId);
        }
        this.eventSink = null;
        return ret;
    }

    private XMLReader getXMLReader() throws LSException {
        if (this.reader == null) {
            this.factory.setNamespaceAware(this.namespaceAware);
            this.factory.setValidating(this.validating);
            this.factory.setXIncludeAware(this.xIncludeAware);
            try {
                SAXParser parser = this.factory.newSAXParser();
                this.reader = parser.getXMLReader();
            }
            catch (ParserConfigurationException e) {
                throw new DomLSException(81, e);
            }
            catch (SAXException e) {
                throw new DomLSException(81, e);
            }
        }
        return this.reader;
    }

    private InputSource getInputSource(LSInput input) throws LSException {
        InputSource source = null;
        String systemId = input.getSystemId();
        InputStream in = input.getByteStream();
        if (in != null) {
            source = new InputSource(in);
            source.setSystemId(systemId);
        }
        if (source == null) {
            URL url = null;
            String base = input.getBaseURI();
            try {
                try {
                    URL baseURL = base == null ? null : new URL(base);
                    url = baseURL == null ? new URL(systemId) : new URL(baseURL, systemId);
                }
                catch (MalformedURLException malformedURLException) {
                    File baseFile = base == null ? null : new File(base);
                    url = baseFile == null ? new File(systemId).toURL() : new File(baseFile, systemId).toURL();
                }
                in = url.openStream();
                systemId = url.toString();
                source = new InputSource(in);
                source.setSystemId(systemId);
            }
            catch (IOException e) {
                throw new DomLSException(81, e);
            }
        }
        return source;
    }

    public void setParameter(String name, Object value) throws DOMException {
        if ("cdata-sections".equals(name = name.toLowerCase())) {
            this.coalescing = (Boolean)value == false;
        } else if ("comments".equals(name)) {
            this.ignoreComments = (Boolean)value == false;
        } else if ("element-content-whitespace".equals(name)) {
            this.ignoreWhitespace = (Boolean)value == false;
        } else if ("namespaces".equals(name)) {
            this.namespaceAware = (Boolean)value;
        } else if ("expand-entity-references".equals(name)) {
            this.expandEntityReferences = (Boolean)value;
        } else if ("coalescing".equals(name)) {
            this.coalescing = (Boolean)value;
        } else if ("validating".equals(name)) {
            this.validating = (Boolean)value;
        } else if ("xinclude-aware".equals(name)) {
            this.xIncludeAware = (Boolean)value;
        } else if ("entity-resolver".equals(name)) {
            this.entityResolver = (EntityResolver)value;
        } else if ("error-handler".equals(name)) {
            this.errorHandler = (ErrorHandler)value;
        } else {
            throw new DomDOMException(9);
        }
        this.reader = null;
    }

    public Object getParameter(String name) throws DOMException {
        if ("cdata-sections".equals(name = name.toLowerCase())) {
            return this.coalescing ? Boolean.FALSE : Boolean.TRUE;
        }
        if ("comments".equals(name)) {
            return this.ignoreComments ? Boolean.FALSE : Boolean.TRUE;
        }
        if ("element-content-whitespace".equals(name)) {
            return this.ignoreWhitespace ? Boolean.FALSE : Boolean.TRUE;
        }
        if ("namespaces".equals(name)) {
            return this.namespaceAware ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("expand-entity-references".equals(name)) {
            return this.expandEntityReferences ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("coalescing".equals(name)) {
            return this.coalescing ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("validating".equals(name)) {
            return this.validating ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("xinclude-aware".equals(name)) {
            return this.xIncludeAware ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("entity-resolver".equals(name)) {
            return this.entityResolver;
        }
        if ("error-handler".equals(name)) {
            return this.errorHandler;
        }
        throw new DomDOMException(9);
    }

    public boolean canSetParameter(String name, Object value) {
        return this.contains(name);
    }

    public DOMStringList getParameterNames() {
        return this;
    }

    public String item(int i) {
        return (String)SUPPORTED_PARAMETERS.get(i);
    }

    public int getLength() {
        return SUPPORTED_PARAMETERS.size();
    }

    public boolean contains(String str) {
        return SUPPORTED_PARAMETERS.contains(str);
    }

    public void warning(SAXParseException e) throws SAXException {
        if (this.errorHandler != null) {
            this.errorHandler.warning(e);
        }
    }

    public void error(SAXParseException e) throws SAXException {
        if (this.errorHandler != null) {
            this.errorHandler.error(e);
        }
    }

    public void fatalError(SAXParseException e) throws SAXException {
        if (this.errorHandler != null) {
            this.errorHandler.fatalError(e);
        }
        this.abort();
    }
}

