/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom.ls;

import gnu.xml.dom.DomAttr;
import gnu.xml.dom.DomDoctype;
import gnu.xml.dom.DomDocument;
import gnu.xml.dom.DomNode;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.Attributes2;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.ext.Locator2;

public class SAXEventSink
implements ContentHandler,
LexicalHandler,
DTDHandler,
DeclHandler {
    private static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    private static final String XMLNS_PREFIX = "xmlns";
    private static final HashSet PREDEFINED_ENTITIES = new HashSet();
    boolean namespaceAware;
    boolean ignoreWhitespace;
    boolean expandEntityReferences;
    boolean ignoreComments;
    boolean coalescing;
    XMLReader reader;
    DomDocument doc;
    Node ctx;
    LinkedList entityCtx;
    List pending;
    Locator locator;
    boolean inCDATA;
    boolean inDTD;
    boolean interrupted;

    static {
        PREDEFINED_ENTITIES.add("amp");
        PREDEFINED_ENTITIES.add("lt");
        PREDEFINED_ENTITIES.add("gt");
        PREDEFINED_ENTITIES.add("quot");
        PREDEFINED_ENTITIES.add("apos");
    }

    void interrupt() {
        this.interrupted = true;
    }

    public Document getDocument() {
        return this.doc;
    }

    public void setReader(XMLReader reader) {
        this.reader = reader;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
        if (this.namespaceAware) {
            this.pending = new LinkedList();
        }
        this.doc = new DomDocument();
        this.doc.setStrictErrorChecking(false);
        this.doc.setBuilding(true);
        this.doc.setDefaultAttributes(false);
        this.ctx = this.doc;
        if (this.reader != null) {
            boolean standalone = this.reader.getFeature("http://xml.org/sax/features/is-standalone");
            this.doc.setXmlStandalone(standalone);
            try {
                String version = (String)this.reader.getProperty("http://xml.org/sax/properties/document-xml-version");
                this.doc.setXmlVersion(version);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {}
            try {
                String encoding = (String)this.reader.getProperty("http://gnu.org/sax/properties/document-xml-encoding");
                this.doc.setXmlEncoding(encoding);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {}
        }
        if (this.locator != null && this.locator instanceof Locator2) {
            String encoding = ((Locator2)this.locator).getEncoding();
            this.doc.setInputEncoding(encoding);
        }
    }

    public void endDocument() throws SAXException {
        this.doc.setStrictErrorChecking(true);
        this.doc.setBuilding(false);
        this.doc.setDefaultAttributes(true);
        DomDoctype doctype = (DomDoctype)this.doc.getDoctype();
        if (doctype != null) {
            doctype.makeReadonly();
        }
        this.ctx = null;
        this.locator = null;
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.namespaceAware) {
            String nsName = prefix != null && prefix.length() > 0 ? "xmlns:" + prefix : XMLNS_PREFIX;
            DomAttr ns = (DomAttr)this.doc.createAttributeNS(XMLNS_URI, nsName);
            ns.setNodeValue(uri);
            if (this.ctx.getNodeType() == 2) {
                Element target = ((Attr)this.ctx).getOwnerElement();
                target.getAttributes().setNamedItemNS(ns);
            } else {
                this.pending.add(ns);
            }
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.interrupted) {
            return;
        }
        Element element = this.createElement(uri, localName, qName, atts);
        this.ctx.appendChild(element);
        this.ctx = element;
    }

    protected Element createElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        Element element = this.namespaceAware ? this.doc.createElementNS(uri, qName) : this.doc.createElement(qName);
        NamedNodeMap attrs = element.getAttributes();
        if (this.namespaceAware && !this.pending.isEmpty()) {
            for (Node ns : this.pending) {
                attrs.setNamedItemNS(ns);
            }
            this.pending.clear();
        }
        int len = atts.getLength();
        int i = 0;
        while (i < len) {
            Attr attr = this.createAttr(atts, i);
            if (attr != null) {
                if (this.namespaceAware) {
                    attrs.setNamedItemNS(attr);
                } else {
                    attrs.setNamedItem(attr);
                }
            }
            ++i;
        }
        return element;
    }

    protected Attr createAttr(Attributes atts, int index) {
        DomAttr attr;
        if (this.namespaceAware) {
            String a_uri = atts.getURI(index);
            String a_qName = atts.getQName(index);
            attr = (DomAttr)this.doc.createAttributeNS(a_uri, a_qName);
        } else {
            String a_qName = atts.getQName(index);
            attr = (DomAttr)this.doc.createAttribute(a_qName);
        }
        attr.setNodeValue(atts.getValue(index));
        if (atts instanceof Attributes2) {
            Attributes2 atts2 = (Attributes2)atts;
            attr.setSpecified(atts2.isSpecified(index));
        }
        return attr;
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.interrupted) {
            return;
        }
        if (this.namespaceAware) {
            this.pending.clear();
        }
        this.ctx = this.ctx.getParentNode();
    }

    public void characters(char[] c, int off, int len) throws SAXException {
        if (this.interrupted || len < 1) {
            return;
        }
        this.ctx.appendChild(this.createText(c, off, len));
    }

    protected Text createText(char[] c, int off, int len) throws SAXException {
        Text text = this.inCDATA && !this.coalescing ? this.doc.createCDATASection(new String(c, off, len)) : this.doc.createTextNode(new String(c, off, len));
        return text;
    }

    public void ignorableWhitespace(char[] c, int off, int len) throws SAXException {
        if (this.interrupted) {
            return;
        }
        if (!this.ignoreWhitespace) {
            this.characters(c, off, len);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.interrupted) {
            return;
        }
        Node pi = this.createProcessingInstruction(target, data);
        this.ctx.appendChild(pi);
    }

    protected Node createProcessingInstruction(String target, String data) {
        return this.doc.createProcessingInstruction(target, data);
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (this.interrupted) {
            return;
        }
        Node doctype = this.createDocumentType(name, publicId, systemId);
        this.doc.appendChild(doctype);
        this.ctx = doctype;
        this.inDTD = true;
    }

    protected Node createDocumentType(String name, String publicId, String systemId) {
        return new DomDoctype(this.doc, name, publicId, systemId);
    }

    public void endDTD() throws SAXException {
        if (this.interrupted) {
            return;
        }
        this.inDTD = false;
        this.ctx = this.ctx.getParentNode();
    }

    public void startEntity(String name) throws SAXException {
        if (this.interrupted) {
            return;
        }
        DocumentType doctype = this.doc.getDoctype();
        if (doctype == null) {
            throw new SAXException("SAX parser error: reference to entity in undeclared doctype");
        }
        if ("[dtd]".equals(name) || name.charAt(0) == '%') {
            return;
        }
        if (PREDEFINED_ENTITIES.contains(name)) {
            return;
        }
        NamedNodeMap entities = doctype.getEntities();
        Entity entity = (Entity)entities.getNamedItem(name);
        if (entity == null) {
            throw new SAXException("SAX parser error: reference to undeclared entity: " + name);
        }
        EntityReference ref = this.doc.createEntityReference(name);
        Node child = ref.getFirstChild();
        while (child != null) {
            Node nextChild = child.getNextSibling();
            ref.removeChild(child);
            child = nextChild;
        }
        this.ctx.appendChild(ref);
        this.ctx = ref;
    }

    public void endEntity(String name) throws SAXException {
        if (this.interrupted) {
            return;
        }
        if ("[dtd]".equals(name) || name.charAt(0) == '%') {
            return;
        }
        if (PREDEFINED_ENTITIES.contains(name)) {
            return;
        }
        EntityReference ref = (EntityReference)this.ctx;
        if (!ref.getNodeName().equals(name)) {
            throw new SAXException("expecting end of " + ref.getNodeName() + " entity");
        }
        this.ctx = this.ctx.getParentNode();
        if (ref instanceof DomNode) {
            ((DomNode)((Object)ref)).makeReadonly();
        }
        if (this.expandEntityReferences) {
            Node child = ref.getFirstChild();
            while (child != null) {
                Node nextChild = child.getNextSibling();
                this.ctx.appendChild(child);
                child = nextChild;
            }
            this.ctx.removeChild(ref);
        }
    }

    public void startCDATA() throws SAXException {
        this.inCDATA = true;
    }

    public void endCDATA() throws SAXException {
        this.inCDATA = false;
    }

    public void comment(char[] c, int off, int len) throws SAXException {
        if (this.interrupted) {
            return;
        }
        Node comment = this.createComment(c, off, len);
        this.ctx.appendChild(comment);
    }

    protected Node createComment(char[] c, int off, int len) {
        return this.doc.createComment(new String(c, off, len));
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        if (this.interrupted) {
            return;
        }
        if (!this.inDTD) {
            throw new SAXException("notation decl outside DTD");
        }
        DomDoctype doctype = (DomDoctype)this.ctx;
        doctype.declareNotation(name, publicId, systemId);
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        if (this.interrupted) {
            return;
        }
        if (!this.inDTD) {
            throw new SAXException("unparsed entity decl outside DTD");
        }
        DomDoctype doctype = (DomDoctype)this.ctx;
        doctype.declareEntity(name, publicId, systemId, notationName);
    }

    public void elementDecl(String name, String model) throws SAXException {
        if (this.interrupted) {
            return;
        }
        if (!this.inDTD) {
            throw new SAXException("element decl outside DTD");
        }
        if (!(this.ctx instanceof DomDoctype)) {
            return;
        }
        DomDoctype doctype = (DomDoctype)this.ctx;
        doctype.elementDecl(name, model);
    }

    public void attributeDecl(String eName, String aName, String type, String mode, String value) throws SAXException {
        if (this.interrupted) {
            return;
        }
        if (!this.inDTD) {
            throw new SAXException("attribute decl outside DTD");
        }
        DomDoctype doctype = (DomDoctype)this.ctx;
        doctype.attributeDecl(eName, aName, type, mode, value);
    }

    public void internalEntityDecl(String name, String value) throws SAXException {
        if (this.interrupted) {
            return;
        }
        if (!this.inDTD) {
            throw new SAXException("internal entity decl outside DTD");
        }
        DomDoctype doctype = (DomDoctype)this.ctx;
        Entity entity = doctype.declareEntity(name, null, null, null);
        if (entity != null) {
            Text text = this.doc.createTextNode(value);
            entity.appendChild(text);
        }
    }

    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        if (this.interrupted) {
            return;
        }
        if (!this.inDTD) {
            throw new SAXException("external entity decl outside DTD");
        }
        DomDoctype doctype = (DomDoctype)this.ctx;
        doctype.declareEntity(name, publicId, systemId, null);
    }
}

