/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.libxmlj.dom;

import gnu.xml.libxmlj.dom.GnomeAttr;
import gnu.xml.libxmlj.dom.GnomeCDATASection;
import gnu.xml.libxmlj.dom.GnomeComment;
import gnu.xml.libxmlj.dom.GnomeDOMException;
import gnu.xml.libxmlj.dom.GnomeDocument;
import gnu.xml.libxmlj.dom.GnomeDocumentFragment;
import gnu.xml.libxmlj.dom.GnomeDocumentType;
import gnu.xml.libxmlj.dom.GnomeElement;
import gnu.xml.libxmlj.dom.GnomeEntity;
import gnu.xml.libxmlj.dom.GnomeEntityReference;
import gnu.xml.libxmlj.dom.GnomeNamedNodeMap;
import gnu.xml.libxmlj.dom.GnomeNodeList;
import gnu.xml.libxmlj.dom.GnomeNotation;
import gnu.xml.libxmlj.dom.GnomeProcessingInstruction;
import gnu.xml.libxmlj.dom.GnomeText;
import gnu.xml.libxmlj.util.StandaloneDocumentType;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

class GnomeNode
implements Node,
Comparable {
    static Map instances;
    final Object id;
    Map userData;
    Map userDataHandlers;

    static GnomeNode newInstance(Object doc, Object node2, int type) {
        GnomeNode nodeInstance;
        HashMap<Object, GnomeNode> docNodes;
        if (doc == null) {
            throw new NullPointerException("doc");
        }
        if (node2 == null) {
            throw new NullPointerException("node");
        }
        if (instances == null) {
            instances = new HashMap();
        }
        if ((docNodes = (HashMap<Object, GnomeNode>)instances.get(doc)) == null) {
            docNodes = new HashMap<Object, GnomeNode>(1024);
            instances.put(doc, docNodes);
        }
        if ((nodeInstance = (GnomeNode)docNodes.get(node2)) != null) {
            return nodeInstance;
        }
        switch (type) {
            case 1: {
                nodeInstance = new GnomeElement(node2);
                break;
            }
            case 2: {
                nodeInstance = new GnomeAttr(node2);
                break;
            }
            case 3: {
                nodeInstance = new GnomeText(node2);
                break;
            }
            case 4: {
                nodeInstance = new GnomeCDATASection(node2);
                break;
            }
            case 5: {
                nodeInstance = new GnomeEntityReference(node2);
                break;
            }
            case 6: {
                nodeInstance = new GnomeEntity(node2);
                break;
            }
            case 7: {
                nodeInstance = new GnomeProcessingInstruction(node2);
                break;
            }
            case 8: {
                nodeInstance = new GnomeComment(node2);
                break;
            }
            case 9: {
                nodeInstance = new GnomeDocument(node2);
                break;
            }
            case 10: {
                nodeInstance = new GnomeDocumentType(node2);
                break;
            }
            case 11: {
                nodeInstance = new GnomeDocumentFragment(node2);
                break;
            }
            case 12: {
                nodeInstance = new GnomeNotation(node2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown node type: " + type);
            }
        }
        docNodes.put(node2, nodeInstance);
        return nodeInstance;
    }

    static void freeDocument(Object doc) {
        if (instances == null || doc == null) {
            return;
        }
        instances.remove(doc);
    }

    GnomeNode(Object id) {
        this.id = id;
    }

    public native String getNodeName();

    public native String getNodeValue() throws DOMException;

    public native void setNodeValue(String var1) throws DOMException;

    public native short getNodeType();

    public native Node getParentNode();

    public NodeList getChildNodes() {
        return new GnomeNodeList(this.id);
    }

    public native Node getFirstChild();

    public native Node getLastChild();

    public native Node getPreviousSibling();

    public native Node getNextSibling();

    public NamedNodeMap getAttributes() {
        return new GnomeNamedNodeMap(this.id, 0);
    }

    public native Document getOwnerDocument();

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        if (newChild instanceof StandaloneDocumentType) {
            DocumentType dt = (DocumentType)newChild;
            newChild = ((GnomeDocument)this.getOwnerDocument()).createDocumentType(dt.getName(), dt.getPublicId(), dt.getSystemId());
        }
        if (newChild == null) {
            throw new GnomeDOMException(8, null);
        }
        if (!(newChild instanceof GnomeNode)) {
            throw new GnomeDOMException(4, null);
        }
        if (refChild == null || !(refChild instanceof GnomeNode)) {
            throw new GnomeDOMException(8, null);
        }
        return this.xmljInsertBefore(newChild, refChild);
    }

    private native Node xmljInsertBefore(Node var1, Node var2) throws DOMException;

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        if (newChild instanceof StandaloneDocumentType) {
            DocumentType dt = (DocumentType)newChild;
            newChild = ((GnomeDocument)this.getOwnerDocument()).createDocumentType(dt.getName(), dt.getPublicId(), dt.getSystemId());
        }
        if (newChild == null) {
            throw new GnomeDOMException(8, null);
        }
        if (!(newChild instanceof GnomeNode)) {
            throw new GnomeDOMException(4, newChild.toString());
        }
        if (oldChild == null || !(oldChild instanceof GnomeNode)) {
            throw new GnomeDOMException(8, null);
        }
        return this.xmljReplaceChild(newChild, oldChild);
    }

    private native Node xmljReplaceChild(Node var1, Node var2) throws DOMException;

    public Node removeChild(Node oldChild) throws DOMException {
        if (!(oldChild instanceof GnomeNode)) {
            throw new GnomeDOMException(4, null);
        }
        return this.xmljRemoveChild(oldChild);
    }

    private native Node xmljRemoveChild(Node var1) throws DOMException;

    public Node appendChild(Node newChild) throws DOMException {
        if (newChild instanceof StandaloneDocumentType) {
            DocumentType dt = (DocumentType)newChild;
            newChild = ((GnomeDocument)this.getOwnerDocument()).createDocumentType(dt.getName(), dt.getPublicId(), dt.getSystemId());
        }
        if (!(newChild instanceof GnomeNode)) {
            throw new GnomeDOMException(4, null);
        }
        return this.xmljAppendChild(newChild);
    }

    private native Node xmljAppendChild(Node var1) throws DOMException;

    public native boolean hasChildNodes();

    public Node cloneNode(boolean deep) {
        Node ret = this.xmljCloneNode(deep);
        this.notifyUserDataHandlers((short)1, this, ret);
        return ret;
    }

    private native Node xmljCloneNode(boolean var1);

    public native void normalize();

    public boolean isSupported(String feature, String version) {
        return this.getOwnerDocument().getImplementation().hasFeature(feature, version);
    }

    public native String getNamespaceURI();

    public native String getPrefix();

    public native void setPrefix(String var1) throws DOMException;

    public native String getLocalName();

    public native boolean hasAttributes();

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        return other instanceof GnomeNode && ((GnomeNode)other).id == this.id;
    }

    public native String getBaseURI();

    public short compareDocumentPosition(Node other) throws DOMException {
        return (short)this.compareTo(other);
    }

    public final int compareTo(Object other) {
        if (other instanceof GnomeNode) {
            return this.xmljCompareTo(other);
        }
        return 0;
    }

    private native int xmljCompareTo(Object var1);

    public String getTextContent() throws DOMException {
        switch (this.getNodeType()) {
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 11: {
                StringBuffer buffer = new StringBuffer();
                NodeList children = this.getChildNodes();
                int len = children.getLength();
                int i = 0;
                while (i < len) {
                    Node child = children.item(i);
                    String textContent = child.getTextContent();
                    if (textContent != null) {
                        buffer.append(textContent);
                    }
                    ++i;
                }
                return buffer.toString();
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                return this.getNodeValue();
            }
        }
        return null;
    }

    public void setTextContent(String textContent) throws DOMException {
        switch (this.getNodeType()) {
            case 5: {
                throw new GnomeDOMException(7, null);
            }
            case 1: 
            case 2: 
            case 6: 
            case 11: {
                NodeList children = this.getChildNodes();
                int len = children.getLength();
                int i = 0;
                while (i < len) {
                    Node child = children.item(i);
                    this.removeChild(child);
                    ++i;
                }
                if (textContent == null) break;
                Text text = this.getOwnerDocument().createTextNode(textContent);
                this.appendChild(text);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                this.setNodeValue(textContent);
            }
        }
    }

    public boolean isSameNode(Node other) {
        return this.equals(other);
    }

    public native String lookupPrefix(String var1);

    public native boolean isDefaultNamespace(String var1);

    public native String lookupNamespaceURI(String var1);

    public native boolean isEqualNode(Node var1);

    public Object getFeature(String feature, String version) {
        return this.getOwnerDocument().getImplementation().getFeature(feature, version);
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        if (this.userData == null) {
            this.userData = new HashMap();
        }
        if (handler != null) {
            if (this.userDataHandlers == null) {
                this.userDataHandlers = new HashMap();
            }
            this.userDataHandlers.put(key, handler);
        }
        return this.userData.put(key, data);
    }

    public Object getUserData(String key) {
        if (this.userData == null) {
            return null;
        }
        return this.userData.get(key);
    }

    void notifyUserDataHandlers(short op, Node src, Node dst) {
        if (this.userDataHandlers != null) {
            for (Map.Entry entry : this.userDataHandlers.entrySet()) {
                String key = (String)entry.getKey();
                UserDataHandler handler = (UserDataHandler)entry.getValue();
                Object data = this.userData.get(key);
                handler.handle(op, key, data, src, dst);
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.getClass().getName());
        buffer.append("[nodeName=");
        buffer.append(this.getNodeName());
        buffer.append("]");
        return buffer.toString();
    }
}

