/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.transform.AbstractNumberNode;
import gnu.xml.transform.ApplyImportsNode;
import gnu.xml.transform.ApplyTemplatesNode;
import gnu.xml.transform.AttributeNode;
import gnu.xml.transform.AttributeSet;
import gnu.xml.transform.Bindings;
import gnu.xml.transform.CallTemplateNode;
import gnu.xml.transform.ChooseNode;
import gnu.xml.transform.CommentNode;
import gnu.xml.transform.CopyNode;
import gnu.xml.transform.CopyOfNode;
import gnu.xml.transform.CurrentFunction;
import gnu.xml.transform.DOMSourceLocator;
import gnu.xml.transform.DocumentFunction;
import gnu.xml.transform.ElementAvailableFunction;
import gnu.xml.transform.ElementNode;
import gnu.xml.transform.ForEachNode;
import gnu.xml.transform.FormatNumberFunction;
import gnu.xml.transform.FunctionAvailableFunction;
import gnu.xml.transform.GenerateIdFunction;
import gnu.xml.transform.IfNode;
import gnu.xml.transform.Key;
import gnu.xml.transform.KeyFunction;
import gnu.xml.transform.LiteralNode;
import gnu.xml.transform.MessageNode;
import gnu.xml.transform.NamespaceProxy;
import gnu.xml.transform.NodeNumberNode;
import gnu.xml.transform.NumberNode;
import gnu.xml.transform.OtherwiseNode;
import gnu.xml.transform.ParameterNode;
import gnu.xml.transform.ProcessingInstructionNode;
import gnu.xml.transform.SortKey;
import gnu.xml.transform.StrippingInstruction;
import gnu.xml.transform.SystemPropertyFunction;
import gnu.xml.transform.Template;
import gnu.xml.transform.TemplateNode;
import gnu.xml.transform.TextNode;
import gnu.xml.transform.TransformerFactoryImpl;
import gnu.xml.transform.TransformerImpl;
import gnu.xml.transform.UnparsedEntityUriFunction;
import gnu.xml.transform.ValueOfNode;
import gnu.xml.transform.WhenNode;
import gnu.xml.transform.WithParam;
import gnu.xml.transform.XSLURIResolver;
import gnu.xml.xpath.Expr;
import gnu.xml.xpath.NameTest;
import gnu.xml.xpath.NodeTypeTest;
import gnu.xml.xpath.Pattern;
import gnu.xml.xpath.Root;
import gnu.xml.xpath.Selector;
import gnu.xml.xpath.XPathImpl;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionResolver;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

class Stylesheet
implements NamespaceContext,
XPathFunctionResolver,
UserDataHandler,
Cloneable {
    static final String XSL_NS = "http://www.w3.org/1999/XSL/Transform";
    private static final NameTest STYLESHEET_PRESERVE_TEXT = new NameTest(new QName("http://www.w3.org/1999/XSL/Transform", "text"), false, false);
    static final int OUTPUT_XML = 0;
    static final int OUTPUT_HTML = 1;
    static final int OUTPUT_TEXT = 2;
    final TransformerFactoryImpl factory;
    TransformerImpl transformer;
    Stylesheet parent;
    final XPathImpl xpath;
    final String systemId;
    final int precedence;
    final boolean debug;
    String version;
    Collection extensionElementPrefixes;
    Collection excludeResultPrefixes;
    Set stripSpace;
    Set preserveSpace;
    Node output;
    int outputMethod;
    String outputVersion;
    String outputEncoding;
    boolean outputOmitXmlDeclaration;
    boolean outputStandalone;
    String outputPublicId;
    String outputSystemId;
    Collection outputCdataSectionElements;
    boolean outputIndent;
    String outputMediaType;
    Collection keys;
    Map decimalFormats;
    Map namespaceAliases;
    List attributeSets;
    List variables;
    Bindings bindings;
    LinkedList templates;
    TemplateNode builtInNodeTemplate;
    TemplateNode builtInTextTemplate;
    Node current;
    transient boolean terminated;
    transient Template currentTemplate;

    Stylesheet(TransformerFactoryImpl factory, Stylesheet parent, Document doc, String systemId, int precedence) throws TransformerConfigurationException {
        this.factory = factory;
        this.systemId = systemId;
        this.precedence = precedence;
        this.parent = parent;
        this.extensionElementPrefixes = new HashSet();
        this.excludeResultPrefixes = new HashSet();
        this.stripSpace = new LinkedHashSet();
        this.preserveSpace = new LinkedHashSet();
        this.outputCdataSectionElements = new LinkedHashSet();
        this.xpath = (XPathImpl)factory.xpathFactory.newXPath();
        this.xpath.setNamespaceContext(this);
        if (parent == null) {
            this.bindings = new Bindings(this);
            this.attributeSets = new LinkedList();
            this.variables = new LinkedList();
            this.namespaceAliases = new LinkedHashMap();
            this.templates = new LinkedList();
            this.keys = new LinkedList();
            this.decimalFormats = new LinkedHashMap();
            this.initDefaultDecimalFormat();
            this.xpath.setXPathFunctionResolver(this);
        } else {
            Stylesheet ctx = this;
            while (ctx.parent != null) {
                if (systemId != null && systemId.equals(ctx.parent.systemId)) {
                    String msg = "circularity importing " + systemId;
                    throw new TransformerConfigurationException(msg);
                }
                ctx = ctx.parent;
            }
            Stylesheet root = this.getRootStylesheet();
            this.bindings = root.bindings;
            this.attributeSets = root.attributeSets;
            this.variables = root.variables;
            this.namespaceAliases = root.namespaceAliases;
            this.templates = root.templates;
            this.keys = root.keys;
            this.decimalFormats = root.decimalFormats;
            this.xpath.setXPathFunctionResolver(root);
        }
        this.xpath.setXPathVariableResolver(this.bindings);
        NodeTypeTest anyNode = new NodeTypeTest(0);
        List<NodeTypeTest> tests = Collections.singletonList(anyNode);
        this.builtInNodeTemplate = new ApplyTemplatesNode(new Selector(3, tests), null, null, null, true);
        this.builtInTextTemplate = new ValueOfNode(new Selector(12, tests), false);
        this.parse(doc.getDocumentElement(), true);
        this.current = doc;
        this.debug = "yes".equals(System.getProperty("xsl.debug"));
        if (this.debug) {
            System.err.println("Stylesheet: " + doc.getDocumentURI());
            for (Template t : this.templates) {
                t.list(System.err);
                System.err.println("--------------------");
            }
        }
    }

    Stylesheet getRootStylesheet() {
        Stylesheet stylesheet = this;
        while (stylesheet.parent != null) {
            stylesheet = stylesheet.parent;
        }
        return stylesheet;
    }

    void initDefaultDecimalFormat() {
        DecimalFormat defaultDecimalFormat = new DecimalFormat();
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        symbols.setGroupingSeparator(',');
        symbols.setPercent('%');
        symbols.setPerMill('\u2030');
        symbols.setZeroDigit('0');
        symbols.setDigit('#');
        symbols.setPatternSeparator(';');
        symbols.setInfinity("Infinity");
        symbols.setNaN("NaN");
        symbols.setMinusSign('-');
        defaultDecimalFormat.setDecimalFormatSymbols(symbols);
        this.decimalFormats.put(null, defaultDecimalFormat);
    }

    public Object clone() {
        try {
            Stylesheet clone = (Stylesheet)super.clone();
            clone.bindings = (Bindings)this.bindings.clone();
            LinkedList<Template> templates2 = new LinkedList<Template>();
            for (Template t : this.templates) {
                templates2.add(t.clone(clone));
            }
            clone.templates = templates2;
            LinkedList<AttributeSet> attributeSets2 = new LinkedList<AttributeSet>();
            for (AttributeSet as : this.attributeSets) {
                attributeSets2.add(as.clone(clone));
            }
            clone.attributeSets = attributeSets2;
            LinkedList<TemplateNode> variables2 = new LinkedList<TemplateNode>();
            for (ParameterNode var : this.variables) {
                variables2.add(var.clone(clone));
            }
            clone.variables = variables2;
            LinkedList<Key> keys2 = new LinkedList<Key>();
            for (Key k : this.keys) {
                keys2.add(k.clone(clone));
            }
            clone.keys = keys2;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e.getMessage());
        }
    }

    void initTopLevelVariables(Node context) throws TransformerException {
        this.current = context;
        ArrayList topLevel = new ArrayList(this.variables);
        Collections.sort(topLevel);
        for (ParameterNode var : topLevel) {
            this.bindings.set(var.name, var.getValue(this, null, context, 1, 1), var.type);
        }
        this.current = null;
    }

    public String getNamespaceURI(String prefix) {
        return this.current == null ? null : this.current.lookupNamespaceURI(prefix);
    }

    public String getPrefix(String namespaceURI) {
        return this.current == null ? null : this.current.lookupPrefix(namespaceURI);
    }

    public Iterator getPrefixes(String namespaceURI) {
        return Collections.singleton(this.getPrefix(namespaceURI)).iterator();
    }

    final QName getQName(String name) {
        String localName = name;
        String uri = null;
        String prefix = null;
        int ci = name.indexOf(58);
        if (ci != -1) {
            prefix = name.substring(0, ci);
            localName = name.substring(ci + 1);
            uri = this.getNamespaceURI(prefix);
        }
        return new QName(uri, localName, prefix);
    }

    TemplateNode getTemplate(QName mode, Node context, boolean applyImports) throws TransformerException {
        if (this.debug) {
            System.err.println("getTemplate: mode=" + mode + " context=" + context);
        }
        Template selected = null;
        for (Template t : this.templates) {
            boolean isMatch = t.matches(mode, context);
            if (applyImports) {
                if (this.currentTemplate == null) {
                    String msg = "current template may not be null during apply-imports";
                    throw new TransformerException(msg);
                }
                if (!this.currentTemplate.imports(t)) {
                    isMatch = false;
                }
            }
            if (!isMatch) continue;
            if (selected == null) {
                selected = t;
                continue;
            }
            if (t.precedence < selected.precedence || t.priority < selected.priority) continue;
            selected = t;
        }
        if (selected == null) {
            if (this.debug) {
                System.err.println("\tbuiltInTemplate context=" + context);
            }
            switch (context.getNodeType()) {
                case 1: 
                case 7: 
                case 8: 
                case 9: 
                case 11: {
                    return this.builtInNodeTemplate;
                }
                case 2: 
                case 3: 
                case 4: {
                    return this.builtInTextTemplate;
                }
            }
            return null;
        }
        this.currentTemplate = selected;
        if (this.debug) {
            System.err.println("\ttemplate=" + this.currentTemplate + " context=" + context);
        }
        return this.currentTemplate.node;
    }

    TemplateNode getTemplate(QName mode, QName name) throws TransformerException {
        Template selected = null;
        for (Template t : this.templates) {
            boolean isMatch = t.matches(name);
            if (!isMatch) continue;
            if (selected == null) {
                selected = t;
                continue;
            }
            if (t.precedence < selected.precedence || t.priority < selected.priority) continue;
            selected = t;
        }
        if (selected == null) {
            return null;
        }
        return selected.node;
    }

    final Template parseTemplate(Node node2, NamedNodeMap attrs) throws TransformerConfigurationException, XPathExpressionException {
        String n = Stylesheet.getAttribute(attrs, "name");
        QName name = n == null ? null : this.getQName(n);
        String m = Stylesheet.getAttribute(attrs, "match");
        Pattern match = null;
        if (m != null) {
            try {
                match = (Pattern)this.xpath.compile(m);
            }
            catch (ClassCastException classCastException) {
                String msg = "illegal pattern: " + m;
                throw new TransformerConfigurationException(msg);
            }
        }
        String p = Stylesheet.getAttribute(attrs, "priority");
        String mm = Stylesheet.getAttribute(attrs, "mode");
        QName mode = mm == null ? null : this.getQName(mm);
        Node children = node2.getFirstChild();
        return new Template(this, name, match, this.parse(children), this.precedence, p, mode);
    }

    final void parseOutput(Node node2, NamedNodeMap attrs) throws TransformerConfigurationException {
        String standalone;
        this.output = node2;
        String method = Stylesheet.getAttribute(attrs, "method");
        if ("xml".equals(method) || method == null) {
            this.outputMethod = 0;
        } else if ("html".equals(method)) {
            this.outputMethod = 1;
        } else if ("text".equals(method)) {
            this.outputMethod = 2;
        } else {
            String msg = "unsupported output method: " + method;
            DOMSourceLocator l = new DOMSourceLocator(node2);
            throw new TransformerConfigurationException(msg, l);
        }
        this.outputPublicId = Stylesheet.getAttribute(attrs, "doctype-public");
        this.outputSystemId = Stylesheet.getAttribute(attrs, "doctype-system");
        this.outputEncoding = Stylesheet.getAttribute(attrs, "encoding");
        String indent = Stylesheet.getAttribute(attrs, "indent");
        if (indent != null) {
            this.outputIndent = "yes".equals(indent);
        }
        this.outputVersion = Stylesheet.getAttribute(attrs, "version");
        String omitXmlDecl = Stylesheet.getAttribute(attrs, "omit-xml-declaration");
        if (omitXmlDecl != null) {
            this.outputOmitXmlDeclaration = "yes".equals(omitXmlDecl);
        }
        if ((standalone = Stylesheet.getAttribute(attrs, "standalone")) != null) {
            this.outputStandalone = "yes".equals(standalone);
        }
        this.outputMediaType = Stylesheet.getAttribute(attrs, "media-type");
        String cdataSectionElements = Stylesheet.getAttribute(attrs, "cdata-section-elements");
        if (cdataSectionElements != null) {
            StringTokenizer st = new StringTokenizer(cdataSectionElements, " ");
            while (st.hasMoreTokens()) {
                this.outputCdataSectionElements.add(st.nextToken());
            }
        }
    }

    final void parseKey(Node node2, NamedNodeMap attrs) throws TransformerConfigurationException, XPathExpressionException {
        String n = Stylesheet.getRequiredAttribute(attrs, "name", node2);
        String m = Stylesheet.getRequiredAttribute(attrs, "match", node2);
        String u = Stylesheet.getRequiredAttribute(attrs, "use", node2);
        QName name = this.getQName(n);
        Expr use = (Expr)this.xpath.compile(u);
        try {
            Pattern match = (Pattern)this.xpath.compile(m);
            Key key = new Key(name, match, use);
            this.keys.add(key);
        }
        catch (ClassCastException classCastException) {
            throw new TransformerConfigurationException("invalid pattern: " + m);
        }
    }

    final void parseDecimalFormat(Node node2, NamedNodeMap attrs) throws TransformerConfigurationException {
        String dfName = Stylesheet.getAttribute(attrs, "name");
        DecimalFormat df = new DecimalFormat();
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator(this.parseDFChar(attrs, "decimal-separator", '.'));
        symbols.setGroupingSeparator(this.parseDFChar(attrs, "grouping-separator", ','));
        symbols.setInfinity(this.parseDFString(attrs, "infinity", "Infinity"));
        symbols.setMinusSign(this.parseDFChar(attrs, "minus-sign", '-'));
        symbols.setNaN(this.parseDFString(attrs, "NaN", "NaN"));
        symbols.setPercent(this.parseDFChar(attrs, "percent", '%'));
        symbols.setPerMill(this.parseDFChar(attrs, "per-mille", '\u2030'));
        symbols.setZeroDigit(this.parseDFChar(attrs, "zero-digit", '0'));
        symbols.setDigit(this.parseDFChar(attrs, "digit", '#'));
        symbols.setPatternSeparator(this.parseDFChar(attrs, "pattern-separator", ';'));
        df.setDecimalFormatSymbols(symbols);
        this.decimalFormats.put(dfName, df);
    }

    private final char parseDFChar(NamedNodeMap attrs, String name, char def) throws TransformerConfigurationException {
        Node attr = attrs.getNamedItem(name);
        try {
            return attr == null ? def : attr.getNodeValue().charAt(0);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new TransformerConfigurationException("empty attribute '" + name + "' in decimal-format", e);
        }
    }

    private final String parseDFString(NamedNodeMap attrs, String name, String def) {
        Node attr = attrs.getNamedItem(name);
        return attr == null ? def : attr.getNodeValue();
    }

    final void parseNamespaceAlias(Node node2, NamedNodeMap attrs) throws TransformerConfigurationException {
        String sp = Stylesheet.getRequiredAttribute(attrs, "stylesheet-prefix", node2);
        String rp = Stylesheet.getRequiredAttribute(attrs, "result-prefix", node2);
        this.namespaceAliases.put(sp, rp);
    }

    final void parseAttributeSet(Node node2, NamedNodeMap attrs) throws TransformerConfigurationException, XPathExpressionException {
        TemplateNode children = this.parse(node2.getFirstChild());
        String name = Stylesheet.getRequiredAttribute(attrs, "name", node2);
        String uas = Stylesheet.getAttribute(attrs, "use-attribute-sets");
        this.attributeSets.add(new AttributeSet(children, name, uas));
    }

    void parse(Node node2, boolean root) throws TransformerConfigurationException {
        while (node2 != null) {
            this.current = node2;
            this.doParse(node2, root);
            node2 = node2.getNextSibling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doParse(Node node2, boolean root) throws TransformerConfigurationException {
        block37: {
            try {
                String namespaceUri = node2.getNamespaceURI();
                if (XSL_NS.equals(namespaceUri) && node2.getNodeType() == 1) {
                    String name = node2.getLocalName();
                    NamedNodeMap attrs = node2.getAttributes();
                    if ("stylesheet".equals(name)) {
                        String erp;
                        this.version = Stylesheet.getAttribute(attrs, "version");
                        String eep = Stylesheet.getAttribute(attrs, "extension-element-prefixes");
                        if (eep != null) {
                            StringTokenizer st = new StringTokenizer(eep);
                            while (st.hasMoreTokens()) {
                                this.extensionElementPrefixes.add(st.nextToken());
                            }
                        }
                        if ((erp = Stylesheet.getAttribute(attrs, "exclude-result-prefixes")) != null) {
                            StringTokenizer st = new StringTokenizer(erp);
                            while (st.hasMoreTokens()) {
                                this.excludeResultPrefixes.add(st.nextToken());
                            }
                        }
                        this.parse(node2.getFirstChild(), false);
                        break block37;
                    }
                    if ("template".equals(name)) {
                        this.templates.add(this.parseTemplate(node2, attrs));
                        break block37;
                    }
                    if ("param".equals(name) || "variable".equals(name)) {
                        ParameterNode param;
                        int type = "variable".equals(name) ? 0 : 1;
                        TemplateNode content = this.parse(node2.getFirstChild());
                        QName paramName = this.getQName(Stylesheet.getRequiredAttribute(attrs, "name", node2));
                        String select = Stylesheet.getAttribute(attrs, "select");
                        if (select != null && select.length() > 0) {
                            if (content != null) {
                                String msg = "parameter '" + paramName + "' has both select and content";
                                DOMSourceLocator l = new DOMSourceLocator(node2);
                                throw new TransformerConfigurationException(msg, l);
                            }
                            Expr expr = (Expr)this.xpath.compile(select);
                            param = new ParameterNode(paramName, expr, type);
                        } else {
                            param = new ParameterNode(paramName, null, type);
                            param.children = content;
                        }
                        this.variables.add(param);
                        break block37;
                    }
                    if ("include".equals(name) || "import".equals(name)) {
                        Source source;
                        int delta = "import".equals(name) ? -1 : 0;
                        String href = Stylesheet.getRequiredAttribute(attrs, "href", node2);
                        XSLURIResolver xSLURIResolver = this.factory.resolver;
                        synchronized (xSLURIResolver) {
                            if (this.transformer != null) {
                                this.factory.resolver.setUserResolver(this.transformer.getURIResolver());
                                this.factory.resolver.setUserListener(this.transformer.getErrorListener());
                            }
                            source = this.factory.resolver.resolve(this.systemId, href);
                        }
                        this.factory.newStylesheet(source, this.precedence + delta, this);
                        break block37;
                    }
                    if ("output".equals(name)) {
                        this.parseOutput(node2, attrs);
                    } else if ("preserve-space".equals(name)) {
                        String elements = Stylesheet.getRequiredAttribute(attrs, "elements", node2);
                        StringTokenizer st = new StringTokenizer(elements, " \t\n\r");
                        while (st.hasMoreTokens()) {
                            NameTest element = this.parseNameTest(st.nextToken());
                            this.preserveSpace.add(new StrippingInstruction(element, this.precedence));
                        }
                    } else if ("strip-space".equals(name)) {
                        String elements = Stylesheet.getRequiredAttribute(attrs, "elements", node2);
                        StringTokenizer st = new StringTokenizer(elements, " \t\n\r");
                        while (st.hasMoreTokens()) {
                            NameTest element = this.parseNameTest(st.nextToken());
                            this.stripSpace.add(new StrippingInstruction(element, this.precedence));
                        }
                    } else if ("key".equals(name)) {
                        this.parseKey(node2, attrs);
                    } else if ("decimal-format".equals(name)) {
                        this.parseDecimalFormat(node2, attrs);
                    } else if ("namespace-alias".equals(name)) {
                        this.parseNamespaceAlias(node2, attrs);
                    } else if ("attribute-set".equals(name)) {
                        this.parseAttributeSet(node2, attrs);
                    }
                    break block37;
                }
                if (root) {
                    Attr versionNode = ((Element)node2).getAttributeNodeNS(XSL_NS, "version");
                    if (versionNode == null) {
                        String msg = "no xsl:version attribute on literal result node";
                        DOMSourceLocator l = new DOMSourceLocator(node2);
                        throw new TransformerConfigurationException(msg, l);
                    }
                    this.version = versionNode.getValue();
                    Node rootClone = node2.cloneNode(true);
                    NamedNodeMap attrs = rootClone.getAttributes();
                    attrs.removeNamedItemNS(XSL_NS, "version");
                    this.templates.add(new Template(this, null, new Root(), this.parse(rootClone), this.precedence, null, null));
                }
            }
            catch (TransformerException e) {
                DOMSourceLocator l = new DOMSourceLocator(node2);
                throw new TransformerConfigurationException(e.getMessage(), l, e);
            }
            catch (DOMException e) {
                DOMSourceLocator l = new DOMSourceLocator(node2);
                throw new TransformerConfigurationException(e.getMessage(), l, e);
            }
            catch (XPathExpressionException e) {
                DOMSourceLocator l = new DOMSourceLocator(node2);
                throw new TransformerConfigurationException(e.getMessage(), l, e);
            }
        }
    }

    final NameTest parseNameTest(String token) {
        if ("*".equals(token)) {
            return new NameTest(null, true, true);
        }
        if (token.endsWith(":*")) {
            QName qName = this.getQName(token);
            return new NameTest(qName, true, false);
        }
        QName qName = this.getQName(token);
        return new NameTest(qName, false, false);
    }

    final TemplateNode parseAttributeValueTemplate(String value, Node source) throws TransformerConfigurationException, XPathExpressionException {
        this.current = source;
        int len = value.length();
        int off = 0;
        ArrayList<String> tokens = new ArrayList<String>();
        ArrayList<Boolean> types = new ArrayList<Boolean>();
        int depth = 0;
        int i = 0;
        while (i < len) {
            char c = value.charAt(i);
            if (c == '{') {
                if (i < len - 1 && value.charAt(i + 1) == '{') {
                    tokens.add(value.substring(off, i + 1));
                    types.add(Boolean.FALSE);
                    off = ++i + 1;
                } else {
                    if (depth == 0) {
                        if (i - off > 0) {
                            tokens.add(value.substring(off, i));
                            types.add(Boolean.FALSE);
                        }
                        off = i + 1;
                    }
                    ++depth;
                }
            } else if (c == '}') {
                if (i < len - 1 && value.charAt(i + 1) == '}') {
                    tokens.add(value.substring(off, i + 1));
                    types.add(Boolean.FALSE);
                    off = ++i + 1;
                } else {
                    if (depth == 1) {
                        if (i - off <= 0) {
                            String msg = "attribute value template must contain expression: " + value;
                            DOMSourceLocator l = new DOMSourceLocator(source);
                            throw new TransformerConfigurationException(msg, l);
                        }
                        tokens.add(value.substring(off, i));
                        types.add(Boolean.TRUE);
                        off = i + 1;
                    }
                    --depth;
                }
            }
            ++i;
        }
        if (depth > 0) {
            String msg = "invalid attribute value template: " + value;
            throw new TransformerConfigurationException(msg);
        }
        if (len - off > 0) {
            tokens.add(value.substring(off));
            types.add(Boolean.FALSE);
        }
        TemplateNode ret = null;
        Document doc = source.getOwnerDocument();
        len = tokens.size();
        int i2 = len - 1;
        while (i2 >= 0) {
            String token = (String)tokens.get(i2);
            Boolean type = (Boolean)types.get(i2);
            if (type == Boolean.TRUE) {
                Expr select = (Expr)this.xpath.compile(token);
                ValueOfNode ret2 = new ValueOfNode(select, false);
                ret2.next = ret;
                ret = ret2;
            } else {
                LiteralNode ret2 = new LiteralNode(doc.createTextNode(token));
                ret2.next = ret;
                ret = ret2;
            }
            --i2;
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    boolean isPreserved(Text text, boolean source) throws TransformerConfigurationException {
        block17: {
            value = text.getData();
            if (value != null) {
                len = value.length();
                i = 0;
                while (i < len) {
                    c = value.charAt(i);
                    if (c != ' ' && c != '\t' && c != '\n' && c != '\r') {
                        return true;
                    }
                    ++i;
                }
            }
            ctx = text.getParentNode();
            if (!source) break block17;
            preserve = true;
            psPriority = 0.0f;
            ssPriority = 0.0f;
            if (!this.stripSpace.isEmpty()) {
                ssi = null;
                psi = null;
                for (StrippingInstruction si : this.stripSpace) {
                    if (!si.element.matches(ctx, 1, 1) || ssi != null && (si.precedence < ssi.precedence || (p = si.getPriority()) < ssPriority)) continue;
                    ssi = si;
                }
                for (StrippingInstruction si : this.preserveSpace) {
                    if (!si.element.matches(ctx, 1, 1) || psi != null && (si.precedence < psi.precedence || (p = si.getPriority()) < psPriority)) continue;
                    psi = si;
                }
                if (ssi != null) {
                    if (psi != null) {
                        if (psi.precedence < ssi.precedence) {
                            preserve = false;
                        } else if (psPriority < ssPriority) {
                            preserve = false;
                        }
                    } else {
                        preserve = false;
                    }
                }
            }
            if (preserve) {
                return true;
            }
            ** GOTO lbl52
        }
        if (!Stylesheet.STYLESHEET_PRESERVE_TEXT.matches(ctx, 1, 1)) ** GOTO lbl52
        return true;
lbl-1000:
        // 1 sources

        {
            if (ctx.getNodeType() == 1) {
                element = (Element)ctx;
                xmlSpace = element.getAttribute("xml:space");
                if ("default".equals(xmlSpace)) break;
                if ("preserve".equals(xmlSpace)) {
                    return true;
                }
                if (xmlSpace.length() > 0) {
                    msg = "Illegal value for xml:space: " + xmlSpace;
                    throw new TransformerConfigurationException(msg);
                }
            }
            ctx = ctx.getParentNode();
lbl52:
            // 3 sources

            ** while (ctx != null)
        }
lbl53:
        // 2 sources

        return false;
    }

    public XPathFunction resolveFunction(QName name, int arity) {
        String uri = name.getNamespaceURI();
        if (XSL_NS.equals(uri) || uri == null || uri.length() == 0) {
            String localName = name.getLocalPart();
            if ("document".equals(localName) && (arity == 1 || arity == 2)) {
                if (this.current == null) {
                    throw new RuntimeException("current is null");
                }
                return new DocumentFunction(this.getRootStylesheet(), this.current);
            }
            if ("key".equals(localName) && arity == 2) {
                return new KeyFunction(this.getRootStylesheet());
            }
            if ("format-number".equals(localName) && (arity == 2 || arity == 3)) {
                return new FormatNumberFunction(this.getRootStylesheet());
            }
            if ("current".equals(localName) && arity == 0) {
                return new CurrentFunction(this.getRootStylesheet());
            }
            if ("unparsed-entity-uri".equals(localName) && arity == 1) {
                return new UnparsedEntityUriFunction();
            }
            if ("generate-id".equals(localName) && (arity == 1 || arity == 0)) {
                return new GenerateIdFunction();
            }
            if ("system-property".equals(localName) && arity == 1) {
                return new SystemPropertyFunction();
            }
            if ("element-available".equals(localName) && arity == 1) {
                return new ElementAvailableFunction(new NamespaceProxy(this.current));
            }
            if ("function-available".equals(localName) && arity == 1) {
                return new FunctionAvailableFunction(new NamespaceProxy(this.current));
            }
        }
        return null;
    }

    final TemplateNode parseApplyTemplates(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        NamedNodeMap attrs = node2.getAttributes();
        String m = Stylesheet.getAttribute(attrs, "mode");
        QName mode = m == null ? null : this.getQName(m);
        String s = Stylesheet.getAttribute(attrs, "select");
        if (s == null) {
            s = "child::node()";
        }
        Node children = node2.getFirstChild();
        List sortKeys = this.parseSortKeys(children);
        List withParams = this.parseWithParams(children);
        Expr select = (Expr)this.xpath.compile(s);
        return new ApplyTemplatesNode(select, mode, sortKeys, withParams, false);
    }

    final TemplateNode parseCallTemplate(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        NamedNodeMap attrs = node2.getAttributes();
        String n = Stylesheet.getRequiredAttribute(attrs, "name", node2);
        QName name = this.getQName(n);
        Node children = node2.getFirstChild();
        List withParams = this.parseWithParams(children);
        return new CallTemplateNode(name, withParams);
    }

    final TemplateNode parseValueOf(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        NamedNodeMap attrs = node2.getAttributes();
        String s = Stylesheet.getRequiredAttribute(attrs, "select", node2);
        String doe = Stylesheet.getAttribute(attrs, "disable-output-escaping");
        boolean d = "yes".equals(doe);
        Expr select = (Expr)this.xpath.compile(s);
        return new ValueOfNode(select, d);
    }

    final TemplateNode parseForEach(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        NamedNodeMap attrs = node2.getAttributes();
        String s = Stylesheet.getRequiredAttribute(attrs, "select", node2);
        Node children = node2.getFirstChild();
        List sortKeys = this.parseSortKeys(children);
        Expr select = (Expr)this.xpath.compile(s);
        ForEachNode ret = new ForEachNode(select, sortKeys);
        ret.children = this.parse(children);
        return ret;
    }

    final TemplateNode parseIf(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        NamedNodeMap attrs = node2.getAttributes();
        String t = Stylesheet.getRequiredAttribute(attrs, "test", node2);
        Expr test = (Expr)this.xpath.compile(t);
        Node children = node2.getFirstChild();
        IfNode ret = new IfNode(test);
        ret.children = this.parse(children);
        return ret;
    }

    final TemplateNode parseWhen(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        NamedNodeMap attrs = node2.getAttributes();
        String t = Stylesheet.getRequiredAttribute(attrs, "test", node2);
        Expr test = (Expr)this.xpath.compile(t);
        Node children = node2.getFirstChild();
        WhenNode ret = new WhenNode(test);
        ret.children = this.parse(children);
        return ret;
    }

    final TemplateNode parseElement(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        NamedNodeMap attrs = node2.getAttributes();
        String name = Stylesheet.getRequiredAttribute(attrs, "name", node2);
        String namespace = Stylesheet.getAttribute(attrs, "namespace");
        String uas = Stylesheet.getAttribute(attrs, "use-attribute-sets");
        TemplateNode n = this.parseAttributeValueTemplate(name, node2);
        TemplateNode ns = namespace == null ? null : this.parseAttributeValueTemplate(namespace, node2);
        Node children = node2.getFirstChild();
        ElementNode ret = new ElementNode(n, ns, uas, node2);
        ret.children = this.parse(children);
        return ret;
    }

    final TemplateNode parseAttribute(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        NamedNodeMap attrs = node2.getAttributes();
        String name = Stylesheet.getRequiredAttribute(attrs, "name", node2);
        String namespace = Stylesheet.getAttribute(attrs, "namespace");
        TemplateNode n = this.parseAttributeValueTemplate(name, node2);
        TemplateNode ns = namespace == null ? null : this.parseAttributeValueTemplate(namespace, node2);
        Node children = node2.getFirstChild();
        AttributeNode ret = new AttributeNode(n, ns, node2);
        ret.children = this.parse(children);
        return ret;
    }

    final TemplateNode parseText(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        NamedNodeMap attrs = node2.getAttributes();
        String doe = Stylesheet.getAttribute(attrs, "disable-output-escaping");
        boolean d = "yes".equals(doe);
        Node children = node2.getFirstChild();
        TextNode ret = new TextNode(d);
        ret.children = this.parse(children);
        return ret;
    }

    final TemplateNode parseCopy(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        NamedNodeMap attrs = node2.getAttributes();
        String uas = Stylesheet.getAttribute(attrs, "use-attribute-sets");
        Node children = node2.getFirstChild();
        CopyNode ret = new CopyNode(uas);
        ret.children = this.parse(children);
        return ret;
    }

    final TemplateNode parseProcessingInstruction(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        NamedNodeMap attrs = node2.getAttributes();
        String name = Stylesheet.getRequiredAttribute(attrs, "name", node2);
        Node children = node2.getFirstChild();
        ProcessingInstructionNode ret = new ProcessingInstructionNode(name);
        ret.children = this.parse(children);
        return ret;
    }

    final TemplateNode parseNumber(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        AbstractNumberNode ret;
        NamedNodeMap attrs = node2.getAttributes();
        String v = Stylesheet.getAttribute(attrs, "value");
        String ff = Stylesheet.getAttribute(attrs, "format");
        if (ff == null) {
            ff = "1";
        }
        TemplateNode format = this.parseAttributeValueTemplate(ff, node2);
        String lang = Stylesheet.getAttribute(attrs, "lang");
        String lv = Stylesheet.getAttribute(attrs, "letter-value");
        int letterValue = "traditional".equals(lv) ? 1 : 0;
        String gs = Stylesheet.getAttribute(attrs, "grouping-separator");
        String gz = Stylesheet.getAttribute(attrs, "grouping-size");
        int gz2 = gz != null && gz.length() > 0 ? Integer.parseInt(gz) : 1;
        Node children = node2.getFirstChild();
        if (v != null && v.length() > 0) {
            Expr value = (Expr)this.xpath.compile(v);
            ret = new NumberNode(value, format, lang, letterValue, gs, gz2);
        } else {
            String l = Stylesheet.getAttribute(attrs, "level");
            int level = "multiple".equals(l) ? 1 : ("any".equals(l) ? 2 : 0);
            String c = Stylesheet.getAttribute(attrs, "count");
            String f = Stylesheet.getAttribute(attrs, "from");
            Pattern count = null;
            Pattern from = null;
            if (c != null) {
                try {
                    count = (Pattern)this.xpath.compile(c);
                }
                catch (ClassCastException classCastException) {
                    String msg = "invalid pattern: " + c;
                    throw new TransformerConfigurationException(msg);
                }
            }
            if (f != null) {
                try {
                    from = (Pattern)this.xpath.compile(f);
                }
                catch (ClassCastException classCastException) {
                    String msg = "invalid pattern: " + f;
                    throw new TransformerConfigurationException(msg);
                }
            }
            ret = new NodeNumberNode(level, count, from, format, lang, letterValue, gs, gz2);
        }
        ret.children = this.parse(children);
        return ret;
    }

    final TemplateNode parseCopyOf(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        NamedNodeMap attrs = node2.getAttributes();
        String s = Stylesheet.getRequiredAttribute(attrs, "select", node2);
        Expr select = (Expr)this.xpath.compile(s);
        Node children = node2.getFirstChild();
        CopyOfNode ret = new CopyOfNode(select);
        ret.children = this.parse(children);
        return ret;
    }

    final TemplateNode parseMessage(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        NamedNodeMap attrs = node2.getAttributes();
        String t = Stylesheet.getAttribute(attrs, "terminate");
        boolean terminate = "yes".equals(t);
        Node children = node2.getFirstChild();
        MessageNode ret = new MessageNode(terminate);
        ret.children = this.parse(children);
        return ret;
    }

    final TemplateNode parse(Node node2) throws TransformerConfigurationException {
        TemplateNode first = null;
        TemplateNode previous = null;
        while (node2 != null) {
            Node next = node2.getNextSibling();
            TemplateNode tnode = this.doParse(node2);
            if (tnode != null) {
                if (first == null) {
                    first = tnode;
                }
                if (previous != null) {
                    previous.next = tnode;
                }
                previous = tnode;
            }
            node2 = next;
        }
        return first;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private final TemplateNode doParse(Node node2) throws TransformerConfigurationException {
        this.current = node2;
        try {
            String namespaceUri = node2.getNamespaceURI();
            if (XSL_NS.equals(namespaceUri) && 1 == node2.getNodeType()) {
                String name = node2.getLocalName();
                if ("apply-templates".equals(name)) {
                    return this.parseApplyTemplates(node2);
                }
                if ("call-template".equals(name)) {
                    return this.parseCallTemplate(node2);
                }
                if ("value-of".equals(name)) {
                    return this.parseValueOf(node2);
                }
                if ("for-each".equals(name)) {
                    return this.parseForEach(node2);
                }
                if ("if".equals(name)) {
                    return this.parseIf(node2);
                }
                if ("choose".equals(name)) {
                    Node children = node2.getFirstChild();
                    ChooseNode ret = new ChooseNode();
                    ret.children = this.parse(children);
                    return ret;
                }
                if ("when".equals(name)) {
                    return this.parseWhen(node2);
                }
                if ("otherwise".equals(name)) {
                    Node children = node2.getFirstChild();
                    OtherwiseNode ret = new OtherwiseNode();
                    ret.children = this.parse(children);
                    return ret;
                }
                if ("element".equals(name)) {
                    return this.parseElement(node2);
                }
                if ("attribute".equals(name)) {
                    return this.parseAttribute(node2);
                }
                if ("text".equals(name)) {
                    return this.parseText(node2);
                }
                if ("copy".equals(name)) {
                    return this.parseCopy(node2);
                }
                if ("processing-instruction".equals(name)) {
                    return this.parseProcessingInstruction(node2);
                }
                if ("comment".equals(name)) {
                    Node children = node2.getFirstChild();
                    CommentNode ret = new CommentNode();
                    ret.children = this.parse(children);
                    return ret;
                }
                if ("number".equals(name)) {
                    return this.parseNumber(node2);
                }
                if ("param".equals(name) || "variable".equals(name)) {
                    ParameterNode ret;
                    int type = "variable".equals(name) ? 0 : 1;
                    NamedNodeMap attrs = node2.getAttributes();
                    Node children = node2.getFirstChild();
                    TemplateNode content = this.parse(children);
                    QName paramName = this.getQName(Stylesheet.getRequiredAttribute(attrs, "name", node2));
                    String select = Stylesheet.getAttribute(attrs, "select");
                    if (select != null) {
                        if (content != null) {
                            String msg = "parameter '" + paramName + "' has both select and content";
                            DOMSourceLocator l = new DOMSourceLocator(node2);
                            throw new TransformerConfigurationException(msg, l);
                        }
                        Expr expr = (Expr)this.xpath.compile(select);
                        ret = new ParameterNode(paramName, expr, type);
                    } else {
                        ret = new ParameterNode(paramName, null, type);
                        ret.children = content;
                    }
                    return ret;
                }
                if ("copy-of".equals(name)) {
                    return this.parseCopyOf(node2);
                }
                if ("message".equals(name)) {
                    return this.parseMessage(node2);
                }
                if ("apply-imports".equals(name)) {
                    Node children = node2.getFirstChild();
                    ApplyImportsNode ret = new ApplyImportsNode();
                    ret.children = this.parse(children);
                    return ret;
                }
                return null;
            }
            String prefix = node2.getPrefix();
            if (this.extensionElementPrefixes.contains(prefix)) {
                Node ctx = node2.getFirstChild();
                while (ctx != null) {
                    String ctxUri = ctx.getNamespaceURI();
                    if (XSL_NS.equals(ctxUri) && "fallback".equals(ctx.getLocalName())) {
                        return (ctx = ctx.getFirstChild()) == null ? null : this.parse(ctx);
                    }
                    ctx = ctx.getNextSibling();
                }
                return null;
            }
            switch (node2.getNodeType()) {
                case 3: 
                case 4: {
                    Text text = (Text)node2;
                    if (!this.isPreserved(text, false)) {
                        text.getParentNode().removeChild(text);
                        return null;
                    }
                    break;
                }
                case 8: {
                    return null;
                }
                case 1: {
                    NamedNodeMap attrs = node2.getAttributes();
                    boolean convert = false;
                    String useAttributeSets = null;
                    int len = attrs.getLength();
                    int i = 0;
                    while (i < len) {
                        Node attr = attrs.item(i);
                        String value = attr.getNodeValue();
                        if (XSL_NS.equals(attr.getNamespaceURI()) && "use-attribute-sets".equals(attr.getLocalName())) {
                            useAttributeSets = value;
                            convert = true;
                            break;
                        }
                        int start = value.indexOf(123);
                        int end = value.indexOf(125);
                        if (start != -1 || end != -1) {
                            convert = true;
                            break;
                        }
                        ++i;
                    }
                    if (convert) {
                        Node children = node2.getFirstChild();
                        TemplateNode child = this.parse(children);
                        int i2 = 0;
                        while (i2 < len) {
                            Node attr = attrs.item(i2);
                            String ans = attr.getNamespaceURI();
                            String aname = attr.getNodeName();
                            if (!XSL_NS.equals(ans) || !"use-attribute-sets".equals(attr.getLocalName())) {
                                String value = attr.getNodeValue();
                                TemplateNode grandchild = this.parseAttributeValueTemplate(value, node2);
                                TemplateNode n = this.parseAttributeValueTemplate(aname, node2);
                                TemplateNode ns = ans == null ? null : this.parseAttributeValueTemplate(ans, node2);
                                AttributeNode newChild = new AttributeNode(n, ns, attr);
                                newChild.children = grandchild;
                                newChild.next = child;
                                child = newChild;
                            }
                            ++i2;
                        }
                        String ename = node2.getNodeName();
                        TemplateNode n = this.parseAttributeValueTemplate(ename, node2);
                        TemplateNode ns = null;
                        ElementNode ret = new ElementNode(n, ns, useAttributeSets, node2);
                        ret.children = child;
                        return ret;
                    }
                    break;
                }
            }
        }
        catch (XPathExpressionException e) {
            DOMSourceLocator l = new DOMSourceLocator(node2);
            throw new TransformerConfigurationException(e.getMessage(), l, e);
        }
        Node children = node2.getFirstChild();
        LiteralNode ret = new LiteralNode(node2);
        ret.children = this.parse(children);
        return ret;
    }

    final List parseSortKeys(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        LinkedList ret = new LinkedList();
        while (node2 != null) {
            String namespaceUri = node2.getNamespaceURI();
            if (XSL_NS.equals(namespaceUri) && 1 == node2.getNodeType() && "sort".equals(node2.getLocalName())) {
                NamedNodeMap attrs = node2.getAttributes();
                String s = Stylesheet.getAttribute(attrs, "select");
                if (s == null) {
                    s = ".";
                }
                Expr select = (Expr)this.xpath.compile(s);
                String l = Stylesheet.getAttribute(attrs, "lang");
                TemplateNode lang = l == null ? null : this.parseAttributeValueTemplate(l, node2);
                String dt = Stylesheet.getAttribute(attrs, "data-type");
                TemplateNode dataType = dt == null ? null : this.parseAttributeValueTemplate(dt, node2);
                String o = Stylesheet.getAttribute(attrs, "order");
                TemplateNode order = o == null ? null : this.parseAttributeValueTemplate(o, node2);
                String co = Stylesheet.getAttribute(attrs, "case-order");
                TemplateNode caseOrder = co == null ? null : this.parseAttributeValueTemplate(co, node2);
                ret.add(new SortKey(select, lang, dataType, order, caseOrder));
            }
            node2 = node2.getNextSibling();
        }
        return ret.isEmpty() ? null : ret;
    }

    final List parseWithParams(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        LinkedList ret = new LinkedList();
        while (node2 != null) {
            String namespaceUri = node2.getNamespaceURI();
            if (XSL_NS.equals(namespaceUri) && 1 == node2.getNodeType() && "with-param".equals(node2.getLocalName())) {
                NamedNodeMap attrs = node2.getAttributes();
                TemplateNode content = this.parse(node2.getFirstChild());
                QName name = this.getQName(Stylesheet.getRequiredAttribute(attrs, "name", node2));
                String select = Stylesheet.getAttribute(attrs, "select");
                if (select != null) {
                    if (content != null) {
                        String msg = "parameter '" + name + "' has both select and content";
                        DOMSourceLocator l = new DOMSourceLocator(node2);
                        throw new TransformerConfigurationException(msg, l);
                    }
                    Expr expr = (Expr)this.xpath.compile(select);
                    ret.add(new WithParam(name, expr));
                } else {
                    ret.add(new WithParam(name, content));
                }
            }
            node2 = node2.getNextSibling();
        }
        return ret.isEmpty() ? null : ret;
    }

    final void addNamespaceNodes(Node source, Node target, Document doc, Collection elementExcludeResultPrefixes) {
        Node parent;
        NamedNodeMap attrs = source.getAttributes();
        if (attrs != null) {
            int len = attrs.getLength();
            int i = 0;
            while (i < len) {
                Node attr = attrs.item(i);
                String uri = attr.getNamespaceURI();
                if (uri == "http://www.w3.org/2000/xmlns/") {
                    String ns;
                    String prefix = attr.getLocalName();
                    if ("xmlns".equals(prefix)) {
                        prefix = "#default";
                    }
                    if (!(XSL_NS.equals(ns = attr.getNodeValue()) || this.extensionElementPrefixes.contains(prefix) || elementExcludeResultPrefixes.contains(prefix) || this.excludeResultPrefixes.contains(prefix))) {
                        if (prefix == "#default") {
                            prefix = null;
                        }
                        if (target.lookupNamespaceURI(prefix) == null) {
                            attr = attr.cloneNode(true);
                            attr = doc.adoptNode(attr);
                            target.getAttributes().setNamedItemNS(attr);
                        }
                    }
                }
                ++i;
            }
        }
        if ((parent = source.getParentNode()) != null) {
            this.addNamespaceNodes(parent, target, doc, elementExcludeResultPrefixes);
        }
    }

    static final String getAttribute(NamedNodeMap attrs, String name) {
        Node attr = attrs.getNamedItem(name);
        if (attr == null) {
            return null;
        }
        String ret = attr.getNodeValue();
        if (ret.length() == 0) {
            return null;
        }
        return ret;
    }

    static final String getRequiredAttribute(NamedNodeMap attrs, String name, Node source) throws TransformerConfigurationException {
        String value = Stylesheet.getAttribute(attrs, name);
        if (value == null || value.length() == 0) {
            String msg = String.valueOf(name) + " attribute is required on " + source.getNodeName();
            DOMSourceLocator l = new DOMSourceLocator(source);
            throw new TransformerConfigurationException(msg, l);
        }
        return value;
    }

    public void handle(short op, String key, Object data, Node src, Node dst) {
        dst.setUserData(key, data, this);
    }
}

