/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.ReplicateScaleFilter;

public abstract class Image {
    public static final Object UndefinedProperty = new String("undefined property");
    public static final int SCALE_DEFAULT = 1;
    public static final int SCALE_FAST = 2;
    public static final int SCALE_SMOOTH = 4;
    public static final int SCALE_REPLICATE = 8;
    public static final int SCALE_AREA_AVERAGING = 16;
    protected float accelerationPriority;

    public abstract int getWidth(ImageObserver var1);

    public abstract int getHeight(ImageObserver var1);

    public abstract ImageProducer getSource();

    public abstract Graphics getGraphics();

    public abstract Object getProperty(String var1, ImageObserver var2);

    public Image getScaledInstance(int width, int height, int flags) {
        ReplicateScaleFilter filter;
        switch (flags) {
            case 4: 
            case 16: {
                filter = new AreaAveragingScaleFilter(width, height);
                break;
            }
            default: {
                filter = new ReplicateScaleFilter(width, height);
            }
        }
        FilteredImageSource producer = new FilteredImageSource(this.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(producer);
    }

    public abstract void flush();

    public void setAccelerationPriority(float priority) {
        if (priority < 0.0f || priority > 1.0f) {
            throw new IllegalArgumentException("Invalid priority value.");
        }
        this.accelerationPriority = priority;
    }

    public float getAccelerationPriority() {
        return this.accelerationPriority;
    }
}

