/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.font.TextMeasurer;
import java.text.AttributedCharacterIterator;
import java.text.BreakIterator;

public final class LineBreakMeasurer {
    private AttributedCharacterIterator text;
    private int position;
    private TextMeasurer tm;
    private int numChars;

    public LineBreakMeasurer(AttributedCharacterIterator text, BreakIterator breakIter, FontRenderContext frc) {
        this(text, frc);
    }

    public LineBreakMeasurer(AttributedCharacterIterator text, FontRenderContext frc) {
        this.text = text;
        this.position = 0;
        this.numChars = text.getEndIndex();
        this.tm = new TextMeasurer(text, frc);
    }

    public void deleteChar(AttributedCharacterIterator newParagraph, int deletePos) {
        this.tm.deleteChar(newParagraph, deletePos);
        this.position = 0;
    }

    public void insertChar(AttributedCharacterIterator newParagraph, int insertPos) {
        this.tm.insertChar(newParagraph, insertPos);
        this.position = 0;
    }

    public TextLayout nextLayout(float wrappingWidth) {
        return this.nextLayout(wrappingWidth, this.numChars, false);
    }

    public TextLayout nextLayout(float wrappingWidth, int offsetLimit, boolean requireNextWord) {
        int next = this.nextOffset(wrappingWidth, offsetLimit, requireNextWord);
        TextLayout tl = this.tm.getLayout(this.position, next);
        this.position = next;
        return tl;
    }

    public int nextOffset(float wrappingWidth) {
        return this.nextOffset(wrappingWidth, this.numChars, false);
    }

    /*
     * Unable to fully structure code
     */
    public int nextOffset(float wrappingWidth, int offsetLimit, boolean requireNextWord) {
        block6: {
            guessOffset = this.tm.getLineBreakIndex(this.position, wrappingWidth);
            if (offsetLimit > this.numChars) {
                offsetLimit = this.numChars;
            }
            if (guessOffset > offsetLimit) {
                this.text.setIndex(offsetLimit);
                return offsetLimit;
            }
            this.text.setIndex(guessOffset);
            if (Character.isWhitespace(this.text.current())) {
                return guessOffset;
            }
            if (requireNextWord) ** GOTO lbl18
            while (!Character.isWhitespace(this.text.previous()) && guessOffset > this.position) {
                --guessOffset;
            }
            break block6;
lbl-1000:
            // 1 sources

            {
                ++guessOffset;
lbl18:
                // 2 sources

                ** while (!Character.isWhitespace((char)this.text.next()) && guessOffset < offsetLimit)
            }
        }
        if (guessOffset > offsetLimit) {
            this.text.setIndex(offsetLimit);
            return offsetLimit;
        }
        this.text.setIndex(guessOffset);
        return guessOffset;
    }

    public void setPosition(int newPosition) {
        this.position = newPosition;
    }

    public int getPosition() {
        return this.position;
    }
}

