/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;

public final class StackTraceElement
implements Serializable {
    private static final long serialVersionUID = 6992337162326171013L;
    private final String fileName;
    private final int lineNumber;
    private final String declaringClass;
    private final String methodName;
    private final transient boolean isNative;

    StackTraceElement(String fileName, int lineNumber, String className, String methodName, boolean isNative) {
        this.fileName = fileName;
        this.lineNumber = lineNumber;
        this.declaringClass = className;
        this.methodName = methodName;
        this.isNative = isNative;
    }

    public StackTraceElement(String className, String methodName, String fileName, int lineNumber) {
        this(fileName, lineNumber, className, methodName, lineNumber == -2);
        if (className == null || methodName == null) {
            throw new NullPointerException("invalid argument to constructor");
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getClassName() {
        return this.declaringClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean isNativeMethod() {
        return this.isNative;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.declaringClass != null) {
            sb.append(this.declaringClass);
            if (this.methodName != null) {
                sb.append('.');
            }
        }
        if (this.methodName != null) {
            sb.append(this.methodName);
        }
        sb.append("(");
        if (this.fileName != null) {
            sb.append(this.fileName);
        } else {
            sb.append(this.isNative ? "Native Method" : "Unknown Source");
        }
        if (this.lineNumber >= 0) {
            sb.append(':').append(this.lineNumber);
        }
        sb.append(')');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof StackTraceElement)) {
            return false;
        }
        StackTraceElement e = (StackTraceElement)o;
        return StackTraceElement.equals(this.fileName, e.fileName) && this.lineNumber == e.lineNumber && StackTraceElement.equals(this.declaringClass, e.declaringClass) && StackTraceElement.equals(this.methodName, e.methodName);
    }

    public int hashCode() {
        return StackTraceElement.hashCode(this.fileName) ^ this.lineNumber ^ StackTraceElement.hashCode(this.declaringClass) ^ StackTraceElement.hashCode(this.methodName);
    }

    private static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private static int hashCode(Object o) {
        return o == null ? 0 : o.hashCode();
    }
}

