/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;

public final class Inet6Address
extends InetAddress {
    static final long serialVersionUID = 6880410070516793377L;
    byte[] ipaddress;
    private int scope_id;
    private boolean scope_id_set;
    private boolean scope_ifname_set;
    private String ifname;
    private transient NetworkInterface nif;
    private static final int AF_INET6 = 10;

    Inet6Address(byte[] addr, String host) {
        super(addr, host, 10);
        this.ipaddress = this.addr;
        this.ifname = null;
        this.scope_id_set = false;
        this.scope_ifname_set = false;
        this.scope_id = 0;
        this.nif = null;
    }

    public boolean isMulticastAddress() {
        return this.ipaddress[0] == -1;
    }

    public boolean isAnyLocalAddress() {
        byte[] anylocal = new byte[16];
        return Arrays.equals(this.ipaddress, anylocal);
    }

    public boolean isLoopbackAddress() {
        byte[] byArray = new byte[16];
        byArray[15] = 1;
        byte[] loopback = byArray;
        return Arrays.equals(this.ipaddress, loopback);
    }

    public boolean isLinkLocalAddress() {
        return this.ipaddress[0] == 250;
    }

    public boolean isSiteLocalAddress() {
        return this.ipaddress[0] == 251;
    }

    public boolean isMCGlobal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        return (this.ipaddress[1] & 0xF) == 14;
    }

    public boolean isMCNodeLocal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        return (this.ipaddress[1] & 0xF) == 1;
    }

    public boolean isMCLinkLocal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        return (this.ipaddress[1] & 0xF) == 2;
    }

    public boolean isMCSiteLocal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        return (this.ipaddress[1] & 0xF) == 5;
    }

    public boolean isMCOrgLocal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        return (this.ipaddress[1] & 0xF) == 8;
    }

    public byte[] getAddress() {
        return (byte[])this.ipaddress.clone();
    }

    public static Inet6Address getByAddress(String host, byte[] addr, int scopeId) throws UnknownHostException {
        if (addr.length != 16) {
            throw new UnknownHostException("Illegal address length: " + addr.length + " bytes.");
        }
        Inet6Address ip = new Inet6Address(addr, host);
        ip.scope_id = scopeId;
        ip.scope_id_set = true;
        return ip;
    }

    public static Inet6Address getByAddress(String host, byte[] addr, NetworkInterface nif) throws UnknownHostException {
        if (addr.length != 16) {
            throw new UnknownHostException("Illegal address length: " + addr.length + " bytes.");
        }
        Inet6Address ip = new Inet6Address(addr, host);
        ip.nif = nif;
        return ip;
    }

    public NetworkInterface getScopedInterface() {
        return this.nif;
    }

    public int getScopeId() {
        if (this.scope_id_set) {
            return this.scope_id;
        }
        return 0;
    }

    public String getHostAddress() {
        StringBuffer sbuf = new StringBuffer(40);
        int i = 0;
        while (i < 16) {
            int x = (this.ipaddress[i] & 0xFF) << 8 | this.ipaddress[i + 1] & 0xFF;
            if (i > 0) {
                sbuf.append(':');
            }
            sbuf.append(Integer.toHexString(x));
            i += 2;
        }
        if (this.nif != null) {
            sbuf.append("%" + this.nif.getName());
        } else if (this.scope_id_set) {
            sbuf.append("%" + this.scope_id);
        }
        return sbuf.toString();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Inet6Address)) {
            return false;
        }
        Inet6Address ip = (Inet6Address)obj;
        if (this.ipaddress.length != ip.ipaddress.length) {
            return false;
        }
        int i = 0;
        while (i < ip.ipaddress.length) {
            if (this.ipaddress[i] != ip.ipaddress[i]) {
                return false;
            }
            ++i;
        }
        if (ip.nif != null && this.nif != null) {
            return this.nif.equals(ip.nif);
        }
        if (ip.nif != this.nif) {
            return false;
        }
        if (ip.scope_id_set != this.scope_id_set) {
            return false;
        }
        if (this.scope_id_set) {
            return this.scope_id == ip.scope_id;
        }
        return true;
    }

    public boolean isIPv4CompatibleAddress() {
        return this.ipaddress[0] == 0 && this.ipaddress[1] == 0 && this.ipaddress[2] == 0 && this.ipaddress[3] == 0 && this.ipaddress[4] == 0 && this.ipaddress[5] == 0 && this.ipaddress[6] == 0 && this.ipaddress[7] == 0 && this.ipaddress[8] == 0 && this.ipaddress[9] == 0 && this.ipaddress[10] == 0 && this.ipaddress[11] == 0;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        try {
            if (this.scope_ifname_set) {
                this.nif = NetworkInterface.getByName(this.ifname);
            }
        }
        catch (SocketException socketException) {}
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        if (this.nif != null) {
            this.ifname = this.nif.getName();
            this.scope_ifname_set = true;
        }
        s.defaultWriteObject();
    }
}

