/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;

public final class Currency
implements Serializable {
    static final long serialVersionUID = -158308464356906721L;
    private transient Locale locale;
    private transient ResourceBundle res;
    private static transient Properties properties;
    private String currencyCode;
    private transient int fractionDigits;
    private static transient Map cache;

    static {
        cache = new HashMap();
        properties = new Properties();
        try {
            properties.load(Currency.class.getResourceAsStream("iso4217.properties"));
        }
        catch (IOException exception) {
            System.out.println("Failed to load currency resource: " + exception);
        }
    }

    private Currency() {
    }

    private Currency(Locale loc) {
        String countryCode = loc.getCountry();
        if (countryCode.equals("")) {
            throw new IllegalArgumentException("Invalid (empty) country code for locale:" + loc);
        }
        this.locale = loc;
        this.res = ResourceBundle.getBundle("gnu.java.locale.LocaleInformation", this.locale, ClassLoader.getSystemClassLoader());
        try {
            this.currencyCode = this.res.getString("intlCurrencySymbol");
        }
        catch (Exception exception) {
            this.currencyCode = null;
        }
        String fractionDigitsKey = String.valueOf(countryCode) + ".fractionDigits";
        this.fractionDigits = Integer.parseInt(properties.getProperty(fractionDigitsKey));
    }

    private Currency(String code) {
        this.currencyCode = code;
        this.fractionDigits = -1;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public int getDefaultFractionDigits() {
        return this.fractionDigits;
    }

    public static Currency getInstance(Locale locale) {
        Currency newCurrency = (Currency)cache.get(locale);
        if (newCurrency == null) {
            newCurrency = new Currency(locale);
            cache.put(locale, newCurrency);
        }
        return newCurrency;
    }

    public static Currency getInstance(String currencyCode) {
        Locale[] allLocales = Locale.getAvailableLocales();
        if (currencyCode.equals("XXX")) {
            return new Currency("XXX");
        }
        int i = 0;
        while (i < allLocales.length) {
            Currency testCurrency = Currency.getInstance(allLocales[i]);
            if (testCurrency.getCurrencyCode() != null && testCurrency.getCurrencyCode().equals(currencyCode)) {
                return testCurrency;
            }
            ++i;
        }
        throw new IllegalArgumentException("The currency code, " + currencyCode + ", is not supported.");
    }

    public String getSymbol() {
        try {
            return this.res.getString("currencySymbol");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getSymbol(Locale locale) {
        try {
            ResourceBundle localeResource = ResourceBundle.getBundle("gnu.java.locale.LocaleInformation", locale, Currency.class.getClassLoader());
            if (localeResource.equals(this.res)) {
                return localeResource.getString("currencySymbol");
            }
            return localeResource.getString("intlCurrencySymbol");
        }
        catch (Exception exception) {
            try {
                return this.res.getString("intlCurrencySymbol");
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }

    public String toString() {
        return this.getCurrencyCode();
    }

    private Object readResolve() throws ObjectStreamException {
        return Currency.getInstance(this.currencyCode);
    }
}

