/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import gnu.classpath.SystemProperties;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicButtonUI;

public class BasicGraphicsUtils {
    static final String CACHED_TEXT_LAYOUT = "BasicGraphicsUtils.cachedTextLayout";

    public static void drawEtchedRect(Graphics g, int x, int y, int width, int height, Color shadow, Color darkShadow, Color highlight, Color lightHighlight) {
        Color oldColor = g.getColor();
        int x2 = x + width - 1;
        int y2 = y + height - 1;
        try {
            g.setColor(shadow);
            g.drawLine(x, y, x2 - 1, y);
            g.drawLine(x, y + 1, x, y2 - 1);
            g.setColor(darkShadow);
            g.drawLine(x + 1, y + 1, x2 - 2, y + 1);
            g.drawLine(x + 1, y + 2, x + 1, y2 - 2);
            g.setColor(highlight);
            g.drawLine(x + 1, y2 - 1, x2 - 1, y2 - 1);
            g.drawLine(x2 - 1, y + 1, x2 - 1, y2 - 2);
            g.setColor(lightHighlight);
            g.drawLine(x, y2, x2, y2);
            g.drawLine(x2, y, x2, y2 - 1);
        }
        finally {
            g.setColor(oldColor);
        }
    }

    public static Insets getEtchedInsets() {
        return new Insets(2, 2, 2, 2);
    }

    public static void drawGroove(Graphics g, int x, int y, int width, int height, Color shadow, Color highlight) {
        BasicGraphicsUtils.drawEtchedRect(g, x, y, width, height, shadow, highlight, shadow, highlight);
    }

    public static Insets getGrooveInsets() {
        return new Insets(2, 2, 2, 2);
    }

    public static void drawBezel(Graphics g, int x, int y, int width, int height, boolean isPressed, boolean isDefault, Color shadow, Color darkShadow, Color highlight, Color lightHighlight) {
        Color oldColor = g.getColor();
        try {
            if (!isPressed && !isDefault) {
                BasicGraphicsUtils.drawEtchedRect(g, x, y, width, height, lightHighlight, highlight, shadow, darkShadow);
            }
            if (isPressed && !isDefault) {
                g.setColor(shadow);
                g.drawRect(x + 1, y + 1, width - 2, height - 2);
            }
            if (!isPressed && isDefault) {
                g.setColor(darkShadow);
                g.drawRect(x, y, width - 1, height - 1);
                BasicGraphicsUtils.drawEtchedRect(g, x + 1, y + 1, width - 2, height - 2, lightHighlight, highlight, shadow, darkShadow);
            }
            if (isPressed && isDefault) {
                g.setColor(darkShadow);
                g.drawRect(x, y, width - 1, height - 1);
                g.setColor(shadow);
                g.drawRect(x + 1, y + 1, width - 3, height - 3);
            }
        }
        finally {
            g.setColor(oldColor);
        }
    }

    public static void drawLoweredBezel(Graphics g, int x, int y, int width, int height, Color shadow, Color darkShadow, Color highlight, Color lightHighlight) {
        BasicGraphicsUtils.drawEtchedRect(g, x, y, width, height, darkShadow, shadow, highlight, lightHighlight);
    }

    public static void drawString(Graphics g, String text, int underlinedChar, int x, int y) {
        int index = -1;
        if (underlinedChar >= 0 || underlinedChar <= 65535) {
            index = text.toLowerCase().indexOf(Character.toLowerCase((char)underlinedChar));
        }
        BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, index, x, y);
    }

    public static void drawStringUnderlineCharAt(Graphics g, String text, int underlinedIndex, int x, int y) {
        int textLength = text.length();
        if (textLength == 0) {
            return;
        }
        boolean drawUnderline = underlinedIndex >= 0 && underlinedIndex < textLength;
        g.drawString(text, x, y);
        if (drawUnderline) {
            FontMetrics fmet = g.getFontMetrics();
            g.fillRect(x + fmet.stringWidth(text.substring(0, underlinedIndex)), y + fmet.getDescent() - 1, fmet.charWidth(text.charAt(underlinedIndex)), 1);
        }
    }

    static void drawString(JComponent c, Graphics g, String text, int underlinedChar, int x, int y) {
        int index = -1;
        if (underlinedChar >= 0 || underlinedChar <= 65535) {
            index = text.toLowerCase().indexOf(Character.toLowerCase((char)underlinedChar));
        }
        BasicGraphicsUtils.drawStringUnderlineCharAt(c, g, text, index, x, y);
    }

    static void drawStringUnderlineCharAt(JComponent c, Graphics g, String text, int underlinedIndex, int x, int y) {
        boolean drawUnderline;
        int textLength = text.length();
        if (textLength == 0) {
            return;
        }
        boolean bl = drawUnderline = underlinedIndex >= 0 && underlinedIndex < textLength;
        if (!(g instanceof Graphics2D) || SystemProperties.getProperty("gnu.javax.swing.noGraphics2D") != null) {
            g.drawString(text, x, y);
            if (drawUnderline) {
                FontMetrics fmet = g.getFontMetrics();
                g.fillRect(x + fmet.stringWidth(text.substring(0, underlinedIndex)), y + fmet.getDescent() - 1, fmet.charWidth(text.charAt(underlinedIndex)), 1);
            }
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Font font = g2.getFont();
        FontRenderContext frc = g2.getFontRenderContext();
        LineMetrics lineMetrics = font.getLineMetrics(text, frc);
        TextLayout layout = (TextLayout)c.getClientProperty(CACHED_TEXT_LAYOUT);
        if (layout == null) {
            layout = new TextLayout(text, font, frc);
            System.err.println("Unable to use cached TextLayout for: " + text);
        }
        layout.draw(g2, x, y);
        if (!drawUnderline) {
            return;
        }
        double underlineX1 = (double)x + layout.getLogicalHighlightShape(underlinedIndex, underlinedIndex).getBounds2D().getX();
        double underlineX2 = (double)x + layout.getLogicalHighlightShape(underlinedIndex + 1, underlinedIndex + 1).getBounds2D().getX();
        Rectangle2D.Double underline = new Rectangle2D.Double();
        if (underlineX1 < underlineX2) {
            underline.x = underlineX1;
            underline.width = underlineX2 - underlineX1;
        } else {
            underline.x = underlineX2;
            underline.width = underlineX1 - underlineX2;
        }
        underline.height = lineMetrics.getUnderlineThickness();
        underline.y = lineMetrics.getUnderlineOffset();
        if (underline.y == 0.0) {
            underline.y = lineMetrics.getDescent();
        }
        underline.y += (double)y;
        g2.fill(underline);
    }

    public static void drawDashedRect(Graphics g, int x, int y, int width, int height) {
        int right = x + width - 1;
        int bottom = y + height - 1;
        int i = x;
        while (i <= right) {
            g.drawLine(i, y, i, y);
            g.drawLine(i, bottom, i, bottom);
            i += 2;
        }
        i = y;
        while (i <= bottom) {
            g.drawLine(x, i, x, i);
            g.drawLine(right, i, right, i);
            i += 2;
        }
    }

    public static Dimension getPreferredButtonSize(AbstractButton b, int textIconGap) {
        Rectangle viewRect = BasicButtonUI.viewR;
        viewRect.x = 0;
        viewRect.y = 0;
        viewRect.width = Short.MAX_VALUE;
        viewRect.height = Short.MAX_VALUE;
        Rectangle iconRect = BasicButtonUI.iconR;
        iconRect.x = 0;
        iconRect.y = 0;
        iconRect.width = 0;
        iconRect.height = 0;
        Rectangle textRect = BasicButtonUI.textR;
        textRect.x = 0;
        textRect.y = 0;
        textRect.width = 0;
        textRect.height = 0;
        SwingUtilities.layoutCompoundLabel(b, b.getFontMetrics(b.getFont()), b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, textIconGap);
        Rectangle contentRect = SwingUtilities.computeUnion(textRect.x, textRect.y, textRect.width, textRect.height, iconRect);
        Insets insets = b.getInsets();
        return new Dimension(insets.left + contentRect.width + insets.right, insets.top + contentRect.height + insets.bottom);
    }
}

