/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.font.TextAttribute;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.Bidi;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.tree.TreeNode;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDocument
implements Document,
Serializable {
    private static final long serialVersionUID = 6842927725919637215L;
    protected static final String BAD_LOCATION = "document location failure";
    public static final String BidiElementName = "bidi level";
    public static final String ContentElementName = "content";
    public static final String ParagraphElementName = "paragraph";
    public static final String SectionElementName = "section";
    public static final String ElementNameAttribute = "$ename";
    private static final String BidiRootName = "bidi root";
    private static final String AsyncLoadPriority = "load priority";
    private static final String I18N = "i18n";
    Content content;
    AttributeContext context;
    DocumentFilter documentFilter;
    Dictionary properties;
    protected EventListenerList listenerList = new EventListenerList();
    private Thread currentWriter = null;
    private int numReaders = 0;
    private int numWriters = 0;
    private DocumentFilter.FilterBypass bypass;
    private BidiRootElement bidiRoot;
    private transient boolean notifyListeners;

    protected AbstractDocument(Content doc) {
        this(doc, StyleContext.getDefaultStyleContext());
    }

    protected AbstractDocument(Content doc, AttributeContext ctx) {
        this.content = doc;
        this.context = ctx;
        this.bidiRoot = new BidiRootElement();
        this.putProperty(I18N, Boolean.FALSE);
        this.writeLock();
        try {
            Element[] children = new Element[]{new BidiElement((Element)this.bidiRoot, 0, 1, 0)};
            this.bidiRoot.replace(0, 0, children);
        }
        finally {
            this.writeUnlock();
        }
    }

    private DocumentFilter.FilterBypass getBypass() {
        if (this.bypass == null) {
            this.bypass = new Bypass();
        }
        return this.bypass;
    }

    public abstract Element getParagraphElement(int var1);

    @Override
    public abstract Element getDefaultRootElement();

    protected Element createBranchElement(Element parent, AttributeSet attributes) {
        return new BranchElement(parent, attributes);
    }

    protected Element createLeafElement(Element parent, AttributeSet attributes, int start, int end) {
        return new LeafElement(parent, attributes, start, end);
    }

    @Override
    public synchronized Position createPosition(int offset) throws BadLocationException {
        return this.content.createPosition(offset);
    }

    protected void fireChangedUpdate(DocumentEvent event) {
        this.notifyListeners = true;
        try {
            DocumentListener[] listeners = this.getDocumentListeners();
            int index = 0;
            while (index < listeners.length) {
                listeners[index].changedUpdate(event);
                ++index;
            }
        }
        finally {
            this.notifyListeners = false;
        }
    }

    protected void fireInsertUpdate(DocumentEvent event) {
        this.notifyListeners = true;
        try {
            DocumentListener[] listeners = this.getDocumentListeners();
            int index = 0;
            while (index < listeners.length) {
                listeners[index].insertUpdate(event);
                ++index;
            }
        }
        finally {
            this.notifyListeners = false;
        }
    }

    protected void fireRemoveUpdate(DocumentEvent event) {
        this.notifyListeners = true;
        try {
            DocumentListener[] listeners = this.getDocumentListeners();
            int index = 0;
            while (index < listeners.length) {
                listeners[index].removeUpdate(event);
                ++index;
            }
        }
        finally {
            this.notifyListeners = false;
        }
    }

    protected void fireUndoableEditUpdate(UndoableEditEvent event) {
        UndoableEditListener[] listeners = this.getUndoableEditListeners();
        int index = 0;
        while (index < listeners.length) {
            listeners[index].undoableEditHappened(event);
            ++index;
        }
    }

    public int getAsynchronousLoadPriority() {
        Object val = this.getProperty(AsyncLoadPriority);
        int prio = -1;
        if (val != null) {
            prio = (Integer)val;
        }
        return prio;
    }

    protected final AttributeContext getAttributeContext() {
        return this.context;
    }

    public Element getBidiRootElement() {
        return this.bidiRoot;
    }

    protected final Content getContent() {
        return this.content;
    }

    protected final synchronized Thread getCurrentWriter() {
        return this.currentWriter;
    }

    public Dictionary<Object, Object> getDocumentProperties() {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        return this.properties;
    }

    @Override
    public final Position getEndPosition() {
        Position p;
        try {
            p = this.createPosition(this.content.length());
        }
        catch (BadLocationException badLocationException) {
            p = null;
        }
        return p;
    }

    @Override
    public int getLength() {
        return this.content.length() - 1;
    }

    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    @Override
    public final Object getProperty(Object key) {
        Object value = null;
        if (this.properties != null) {
            value = this.properties.get(key);
        }
        return value;
    }

    @Override
    public Element[] getRootElements() {
        Element[] elements = new Element[]{this.getDefaultRootElement(), this.getBidiRootElement()};
        return elements;
    }

    @Override
    public final Position getStartPosition() {
        Position p;
        try {
            p = this.createPosition(0);
        }
        catch (BadLocationException badLocationException) {
            p = null;
        }
        return p;
    }

    @Override
    public String getText(int offset, int length) throws BadLocationException {
        return this.content.getString(offset, length);
    }

    @Override
    public void getText(int offset, int length, Segment segment) throws BadLocationException {
        this.content.getChars(offset, length, segment);
    }

    @Override
    public void insertString(int offset, String text, AttributeSet attributes) throws BadLocationException {
        if (text == null || text.length() == 0) {
            return;
        }
        this.writeLock();
        try {
            if (this.documentFilter == null) {
                this.insertStringImpl(offset, text, attributes);
            } else {
                this.documentFilter.insertString(this.getBypass(), offset, text, attributes);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    void insertStringImpl(int offset, String text, AttributeSet attributes) throws BadLocationException {
        if (text == null || text.length() == 0) {
            return;
        }
        DefaultDocumentEvent event = new DefaultDocumentEvent(offset, text.length(), DocumentEvent.EventType.INSERT);
        UndoableEdit undo = this.content.insertString(offset, text);
        if (undo != null) {
            event.addEdit(undo);
        }
        if (this.getProperty(I18N).equals(Boolean.FALSE)) {
            Object dir = this.getProperty(TextAttribute.RUN_DIRECTION);
            if (TextAttribute.RUN_DIRECTION_RTL.equals(dir)) {
                this.putProperty(I18N, Boolean.TRUE);
            } else {
                char[] chars = text.toCharArray();
                if (Bidi.requiresBidi(chars, 0, chars.length)) {
                    this.putProperty(I18N, Boolean.TRUE);
                }
            }
        }
        this.insertUpdate(event, attributes);
        this.fireInsertUpdate(event);
        if (undo != null) {
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, undo));
        }
    }

    protected void insertUpdate(DefaultDocumentEvent chng, AttributeSet attr) {
        if (Boolean.TRUE.equals(this.getProperty(I18N))) {
            this.updateBidi(chng);
        }
    }

    protected void postRemoveUpdate(DefaultDocumentEvent chng) {
        if (Boolean.TRUE.equals(this.getProperty(I18N))) {
            this.updateBidi(chng);
        }
    }

    @Override
    public final void putProperty(Object key, Object value) {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        if (value == null) {
            this.properties.remove(key);
        } else {
            this.properties.put(key, value);
        }
        if (TextAttribute.RUN_DIRECTION.equals(key)) {
            if (TextAttribute.RUN_DIRECTION_RTL.equals(value) && Boolean.FALSE.equals(this.getProperty(I18N))) {
                this.putProperty(I18N, Boolean.TRUE);
            }
            if (Boolean.TRUE.equals(this.getProperty(I18N))) {
                this.writeLock();
                try {
                    DefaultDocumentEvent ev = new DefaultDocumentEvent(0, this.getLength(), DocumentEvent.EventType.INSERT);
                    this.updateBidi(ev);
                }
                finally {
                    this.writeUnlock();
                }
            }
        }
    }

    private void updateBidi(DefaultDocumentEvent ev) {
        int start = 0;
        int end = 0;
        DocumentEvent.EventType type = ev.getType();
        if (type == DocumentEvent.EventType.INSERT || type == DocumentEvent.EventType.CHANGE) {
            int offs = ev.getOffset();
            int endOffs = offs + ev.getLength();
            start = this.getParagraphElement(offs).getStartOffset();
            end = this.getParagraphElement(endOffs).getEndOffset();
        } else if (type == DocumentEvent.EventType.REMOVE) {
            Element par = this.getParagraphElement(ev.getOffset());
            start = par.getStartOffset();
            end = par.getEndOffset();
        } else assert (false) : "Unknown event type";
        Bidi[] bidis = this.getBidis(start, end);
        int removeFrom = 0;
        int removeTo = 0;
        int offs = 0;
        int lastRunStart = 0;
        int lastRunEnd = 0;
        int lastRunLevel = 0;
        ArrayList<BidiElement> newEls = new ArrayList<BidiElement>();
        int i = 0;
        while (i < bidis.length) {
            Bidi bidi = bidis[i];
            int numRuns = bidi.getRunCount();
            int r = 0;
            while (r < numRuns) {
                int level;
                AttributeSet atts;
                if (r == 0 && i == 0) {
                    if (start > 0) {
                        int prevElIndex;
                        removeFrom = prevElIndex = this.bidiRoot.getElementIndex(start - 1);
                        Element prevEl = this.bidiRoot.getElement(prevElIndex);
                        atts = prevEl.getAttributes();
                        int prevElLevel = StyleConstants.getBidiLevel(atts);
                        if (prevElLevel == bidi.getRunLevel(r)) {
                            lastRunStart = prevEl.getStartOffset() - start;
                            lastRunEnd = bidi.getRunLimit(r);
                            lastRunLevel = bidi.getRunLevel(r);
                        } else if (prevEl.getEndOffset() > start) {
                            lastRunStart = 0;
                            lastRunEnd = bidi.getRunLimit(r);
                            lastRunLevel = bidi.getRunLevel(r);
                            newEls.add(new BidiElement((Element)this.bidiRoot, prevEl.getStartOffset(), start, prevElLevel));
                        } else {
                            lastRunStart = 0;
                            lastRunEnd = bidi.getRunLimit(r);
                            lastRunLevel = bidi.getRunLevel(r);
                            ++removeFrom;
                        }
                    } else {
                        lastRunStart = 0;
                        lastRunEnd = bidi.getRunLimit(r);
                        lastRunLevel = bidi.getRunLevel(r);
                        removeFrom = 0;
                    }
                }
                if (i == bidis.length - 1 && r == numRuns - 1) {
                    if (end <= this.getLength()) {
                        int endOffs;
                        int nextIndex = this.bidiRoot.getElementIndex(end);
                        Element nextEl = this.bidiRoot.getElement(nextIndex);
                        atts = nextEl.getAttributes();
                        int nextLevel = StyleConstants.getBidiLevel(atts);
                        int level2 = bidi.getRunLevel(r);
                        if (lastRunLevel == level2 && level2 == nextLevel) {
                            if (lastRunStart + start == nextEl.getStartOffset()) {
                                removeTo = nextIndex - 1;
                            } else {
                                newEls.add(new BidiElement((Element)this.bidiRoot, start + lastRunStart, nextEl.getEndOffset(), level2));
                                removeTo = nextIndex;
                            }
                        } else if (lastRunLevel == level2) {
                            endOffs = offs + bidi.getRunLimit(r);
                            newEls.add(new BidiElement((Element)this.bidiRoot, start + lastRunStart, start + endOffs, level2));
                            if (start + endOffs == nextEl.getStartOffset()) {
                                removeTo = nextIndex - 1;
                            } else {
                                newEls.add(new BidiElement((Element)this.bidiRoot, start + endOffs, nextEl.getEndOffset(), nextLevel));
                                removeTo = nextIndex;
                            }
                        } else if (level2 == nextLevel) {
                            newEls.add(new BidiElement((Element)this.bidiRoot, start + lastRunStart, start + lastRunEnd, lastRunLevel));
                            newEls.add(new BidiElement((Element)this.bidiRoot, start + lastRunEnd, nextEl.getEndOffset(), level2));
                            removeTo = nextIndex;
                        } else {
                            endOffs = offs + bidi.getRunLimit(r);
                            newEls.add(new BidiElement((Element)this.bidiRoot, start + lastRunStart, start + lastRunEnd, lastRunLevel));
                            newEls.add(new BidiElement((Element)this.bidiRoot, start + lastRunEnd, start + endOffs, level2));
                            newEls.add(new BidiElement((Element)this.bidiRoot, start + endOffs, nextEl.getEndOffset(), nextLevel));
                            removeTo = nextIndex;
                        }
                    } else {
                        removeTo = this.bidiRoot.getElementIndex(end);
                        level = bidi.getRunLevel(r);
                        int runEnd = offs + bidi.getRunLimit(r);
                        if (level == lastRunLevel) {
                            lastRunEnd = offs + runEnd;
                            newEls.add(new BidiElement((Element)this.bidiRoot, start + lastRunStart, start + runEnd, level));
                        } else {
                            newEls.add(new BidiElement((Element)this.bidiRoot, start + lastRunStart, start + lastRunEnd, lastRunLevel));
                            newEls.add(new BidiElement((Element)this.bidiRoot, start + lastRunEnd, start + runEnd, level));
                        }
                    }
                } else {
                    level = bidi.getRunLevel(r);
                    int runEnd = bidi.getRunLimit(r);
                    if (level == lastRunLevel) {
                        lastRunEnd = offs + runEnd;
                    } else {
                        newEls.add(new BidiElement((Element)this.bidiRoot, start + lastRunStart, start + lastRunEnd, lastRunLevel));
                        lastRunStart = lastRunEnd;
                        lastRunEnd = offs + runEnd;
                        lastRunLevel = level;
                    }
                }
                ++r;
            }
            offs += bidi.getLength();
            ++i;
        }
        int numRemoved = 0;
        if (this.bidiRoot.getElementCount() > 0) {
            numRemoved = removeTo - removeFrom + 1;
        }
        Element[] removed = new Element[numRemoved];
        int i2 = 0;
        while (i2 < numRemoved) {
            removed[i2] = this.bidiRoot.getElement(removeFrom + i2);
            ++i2;
        }
        Element[] added = new Element[newEls.size()];
        added = newEls.toArray(added);
        ElementEdit edit = new ElementEdit(this.bidiRoot, removeFrom, removed, added);
        ev.addEdit(edit);
        this.bidiRoot.replace(removeFrom, numRemoved, added);
    }

    private Bidi[] getBidis(int start, int end) {
        Boolean defaultDir = null;
        Object o = this.getProperty(TextAttribute.RUN_DIRECTION);
        if (o instanceof Boolean) {
            defaultDir = (Boolean)o;
        }
        ArrayList<Bidi> bidis = new ArrayList<Bidi>();
        Segment s = new Segment();
        int i = start;
        while (i < end) {
            Boolean dir;
            int pEnd;
            block6: {
                Element par = this.getParagraphElement(i);
                int pStart = par.getStartOffset();
                pEnd = par.getEndOffset();
                dir = defaultDir;
                o = par.getAttributes().getAttribute(TextAttribute.RUN_DIRECTION);
                if (o instanceof Boolean) {
                    dir = (Boolean)o;
                }
                try {
                    this.getText(pStart, pEnd - pStart, s);
                }
                catch (BadLocationException badLocationException) {
                    if ($assertionsDisabled) break block6;
                    throw new AssertionError((Object)"Must not happen");
                }
            }
            int flag = -2;
            if (dir != null) {
                flag = TextAttribute.RUN_DIRECTION_LTR.equals(dir) ? 0 : 1;
            }
            Bidi bidi = new Bidi(s.array, s.offset, null, 0, s.count, flag);
            bidis.add(bidi);
            i = pEnd;
        }
        Bidi[] ret = new Bidi[bidis.size()];
        ret = bidis.toArray(ret);
        return ret;
    }

    public final synchronized void readLock() {
        try {
            while (this.currentWriter != null) {
                if (this.currentWriter == Thread.currentThread()) {
                    return;
                }
                this.wait();
            }
            ++this.numReaders;
        }
        catch (InterruptedException interruptedException) {
            throw new Error("Interrupted during grab read lock");
        }
    }

    public final synchronized void readUnlock() {
        if (this.currentWriter == Thread.currentThread()) {
            return;
        }
        if (this.numReaders <= 0) {
            throw new IllegalStateException("document lock failure");
        }
        --this.numReaders;
        this.notify();
    }

    @Override
    public void remove(int offset, int length) throws BadLocationException {
        this.writeLock();
        try {
            DocumentFilter f = this.getDocumentFilter();
            if (f == null) {
                this.removeImpl(offset, length);
            } else {
                f.remove(this.getBypass(), offset, length);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    void removeImpl(int offset, int length) throws BadLocationException {
        if (length > 0) {
            if (offset < 0 || offset > this.getLength()) {
                throw new BadLocationException("Invalid remove position", offset);
            }
            if (offset + length > this.getLength()) {
                throw new BadLocationException("Invalid remove length", offset);
            }
            DefaultDocumentEvent event = new DefaultDocumentEvent(offset, length, DocumentEvent.EventType.REMOVE);
            this.removeUpdate(event);
            this.content.remove(offset, length);
            this.postRemoveUpdate(event);
            this.fireRemoveUpdate(event);
        }
    }

    public void replace(int offset, int length, String text, AttributeSet attributes) throws BadLocationException {
        if (length == 0 && (text == null || text.length() == 0)) {
            return;
        }
        this.writeLock();
        try {
            if (this.documentFilter == null) {
                this.remove(offset, length);
                this.insertString(offset, text, attributes);
            } else {
                this.documentFilter.replace(this.getBypass(), offset, length, text, attributes);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    void replaceImpl(int offset, int length, String text, AttributeSet attributes) throws BadLocationException {
        this.removeImpl(offset, length);
        this.insertStringImpl(offset, text, attributes);
    }

    @Override
    public void addDocumentListener(DocumentListener listener) {
        this.listenerList.add(DocumentListener.class, listener);
    }

    @Override
    public void removeDocumentListener(DocumentListener listener) {
        this.listenerList.remove(DocumentListener.class, listener);
    }

    public DocumentListener[] getDocumentListeners() {
        return (DocumentListener[])this.getListeners(DocumentListener.class);
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener listener) {
        this.listenerList.add(UndoableEditListener.class, listener);
    }

    @Override
    public void removeUndoableEditListener(UndoableEditListener listener) {
        this.listenerList.remove(UndoableEditListener.class, listener);
    }

    public UndoableEditListener[] getUndoableEditListeners() {
        return (UndoableEditListener[])this.getListeners(UndoableEditListener.class);
    }

    protected void removeUpdate(DefaultDocumentEvent chng) {
    }

    @Override
    public void render(Runnable runnable) {
        this.readLock();
        try {
            runnable.run();
        }
        finally {
            this.readUnlock();
        }
    }

    public void setAsynchronousLoadPriority(int p) {
        Integer val = p >= 0 ? new Integer(p) : null;
        this.putProperty(AsyncLoadPriority, val);
    }

    public void setDocumentProperties(Dictionary<Object, Object> p) {
        this.properties = p;
    }

    protected final synchronized void writeLock() {
        try {
            while (this.numReaders > 0 || this.currentWriter != null) {
                if (Thread.currentThread() == this.currentWriter) {
                    if (this.notifyListeners) {
                        throw new IllegalStateException("Mutation during notify");
                    }
                    ++this.numWriters;
                    return;
                }
                this.wait();
            }
            this.currentWriter = Thread.currentThread();
            this.numWriters = 1;
        }
        catch (InterruptedException interruptedException) {
            throw new Error("Interupted during grab write lock");
        }
    }

    protected final synchronized void writeUnlock() {
        if (--this.numWriters <= 0) {
            this.numWriters = 0;
            this.currentWriter = null;
            this.notifyAll();
        }
    }

    public DocumentFilter getDocumentFilter() {
        return this.documentFilter;
    }

    public void setDocumentFilter(DocumentFilter filter) {
        this.documentFilter = filter;
    }

    public void dump(PrintStream out) {
        ((AbstractElement)this.getDefaultRootElement()).dump(out, 0);
        ((AbstractElement)this.getBidiRootElement()).dump(out, 0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class AbstractElement
    implements Element,
    MutableAttributeSet,
    TreeNode,
    Serializable {
        private static final long serialVersionUID = 1712240033321461704L;
        int count;
        int offset;
        AttributeSet attributes;
        Element element_parent;
        TreeNode tree_parent;
        Vector tree_children;

        public AbstractElement(Element p, AttributeSet s) {
            this.element_parent = p;
            AttributeContext ctx = AbstractDocument.this.getAttributeContext();
            this.attributes = ctx.getEmptySet();
            if (s != null) {
                this.addAttributes(s);
            }
        }

        @Override
        public abstract Enumeration children();

        @Override
        public abstract boolean getAllowsChildren();

        @Override
        public TreeNode getChildAt(int index) {
            return (TreeNode)this.tree_children.get(index);
        }

        @Override
        public int getChildCount() {
            return this.tree_children.size();
        }

        @Override
        public int getIndex(TreeNode node2) {
            return this.tree_children.indexOf(node2);
        }

        @Override
        public TreeNode getParent() {
            return this.tree_parent;
        }

        @Override
        public abstract boolean isLeaf();

        @Override
        public void addAttribute(Object name, Object value) {
            this.attributes = AbstractDocument.this.getAttributeContext().addAttribute(this.attributes, name, value);
        }

        @Override
        public void addAttributes(AttributeSet attrs) {
            this.attributes = AbstractDocument.this.getAttributeContext().addAttributes(this.attributes, attrs);
        }

        @Override
        public void removeAttribute(Object name) {
            this.attributes = AbstractDocument.this.getAttributeContext().removeAttribute(this.attributes, name);
        }

        @Override
        public void removeAttributes(AttributeSet attrs) {
            this.attributes = AbstractDocument.this.getAttributeContext().removeAttributes(this.attributes, attrs);
        }

        @Override
        public void removeAttributes(Enumeration<?> names) {
            this.attributes = AbstractDocument.this.getAttributeContext().removeAttributes(this.attributes, names);
        }

        @Override
        public void setResolveParent(AttributeSet parent) {
            this.attributes = AbstractDocument.this.getAttributeContext().addAttribute(this.attributes, ResolveAttribute, parent);
        }

        @Override
        public boolean containsAttribute(Object name, Object value) {
            return this.attributes.containsAttribute(name, value);
        }

        @Override
        public boolean containsAttributes(AttributeSet attrs) {
            return this.attributes.containsAttributes(attrs);
        }

        @Override
        public AttributeSet copyAttributes() {
            return this.attributes.copyAttributes();
        }

        @Override
        public Object getAttribute(Object key) {
            AttributeSet resParent;
            Object result = this.attributes.getAttribute(key);
            if (result == null && (resParent = this.getResolveParent()) != null) {
                result = resParent.getAttribute(key);
            }
            return result;
        }

        @Override
        public int getAttributeCount() {
            return this.attributes.getAttributeCount();
        }

        @Override
        public Enumeration<?> getAttributeNames() {
            return this.attributes.getAttributeNames();
        }

        @Override
        public AttributeSet getResolveParent() {
            return this.attributes.getResolveParent();
        }

        @Override
        public boolean isDefined(Object attrName) {
            return this.attributes.isDefined(attrName);
        }

        @Override
        public boolean isEqual(AttributeSet attrs) {
            return this.attributes.isEqual(attrs);
        }

        @Override
        public AttributeSet getAttributes() {
            return this;
        }

        @Override
        public Document getDocument() {
            return AbstractDocument.this;
        }

        @Override
        public abstract Element getElement(int var1);

        @Override
        public String getName() {
            return (String)this.attributes.getAttribute(AbstractDocument.ElementNameAttribute);
        }

        @Override
        public Element getParentElement() {
            return this.element_parent;
        }

        @Override
        public abstract int getEndOffset();

        @Override
        public abstract int getElementCount();

        @Override
        public abstract int getElementIndex(int var1);

        @Override
        public abstract int getStartOffset();

        public void dump(PrintStream stream, int indent) {
            StringBuffer b = new StringBuffer();
            int i = 0;
            while (i < indent) {
                b.append(' ');
                ++i;
            }
            b.append('<');
            b.append(this.getName());
            if (this.getAttributeCount() > 0) {
                b.append('\n');
                Enumeration<?> attNames = this.getAttributeNames();
                while (attNames.hasMoreElements()) {
                    int i2 = 0;
                    while (i2 < indent + 2) {
                        b.append(' ');
                        ++i2;
                    }
                    Object attName = attNames.nextElement();
                    b.append(attName);
                    b.append('=');
                    Object attribute = this.getAttribute(attName);
                    b.append(attribute);
                    b.append('\n');
                }
            }
            if (this.getAttributeCount() > 0) {
                i = 0;
                while (i < indent) {
                    b.append(' ');
                    ++i;
                }
            }
            b.append(">\n");
            if (this.isLeaf()) {
                i = 0;
                while (i < indent + 2) {
                    b.append(' ');
                    ++i;
                }
                int start = this.getStartOffset();
                int end = this.getEndOffset();
                b.append('[');
                b.append(start);
                b.append(',');
                b.append(end);
                b.append("][");
                try {
                    b.append(this.getDocument().getText(start, end - start));
                }
                catch (BadLocationException ex) {
                    AssertionError err = new AssertionError((Object)"BadLocationException must not be thrown here.");
                    ((Throwable)((Object)err)).initCause(ex);
                    throw err;
                }
                b.append("]\n");
            }
            stream.print(b.toString());
            int count = this.getElementCount();
            int i3 = 0;
            while (i3 < count) {
                Element el = this.getElement(i3);
                if (el instanceof AbstractElement) {
                    ((AbstractElement)el).dump(stream, indent + 2);
                }
                ++i3;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface AttributeContext {
        public AttributeSet addAttribute(AttributeSet var1, Object var2, Object var3);

        public AttributeSet addAttributes(AttributeSet var1, AttributeSet var2);

        public AttributeSet getEmptySet();

        public void reclaim(AttributeSet var1);

        public AttributeSet removeAttribute(AttributeSet var1, Object var2);

        public AttributeSet removeAttributes(AttributeSet var1, AttributeSet var2);

        public AttributeSet removeAttributes(AttributeSet var1, Enumeration<?> var2);
    }

    private class BidiElement
    extends LeafElement {
        BidiElement(Element parent, int start, int end, int level) {
            super(parent, new SimpleAttributeSet(), start, end);
            this.addAttribute(StyleConstants.BidiLevel, new Integer(level));
        }

        public String getName() {
            return AbstractDocument.BidiElementName;
        }
    }

    private class BidiRootElement
    extends BranchElement {
        BidiRootElement() {
            super(null, null);
        }

        public String getName() {
            return AbstractDocument.BidiRootName;
        }
    }

    public class BranchElement
    extends AbstractElement {
        private static final long serialVersionUID = -6037216547466333183L;
        private Element[] children;
        private int numChildren;
        private int lastIndex;

        public BranchElement(Element parent, AttributeSet attributes) {
            super(parent, attributes);
            this.children = new Element[1];
            this.numChildren = 0;
            this.lastIndex = -1;
        }

        public Enumeration children() {
            if (this.numChildren == 0) {
                return null;
            }
            Vector<Element> tmp = new Vector<Element>();
            int index = 0;
            while (index < this.numChildren) {
                tmp.add(this.children[index]);
                ++index;
            }
            return tmp.elements();
        }

        public boolean getAllowsChildren() {
            return true;
        }

        public Element getElement(int index) {
            if (index < 0 || index >= this.numChildren) {
                return null;
            }
            return this.children[index];
        }

        public int getElementCount() {
            return this.numChildren;
        }

        public int getElementIndex(int offset) {
            int i0 = 0;
            int i1 = this.numChildren - 1;
            int index = -1;
            int p0 = this.getStartOffset();
            if (this.numChildren == 0) {
                index = 0;
            } else if (offset >= this.getEndOffset()) {
                index = this.numChildren - 1;
            } else {
                int p1;
                if (this.lastIndex >= i0 && this.lastIndex <= i1) {
                    Element last = this.getElement(this.lastIndex);
                    p0 = last.getStartOffset();
                    p1 = last.getEndOffset();
                    if (offset >= p0 && offset < p1) {
                        index = this.lastIndex;
                    } else if (offset < p0) {
                        i1 = this.lastIndex;
                    } else {
                        i0 = this.lastIndex;
                    }
                }
                int i = 0;
                while (i0 <= i1 && index == -1) {
                    i = i0 + (i1 - i0) / 2;
                    Element el = this.getElement(i);
                    p0 = el.getStartOffset();
                    p1 = el.getEndOffset();
                    if (offset >= p0 && offset < p1) {
                        index = i;
                        continue;
                    }
                    if (offset < p0) {
                        i1 = i - 1;
                        continue;
                    }
                    i0 = i + 1;
                }
                if (index == -1) {
                    index = offset < p0 ? i : i + 1;
                }
                this.lastIndex = index;
            }
            return index;
        }

        public int getEndOffset() {
            Element child = this.numChildren > 0 ? this.children[this.numChildren - 1] : this.children[0];
            return child.getEndOffset();
        }

        public String getName() {
            return AbstractDocument.ParagraphElementName;
        }

        public int getStartOffset() {
            return this.children[0].getStartOffset();
        }

        public boolean isLeaf() {
            return false;
        }

        public Element positionToElement(int position) {
            int index = 0;
            while (index < this.numChildren) {
                Element elem = this.children[index];
                if (elem.getStartOffset() <= position && position < elem.getEndOffset()) {
                    return elem;
                }
                ++index;
            }
            return null;
        }

        public void replace(int offset, int length, Element[] elements) {
            int delta = elements.length - length;
            int copyFrom = offset + length;
            int copyTo = copyFrom + delta;
            int numMove = this.numChildren - copyFrom;
            if (this.numChildren + delta > this.children.length) {
                int newSize = Math.max(2 * this.children.length, this.numChildren + delta);
                Element[] target = new Element[newSize];
                System.arraycopy(this.children, 0, target, 0, offset);
                System.arraycopy(elements, 0, target, offset, elements.length);
                System.arraycopy(this.children, copyFrom, target, copyTo, numMove);
                this.children = target;
            } else {
                System.arraycopy(this.children, copyFrom, this.children, copyTo, numMove);
                System.arraycopy(elements, 0, this.children, offset, elements.length);
            }
            this.numChildren += delta;
        }

        public String toString() {
            return "BranchElement(" + this.getName() + ") " + this.getStartOffset() + "," + this.getEndOffset() + "\n";
        }
    }

    class Bypass
    extends DocumentFilter.FilterBypass {
        Bypass() {
        }

        public Document getDocument() {
            return AbstractDocument.this;
        }

        public void insertString(int offset, String string, AttributeSet attr) throws BadLocationException {
            AbstractDocument.this.insertStringImpl(offset, string, attr);
        }

        public void remove(int offset, int length) throws BadLocationException {
            AbstractDocument.this.removeImpl(offset, length);
        }

        public void replace(int offset, int length, String string, AttributeSet attrs) throws BadLocationException {
            AbstractDocument.this.replaceImpl(offset, length, string, attrs);
        }
    }

    public static interface Content {
        public Position createPosition(int var1) throws BadLocationException;

        public int length();

        public UndoableEdit insertString(int var1, String var2) throws BadLocationException;

        public UndoableEdit remove(int var1, int var2) throws BadLocationException;

        public String getString(int var1, int var2) throws BadLocationException;

        public void getChars(int var1, int var2, Segment var3) throws BadLocationException;
    }

    public class DefaultDocumentEvent
    extends CompoundEdit
    implements DocumentEvent {
        private static final long serialVersionUID = 5230037221564563284L;
        private static final int THRESHOLD = 10;
        private int offset;
        private int length;
        private DocumentEvent.EventType type;
        private HashMap changes;
        private boolean modified;

        public DefaultDocumentEvent(int offset, int length, DocumentEvent.EventType type) {
            this.offset = offset;
            this.length = length;
            this.type = type;
            this.modified = false;
        }

        public boolean addEdit(UndoableEdit edit) {
            if (this.changes == null && this.edits.size() > 10) {
                this.changes = new HashMap();
                int count = this.edits.size();
                int i = 0;
                while (i < count) {
                    Object o = this.edits.elementAt(i);
                    if (o instanceof DocumentEvent.ElementChange) {
                        DocumentEvent.ElementChange ec = (DocumentEvent.ElementChange)o;
                        this.changes.put(ec.getElement(), ec);
                    }
                    ++i;
                }
            }
            if (this.changes != null && edit instanceof DocumentEvent.ElementChange) {
                DocumentEvent.ElementChange elEdit = (DocumentEvent.ElementChange)((Object)edit);
                this.changes.put(elEdit.getElement(), elEdit);
            }
            return super.addEdit(edit);
        }

        public Document getDocument() {
            return AbstractDocument.this;
        }

        public int getLength() {
            return this.length;
        }

        public int getOffset() {
            return this.offset;
        }

        public DocumentEvent.EventType getType() {
            return this.type;
        }

        public DocumentEvent.ElementChange getChange(Element elem) {
            DocumentEvent.ElementChange change = null;
            if (this.changes != null) {
                change = (DocumentEvent.ElementChange)this.changes.get(elem);
            } else {
                int count = this.edits.size();
                int i = 0;
                while (i < count && change == null) {
                    DocumentEvent.ElementChange ec;
                    Object o = this.edits.get(i);
                    if (o instanceof DocumentEvent.ElementChange && elem.equals((ec = (DocumentEvent.ElementChange)o).getElement())) {
                        change = ec;
                    }
                    ++i;
                }
            }
            return change;
        }

        public String toString() {
            return this.edits.toString();
        }
    }

    public static class ElementEdit
    extends AbstractUndoableEdit
    implements DocumentEvent.ElementChange {
        private static final long serialVersionUID = -1216620962142928304L;
        private Element elem;
        private int index;
        private Element[] removed;
        private Element[] added;

        public ElementEdit(Element elem, int index, Element[] removed, Element[] added) {
            this.elem = elem;
            this.index = index;
            this.removed = removed;
            this.added = added;
        }

        public Element[] getChildrenAdded() {
            return this.added;
        }

        public Element[] getChildrenRemoved() {
            return this.removed;
        }

        public Element getElement() {
            return this.elem;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public class LeafElement
    extends AbstractElement {
        private static final long serialVersionUID = -8906306331347768017L;
        private Position startPos;
        private Position endPos;

        public LeafElement(Element parent, AttributeSet attributes, int start, int end) {
            super(parent, attributes);
            try {
                this.startPos = AbstractDocument.this.createPosition(start);
                this.endPos = AbstractDocument.this.createPosition(end);
            }
            catch (BadLocationException ex) {
                AssertionError as = new AssertionError((Object)("BadLocationException thrown here. start=" + start + ", end=" + end + ", length=" + AbstractDocument.this.getLength()));
                ((Throwable)((Object)as)).initCause(ex);
                throw as;
            }
        }

        public Enumeration children() {
            return null;
        }

        public boolean getAllowsChildren() {
            return false;
        }

        public Element getElement(int index) {
            return null;
        }

        public int getElementCount() {
            return 0;
        }

        public int getElementIndex(int offset) {
            return -1;
        }

        public int getEndOffset() {
            return this.endPos.getOffset();
        }

        public String getName() {
            String name = super.getName();
            if (name == null) {
                name = AbstractDocument.ContentElementName;
            }
            return name;
        }

        public int getStartOffset() {
            return this.startPos.getOffset();
        }

        public boolean isLeaf() {
            return true;
        }

        public String toString() {
            return "LeafElement(" + this.getName() + ") " + this.getStartOffset() + "," + this.getEndOffset() + "\n";
        }
    }
}

