/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.text.AttributedCharacterIterator;
import java.text.Format;
import java.text.ParseException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatter;

public class InternationalFormatter
extends DefaultFormatter {
    private static final long serialVersionUID = 2436068675711756856L;
    Format format = null;
    Comparable minimum = null;
    Comparable maximum = null;

    public InternationalFormatter() {
        this.setCommitsOnValidEdit(false);
        this.setOverwriteMode(false);
    }

    public InternationalFormatter(Format format) {
        this();
        this.setFormat(format);
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setMinimum(Comparable minValue) {
        this.minimum = minValue;
        if (this.valueClass == null && minValue != null) {
            this.valueClass = minValue.getClass();
        }
    }

    public Comparable getMinimum() {
        return this.minimum;
    }

    public void setMaximum(Comparable maxValue) {
        this.maximum = maxValue;
        if (this.valueClass == null && maxValue != null) {
            this.valueClass = maxValue.getClass();
        }
    }

    public Comparable getMaximum() {
        return this.maximum;
    }

    public void install(JFormattedTextField ftf) {
        super.install(ftf);
    }

    public String valueToString(Object value) throws ParseException {
        if (value == null) {
            return "";
        }
        if (this.format != null) {
            return this.format.format(value);
        }
        return super.valueToString(value);
    }

    public Object stringToValue(String string) throws ParseException {
        if (this.format != null) {
            Object o = this.format.parseObject(string);
            if (this.valueClass != null) {
                o = super.stringToValue(o.toString());
            }
            if (this.minimum != null && this.minimum.compareTo(o) > 0) {
                throw new ParseException("The value may not be less than the specified minimum", 0);
            }
            if (this.maximum != null && this.maximum.compareTo(o) < 0) {
                throw new ParseException("The value may not be greater than the specified maximum", 0);
            }
            return o;
        }
        return super.stringToValue(string);
    }

    public Format.Field[] getFields(int offset) {
        AttributedCharacterIterator aci = this.format.formatToCharacterIterator(this.getFormattedTextField().getValue());
        aci.setIndex(offset);
        Map<AttributedCharacterIterator.Attribute, Object> atts = aci.getAttributes();
        Set<AttributedCharacterIterator.Attribute> keys = atts.keySet();
        Format.Field[] fields = new Format.Field[keys.size()];
        int index = 0;
        Iterator<AttributedCharacterIterator.Attribute> i = keys.iterator();
        while (i.hasNext()) {
            fields[index] = (Format.Field)i.next();
            ++index;
        }
        return fields;
    }

    public Object clone() throws CloneNotSupportedException {
        Object clone = super.clone();
        return clone;
    }

    protected Action[] getActions() {
        return super.getActions();
    }
}

