/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.javah;

import gnu.classpath.tools.javah.ClassWrapper;
import gnu.classpath.tools.javah.CniPrintStream;
import gnu.classpath.tools.javah.Keywords;
import java.lang.reflect.Modifier;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.FieldNode;

public class FieldHelper {
    public static boolean print(CniPrintStream out, FieldNode field, ClassWrapper superType, boolean hasMethodName) {
        out.setModifiers(field.access);
        out.print("  ");
        if (Modifier.isStatic(field.access)) {
            out.print("static ");
        }
        if (field.value instanceof Integer || field.value instanceof Long) {
            out.print("const ");
        }
        out.print(Type.getType((String)field.desc));
        out.print(" ");
        if (Modifier.isVolatile(field.access)) {
            out.print("volatile ");
        }
        boolean result = false;
        if (superType != null && !Modifier.isStatic(field.access)) {
            out.print("__attribute__((aligned(__alignof__( ");
            superType.print(out);
            out.print(")))) ");
            result = true;
        }
        out.print(Keywords.getCxxName(field.name));
        if (hasMethodName) {
            out.print("__");
        }
        if (Modifier.isStatic(field.access)) {
            if (field.value instanceof Integer) {
                out.print(" = ");
                int val = (Integer)field.value;
                if (val == Integer.MIN_VALUE) {
                    out.print("-2147483647 - 1");
                } else {
                    out.print(val);
                }
            } else if (field.value instanceof Long) {
                out.print(" = ");
                long val = (Long)field.value;
                if (val == Long.MIN_VALUE) {
                    out.print("-9223372036854775807LL - 1");
                } else {
                    out.print(val);
                    out.print("LL");
                }
            }
        }
        out.println(";");
        return result;
    }
}

