<?php
/** Literary Chinese (文言)
 *
 * See MessagesQqq.php for message documentation incl. usage of parameters
 * To improve a translation please visit http://translatewiki.net
 *
 * @ingroup Language
 * @file
 *
 * @author Itsmine
 * @author Omnipaedista
 * @author Shinjiman
 */

/**
 * A list of date format preference keys which can be selected in user
 * preferences. New preference keys can be added, provided they are supported
 * by the language class's timeanddate(). Only the 5 keys listed below are
 * supported by the wikitext converter (DateFormatter.php).
 *
 * The special key "default" is an alias for either dmy or mdy depending on
 * $wgAmericanDates
 */
$datePreferences = array(
	'default',
	'ISO 8601',
);

$defaultDateFormat = 'zh';

/**
 * These are formats for dates generated by MediaWiki (as opposed to the wikitext
 * DateFormatter). Documentation for the format string can be found in
 * Language.php, search for sprintfDate.
 *
 * This array is automatically inherited by all subclasses. Individual keys can be
 * overridden.
 */
$dateFormats = array(
        'zh time' => 'H時i分',
        'zh date' => 'Y年n月j日 （l）',
        'zh both' => 'Y年n月j日 （D） H時i分',
);

$linkTrail = '/^([a-z]+)(.*)$/sD';

$digitTransformTable = array(
	'0' => '〇',
	'1' => '一',
	'2' => '二',
	'3' => '三',
	'4' => '四',
	'5' => '五',
	'6' => '六',
	'7' => '七',
	'8' => '八',
	'9' => '九',
	'.' => '點',
	',' => '',
);

#-------------------------------------------------------------------
# Default messages
#-------------------------------------------------------------------
# Allowed characters in keys are: A-Z, a-z, 0-9, underscore (_) and
# hyphen (-). If you need more characters, you may be able to change
# the regex in MagicWord::initRegex

$messages = array(
# User preference toggles
'tog-underline'               => '鏈墊線：',
'tog-highlightbroken'         => '<a href="" class="new">斷鏈</a>，以<a href="" class="internal">？</a>替',
'tog-justify'                 => '齊段落',
'tog-hideminor'               => '隱近校',
'tog-hidepatrolled'           => '隱近巡',
'tog-newpageshidepatrolled'   => '隱新巡',
'tog-extendwatchlist'         => '展列見變',
'tog-usenewrc'                => '青出近易（JavaScript）',
'tog-numberheadings'          => '生章數',
'tog-showtoolbar'             => '多寶列見（JavaScript）',
'tog-editondblclick'          => '纂頁雙擊（JavaScript）',
'tog-editsection'             => '纂段擊鏈',
'tog-editsectiononrightclick' => '纂段右擊標（JavaScript）',
'tog-showtoc'                 => '四章見目',
'tog-rememberpassword'        => '符節通越',
'tog-editwidth'               => '纂幅全',
'tog-watchcreations'          => '哨己撰',
'tog-watchdefault'            => '哨己纂',
'tog-minordefault'            => '慣為校',
'tog-previewontop'            => '頂草覽',
'tog-previewonfirst'          => '覽首修',
'tog-nocache'                 => '莫謄文',
'tog-enotifwatchlistpages'    => '哨新，遣函',
'tog-enotifusertalkpages'     => '議新，遣函',
'tog-enotifminoredits'        => '校新，遣函',
'tog-enotifrevealaddr'        => '列余址於書內',
'tog-shownumberswatching'     => '放哨有',
'tog-oldsig'                  => '覽原署名：',
'tog-fancysig'                => '署以本碼待之（免自連）',
'tog-externaleditor'          => '它器修文（高人用，需設之。[http://www.mediawiki.org/wiki/Manual:External_editors 閱。]）',
'tog-externaldiff'            => '它器修異（高人用，需設之。[http://www.mediawiki.org/wiki/Manual:External_editors 閱。]）',
'tog-showjumplinks'           => '鏈往字',
'tog-uselivepreview'          => '即覽嚐鮮（JavaScript）',
'tog-forceeditsummary'        => '漏概醒之',
'tog-watchlisthideown'        => '不哨己文',
'tog-watchlisthidebots'       => '不哨僕文',
'tog-watchlisthideminor'      => '不哨小纂',
'tog-watchlisthideliu'        => '不哨有簿',
'tog-watchlisthideanons'      => '不哨無簿',
'tog-watchlisthidepatrolled'  => '不哨已巡',
'tog-nolangconversion'        => '非轉',
'tog-ccmeonemails'            => '凡所遺書，請存副本。',
'tog-diffonly'                => '異下無示頁',
'tog-showhiddencats'          => '示隱類',
'tog-noconvertlink'           => '非轉鍵題',
'tog-norollbackdiff'          => '轉後略異',

'underline-always'  => '恆',
'underline-never'   => '絕',
'underline-default' => '慣',

# Font style option in Special:Preferences
'editfont-style'     => '纂字樣：',
'editfont-default'   => '慣',
'editfont-monospace' => '固字',
'editfont-sansserif' => '哥特字',
'editfont-serif'     => '宋明字',

# Dates
'sunday'        => '週日',
'monday'        => '週一',
'tuesday'       => '週二',
'wednesday'     => '週三',
'thursday'      => '週四',
'friday'        => '週五',
'saturday'      => '週六',
'sun'           => '週日',
'mon'           => '周一',
'tue'           => '周二',
'wed'           => '周三',
'thu'           => '周四',
'fri'           => '周五',
'sat'           => '周六',
'january'       => '一月',
'february'      => '二月',
'march'         => '三月',
'april'         => '四月',
'may_long'      => '五月',
'june'          => '六月',
'july'          => '七月',
'august'        => '八月',
'september'     => '九月',
'october'       => '十月',
'november'      => '十一月',
'december'      => '十二月',
'january-gen'   => '一月',
'february-gen'  => '二月',
'march-gen'     => '三月',
'april-gen'     => '四月',
'may-gen'       => '五月',
'june-gen'      => '六月',
'july-gen'      => '七月',
'august-gen'    => '八月',
'september-gen' => '九月',
'october-gen'   => '十月',
'november-gen'  => '十一月',
'december-gen'  => '十二月',
'jan'           => '一月',
'feb'           => '二月',
'mar'           => '三月',
'apr'           => '四月',
'may'           => '五月',
'jun'           => '六月',
'jul'           => '七月',
'aug'           => '八月',
'sep'           => '九月',
'oct'           => '十月',
'nov'           => '十一月',
'dec'           => '十二月',

# Categories related messages
'pagecategories'                 => '$1類',
'category_header'                => '「$1」中之頁',
'subcategories'                  => '次類',
'category-media-header'          => '「$1」中之媒',
'category-empty'                 => "''無頁或媒也。''",
'hidden-categories'              => '$1隱類',
'hidden-category-category'       => '隱類',
'category-subcat-count'          => '{{PLURAL:$2|門有戶壹。|門有戶$1，有$2戶也。}}',
'category-subcat-count-limited'  => '門有戶$1。',
'category-article-count'         => '{{PLURAL:$2|門有頁壹。|門有頁$1，有$2頁也。}}',
'category-article-count-limited' => '門有頁$1。',
'category-file-count'            => '{{PLURAL:$2|門有檔壹。|門有檔$1，有$2檔也。}}',
'category-file-count-limited'    => '門有檔$1。',
'listingcontinuesabbrev'         => '續',
'index-category'                 => '已索之頁',
'noindex-category'               => '未索之頁',

'mainpagetext'      => "'''共筆臺已立'''",
'mainpagedocfooter' => "欲識維基，見[http://meta.wikimedia.org/wiki/Help:Contents User's Guide]

== 始 ==

* [http://www.mediawiki.org/wiki/Manual:Configuration_settings Configuration settings list]
* [http://www.mediawiki.org/wiki/Manual:FAQ MediaWiki FAQ]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki release mailing list]",

'about'         => '述',
'article'       => '文',
'newwindow'     => '啟窗',
'cancel'        => '捨',
'moredotdotdot' => '見逾',
'mypage'        => '寒舍',
'mytalk'        => '書房',
'anontalk'      => '與（IP）私議',
'navigation'    => '導',
'and'           => '與',

# Cologne Blue skin
'qbfind'         => '尋',
'qbbrowse'       => '覽',
'qbedit'         => '纂',
'qbpageoptions'  => '此頁',
'qbpageinfo'     => '內文',
'qbmyoptions'    => '吾好',
'qbspecialpages' => '非凡',
'faq'            => '頻答問',
'faqpage'        => 'Project:頻答問',

# Vector skin
'vector-action-addsection'   => '入題',
'vector-action-delete'       => '刪',
'vector-action-move'         => '遷',
'vector-action-protect'      => '緘',
'vector-action-undelete'     => '覽刪',
'vector-action-unprotect'    => '啟',
'vector-namespace-category'  => '類',
'vector-namespace-help'      => '助',
'vector-namespace-image'     => '檔',
'vector-namespace-main'      => '文',
'vector-namespace-media'     => '雅',
'vector-namespace-mediawiki' => '訊',
'vector-namespace-project'   => '策',
'vector-namespace-special'   => '奇',
'vector-namespace-talk'      => '議',
'vector-namespace-template'  => '模',
'vector-namespace-user'      => '齋',
'vector-view-create'         => '立',
'vector-view-edit'           => '纂',
'vector-view-history'        => '覽史',
'vector-view-view'           => '閱',
'vector-view-viewsource'     => '覽源',
'actions'                    => '動',
'namespaces'                 => '名集',
'variants'                   => '變字',

'errorpagetitle'    => '誤',
'returnto'          => '返$1。',
'tagline'           => '語出{{SITENAME}}',
'help'              => '助',
'search'            => '尋',
'searchbutton'      => '尋',
'go'                => '往',
'searcharticle'     => '始',
'history'           => '誌',
'history_short'     => '誌',
'updatedmarker'     => '新也',
'info_short'        => '快訊',
'printableversion'  => '印本',
'permalink'         => '恆鏈',
'print'             => '印',
'edit'              => '纂',
'create'            => '立',
'editthispage'      => '纂',
'create-this-page'  => '立',
'delete'            => '刪',
'deletethispage'    => '刪',
'undelete_short'    => '還$1已刪',
'protect'           => '緘',
'protect_change'    => '易',
'protectthispage'   => '緘封',
'unprotect'         => '啟',
'unprotectthispage' => '啟函',
'newpage'           => '新頁',
'talkpage'          => '參議此文',
'talkpagelinktext'  => '議',
'specialpage'       => '特查',
'personaltools'     => '家私',
'postcomment'       => '評',
'articlepage'       => '閱內文',
'talk'              => '議',
'views'             => '覽',
'toolbox'           => '多寶',
'userpage'          => '簿',
'projectpage'       => '計畫',
'imagepage'         => '述',
'mediawikipage'     => '觀訊',
'templatepage'      => '鑄模',
'viewhelppage'      => '助文',
'categorypage'      => '分類',
'viewtalkpage'      => '見議',
'otherlanguages'    => '他山',
'redirectedfrom'    => '（渡自$1）',
'redirectpagesub'   => '渡',
'lastmodifiedat'    => '此頁於$1$2方易。',
'viewcount'         => '此頁$1閱矣',
'protectedpage'     => '此頁錮矣',
'jumpto'            => '往：',
'jumptonavigation'  => '嚮',
'jumptosearch'      => '尋',
'view-pool-error'   => '歉也，伺服器超負矣。
多簿查頁。
欲試候之。

$1',

# All link text and link target definitions of links into project namespace that get used by other message strings, with the exception of user group pages (see grouppage) and the disambiguation template definition (see disambiguations).
'aboutsite'            => '述{{SITENAME}}',
'aboutpage'            => 'Project:述',
'copyright'            => '文奉$1行。',
'copyrightpage'        => '{{ns:project}}:版權',
'currentevents'        => '世事',
'currentevents-url'    => 'Project:世事',
'disclaimers'          => '免責宣',
'disclaimerpage'       => 'Project:免責宣',
'edithelp'             => '助纂塾',
'edithelppage'         => 'Help:纂',
'helppage'             => 'Help:目錄',
'mainpage'             => '卷首',
'mainpage-description' => '卷首',
'policy-url'           => 'Project:策',
'portal'               => '市集',
'portal-url'           => 'Project:市集',
'privacy'              => '隱私通例',
'privacypage'          => 'Project:隱私通例',

'badaccess'        => '子未逮',
'badaccess-group0' => '子未逮，歉限之。',
'badaccess-groups' => '子未逮，歉限之有{{PLURAL:$2|一|多}}：$1',

'versionrequired'     => '惠置$1媒維基',
'versionrequiredtext' => '惠置$1媒維基，見[[Special:Version|版]]。',

'ok'                      => '可',
'retrievedfrom'           => '取自"$1"',
'youhavenewmessages'      => '子有$1（$2）',
'newmessageslink'         => '新訊',
'newmessagesdifflink'     => '變更',
'youhavenewmessagesmulti' => '新訊於$1',
'editsection'             => '纂',
'editold'                 => '纂',
'viewsourceold'           => '察源碼',
'editlink'                => '纂',
'viewsourcelink'          => '察源碼',
'editsectionhint'         => '纂 $1',
'toc'                     => '章',
'showtoc'                 => '示',
'hidetoc'                 => '藏',
'thisisdeleted'           => '還$1或閱之？',
'viewdeleted'             => '閱$1之？',
'restorelink'             => '$1已刪',
'feedlinks'               => '源︰',
'feed-unavailable'        => '聯合源無視也',
'site-rss-feed'           => '$1之RSS源',
'site-atom-feed'          => '$1之Atom源',
'page-rss-feed'           => '「$1」之RSS源',
'page-atom-feed'          => '「$1」之Atom源',
'red-link-title'          => '$1（查無此頁）',

# Short words for each namespace, by default used in the namespace tab in monobook
'nstab-main'      => '文',
'nstab-user'      => '齋',
'nstab-media'     => '雅',
'nstab-special'   => '奇',
'nstab-project'   => '策',
'nstab-image'     => '檔',
'nstab-mediawiki' => '訊',
'nstab-template'  => '模',
'nstab-help'      => '助',
'nstab-category'  => '類',

# Main script and global functions
'nosuchaction'      => '無可為',
'nosuchactiontext'  => '無此址',
'nosuchspecialpage' => '無此特查',
'nospecialpagetext' => '<strong>無此特查。</strong>

見[[Special:SpecialPages|{{int:specialpages}}]]。',

# General errors
'error'                => '有誤',
'databaseerror'        => '庫藏誤然',
'dberrortext'          => '問庫語誤，或軟體瑕焉。
末語道：
<blockquote><tt>$1</tt></blockquote>
內此函式"<tt>$2</tt>".
庫藏報有誤"<tt>$3: $4</tt>"。',
'dberrortextcl'        => '庫藏問語有誤，末道：
"$1"
內此函式"$2".
庫藏報有誤"$3: $4"',
'laggedslavemode'      => '警示，此頁不新',
'readonly'             => '鎖庫藏',
'enterlockreason'      => '何以鎖之？何日啟之？',
'readonlytext'         => '鎖者曰：「$1」，庫藏鎖矣，撰纂謝焉。',
'missing-article'      => '或舊、或刪，未見昔者"$1" $2。

若非此故，恐有瑕焉，惠呈此址也。',
'missingarticle-rev'   => '（審號：$1）',
'missingarticle-diff'  => '（異：$1，$2）',
'internalerror'        => '家誤',
'internalerror_info'   => '家誤：$1',
'fileappenderrorread'  => '當附時無讀 "$1"，未可為也。',
'fileappenderror'      => '"$2"附"$1"，未可為也。',
'filecopyerror'        => '"$1"謄"$2"，未可為也。',
'filerenameerror'      => '"$2"替"$1"名，未可為也。',
'filedeleteerror'      => '"$1"未可刪也。',
'directorycreateerror' => '立目"$1"，未可為也。',
'filenotfound'         => '"$1"未見。',
'fileexistserror'      => '"$1"存焉，未可儲也。',
'unexpected'           => '異數，"$1"="$2"。',
'formerror'            => '有誤：表不可呈',
'badarticleerror'      => '此頁莫為之',
'cannotdelete'         => '頁或檔"$1"刪矣，不復為之。',
'badtitle'             => '無此題',
'badtitletext'         => '或別、或缺、或違、或他山謬鏈，此題不存也。',
'perfcached'           => '下為謄本，恐不新也。',
'perfcachedts'         => '下為謄本，$1新之。',
'wrong_wfQuery_params' => 'wfQuery（）參數謬然<br />
函式： $1<br />
問語： $2',
'viewsource'           => '覽源',
'viewsourcefor'        => '$1',
'actionthrottled'      => '無為',
'actionthrottledtext'  => '基反垃圾之量，於短時中限欲，爾之上限已過。數分後再試之。',
'protectedpagetext'    => '該頁被錮無纂也。',
'viewsourcetext'       => '爾可視及複之本頁之原始碼。',
'protectedinterface'   => '此頁司版，錮之以遠濫。',
'editinginterface'     => "'''警示：'''此頁司版，一髮牽身，惠慎之。如譯之，可慮[http://translatewiki.net/wiki/Main_Page?setlang=zh-hant translatewiki.net]也，為MediaWiki軟件本地化之計劃也。",
'sqlhidden'            => '（SQL隱然）',
'cascadeprotected'     => '此頁"迭緘"矣。$1頁牽連如下：
$2',
'namespaceprotected'   => "子權未逮，莫能纂'''$1'''。",
'customcssjsprotected' => '牽他人，子權未逮，莫能纂之。',
'ns-specialprotected'  => '奇頁禁纂也。',
'titleprotected'       => "緘焉自[[User:$1|$1]]防建也。因''$2''也。",

# Virus scanner
'virus-badscanner'     => "壞設：不明之病掃：''$1''",
'virus-scanfailed'     => '敗掃（碼$1）',
'virus-unknownscanner' => '不明之反毒：',

# Login and logout pages
'logouttext'                 => "'''子去簿矣'''

子可匿名還覽{{SITENAME}}，或[[Special:UserLogin|復登]]同簿、異簿。
未清謄本，覽器文舊，且慎之。",
'welcomecreation'            => '== $1大駕光臨! ==
子簿增矣，敬更[[Special:Preferences|簿註]]。',
'yourname'                   => '名',
'yourpassword'               => '符節',
'yourpasswordagain'          => '復核節',
'remembermypassword'         => '記之',
'externaldberror'            => '認庫之錯或禁更爾之外簿。',
'login'                      => '登簿',
'nav-login-createaccount'    => '登簿、增簿',
'loginprompt'                => '登簿{{SITENAME}}須cookies，請准之。',
'userlogin'                  => '登簿、增簿',
'userloginnocreate'          => '登簿',
'logout'                     => '去簿',
'userlogout'                 => '去簿',
'notloggedin'                => '尚未登簿',
'nologin'                    => '無簿乎？往$1。',
'nologinlink'                => '增簿',
'createaccount'              => '增簿',
'gotaccount'                 => '有簿矣哉？往$1。',
'gotaccountlink'             => '登簿',
'createaccountmail'          => '同郵',
'badretype'                  => '符節不合也。',
'userexists'                 => '簿名存矣，惠更之',
'loginerror'                 => '登簿誤然',
'createaccounterror'         => '無增簿：$1',
'nocookiesnew'               => '{{SITENAME}}簿增而未登，惠准cookies後再登之。',
'nocookieslogin'             => '登簿{{SITENAME}}須cookies，惠准之後登。',
'noname'                     => '缺簿名，或不格也。',
'loginsuccesstitle'          => '登簿成矣',
'loginsuccess'               => "'''$1'''登{{SITENAME}}矣",
'nosuchuser'                 => '查無此人。',
'nosuchusershort'            => '查無"<nowiki>$1</nowiki>"，惠核之。',
'nouserspecified'            => '簿名須也',
'login-userblocked'          => '此簿已被封。登無簿也。',
'wrongpassword'              => '符節不合，惠核之。',
'wrongpasswordempty'         => '缺符節，惠補之。',
'passwordtooshort'           => '符節莫逾$1字。',
'password-name-match'        => '符節與簿名異也。',
'mailmypassword'             => '遣吾符節',
'passwordremindertitle'      => '新臨符節自{{SITENAME}}',
'passwordremindertext'       => '$1求遣{{SITENAME}}（$4）："$2"之臨符節為"$3"。日到有$5。

子若罔須或省更之，如舊即可。',
'noemail'                    => '"$1"無存郵也。',
'noemailcreate'              => '爾需乙郵也',
'passwordsent'               => '新節已遣$1"，惠鑒復登之。',
'blocked-mailpassword'       => '爾之IP已錮，密復無用之，以之濫也。',
'eauthentsent'               => '核文遣矣。惠循核之，簿方活也。',
'throttled-mailpassword'     => '密記已寄之於$1時前。
防濫，單一密記短至$1時寄之。',
'mailerror'                  => '信失遣如下：$1',
'acct_creation_throttle_hit' => '一日之內，但許一註。',
'emailauthenticated'         => '$2 $3郵驛證矣',
'emailnotauthenticated'      => '郵驛<strong>未證</strong>，下不遺書。',
'noemailprefs'               => '郵驛設而用之。',
'emailconfirmlink'           => '惠考郵驛',
'invalidemailaddress'        => '驛址不格，惠正略之。',
'accountcreated'             => '簿增矣',
'accountcreatedtext'         => '$1簿增矣',
'createaccount-title'        => '於{{SITENAME}}增簿',
'createaccount-text'         => '有人於{{SITENAME}}用爾之電郵增名為 "$2" 之簿 （$4），符節為 "$3" 。汝應登，再改符節也。

如簿誤增，爾可略之。',
'usernamehasherror'          => '簿名無含切細符也',
'login-throttled'            => '爾多試於此簿登中。
請候再試之。',
'loginlanguagelabel'         => '語：$1',
'suspicious-userlogout'      => '爾欲無離也，可由壞瀏覽器或快枝代理呈送之。',

# Password reset dialog
'resetpass'                 => '變符',
'resetpass_announce'        => '爾乃過郵之臨符登之。要完登，汝乃需設新符節：',
'resetpass_text'            => '<!-- 加字 -->',
'resetpass_header'          => '改簿符',
'oldpassword'               => '舊符節：',
'newpassword'               => '新符節：',
'retypenew'                 => '重察新符節：',
'resetpass_submit'          => '設符再登',
'resetpass_success'         => '爾之符節已改！
現登簿中...',
'resetpass_forbidden'       => '無改符節',
'resetpass-no-info'         => '爾須登簿後方進此頁。',
'resetpass-submit-loggedin' => '改符節',
'resetpass-submit-cancel'   => '消',
'resetpass-wrong-oldpass'   => '無效之臨符或現符。
爾或改符，或求新臨符。',
'resetpass-temp-password'   => '臨符節:',

# Edit page toolbar
'bold_sample'     => '粗體',
'bold_tip'        => '粗體',
'italic_sample'   => '斜體',
'italic_tip'      => '斜體',
'link_sample'     => '鏈',
'link_tip'        => '鏈內',
'extlink_sample'  => 'http://www.example.com 鍵 題',
'extlink_tip'     => '冠http://以鏈外',
'headline_sample' => '題',
'headline_tip'    => '二題',
'math_sample'     => '此書方程式',
'math_tip'        => '數學方程式（LaTeX）',
'nowiki_sample'   => '此不排版',
'nowiki_tip'      => '不排維基之版',
'image_tip'       => '嵌檔',
'media_tip'       => '鏈檔',
'sig_tip'         => '署名刻時',
'hr_tip'          => '縱線，慎用之',

# Edit pages
'summary'                          => '概:',
'subject'                          => '題:',
'minoredit'                        => '令校',
'watchthis'                        => '派哨',
'savearticle'                      => '存儲',
'preview'                          => '草覽',
'showpreview'                      => '草覽',
'showlivepreview'                  => '即覽',
'showdiff'                         => '示異',
'anoneditwarning'                  => "'''警示：'''子未登簿，IP將誌。",
'missingsummary'                   => "'''醒示：'''子未概之，復「{{int:savearticle}}」則文倍焉。",
'missingcommenttext'               => '請贊之',
'summary-preview'                  => '覽概：',
'subject-preview'                  => '覽題：',
'blockedtitle'                     => '子見禁',
'blockedtext'                      => "'''子名、IP見禁。'''禁者$1也，因''$2''故。

* 始之時為：$8
* 終之時為：$6
* 見禁之人：$7

存惑可詢$1，或[[{{MediaWiki:Grouppage-sysop}}|有秩]]，[[Special:Preferences|簿註]]無驛則信不遣。另，子IP為$3，其禁號為#$5。詢時切附之。",
'autoblockedtext'                  => "爾之IP或簿自禁，因簿先用，禁者$1也。因故：:\\'\\'$2\\'\\'

* 始之時為：$8
* 終之時為：$6
* 見禁之人：$7

存惑可詢$1，或[[{{MediaWiki:Grouppage-sysop}}|有秩]]，[[Special:Preferences|簿註]]無驛則信不遣。另，子用IP $3，禁號為#$5。詢時切附之。",
'blockedoriginalsource'            => "'''$1'''本源如下：",
'blockededitsource'                => "子'''$1纂文'''如下：",
'whitelistedittitle'               => '登簿以纂',
'whitelistedittext'                => '$1後方可纂文。',
'confirmedittext'                  => '驛證方可纂文。惠見[[Special:Preferences|簿註]]。',
'nosuchsectiontitle'               => '無尋節',
'nosuchsectiontext'                => '爾纂之節無存也。
機以察時遷或刪之。',
'loginreqtitle'                    => '須登簿',
'loginreqlink'                     => '登簿',
'loginreqpagetext'                 => '$1以覽它頁。',
'accmailtitle'                     => '符節傳矣',
'accmailtext'                      => '"$1"符節至$2矣',
'newarticle'                       => '撰',
'newarticletext'                   => '此頁尚缺。欲補，撰於下，有惑見[[{{MediaWiki:Helppage}}|助]]。
誤入者，返前即可。',
'anontalkpagetext'                 => "----''此匿論也，為未簿或不簿者設，IP俱錄以辨人焉。然IP不獨，恐生亂象，不喜惠[[Special:UserLogin/signup|增]][[Special:UserLogin|登簿]]遠之。",
'noarticletext'                    => '查無此文。[[Special:Search/{{PAGENAME}}|尋題]]，
<span class="plainlinks">[{{fullurl:{{#Special:Log}}|page={{FULLPAGENAMEE}}}} 尋誌]，
或[{{fullurl:{{FULLPAGENAME}}|action=edit}} 纂頁]</span>。',
'noarticletext-nopermission'       => '查無此文。[[Special:Search/{{PAGENAME}}|尋題]]，或<span class="plainlinks">[{{fullurl:{{#Special:Log}}|page={{FULLPAGENAMEE}}}} 尋誌]</span>。',
'userpage-userdoesnotexist'        => '「$1」之簿未增也。請建纂本頁前查之。',
'userpage-userdoesnotexist-view'   => '「$1」之簿未增也。',
'blocked-notice-logextract'        => '該簿現鎖也。
下列之記鎖，以察之：',
'clearyourcache'                   => "'''註：'''重取頁面，文方新焉。
'''Mozilla / Firefox / Safari:'''押''Shift''並點''重新載入''，或合鍵''Ctrl-F5''或''Ctrl-R''（Macintosh為''Command-R''）。
'''Konqueror:'''點''Reload''，或押''F5''。
：''Opera:'''須至''Tools→Preferences''清謄本。
'''Internet Explorer:'''押''Ctrl''並點''重新整理''，或合鍵''Ctrl-F5''。",
'usercssyoucanpreview'             => "'''訣：'''CSS應先「{{int:showpreview}}」而後存。",
'userjsyoucanpreview'              => "'''訣：'''JavaScript應先「{{int:showpreview}}」而後存。",
'usercsspreview'                   => "'''預覽簿CSS。'''
'''尚未儲焉！'''",
'userjspreview'                    => "'''預覽簿JavaScript。'''
'''尚未儲焉！'''",
'userinvalidcssjstitle'            => "'''警：'''\"\$1\"無此面版。自製者，全名務小寫，如{{ns:user}}:Foo/monobook.css 而非{{ns:user}}:Foo/Monobook.css",
'updated'                          => '（新）',
'note'                             => "'''註'''",
'previewnote'                      => "'''此乃預覽，尚未儲焉。'''",
'session_fail_preview'             => "'''歉哉有變，子纂未存焉，惠再之。如復不成，[[Special:UserLogout|重登]]再試也。'''",
'session_fail_preview_html'        => "'''歉哉有變，子纂未存焉'''

''此維基亦合純HTML，除預覽以遠惡JavaScript侵。''
'''纂文若合，惠再之。如復不成，簿[[Special:UserLogout|重登]]焉。'''",
'token_suffix_mismatch'            => "'''君修見拒，蓋因代理之故，亂事見兮。'''",
'editing'                          => '纂$1',
'editingsection'                   => '纂節$1',
'editingcomment'                   => '贊$1',
'editconflict'                     => '纂沖$1',
'explainconflict'                  => "子纂與他人沖，上者時也，下者子也，望子合之。
註，'''{{int:savearticle}}'''上文儲焉",
'yourtext'                         => '子也',
'storedversion'                    => '時也',
'nonunicodebrowser'                => "'''警示：覽器不識萬國碼，以十六進位數代之，以保纂可也。'''",
'editingold'                       => "''''''警示'''子纂舊然。強儲之，則新易失焉。'''",
'yourdiff'                         => '異',
'copyrightwarning'                 => "{{SITENAME}}全文皆循$2，詳見$1。不喜他纂，但去可矣。文務親撰，或謄公本，
'''萬勿盜版！'''",
'copyrightwarning2'                => "{{SITENAME}}全文，允眾人撰、纂、刪、校。不喜他纂，但去可矣。<br />
文務親撰，或謄公本，如$1。'''萬勿盜版！'''",
'longpagewarning'                  => "'''警示：此頁長$1仟位元組，逾卅二，覽器恐不盡堪，望縮斷之。'''",
'longpageerror'                    => "'''警示：文長$1仟位元組，越幅$2，未能儲焉。'''",
'readonlywarning'                  => "'''警示：修庫藏，存儲謝焉。惠謄文備用之。'''

鎖者曰：「$1」",
'protectedpagewarning'             => "'''警示：庫藏錮矣，惟有秩纂之。'''
近誌下曰參詳之：",
'semiprotectedpagewarning'         => "'''註記'''庫藏錮矣，惟登簿纂之。
近誌下曰參詳之：",
'cascadeprotectedwarning'          => "'''警示：'''此頁錮矣，唯有秩纂之，乃因{{PLURAL:$1|一|多}}頁連誅之：",
'titleprotectedwarning'            => "'''警告：此頁錮矣，乃需[[Special:ListGroupRights|權]]用之。'''
近誌下曰參詳之：",
'templatesused'                    => '此文用模：',
'template-protected'               => '（錮）',
'template-semiprotected'           => '（半錮）',
'hiddencategories'                 => '此頁屬隱類之員有$1：',
'nocreatetitle'                    => '新題謝焉',
'nocreatetext'                     => '舊題可修，新題謝焉。[[Special:UserLogin|登簿、增簿]]以逮權也。',
'nocreate-loggedin'                => '子權未逮，新頁謝焉。',
'sectioneditnotsupported-title'    => '不纂持節',
'sectioneditnotsupported-text'     => '此頁不持纂節也。',
'permissionserrors'                => '權未逮也',
'permissionserrorstext'            => '子權未逮，有{{PLURAL:$1|因|因}}如下：',
'permissionserrorstext-withaction' => '子權未逮，有{{PLURAL:$1|因|因}}如$2：',
'recreate-moveddeleted-warn'       => "'''留意：刪文復造，惠慎纂。'''
誌刪遷如下：",
'moveddeleted-notice'              => '此頁刪矣。
此頁之誌刪遷參留之。',
'log-fulllog'                      => '閱誌全',
'edit-hook-aborted'                => '鈎纂消矣。
無解也。',
'edit-gone-missing'                => '無更頁。
刪之也。',
'edit-conflict'                    => '纂突。',
'edit-no-change'                   => '爾之纂已略，由字無改也。',
'edit-already-exists'              => '不建新頁。
已存也。',

# Parser/template warnings
'expensive-parserfunction-warning'        => '警：頁有多貴功呼。

其須少$2呼，現有$1呼。',
'expensive-parserfunction-category'       => '頁有多貴功呼',
'post-expand-template-inclusion-warning'  => '警：含模過大也。
一些模板將不會包含。',
'post-expand-template-inclusion-category' => '模含上限已超之頁',
'post-expand-template-argument-warning'   => '警：此頁有至少一模數展大。
數略之。',
'post-expand-template-argument-category'  => '含略模數之頁',
'parser-template-loop-warning'            => '測迴模：[[$1]]',
'parser-template-recursion-depth-warning' => '已超迴模限深（$1）',
'language-converter-depth-warning'        => '已超字變限深（$1）',

# "Undo" feature
'undo-success' => '此審可返也。查確然完之。',
'undo-failure' => '中審之異，此審無返也。',
'undo-norev'   => '其審無存或刪，此審無返也。',
'undo-summary' => '返[[Special:Contributions/$2|$2]]（[[User talk:$2|書]]）之審$1',

# Account creation failure
'cantcreateaccounttitle' => '新簿謝焉',
'cantcreateaccount-text' => "[[User:$3|S3]]因''$2''故，封子IP <b>$1</b>。",

# History pages
'viewpagelogs'           => '覽誌',
'nohistory'              => '此題無誌',
'currentrev'             => '今審',
'currentrev-asof'        => '$1之今審',
'revisionasof'           => '$1審',
'revision-info'          => '本版日期︰$1；作者︰$2',
'previousrevision'       => '←舊',
'nextrevision'           => '新→',
'currentrevisionlink'    => '今審',
'cur'                    => '辨今',
'next'                   => '後',
'last'                   => '前',
'page_first'             => '首',
'page_last'              => '末',
'histlegend'             => "辨異：擇二孔後，按Enter、或點下鈕以辨之。<br />
釋義：'''（{{int:cur}}）'''與今審辨；'''（{{int:last}}）'''與前審辨；'''{{int:minoreditletter}}'''，校文",
'history-fieldset-title' => '誌覽',
'history-show-deleted'   => '只刪',
'histfirst'              => '初',
'histlast'               => '末',
'historysize'            => '（$1位元組）',
'historyempty'           => '（空）',

# Revision feed
'history-feed-title'          => '誌審',
'history-feed-description'    => '維基誌審',
'history-feed-item-nocomment' => '$1於$2',
'history-feed-empty'          => '此頁不存，或刪、或更。類由此[[Special:Search|尋]]',

# Revision deletion
'rev-deleted-comment'         => '（此註刪矣）',
'rev-deleted-user'            => '（此簿刪矣）',
'rev-deleted-event'           => '（此誌刪矣）',
'rev-deleted-user-contribs'   => '[簿名或IP地址已除 - 從貢藏纂]',
'rev-deleted-text-permission' => "此審'''刪'''矣，詳見[{{fullurl:{{#Special:Log}}/delete|page={{PAGENAMEE}}}}誌刪]。",
'rev-deleted-text-unhide'     => "此審'''刪'''矣，詳見[{{fullurl:{{#Special:Log}}/delete|page={{PAGENAMEE}}}}誌刪]。
有秩仍看者，[$1 看此審]也。",
'rev-suppressed-text-unhide'  => "此審'''廢'''矣，詳見[{{fullurl:{{#Special:Log}}/suppress|page={{PAGENAMEE}}}}誌廢]。
有秩仍看者，[$1 看此審]也。",
'rev-deleted-text-view'       => "此審'''刪'''矣，惟有秩可見之，詳見[{{fullurl:{{#Special:Log}}/delete|page={{FULLPAGENAMEE}}}} 誌刪]。",
'rev-suppressed-text-view'    => "此審'''廢'''矣，惟有秩可見之，詳見[{{fullurl:{{#Special:Log}}/suppress|page={{FULLPAGENAMEE}}}} 誌廢]。",
'rev-deleted-no-diff'         => "此審'''刪'''矣，無視之審也。
詳見[{{fullurl:{{#Special:Log}}/delete|page={{PAGENAMEE}}}}誌刪]。",
'rev-suppressed-no-diff'      => "此審'''刪'''矣，爾無視此審也。",
'rev-deleted-unhide-diff'     => "此審'''刪'''矣，
詳見[{{fullurl:{{#Special:Log}}/delete|page={{PAGENAMEE}}}}誌刪]。
有秩仍看者，[$1 看此審]也。",
'rev-suppressed-unhide-diff'  => "此審'''廢'''矣，
詳見[{{fullurl:{{#Special:Log}}/suppress|page={{PAGENAMEE}}}}誌廢]。
有秩仍看者，[$1 看此審]也。",
'rev-deleted-diff-view'       => "此二孔之一審'''刪'''矣，惟有秩可見之，詳見[{{fullurl:{{#Special:Log}}/delete|page={{FULLPAGENAMEE}}}} 誌刪]。",
'rev-suppressed-diff-view'    => "此二孔之一審'''廢'''矣，惟有秩可見之，詳見[{{fullurl:{{#Special:Log}}/delete|page={{FULLPAGENAMEE}}}} 誌廢]。",
'rev-delundel'                => '見/藏',
'rev-showdeleted'             => '見',
'revisiondelete'              => '刪、還審',
'revdelete-nooldid-title'     => '無此審。',
'revdelete-nooldid-text'      => '審未擇，審未存，爾隱現審，不可為之。',
'revdelete-nologtype-title'   => '無誌類',
'revdelete-nologtype-text'    => '爾未定誌類以為之。',
'revdelete-nologid-title'     => '無效之誌項',
'revdelete-nologid-text'      => '爾未定標誌項以為之或其無存也。',
'revdelete-no-file'           => '指之檔無存也。',
'revdelete-show-file-confirm' => '爾察於$2 $3刪「$1」檔之審？',
'revdelete-show-file-submit'  => '善',
'revdelete-selected'          => "'''審[[:$1]]已擇$2：'''",
'logdelete-selected'          => "'''已擇誌$1：'''",
'revdelete-text'              => "'''刪審雖見誌，其文摒公眾，惟有秩可得之。'''無規則有秩可復還焉。",
'revdelete-confirm'           => '爾確作之，解之果焉，合之[[{{MediaWiki:Policy-url}}|策]]矣。',
'revdelete-suppress-text'     => "'''限'''於此壓：
* 無適之個訊
*: ''地、號、保等之。''",
'revdelete-legend'            => '見，規之以',
'revdelete-hide-text'         => '藏審文',
'revdelete-hide-image'        => '藏檔容',
'revdelete-hide-comment'      => '藏摘',
'revdelete-hide-user'         => '簿、IP址以藏',
'revdelete-hide-restricted'   => '廢有秩與簿之事',
'revdelete-radio-same'        => '（無改）',
'revdelete-radio-set'         => '可',
'revdelete-radio-unset'       => '否',
'revdelete-suppress'          => '廢有秩與簿之事',
'revdelete-unsuppress'        => '復審解限',
'revdelete-log'               => '因：',
'revdelete-submit'            => '擇{{PLURAL:$1|審}}使之',
'revdelete-logentry'          => '「[[$1]]」之見審動矣',
'logdelete-logentry'          => '「[[$1]]」之事見動矣',
'revdelete-success'           => "'''見審已更也。'''",
'revdelete-failure'           => "'''見審無更也：'''
$1",
'logdelete-success'           => "'''見事已設也。'''",
'logdelete-failure'           => "'''見事無設也：'''
$1",
'revdel-restore'              => '動見之',
'pagehist'                    => '頁史',
'deletedhist'                 => '刪史',
'revdelete-content'           => '字',
'revdelete-summary'           => '摘',
'revdelete-uname'             => '簿名',
'revdelete-restricted'        => '應限至有秩',
'revdelete-unrestricted'      => '除限自有秩',
'revdelete-hid'               => '隱$1',
'revdelete-unhid'             => '非隱$1',
'revdelete-log-message'       => '$1之修$2',
'logdelete-log-message'       => '$1之事$2',
'revdelete-hide-current'      => '錯藏於$1 $2項：現之審也，無藏之。',
'revdelete-show-no-access'    => '錯示於$1 $2項：「限」之項，爾無通行權也。',
'revdelete-modify-no-access'  => '錯改於$1 $2項：「限」之項，爾無通行權也。',
'revdelete-modify-missing'    => '錯改項ID $1：失庫！',
'revdelete-no-change'         => '警：於$1 $2之項求示設也。',
'revdelete-concurrent-change' => '錯改於$1 $2項：眾改之設，乃另之改。查誌。',
'revdelete-only-restricted'   => '藏期於 $1 $2 之項：爾無廢有秩見之項，而無選另廢項也。',
'revdelete-reason-dropdown'   => '*常因
** 侵權
** 無合之人料',
'revdelete-otherreason'       => '它附因：',
'revdelete-reasonotherlist'   => '它因',
'revdelete-edit-reasonlist'   => '纂刪因',
'revdelete-offender'          => '審著：',

# Suppression log
'suppressionlog'     => '誌廢',
'suppressionlogtext' => '下乃刪及錮物之列也。
[[Special:IPBlockList|IP之錮]]有現之閱。',

# History merging
'mergehistory'                     => '併頁之誌',
'mergehistory-header'              => "此頁講汝併一源頁之誌至二頁也。
認之易繼留該頁之前誌也。

'''以源頁之現誌必會保持。'''",
'mergehistory-box'                 => '併二頁之誌：',
'mergehistory-from'                => '源頁：',
'mergehistory-into'                => '到頁：',
'mergehistory-list'                => '可併之誌',
'mergehistory-merge'               => '下[[:$1]]之誌可併至[[:$2]]。用選鈕欄以併只於定時前所建之誌。留心用導連將重設本欄也。',
'mergehistory-go'                  => '示可併之誌',
'mergehistory-submit'              => '併誌',
'mergehistory-empty'               => '無誌可併',
'mergehistory-success'             => '[[:$1]]之$3誌已併至[[:$2]]。',
'mergehistory-fail'                => '併誌無進也，該頁及時間參數請重檢也。',
'mergehistory-no-source'           => '源頁$1無存也。',
'mergehistory-no-destination'      => '到頁$1無存也。',
'mergehistory-invalid-source'      => '源頁之題須效之。',
'mergehistory-invalid-destination' => '到頁之題須效之。',
'mergehistory-autocomment'         => '併[[:$1]]至[[:$2]]',
'mergehistory-comment'             => '併[[:$1]]至[[:$2]]：$3',
'mergehistory-same-destination'    => '源頁和到頁無同也',
'mergehistory-reason'              => '因：',

# Merge log
'mergelog'           => '誌併',
'pagemerge-logentry' => '併咗[[$1]]至[[$2]] （訂至$3）',
'revertmerge'        => '悔併',
'mergelogpagetext'   => '下乃近頁之誌併至二頁之表也。',

# Diffs
'history-title'            => '$1之誌',
'difference'               => '（辨異）',
'lineno'                   => '列$1：',
'compareselectedversions'  => '辨二擇',
'showhideselectedversions' => '示／藏之擇',
'editundo'                 => '悔',
'diff-multi'               => '（未示之審有$1）',

# Search results
'searchresults'                    => '得尋',
'searchresults-title'              => '"$1"得尋',
'searchresulttext'                 => '何索{{SITENAME}}，詳見[[{{MediaWiki:Helppage}}|{{int:help}}]]。',
'searchsubtitle'                   => "'''[[:$1]]'''尋焉（[[Special:Prefixindex/$1|『$1』之全首頁]]{{int:pipe-separator}}[[Special:WhatLinksHere/$1|『$1』之全取佐]]）",
'searchsubtitleinvalid'            => "'''$1'''尋焉",
'toomanymatches'                   => '多配應之，試異詢也',
'titlematches'                     => '合題',
'notitlematches'                   => '無題合',
'textmatches'                      => '合文',
'notextmatches'                    => '無文合',
'prevn'                            => '前{{PLURAL:$1|$1}}',
'nextn'                            => '次{{PLURAL:$1|$1}}',
'viewprevnext'                     => '見（$1 {{int:pipe-separator}} $2）（$3）',
'searchmenu-legend'                => '尋選',
'searchmenu-exists'                => "'''在此wiki中有頁為\"[[:\$1]]\"。'''",
'searchmenu-new'                   => "'''在此wiki上建頁\"[[:\$1]]\"！'''",
'searchhelp-url'                   => 'Help:目錄',
'searchmenu-prefix'                => '[[Special:PrefixIndex/$1|查此首之頁]]',
'searchprofile-articles'           => '容',
'searchprofile-project'            => '助題',
'searchprofile-images'             => '媒',
'searchprofile-everything'         => '全',
'searchprofile-advanced'           => '進',
'searchprofile-articles-tooltip'   => '在$1中尋',
'searchprofile-project-tooltip'    => '在$1中尋',
'searchprofile-images-tooltip'     => '尋檔',
'searchprofile-everything-tooltip' => '尋全（含議）',
'searchprofile-advanced-tooltip'   => '自定名集中尋',
'search-result-size'               => '$1 （$2字）',
'search-result-score'              => '關：$1%',
'search-redirect'                  => '（轉 $1）',
'search-section'                   => '（節 $1）',
'search-suggest'                   => '爾否解之：$1',
'search-interwiki-caption'         => '結義金蘭',
'search-interwiki-default'         => '結果有$1：',
'search-interwiki-more'            => '（多）',
'search-mwsuggest-enabled'         => '有議',
'search-mwsuggest-disabled'        => '無議',
'search-relatedarticle'            => '關',
'mwsuggest-disable'                => '停AJAX議',
'searcheverything-enable'          => '尋全名集',
'searchrelated'                    => '關',
'searchall'                        => '全',
'showingresults'                   => "見'''$1'''尋，自'''$2'''始：",
'showingresultsnum'                => "見'''$3'''尋，自'''$2'''始：",
'showingresultsheader'             => "見'''$4'''，{{PLURAL:$5|'''$1''''''$3'''之尋|'''$1 - $2'''，共'''$3'''之尋}}",
'nonefound'                        => "'''注'''：部名冊預尋也。。試''all:''尋全名刪之頁（含議模等），或可用要之名冊為前綴也。",
'search-nonefound'                 => '詢中無結。',
'powersearch'                      => '尋',
'powersearch-legend'               => '尋',
'powersearch-ns'                   => '尋名集：',
'powersearch-redir'                => '轉表',
'powersearch-field'                => '尋',
'powersearch-togglelabel'          => '核：',
'powersearch-toggleall'            => '全',
'powersearch-togglenone'           => '無',
'search-external'                  => '外尋',
'searchdisabled'                   => '{{SITENAME}}因性能而停用之。可Gooogle查之，乃之過時也。',

# Quickbar
'qbsettings-none' => '無',

# Preferences page
'preferences'                   => '簿註',
'mypreferences'                 => '簿註',
'prefs-edits'                   => '數計：',
'prefsnologin'                  => '未登簿',
'prefsnologintext'              => '註記須<span class="plainlinks">[{{fullurl:{{#Special:UserLogin}}|returnto=$1}} 登簿]</span>。',
'changepassword'                => '易符節',
'prefs-skin'                    => '面版',
'skin-preview'                  => '草覽',
'prefs-math'                    => '數學',
'datedefault'                   => '原註',
'prefs-datetime'                => '日時',
'prefs-personal'                => '概簿',
'prefs-rc'                      => '近易',
'prefs-watchlist'               => '哨站',
'prefs-watchlist-days'          => '哨報有日',
'prefs-watchlist-days-max'      => '最大有七',
'prefs-watchlist-edits'         => '哨站有易',
'prefs-watchlist-edits-max'     => '最多之量：一千',
'prefs-watchlist-token'         => '哨幣：',
'prefs-misc'                    => '雜',
'prefs-resetpass'               => '更符節',
'prefs-email'                   => '傳書',
'prefs-rendering'               => '觀',
'saveprefs'                     => '儲',
'resetprefs'                    => '棄',
'restoreprefs'                  => '重修',
'prefs-editing'                 => '在修',
'prefs-edit-boxsize'            => '修框尺',
'rows'                          => '行：',
'columns'                       => '列：',
'searchresultshead'             => '尋',
'resultsperpage'                => '頁示尋',
'contextlines'                  => '尋分列',
'contextchars'                  => '列有字',
'stub-threshold'                => '<a href="#" class="stub">短頁連</a>格式門檻（位元組）：',
'recentchangesdays'             => '近易示日：',
'recentchangesdays-max'         => '最大有$1',
'recentchangescount'            => '修著凡幾︰',
'prefs-help-recentchangescount' => '含近易、史與誌。',
'prefs-help-watchlist-token'    => '添匙參爾之RSS哨。
且人知匙，可閱矣之，擇全之值也。
任成之值，爾可選之：$1',
'savedprefs'                    => '簿註書矣',
'timezonelegend'                => '時區：',
'localtime'                     => '本地時：',
'timezoneuseserverdefault'      => '用伺服器之預定',
'timezoneuseoffset'             => '它（定偏）',
'timezoneoffset'                => '偏¹：',
'servertime'                    => '伺服器時：',
'guesstimezone'                 => '瀏覽器填之',
'timezoneregion-africa'         => '非洲',
'timezoneregion-america'        => '美洲',
'timezoneregion-antarctica'     => '南極洲',
'timezoneregion-arctic'         => '北極',
'timezoneregion-asia'           => '亞洲',
'timezoneregion-atlantic'       => '大西洋',
'timezoneregion-australia'      => '澳洲',
'timezoneregion-europe'         => '歐洲',
'timezoneregion-indian'         => '印度洋',
'timezoneregion-pacific'        => '太平洋',
'allowemail'                    => '允遺書',
'prefs-searchoptions'           => '尋項',
'prefs-namespaces'              => '名集',
'defaultns'                     => '則尋之名集：',
'default'                       => '予定',
'prefs-files'                   => '檔',
'prefs-custom-css'              => '定之CSS',
'prefs-custom-js'               => '定之JavaScript',
'prefs-reset-intro'             => '爾用頁重設至預之設。無修之也。',
'prefs-emailconfirm-label'      => '確郵：',
'prefs-textboxsize'             => '纂框量',
'youremail'                     => '郵：',
'username'                      => '簿名：',
'uid'                           => '編號︰',
'prefs-memberingroups'          => '{{PLURAL:$1|一|權任}}：',
'prefs-registration'            => '注簿時辰：',
'yourrealname'                  => '本名：',
'yourlanguage'                  => '語言：',
'yourvariant'                   => '變字：',
'yournick'                      => '新署名︰',
'prefs-help-signature'          => '論版以論事以「<nowiki>~~~~</nowiki>」署名之，換爾之署名與時辰也。',
'badsig'                        => '無效之自畫。
查HTML籤之。',
'badsiglength'                  => '署名宜簡。',
'yourgender'                    => '性別︰',
'gender-unknown'                => '未',
'gender-male'                   => '男',
'gender-female'                 => '女',
'email'                         => '郵',
'prefs-help-realname'           => '可用署也，選填之。',
'prefs-help-email'              => '電郵地址，雖非必要，惟失符節之時，重設者須寄於此。',
'prefs-help-email-required'     => '郵須也。',
'prefs-info'                    => '基',
'prefs-i18n'                    => '萬國',
'prefs-signature'               => '簽',
'prefs-dateformat'              => '日格',
'prefs-timeoffset'              => '偏時',
'prefs-advancedediting'         => '進',
'prefs-advancedrc'              => '進',
'prefs-advancedrendering'       => '進',
'prefs-advancedsearchoptions'   => '進',
'prefs-advancedwatchlist'       => '進',
'prefs-display'                 => '示項',
'prefs-diffs'                   => '異',

# User rights
'userrights'                     => '秉治權任',
'userrights-lookup-user'         => '司社',
'userrights-user-editname'       => '簿名：',
'editusergroup'                  => '治社',
'editinguser'                    => "正纂簿'''[[User:$1|$1]]''' （[[User talk:$1|{{int:talkpagelinktext}}]]{{int:pipe-separator}}[[Special:Contributions/$1|{{int:contribslink}}]]） 之權",
'userrights-editusergroup'       => '治社',
'saveusergroups'                 => '定之',
'userrights-groupsmember'        => '有員：',
'userrights-groupsmember-auto'   => '固有員：',
'userrights-groups-help'         => '足下可為者有二︰

*賦其權，此其一也；
*去其職，此其二也。

*而星號在前者，一旦賦予，不可去也，宜慎焉。',
'userrights-reason'              => '因：',
'userrights-no-interwiki'        => '爾無權改他山wiki之簿權也。',
'userrights-nodatabase'          => '資料庫$1無存或非本地也。',
'userrights-nologin'             => '爾以有秩乲簿[[Special:UserLogin|登]]後以定簿之權也。',
'userrights-notallowed'          => '爾之簿無權定簿之權也。',
'userrights-changeable-col'      => '爾所管轄',
'userrights-unchangeable-col'    => '非爾所轄',
'userrights-irreversible-marker' => '$1＊',

# Groups
'group'               => '社：',
'group-user'          => '簿',
'group-autoconfirmed' => '自證其簿',
'group-bot'           => '僕',
'group-sysop'         => '有秩',
'group-bureaucrat'    => '門下',
'group-suppress'      => '監',
'group-all'           => '（眾）',

'group-user-member'          => '簿',
'group-autoconfirmed-member' => '自證其簿',
'group-bot-member'           => '僕',
'group-sysop-member'         => '有秩',
'group-bureaucrat-member'    => '門下',
'group-suppress-member'      => '監',

'grouppage-user'          => '{{ns:project}}:簿',
'grouppage-autoconfirmed' => '{{ns:project}}:自證其簿',
'grouppage-bot'           => '{{ns:project}}:僕',
'grouppage-sysop'         => '{{ns:project}}:有秩',
'grouppage-bureaucrat'    => '{{ns:project}}:門下',
'grouppage-suppress'      => '{{ns:project}}:監',

# Rights
'right-read'                  => '閱頁',
'right-edit'                  => '纂頁',
'right-createpage'            => '建頁（議不含）',
'right-createtalk'            => '建議頁',
'right-createaccount'         => '增簿',
'right-minoredit'             => '示小改',
'right-move'                  => '遷頁',
'right-move-subpages'         => '連遷子頁',
'right-move-rootuserpages'    => '遷根齋',
'right-movefile'              => '遷檔',
'right-suppressredirect'      => '遷頁時無增源之轉',
'right-upload'                => '貢獻品物',
'right-reupload'              => '蓋現之品物',
'right-reupload-own'          => '蓋同簿之品物',
'right-reupload-shared'       => '於本無視共媒物庫上之品物',
'right-upload_by_url'         => '由URL貢品物',
'right-purge'                 => '無確認頁除網存',
'right-autoconfirmed'         => '纂半錮之頁',
'right-bot'                   => '視自動之程序',
'right-nominornewtalk'        => '小改無發新信之示',
'right-apihighlimits'         => '於API查頂上',
'right-writeapi'              => '用寫之API',
'right-delete'                => '刪頁面',
'right-bigdelete'             => '刪大史之頁',
'right-deleterevision'        => '刪與反刪頁之審',
'right-deletedhistory'        => '看刪之項，無關之字',
'right-deletedtext'           => '看刪之項，審關之字',
'right-browsearchive'         => '尋刪之頁',
'right-undelete'              => '反刪頁',
'right-suppressrevision'      => '看與復由有秩藏之審',
'right-suppressionlog'        => '看私之誌',
'right-block'                 => '鎖他簿無編',
'right-blockemail'            => '鎖簿無電郵',
'right-hideuser'              => '鎖簿名，予藏眾',
'right-ipblock-exempt'        => '繞IP鎖、自鎖與圍鎖',
'right-proxyunbannable'       => '繞Proxy之自鎖',
'right-protect'               => '改錮級與纂錮頁',
'right-editprotected'         => '纂錮頁（無連錮）',
'right-editinterface'         => '纂要',
'right-editusercssjs'         => '纂他簿之CSS與JavaScript檔',
'right-editusercss'           => '纂他簿之CSS檔',
'right-edituserjs'            => '纂他簿之JavaScript檔',
'right-rollback'              => '速復上簿頁之纂',
'right-markbotedits'          => '標復纂為機纂',
'right-noratelimit'           => '無率之上限',
'right-import'                => '由它wiki匯入頁',
'right-importupload'          => '由品貢匯入頁',
'right-patrol'                => '示它纂作已巡查',
'right-autopatrol'            => '將己纂自示為已巡查',
'right-patrolmarks'           => '察近巡查記之易',
'right-unwatchedpages'        => '看未哨之頁',
'right-trackback'             => '交一trackback',
'right-mergehistory'          => '併頁之史',
'right-userrights'            => '纂簿權',
'right-userrights-interwiki'  => '纂另wiki他簿之權',
'right-siteadmin'             => '鎖與解鎖資料庫',
'right-reset-passwords'       => '設他簿之符節',
'right-override-export-depth' => '出有五層深之頁',
'right-versiondetail'         => '示延用之版',
'right-sendemail'             => '擬書傳予他簿',

# User rights log
'rightslog'  => '職權志',
'rightsnone' => '（凡）',

# Associated actions - in the sentence "You do not have permission to X"
'action-read'                 => '閱此頁',
'action-edit'                 => '纂此頁',
'action-createpage'           => '建此頁',
'action-createtalk'           => '建論頁',
'action-createaccount'        => '增簿',
'action-minoredit'            => '示纂為小',
'action-move'                 => '移頁',
'action-move-subpages'        => '移頁和其字頁',
'action-move-rootuserpages'   => '移根齋',
'action-movefile'             => '移檔',
'action-upload'               => '貢檔',
'action-reupload'             => '蓋現檔',
'action-reupload-shared'      => '蓋庫檔',
'action-upload_by_url'        => '自URL貢檔',
'action-writeapi'             => '寫API',
'action-delete'               => '刪頁',
'action-deleterevision'       => '刪審',
'action-deletedhistory'       => '看此頁之刪史',
'action-browsearchive'        => '尋刪頁',
'action-undelete'             => '反刪此頁',
'action-suppressrevision'     => '查復是次之隱訂',
'action-suppressionlog'       => '看此誌私',
'action-block'                => '禁簿纂',
'action-protect'              => '更頁錮',
'action-import'               => '自另wiki入此頁',
'action-importupload'         => '自貢入此頁',
'action-patrol'               => '示他纂為巡',
'action-autopatrol'           => '示己纂為巡',
'action-unwatchedpages'       => '查無哨',
'action-trackback'            => '交trackback',
'action-mergehistory'         => '併此頁之史',
'action-userrights'           => '纂全權',
'action-userrights-interwiki' => '纂他wiki上之權',
'action-siteadmin'            => '鎖及解鎖其庫',

# Recent changes
'nchanges'                          => '$1易',
'recentchanges'                     => '近易',
'recentchanges-legend'              => '近易項',
'recentchangestext'                 => '共筆揮新，悉列於此。',
'recentchanges-feed-description'    => '跟wiki源之近易。',
'recentchanges-label-legend'        => '例： $1',
'recentchanges-legend-newpage'      => '$1 - 新頁',
'recentchanges-label-newpage'       => '此纂開新頁',
'recentchanges-legend-minor'        => '$1 - 細纂',
'recentchanges-label-minor'         => '此乃細纂',
'recentchanges-legend-bot'          => '$1 - 機纂',
'recentchanges-label-bot'           => '此乃機纂',
'recentchanges-legend-unpatrolled'  => '$1 - 未巡之纂',
'recentchanges-label-unpatrolled'   => '此乃未巡之纂',
'rcnote'                            => "下為自$4$5起，'''$2'''日內'''$1'''近易也。",
'rcnotefrom'                        => "下為自'''$2'''至'''$1'''之易也。",
'rclistfrom'                        => '自$1起之易也',
'rcshowhideminor'                   => '$1校',
'rcshowhidebots'                    => '$1僕',
'rcshowhideliu'                     => '$1簿',
'rcshowhideanons'                   => '$1匿名',
'rcshowhidepatr'                    => '$1哨',
'rcshowhidemine'                    => '$1吾纂',
'rclinks'                           => '$2日內$1近易。<br />$3',
'diff'                              => '辨',
'hist'                              => '誌',
'hide'                              => '藏',
'show'                              => '示',
'minoreditletter'                   => '校',
'newpageletter'                     => '新',
'boteditletter'                     => '僕',
'number_of_watching_users_pageview' => '[放有$1哨]',
'rc_categories_any'                 => '任',
'newsectionsummary'                 => '/* $1 */ 新節',
'rc-enhanced-expand'                => '示細（要 JavaScript）',
'rc-enhanced-hide'                  => '藏細',

# Recent changes linked
'recentchangeslinked'          => '援引',
'recentchangeslinked-feed'     => '援引',
'recentchangeslinked-toolbox'  => '援引',
'recentchangeslinked-title'    => '「$1」援引近易',
'recentchangeslinked-noresult' => '限期內無近易。',
'recentchangeslinked-summary'  => "此奇頁乃列''由''頁援之近易（或對類之員）。
有[[Special:Watchlist|爾有哨]]者'''粗體'''。",
'recentchangeslinked-page'     => '頁名：',
'recentchangeslinked-to'       => '示援頁',

# Upload
'upload'                     => '進獻',
'uploadbtn'                  => '進獻',
'reuploaddesc'               => '消進乃返載獻',
'upload-tryagain'            => '呈改檔述',
'uploadnologin'              => '未登簿',
'uploadnologintext'          => '[[Special:UserLogin|登簿]]始可進獻',
'upload_directory_missing'   => '目錄$1已失，無建之。',
'upload_directory_read_only' => '目錄$1禁入，無可獻。',
'uploaderror'                => '進獻有變',
'uploadtext'                 => "下表以獻，[[Special:FileList|載獻]]覽之。或見[[Special:Log/upload|誌獻]]與[[Special:Log/delete|誌刪]]。
欲嵌頁中，是格鏈之其一：
* '''<tt><nowiki>[[</nowiki>{{ns:file}}:File.jpg]]</tt>'''用此整獻
* '''<tt><nowiki>[[</nowiki>{{ns:file}}:File.png||200px|thumb|left|名]]</tt>'''以二百像素置左框置『名』
* '''<tt><nowiki>[[</nowiki>{{ns:media}}:File.ogg]]</tt>'''直連獻，無示獻",
'upload-permitted'           => '可之物類：$1。',
'upload-preferred'           => '議之物類：$1。',
'upload-prohibited'          => '禁之物類：$1。',
'uploadlog'                  => '誌獻',
'uploadlogpage'              => '誌獻',
'uploadlogpagetext'          => '近獻如下。
看[[Special:NewFiles|新畫獻]]示獻功。',
'filename'                   => '名',
'filedesc'                   => '概',
'fileuploadsummary'          => '概：',
'filereuploadsummary'        => '動：',
'filestatus'                 => '授權：',
'filesource'                 => '源：',
'uploadedfiles'              => '進獻',
'ignorewarning'              => '強儲之',
'ignorewarnings'             => '警略。',
'minlength1'                 => '名務逾一字元。',
'illegalfilename'            => '名"$1"不格，更之再焉。',
'badfilename'                => '更名"$1。"。',
'filetype-mime-mismatch'     => '檔展名無配MIME類。',
'filetype-badmime'           => '「$1」之MIME類物檔案不能獻之。',
'filetype-bad-ie-mime'       => '因 Internet Explorer 偵作「$1」不貢也。它乃有危險之類也。',
'filetype-unwanted-type'     => "'''「.$1」'''乃無需之物類也。
議之物類有{{PLURAL:$3|一|多}}$2也。",
'filetype-banned-type'       => "'''「.$1」'''乃無允之物類也。
允之物類有{{PLURAL:$3|一|多}}$2也。",
'filetype-missing'           => '檔名無後綴也（如「.jpg」）。',
'large-file'                 => '檔長$2仟位元組，不逾$1為佳。',
'emptyfile'                  => '無以獻，疑謬名也，惠核之。',
'fileexists'                 => "'''<tt>[[:$1]]</tt>'''存矣，欲蓋之則再也。 [[$1|thumb]]",
'filepageexists'             => "此檔之述於'''<tt>[[:$1]]</tt>'''存矣，檔未存也。爾入述無存也。要現之，爾需纂之。",
'file-exists-duplicate'      => '此檔乃重檔{{PLURAL:$1|一|數}}：',
'file-deleted-duplicate'     => '此檔（[[:$1]]）前刪。爾需查刪錄再貢之。',
'successfulupload'           => '檔案安矣',
'uploadwarning'              => '慎焉！',
'uploadwarning-text'         => '改下檔述再試之。',
'savefile'                   => '存之',
'uploadedimage'              => '進獻"[[$1]]"',
'overwroteimage'             => '新置「[[$1]]」矣',
'uploaddisabledtext'         => '檔之貢被禁也。',
'php-uploaddisabledtext'     => 'PHP之貢被禁也。查 file_uploads 之。',
'uploadvirus'                => '此檔含毒也！
詳：$1',
'upload-source'              => '源檔',
'sourcefilename'             => '源名：',
'sourceurl'                  => '源址：',
'destfilename'               => '欲置檔名：',
'upload-maxfilesize'         => '檔限：$1',
'upload-description'         => '檔述',
'upload-options'             => '貢項',
'watchthisupload'            => '派哨',
'upload-wasdeleted'          => "'''警示：復獻棄檔，慎續之。'''
誌刪如下：",
'filename-bad-prefix'        => "獻檔以'''「$1」'''首，常由相機瞎造，惠更述之。",

'upload-too-many-redirects' => '網址含多轉',
'upload-unknown-size'       => '未知之積',
'upload-http-error'         => '發一HTTP之錯：$1',

# img_auth script messages
'img-auth-accessdenied' => '無通',
'img-auth-nopathinfo'   => 'PATH_INFO失之。
爾之伺服器無此資料也。
以CGI之本耳，無img_auth矣。
閱http://www.mediawiki.org/wiki/Manual:Image_Authorization。',
'img-auth-notindir'     => '求之徑無存貢錄中。',
'img-auth-badtitle'     => '於「$1」無建效題也。',
'img-auth-nologinnWL'   => '爾未登簿，「$1」無在白名中。',
'img-auth-nofile'       => '檔「$1」無存也。',
'img-auth-isdir'        => '爾試問錄「$1」。
只問檔也。',
'img-auth-streaming'    => '流「$1」中。',
'img-auth-public'       => 'img_auth.php之功能乃由共wiki出貢。
此wiki為公共wiki是也。
保強，img_auth.php已停矣。',
'img-auth-noread'       => '簿無權讀「$1」也。',

# HTTP errors
'http-invalid-url'      => '無效之網址：$1',
'http-invalid-scheme'   => '有「$1」之網址無持也',
'http-request-error'    => '未知之錯令HTTP求時錯之。',
'http-read-error'       => 'HTTP讀錯。',
'http-timed-out'        => 'HTTP求之過時也。',
'http-curl-error'       => '取網址現錯之：$1',
'http-host-unreachable' => '無達網址之。',
'http-bad-status'       => 'HTTP求時現問：$1 $2',

# Some likely curl errors. More could be added from <http://curl.haxx.se/libcurl/c/libcurl-errors.html>
'upload-curl-error6'       => '無達網址也',
'upload-curl-error6-text'  => '無達所指之網址也。再試其正，乃正常也。',
'upload-curl-error28'      => '貢超時也',
'upload-curl-error28-text' => '網站應之長也。再試其而行之。乃以閑以試之。',

'license'            => '權：',
'license-header'     => '權',
'nolicense'          => '無選',
'license-nopreview'  => '（謝草覽）',
'upload_source_url'  => '（乃一公共可達之網址）',
'upload_source_file' => '（本機之件）',

# Special:ListFiles
'listfiles-summary'     => '此奇頁示檔之全呈也。
設最後之檔呈示於表頂。
點題改其列之。',
'listfiles_search_for'  => '以媒名尋：',
'imgfile'               => '檔',
'listfiles'             => '見檔',
'listfiles_date'        => '時',
'listfiles_name'        => '名',
'listfiles_user'        => '簿',
'listfiles_size'        => '幅（位元組）',
'listfiles_description' => '述',
'listfiles_count'       => '擇',

# File description page
'file-anchor-link'                  => '檔',
'filehist'                          => '檔史',
'filehist-help'                     => '揀日尋檔。',
'filehist-deleteall'                => '全刪',
'filehist-deleteone'                => '刪',
'filehist-revert'                   => '還',
'filehist-current'                  => '今',
'filehist-datetime'                 => '時',
'filehist-thumb'                    => '縮',
'filehist-thumbtext'                => '於$1之縮',
'filehist-nothumb'                  => '無縮',
'filehist-user'                     => '薄',
'filehist-dimensions'               => '度',
'filehist-filesize'                 => '檔幅',
'filehist-comment'                  => '註',
'filehist-missing'                  => '失檔',
'imagelinks'                        => '檔所繫者',
'linkstoimage'                      => '下頁連本檔有$1：',
'linkstoimage-more'                 => '連檔有多於$1。
下表示連檔之首$1。
[[Special:WhatLinksHere/$2|整表]]可供之閱也。',
'nolinkstoimage'                    => '無頁連本檔也。',
'morelinkstoimage'                  => '閱檔[[Special:WhatLinksHere/$1|接]]。',
'redirectstofile'                   => '下檔轉到此檔有$1：',
'duplicatesoffile'                  => '下檔重此檔有$1（[[Special:FileDuplicateSearch/$2|詳]]）：',
'sharedupload'                      => '此檔為$1之共傳，可另項用也。',
'sharedupload-desc-there'           => '此檔為$1之共傳，可另項用也。
詳閱[$2 檔述]。',
'sharedupload-desc-here'            => '此檔為$1之共傳，可另項用也。
於共庫上[$2 檔述]之示。',
'filepage-nofile'                   => '查無此檔。',
'filepage-nofile-link'              => '查無此檔，爾可[$1 貢焉]。',
'uploadnewversion-linktext'         => '更新此檔',
'shared-repo-name-wikimediacommons' => '維基共享',

# File reversion
'filerevert'                => '還$1',
'filerevert-legend'         => '還檔',
'filerevert-intro'          => "'''[[Media:$1|$1]]'''欲還回$2$3之版$4。",
'filerevert-comment'        => '因：',
'filerevert-defaultcomment' => '還$1$2之版矣',
'filerevert-submit'         => '還',
'filerevert-success'        => "'''[[Media:$1|$1]]'''，$2$3之版$4還矣。",
'filerevert-badversion'     => '該日無版也。',

# File deletion
'filedelete'                  => '刪$1',
'filedelete-legend'           => '刪檔',
'filedelete-intro'            => "欲刪'''[[Media:$1|$1]]'''。",
'filedelete-intro-old'        => "欲刪'''[[Media:$1|$1]]'''$2$3之版$4。",
'filedelete-comment'          => '因：',
'filedelete-submit'           => '刪',
'filedelete-success'          => "'''$1'''刪矣。",
'filedelete-success-old'      => "'''[[Media:$1|$1]]'''$2$3之版刪矣。",
'filedelete-nofile'           => "無'''$1'''也。",
'filedelete-nofile-old'       => "無合'''$1'''藏也。",
'filedelete-otherreason'      => '另／附之因：',
'filedelete-reason-otherlist' => '另因',
'filedelete-reason-dropdown'  => '
*常刪之因
** 侵版權
** 重檔',
'filedelete-edit-reasonlist'  => '纂刪因',
'filedelete-maintenance'      => '護當禁刪復檔也。',

# MIME search
'mimesearch'         => '篩檔',
'mimesearch-summary' => '此頁可以MIME篩檔．格仿「文類/次類」，如<tt>image/jpeg</tt>。',
'mimetype'           => 'MIME類有：',
'download'           => '載下',

# Unwatched pages
'unwatchedpages' => '無哨頁',

# List redirects
'listredirects' => '表轉',

# Unused templates
'unusedtemplates'     => '墨乾',
'unusedtemplatestext' => '此表閒模，篤刪前惠考支鏈。',
'unusedtemplateswlh'  => '支鏈',

# Random page
'randompage'         => '風掀',
'randompage-nopages' => '下列{{PLURAL:$2|名集}}中無頁也：$1',

# Random redirect
'randomredirect'         => '任渡',
'randomredirect-nopages' => '「$1」名冊內無渡也。',

# Statistics
'statistics'                   => '彙統',
'statistics-header-pages'      => '頁彙統',
'statistics-header-edits'      => '纂彙統',
'statistics-header-views'      => '閱彙統',
'statistics-header-users'      => '有簿彙統',
'statistics-header-hooks'      => '他彙統',
'statistics-articles'          => '容頁',
'statistics-pages'             => '頁',
'statistics-pages-desc'        => 'wiki上之全頁，含議、轉等',
'statistics-files'             => '已貢',
'statistics-edits'             => '自{{SITENAME}}設之頁纂數',
'statistics-edits-average'     => '每頁均纂數',
'statistics-views-total'       => '閱總',
'statistics-views-peredit'     => '每纂閱數',
'statistics-jobqueue'          => '[http://www.mediawiki.org/wiki/Manual:Job_queue 隊]長',
'statistics-users'             => '註[[Special:ListUsers|簿]]',
'statistics-users-active'      => '活簿',
'statistics-users-active-desc' => '早$1日前更動之簿',
'statistics-mostpopular'       => '燴炙',

'disambiguations'      => '釋義',
'disambiguations-text' => '頁下引[[MediaWiki:Disambiguationspage]]模，求釋義，宜正題之。',

'doubleredirects'            => '窮渡',
'doubleredirectstext'        => '頁下窮渡，迭列以示。首尾宿合，宜正渡之。
<s>劃</s>已解之。',
'double-redirect-fixed-move' => '[[$1]]遷畢，現渡至[[$2]]',
'double-redirect-fixer'      => '修渡',

'brokenredirects'        => '斷渡',
'brokenredirectstext'    => '頁下斷渡。',
'brokenredirects-edit'   => '替',
'brokenredirects-delete' => '刪',

'withoutinterwiki'         => '孤語',
'withoutinterwiki-summary' => '頁下無鏈他語。',
'withoutinterwiki-legend'  => '首',
'withoutinterwiki-submit'  => '示',

'fewestrevisions' => '鮮察',

# Miscellaneous special pages
'nbytes'                  => '$1位元組',
'ncategories'             => '$1門',
'nlinks'                  => '$1鏈',
'nmembers'                => '$1戶',
'nrevisions'              => '$1審',
'nviews'                  => '$1閱',
'lonelypages'             => '孤寡',
'lonelypagestext'         => '頁下無鏈或含',
'uncategorizedpages'      => '欲訂',
'uncategorizedcategories' => '問栓',
'uncategorizedimages'     => '候裱',
'uncategorizedtemplates'  => '待蘸',
'unusedcategories'        => '樞鏽',
'unusedimages'            => '色褪',
'popularpages'            => '膾炙',
'wantedcategories'        => '求門',
'wantedpages'             => '徵頁',
'wantedpages-badtitle'    => '結組無題: $1',
'wantedfiles'             => '求檔',
'wantedtemplates'         => '徵模',
'mostlinked'              => '好料',
'mostlinkedcategories'    => '豪門',
'mostlinkedtemplates'     => '美模',
'mostcategories'          => '跨船',
'mostimages'              => '名檔',
'mostrevisions'           => '屢審',
'prefixindex'             => '以鏈外查',
'shortpages'              => '短篇',
'longpages'               => '長言',
'deadendpages'            => '此無路也',
'protectedpages'          => '頁錮',
'protectedpages-indef'    => '只示無期之錮',
'protectedpages-cascade'  => '只示連串之錮',
'listusers'               => '點簿',
'listusers-editsonly'     => '只示有纂之簿',
'listusers-creationsort'  => '按先後列之',
'usereditcount'           => '$1纂',
'usercreated'             => '建於$1$2',
'newpages'                => '新灶',
'newpages-username'       => '簿名：',
'ancientpages'            => '陳年',
'move'                    => '遷',
'movethispage'            => '遷此頁',
'unusedimagestext'        => '下檔存也，未嵌於其頁之。
他站可以網址鏈檔，故下列並非盡閒，註記之。',
'unusedcategoriestext'    => '以下空門，無依可活。',
'notargettitle'           => '落靶',
'notargettext'            => '簿、頁未定，無可為之。',
'nopagetitle'             => '落靶之頁',
'nopagetext'              => '頁未定，無可為之。',
'pager-newer-n'           => '新$1次',
'pager-older-n'           => '陳$1次',
'suppress'                => '監',

# Book sources
'booksources'               => '書海',
'booksources-search-legend' => '舀書海',
'booksources-go'            => '往',
'booksources-text'          => '有賈售新舊書，或有助焉。茲列如下：',
'booksources-invalid-isbn'  => '供之ISBN無確，查始複之誤。',

# Special:Log
'specialloguserlabel'  => '簿：',
'speciallogtitlelabel' => '標：',
'log'                  => '誌',
'all-logs-page'        => '眾誌',
'alllogstext'          => '眾{{SITENAME}}之誌有合者，俱併版見。擇門、選簿、限疆以裁之。',
'logempty'             => '無合誌也。',
'log-title-wildcard'   => '題以此始者，取之',

# Special:AllPages
'allpages'          => '全典',
'alphaindexline'    => '自$1至$2',
'nextpage'          => '次頁（$1）',
'prevpage'          => '先頁（$1）',
'allpagesfrom'      => '始頁：',
'allpagesto'        => '末頁：',
'allarticles'       => '全典',
'allinnamespace'    => '全$1名冊',
'allnotinnamespace' => '非$1名冊',
'allpagesprev'      => '前',
'allpagesnext'      => '次',
'allpagessubmit'    => '往',
'allpagesprefix'    => '冠頁以：',
'allpagesbadtitle'  => '或冠有他語、他山、或含禁字，題標不格。',
'allpages-bad-ns'   => '無"$1"名冊',

# Special:Categories
'categories'                    => '類',
'categoriespagetext'            => '大典{{PLURAL:$1|類中}}有頁或媒。
[[Special:UnusedCategories|未類]]無示之。
閱[[Special:WantedCategories|需類]]也。',
'categoriesfrom'                => '示此項起之類：',
'special-categories-sort-count' => '排數',
'special-categories-sort-abc'   => '排字',

# Special:DeletedContributions
'deletedcontributions'             => '已刪之積',
'deletedcontributions-title'       => '所棄之事',
'sp-deletedcontributions-contribs' => '積',

# Special:LinkSearch
'linksearch'       => '尋網連',
'linksearch-pat'   => '尋址：',
'linksearch-ns'    => '名集：',
'linksearch-ok'    => '尋',
'linksearch-text'  => '用似"*.wikipedia.org"之萬字。<br />
援之議：<tt>$1</tt>',
'linksearch-line'  => '$1連$2',
'linksearch-error' => '萬字僅用於機之始也。',

# Special:ListUsers
'listusersfrom'      => '始簿：',
'listusers-submit'   => '見',
'listusers-noresult' => '尋無簿。',
'listusers-blocked'  => '（已禁）',

# Special:ActiveUsers
'activeusers'            => '躍簿',
'activeusers-intro'      => '此乃為近$1天內之躍簿也。',
'activeusers-count'      => '$3天內之$1易',
'activeusers-from'       => '示簿始於：',
'activeusers-hidebots'   => '藏僕',
'activeusers-hidesysops' => '藏有秩',
'activeusers-noresult'   => '無簿矣。',

# Special:Log/newusers
'newuserlogpage'              => '誌簿',
'newuserlogpagetext'          => '此為誌簿之記也',
'newuserlog-byemail'          => '號發自電郵',
'newuserlog-create-entry'     => '新簿',
'newuserlog-create2-entry'    => '已註$1之簿',
'newuserlog-autocreate-entry' => '已自註之簿',

# Special:ListGroupRights
'listgrouprights'                      => '權任一覽',
'listgrouprights-summary'              => '此所列述，諸職所司也，各有異同。欲知其詳，請閱[[{{MediaWiki:Listgrouprights-helppage}}|此文]]。',
'listgrouprights-key'                  => '* <span class="listgrouprights-granted">權授矣</span>
* <span class="listgrouprights-revoked">權撤矣</span>',
'listgrouprights-group'                => '組',
'listgrouprights-rights'               => '權',
'listgrouprights-helppage'             => 'Help:組權',
'listgrouprights-members'              => '（社員表）',
'listgrouprights-addgroup'             => '加{{PLURAL:$2|一|多}}組：$1',
'listgrouprights-removegroup'          => '除{{PLURAL:$2|一|多}}組：$1',
'listgrouprights-addgroup-all'         => '加全組',
'listgrouprights-removegroup-all'      => '除全組',
'listgrouprights-addgroup-self'        => '加自之{{PLURAL:$2|一|多}}組：$1',
'listgrouprights-removegroup-self'     => '除自之{{PLURAL:$2|一|多}}組：$1',
'listgrouprights-addgroup-self-all'    => '加自之全組',
'listgrouprights-removegroup-self-all' => '除自之全組',

# E-mail user
'mailnologin'      => '無驛',
'mailnologintext'  => '[[Special:UserLogin|登簿]]置郵，方可捎書。',
'emailuser'        => '捎君',
'emailpage'        => '捎書',
'emailpagetext'    => '表下捎焉，以郵制君。
署[[Special:Preferences|子簿郵]]以候往返。',
'usermailererror'  => '驛報有誤：',
'defemailsubject'  => '{{SITENAME}}來書',
'noemailtitle'     => '無郵',
'noemailtext'      => '此君無郵。',
'nowikiemailtitle' => '無許之郵',
'nowikiemailtext'  => '此君謝收郵之。',
'email-legend'     => '發郵至{{SITENAME}}之另一簿',
'emailfrom'        => '自：',
'emailto'          => '致：',
'emailsubject'     => '題：',
'emailmessage'     => '訊：',
'emailsend'        => '遣',
'emailccme'        => '謄複本。',
'emailccsubject'   => '致$1複本：$2',
'emailsent'        => '書遣矣',
'emailsenttext'    => '書遣矣',
'emailuserfooter'  => '此捎由$1給$2經{{SITENAME}}之「捎君」發矣。',

# Watchlist
'watchlist'            => '哨站',
'mywatchlist'          => '哨站',
'watchlistfor'         => "（'''$1'''之哨）",
'nowatchlist'          => '無哨',
'watchlistanontext'    => '$1以治哨',
'watchnologin'         => '未登簿',
'watchnologintext'     => '[[Special:UserLogin|登簿]]以治哨。',
'addedwatch'           => '派哨',
'addedwatchtext'       => "\"[[:\$1]]\"哨派矣。後有易、議者可見於[[Special:Watchlist|哨站]]，且'''粗體'''列於[[Special:RecentChanges|近易]]。",
'removedwatch'         => '撤哨',
'removedwatchtext'     => '"[[:$1]]"[[Special:Watchlist|哨]]撤矣。',
'watch'                => '派哨',
'watchthispage'        => '哨此報',
'unwatch'              => '撤哨',
'unwatchthispage'      => '撤此哨',
'notanarticle'         => '此頁非文',
'notvisiblerev'        => '上中異簿之審已刪矣',
'watchnochange'        => '皆無易也',
'watchlist-details'    => '哨上有$1，不含議論。',
'wlheader-enotif'      => '*准報信。',
'wlheader-showupdated' => "*易者'''粗體'''。",
'watchmethod-recent'   => '哨近易。',
'watchmethod-list'     => '報近易…',
'watchlistcontains'    => '共$1哨。',
'iteminvalidname'      => "'$1'謬名。",
'wlnote'               => '近<b>$2</b>時有$1者易。',
'wlshowlast'           => '見近$1時、$2天、$3時易',
'watchlist-options'    => '哨項',

# Displayed when you click the "watch" button and it is in the process of watching
'watching'   => '出陣…',
'unwatching' => '收兵…',

'enotif_mailer'                => '{{SITENAME}}報',
'enotif_reset'                 => '令為盡閱',
'enotif_newpagetext'           => '新灶',
'enotif_impersonal_salutation' => '貴客',
'changed'                      => '易',
'created'                      => '撰',
'enotif_subject'               => '{{SITENAME}}簿{$PAGEEDITOR}{$CHANGEDORCREATED}{$PAGETITLE}',
'enotif_lastvisited'           => '自子出簿，有易見$1。',
'enotif_lastdiff'              => '欲閱此易，見$1。',
'enotif_anon_editor'           => '過客$1',
'enotif_body'                  => '$WATCHINGUSERNAME鈞鑑

$PAGEEDITDATE{{SITENAME}}簿$PAGEEDITOR$CHANGEDORCREATED$PAGETITLE，閱審之見$PAGETITLE_URL。

$NEWPAGE

纂者彙：$PAGESUMMARY $PAGEMINOREDIT
遣書（$PAGEEDITOR_EMAIL）或訪齋（$PAGEEDITOR_WIKI）聯繫之。

如不訪頁，哨報止也。可赴哨所令復之。

{{SITENAME}}敬上

--
欲更哨令，惠訪{{fullurl:{{#special:Watchlist}}/edit}}

欲刪之頁，惠訪$UNWATCHURL

饋助之，惠訪{{fullurl:{{MediaWiki:Helppage}}}}',

# Delete
'deletepage'             => '刪頁',
'confirm'                => '准',
'excontent'              => '文乃「$1」',
'excontentauthor'        => '文乃「$1」，乃「[[Special:Contributions/$2|$2]]」獨作。',
'exbeforeblank'          => '清文前乃為：「$1」',
'exblank'                => '缺頁',
'delete-confirm'         => '刪"$1"',
'delete-legend'          => '刪',
'historywarning'         => '警示，此頁約有誌$1：',
'confirmdeletetext'      => '欲刪此物與誌，知後果、合[[{{MediaWiki:Policy-url}}]]後再為之。',
'actioncomplete'         => '成矣',
'actionfailed'           => '敗矣',
'deletedtext'            => '"<nowiki>$1</nowiki>"刪矣，見誌刪於$2。',
'deletedarticle'         => '刪焉「[[$1]]」',
'suppressedarticle'      => '廢焉「[[$1]]」',
'dellogpage'             => '誌刪',
'dellogpagetext'         => '近刪如下：',
'deletionlog'            => '誌刪',
'reverted'               => '已還前審',
'deletecomment'          => '因：',
'deleteotherreason'      => '另／附之因：',
'deletereasonotherlist'  => '另因',
'deletereason-dropdown'  => '*常刪之因
** 作者之求
** 侵版權
** 破壞',
'delete-edit-reasonlist' => '纂刪因',
'delete-toobig'          => '此頁含大誌，過$1修。刪頁限矣，防於{{SITENAME}}之亂也。',
'delete-warning-toobig'  => '此頁含大誌，過$1修。刪之可亂{{SITENAME}}之事也；續時留神之。',

# Rollback
'rollback'          => '反正',
'rollback_short'    => '正',
'rollbacklink'      => '正',
'rollbackfailed'    => '未能反正',
'cantrollback'      => '獨一作者，無以反正。',
'alreadyrolled'     => '[[User:$2|$2]]（[[User talk:$2|議]] | [[Special:Contributions/$2|{{int:contribslink}}]]）作[[:$1]]，退不成也。有易或已退焉。新纂者為[[User:$3|$3]]（[[User talk:$3|議]] | [[Special:Contributions/$3|{{int:contribslink}}]]）',
'editcomment'       => "贊曰\"''\$1''\"",
'revertpage'        => '去[[Special:Contributions/$2|$2]]之作（欲言之，可至[[User talk:$2|此]]）為[[User:$1|$1]]之本耳',
'revertpage-nouser' => '去（刪簿）之作為[[User:$1|$1]]之本耳',
'rollback-success'  => '去$1之作，復為$2之本耳。',
'sessionfailure'    => '登簿有變。為防盜簿，返前重取再為之。',

# Protect
'protectlogpage'              => '誌緘',
'protectlogtext'              => '誌緘如下；近緘見[[Special:ProtectedPages|此]] 。',
'protectedarticle'            => '緘焉"[[$1]]"',
'modifiedarticleprotection'   => '令"$1"',
'unprotectedarticle'          => '啟焉"[[$1]]"',
'movedarticleprotection'      => '自「[[$2]]」至「[[$1]]」之錮改矣',
'protect-title'               => '更"$1"之緘',
'prot_1movedto2'              => '[[$1]]遷至[[$2]]',
'protect-legend'              => '准緘',
'protectcomment'              => '贊因',
'protectexpiry'               => '屆期',
'protect_expiry_invalid'      => '屆期不明。',
'protect_expiry_old'          => '屆期已過。',
'protect-unchain-permissions' => '解鎖更遠之項',
'protect-text'                => "緘捆'''<nowiki>$1</nowiki>'''。",
'protect-locked-blocked'      => "簿禁，'''$1'''緘昔如下：",
'protect-locked-dblock'       => "庫鎖，'''$1'''緘昔如下：",
'protect-locked-access'       => "未准，'''$1'''緘昔如下：",
'protect-cascadeon'           => '取佐緘焉，迭牽此頁；{{PLURAL:$1|此|此}}頁啟篋，無反累焉。',
'protect-default'             => '允全簿',
'protect-fallback'            => "須''$1''准",
'protect-level-autoconfirmed' => '禁無簿',
'protect-level-sysop'         => '惟有秩',
'protect-summary-cascade'     => '迭緘',
'protect-expiring'            => '$1（UTC）屆',
'protect-expiry-indefinite'   => '無屆',
'protect-cascade'             => '援引緘，牽迭',
'protect-cantedit'            => '汝無動頁之護也，因汝無權纂之矣。',
'protect-othertime'           => '它時：',
'protect-othertime-op'        => '它時',
'protect-existing-expiry'     => '現屆時：$2 $3',
'protect-otherreason'         => '它／附之理：',
'protect-otherreason-op'      => '它理',
'protect-dropdown'            => '*通錮之理
** 多破
** 多灌
** 反產之戰纂
** 高量之頁',
'protect-edit-reasonlist'     => '纂護之理',
'protect-expiry-options'      => '半時:1 hour,一日:1 day,一週:1 week,兩週:2 weeks,一月:1 month,三月:3 months,六月:6 months,一年:1 year,永久:infinite',
'restriction-type'            => '准',
'restriction-level'           => '緘捆',
'minimum-size'                => '幅越',
'maximum-size'                => '幅弱：',
'pagesize'                    => '（位元組）',

# Restrictions (nouns)
'restriction-edit'   => '纂',
'restriction-move'   => '遷',
'restriction-create' => '建',
'restriction-upload' => '貢',

# Restriction levels
'restriction-level-sysop'         => '全封',
'restriction-level-autoconfirmed' => '半封',
'restriction-level-all'           => '有封',

# Undelete
'undelete'                     => '覽刪',
'undeletepage'                 => '覽刪並還之',
'undeletepagetitle'            => "'''如下含[[:$1]]刪之審'''。",
'viewdeletedpage'              => '覽刪',
'undeletepagetext'             => '如下之$1頁已刪，備謄以還；曆滿乃清之。',
'undelete-fieldset-title'      => '復審',
'undeleteextrahelp'            => "欲還題，撤核後令'''''{{int:undeletebtn}}'''''。
欲還某審，核之再令。
欲清核、贊，令之'''''{{int:undeletereset}}'''''。",
'undeleterevisions'            => '審備$1',
'undeletehistory'              => '如還題，審亦隨焉；若存同題，還如誌，不以代焉。',
'undeleterevdel'               => '新審不牽，難還也；銷、見之以篤還。',
'undeletehistorynoadmin'       => '文刪矣，何由如下；並示末纂者。詳文藏，惟有迭可閱。',
'undelete-revision'            => '自$4$5，$3纂之$1審刪如下：',
'undeleterevision-missing'     => '審謬失；棄、還或鏈亡。',
'undeletebtn'                  => '還',
'undeletelink'                 => '察焉，以定還否',
'undeleteviewlink'             => '察',
'undeletereset'                => '歸白',
'undeleteinvert'               => '反相',
'undeletecomment'              => '因：',
'undeletedarticle'             => '還焉"[[$1]]"',
'undeletedrevisions'           => '$1審已還',
'undeletedrevisions-files'     => '$1審、$2檔已還',
'undeletedfiles'               => '$1檔已還',
'cannotundelete'               => '無以還檔；或復矣。',
'undeletedpage'                => "'''$1還矣'''
近刪新還，見[[Special:Log/delete|刪還誌]]。",
'undelete-header'              => '欲覽近刪，見[[Special:Log/delete|誌刪]]。',
'undelete-search-box'          => '尋刪',
'undelete-search-prefix'       => '見頁始如',
'undelete-search-submit'       => '尋',
'undelete-no-results'          => '備本無合者也。',
'undelete-filename-mismatch'   => '$1之審名不合，無可還焉。',
'undelete-bad-store-key'       => '$1之審乃空，無可還焉。',
'undelete-cleanup-error'       => '冗檔$1，欲刪而有誤也。',
'undelete-missing-filearchive' => '$1無尋，或已還矣。',
'undelete-error-short'         => '$1欲還而有誤也。',
'undelete-error-long'          => '還檔有誤。欲還者：

$1',
'undelete-show-file-confirm'   => '汝乃確視於 $2 $3 之「<nowiki>$1</nowiki>」的已刪之審嗎？',
'undelete-show-file-submit'    => '是',

# Namespace form on various pages
'namespace'      => '名冊：',
'invert'         => '反相',
'blanknamespace' => '主',

# Contributions
'contributions'       => '功績',
'contributions-title' => '$1之功績',
'mycontris'           => '吾績',
'contribsub2'         => '$1勛（$2）',
'nocontribs'          => '無勛及也。',
'uctop'               => '（至頂）',
'month'               => '且不越',
'year'                => '年不越',

'sp-contributions-newbies'        => '惟列新進',
'sp-contributions-newbies-sub'    => '予新進',
'sp-contributions-newbies-title'  => '新進之功績',
'sp-contributions-blocklog'       => '誌禁',
'sp-contributions-deleted'        => '已刪之積',
'sp-contributions-logs'           => '誌',
'sp-contributions-talk'           => '議',
'sp-contributions-userrights'     => '秉治權任',
'sp-contributions-blocked-notice' => '此簿現禁。
近誌禁之項如下示之：',
'sp-contributions-search'         => '問勛',
'sp-contributions-username'       => '簿名或IP址',
'sp-contributions-submit'         => '問',

# What links here
'whatlinkshere'            => '取佐',
'whatlinkshere-title'      => '「$1」取佐',
'whatlinkshere-page'       => '題',
'linkshere'                => "取佐'''[[:$1]]'''如下：",
'nolinkshere'              => "無頁取佐'''[[:$1]]'''。",
'nolinkshere-ns'           => "名冊內無頁取佐'''[[:$1]]'''。",
'isredirect'               => '渡',
'istemplate'               => '含',
'isimage'                  => '檔佐',
'whatlinkshere-prev'       => '前$1',
'whatlinkshere-next'       => '次$1',
'whatlinkshere-links'      => '←佐',
'whatlinkshere-hideredirs' => '$1轉',
'whatlinkshere-hidetrans'  => '$1含',
'whatlinkshere-hidelinks'  => '$1佐',
'whatlinkshere-hideimages' => '$1檔佐',
'whatlinkshere-filters'    => '濾',

# Block/unblock
'blockip'                         => '禁簿',
'blockip-title'                   => '禁簿',
'blockip-legend'                  => '禁簿',
'blockiptext'                     => '函下禁纂，簿、址明判；[[{{MediaWiki:Policy-url}}|秉據]]如斯，立法克亂。指罪證行，了冤無憾。',
'ipaddress'                       => 'IP址',
'ipadressorusername'              => 'IP或簿名',
'ipbexpiry'                       => '限期',
'ipbreason'                       => '指證',
'ipbreasonotherlist'              => '常犯',
'ipbreason-dropdown'              => '*如下道：
** 造假報
** 毀文貌
** 廣賈告
** 話胡鬧
** 恐嚇擾
** 污名號
** 名瀆道',
'ipbanononly'                     => '惟禁匿',
'ipbcreateaccount'                => '禁增簿',
'ipbemailban'                     => '禁郵捎',
'ipbenableautoblock'              => '屢禁此簿，新IP址、後繼亦如也。',
'ipbsubmit'                       => '禁簿',
'ipbother'                        => '別期',
'ipboptions'                      => '二時:2 hours,一日:1 day,三日:3 days,一週:1 week,二週:2 weeks,一月:1 month,三月:3 months,六月:6 months,一年:1 year,永如:infinite',
'ipbotheroption'                  => '它',
'ipbotherreason'                  => '補證、加證曰',
'ipbhidename'                     => '簿名隱乎纂與表',
'ipbwatchuser'                    => '哨該簿之齋與議',
'ipballowusertalk'                => '禁時許其簿纂己之議',
'ipb-change-block'                => '用此設重禁此簿',
'badipaddress'                    => 'IP不格',
'blockipsuccesssub'               => '禁焉',
'blockipsuccesstext'              => '[[Special:Contributions/$1|$1]]禁焉。表禁<br />見[[Special:IPBlockList|此]]。',
'ipb-edit-dropdown'               => '改證',
'ipb-unblock-addr'                => '赦$1',
'ipb-unblock'                     => '赦簿、址',
'ipb-blocklist-addr'              => '$1之禁',
'ipb-blocklist'                   => '列禁',
'ipb-blocklist-contribs'          => '$1勛績',
'unblockip'                       => '赦簿',
'unblockiptext'                   => '函下赦禁。',
'ipusubmit'                       => '赦此址',
'unblocked'                       => '[[User:$1|$1]]赦焉',
'unblocked-id'                    => '禁$1赦焉',
'ipblocklist'                     => '列禁簿、禁址',
'ipblocklist-legend'              => '尋禁簿',
'ipblocklist-username'            => '簿名、IP址：',
'ipblocklist-sh-userblocks'       => '$1禁簿',
'ipblocklist-sh-tempblocks'       => '$1臨禁',
'ipblocklist-sh-addressblocks'    => '$1禁單IP',
'ipblocklist-submit'              => '尋',
'ipblocklist-localblock'          => '本禁',
'ipblocklist-otherblocks'         => '他{{PLURAL:$1|禁|禁}}',
'blocklistline'                   => '$1，$2禁$3（$4）',
'infiniteblock'                   => '永如',
'expiringblock'                   => '屆$1 $2',
'anononlyblock'                   => '惟匿者',
'noautoblockblock'                => '止自禁',
'createaccountblock'              => '禁增簿',
'emailblock'                      => '郵禁焉',
'blocklist-nousertalk'            => '禁其議',
'ipblocklist-empty'               => '無禁。',
'ipblocklist-no-results'          => '簿名、IP址未禁焉。',
'blocklink'                       => '禁',
'unblocklink'                     => '赦',
'change-blocklink'                => '更',
'contribslink'                    => '勛',
'autoblocker'                     => '近日$1"$2"；同子IP址，故禁焉。',
'blocklogpage'                    => '誌禁',
'blocklog-showlog'                => '此簿曾被禁。誌禁示下：',
'blocklog-showsuppresslog'        => '此簿曾被禁隱。誌廢示下：',
'blocklogentry'                   => '禁[[$1]]屆$2$3',
'reblock-logentry'                => '改[[$1]]之禁，屆$2$3',
'blocklogtext'                    => '此誌禁赦；自禁不示。見[[Special:IPBlockList|此]]列今禁者。',
'unblocklogentry'                 => '$1赦焉',
'block-log-flags-anononly'        => '惟禁匿',
'block-log-flags-nocreate'        => '禁增簿',
'block-log-flags-noautoblock'     => '止自禁',
'block-log-flags-noemail'         => '郵禁焉',
'block-log-flags-nousertalk'      => '禁己議',
'block-log-flags-angry-autoblock' => '強自封用也',
'block-log-flags-hiddenname'      => '藏簿名',
'range_block_disabled'            => '未准有秩圍禁。',
'ipb_expiry_invalid'              => '屆期不明。',
'ipb_expiry_temp'                 => '藏簿禁封必為長久也。',
'ipb_hide_invalid'                => '無壓簿以多纂之故。',
'ipb_already_blocked'             => '"$1"早禁矣',
'ipb-needreblock'                 => '== 已禁 ==
$1已被禁矣。爾是否改此置？',
'ipb-otherblocks-header'          => '他{{PLURAL:$1|禁|禁}}',
'ipb_cant_unblock'                => '有誤：禁$1無尋；或早赦矣。',
'ipb_blocked_as_range'            => '錯：該IP $1 無直禁也，無赦之。唯它在 $2 之範禁內，其範可赦之。',
'ip_range_invalid'                => 'IP址圍不格',
'ip_range_toolarge'               => '大於 /$1 之禁段乃無容也。',
'blockme'                         => '自禁',
'proxyblocker'                    => '禁Proxy',
'proxyblocksuccess'               => '成矣。',
'cant-block-while-blocked'        => '爾然被禁，勿施於人。',
'cant-see-hidden-user'            => '簿禁或藏矣。
爾無藏之權，無視纂禁也。',

# Developer tools
'lockdb'              => '閉庫',
'unlockdb'            => '開庫',
'lockdbtext'          => '夫閉庫者，止撰編、凍簿註、休令哨、謝問庫也。篤欲行，事畢開之。',
'unlockdbtext'        => '夫開庫者，迎撰編、任註簿、喜令哨、隨問庫也；慎篤之。',
'lockconfirm'         => '篤閉之。',
'unlockconfirm'       => '篤開之。',
'lockbtn'             => '閉庫',
'unlockbtn'           => '開庫',
'locknoconfirm'       => '未篤焉。',
'lockdbsuccesssub'    => '庫已閉',
'unlockdbsuccesssub'  => '庫已開',
'lockdbsuccesstext'   => '庫閉矣。<br />檢畢切[[Special:UnlockDB|開之]]。',
'unlockdbsuccesstext' => '庫開矣',
'lockfilenotwritable' => '未准更鎖庫檔。欲開閉之，網頁伺服須得更也。',
'databasenotlocked'   => '庫未閉焉。',

# Move page
'move-page'                    => '遷$1',
'move-page-legend'             => '遷頁',
'movepagetext'                 => "函下遷頁，誌隨新往、舊題作渡、取佐欲移。保佐正，[[Special:DoubleRedirects|防窮]]、[[Special:BrokenRedirects|斷渡]]。

囑之者，新題若非空、渡、缺誌，則舊'''不遷'''焉。存頁勿覆，而誤遷可悔也。

'''警示！'''
膾炙遷焉，禍生不測；戒慎行之。",
'movearticle'                  => '遷文：',
'moveuserpage-warning'         => "'''警：'''爾將遷頁齋。注之遷齋後之簿名乃為''無''變也。",
'movenologin'                  => '未登簿',
'movenologintext'              => '遷文須[[Special:UserLogin|登簿]]。',
'movenotallowed'               => '無准遷檔也。',
'cant-move-user-page'          => '無動自齋（除字頁）。',
'cant-move-to-user-page'       => '無動至齋（除字頁）。',
'newtitle'                     => '至新題：',
'move-watch'                   => '派哨至自與至之頁',
'movepagebtn'                  => '遷文',
'pagemovedsub'                 => '遷成矣',
'movepage-moved'               => "'''「$1」已遷至「$2」'''",
'movepage-moved-redirect'      => '一渡已建。',
'movepage-moved-noredirect'    => '建渡已押。',
'articleexists'                => '此題早存，或名謬焉；請更之。',
'cantmove-titleprotected'      => '爾不可動頁至此，因新題已緘焉，防建之。',
'talkexists'                   => "'''文遷成而議未移，蓋早存也；請併之。'''",
'movedto'                      => '遷至',
'movetalk'                     => '議並遷',
'move-subpages'                => '遷議（上至$1）',
'move-talk-subpages'           => '遷子議（上至$1）',
'movepage-page-exists'         => '頁$1已存矣，非自覆也。',
'movepage-page-moved'          => '頁$1遷$2矣。',
'movepage-page-unmoved'        => '頁$1遷$2不成。',
'movepage-max-pages'           => '上之$1頁遷矣同非自遷之下。',
'1movedto2'                    => '[[$1]]遷至[[$2]]',
'1movedto2_redir'              => '[[$1]]遷至[[$2]]為渡',
'move-redirect-suppressed'     => '渡押',
'movelogpage'                  => '誌遷',
'movelogpagetext'              => '頁遷如下：',
'movereason'                   => '因',
'revertmove'                   => '還',
'delete_and_move'              => '刪遷',
'delete_and_move_text'         => '==准刪==

往遷"[[:$1]]"存，刪之以替乎？',
'delete_and_move_confirm'      => '刪之',
'delete_and_move_reason'       => '為遷而刪之',
'selfmove'                     => '鄉遷同源，如未移也。',
'immobile-source-namespace'    => '名集「$1」上無動',
'immobile-target-namespace'    => '無移至「$1」中',
'immobile-target-namespace-iw' => '無移至垮維基，此乃無效也。',
'immobile-source-page'         => '此頁無動也。',
'immobile-target-page'         => '無動至標之標題。',
'imagenocrossnamespace'        => '非動檔至非檔名間',
'imagetypemismatch'            => '其新副檔名非配其類也',
'imageinvalidfilename'         => '標之檔名乃無效也',
'fix-double-redirects'         => '更指原題之任渡',
'move-leave-redirect'          => '留渡',
'protectedpagemovewarning'     => "'''警：'''本頁已錮，有秩移之。
近誌下曰參詳之：",
'semiprotectedpagemovewarning' => "'''注：'''本頁已錮，注簿移之。
近誌下曰參詳之：",
'move-over-sharedrepo'         => '== 檔存也 ==
[[:$1]]於共存存也，遷標題，蓋共檔之。',
'file-exists-sharedrepo'       => '同名之檔已存於共也。
請擇其另名之。',

# Export
'export'            => '出匯',
'exporttext'        => '文、誌纂、擇頁可編成XML，借MediaWiki[[Special:Import|入匯]他山]。欲出匯，函下題之，每列一題，任牽舊審、誌文；或獨帶末纂之述，以鏈表之，如以[[{{#Special:Export}}/{{MediaWiki:Mainpage}}]]匯"[[{{MediaWiki:Mainpage}}]]"。',
'exportcuronly'     => '獨匯今審',
'exportnohistory'   => "----
'''囑記，'''封匯全誌，因累甚也。",
'export-submit'     => '出匯',
'export-addcattext' => '索門擇題：',
'export-addcat'     => '增',
'export-addnstext'  => '索名集擇題：',
'export-addns'      => '增',
'export-download'   => '備檔以載',
'export-templates'  => '含模',

# Namespace 8 related
'allmessages'                   => '官話',
'allmessagesname'               => '話',
'allmessagesdefault'            => '慣話文',
'allmessagescurrent'            => '今話文',
'allmessagestext'               => '此列MediaWiki官話。
如貢正宗MediaWiki本地化，[http://www.mediawiki.org/wiki/Localisation MediaWiki本地化]與[http://translatewiki.net translatewiki.net]閱之。',
'allmessagesnotsupportedDB'     => "'''\$wgUseDatabaseMessages'''閉庫，'''無纂也。",
'allmessages-filter-legend'     => '濾',
'allmessages-filter'            => '以易濾：',
'allmessages-filter-unmodified' => '無易',
'allmessages-filter-all'        => '全',
'allmessages-filter-modified'   => '有易',
'allmessages-prefix'            => '以前綴濾：',
'allmessages-language'          => '言：',
'allmessages-filter-submit'     => '始',

# Thumbnails
'thumbnail-more'           => '展',
'filemissing'              => '喪檔',
'thumbnail_error'          => '縮圖$1有誤',
'thumbnail_invalid_params' => '縮圖參數不合',
'thumbnail_dest_directory' => '縮圖匣未可造',
'thumbnail_image-type'     => '圖類未支也',
'thumbnail_gd-library'     => '未完之GD設：功遺$1',
'thumbnail_image-missing'  => '檔遺：$1',

# Special:Import
'import'                     => '圖入匯',
'importinterwiki'            => '維基互匯',
'import-interwiki-text'      => '欲入匯，擇維基、揀題文，審時、纂者隨記也。互匯錄於[[Special:Log/import|誌入]]。',
'import-interwiki-source'    => '來源wiki／頁：',
'import-interwiki-history'   => '審、誌同匯',
'import-interwiki-submit'    => '入匯',
'import-interwiki-namespace' => '入名集：',
'import-upload-filename'     => '檔名：',
'import-comment'             => '註：',
'importtext'                 => '請[[Special:Export|出匯]]儲之。
再入匯於此。',
'importstart'                => '入匯…',
'import-revision-count'      => '有審$1',
'importnopages'              => '無可匯。',
'importfailed'               => '入匯有變：<nowiki>$1</nowiki>',
'importunknownsource'        => '入類不明',
'importcantopen'             => '入未可啟',
'importbadinterwiki'         => '維基內鏈壞',
'importnotext'               => '空檔或無文',
'importsuccess'              => '入匯成矣！',
'importhistoryconflict'      => '舊審沖，疑早存焉',
'importnosources'            => '互匯而未定入源，審、誌不予直進。',
'importnofile'               => '無匯入也。',
'importuploaderrorsize'      => '檔未入匯。幅越焉。',
'importuploaderrorpartial'   => '檔未入匯。檔部傳。',
'importuploaderrortemp'      => '檔未入匯。臨夾已失。',
'import-parse-failure'       => 'XML入匯語法敗矣',
'import-noarticle'           => '無頁入匯也！',
'import-nonewrevisions'      => '全審已入匯也。',
'xml-error-string'           => '$1 於行$2，欄$3 （$4字節）: $5',
'import-upload'              => '貢XML',
'import-token-mismatch'      => '節遺。再嘗之。',
'import-invalid-interwiki'   => '無乃定之wiki匯入。',

# Import log
'importlogpage'                    => '誌入',
'importlogpagetext'                => '秩入匯自他山之審。',
'import-logentry-upload'           => '[[$1]]上傳而匯',
'import-logentry-upload-detail'    => '有審$1',
'import-logentry-interwiki'        => '互匯$1',
'import-logentry-interwiki-detail' => '$1審自$2',

# Tooltip help for the actions
'tooltip-pt-userpage'             => '述平生、紹身家、銘字號',
'tooltip-pt-anonuserpage'         => '君IP之舍',
'tooltip-pt-mytalk'               => '與眾論、往魚雁、湧文滔',
'tooltip-pt-anontalk'             => '此IP所修之議',
'tooltip-pt-preferences'          => '更符驛、排版式、投所好',
'tooltip-pt-watchlist'            => '收矚目、治眼線、賞萌茂',
'tooltip-pt-mycontris'            => '刻勛功、追作續、慰苦勞',
'tooltip-pt-login'                => '設書齋、錄功績、廣放哨',
'tooltip-pt-anonlogin'            => '設書齋、錄功績、廣放哨',
'tooltip-pt-logout'               => '凡事盡，乘雲飄',
'tooltip-ca-talk'                 => '求異見、辯是非、妥紛擾',
'tooltip-ca-edit'                 => '拓文意、校誤謬、潤辭藻',
'tooltip-ca-addsection'           => '有言議，添新要',
'tooltip-ca-viewsource'           => '文函緘，讀源老',
'tooltip-ca-history'              => '誌流衍、備謄本、修惡盜',
'tooltip-ca-protect'              => '謝撰纂，奏原調',
'tooltip-ca-unprotect'            => '和原調，以撰纂',
'tooltip-ca-delete'               => '撕書頁，棄於奧',
'tooltip-ca-undelete'             => '悔刪斷，奉回轎',
'tooltip-ca-move'                 => '安居所，嚮正道',
'tooltip-ca-watch'                => '哨此報',
'tooltip-ca-unwatch'              => '撤此哨',
'tooltip-search'                  => '索大典，籲自曉',
'tooltip-search-go'               => '確合契，躍步到',
'tooltip-search-fulltext'         => '尋通篇，列倣傚',
'tooltip-p-logo'                  => '返卷首，訪露朝',
'tooltip-n-mainpage'              => '返卷首，訪露朝',
'tooltip-n-mainpage-description'  => '返卷首，訪露朝',
'tooltip-n-portal'                => '識百科、習施行、熟矩教',
'tooltip-n-currentevents'         => '知天下、順潮流、察脈絡',
'tooltip-n-recentchanges'         => '閱新易、聞脈搏、觀熱鬧',
'tooltip-n-randompage'            => '嚐鮮味，隨遊遨',
'tooltip-n-help'                  => '解疑惑、點明燈、掛病號',
'tooltip-t-whatlinkshere'         => '何美餚，佐此料',
'tooltip-t-recentchangeslinked'   => '足義友，借鏡照',
'tooltip-feed-rss'                => '本卷之RSS源',
'tooltip-feed-atom'               => '本卷之Atom源',
'tooltip-t-contributions'         => '同肩戰，苦功高',
'tooltip-t-emailuser'             => '言未猶，書信捎',
'tooltip-t-upload'                => '貢彩件、獻樂謠',
'tooltip-t-specialpages'          => '奇怪求，特查找',
'tooltip-t-print'                 => '備印墨，整版貌',
'tooltip-t-permalink'             => '鏈緊焊，橋吊牢',
'tooltip-ca-nstab-main'           => '閱文稿',
'tooltip-ca-nstab-user'           => '返齋寮',
'tooltip-ca-nstab-media'          => '聽媒紹',
'tooltip-ca-nstab-special'        => '特查報，謝纂校',
'tooltip-ca-nstab-project'        => '探爐灶',
'tooltip-ca-nstab-image'          => '觀揮毫',
'tooltip-ca-nstab-mediawiki'      => '聞官耗',
'tooltip-ca-nstab-template'       => '尋模造',
'tooltip-ca-nstab-help'           => '助拳腳',
'tooltip-ca-nstab-category'       => '入門道',
'tooltip-minoredit'               => '正小錯，謙註校',
'tooltip-save'                    => '葺修畢，儲之窖',
'tooltip-preview'                 => '篤存儲，先草稿',
'tooltip-diff'                    => '留筆過，觀入刀',
'tooltip-compareselectedversions' => '揀二審，辨毀造',
'tooltip-watch'                   => '哨此報',
'tooltip-recreate'                => '昔棄鄙，重起灶',
'tooltip-upload'                  => '獻品備，伐步跑',
'tooltip-rollback'                => '『返』乃反之上貢也。',
'tooltip-undo'                    => '『復』乃開表加因也。',

# Stylesheets
'common.css'      => '/* 此之 CSS 用於全面也 */',
'standard.css'    => '/* 此之 CSS 用於經典面之簿也 */',
'nostalgia.css'   => '/* 此之 CSS 用於懷古面之簿也 */',
'cologneblue.css' => '/* 此之 CSS 用於馨藍面之簿也 */',
'monobook.css'    => '/* 此之 CSS 用於單書面之簿也 */',
'myskin.css'      => '/* 此之 CSS 用於吾風面之簿也 */',
'chick.css'       => '/* 此之 CSS 用於窈窕面之簿也 */',
'simple.css'      => '/* 此之 CSS 用於簡明面之簿也 */',
'modern.css'      => '/* 此之 CSS 用於時髦面之簿也 */',
'vector.css'      => '/* 此之 CSS 用於動力面之簿也 */',
'print.css'       => '/* 此之 CSS 用於印之出力也 */',
'handheld.css'    => '/* 此之 CSS 用於 $wgHandheldStyle 之手置面也 */',

# Scripts
'common.js'      => '/* 此之JavaScript將載於全簿之頁。 */',
'standard.js'    => '/* 此之JavaScript將載於用經典面之簿 */',
'nostalgia.js'   => '/* 此之JavaScript將載於用懷古面之簿 */',
'cologneblue.js' => '/* 此之JavaScript將載於用馨藍面之簿 */',
'monobook.js'    => '/* 此之JavaScript將載於用單書面之簿 */',
'myskin.js'      => '/* 此之JavaScript將載於用吾風面之簿 */',
'chick.js'       => '/* 此之JavaScript將載於用窈窕面之簿 */',
'simple.js'      => '/* 此之JavaScript將載於用簡明面之簿 */',
'modern.js'      => '/* 此之JavaScript將載於用時髦面之簿 */',
'vector.js'      => '/* 此之JavaScript將載於用動力面之簿 */',

# Attribution
'anonymous'        => '{{SITENAME}}無{{PLURAL:$1|簿|簿}}者',
'siteuser'         => '{{SITENAME}}有簿者$1',
'anonuser'         => '{{SITENAME}}有匿簿者$1',
'lastmodifiedatby' => '$1$2，$3新易此頁。',
'othercontribs'    => '$1主撰',
'others'           => '他',
'siteusers'        => '{{SITENAME}}有{{PLURAL:$2|簿|簿}}者$1',
'anonusers'        => '{{SITENAME}}有匿{{PLURAL:$2|簿|簿}}者$1',
'creditspage'      => '頁贊',
'nocredits'        => '本頁未有贊信也。',

# Spam protection
'spamprotectiontitle' => '防賈濫',
'spamprotectiontext'  => '外鏈疑賈。
存頁止焉。',
'spamprotectionmatch' => '憑如下：$1',
'spambot_username'    => 'MediaWiki清濫',
'spam_reverting'      => '還新審之無鏈$1者。',
'spam_blanking'       => '審皆鏈$1，遂令白頁。',

# Info page
'infosubtitle'   => '頁註',
'numedits'       => '有纂$1',
'numtalkedits'   => '有議$1',
'numwatchers'    => '有哨$1',
'numauthors'     => '編者$1',
'numtalkauthors' => '議者$1',

# Skin names
'skinname-standard'    => '經典',
'skinname-nostalgia'   => '懷古',
'skinname-cologneblue' => '馨藍',
'skinname-monobook'    => '單書',
'skinname-myskin'      => '吾風',
'skinname-chick'       => '窈窕',
'skinname-simple'      => '簡明',
'skinname-modern'      => '時髦',
'skinname-vector'      => '動力',

# Math options
'mw_math_png'    => '屢作PNG',
'mw_math_simple' => '易為則作HTML，否則PNG',
'mw_math_html'   => '堪為則作HTML，否則PNG',
'mw_math_source' => 'TeX依舊，純文覽器適也。',
'mw_math_modern' => '今之覽器此薦。',
'mw_math_mathml' => '實驗者，堪為則作MathML。',

# Math errors
'math_failure'          => '譯不成',
'math_unknown_error'    => '未知之誤',
'math_unknown_function' => '未知函式',
'math_lexing_error'     => '律有誤',
'math_syntax_error'     => '語法有誤',
'math_image_error'      => 'PNG 轉敗之；查已裝 latex, dvipng（或dvips + gs + convert）乎',
'math_bad_tmpdir'       => '無寫或建數式臨目',
'math_bad_output'       => '無寫或建數式出目',
'math_notexvc'          => '少「texvc」；參 math/README 置之。',

# Patrolling
'markaspatrolleddiff'                 => '派哨',
'markaspatrolledtext'                 => '哨此報',
'markedaspatrolled'                   => '派哨',
'markedaspatrolledtext'               => '[[:$1]]之審哨矣。',
'rcpatroldisabled'                    => '不哨近易',
'rcpatroldisabledtext'                => '近易之哨，未准行也。',
'markedaspatrollederror'              => '哨有誤',
'markedaspatrollederrortext'          => '揀一以哨。',
'markedaspatrollederror-noautopatrol' => '己易不可哨。',

# Patrol log
'patrol-log-page'      => '誌哨',
'patrol-log-header'    => '此乃誌哨也。',
'patrol-log-line'      => '令哨$2之$1$3',
'patrol-log-auto'      => '（自行）',
'log-show-hide-patrol' => '$1誌巡',

# Image deletion
'deletedrevision'                 => '刪舊審$1',
'filedeleteerror-short'           => '刪檔有誤：$1',
'filedeleteerror-long'            => '刪檔有誤：

$1',
'filedelete-missing'              => '"$1"不存，無可刪也。',
'filedelete-old-unregistered'     => '庫無舊審"$1"。',
'filedelete-current-unregistered' => '庫無"$1"也。',
'filedelete-archive-read-only'    => '"$1"存匣，未准更之。',

# Browsing diffs
'previousdiff' => '←前辨',
'nextdiff'     => '後辨→',

# Media information
'mediawarning'         => "'''警'''：此檔型疑惡。行之恐諜也。",
'imagemaxsize'         => "述檔頁惟列：<br />''（用於檔）''",
'thumbsize'            => '縮圖幅',
'widthheight'          => '$1矩$2',
'widthheightpage'      => '$1矩$2，共$3頁',
'file-info'            => '（大小：$1，MIME類型：$2）',
'file-info-size'       => '（像素$1矩$2，大小：$3，MIME類型：$4）',
'file-nohires'         => '<small>無以更晰。</small>',
'svg-long-desc'        => '（SVG檔，貌有像素$1矩$2，幅$3）',
'show-big-image'       => '全幅',
'show-big-image-thumb' => '<small>縮圖幅有像素$1矩$2</small>',
'file-info-gif-looped' => '循',
'file-info-gif-frames' => '$1幀',

# Special:NewFiles
'newimages'             => '新圖之廊',
'imagelisttext'         => "下表乃按$2排之的'''$1'''檔。",
'newimages-summary'     => '此奇頁示最後呈上之檔也。',
'newimages-legend'      => '濾',
'newimages-label'       => '名（或其部）：',
'showhidebots'          => '（$1僕）',
'noimages'              => '無可見。',
'ilsubmit'              => '尋檔',
'bydate'                => '時序',
'sp-newimages-showfrom' => '自$1 $2賞新檔',

# Video information, used by Language::formatTimePeriod() to format lengths in the above messages
'video-dims' => '$1，$2矩$3',

# Bad image list
'bad_image_list' => '僅取表件，冠「*」者也。格式如下：

單列數鏈，首通壞檔；而後所鏈之文，允圖見於其內。',

# Metadata
'metadata'          => '補註',
'metadata-help'     => '此檔補註，製者所添，如相機、掃描之器；後若更檔，補註不誠也。',
'metadata-expand'   => '見詳',
'metadata-collapse' => '藏詳',
'metadata-fields'   => '若藏詳，此下EXIF補註方現，否則藏焉。
* make
* model
* datetimeoriginal
* exposuretime
* fnumber
* isospeedratings
* focallength',

# EXIF tags
'exif-imagewidth'                => '寬',
'exif-imagelength'               => '長',
'exif-photometricinterpretation' => '像素構成',
'exif-datetime'                  => '文檔修訂之日期時辰',
'exif-make'                      => '出廠',
'exif-model'                     => '型號',
'exif-artist'                    => '作者',
'exif-exifversion'               => 'Exif版本',
'exif-datetimeoriginal'          => '數據生成之日期時辰',
'exif-datetimedigitized'         => '數位化之日期時辰',
'exif-exposuretime'              => '曝光',
'exif-exposuretime-format'       => '$1 秒 （$2）',
'exif-fnumber'                   => '光圈',
'exif-aperturevalue'             => '光圈',
'exif-brightnessvalue'           => '光度',
'exif-flash'                     => '閃光燈',
'exif-focallength'               => '焦距',
'exif-flashenergy'               => '閃光燈能量',
'exif-contrast'                  => '對比',
'exif-saturation'                => '飽和度',
'exif-sharpness'                 => '清晰度',

'exif-meteringmode-255' => '其他',

# Flash modes
'exif-flash-fired-0'    => '閃無火',
'exif-flash-fired-1'    => '閃開火',
'exif-flash-return-0'   => '無閃測',
'exif-flash-return-2'   => '閃無測光',
'exif-flash-return-3'   => '閃測光',
'exif-flash-mode-1'     => '強開閃',
'exif-flash-mode-2'     => '強閉閃',
'exif-flash-mode-3'     => '自模',
'exif-flash-function-1' => '無閃',
'exif-flash-redeye-1'   => '紅退模',

'exif-focalplaneresolutionunit-2' => '吋',

'exif-gaincontrol-0' => '無',

# External editor support
'edit-externally'      => '以外部程式修此文',
'edit-externally-help' => '（請閱[http://www.mediawiki.org/wiki/Manual:External_editors 安裝指引]以知詳情）',

# 'all' in various places, this might be different for inflected languages
'recentchangesall' => '全',
'imagelistall'     => '全',
'watchlistall2'    => '全',
'namespacesall'    => '全',
'monthsall'        => '全',
'limitall'         => '全',

# E-mail address confirmation
'confirmemail'             => '核郵驛',
'confirmemail_noemail'     => '[[Special:Preferences|簿註]]有驛。',
'confirmemail_send'        => '遣核符',
'confirmemail_sent'        => '核符遣矣',
'confirmemail_sendfailed'  => '{{SITENAME}}信未遣焉，請核郵驛。

郵者覆之：$1',
'confirmemail_body'        => '持IP $1之人（亦為汝）於{{SITENAME}}建簿"$2"，並呈電郵位址。

確此簿屬爾，並用{{SITENAME}}之電郵。
於瀏覽器上開此連：

$3

如汝之簿*未*增，
於瀏覽器上開此連消確：

$5

確碼於$4過之。',
'confirmemail_invalidated' => '核郵驛消也',
'invalidateemail'          => '消核郵驛',

# Scary transclusion
'scarytranscludedisabled' => '[蓋跨共筆之轉碼者，莫之能用也]',
'scarytranscludefailed'   => '[$1模不得]',
'scarytranscludetoolong'  => '[網址過長]',

# Trackbacks
'trackbackbox'      => '此文之引:<br />
$1',
'trackbackremove'   => '（[$1刪]）',
'trackbacklink'     => '迴響',
'trackbackdeleteok' => 'Trackback 刪矣。',

# Delete conflict
'deletedwhileediting' => '警：纂中見刪。',
'confirmrecreate'     => "[[User:$1|$1]]（[[User talk:$1|議]]）刪之有由：
''$2''
請爾審視之。",
'recreate'            => '復',

# action=purge
'confirm_purge_button' => '准',
'confirm-purge-top'    => '清謄本？',
'confirm-purge-bottom' => '清頁會清謄本以迫示近審。',

# Separators for various lists, etc.
'semicolon-separator' => '；',
'comma-separator'     => '、',
'colon-separator'     => '：',
'pipe-separator'      => '｜',
'word-separator'      => '',
'ellipsis'            => '……',

# Multipage image navigation
'imgmultipageprev' => '←前頁',
'imgmultipagenext' => '次頁→',
'imgmultigo'       => '往',
'imgmultigoto'     => '往頁$1',

# Table pager
'ascending_abbrev'         => '升冪',
'descending_abbrev'        => '降冪',
'table_pager_next'         => '次頁',
'table_pager_prev'         => '前頁',
'table_pager_first'        => '首頁',
'table_pager_last'         => '末頁',
'table_pager_limit'        => '頁有物$1',
'table_pager_limit_submit' => '往',
'table_pager_empty'        => '空',

# Auto-summaries
'autosumm-blank'   => '盡除之',
'autosumm-replace' => '置為「$1」',
'autoredircomment' => '渡至[[$1]]',
'autosumm-new'     => '新文「$1」',

# Size units
'size-bytes' => '$1 位元組',

# Live preview
'livepreview-loading' => '遺藏…',
'livepreview-ready'   => '藏至矣。',
'livepreview-failed'  => '弗能即時示之！
嘗以本法。',
'livepreview-error'   => '莫之連也：$1 "$2"。
嘗以本法。',

# Friendlier slave lag warnings
'lag-warn-normal' => '近$1秒新易者疑喪也。',
'lag-warn-high'   => '遣藏遲焉。近$1秒新易者疑喪也。',

# Watchlist editor
'watchlistedit-numitems'       => '不計議論，哨有題$1。',
'watchlistedit-noitems'        => '哨無題也。',
'watchlistedit-normal-title'   => '治哨站',
'watchlistedit-normal-legend'  => '撤之',
'watchlistedit-normal-explain' => '盡列有哨。欲撤題，揀之再擊『{{int:Watchlistedit-normal-submit}}』。亦[[Special:Watchlist/raw|治源哨]]也。',
'watchlistedit-normal-submit'  => '撤題',
'watchlistedit-normal-done'    => '$1題之哨已撤：',
'watchlistedit-raw-title'      => '治源哨',
'watchlistedit-raw-legend'     => '治源哨',
'watchlistedit-raw-explain'    => '盡列有哨。治此表以加減題；一行一題之。善，擊{{int:Watchlistedit-raw-submit}}。亦[[Special:Watchlist/edit|標準治哨]]也。',
'watchlistedit-raw-titles'     => '題：',
'watchlistedit-raw-submit'     => '更哨',
'watchlistedit-raw-done'       => '哨更矣。',
'watchlistedit-raw-added'      => '已添$1題：',
'watchlistedit-raw-removed'    => '已撤$1題：',

# Watchlist editing tools
'watchlisttools-view' => '察易',
'watchlisttools-edit' => '治哨站',
'watchlisttools-raw'  => '治源哨',

# Core parser functions
'unknown_extension_tag' => '未明之擴標「$1」',
'duplicate-defaultsort' => '警：預之排鍵「$2」蓋前之排鍵「$1」。',

# Special:Version
'version'                          => '版',
'version-extensions'               => '裝展',
'version-specialpages'             => '奇頁',
'version-parserhooks'              => '語鈎',
'version-variables'                => '變數',
'version-other'                    => '他',
'version-mediahandlers'            => '媒處',
'version-hooks'                    => '鈎',
'version-extension-functions'      => '展函',
'version-parser-extensiontags'     => '語展標',
'version-parser-function-hooks'    => '語函鈎',
'version-skin-extension-functions' => '面版展函',
'version-hook-name'                => '鈎名',
'version-hook-subscribedby'        => '用於',
'version-version'                  => '（版 $1）',
'version-license'                  => '牌',
'version-software'                 => '裝件',
'version-software-product'         => '品',
'version-software-version'         => '版',

# Special:FilePath
'filepath'         => '檔路',
'filepath-page'    => '檔名：',
'filepath-submit'  => '往',
'filepath-summary' => '此奇頁取一檔之整路。圖以全解像示之，他檔會以有關之程式啟動也。

輸檔名之，不包「{{ns:file}}:」開頭也。',

# Special:FileDuplicateSearch
'fileduplicatesearch'          => '擇重檔',
'fileduplicatesearch-summary'  => '以重檔之切去查重也。

入名時無 "{{ns:file}}:" 首也。',
'fileduplicatesearch-legend'   => '尋重',
'fileduplicatesearch-filename' => '名：',
'fileduplicatesearch-submit'   => '尋',
'fileduplicatesearch-info'     => '像素$1矩$2<br />大小：$3<br />MIME類型：$4',
'fileduplicatesearch-result-1' => '案 "$1" 無重也。',
'fileduplicatesearch-result-n' => '案 "$1" 重有$2。',

# Special:SpecialPages
'specialpages'                   => '特查',
'specialpages-note'              => '----
* 準特查。
* <strong class="mw-specialpagerestricted">限特查。</strong>',
'specialpages-group-maintenance' => '護報',
'specialpages-group-other'       => '它之奇頁',
'specialpages-group-login'       => '登／增',
'specialpages-group-changes'     => '近易與誌',
'specialpages-group-media'       => '媒報兼呈',
'specialpages-group-users'       => '簿與權',
'specialpages-group-highuse'     => '高用頁',
'specialpages-group-pages'       => '頁列',
'specialpages-group-pagetools'   => '頁器',
'specialpages-group-wiki'        => 'Wiki訊與器',
'specialpages-group-redirects'   => '轉之特查',
'specialpages-group-spam'        => '反垃圾之器',

# Special:BlankPage
'blankpage'              => '白頁',
'intentionallyblankpage' => '此頁為白也，試速之用',

# External image whitelist
'external_image_whitelist' => ' #同留<pre>
#下（中之//）乃正表式
#乃外（連）圖配之
#配乃成像，非配則成連
#有 # 之為注
#無為大小之異也

#入正表式。同留</pre>',

# Special:Tags
'tags-tag'  => '標名',
'tags-edit' => '纂',

# HTML forms
'htmlform-invalid-input'       => '爾之輸問也',
'htmlform-select-badoption'    => '爾之值為非效之。',
'htmlform-int-invalid'         => '爾之值為非整數也。',
'htmlform-float-invalid'       => '爾之值為非數字也。',
'htmlform-int-toolow'          => '爾之值比$1以低',
'htmlform-int-toohigh'         => '爾之值比$1以高',
'htmlform-submit'              => '呈',
'htmlform-reset'               => '復',
'htmlform-selectorother-other' => '他',

);
