#!/bin/bash
# UUID	(http://www.ossp.org/pkg/lib/uuid/)
#	BuildScript for Plamo Linux 4.5
#			by Jun Kuwamura <juk@linet.gr.jp> on 2011-04-29
# require:
#
SRC_URI=ftp://ftp.ossp.org/pkg/lib/uuid/uuid-1.6.2.tar.gz
SRC_URI=http://www.mirrorservice.org/sites/ftp.ossp.org/pkg/lib/uuid/uuid-1.6.2.tar.gz
SRC_FILE=${SRC_URI##*/}
PAC_NAME=${SRC_FILE%%.tar.gz}

REL=P1
CPU=i586
SYS_NAME="${CPU}-${REL}"

PLAMO=/expo/Build
SRC_DIR=$PLAMO/Archive/devel
PAC_DIR=$PLAMO/Packages/4.7/Develop
BUILD_DIR=$PLAMO/ossp-uuid
CUSTOM_DIR=$BUILD_DIR/Custom

echo $PAC_DIR
if [ ! -d $PAC_DIR ]; then
  mkdir -p  $PAC_DIR
fi
echo $SRC_DIR/$SRC_FILE
if [ ! -f $SRC_DIR/$SRC_FILE ]; then
  if [ ! -d $SRC_DIR ]; then
    mkdir -p $SRC_DIR
  fi
  ( cd $SRC_DIR; wget $SRC_URI )
fi


umask 022
CWD=`pwd`
WORK=$CWD/work
rm -rf $WORK/*
mkdir -p $WORK
export LANG=C
export LC_ALL=C
export PATH=$PATH:/usr/X11R6/bin


tar xvfz $SRC_DIR/$SRC_FILE
cd $PAC_NAME
./configure --prefix=/usr \

export CFLAGS="-O2 -mcpu=$CPU"
make 
make install DESTDIR=$WORK

DOC_DIR=$WORK/usr/share/doc/$PAC_NAME
mkdir -p $DOC_DIR
cp -p	AUTHORS    HISTORY     NEWS      README   TODO  \
	BINDINGS   INSTALL     OVERVIEW  SEEALSO  USERS \
	ChangeLog  MANIFEST    PORTING   THANKS  \
	$DOC_DIR/
cp -p $BUILD_DIR/`basename $0`  $DOC_DIR/
chown -R root.root $DOC_DIR
chmod -R a+rX $DOC_DIR

cd $WORK
echo "y
1
" | makepkg ${PAC_NAME}-${SYS_NAME}.tgz

echo -n "$PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz"
if `mv -v ${PAC_NAME}-${SYS_NAME}.tgz  $PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz 1>/dev/null 2>&1`; then
  echo " ... done"
else
  echo " ... false"
fi

cd $CWD
