/*
 *
 * UNICON - The Console Chinese & I18N
 * Copyright (c) 1999-2000
 *
 * This file is part of UNICON, a console Chinese & I18N
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * See the file COPYING directory of this archive
 * Author: see CREDITS
 */

#include <linux/module.h>
#include <linux/fb_doublebyte.h>
#include "font_eucjp16.h"
#define min1 0xa1
#define max1 0xfe
// 0x2121 -- 0x7424

#ifdef MODULE_LICENSE
MODULE_LICENSE("GPL");
#endif

static int index_euc(int left, int right)
{
        if ( left == 0x8E )
                left = 0;
        else
                left &= 0x7F;
        right &= 0x7F;

        if (left > 0x29)
                return ((right - 0x40 + (left - 0x25) * 96) << 5);
        else
        return ((right - 0x20 + (left - 0x20) * 96) << 5);
}

static int is_hz_left(int c)
{
        return ( c >= min1 && c<=max1);
}

static int is_hz_right(int c)
{
        return ( c >= min1 && c<=max1);
}

#ifdef MODULE
static struct double_byte db_eucjp =
#else
struct double_byte db_eucjp =
#endif
{
	0,
	"EUCJP",
	is_hz_left,
	is_hz_right,
	index_euc,
	16,16,
	max_jis16,
	font_jis16
};

#ifdef MODULE
int init_module(void)
{
        if (UniconFontManager == (DBFontManager *) 0)
            return 1;
        if (UniconFontManager->registerfont (XL_DB_EUCJP, &db_eucjp) == 0)
            return 1;
        return 0;
}
	
void cleanup_module(void)
{
        if (UniconFontManager == (DBFontManager *) 0)
            return;
        UniconFontManager->unregisterfont (XL_DB_EUCJP);
}	
#endif
