#!/bin/bash
# phpPgAdmin
#	BuildScript for Plamo Linux 4.7
#			by Jun Kuwamura <juk@linet.gr.jp> on 2010-09-16
# require:
#	httpd-2.2
#	php-5.3
#	postgresql-9.0
#
VERSION="5.0.2"
#SRC_URI="http://jaist.dl.sourceforge.net/sourceforge/phppgadmin/phpPgAdmin-${VERSION}.tar.gz"
SRC_URI="http://downloads.sourceforge.net/sourceforge/phppgadmin/phpPgAdmin-${VERSION}.tar.gz"
SRC_FILE=${SRC_URI##*/}
PAC_NAME=${SRC_FILE%%.tar.gz}

REL=P1
CPU=noname
SYS_NAME="${CPU}-${REL}"

PLAMO=/expo/Build
SRC_DIR=$PLAMO/Archive/www/php/appli
PAC_DIR=$PLAMO/Packages/4.7/09_webdb/03_PHP.tgz/
BUILD_DIR=$PLAMO/phppgadmin
CUSTOM_DIR=$BUILD_DIR/Custom


echo $PAC_DIR
if [ ! -d $PAC_DIR ]; then
  mkdir -p  $PAC_DIR || exit 1;
fi
echo $SRC_DIR/$SRC_FILE
if [ ! -f $SRC_DIR/$SRC_FILE ]; then
  if [ ! -d $SRC_DIR ]; then
    mkdir -p $SRC_DIR
  fi
  ( cd $SRC_DIR; wget $SRC_URI ) || exit 1;
fi


umask 022
CWD=`pwd`
WORK=$CWD/work
rm -rf $WORK/*
mkdir -p $WORK || exit 1;
export LANG=C
export LC_ALL=C
export CFLAGS="-O2 -march=$CPU"
export PATH=$PATH:/usr/X11R7/bin


cd $WORK
DESTDIR=$WORK/opt/htdocs/
mkdir -p $DESTDIR || exit 1;
DOC_DIR=usr/share/doc/$PAC_NAME
tar xvfz $SRC_DIR/$SRC_FILE -C $DESTDIR
( cd $DESTDIR/$PAC_NAME; \
  if [ "$PAT_FILE" != "" ]; then
    patch < $CUSTOM_DIR/$PAT_FILE
  fi
  sed -e "/\$conf\['servers'\]\[0\]\['host'\]/i \	\$conf['servers'][0]['host'] = '127.0.0.1';" \
      -e "/\$conf\['servers'\]\[0\]\['host'\]/d" \
	./conf/config.inc.php-dist > ./conf/config.inc.php
  mv ./conf/config.inc.php ./conf/config.inc.php-dist

  mkdir -p $WORK/$DOC_DIR || exit 1
  cp -p $BUILD_DIR/`basename $0`  \
        TRANSLATORS TODO LICENSE INSTALL HISTORY FAQ DEVELOPERS \
	CREDITS $WORK/$DOC_DIR
)

chown -R wadm:apache  $DESTDIR/$PAC_NAM
chown -R root:root $WORK/$DOC_DIR
chmod -R a+rX,go-w $WORK/$DOC_DIR

mkdir -p $DESTDIR/AppList || exit 1;
TYP=2 
cat >> $DESTDIR/AppList/$TYP.$PAC_NAME.list <<__EOCL__
TYP	$TYP
NAM	${PAC_NAME}
URL	http://phppgadmin.sourceforge.net/
DOC	/usr/share/doc/${PAC_NAME}
EXE	/phpPgAdmin/
REM	PostgreSQL Web󥿡ե
__EOCL__


cd $WORK
mkdir -p opt/pgsql/bin
cp $CUSTOM_DIR/pg_passwd.sh opt/pgsql/bin/
chmod +x opt/pgsql/bin/pg_passwd.sh
mkdir -p install
sed -e "s/_VERSION_/$VERSION/g" \
    -e "s/_PACKAGENAME_/${PAC_NAME}-${SYS_NAME}/g" \
    $CUSTOM_DIR/doinst.sh > install/doinst.sh
#cp $CUSTOM_DIR/.ini.php $DESTDIR/$PAC_NAME 


tar cvfz ${PAC_NAME}.tgz  opt/htdocs/${PAC_NAME}  opt/htdocs/AppList/* ${DOC_DIR} opt/pgsql/bin/pg_passwd.sh install/doinst.sh

echo -n "$PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz"
if `mv -v ${PAC_NAME}.tgz  $PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz 1>/dev/null 2>&1`; then
  echo " ... done"
else
  echo " ... false"
fi

cd $CWD
