#!/bin/bash
# StatusNet (formerly Laconica) for Apache-2.2+PHP5
#	BuildScript for Plamo Linux 4.7
#			by Jun Kuwamura <juk@linet.gr.jp> on 2011-07-31
# require:
#	httpd-2.2.x
#	php-5.3.x
#
VERSION=0.9.7fix1
SRC_URI="http://status.net/statusnet-${VERSION}.tar.gz"

SRC_FILE=${SRC_URI##*/}
SRC_NAME=${SRC_FILE%%.tar.gz}
PAC_NAME=statusnet-${VERSION}

REL=P1
CPU=noarch
SYS_NAME="${CPU}-${REL}"

PLAMO=/expo/Build
SRC_DIR=$PLAMO/Archive/www/php/appli
PAC_DIR=$PLAMO/Packages/4.7/09_webdb/03_PHP.tgz
BUILD_DIR=$PLAMO/statusnet
CUSTOM_DIR=${BUILD_DIR}/Custom
PAT_FILE=statusnet_pg.php.diff

echo $PAC_DIR
if [ ! -d $PAC_DIR ]; then
  mkdir -p  $PAC_DIR
fi
echo $SRC_DIR/$SRC_FILE
if [ ! -f $SRC_DIR/$SRC_FILE ]; then
  if [ ! -d $SRC_DIR ]; then
    mkdir -p $SRC_DIR
  fi
  ( cd $SRC_DIR; wget $SRC_URI )
fi


umask 022
CWD=`pwd`
WORK=$CWD/work
rm -rf $WORK/*
mkdir -p $WORK
export LANG=C
export LC_ALL=C
export CFLAGS="-O2 -march=$CPU"
export PATH=$PATH:/usr/X11R7/bin:/opt/teTeX/bin:/opt/php5/bin


tar xvfz $SRC_DIR/$SRC_FILE
if [ -f "$PAT_FILE" ]; then
  patch < $PAT_FILE
fi
if [ "$SRC_NAME" != "$PAC_NAME" ]; then
  mv $SRC_NAME $PAC_NAME
fi
cd $PAC_NAME

if [ "$PAT_FILE" != "" ]; then
  patch -p1 < $CUSTOM_DIR/$PAT_FILE
fi

DOC_DIR=/usr/share/doc/$PAC_NAME
mkdir -p $WORK/$DOC_DIR
if [ "$PAT_FILE" != "" ]; then
  cp -p $CUSTOM_DIR/$PAT_FILE   $WORK/$DOC_DIR
fi
cp -p $CUSTOM_DIR/config-096.pgsql.php   $WORK/$DOC_DIR
cp -p COPYING EVENTS.txt README   $WORK/$DOC_DIR
cp -p $BUILD_DIR/`basename $0`  \
    $WORK/$DOC_DIR
chown -R root.root $WORK/$DOC_DIR
chmod -R a+rX,go-w $WORK/$DOC_DIR

cd ..

DESTDIR=$WORK/opt/htdocs/
mkdir -p $DESTDIR
mv $PAC_NAME $DESTDIR

cd $WORK
mkdir -p install
sed -e "s/_VERSION_/$VERSION/g" \
    -e "s/_PACKAGENAME_/${PAC_NAME}-${SYS_NAME}/" \
    $CUSTOM_DIR/doinst.sh-096 > install/doinst.sh

#cp -p $CUSTOM_DIR/config-096.pgsql.php opt/htdocs/$PAC_NAME/config.pgsql.php
cp -p $CUSTOM_DIR/create_statusnet_db.sh opt/htdocs/$PAC_NAME/db/
(cd opt/htdocs/$PAC_NAME/db;
 mv statusnet_pg.sql statusnet_pg.sql.bak;
 sed -e  's/english/japanese/' statusnet_pg.sql.bak > statusnet_pg.sql;
 mv sms_carrier.sql sms_carrier.sql.bak;
 sed -e  "s/\\\'/\'\'/" sms_carrier.sql.bak > sms_carrier.sql;
)


mkdir -p $WORK/opt/htdocs/AppList || exit 1
TYP=2 #(0:httpd, 1:libraries, 2:application)
cat >> $WORK/opt/htdocs/AppList/${TYP}.${PAC_NAME}.list <<__EOCL__
TYP	$TYP
NAM	${PAC_NAME}
URL	http://status.net/
DOC	${DOC_DIR}/
EXE	/statusnet/
REM	micro blog(timeline) written in PHP with eventlist/evententry plugin
__EOCL__


echo "n
" | makepkg ${PAC_NAME}.tgz

echo -n "$PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz"
if `mv -v ${PAC_NAME}.tgz  $PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz 1>/dev/null 2>&1`; then
  echo " ... done"
else
  echo " ... false"
fi

cd $CWD
