#!/bin/sh
#
#                           Time-stamp: <2004-03-07 18:47:19 cyamauch>
#                           Time-stamp: <2011-10-08 16:48:55 tamuki>

if [ -z "$1" ] ; then
  echo "Specify Source directory."
  exit 0
fi

SOURCE_DIR=$1
DEFAULT_DIRNAME=Default
DEFAULT_DIR=${SOURCE_DIR%/*}/$DEFAULT_DIRNAME

FSIZE_UI=${2:-12}
FSIZE_TERM=${3:-14}
FSIZE_EDITOR=${4:-16}
FSIZE_UI_SMALL=$((FSIZE_UI - 2))
FSIZE_UI_LARGE=$((FSIZE_UI + 2))

echo "[User Interface    : $FSIZE_UI pixels]"
echo "[Terminal and Text : $FSIZE_TERM pixels]"
echo "[Editor (emacs)    : $FSIZE_EDITOR pixels]"

rm -rf $DEFAULT_DIR
cp -a $SOURCE_DIR $DEFAULT_DIR

LST=`grep "@FSIZE_" $SOURCE_DIR/.* | cut -d: -f1 | sort -u`
for i in $LST ; do
  cat $i | sed -e "s/@FSIZE_UI@/$FSIZE_UI/g" \
      -e "s/@FSIZE_TERM@/$FSIZE_TERM/g" \
      -e "s/@FSIZE_EDITOR@/$FSIZE_EDITOR/g" \
      -e "s/@FSIZE_UI_SMALL@/$FSIZE_UI_SMALL/g" \
      -e "s/@FSIZE_UI_LARGE@/$FSIZE_UI_LARGE/g" \
      > `echo $i | sed "s/${SOURCE_DIR##*/}/$DEFAULT_DIRNAME/"`
done

if [ "$FSIZE_TERM" -lt 16 ] ; then
  uudecode <<- "EOF" | gunzip | patch $DEFAULT_DIR/.dir_colors
	begin-base64 644 /dev/stdout
	H4sIAAAAAAAAA42STW/UMBCGz91fYakXkLrImzQp0qJICCpRgQrqCfWWON6st/mSYyDdX489tjMT
	UQGXRE/mnRlbebL0KrsWmXtu3rGPdw+M7/bpNbu4ZLXSUphBP9vCl7v7z1DJXWV67qqhVYK1qn/a
	bLfbTeFb+R+tRWjlL7bmXOTcjv/68O3T+3vGb/Z+B+RcgpmB9UMvZzUZ2Rt2UK0MC0NPmu/5zcXf
	G/JU5Kldc/v99gPcImFhiP/C4Uv+9mq3y4V/2fQb0dUhfcnkLMUPU1atnNirSqvmaFijpexfu6St
	+iS0DR1CZSiUBsGUGmBnp5daHNVPO3rQzLaPWk6TrJdFWtawxjRn3+Kg1CcEU5JKez4inNVIgDGE
	Rwp2MkJ1ThBqWSHosUM4jQ1AZm+gurKR7DDorjSTL8pQdTT2BBp1QKi6kcTC+MzftkSYK1KZVzE6
	zQKhljatKvOvmmylsbGh0FOw1iIkDMHeHeGgzEQWCbJ1nBiFhEKKIMdpBcmKSHCoTgjTE6OHICfq
	4n8K0nux+T/FLoLYLgltTuwIIPYCTuwIIDb/f7GLILZrcQBiRwCxI4DYEUDsBZzLER4pgNgRQOwI
	IHYEEDsCiM1fEruIYruqIxA7AogdAcReYmF85m9bIoDYC6xidJoXO1JLm1YVEHvZSmMgNh6bghN7
	gYQhgNgRvNjLIkG2gtgICYUUAcQmkKyIBEHsCCA2HoKcqIv/afMbuGE8K8cGAAA=
	====
	EOF
fi
