/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.util;

import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Misc {
    public static final int[] doubleIntArray(int[] nArray) {
        int n = nArray.length;
        int[] nArray2 = new int[2 * n];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = nArray[i];
        }
        return nArray2;
    }

    public static final String int2roman(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        while (n >= 1000) {
            stringBuffer.append('m');
            n -= 1000;
        }
        if (n >= 900) {
            stringBuffer.append("cm");
            n -= 900;
        }
        if (n >= 500) {
            stringBuffer.append('d');
            n -= 500;
        }
        if (n >= 400) {
            stringBuffer.append("cd");
            n -= 400;
        }
        while (n >= 100) {
            stringBuffer.append('c');
            n -= 100;
        }
        if (n >= 90) {
            stringBuffer.append("xc");
            n -= 90;
        }
        if (n >= 50) {
            stringBuffer.append('l');
            n -= 50;
        }
        if (n >= 40) {
            stringBuffer.append("xl");
            n -= 40;
        }
        while (n >= 10) {
            stringBuffer.append('x');
            n -= 10;
        }
        if (n >= 9) {
            stringBuffer.append("ix");
            n -= 9;
        }
        if (n >= 5) {
            stringBuffer.append('v');
            n -= 5;
        }
        if (n >= 4) {
            stringBuffer.append("iv");
            n -= 4;
        }
        while (n >= 1) {
            stringBuffer.append('i');
            --n;
        }
        return stringBuffer.toString();
    }

    public static final String int2Roman(int n) {
        return Misc.int2roman(n).toUpperCase();
    }

    public static final String int2arabic(int n) {
        return new Integer(n).toString();
    }

    public static final String int2alph(int n, boolean bl) {
        return new Character((char)(n + 96)).toString();
    }

    public static final String int2Alph(int n, boolean bl) {
        return Misc.int2alph(n, bl).toUpperCase();
    }

    public static final int getPosInteger(String string, int n) {
        int n2;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
        return n2 > 0 ? n2 : n;
    }

    public static final float getFloat(String string, float f) {
        float f2;
        try {
            f2 = Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            return f;
        }
        return f2;
    }

    public static final int getIntegerFromHex(String string, int n) {
        int n2;
        try {
            n2 = Integer.parseInt(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
        return n2;
    }

    public static String truncateLength(String string) {
        if (string.endsWith("inch")) {
            return string.substring(0, string.length() - 2);
        }
        return string;
    }

    private static final float getUpi(String string) {
        if ("in".equals(string)) {
            return 1.0f;
        }
        if ("mm".equals(string)) {
            return 25.4f;
        }
        if ("cm".equals(string)) {
            return 2.54f;
        }
        if ("pc".equals(string)) {
            return 6.0f;
        }
        return 72.0f;
    }

    public static final String length2px(String string) {
        float f = Misc.getFloat(string.substring(0, string.length() - 2), 1.0f);
        String string2 = string.substring(string.length() - 2);
        float f2 = 96.0f / Misc.getUpi(string2) * f;
        if ((double)Math.abs(f2) < 0.01) {
            return "0";
        }
        if (f2 > 0.0f) {
            return Float.toString(f2 < 1.0f ? 1.0f : f2) + "px";
        }
        return Float.toString(f2 > -1.0f ? -1.0f : f2) + "px";
    }

    public static final String multiply(String string, String string2) {
        float f = Misc.getFloat(string.substring(0, string.length() - 1), 1.0f);
        float f2 = Misc.getFloat(string2.substring(0, string2.length() - 2), 1.0f);
        String string3 = string2.substring(string2.length() - 2);
        return Float.toString(f * f2 / 100.0f) + string3;
    }

    public static final String add(String string, String string2) {
        float f = Misc.getFloat(string.substring(0, string.length() - 2), 1.0f);
        String string3 = string.substring(string.length() - 2);
        float f2 = Misc.getFloat(string2.substring(0, string2.length() - 2), 1.0f);
        String string4 = string2.substring(string2.length() - 2);
        return Float.toString(f + Misc.getUpi(string3) / Misc.getUpi(string4) * f2) + string3;
    }

    public static final String trimDocumentName(String string, String string2) {
        String string3 = string.toLowerCase();
        if (string3.endsWith(string2)) {
            int n = string.length();
            int n2 = n - string2.length();
            string = string.substring(0, n2);
        }
        return string;
    }

    public static final String removeExtension(String string) {
        int n = string.lastIndexOf(".");
        if (n < 0) {
            return string;
        }
        return string.substring(0, n);
    }

    public static final String getAttribute(Node node, String string) {
        Node node2;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null && (node2 = namedNodeMap.getNamedItem(string)) != null) {
            return node2.getNodeValue();
        }
        return null;
    }

    public static final Element getChildByTagName(Node node, String string) {
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1 || !node2.getNodeName().equals(string)) continue;
                return (Element)node2;
            }
        }
        return null;
    }
}

