<?php
/** Classical Chinese (文言)
 *
 * @ingroup Language
 * @file
 *
 * @author Itsmine
 */

$skinNames = array(
        'standard' => '經典',
        'nostalgia' => '懷古',
        'cologneblue' => '馨藍',
        'monobook' => '單書',
        'myskin' => '吾風',
	'chick' => '窈窕',
	'simple' => '簡明',
	'modern' => '時髦',
);

/**
 * A list of date format preference keys which can be selected in user
 * preferences. New preference keys can be added, provided they are supported
 * by the language class's timeanddate(). Only the 5 keys listed below are
 * supported by the wikitext converter (DateFormatter.php).
 *
 * The special key "default" is an alias for either dmy or mdy depending on
 * $wgAmericanDates
 */
$datePreferences = array(
	'default',
	'ISO 8601',
);

$defaultDateFormat = 'zh';

/**
 * These are formats for dates generated by MediaWiki (as opposed to the wikitext
 * DateFormatter). Documentation for the format string can be found in
 * Language.php, search for sprintfDate.
 *
 * This array is automatically inherited by all subclasses. Individual keys can be
 * overridden.
 */
$dateFormats = array(
        'zh time' => 'H時i分',
        'zh date' => 'Y年n月j日 （l）',
        'zh both' => 'Y年n月j日 （D） H時i分',
);

$linkTrail = '/^([a-z]+)(.*)$/sD';

$digitTransformTable = array(
	'0' => '〇',
	'1' => '一',
	'2' => '二',
	'3' => '三',
	'4' => '四',
	'5' => '五',
	'6' => '六',
	'7' => '七',
	'8' => '八',
	'9' => '九',
	'.' => '點',
	',' => '',
);

#-------------------------------------------------------------------
# Default messages
#-------------------------------------------------------------------
# Allowed characters in keys are: A-Z, a-z, 0-9, underscore (_) and
# hyphen (-). If you need more characters, you may be able to change
# the regex in MagicWord::initRegex

$messages = array(
# User preference toggles
'tog-underline'               => '鏈墊線',
'tog-highlightbroken'         => '<a href="" class="new">斷鏈</a>，以<a href="" class="internal">？</a>替',
'tog-justify'                 => '齊段落',
'tog-hideminor'               => '隱近校',
'tog-extendwatchlist'         => '展列見變',
'tog-usenewrc'                => '青出近易（JavaScript）',
'tog-numberheadings'          => '生章數',
'tog-showtoolbar'             => '多寶列見（JavaScript）',
'tog-editondblclick'          => '纂頁雙擊（JavaScript）',
'tog-editsection'             => '纂段擊鏈',
'tog-editsectiononrightclick' => '纂段右擊標（JavaScript）',
'tog-showtoc'                 => '四章見目',
'tog-rememberpassword'        => '符節通越',
'tog-editwidth'               => '纂幅全',
'tog-watchcreations'          => '哨己撰',
'tog-watchdefault'            => '哨己纂',
'tog-minordefault'            => '慣為校',
'tog-previewontop'            => '頂草覽',
'tog-previewonfirst'          => '覽首修',
'tog-nocache'                 => '莫謄文',
'tog-enotifwatchlistpages'    => '哨新，遣函',
'tog-enotifusertalkpages'     => '議新，遣函',
'tog-enotifminoredits'        => '校新，遣函',
'tog-enotifrevealaddr'        => '列余址於書內',
'tog-shownumberswatching'     => '放哨有',
'tog-fancysig'                => '署以本碼（免自連）',
'tog-externaleditor'          => '它器修文（高人用，需設之）',
'tog-externaldiff'            => '它器修異（高人用，需設之）',
'tog-showjumplinks'           => '鏈往字',
'tog-uselivepreview'          => '即覽嚐鮮（JavaScript）',
'tog-forceeditsummary'        => '漏概醒之',
'tog-watchlisthideown'        => '不哨己文',
'tog-watchlisthidebots'       => '不哨僕文',
'tog-watchlisthideminor'      => '不哨小纂',
'tog-nolangconversion'        => '非轉',
'tog-ccmeonemails'            => '傳己之副信',
'tog-diffonly'                => '異下無示頁',
'tog-showhiddencats'          => '示隱類',

'underline-always'  => '恆',
'underline-never'   => '絕',
'underline-default' => '慣',

'skinpreview' => '（草覽）',

# Dates
'sunday'        => '週日',
'monday'        => '週一',
'tuesday'       => '週二',
'wednesday'     => '週三',
'thursday'      => '週四',
'friday'        => '週五',
'saturday'      => '週六',
'sun'           => '週日',
'mon'           => '周一',
'tue'           => '周二',
'wed'           => '周三',
'thu'           => '周四',
'fri'           => '周五',
'sat'           => '周六',
'january'       => '一月',
'february'      => '二月',
'march'         => '三月',
'april'         => '四月',
'may_long'      => '五月',
'june'          => '六月',
'july'          => '七月',
'august'        => '八月',
'september'     => '九月',
'october'       => '十月',
'november'      => '十一月',
'december'      => '十二月',
'january-gen'   => '一月',
'february-gen'  => '二月',
'march-gen'     => '三月',
'april-gen'     => '四月',
'may-gen'       => '五月',
'june-gen'      => '六月',
'july-gen'      => '七月',
'august-gen'    => '八月',
'september-gen' => '九月',
'october-gen'   => '十月',
'november-gen'  => '十一月',
'december-gen'  => '十二月',
'jan'           => '一月',
'feb'           => '二月',
'mar'           => '三月',
'apr'           => '四月',
'may'           => '五月',
'jun'           => '六月',
'jul'           => '七月',
'aug'           => '八月',
'sep'           => '九月',
'oct'           => '十月',
'nov'           => '十一月',
'dec'           => '十二月',

# Categories related messages
'pagecategories'                 => '$1類',
'category_header'                => '「$1」中之頁',
'subcategories'                  => '次類',
'category-media-header'          => '「$1」中之媒',
'category-empty'                 => "''無頁或媒也。''",
'hidden-categories'              => '$1隱類',
'hidden-category-category'       => '隱類', # Name of the category where hidden categories will be listed
'category-subcat-count'          => '{{PLURAL:$2|門有戶壹。|門有戶$1，有$2戶也。}}',
'category-subcat-count-limited'  => '門有戶$1。',
'category-article-count'         => '{{PLURAL:$2|門有頁壹。|門有頁$1，有$2頁也。}}',
'category-article-count-limited' => '門有頁$1。',
'category-file-count'            => '{{PLURAL:$2|門有檔壹。|門有檔$1，有$2檔也。}}',
'category-file-count-limited'    => '門有檔$1。',
'listingcontinuesabbrev'         => '續',

'mainpagetext'      => "<big>'''媒維基安置矣'''</big>",
'mainpagedocfooter' => "欲識維基，見[http://meta.wikimedia.org/wiki/Help:Contents User's Guide]

== 始 ==

* [http://www.mediawiki.org/wiki/Manual:Configuration_settings Configuration settings list]
* [http://www.mediawiki.org/wiki/Manual:FAQ MediaWiki FAQ]
* [http://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki release mailing list]",

'about'          => '述',
'article'        => '文',
'newwindow'      => '啟窗',
'cancel'         => '捨',
'qbfind'         => '尋',
'qbbrowse'       => '覽',
'qbedit'         => '纂',
'qbpageoptions'  => '此頁',
'qbpageinfo'     => '內文',
'qbmyoptions'    => '吾好',
'qbspecialpages' => '非凡',
'moredotdotdot'  => '見逾',
'mypage'         => '寒舍',
'mytalk'         => '書房',
'anontalk'       => '與（IP）私議',
'navigation'     => '導',
'and'            => '與',

# Metadata in edit box
'metadata_help' => '衍意：',

'errorpagetitle'    => '誤',
'returnto'          => '返$1。',
'tagline'           => '語出{{SITENAME}}',
'help'              => '助',
'search'            => '尋',
'searchbutton'      => '尋',
'go'                => '往',
'searcharticle'     => '始',
'history'           => '誌',
'history_short'     => '誌',
'updatedmarker'     => '新也',
'info_short'        => '快訊',
'printableversion'  => '印本',
'permalink'         => '恆鏈',
'print'             => '印',
'edit'              => '纂',
'create'            => '立',
'editthispage'      => '纂',
'create-this-page'  => '立',
'delete'            => '刪',
'deletethispage'    => '刪',
'undelete_short'    => '還$1已刪',
'protect'           => '緘',
'protect_change'    => '易',
'protectthispage'   => '緘封',
'unprotect'         => '啟',
'unprotectthispage' => '啟函',
'newpage'           => '新頁',
'talkpage'          => '參議此文',
'talkpagelinktext'  => '議',
'specialpage'       => '特查',
'personaltools'     => '家私',
'postcomment'       => '增一參議',
'articlepage'       => '閱內文',
'talk'              => '議',
'views'             => '覽',
'toolbox'           => '多寶',
'userpage'          => '簿',
'projectpage'       => '計畫',
'imagepage'         => '覽媒',
'mediawikipage'     => '觀訊',
'templatepage'      => '鑄模',
'viewhelppage'      => '助文',
'categorypage'      => '分類',
'viewtalkpage'      => '見議',
'otherlanguages'    => '他山',
'redirectedfrom'    => '（渡自$1）',
'redirectpagesub'   => '渡',
'lastmodifiedat'    => '此頁於$1$2方易。', # $1 date, $2 time
'viewcount'         => '此頁$1閱矣',
'protectedpage'     => '函啟矣',
'jumpto'            => '往：',
'jumptonavigation'  => '嚮',
'jumptosearch'      => '尋',

# All link text and link target definitions of links into project namespace that get used by other message strings, with the exception of user group pages (see grouppage) and the disambiguation template definition (see disambiguations).
'aboutsite'            => '述{{SITENAME}}',
'aboutpage'            => 'Project:述',
'bugreports'           => '錯漏集',
'bugreportspage'       => 'Project:錯漏集',
'copyright'            => '文奉$1行。',
'copyrightpagename'    => '權歸{{SITENAME}}',
'copyrightpage'        => '{{ns:project}}:版權',
'currentevents'        => '世事',
'currentevents-url'    => 'Project:世事',
'disclaimers'          => '免責宣',
'disclaimerpage'       => 'Project:免責宣',
'edithelp'             => '助纂塾',
'edithelppage'         => 'Help:纂',
'faq'                  => '頻答問',
'faqpage'              => 'Project:頻答問',
'helppage'             => 'Help:目錄',
'mainpage'             => '卷首',
'mainpage-description' => '卷首',
'policy-url'           => 'Project:策',
'portal'               => '市集',
'portal-url'           => 'Project:市集',
'privacy'              => '隱私通例',
'privacypage'          => 'Project:隱私通例',

'badaccess'        => '子未逮',
'badaccess-group0' => '子未逮，歉限之。',
'badaccess-group1' => '子非$1，歉限之',

'versionrequired'     => '惠置$1媒維基',
'versionrequiredtext' => '惠置$1媒維基，見[[Special:Version|版]]。',

'ok'                      => '可',
'retrievedfrom'           => '取自"$1"',
'youhavenewmessages'      => '子有$1（$2）',
'newmessageslink'         => '新訊',
'newmessagesdifflink'     => '變更',
'youhavenewmessagesmulti' => '新訊於$1',
'editsection'             => '纂',
'editold'                 => '纂',
'viewsourceold'           => '察源碼',
'editsectionhint'         => '纂 $1',
'toc'                     => '章',
'showtoc'                 => '示',
'hidetoc'                 => '藏',
'thisisdeleted'           => '還$1或閱之？',
'viewdeleted'             => '閱$1之？',
'restorelink'             => '$1已刪',
'feed-unavailable'        => '聯合源於{{SITENAME}}無視也',
'site-rss-feed'           => '$1之RSS源',
'site-atom-feed'          => '$1之Atom源',
'page-rss-feed'           => '「$1」之RSS源',
'page-atom-feed'          => '「$1」之Atom源',
'red-link-title'          => '$1 (未纂)',

# Short words for each namespace, by default used in the namespace tab in monobook
'nstab-main'      => '文',
'nstab-user'      => '齋',
'nstab-media'     => '雅',
'nstab-special'   => '奇',
'nstab-project'   => '策',
'nstab-image'     => '檔',
'nstab-mediawiki' => '訊',
'nstab-template'  => '模',
'nstab-help'      => '助',
'nstab-category'  => '類',

# Main script and global functions
'nosuchaction'      => '無可為',
'nosuchactiontext'  => '無此址',
'nosuchspecialpage' => '無此特查',
'nospecialpagetext' => "'''<big>無此特查。</big>'''

見[[Special:SpecialPages|{{int:specialpages}}]]。",

# General errors
'error'                => '有誤',
'databaseerror'        => '庫藏誤然',
'dberrortext'          => '問庫語誤，或軟體瑕焉。
末語道:
<blockquote><tt>$1</tt></blockquote>
內此函式"<tt>$2</tt>".
MySQL報有誤"<tt>$3: $4</tt>"。',
'dberrortextcl'        => '庫藏問語有誤，末道：
"$1"
內此函式"$2".
MySQL報有誤"$3: $4"',
'noconnect'            => '歉哉有變，莫能問庫藏。<br />
$1',
'nodb'                 => '莫能擇庫$1',
'cachederror'          => '此為謄本，恐不新也',
'laggedslavemode'      => '警示，此頁不新',
'readonly'             => '鎖庫藏',
'enterlockreason'      => '何以鎖之？何日啟之？',
'readonlytext'         => '鎖者曰：「$1」，庫藏鎖矣，撰纂謝焉。',
'missing-article'      => '或舊、或刪，未見昔者"$1" $2。

若非此故，恐有瑕焉，惠呈此址也。',
'missingarticle-rev'   => '（審號：$1）',
'missingarticle-diff'  => '（異：$1，$2）',
'internalerror'        => '家誤',
'internalerror_info'   => '家誤：$1',
'filecopyerror'        => '"$1"謄"$2"，未可為也。',
'filerenameerror'      => '"$2"替"$1"名，未可為也。',
'filedeleteerror'      => '"$1"未可刪也。',
'directorycreateerror' => '立目"$1"，未可為也。',
'filenotfound'         => '"$1"未見。',
'fileexistserror'      => '"$1"存焉，未可儲也。',
'unexpected'           => '異數，"$1"="$2"。',
'formerror'            => '有誤：表不可呈',
'badarticleerror'      => '此頁莫為之',
'cannotdelete'         => '此頁或刪矣，不復為之。',
'badtitle'             => '無此題',
'badtitletext'         => '或別、或缺、或違、或他山謬鏈，此題不存也。',
'perfdisabled'         => '歉哉，此舉累及他人，故謝之。',
'perfcached'           => '下為謄本，恐不新也。',
'perfcachedts'         => '下為謄本，$1新之。',
'wrong_wfQuery_params' => 'wfQuery()參數謬然<br />
函式: $1<br />
問語: $2',
'viewsource'           => '覽源',
'viewsourcefor'        => '$1',
'protectedinterface'   => '此頁司版，緘之以遠濫。',
'editinginterface'     => "'''警示：'''此頁司版，一髮牽身，惠慎之。如譯之，可慮[http://translatewiki.net/wiki/Main_Page?setlang=zh-hant Betawiki]也，為MediaWiki軟件本地化之計劃也。",
'sqlhidden'            => '(SQL隱然)',
'cascadeprotected'     => '此頁"迭緘"矣。$1頁牽連如下：
$2',
'namespaceprotected'   => "子權未逮，莫能纂'''$1'''。",
'customcssjsprotected' => '牽他人，子權未逮，莫能纂之。',
'ns-specialprotected'  => '奇頁禁纂也。',
'titleprotected'       => '緘焉自[[User:$1|$1]]防建也。因<i>$2</i>也。',

# Virus scanner
'virus-badscanner'     => "壞設：不明之病掃：''$1''",
'virus-scanfailed'     => '敗掃（碼$1）',
'virus-unknownscanner' => '不明之反毒：',

# Login and logout pages
'logouttitle'                => '去簿',
'logouttext'                 => '<strong>子去簿矣</strong><br />
子可匿名還覽{{SITENAME}}，或[[Special:UserLogin|復登]]同簿、異簿。未清謄本，覽器文舊，且慎之。',
'welcomecreation'            => '== $1大駕光臨! ==
子簿增矣，敬更[[Special:Preferences|簿註]]。',
'loginpagetitle'             => '合符節',
'yourname'                   => '名',
'yourpassword'               => '符節',
'yourpasswordagain'          => '復核節',
'remembermypassword'         => '記之',
'loginproblem'               => '<b>登簿有誤</b><br />惠再之。',
'login'                      => '登簿',
'nav-login-createaccount'    => '登簿、增簿',
'loginprompt'                => '登簿{{SITENAME}}須cookies，請准之。',
'userlogin'                  => '登簿、增簿',
'logout'                     => '去簿',
'userlogout'                 => '去簿',
'notloggedin'                => '尚未登簿',
'nologin'                    => '無簿乎？往$1。',
'nologinlink'                => '增簿',
'createaccount'              => '增簿',
'gotaccount'                 => '有簿矣哉？往$1。',
'gotaccountlink'             => '登簿',
'createaccountmail'          => '同郵',
'badretype'                  => '符節不合也。',
'userexists'                 => '簿名存矣，惠更之',
'youremail'                  => '郵：',
'username'                   => '簿名：',
'uid'                        => 'ID：',
'prefs-memberingroups'       => '其員{{PLURAL:$1|一|多}}：',
'yourrealname'               => '本名：',
'yourlanguage'               => '語言：',
'yourvariant'                => '變字：',
'yournick'                   => '自畫：',
'badsig'                     => '無效之自畫。
查HTML籤之。',
'badsiglength'               => '自畫長哉。
莫逾$1字。',
'email'                      => '郵',
'prefs-help-realname'        => '可用署也，選填之。',
'loginerror'                 => '登簿誤然',
'prefs-help-email'           => '以匿議重投密也，選填之。',
'prefs-help-email-required'  => '郵須也。',
'nocookiesnew'               => '{{SITENAME}}簿增而未登，惠准cookies後再登之。',
'nocookieslogin'             => '登簿{{SITENAME}}須cookies，惠准之後登。',
'noname'                     => '缺簿名，或不格也。',
'loginsuccesstitle'          => '登簿成矣',
'loginsuccess'               => "'''$1'''登{{SITENAME}}矣",
'nosuchuser'                 => '查無"$1"，惠[[Special:Userlogin/signup|增簿]]或核之。',
'nosuchusershort'            => '查無"<nowiki>$1</nowiki>"，惠核之。',
'nouserspecified'            => '簿名須也',
'wrongpassword'              => '符節不合，惠核之。',
'wrongpasswordempty'         => '缺符節，惠補之。',
'passwordtooshort'           => '符節短錯哉，莫逾$1字，且與簿名異也。',
'mailmypassword'             => '遣吾符節',
'passwordremindertitle'      => '新臨符節自{{SITENAME}}',
'passwordremindertext'       => '$1求遣{{SITENAME}}（$4）："$2"之臨符節為"$3"。

子若罔須或省更之，如舊即可。',
'noemail'                    => '"$1"無存郵也。',
'passwordsent'               => '新節已遣$1"，惠鑒復登之。',
'blocked-mailpassword'       => '爾之IP已錮，密復無用之，以之濫也。',
'eauthentsent'               => '核文遣矣。惠循核之，簿方活也。',
'throttled-mailpassword'     => '密記已寄之於$1時前。
防濫，單一密記短至$1時寄之。',
'mailerror'                  => '信失遣如下：$1',
'acct_creation_throttle_hit' => '歉哉，$1存矣，不可復增也。',
'emailauthenticated'         => '$1郵驛證矣',
'emailnotauthenticated'      => '郵驛<strong>未證</strong>，下不遺書。',
'noemailprefs'               => '郵驛須然如下：',
'emailconfirmlink'           => '惠考郵驛',
'invalidemailaddress'        => '驛址不格，惠正略之。',
'accountcreated'             => '簿增矣',
'accountcreatedtext'         => '$1簿增矣',
'createaccount-title'        => '於{{SITENAME}}增簿',
'createaccount-text'         => '有人於{{SITENAME}}用爾之電郵增名為 "$2" 之簿 ($4)，符節為 "$3" 。汝應登，再改符節也。

如簿誤增，爾可略之。',
'loginlanguagelabel'         => '語：$1',

# Edit page toolbar
'bold_sample'     => '粗體',
'bold_tip'        => '粗體',
'italic_sample'   => '斜體',
'italic_tip'      => '斜體',
'link_sample'     => '鏈',
'link_tip'        => '鏈內',
'extlink_tip'     => '冠http://以鏈外',
'headline_sample' => '題',
'headline_tip'    => '二題',
'math_sample'     => '此書方程式',
'math_tip'        => '數學方程式（LaTeX）',
'nowiki_sample'   => '此不排版',
'nowiki_tip'      => '不排維基之版',
'image_tip'       => '嵌檔',
'media_tip'       => '鏈檔',
'sig_tip'         => '署名刻時',
'hr_tip'          => '縱線，慎用之',

# Edit pages
'summary'                          => '概',
'subject'                          => '題',
'minoredit'                        => '令校',
'watchthis'                        => '派哨',
'savearticle'                      => '存儲',
'preview'                          => '草覽',
'showpreview'                      => '草覽',
'showlivepreview'                  => '即覽',
'showdiff'                         => '示異',
'anoneditwarning'                  => "'''警示：'''子未登簿，IP將誌。",
'missingsummary'                   => "''''醒示：'''子未概之，復存則文倍焉。",
'missingcommenttext'               => '請贊之',
'blockedtitle'                     => '子見禁',
'blockedtext'                      => "<big>'''子名、IP見禁。'''</big>禁者$1也，因''$2''故。

* 始之時為：$8
* 終之時為：$6
* 見禁之人：$7

存惑可詢$1，或[[{{MediaWiki:Grouppage-sysop}}|有秩]]，[[Special:Preferences|簿註]]無驛則信不遣。另，子IP為$3，其禁號為#$5。詢時切附之。",
'autoblockedtext'                  => "爾之IP或簿自禁，因簿先用，禁者$1也。因故：:\\'\\'$2\\'\\'

* 始之時為：$8
* 終之時為：$6
* 見禁之人：$7

存惑可詢$1，或[[{{MediaWiki:Grouppage-sysop}}|有秩]]，[[Special:Preferences|簿註]]無驛則信不遣。另，子用IP $3，禁號為#$5。詢時切附之。",
'blockedoriginalsource'            => "'''$1'''本源如下：",
'blockededitsource'                => "子'''$1纂文'''如下：",
'whitelistedittitle'               => '登簿以纂',
'whitelistedittext'                => '$1後方可纂文。',
'confirmedittitle'                 => '證驛以纂',
'confirmedittext'                  => '驛證方可纂文。惠見[[Special:Preferences|簿註]]。',
'loginreqtitle'                    => '須登簿',
'loginreqlink'                     => '登簿',
'loginreqpagetext'                 => '$1以覽它頁。',
'accmailtitle'                     => '符節傳矣',
'accmailtext'                      => '"$1"符節至$2矣',
'newarticle'                       => '撰',
'newarticletext'                   => '此頁尚缺。欲補，撰於下，有惑見[[{{MediaWiki:Helppage}}|助]]。
誤入者，返前即可。',
'anontalkpagetext'                 => "----''此匿論也，為未簿或不簿者設，IP俱錄以辨人焉。然IP不獨，恐生亂象，不喜惠[[Special:UserLogin/signup|增]][[Special:UserLogin|登簿]]遠之。",
'noarticletext'                    => '此頁無文。子可 [[Special:Search/{{PAGENAME}}|尋同題]]，或[{{fullurl:{{FULLPAGENAME}}|action=edit}} 撰新文]。',
'userpage-userdoesnotexist'        => '"$1"之簿未增也。請建纂本頁前查之。',
'clearyourcache'                   => "'''註：'''重取頁面，文方新焉。
'''Mozilla / Firefox / Safari:'''押''Shift''並點''重新載入''，或合鍵''Ctrl-F5''或''Ctrl-R''（Macintosh為''Command-R''）。
'''Konqueror:'''點''Reload''，或押''F5''。
：''Opera:'''須至''Tools→Preferences''清謄本。
'''Internet Explorer:'''押''Ctrl''並點''重新整理''，或合鍵''Ctrl-F5''。",
'usercssjsyoucanpreview'           => '<strong>訣：</strong>CSS/JS應先預覽而後存。',
'usercsspreview'                   => "'''預覽CSS。'''
'''尚未儲焉。'''",
'userjspreview'                    => "'''預覽JavaScript。'''
'''尚未儲焉。'''",
'userinvalidcssjstitle'            => "'''警：'''\"\$1\"無此面版。自製者，全名務小寫，如{{ns:user}}:Foo/monobook.css 而非{{ns:user}}:Foo/Monobook.css",
'updated'                          => '（新）',
'note'                             => '<strong>註</strong>',
'previewnote'                      => '<strong>此乃預覽，尚未儲焉。</strong>',
'session_fail_preview'             => '<strong>歉哉有變，子纂未存焉，惠再之。如復不成，[[Special:UserLogout|重登]]再試也。</strong>',
'session_fail_preview_html'        => "<strong>歉哉有變，子纂未存焉</strong>

''此維基亦合純HTML，除預覽以遠惡JavaScript侵。''
<strong>纂文若合，惠再之。如復不成，簿[[Special:UserLogout|重登]]焉。</strong>",
'token_suffix_mismatch'            => '<strong>君修見拒，蓋因代理之故，亂事見兮。</strong>',
'editing'                          => '纂$1',
'editingsection'                   => '纂節$1',
'editingcomment'                   => '贊$1',
'editconflict'                     => '纂沖$1',
'explainconflict'                  => '子纂與他人沖，上者時也，下者子也，望子合之。
註，<b>惟</b>上文儲焉<br />',
'yourtext'                         => '子也',
'storedversion'                    => '時也',
'nonunicodebrowser'                => '<strong>警示：覽器不識萬國碼，以十六進位數代之，以保纂可也。</strong>',
'editingold'                       => "<strong>'''警示'''子纂舊然。強儲之，則新易失焉。</strong>",
'yourdiff'                         => '異',
'copyrightwarning'                 => '{{SITENAME}}全文皆循$2，詳見$1。不喜他纂，但去可矣。文務親撰，或謄公本，
<strong>萬勿盜版！</strong>',
'copyrightwarning2'                => '{{SITENAME}}全文，允眾人撰、纂、刪、校。不喜他纂，但去可矣。<br />
文務親撰，或謄公本，如$1。<strong>萬勿盜版！</strong>',
'longpagewarning'                  => '<strong>警示：此頁長$1仟位元組，逾卅二，覽器恐不盡堪，望縮斷之。<strong>',
'longpageerror'                    => '<strong>警示：文長$1仟位元組，越幅$2，未能儲焉。</strong>',
'readonlywarning'                  => '<strong>警示：修庫藏，存儲謝焉。惠謄文備用之。</strong>',
'protectedpagewarning'             => '<strong>警示：庫藏鎖矣，惟有秩纂之。</strong>',
'semiprotectedpagewarning'         => "'''註記'''庫藏鎖矣，惟登簿纂之。",
'templatesused'                    => '此文用模：',
'template-protected'               => '(錮)',
'template-semiprotected'           => '(半錮)',
'hiddencategories'                 => '此頁屬隱類之員有$1：',
'nocreatetitle'                    => '新題謝焉',
'nocreatetext'                     => '舊題可修，新題謝焉。[[Special:UserLogin|登簿、增簿]]以逮權也。',
'nocreate-loggedin'                => '子權未逮，新頁謝焉。',
'permissionserrors'                => '權未逮也',
'permissionserrorstext'            => '子權未逮，有{{PLURAL:$1|因|因}}如下：',
'permissionserrorstext-withaction' => '子權未逮，有{{PLURAL:$1|因|因}}如$2：',
'recreate-deleted-warn'            => "'''留意：刪文復造，惠慎纂。'''
誌刪如下：",

# Parser/template warnings
'expensive-parserfunction-warning'        => '警：頁有多貴功呼。

其須少$2，現有$1。',
'expensive-parserfunction-category'       => '頁有多貴功呼',
'post-expand-template-inclusion-warning'  => '警：含模過大也。
一些模板將不會包含。',
'post-expand-template-inclusion-category' => '模含上限已超之頁',
'post-expand-template-argument-warning'   => '警：此頁有至少一模數展大。
數略之。',
'post-expand-template-argument-category'  => '含略模數之頁',

# "Undo" feature
'undo-success' => '此審可返也。查確然完之。',
'undo-failure' => '中審之異，此審無返也。',
'undo-norev'   => '其審無存或刪，此審無返也。',
'undo-summary' => '返[[Special:Contributions/$2|$2]]（[[User talk:$2|書]]）之審$1',

# Account creation failure
'cantcreateaccounttitle' => '新簿謝焉',
'cantcreateaccount-text' => "[[User:$3|S3]]因''$2''故，封子IP <b>$1</b>。",

# History pages
'viewpagelogs'        => '覽誌',
'nohistory'           => '此題無誌',
'revnotfound'         => '查無審',
'revnotfoundtext'     => '查無舊審，惠核網址。',
'currentrev'          => '今審',
'revisionasof'        => '$1審',
'previousrevision'    => '←舊',
'nextrevision'        => '新→',
'currentrevisionlink' => '今審',
'cur'                 => '辨今',
'next'                => '後',
'last'                => '前',
'page_first'          => '首',
'page_last'           => '末',
'histlegend'          => '辨異：擇二孔後，按Enter、或點下鈕以辨之。<br />
釋義：（辨今）與今審辨；（前省）與前審辨；校，校文',
'deletedrev'          => '刪矣',
'histfirst'           => '初',
'histlast'            => '末',
'historysize'         => '（$1位元組）',
'historyempty'        => '（空）',

# Revision feed
'history-feed-title'          => '誌審',
'history-feed-description'    => '維基誌審',
'history-feed-item-nocomment' => '$1於$2', # user at time
'history-feed-empty'          => '此頁不存，或刪、或更。類由此[[Special:Search|尋]]',

# Revision deletion
'rev-deleted-comment'         => '（此註刪矣）',
'rev-deleted-user'            => '（此簿刪矣）',
'rev-deleted-event'           => '（此誌刪矣）',
'rev-deleted-text-permission' => '<div class="mw-warning plainlinks">
此審刪矣，詳見[{{fullurl:Special:Log/delete|page={{PAGENAMEE}}}}誌刪]。
</div>',
'rev-deleted-text-view'       => '<div class="mw-warning plainlinks">
此審刪矣，惟{{SITENAME}}有秩可見之，詳見[{{fullurl:Special:Log/delete|page={{PAGENAMEE}}}} 誌刪]。
</div>',
'rev-delundel'                => '見/藏',
'revisiondelete'              => '刪、還審',
'revdelete-nooldid-title'     => '無此審。',
'revdelete-nooldid-text'      => '審未擇，審未存，爾隱現審，不可為之。',
'revdelete-selected'          => '審[[:$1]]已擇$2：',
'logdelete-selected'          => '已擇誌$1：',
'revdelete-text'              => '刪審雖見誌，其文摒公眾，惟有秩可得之。無規則有秩可復還焉。',
'revdelete-legend'            => '見，規之以',
'revdelete-hide-text'         => '藏審文',
'revdelete-hide-comment'      => '藏贊',
'revdelete-hide-user'         => '簿、IP以藏',
'revdelete-hide-restricted'   => '限有秩以鎖之',
'revdelete-suppress'          => '廢有秩與簿之事',
'revdelete-hide-image'        => '藏檔',
'revdelete-unsuppress'        => '復審解限',
'revdelete-log'               => '誌贊：',
'revdelete-submit'            => '擇審使之',
'revdelete-logentry'          => '[[$1]]之見審動矣',
'logdelete-logentry'          => '[[$1]]之事見動矣',
'revdelete-success'           => "'''見審已設也。'''",
'logdelete-success'           => "'''見事已設也。'''",
'revdel-restore'              => '動見之',
'pagehist'                    => '頁史',
'deletedhist'                 => '刪史',
'revdelete-content'           => '字',
'revdelete-summary'           => '摘',
'revdelete-uname'             => '簿名',
'revdelete-restricted'        => '應限至有秩',
'revdelete-unrestricted'      => '除限自有秩',
'revdelete-hid'               => '隱$1',
'revdelete-unhid'             => '非隱$1',
'revdelete-log-message'       => '$1之修$2',
'logdelete-log-message'       => '$1之事$2',

# Suppression log
'suppressionlog'     => '誌廢',
'suppressionlogtext' => '下乃刪及錮物之列也。
[[Special:IPBlockList|IP之錮]]有現之閱。',

# History merging
'mergehistory'                     => '併頁之誌',
'mergehistory-header'              => "此頁講汝併一源頁之誌至二頁也。
認之易繼留該頁之前誌也。

'''以源頁之現誌必會保持。'''",
'mergehistory-box'                 => '併二頁之誌：',
'mergehistory-from'                => '源頁：',
'mergehistory-into'                => '到頁：',
'mergehistory-list'                => '可併之誌',
'mergehistory-merge'               => '下[[:$1]]之誌可併至[[:$2]]。用選鈕欄以併只於定時前所建之誌。留心用導連將重設本欄也。',
'mergehistory-go'                  => '示可併之誌',
'mergehistory-submit'              => '併誌',
'mergehistory-empty'               => '無誌可併',
'mergehistory-success'             => '[[:$1]]之$3誌已併至[[:$2]]。',
'mergehistory-fail'                => '併誌無進也，該頁及時間參數請重檢也。',
'mergehistory-no-source'           => '源頁$1無存也。',
'mergehistory-no-destination'      => '到頁$1無存也。',
'mergehistory-invalid-source'      => '源頁之題須效之。',
'mergehistory-invalid-destination' => '到頁之題須效之。',
'mergehistory-autocomment'         => '併[[:$1]]至[[:$2]]',
'mergehistory-comment'             => '併[[:$1]]至[[:$2]]：$3',

# Merge log
'mergelog'           => '誌併',
'pagemerge-logentry' => '併咗[[$1]]至[[$2]] (訂至$3)',
'revertmerge'        => '悔併',
'mergelogpagetext'   => '下乃近頁之誌併至二頁之表也。',

# Diffs
'history-title'           => '$1之誌',
'difference'              => '（辨異）',
'lineno'                  => '列$1：',
'compareselectedversions' => '辨二擇',
'editundo'                => '悔',
'diff-multi'              => '（未示之途審有$1。）',

# Search results
'searchresults'             => '得尋',
'searchresulttext'          => '何索{{SITENAME}}，詳見[[{{MediaWiki:Helppage}}|{{int:help}}]]。',
'searchsubtitle'            => "'''[[:$1]]'''尋焉（[[Special:Prefixindex/$1|『$1』之全首頁]] | [[Special:WhatLinksHere/$1|『$1』之全取佐]]）",
'searchsubtitleinvalid'     => "'''$1'''尋焉",
'noexactmatch'              => "'''無題曰\"\$1\"。'''子可[[:\$1|撰之]]。",
'noexactmatch-nocreate'     => "'''無題曰\"\$1\"。'''",
'toomanymatches'            => '多配應之，試異詢也',
'titlematches'              => '合題',
'notitlematches'            => '無題合',
'textmatches'               => '合文',
'notextmatches'             => '無文合',
'prevn'                     => '前$1',
'nextn'                     => '次$1',
'viewprevnext'              => '見（$1）（$2）（$3）',
'search-result-size'        => '$1 （$2字）',
'search-result-score'       => '關：$1%',
'search-redirect'           => '(轉 $1)',
'search-section'            => '(節 $1)',
'search-suggest'            => '爾否解之：$1',
'search-interwiki-caption'  => '結義金蘭',
'search-interwiki-default'  => '結果有$1：',
'search-interwiki-more'     => '(多)',
'search-mwsuggest-enabled'  => '有議',
'search-mwsuggest-disabled' => '無議',
'search-relatedarticle'     => '關',
'mwsuggest-disable'         => '停AJAX議',
'searchrelated'             => '關',
'searchall'                 => '全',
'showingresults'            => "見'''$1'''尋，自'''$2'''始：",
'showingresultsnum'         => "見'''$3'''尋，自'''$2'''始：",
'showingresultstotal'       => "見'''$1至$2'''共'''$3'''尋",
'nonefound'                 => "'''注'''：部名冊預尋也。。試''all:''尋全名刪之頁（含議模等），或可用要之名冊為前綴也。",
'powersearch'               => '尋',
'powersearch-legend'        => '尋',
'powersearch-ns'            => '尋名集：',
'powersearch-redir'         => '轉表',
'powersearch-field'         => '尋',
'search-external'           => '外尋',
'searchdisabled'            => '{{SITENAME}}因性能而停用之。可Gooogle查之，乃之過時也。',

# Preferences page
'preferences'           => '簿註',
'mypreferences'         => '簿註',
'prefs-edits'           => '數纂：',
'prefsnologin'          => '未登簿',
'prefsnologintext'      => '註記須<span class="plainlinks">[{{fullurl:Special:Userlogin|returnto=$1}} 登簿]</span>。',
'prefsreset'            => '簿註歸白',
'changepassword'        => '易符節',
'skin'                  => '面版',
'math'                  => '數學',
'dateformat'            => '日期格式',
'datedefault'           => '原註',
'datetime'              => '日時',
'math_failure'          => '譯不成',
'math_unknown_error'    => '未知之誤',
'math_unknown_function' => '未知函式',
'math_lexing_error'     => '律有誤',
'math_syntax_error'     => '語法有誤',
'prefs-personal'        => '概簿',
'prefs-rc'              => '近易',
'prefs-watchlist'       => '哨站',
'prefs-watchlist-days'  => '哨報有日',
'prefs-watchlist-edits' => '哨站有易',
'prefs-misc'            => '雜',
'saveprefs'             => '儲',
'resetprefs'            => '歸白',
'oldpassword'           => '舊符節：',
'newpassword'           => '新符節：',
'retypenew'             => '重察新符節：',
'textboxsize'           => '在修',
'rows'                  => '行：',
'columns'               => '列：',
'searchresultshead'     => '尋',
'resultsperpage'        => '頁示尋',
'contextlines'          => '尋分列',
'contextchars'          => '列有字',
'recentchangescount'    => '近易、史與誌有題：',
'savedprefs'            => '簿註書矣',
'timezonelegend'        => '時區',
'timezonetext'          => '¹與伺服器偏時有',
'localtime'             => '本地時',
'timezoneoffset'        => '偏¹',
'servertime'            => '伺服器時',
'guesstimezone'         => '瀏覽器填之',
'allowemail'            => '予收信',
'prefs-searchoptions'   => '尋項',
'prefs-namespaces'      => '名集',
'defaultns'             => '定尋之名集：',
'default'               => '予定',
'files'                 => '檔',

# User rights
'userrights'                     => '齋權管', # Not used as normal message but as header for the special page itself
'userrights-lookup-user'         => '司社',
'userrights-user-editname'       => '簿名：',
'editusergroup'                  => '治社',
'editinguser'                    => "正纂簿'''[[User:$1|$1]]''' ([[User talk:$1|{{int:talkpagelinktext}}]] | [[Special:Contributions/$1|{{int:contribslink}}]]) 之權",
'userrights-editusergroup'       => '治社',
'saveusergroups'                 => '定之',
'userrights-groupsmember'        => '有員：',
'userrights-groups-help'         => '爾動員之社也：
* 選解員之社屬。
* 未選則非社屬。
* 一＊即選屬後無倒之，反亦之。',
'userrights-reason'              => '因：',
'userrights-no-interwiki'        => '爾無權改他山wiki之簿權也。',
'userrights-nodatabase'          => '資料庫$1無存或非本地也。',
'userrights-nologin'             => '爾以有秩乲簿[[Special:UserLogin|登]]後以定簿之權也。',
'userrights-notallowed'          => '爾之簿無權定簿之權也。',
'userrights-changeable-col'      => '爾可動之社',
'userrights-unchangeable-col'    => '爾非動之社',
'userrights-irreversible-marker' => '$1＊',

# Groups
'group'               => '社：',
'group-user'          => '簿',
'group-autoconfirmed' => '自證其簿',
'group-bot'           => '僕',
'group-sysop'         => '有秩',
'group-bureaucrat'    => '門下',
'group-suppress'      => '監',
'group-all'           => '（眾）',

'group-user-member'          => '簿',
'group-autoconfirmed-member' => '自證其簿',
'group-bot-member'           => '僕',
'group-sysop-member'         => '有秩',
'group-bureaucrat-member'    => '門下',
'group-suppress-member'      => '監',

'grouppage-user'          => '{{ns:project}}:簿',
'grouppage-autoconfirmed' => '{{ns:project}}:自證其簿',
'grouppage-bot'           => '{{ns:project}}:僕',
'grouppage-sysop'         => '{{ns:project}}:有秩',
'grouppage-bureaucrat'    => '{{ns:project}}:門下',
'grouppage-suppress'      => '{{ns:project}}:監',

# Rights
'right-read'                 => '閱頁',
'right-edit'                 => '纂頁',
'right-createpage'           => '建頁（議不含）',
'right-createtalk'           => '建議頁',
'right-createaccount'        => '增簿',
'right-minoredit'            => '示小改',
'right-move'                 => '遷頁',
'right-move-subpages'        => '連遷子頁',
'right-suppressredirect'     => '遷頁時無增轉',
'right-upload'               => '貢獻品物',
'right-reupload'             => '蓋現之品物',
'right-reupload-own'         => '蓋同簿之品物',
'right-reupload-shared'      => '於本無視共媒物庫上之品物',
'right-upload_by_url'        => '由URL貢品物',
'right-purge'                => '無確認頁除網存',
'right-autoconfirmed'        => '纂半錮之頁',
'right-bot'                  => '視自動之程序',
'right-nominornewtalk'       => '小改無發新信之示',
'right-apihighlimits'        => '於API查頂上',
'right-writeapi'             => '用寫之API',
'right-delete'               => '刪頁面',
'right-bigdelete'            => '刪大史之頁',
'right-deleterevision'       => '刪與反刪頁之審',
'right-deletedhistory'       => '看刪之項，無關之字',
'right-browsearchive'        => '尋刪之頁',
'right-undelete'             => '反刪頁',
'right-suppressrevision'     => '看與復由有秩藏之審',
'right-suppressionlog'       => '看私之誌',
'right-block'                => '鎖他簿無編',
'right-blockemail'           => '鎖簿無電郵',
'right-hideuser'             => '鎖簿名，予藏眾',
'right-ipblock-exempt'       => '繞IP鎖、自鎖與圍鎖',
'right-proxyunbannable'      => '繞Proxy之自鎖',
'right-protect'              => '改錮級與纂錮頁',
'right-editprotected'        => '纂錮頁（無連錮）',
'right-editinterface'        => '纂要',
'right-editusercssjs'        => '纂他簿之CSS與JS檔',
'right-rollback'             => '速復上簿頁之纂',
'right-markbotedits'         => '標復纂為機纂',
'right-noratelimit'          => '無率之上限',
'right-import'               => '由它wiki匯入頁',
'right-importupload'         => '由品貢匯入頁',
'right-patrol'               => '示它纂作已巡查',
'right-autopatrol'           => '將己纂自示為已巡查',
'right-patrolmarks'          => '察近巡查記之易',
'right-unwatchedpages'       => '看未哨之頁',
'right-trackback'            => '交一trackback',
'right-mergehistory'         => '併頁之史',
'right-userrights'           => '纂簿權',
'right-userrights-interwiki' => '纂另wiki他簿之權',
'right-siteadmin'            => '鎖與解鎖資料庫',

# User rights log
'rightsnone' => '（凡）',

# Recent changes
'nchanges'                          => '$1易',
'recentchanges'                     => '近易',
'recentchangestext'                 => '共筆揮新，悉列於此。',
'rcnote'                            => "下為自$4$5起，'''$2'''日內'''$1'''近易也。",
'rcnotefrom'                        => '下為自<b>$2</b至<b>$1</b>之易也。',
'rclistfrom'                        => '自$1起之易也',
'rcshowhideminor'                   => '$1校',
'rcshowhidebots'                    => '$1僕',
'rcshowhideliu'                     => '$1簿',
'rcshowhideanons'                   => '$1匿名',
'rcshowhidepatr'                    => '$1哨',
'rcshowhidemine'                    => '$1吾纂',
'rclinks'                           => '$2日內$1近易。<br />$3',
'diff'                              => '辨',
'hist'                              => '誌',
'hide'                              => '藏',
'show'                              => '示',
'minoreditletter'                   => '校',
'newpageletter'                     => '新',
'boteditletter'                     => '僕',
'number_of_watching_users_pageview' => '[放有$1哨]',
'rc_categories_any'                 => '任',
'newsectionsummary'                 => '/* $1 */ 新節',

# Recent changes linked
'recentchangeslinked'          => '援引',
'recentchangeslinked-title'    => '「$1」援引近易',
'recentchangeslinked-noresult' => '限期內無近易。',
'recentchangeslinked-summary'  => "此奇頁乃列''由''頁援之近易（或對類之員）。
有[[Special:Watchlist|爾有哨]]者'''粗體'''。",
'recentchangeslinked-page'     => '頁名：',
'recentchangeslinked-to'       => '示援頁',

# Upload
'upload'                     => '進獻',
'uploadbtn'                  => '進獻',
'reupload'                   => '復獻之',
'reuploaddesc'               => '消進乃返載獻',
'uploadnologin'              => '未登簿',
'uploadnologintext'          => '[[Special:UserLogin|登簿]]始可進獻',
'upload_directory_missing'   => '目錄$1已失，無建之。',
'upload_directory_read_only' => '目錄$1禁入，無可獻。',
'uploaderror'                => '進獻有變',
'uploadtext'                 => "下表以獻，[[Special:ImageList|載獻]]覽之。或見[[Special:Log/upload|誌獻]]與[[Special:Log/delete|誌刪]]。
欲嵌頁中，是格鏈之其一：
* '''<tt><nowiki>[[</nowiki>{{ns:image}}:File.jpg]]</tt>'''用此整獻
* '''<tt><nowiki>[[</nowiki>{{ns:image}}:File.png||200px|thumb|left|名]]</tt>'''以二百像素置左框置『名』
* '''<tt><nowiki>[[</nowiki>{{ns:media}}:File.ogg]]</tt>'''直連獻，無示獻",
'upload-permitted'           => '可之物類：$1。',
'upload-preferred'           => '議之物類：$1。',
'upload-prohibited'          => '禁之物類：$1。',
'uploadlog'                  => '誌獻',
'uploadlogpage'              => '誌獻',
'uploadlogpagetext'          => '近獻如下。
看[[Special:NewImages|新畫獻]]示獻功。',
'filename'                   => '名',
'filedesc'                   => '概',
'fileuploadsummary'          => '概：',
'filestatus'                 => '授權：',
'filesource'                 => '源：',
'uploadedfiles'              => '進獻',
'ignorewarning'              => '強儲之',
'ignorewarnings'             => '警略。',
'minlength1'                 => '名務逾一字元。',
'illegalfilename'            => '名"$1"不格，更之再焉。',
'badfilename'                => '更名"$1。"。',
'filetype-badmime'           => '「$1」之MIME類物檔案不能獻之。',
'filetype-unwanted-type'     => "'''「.$1」'''乃無需之物類也。
議之物類有{{PLURAL:$3|一|多}}$2也。",
'filetype-banned-type'       => "'''「.$1」'''乃無允之物類也。
允之物類有{{PLURAL:$3|一|多}}$2也。",
'filetype-missing'           => '檔名無後綴也（如「.jpg」）。',
'large-file'                 => '檔長$2仟位元組，不逾$1為佳。',
'emptyfile'                  => '無以獻，疑謬名也，惠核之。',
'fileexists'                 => '<strong><tt>$1</tt></strong>存矣，欲蓋之則再也。',
'filepageexists'             => '此檔之述於<strong><tt>$1</tt></strong>存矣，檔未存也。爾入述無存也。要現之，爾需纂之。',
'fileexists-thumb'           => "<center>'''現存之檔'''</center>",
'file-exists-duplicate'      => '此檔乃重檔{{PLURAL:$1|一|數}}：',
'successfulupload'           => '檔案安矣',
'uploadwarning'              => '慎焉！',
'savefile'                   => '存之',
'overwroteimage'             => '新置「[[$1]]」矣',
'sourcefilename'             => '源名：',
'destfilename'               => '欲置檔名：',
'upload-maxfilesize'         => '檔限：$1',
'watchthisupload'            => '派哨',
'upload-wasdeleted'          => "'''警示：復獻棄檔，慎續之。'''
誌刪如下：",
'filename-bad-prefix'        => '獻檔以<strong>「$1」</strong>首，常由相機瞎造，惠更述之。',

'license-nopreview' => '（謝草覽）',

# Special:ImageList
'imagelist-summary'     => '此奇頁示檔之全呈也。
設最後之檔呈示於表頂。
點題改其列之。',
'imagelist_search_for'  => '以媒名尋：',
'imgfile'               => '檔',
'imagelist_date'        => '時',
'imagelist_name'        => '名',
'imagelist_user'        => '簿',
'imagelist_size'        => '幅（位元組）',
'imagelist_description' => '述',

# Image description page
'filehist'                       => '檔史',
'filehist-help'                  => '揀日尋檔。',
'filehist-deleteall'             => '全刪',
'filehist-deleteone'             => '刪',
'filehist-revert'                => '還',
'filehist-current'               => '今',
'filehist-datetime'              => '時',
'filehist-user'                  => '薄',
'filehist-dimensions'            => '度',
'filehist-filesize'              => '檔幅',
'filehist-comment'               => '註',
'imagelinks'                     => '圖鏈',
'linkstoimage'                   => '下頁連本檔有$1：',
'nolinkstoimage'                 => '無頁連本檔也。',
'morelinkstoimage'               => '閱檔[[Special:WhatLinksHere/$1|接]]。',
'redirectstofile'                => '下檔轉到此檔有$1：',
'duplicatesoffile'               => '下檔重此檔有$1：',
'sharedupload'                   => '此檔為共傳，可另項用也。',
'shareduploadwiki'               => '詳閱$1。',
'shareduploadwiki-desc'          => '於共庫上$1之示。',
'shareduploadwiki-linktext'      => '檔述',
'shareduploadduplicate'          => '此檔重於共檔之$1。',
'shareduploadduplicate-linktext' => '另檔',
'shareduploadconflict'           => '此檔重名於共檔之$1。',
'shareduploadconflict-linktext'  => '另檔',
'imagepage-searchdupe'           => '尋重檔',

# File reversion
'filerevert'                => '還$1',
'filerevert-legend'         => '還檔',
'filerevert-intro'          => "'''[[Media:$1|$1]]'''欲還回$2$3之版$4。",
'filerevert-comment'        => '註：',
'filerevert-defaultcomment' => '還$1$2之版矣',
'filerevert-submit'         => '還',
'filerevert-success'        => "'''[[Media:$1|$1]]'''，$2$3之版$4還矣。",
'filerevert-badversion'     => '該日無版也。',

# File deletion
'filedelete'                  => '刪$1',
'filedelete-legend'           => '刪檔',
'filedelete-intro'            => "欲刪'''[[Media:$1|$1]]'''。",
'filedelete-intro-old'        => "欲刪'''[[Media:$1|$1]]'''$2$3之版$4。",
'filedelete-comment'          => '刪因：',
'filedelete-submit'           => '刪',
'filedelete-success'          => "'''$1'''刪矣。",
'filedelete-success-old'      => "'''[[Media:$1|$1]]'''$2$3之版刪矣。",
'filedelete-nofile'           => "{{SITENAME}}無'''$1'''也。",
'filedelete-nofile-old'       => "無合'''$1'''藏也。",
'filedelete-iscurrent'        => '刪版乃新，先還舊焉。',
'filedelete-otherreason'      => '另／附之因：',
'filedelete-reason-otherlist' => '另因',
'filedelete-reason-dropdown'  => '
*常刪之因
** 侵版權
** 重檔',
'filedelete-edit-reasonlist'  => '纂刪因',

# MIME search
'mimesearch'         => '篩檔',
'mimesearch-summary' => '此頁可以MIME篩檔．格仿「文類/次類」，如<tt>image/jpeg</tt>。',
'mimetype'           => 'MIME類有：',
'download'           => '載下',

# Unwatched pages
'unwatchedpages' => '無哨頁',

# List redirects
'listredirects' => '表轉',

# Unused templates
'unusedtemplates'     => '墨乾',
'unusedtemplatestext' => '此表閒模，篤刪前惠考支鏈。',
'unusedtemplateswlh'  => '支鏈',

# Random page
'randompage' => '風掀',

# Random redirect
'randomredirect'         => '任渡',
'randomredirect-nopages' => '名冊內無渡也。',

# Statistics
'statistics'             => '彙統',
'sitestats'              => '{{SITENAME}}彙統',
'userstats'              => '有簿彙統',
'sitestatstext'          => "庫藏有頁'''$1'''，除議、釋、芻文、渡與不濟者，有足文$2、獻品'''$8'''。
自{{SITENAME}}始焉，閱頁'''$3'''，纂文'''$4'''。均之則每頁'''$5'''覽，每文'''$6'''纂。
[http://www.mediawiki.org/wiki/Manual:Job_queue job queue]長'''$7'''。",
'userstatstext'          => "有[[Special:ListUsers|簿]]者'''$1'''，內'''$2'''人掌$5權，據百分之'''$4'''。",
'statistics-mostpopular' => '燴炙',

'disambiguations'      => '釋義',
'disambiguations-text' => '頁下引[[MediaWiki:Disambiguationspage]]模，求釋義，宜正題之。',

'doubleredirects'            => '窮渡',
'doubleredirectstext'        => '頁下窮渡，迭列以示。首尾宿合，宜正渡之。',
'double-redirect-fixed-move' => '[[$1]]遷畢，現渡至[[$2]]',
'double-redirect-fixer'      => '修渡',

'brokenredirects'        => '斷渡',
'brokenredirectstext'    => '頁下斷渡。',
'brokenredirects-edit'   => '(替)',
'brokenredirects-delete' => '(刪)',

'withoutinterwiki'         => '孤語',
'withoutinterwiki-summary' => '頁下無鏈他語。',
'withoutinterwiki-legend'  => '首',
'withoutinterwiki-submit'  => '示',

'fewestrevisions' => '鮮察',

# Miscellaneous special pages
'nbytes'                  => '$1位元組',
'ncategories'             => '$1門',
'nlinks'                  => '$1鏈',
'nmembers'                => '$1戶',
'nrevisions'              => '$1審',
'nviews'                  => '$1閱',
'lonelypages'             => '孤寡',
'lonelypagestext'         => '頁下無鏈',
'uncategorizedpages'      => '欲訂',
'uncategorizedcategories' => '問栓',
'uncategorizedimages'     => '候裱',
'uncategorizedtemplates'  => '待蘸',
'unusedcategories'        => '樞鏽',
'unusedimages'            => '色褪',
'popularpages'            => '膾炙',
'wantedcategories'        => '求門',
'wantedpages'             => '徵頁',
'missingfiles'            => '失檔',
'mostlinked'              => '好料',
'mostlinkedcategories'    => '豪門',
'mostlinkedtemplates'     => '美模',
'mostcategories'          => '跨船',
'mostimages'              => '名檔',
'mostrevisions'           => '屢審',
'shortpages'              => '短篇',
'longpages'               => '長言',
'protectedpages'          => '頁錮',
'protectedpages-indef'    => '只示無期之錮',
'listusers'               => '點簿',
'newpages'                => '新灶',
'newpages-username'       => '簿名：',
'ancientpages'            => '陳年',
'move'                    => '遷',
'movethispage'            => '遷此頁',
'unusedimagestext'        => '<p>他站可以網址鏈檔，故下列並非盡閒，註記之。</p>',
'unusedcategoriestext'    => '以下空門，無依可活。',
'notargettitle'           => '落靶',
'notargettext'            => '簿、頁未定，無可為之。',
'nopagetitle'             => '落靶之頁',
'nopagetext'              => '頁未定，無可為之。',
'pager-newer-n'           => '新$1次',
'pager-older-n'           => '陳$1次',
'suppress'                => '監',

# Book sources
'booksources'               => '書海',
'booksources-search-legend' => '舀書海',
'booksources-go'            => '往',
'booksources-text'          => '有賈售新舊書，或有助焉。茲列如下：',

# Special:Log
'specialloguserlabel'  => '簿：',
'speciallogtitlelabel' => '標：',
'log'                  => '誌',
'all-logs-page'        => '眾誌',
'log-search-legend'    => '尋誌',
'log-search-submit'    => '往',
'alllogstext'          => '眾誌有合者，俱併版見。擇門、選簿、限疆以裁之。',
'logempty'             => '無合誌也。',
'log-title-wildcard'   => '題以此始者，取之',

# Special:AllPages
'allpages'          => '全典',
'alphaindexline'    => '自$1至$2',
'nextpage'          => '次頁（$1）',
'prevpage'          => '先頁（$1）',
'allpagesfrom'      => '始頁：',
'allarticles'       => '全典',
'allinnamespace'    => '全$1名冊',
'allnotinnamespace' => '非$1名冊',
'allpagesprev'      => '前',
'allpagesnext'      => '次',
'allpagessubmit'    => '往',
'allpagesprefix'    => '冠頁以：',
'allpagesbadtitle'  => '或冠有他語、他山、或含禁字，題標不格。',
'allpages-bad-ns'   => '無"$1"名冊',

# Special:Categories
'categories'                    => '類',
'categoriespagetext'            => '大典有頁或媒。
[[Special:UnusedCategories|未類]]無示之。
閱[[Special:WantedCategories|需類]]也。',
'categoriesfrom'                => '示此項起之類：',
'special-categories-sort-count' => '排數',
'special-categories-sort-abc'   => '排字',

# Special:ListUsers
'listusersfrom'      => '始簿：',
'listusers-submit'   => '見',
'listusers-noresult' => '尋無簿。',

# Special:ListGroupRights
'listgrouprights'          => '簿組權',
'listgrouprights-summary'  => '下乃wiki之簿權表及存取之權也。
欲知權節，可望[[{{MediaWiki:Listgrouprights-helppage}}|此]]矣。',
'listgrouprights-group'    => '組',
'listgrouprights-rights'   => '權',
'listgrouprights-helppage' => 'Help:組權',
'listgrouprights-members'  => '（社員表）',

# E-mail user
'mailnologin'     => '無驛',
'mailnologintext' => '[[Special:UserLogin|登簿]]置郵，方可捎書。',
'emailuser'       => '捎君',
'emailpage'       => '捎書',
'emailpagetext'   => '若此君有郵，表下捎焉。署[[Special:Preferences|子簿郵]]以候往返。',
'usermailererror' => '驛報有誤：',
'defemailsubject' => '{{SITENAME}}來書',
'noemailtitle'    => '無郵',
'noemailtext'     => '此君無郵，或謝收之。',
'emailfrom'       => '自：',
'emailto'         => '致：',
'emailsubject'    => '題：',
'emailmessage'    => '訊：',
'emailsend'       => '遣',
'emailccme'       => '謄複本。',
'emailccsubject'  => '致$1複本：$2',
'emailsent'       => '書遣矣',
'emailsenttext'   => '書遣矣',
'emailuserfooter' => '此捎由$1給$2經{{SITENAME}}之「捎君」發矣。',

# Watchlist
'watchlist'            => '哨站',
'mywatchlist'          => '哨站',
'watchlistfor'         => "（'''$1'''之哨）",
'nowatchlist'          => '無哨',
'watchlistanontext'    => '$1以治哨',
'watchnologin'         => '未登簿',
'watchnologintext'     => '[[Special:UserLogin|登簿]]以治哨。',
'addedwatch'           => '派哨',
'addedwatchtext'       => "\"[[:\$1]]\"哨派矣。後有易、議者可見於[[Special:Watchlist|哨站]]，且'''粗體'''列於[[Special:RecentChanges|近易]]。",
'removedwatch'         => '撤哨',
'removedwatchtext'     => '"[[:$1]]"[[Special:Watchlist|哨]]撤矣。',
'watch'                => '派哨',
'watchthispage'        => '哨此報',
'unwatch'              => '撤哨',
'unwatchthispage'      => '撤此哨',
'notanarticle'         => '此頁非文',
'notvisiblerev'        => '易已刪矣',
'watchnochange'        => '皆無易也',
'watchlist-details'    => '哨上有$1，不含議論。',
'wlheader-enotif'      => '*准報信。',
'wlheader-showupdated' => "*易者'''粗體'''。",
'watchmethod-recent'   => '哨近易。',
'watchmethod-list'     => '報近易…',
'watchlistcontains'    => '共$1哨。',
'iteminvalidname'      => "'$1'謬名。",
'wlnote'               => '近<b>$2</b>時有$1者易。',
'wlshowlast'           => '見近$1時、$2天、$3時易',
'watchlist-show-bots'  => '見僕',
'watchlist-hide-bots'  => '藏僕',
'watchlist-show-own'   => '見己',
'watchlist-hide-own'   => '藏己',
'watchlist-show-minor' => '見校',
'watchlist-hide-minor' => '藏校',

# Displayed when you click the "watch" button and it is in the process of watching
'watching'   => '出陣…',
'unwatching' => '收兵…',

'enotif_mailer'                => '{{SITENAME}}報',
'enotif_reset'                 => '令為盡閱',
'enotif_newpagetext'           => '新灶',
'enotif_impersonal_salutation' => '貴客',
'changed'                      => '易',
'created'                      => '撰',
'enotif_subject'               => '{{SITENAME}}簿{$PAGEEDITOR}{$CHANGEDORCREATED}{$PAGETITLE}',
'enotif_lastvisited'           => '自子出簿，有易見$1。',
'enotif_lastdiff'              => '欲閱此易，見$1。',
'enotif_anon_editor'           => '過客$1',
'enotif_body'                  => '$WATCHINGUSERNAME鈞鑑

{$PAGEEDITDATE}{{SITENAME}}簿{$PAGEEDITOR}{$CHANGEDORCREATED}{$PAGETITLE}，閱之見{$PAGETITLE_URL}。

$NEWPAGE

纂者彙：$PAGESUMMARY $PAGEMINOREDIT
遣書（$PAGEEDITOR_EMAIL）或訪齋（$PAGEEDITOR_WIKI）聯繫之。

如不訪頁，哨報止也。可赴哨所令復之。

{{SITENAME}}敬上

--
欲更哨令，惠訪{{fullurl:{{ns:special}}:Watchlist/edit}}
饋助之，惠訪{{fullurl:{{ns:help}}:Contents}}',

# Delete/protect/revert
'deletepage'                  => '刪頁',
'confirm'                     => '准',
'excontent'                   => "文乃'$1'",
'excontentauthor'             => "文乃'$1'，乃[[Special:Contributions/$2|$2]]獨作。",
'exblank'                     => '缺頁',
'delete-confirm'              => '刪"$1"',
'delete-legend'               => '刪',
'historywarning'              => '警示，此頁有誌：',
'confirmdeletetext'           => '欲刪此物與誌，知後果、合[[{{MediaWiki:Policy-url}}]]後再為之。',
'actioncomplete'              => '成矣',
'deletedtext'                 => '"<nowiki>$1</nowiki>"刪矣，見誌刪於$2。',
'deletedarticle'              => '刪焉「[[$1]]」',
'suppressedarticle'           => '廢焉「[[$1]]」',
'dellogpage'                  => '誌刪',
'dellogpagetext'              => '近刪如下：',
'deletionlog'                 => '誌刪',
'reverted'                    => '已還前審',
'deletecomment'               => '刪因：',
'deleteotherreason'           => '另／附之因：',
'deletereasonotherlist'       => '另因',
'deletereason-dropdown'       => '
*常刪之因
** 作者之求
** 侵版權
** 破壞',
'delete-edit-reasonlist'      => '纂刪因',
'delete-toobig'               => '此頁含大誌，過$1修。刪頁限矣，防於{{SITENAME}}之亂也。',
'delete-warning-toobig'       => '此頁含大誌，過$1修。刪之可亂{{SITENAME}}之事也；續時留神之。',
'rollback'                    => '退修',
'rollback_short'              => '退',
'rollbacklink'                => '退',
'rollbackfailed'              => '退未成',
'cantrollback'                => '退修不成，作者獨也。',
'alreadyrolled'               => '[[User:$2|$2]]（[[User talk:$2|議]] | [[Special:Contributions/$2|{{int:contribslink}}]]）作[[:$1]]，退不成也。有易或已退焉。新纂者為[[User:$3|$3]]（[[User talk:$3|議]] | [[Special:Contributions/$3|{{int:contribslink}}]]）',
'editcomment'                 => '贊曰"<i>$1</i>"', # only shown if there is an edit comment
'revertpage'                  => '去[[Special:Contributions/$2|$2]]之作（欲言之，可至[[User talk:$2|此]]）為[[User:$1|$1]]之本耳', # Additional available: $3: revid of the revision reverted to, $4: timestamp of the revision reverted to, $5: revid of the revision reverted from, $6: timestamp of the revision reverted from
'rollback-success'            => '去$1之作，復為$2之本耳。',
'sessionfailure'              => '登簿有變。為防盜簿，返前重取再為之。',
'protectlogpage'              => '誌緘',
'protectlogtext'              => '誌緘如下；近緘見[[Special:ProtectedPages|此]] 。',
'protectedarticle'            => '緘焉"[[$1]]"',
'modifiedarticleprotection'   => '令"$1"',
'unprotectedarticle'          => '啟焉"[[$1]]"',
'protect-title'               => '更"$1"之緘',
'protect-legend'              => '准緘',
'protectcomment'              => '贊曰',
'protectexpiry'               => '屆期',
'protect_expiry_invalid'      => '屆期不明。',
'protect_expiry_old'          => '屆期已過。',
'protect-unchain'             => '准遷之',
'protect-text'                => '緘捆<strong><nowiki>$1</nowiki></strong>。',
'protect-locked-blocked'      => '簿禁，<strong>$1</strong>緘昔如下：',
'protect-locked-dblock'       => '庫鎖，<strong>$1</strong>緘昔如下：',
'protect-locked-access'       => '未准，<strong>$1</strong>緘昔如下：',
'protect-cascadeon'           => '取佐緘焉，迭牽此頁；{{PLURAL:$1|此|此}}頁啟篋，無反累焉。',
'protect-default'             => '（慣）',
'protect-fallback'            => "須''$1''准",
'protect-level-autoconfirmed' => '禁無簿',
'protect-level-sysop'         => '惟有秩',
'protect-summary-cascade'     => '迭緘',
'protect-expiring'            => '$1（UTC）屆',
'protect-cascade'             => '援引緘，牽迭',
'protect-cantedit'            => '汝無動頁之護也，因汝無權纂之矣。',
'restriction-type'            => '准',
'restriction-level'           => '緘捆',
'minimum-size'                => '幅越',
'maximum-size'                => '幅弱：',
'pagesize'                    => '（位元組）',

# Restrictions (nouns)
'restriction-edit'   => '纂',
'restriction-move'   => '遷',
'restriction-create' => '建',
'restriction-upload' => '貢',

# Restriction levels
'restriction-level-sysop'         => '全封',
'restriction-level-autoconfirmed' => '半封',
'restriction-level-all'           => '有封',

# Undelete
'undelete'                     => '覽刪',
'undeletepage'                 => '覽刪並還之',
'undeletepagetitle'            => "'''如下含[[:$1]]刪之審'''。",
'viewdeletedpage'              => '覽刪',
'undeletepagetext'             => '如下已刪，備謄以還；曆滿乃清之。',
'undelete-fieldset-title'      => '復審',
'undeleteextrahelp'            => "欲還題，撤核後令'''''還刪'''''。欲還某審，核之再令。欲清核、贊，令之'''''歸白'''''。",
'undeleterevisions'            => '審備$1',
'undeletehistory'              => '如還題，審亦隨焉；若存同題，還如誌，不以代焉。',
'undeleterevdel'               => '新審不牽，難還也；銷、見之以篤還。',
'undeletehistorynoadmin'       => '文刪矣，何由如下；並示末纂者。詳文藏，惟有迭可閱。',
'undelete-revision'            => '自$2，$3纂之$1審刪如下：',
'undeleterevision-missing'     => '審謬失；棄、還或鏈亡。',
'undeletebtn'                  => '還',
'undeletelink'                 => '還',
'undeletereset'                => '歸白',
'undeletecomment'              => '贊日',
'undeletedarticle'             => '還焉"[[$1]]"',
'undeletedrevisions'           => '$1審已還',
'undeletedrevisions-files'     => '$1審、$2檔已還',
'undeletedfiles'               => '$1檔已還',
'cannotundelete'               => '無以還檔；或復矣。',
'undeletedpage'                => "<big>'''$1還矣'''</big>
近刪新還，見[[Special:Log/delete|刪還誌]]。",
'undelete-header'              => '欲覽近刪，見[[Special:Log/delete|誌刪]]。',
'undelete-search-box'          => '尋刪',
'undelete-search-prefix'       => '見頁始如',
'undelete-search-submit'       => '尋',
'undelete-no-results'          => '備本無合者也。',
'undelete-filename-mismatch'   => '$1之審名不合，無可還焉。',
'undelete-bad-store-key'       => '$1之審乃空，無可還焉。',
'undelete-cleanup-error'       => '冗檔$1，欲刪而有誤也。',
'undelete-missing-filearchive' => '$1無尋，或已還矣。',
'undelete-error-short'         => '$1欲還而有誤也。',
'undelete-error-long'          => '還檔有誤。欲還者：\\n\\n$1\\n',

# Namespace form on various pages
'namespace'      => '名冊：',
'invert'         => '反相',
'blanknamespace' => '主',

# Contributions
'contributions' => '功績',
'mycontris'     => '吾績',
'contribsub2'   => '$1勛（$2）',
'nocontribs'    => '無勛及也。',
'uctop'         => '(至頂)',
'month'         => '且不越',
'year'          => '年不越',

'sp-contributions-newbies'     => '惟列新進',
'sp-contributions-newbies-sub' => '予新進',
'sp-contributions-blocklog'    => '誌禁',
'sp-contributions-search'      => '問勛',
'sp-contributions-username'    => '簿名或IP址',
'sp-contributions-submit'      => '問',

# What links here
'whatlinkshere'            => '取佐',
'whatlinkshere-title'      => '「$1」取佐',
'whatlinkshere-page'       => '題',
'linklistsub'              => '（列取佐）',
'linkshere'                => "取佐'''[[:$1]]'''如下：",
'nolinkshere'              => "無頁取佐'''[[:$1]]'''。",
'nolinkshere-ns'           => "名冊內無頁取佐'''[[:$1]]'''。",
'isredirect'               => '渡',
'istemplate'               => '含',
'isimage'                  => '檔佐',
'whatlinkshere-prev'       => '前$1',
'whatlinkshere-next'       => '次$1',
'whatlinkshere-links'      => '←佐',
'whatlinkshere-hideredirs' => '$1轉',
'whatlinkshere-hidetrans'  => '$1含',
'whatlinkshere-hidelinks'  => '$1佐',
'whatlinkshere-hideimages' => '$1檔佐',
'whatlinkshere-filters'    => '濾',

# Block/unblock
'blockip'                         => '禁簿',
'blockip-legend'                  => '禁簿',
'blockiptext'                     => '函下禁纂，簿、址明判；[[{{MediaWiki:Policy-url}}|秉據]]如斯，立法克亂。指罪證行，了冤無憾。',
'ipaddress'                       => 'IP址',
'ipadressorusername'              => 'IP或簿名',
'ipbexpiry'                       => '限期',
'ipbreason'                       => '指證',
'ipbreasonotherlist'              => '常犯',
'ipbreason-dropdown'              => '
*如下道：
** 造假報
** 毀文貌
** 廣賈告
** 話胡鬧
** 恐嚇擾
** 污名號
** 名瀆道',
'ipbanononly'                     => '惟禁匿',
'ipbcreateaccount'                => '禁增簿',
'ipbemailban'                     => '禁郵捎',
'ipbenableautoblock'              => '屢禁此簿，新IP址、後繼亦如也。',
'ipbsubmit'                       => '禁簿',
'ipbother'                        => '別期',
'ipboptions'                      => '二時:2 hours,一日:1 day,三日:3 days,一週:1 week,二週:2 weeks,一月:1 month,三月:3 months,六月:6 months,一年:1 year,永如:infinite', # display1:time1,display2:time2,...
'ipbotheroption'                  => '它',
'ipbotherreason'                  => '補證、加證曰',
'ipbhidename'                     => '簿名隱乎誌禁、表禁、點簿。',
'ipbwatchuser'                    => '哨該簿之齋與議',
'badipaddress'                    => 'IP不格',
'blockipsuccesssub'               => '禁焉',
'blockipsuccesstext'              => '[[Special:Contributions/$1|$1]]禁焉。表禁<br />見[[Special:IPBlockList|此]]。',
'ipb-edit-dropdown'               => '改證',
'ipb-unblock-addr'                => '赦$1',
'ipb-unblock'                     => '赦簿、址',
'ipb-blocklist-addr'              => '見$1禁',
'ipb-blocklist'                   => '列禁',
'unblockip'                       => '赦簿',
'unblockiptext'                   => '函下赦禁。',
'ipusubmit'                       => '赦此址',
'unblocked'                       => '[[User:$1|$1]]赦焉',
'unblocked-id'                    => '禁$1赦焉',
'ipblocklist'                     => '列禁簿、禁址',
'ipblocklist-legend'              => '尋禁簿',
'ipblocklist-username'            => '簿名、IP址：',
'ipblocklist-submit'              => '尋',
'blocklistline'                   => '$1，$2禁$3（$4）',
'infiniteblock'                   => '永如',
'expiringblock'                   => '屆$1',
'anononlyblock'                   => '惟匿者',
'noautoblockblock'                => '止自禁',
'createaccountblock'              => '禁增簿',
'emailblock'                      => '郵禁焉',
'ipblocklist-empty'               => '無禁。',
'ipblocklist-no-results'          => '簿名、IP址未禁焉。',
'blocklink'                       => '禁',
'unblocklink'                     => '赦',
'contribslink'                    => '勛',
'autoblocker'                     => '近日$1"$2"；同子IP址，故禁焉。',
'blocklogpage'                    => '誌禁',
'blocklogentry'                   => '禁[[$1]]屆$2$3',
'blocklogtext'                    => '此誌禁赦；自禁不示。見[[Special:IPBlockList|此]]列今禁者。',
'unblocklogentry'                 => '$1赦焉',
'block-log-flags-anononly'        => '惟禁匿',
'block-log-flags-nocreate'        => '禁增簿',
'block-log-flags-noautoblock'     => '止自禁',
'block-log-flags-noemail'         => '郵禁焉',
'block-log-flags-angry-autoblock' => '強自封用也',
'range_block_disabled'            => '未准有秩圍禁。',
'ipb_expiry_invalid'              => '屆期不明。',
'ipb_expiry_temp'                 => '藏簿禁封必為長久也。',
'ipb_already_blocked'             => '"$1"早禁矣',
'ipb_cant_unblock'                => '有誤：禁$1無尋；或早赦矣。',
'ipb_blocked_as_range'            => '錯：該IP $1 無直禁也，無赦之。唯它在 $2 之範禁內，其範可赦之。',
'ip_range_invalid'                => 'IP址圍不格',
'blockme'                         => '自禁',
'proxyblocker'                    => '禁Proxy',
'proxyblocksuccess'               => '成矣。',

# Developer tools
'lockdb'              => '閉庫',
'unlockdb'            => '開庫',
'lockdbtext'          => '夫閉庫者，止撰編、凍簿註、休令哨、謝問庫也。篤欲行，事畢開之。',
'unlockdbtext'        => '夫開庫者，迎撰編、任註簿、喜令哨、隨問庫也；慎篤之。',
'lockconfirm'         => '篤閉之。',
'unlockconfirm'       => '篤開之。',
'lockbtn'             => '閉庫',
'unlockbtn'           => '開庫',
'locknoconfirm'       => '未篤焉。',
'lockdbsuccesssub'    => '庫已閉',
'unlockdbsuccesssub'  => '庫已開',
'lockdbsuccesstext'   => '庫閉矣。<br />檢畢切[[Special:UnlockDB|開之]]。',
'unlockdbsuccesstext' => '庫開矣',
'lockfilenotwritable' => '未准更鎖庫檔。欲開閉之，網頁伺服須得更也。',
'databasenotlocked'   => '庫未閉焉。',

# Move page
'move-page'               => '遷$1',
'move-page-legend'        => '遷頁',
'movepagetext'            => "函下遷頁，誌隨新往、舊題作渡、取佐欲移。保佐正，[[Special:DoubleRedirects|防窮]]、[[Special:BrokenRedirects|斷渡]]。

囑之者，新題若非空、渡、缺誌，則舊'''不遷'''焉。存頁勿覆，而誤遷可悔也。

<b>警示</b>
膾炙遷焉，禍生不測；戒慎行之。",
'movearticle'             => '遷文：',
'movenotallowed'          => '無准遷文也。',
'newtitle'                => '至新題：',
'move-watch'              => '派哨',
'movepagebtn'             => '遷文',
'pagemovedsub'            => '遷成矣',
'movepage-moved'          => "<big>'''「$1」已遷至「$2」'''</big>", # The two titles are passed in plain text as $3 and $4 to allow additional goodies in the message.
'articleexists'           => '此題早存，或名謬焉；請更之。',
'cantmove-titleprotected' => '爾不可動頁至此，因新題已緘焉，防建之。',
'talkexists'              => "'''文遷成而議未移，蓋早存也；請併之。'''",
'movedto'                 => '遷至',
'movetalk'                => '議並遷',
'move-subpages'           => '如可，同遷議',
'move-talk-subpages'      => '如可，同遷子議',
'movepage-page-exists'    => '頁$1已存矣，非自覆也。',
'movepage-page-moved'     => '頁$1遷$2矣。',
'movepage-page-unmoved'   => '頁$1遷$2不成。',
'movepage-max-pages'      => '上之$1頁遷矣同非自遷之下。',
'1movedto2'               => '[[$1]]遷至[[$2]]',
'1movedto2_redir'         => '[[$1]]遷至[[$2]]為渡',
'movelogpage'             => '誌遷',
'movelogpagetext'         => '頁遷如下：',
'movereason'              => '因',
'revertmove'              => '還',
'delete_and_move'         => '刪遷',
'delete_and_move_text'    => '==准刪==

往遷"[[:$1]]"存，刪之以替乎？',
'delete_and_move_confirm' => '刪之',
'delete_and_move_reason'  => '為遷而刪之',
'selfmove'                => '鄉遷同源，如未移也。',
'immobile_namespace'      => '鄉遷其一，名冊特異，不可遷也。',
'imagenocrossnamespace'   => '非勳檔至非檔名間',
'imagetypemismatch'       => '其新副檔名非配其類也',
'imageinvalidfilename'    => '標之檔名乃無效也',
'fix-double-redirects'    => '更指原題之任渡',

# Export
'export'            => '出匯',
'exporttext'        => '文、誌纂、擇頁可編成XML，借MediaWiki[[Special:Import|入匯]他山]。欲出匯，函下題之，每列一題，任牽舊審、誌文；或獨帶末纂之述，以鏈表之，如以[[{{ns:special}}:Export/{{MediaWiki:Mainpage}}]]匯"[[{{MediaWiki:Mainpage}}]]"。',
'exportcuronly'     => '獨匯今審',
'exportnohistory'   => "----
'''囑記，'''封匯全誌，因累甚也。",
'export-submit'     => '出匯',
'export-addcattext' => '索門擇題：',
'export-addcat'     => '增',
'export-download'   => '備檔以載',
'export-templates'  => '含模',

# Namespace 8 related
'allmessages'               => '官話',
'allmessagesname'           => '話',
'allmessagesdefault'        => '慣文',
'allmessagescurrent'        => '今文',
'allmessagestext'           => '此列MediaWiki官話。
如貢正宗MediaWiki本地化，[http://www.mediawiki.org/wiki/Localisation MediaWiki本地化]與[http://translatewiki.net Betawiki]閱之。',
'allmessagesnotsupportedDB' => "'''\$wgUseDatabaseMessages'''閉庫，'''無纂也。",
'allmessagesfilter'         => '含辭：',
'allmessagesmodified'       => '見易',

# Thumbnails
'thumbnail-more'           => '展',
'filemissing'              => '喪檔',
'thumbnail_error'          => '縮圖$1有誤',
'thumbnail_invalid_params' => '縮圖參數不合',
'thumbnail_dest_directory' => '縮圖匣未可造',

# Special:Import
'import'                     => '圖入匯',
'importinterwiki'            => '維基互匯',
'import-interwiki-text'      => '欲入匯，擇維基、揀題文，審時、纂者隨記也。互匯錄於[[Special:Log/import|誌入]]。',
'import-interwiki-history'   => '審、誌同匯',
'import-interwiki-submit'    => '入匯',
'import-interwiki-namespace' => '入名冊：',
'importtext'                 => '請[[Special:Export|出匯]]儲之。
再入匯於此。',
'importstart'                => '入匯…',
'import-revision-count'      => '有審$1',
'importnopages'              => '無可匯。',
'importfailed'               => '入匯有變：<nowiki>$1</nowiki>',
'importunknownsource'        => '入類不明',
'importcantopen'             => '入未可啟',
'importbadinterwiki'         => '維基內鏈壞',
'importnotext'               => '空檔或無文',
'importsuccess'              => '入匯成矣！',
'importhistoryconflict'      => '舊審沖，疑早存焉',
'importnosources'            => '互匯而未定入源，審、誌不予直進。',
'importnofile'               => '無匯入也。',
'importuploaderrorsize'      => '檔未入匯。幅越焉。',
'importuploaderrorpartial'   => '檔未入匯。檔部傳。',
'importuploaderrortemp'      => '檔未入匯。臨夾已失。',
'import-parse-failure'       => 'XML入匯語法敗矣',
'import-noarticle'           => '無頁入匯也！',
'import-nonewrevisions'      => '全審已入匯也。',
'xml-error-string'           => '$1 於行$2，欄$3 ($4字節): $5',
'import-upload'              => '貢XML',

# Import log
'importlogpage'                    => '誌入',
'importlogpagetext'                => '秩入匯自他山之審。',
'import-logentry-upload'           => '[[$1]]上傳而匯',
'import-logentry-upload-detail'    => '有審$1',
'import-logentry-interwiki'        => '互匯$1',
'import-logentry-interwiki-detail' => '$1審自$2',

# Tooltip help for the actions
'tooltip-pt-userpage'             => '述平生、紹身家、銘字號',
'tooltip-pt-anonuserpage'         => '君IP之舍',
'tooltip-pt-mytalk'               => '與眾論、往魚雁、湧文滔',
'tooltip-pt-anontalk'             => '此IP所修之議',
'tooltip-pt-preferences'          => '更符驛、排版式、投所好',
'tooltip-pt-watchlist'            => '收矚目、治眼線、賞萌茂',
'tooltip-pt-mycontris'            => '刻勛功、追作續、慰苦勞',
'tooltip-pt-login'                => '設書齋、錄功績、廣放哨',
'tooltip-pt-anonlogin'            => '設書齋、錄功績、廣放哨',
'tooltip-pt-logout'               => '凡事盡，乘雲飄',
'tooltip-ca-talk'                 => '求異見、辯是非、妥紛擾',
'tooltip-ca-edit'                 => '拓文意、校誤謬、潤辭藻',
'tooltip-ca-addsection'           => '有言議，添新要',
'tooltip-ca-viewsource'           => '文函緘，讀源老',
'tooltip-ca-history'              => '誌流衍、備謄本、修惡盜',
'tooltip-ca-protect'              => '謝撰纂，奏原調',
'tooltip-ca-delete'               => '撕書頁，棄於奧',
'tooltip-ca-undelete'             => '悔刪斷，奉回轎',
'tooltip-ca-move'                 => '安居所，嚮正道',
'tooltip-ca-watch'                => '哨此報',
'tooltip-ca-unwatch'              => '撤此哨',
'tooltip-search'                  => '索大典，籲自曉',
'tooltip-search-go'               => '確合契，躍步到',
'tooltip-search-fulltext'         => '尋通篇，列倣傚',
'tooltip-p-logo'                  => '返卷首，訪露朝',
'tooltip-n-mainpage'              => '返卷首，訪露朝',
'tooltip-n-portal'                => '識百科、習施行、熟矩教',
'tooltip-n-currentevents'         => '知天下、順潮流、察脈絡',
'tooltip-n-recentchanges'         => '閱新易、聞脈搏、觀熱鬧',
'tooltip-n-randompage'            => '嚐鮮味，隨遊遨',
'tooltip-n-help'                  => '解疑惑、點明燈、掛病號',
'tooltip-t-whatlinkshere'         => '何美餚，佐此料',
'tooltip-t-recentchangeslinked'   => '足義友，借鏡照',
'tooltip-feed-rss'                => '本卷之RSS源',
'tooltip-feed-atom'               => '本卷之Atom源',
'tooltip-t-contributions'         => '同肩戰，苦功高',
'tooltip-t-emailuser'             => '言未猶，書信捎',
'tooltip-t-upload'                => '貢彩件、獻樂謠',
'tooltip-t-specialpages'          => '奇怪求，特查找',
'tooltip-t-print'                 => '備印墨，整版貌',
'tooltip-t-permalink'             => '鏈緊焊，橋吊牢',
'tooltip-ca-nstab-main'           => '閱文稿',
'tooltip-ca-nstab-user'           => '返齋寮',
'tooltip-ca-nstab-media'          => '聽媒紹',
'tooltip-ca-nstab-special'        => '特查報，謝纂校',
'tooltip-ca-nstab-project'        => '探爐灶',
'tooltip-ca-nstab-image'          => '觀揮毫',
'tooltip-ca-nstab-mediawiki'      => '聞官耗',
'tooltip-ca-nstab-template'       => '尋模造',
'tooltip-ca-nstab-help'           => '助拳腳',
'tooltip-ca-nstab-category'       => '入門道',
'tooltip-minoredit'               => '正小錯，謙註校',
'tooltip-save'                    => '葺修畢，儲之窖',
'tooltip-preview'                 => '篤存儲，先草稿',
'tooltip-diff'                    => '留筆過，觀入刀',
'tooltip-compareselectedversions' => '揀二審，辨毀造',
'tooltip-watch'                   => '哨此報',
'tooltip-recreate'                => '昔棄鄙，重起灶',
'tooltip-upload'                  => '獻品備，伐步跑',

# Stylesheets
'common.css'      => '/* 此之 CSS 用於全面也 */',
'standard.css'    => '/* 此之 CSS 用於經典面之簿也 */',
'nostalgia.css'   => '/* 此之 CSS 用於懷古面之簿也 */',
'cologneblue.css' => '/* 此之 CSS 用於馨藍面之簿也 */',
'monobook.css'    => '/* 此之 CSS 用於單書面之簿也 */',
'myskin.css'      => '/* 此之 CSS 用於吾風面之簿也 */',
'chick.css'       => '/* 此之 CSS 用於窈窕面之簿也 */',
'simple.css'      => '/* 此之 CSS 用於簡明面之簿也 */',
'modern.css'      => '/* 此之 CSS 用於時髦面之簿也 */',

# Scripts
'common.js'      => '/* 此之JavaScript將載於全簿之頁。 */',
'standard.js'    => '/* 此之JavaScript將載於用經典面之簿 */',
'nostalgia.js'   => '/* 此之JavaScript將載於用懷古面之簿 */',
'cologneblue.js' => '/* 此之JavaScript將載於用馨藍面之簿 */',
'monobook.js'    => '/* 此之JavaScript將載於用單書面之簿 */',
'myskin.js'      => '/* 此之JavaScript將載於用吾風面之簿 */',
'chick.js'       => '/* 此之JavaScript將載於用窈窕面之簿 */',
'simple.js'      => '/* 此之JavaScript將載於用簡明面之簿 */',
'modern.js'      => '/* 此之JavaScript將載於用時髦面之簿 */',

# Attribution
'anonymous'        => '{{SITENAME}}無簿者',
'siteuser'         => '{{SITENAME}}有簿者$1',
'lastmodifiedatby' => '$1$2，$3新易此頁。', # $1 date, $2 time, $3 user
'othercontribs'    => '$1主撰',
'others'           => '他',
'siteusers'        => '{{SITENAME}}有簿者$1',
'creditspage'      => '頁贊',
'nocredits'        => '本頁未有贊信也。',

# Spam protection
'spamprotectiontitle' => '防賈濫',
'spamprotectiontext'  => '外鏈疑賈，存頁止焉。',
'spamprotectionmatch' => '憑如下：$1',
'spambot_username'    => 'MediaWiki清濫',
'spam_reverting'      => '還新審之無鏈$1者。',
'spam_blanking'       => '審皆鏈$1，遂令白頁。',

# Info page
'infosubtitle'   => '頁註',
'numedits'       => '有纂$1',
'numtalkedits'   => '有議$1',
'numwatchers'    => '有哨$1',
'numauthors'     => '編者$1',
'numtalkauthors' => '議者$1',

# Math options
'mw_math_png'    => '屢作PNG',
'mw_math_simple' => '易為則作HTML，否則PNG',
'mw_math_html'   => '堪為則作HTML，否則PNG',
'mw_math_source' => 'TeX依舊，純文覽器適也。',
'mw_math_modern' => '今之覽器此薦。',
'mw_math_mathml' => '實驗者，堪為則作MathML。',

# Patrolling
'markaspatrolleddiff'                 => '派哨',
'markaspatrolledtext'                 => '哨此報',
'markedaspatrolled'                   => '派哨',
'markedaspatrolledtext'               => '此審哨矣。',
'rcpatroldisabled'                    => '不哨近易',
'rcpatroldisabledtext'                => '近易之哨，未准行也。',
'markedaspatrollederror'              => '哨有誤',
'markedaspatrollederrortext'          => '揀一以哨。',
'markedaspatrollederror-noautopatrol' => '己易不可哨。',

# Patrol log
'patrol-log-page'   => '誌哨',
'patrol-log-header' => '此乃誌哨也。',
'patrol-log-line'   => '令哨$2之$1$3',
'patrol-log-auto'   => '（自行）',

# Image deletion
'deletedrevision'                 => '刪舊審$1',
'filedeleteerror-short'           => '刪檔有誤：$1',
'filedeleteerror-long'            => '刪檔有誤：\\n\\n$1\\n',
'filedelete-missing'              => '"$1"不存，無可刪也。',
'filedelete-old-unregistered'     => '庫無舊審"$1"。',
'filedelete-current-unregistered' => '庫無"$1"也。',
'filedelete-archive-read-only'    => '"$1"存匣，未准更之。',

# Browsing diffs
'previousdiff' => '←前辨',
'nextdiff'     => '後辨→',

# Media information
'mediawarning'         => "'''警'''日：此檔疑惡，行之恐諜也。<hr />",
'imagemaxsize'         => '述檔頁惟列：',
'thumbsize'            => '縮圖幅',
'widthheight'          => '$1矩$2',
'widthheightpage'      => '$1矩$2，共$3頁',
'svg-long-desc'        => '（SVG檔，貌有像素$1矩$2，幅$3）',
'show-big-image'       => '全幅',
'show-big-image-thumb' => '<small>縮圖幅有像素$1矩$2</small>',

# Special:NewImages
'newimages'             => '新圖之廊',
'imagelisttext'         => "下表乃按$2排之的'''$1'''檔。",
'newimages-summary'     => '此奇頁示最後呈上之檔也。',
'showhidebots'          => '（$1僕）',
'noimages'              => '無可見。',
'ilsubmit'              => '尋檔',
'bydate'                => '時序',
'sp-newimages-showfrom' => '自$1 $2賞新檔',

# Video information, used by Language::formatTimePeriod() to format lengths in the above messages
'video-dims' => '$1，$2矩$3',

# Bad image list
'bad_image_list' => '僅取表件，冠「*」者也。格式如下：

單列數鏈，首通壞檔；而後所鏈之文，允圖見於其內。',

# Metadata
'metadata'          => '補註',
'metadata-help'     => '此檔補註，製者所添，如相機、掃描之器；後若更檔，補註不誠也。',
'metadata-expand'   => '見詳',
'metadata-collapse' => '藏詳',
'metadata-fields'   => '若藏詳，此下EXIF補註方現，否則藏焉。
* make
* model
* datetimeoriginal
* exposuretime
* fnumber
* focallength', # Do not translate list items

# EXIF tags
'exif-imagewidth'        => '寬',
'exif-imagelength'       => '長',
'exif-datetime'          => '文檔修訂之日期時辰',
'exif-make'              => '出廠',
'exif-model'             => '型號',
'exif-datetimeoriginal'  => '數據生成之日期時辰',
'exif-datetimedigitized' => '數位化之日期時辰',
'exif-exposuretime'      => '曝光',
'exif-fnumber'           => '光圈',
'exif-focallength'       => '焦距',

# External editor support
'edit-externally'      => '以外部程式修此文',
'edit-externally-help' => '請閱[http://www.mediawiki.org/wiki/Manual:External_editors 安裝指引]以知詳情。',

# 'all' in various places, this might be different for inflected languages
'recentchangesall' => '全',
'imagelistall'     => '全',
'watchlistall2'    => '全',
'namespacesall'    => '全',
'monthsall'        => '全',

# E-mail address confirmation
'confirmemail'             => '核郵驛',
'confirmemail_noemail'     => '[[Special:Preferences|簿註]]有驛。',
'confirmemail_send'        => '遣核符',
'confirmemail_sent'        => '核符遣矣',
'confirmemail_sendfailed'  => '信未遣焉，請核郵驛。

郵者覆之：$1',
'confirmemail_invalidated' => '核郵驛消也',
'invalidateemail'          => '消核郵驛',

# Scary transclusion
'scarytranscludedisabled' => '[蓋跨共筆之轉碼者，莫之能用也]',
'scarytranscludefailed'   => '[$1模不得]',
'scarytranscludetoolong'  => '[網址過長]',

# Trackbacks
'trackbackbox'      => '<div id="mw_trackbacks">此文之引:
$1
</div>',
'trackbackremove'   => ' （[$1刪]）',
'trackbacklink'     => '迴響',
'trackbackdeleteok' => 'Trackback 刪矣。',

# Delete conflict
'deletedwhileediting' => '警：纂中見刪。',
'confirmrecreate'     => "[[User:$1|$1]]（[[User talk:$1|議]]）刪之有由：
''$2''
請爾審視之。",
'recreate'            => '復',

# HTML dump
'redirectingto' => '渡至[[:$1]]…',

# action=purge
'confirm_purge'        => '清謄本？

$1',
'confirm_purge_button' => '准',

# AJAX search
'searchcontaining' => "尋文含''$1''",
'searchnamed'      => "尋文名''$1''.",
'articletitles'    => "文首為''$1''",
'hideresults'      => '藏',
'useajaxsearch'    => '用AJAX尋之',

# Separators for various lists, etc.
'comma-separator' => '、',
'colon-separator' => '：',

# Multipage image navigation
'imgmultipageprev' => '←前頁',
'imgmultipagenext' => '次頁→',
'imgmultigo'       => '往',
'imgmultigoto'     => '往頁$1',

# Table pager
'ascending_abbrev'         => '升冪',
'descending_abbrev'        => '降冪',
'table_pager_next'         => '次頁',
'table_pager_prev'         => '前頁',
'table_pager_first'        => '首頁',
'table_pager_last'         => '末頁',
'table_pager_limit'        => '頁有物$1',
'table_pager_limit_submit' => '往',
'table_pager_empty'        => '空',

# Auto-summaries
'autosumm-blank'   => '盡除之',
'autosumm-replace' => "置為'$1'",
'autoredircomment' => '渡至[[$1]]',
'autosumm-new'     => '新文：$1',

# Size units
'size-bytes' => '$1 位元組',

# Live preview
'livepreview-loading' => '遺藏…',
'livepreview-ready'   => '藏至矣。',
'livepreview-failed'  => '弗能即時示之！嘗以本法。',
'livepreview-error'   => '莫之連也：$1 "$2" 嘗以本法。',

# Friendlier slave lag warnings
'lag-warn-normal' => '近$1秒新易者疑喪也。',
'lag-warn-high'   => '遣藏遲焉。近$1秒新易者疑喪也。',

# Watchlist editor
'watchlistedit-numitems'       => '不計議論，哨有題$1。',
'watchlistedit-noitems'        => '哨無題也。',
'watchlistedit-normal-title'   => '治哨站',
'watchlistedit-normal-legend'  => '撤之',
'watchlistedit-normal-explain' => '盡列有哨。欲撤題，揀之再擊。亦[[Special:Watchlist/raw|治源哨]]也。',
'watchlistedit-normal-submit'  => '撤題',
'watchlistedit-normal-done'    => '$1題之哨已撤：',
'watchlistedit-raw-title'      => '治源哨',
'watchlistedit-raw-legend'     => '治源哨',
'watchlistedit-raw-explain'    => '盡列有哨。治此表以加減題；一行一題之。善，擊更哨。亦[[Special:Watchlist/edit|標準治哨]]也。',
'watchlistedit-raw-titles'     => '題：',
'watchlistedit-raw-submit'     => '更哨',
'watchlistedit-raw-done'       => '哨更矣。',
'watchlistedit-raw-added'      => '已添$1題：',
'watchlistedit-raw-removed'    => '已撤$1題：',

# Watchlist editing tools
'watchlisttools-view' => '察易',
'watchlisttools-edit' => '治哨站',
'watchlisttools-raw'  => '治源哨',

# Core parser functions
'unknown_extension_tag' => '未明之擴標「$1」',

# Special:Version
'version'                          => '版', # Not used as normal message but as header for the special page itself
'version-extensions'               => '裝展',
'version-specialpages'             => '奇頁',
'version-parserhooks'              => '語鈎',
'version-variables'                => '變數',
'version-other'                    => '他',
'version-mediahandlers'            => '媒處',
'version-hooks'                    => '鈎',
'version-extension-functions'      => '展函',
'version-parser-extensiontags'     => '語展標',
'version-parser-function-hooks'    => '語函鈎',
'version-skin-extension-functions' => '面版展函',
'version-hook-name'                => '鈎名',
'version-hook-subscribedby'        => '用於',
'version-version'                  => '版',
'version-license'                  => '牌',
'version-software'                 => '裝件',
'version-software-product'         => '品',
'version-software-version'         => '版',

# Special:FilePath
'filepath'         => '檔路',
'filepath-page'    => '檔名：',
'filepath-submit'  => '尋路',
'filepath-summary' => '此奇頁取一檔之整路。圖以全解像示之，他檔會以有關之程式啟動也。

輸檔名之，不包「{{ns:image}}:」開頭也。',

# Special:FileDuplicateSearch
'fileduplicatesearch'          => '擇重檔',
'fileduplicatesearch-summary'  => '以重檔之切去查重也。

入名時無 "{{ns:image}}:" 首也。',
'fileduplicatesearch-legend'   => '尋重',
'fileduplicatesearch-filename' => '名：',
'fileduplicatesearch-submit'   => '尋',
'fileduplicatesearch-info'     => '$1 × $2 像素<br />大小: $3<br />MIME類型: $4',
'fileduplicatesearch-result-1' => '案 "$1" 無重也。',
'fileduplicatesearch-result-n' => '案 "$1" 重有$2。',

# Special:SpecialPages
'specialpages'                   => '特查',
'specialpages-note'              => '----
* 準特查。
* <span class="mw-specialpagerestricted">限特查。</span>',
'specialpages-group-maintenance' => '護報',
'specialpages-group-other'       => '它之奇頁',
'specialpages-group-login'       => '登／增',
'specialpages-group-changes'     => '近易與誌',
'specialpages-group-media'       => '媒報兼呈',
'specialpages-group-users'       => '簿與權',
'specialpages-group-highuse'     => '高用頁',
'specialpages-group-pages'       => '頁列',
'specialpages-group-pagetools'   => '頁器',
'specialpages-group-wiki'        => 'Wiki訊與器',
'specialpages-group-redirects'   => '轉之特查',
'specialpages-group-spam'        => '反垃圾之器',

# Special:BlankPage
'blankpage'              => '白頁',
'intentionallyblankpage' => '此頁為白也，試速之用',

);
