/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.content;

import org.w3c.dom.Element;
import writer2latex.bibtex.BibTeXDocument;
import writer2latex.latex.Context;
import writer2latex.latex.ConverterHelper;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.office.BibMark;
import writer2latex.office.IndexMark;
import writer2latex.util.Config;
import writer2latex.util.Misc;

public class IndexConverter
extends ConverterHelper {
    private BibTeXDocument bibDoc;
    private boolean bContainsAlphabeticalIndex = false;

    public IndexConverter(Config config, ConverterPalette converterPalette) {
        super(config, converterPalette);
    }

    public void appendDeclarations(LaTeXDocumentPortion laTeXDocumentPortion, LaTeXDocumentPortion laTeXDocumentPortion2) {
        if (this.bContainsAlphabeticalIndex) {
            laTeXDocumentPortion.append("\\usepackage{makeidx}").nl();
            laTeXDocumentPortion2.append("\\makeindex").nl();
        }
    }

    public void handleTOC(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        Element element2 = Misc.getChildByTagName(element, "text:table-of-content-source");
        if (element2 != null) {
            if ("chapter".equals(element2.getAttribute("text:index-source"))) {
                laTeXDocumentPortion.append("[Warning: Table of content (for this chapter) ignored!]").nl().nl();
            } else {
                int n = Misc.getPosInteger(element2.getAttribute("text:outline-level"), 1);
                laTeXDocumentPortion.append("\\setcounter{tocdepth}{" + n + "}").nl();
                Element element3 = Misc.getChildByTagName(element2, "text:index-title-template");
                if (element3 != null) {
                    laTeXDocumentPortion.append("\\renewcommand\\contentsname{");
                    this.palette.getInlineCv().traversePCDATA(element3, laTeXDocumentPortion, context);
                    laTeXDocumentPortion.append("}").nl();
                }
            }
        }
        laTeXDocumentPortion.append("\\tableofcontents").nl();
    }

    public void handleLOF(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        laTeXDocumentPortion.append("[Warning: List of illustrations ignored]").nl().nl();
    }

    public void handleLOT(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        laTeXDocumentPortion.append("[Warning: List of tables ignored]").nl().nl();
    }

    public void handleObjectIndex(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        laTeXDocumentPortion.append("[Warning: Object index ignored]").nl().nl();
    }

    public void handleUserIndex(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        laTeXDocumentPortion.append("[Warning: User index ignored]").nl().nl();
    }

    public void handleBibliography(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        if (this.config.useBibtex()) {
            if (this.bibDoc == null) {
                this.bibDoc = new BibTeXDocument(this.palette.getOutFileName());
            }
            laTeXDocumentPortion.append("\\bibliographystyle{").append(this.config.bibtexStyle()).append("}").nl();
            laTeXDocumentPortion.append("\\bibliography{").append(this.bibDoc.getName()).append("}").nl();
        } else {
            Element element2 = Misc.getChildByTagName(element, "text:index-body");
            if (element2 != null) {
                Element element3 = Misc.getChildByTagName(element2, "text:index-title");
                if (element3 != null) {
                    this.palette.getBlockCv().traverseBlockText(element3, laTeXDocumentPortion, context);
                }
                this.palette.getBlockCv().traverseBlockText(element2, laTeXDocumentPortion, context);
            }
        }
    }

    public void handleBibliographyMark(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        if (this.config.useBibtex()) {
            String string;
            if (this.bibDoc == null) {
                this.bibDoc = new BibTeXDocument(this.palette.getOutFileName());
            }
            if (!this.bibDoc.containsKey(string = element.getAttribute("text:identifier"))) {
                this.bibDoc.put(new BibMark(element));
            }
            laTeXDocumentPortion.append("\\cite{").append(this.bibDoc.getExportName(string)).append("}");
        } else {
            this.palette.getInlineCv().traverseInlineText(element, laTeXDocumentPortion, context, false);
        }
    }

    public BibTeXDocument getBibTeXDocument() {
        return this.bibDoc;
    }

    public void handleAlphabeticalIndex(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        laTeXDocumentPortion.append("\\printindex").nl();
        this.bContainsAlphabeticalIndex = true;
    }

    public void handleAlphabeticalIndexMark(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        String string = IndexMark.getIndexValue(element);
        if (string != null) {
            String string2;
            laTeXDocumentPortion.append("\\index{");
            String string3 = IndexMark.getKey1(element);
            if (string3 != null) {
                this.writeIndexText(string3, laTeXDocumentPortion, context);
                laTeXDocumentPortion.append("!");
            }
            if ((string2 = IndexMark.getKey2(element)) != null) {
                this.writeIndexText(string2, laTeXDocumentPortion, context);
                laTeXDocumentPortion.append("!");
            }
            this.writeIndexText(string, laTeXDocumentPortion, context);
            laTeXDocumentPortion.append("}");
        }
    }

    private void writeIndexText(String string, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        String string2 = this.palette.getI18n().convert(string, false, context.getLang());
        int n = string2.length();
        boolean bl = false;
        block4: for (int i = 0; i < n; ++i) {
            if (bl) {
                laTeXDocumentPortion.append(string2.substring(i, i + 1));
                bl = false;
                continue;
            }
            switch (string2.charAt(i)) {
                case '\\': {
                    bl = true;
                    laTeXDocumentPortion.append("\\");
                    continue block4;
                }
                case '!': 
                case '\"': 
                case '@': 
                case '|': {
                    laTeXDocumentPortion.append("\"");
                }
                default: {
                    laTeXDocumentPortion.append(string2.substring(i, i + 1));
                }
            }
        }
    }
}

