/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.content;

import java.util.Hashtable;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.content.CharClasses;
import writer2latex.latex.content.SmToken;
import writer2latex.latex.content.SmTokenTable;
import writer2latex.latex.content.TGroup;
import writer2latex.latex.content.Token;
import writer2latex.latex.style.I18n;
import writer2latex.util.Config;
import writer2latex.util.Misc;
import writer2latex.util.SimpleInputBuffer;

public final class StarMathConverter {
    private SmTokenTable keywords = new SmTokenTable(SmTokenTable.keywords);
    private SmTokenTable symbols = new SmTokenTable(SmTokenTable.symbols);
    private Hashtable configSymbols;
    private boolean bUseColor;
    private SmToken curToken = new SmToken();
    private SimpleInputBuffer buffer;
    private Float fBaseSize;
    private I18n i18n;
    private boolean bDefeq = false;
    private boolean bLambdabar = false;
    private boolean bDdotsup = false;
    private boolean bMultimapdotbothA = false;
    private boolean bMultimapdotbothB = false;
    private boolean bLlbracket = false;
    private boolean bRrbracket = false;
    private boolean bOiint = false;
    private boolean bOiiint = false;
    private boolean bWideslash = false;
    private boolean bWidebslash = false;
    private boolean bBoldsubformula = false;
    private boolean bNormalsubformula = false;
    private boolean bMultiscripts = false;
    private boolean bMathoverstrike = false;

    StarMathConverter(I18n i18n, Config config) {
        this.i18n = i18n;
        this.configSymbols = config.getMathSymbols();
        this.bUseColor = config.useColor();
    }

    public void appendDeclarations(LaTeXDocumentPortion laTeXDocumentPortion, LaTeXDocumentPortion laTeXDocumentPortion2) {
        if (this.bDefeq) {
            laTeXDocumentPortion2.append("\\newcommand\\defeq{\\stackrel{\\mathrm{def}}{=}}").nl();
        }
        if (this.bLambdabar) {
            laTeXDocumentPortion2.append("\\newcommand\\lambdabar{\\mathchar'26\\mkern-10mu\\lambda}").nl();
        }
        if (this.bDdotsup) {
            laTeXDocumentPortion2.append("\\newcommand\\ddotsup{\\mathinner{\\mkern1mu\\raise1pt\\vbox{\\kern7pt\\hbox{.}}\\mkern2mu\\raise4pt\\hbox{.}\\mkern2mu\\raise7pt\\hbox{.}\\mkern1mu}}").nl();
        }
        if (this.bMultimapdotbothA) {
            laTeXDocumentPortion2.append("\\providecommand\\multimapdotbothA{\\bullet\\kern-0.4em-\\kern-0.4em\\circ}").nl();
        }
        if (this.bMultimapdotbothB) {
            laTeXDocumentPortion2.append("\\providecommand\\multimapdotbothB{\\circ\\kern-0.4em-\\kern-0.4em\\bullet}").nl();
        }
        if (this.bLlbracket) {
            laTeXDocumentPortion2.append("\\providecommand\\llbracket{[}").nl();
        }
        if (this.bRrbracket) {
            laTeXDocumentPortion2.append("\\providecommand\\rrbracket{]}").nl();
        }
        if (this.bOiint) {
            laTeXDocumentPortion2.append("\\providecommand\\oiint{\\oint}").nl();
        }
        if (this.bOiiint) {
            laTeXDocumentPortion2.append("\\providecommand\\oiiint{\\oint}").nl();
        }
        if (this.bWideslash) {
            laTeXDocumentPortion2.append("\\newcommand\\wideslash[2]{{}^{#1}/_{#2}}").nl();
        }
        if (this.bWidebslash) {
            laTeXDocumentPortion2.append("\\newcommand\\widebslash[2]{{}_{#1}\\backslash^{#2}}").nl();
        }
        if (this.bBoldsubformula) {
            laTeXDocumentPortion2.append("\\newcommand\\boldsubformula[1]{\\text{\\mathversion{bold}$#1$}}").nl();
        }
        if (this.bNormalsubformula) {
            laTeXDocumentPortion2.append("\\newcommand\\normalsubformula[1]{\\text{\\mathversion{normal}$#1$}}").nl();
        }
        if (this.bMultiscripts || this.bMathoverstrike) {
            laTeXDocumentPortion2.append("\\newlength{\\idxmathdepth}\\newlength{\\idxmathtotal}\\newlength{\\idxmathwidth}\\newlength{\\idxraiseme}").nl();
            laTeXDocumentPortion2.append("\\newcommand{\\idxdheight}[1]{\\protect\\settoheight{\\idxmathtotal}{\\(\\displaystyle#1\\)}\\protect\\settodepth{\\idxmathdepth}{\\(\\displaystyle#1\\)}\\protect\\settowidth{\\idxmathwidth}{\\(\\displaystyle#1\\)}\\protect\\addtolength{\\idxmathtotal}{\\idxmathdepth}\\protect\\setlength{\\idxraiseme}{\\idxmathtotal/2-\\idxmathdepth}}").nl();
            laTeXDocumentPortion2.append("\\newcommand{\\idxtheight}[1]{\\protect\\settoheight{\\idxmathtotal}{\\(\\textstyle #1\\)}\\protect\\settodepth{\\idxmathdepth}{\\(\\textstyle #1\\)}\\protect\\settowidth{\\idxmathwidth}{\\(\\textstyle#1\\)}\\protect\\addtolength{\\idxmathtotal}{\\idxmathdepth}\\protect\\setlength{\\idxraiseme}{\\idxmathtotal/2-\\idxmathdepth}}").nl();
            laTeXDocumentPortion2.append("\\newcommand{\\idxsheight}[1]{\\protect\\settoheight{\\idxmathtotal}{\\(\\scriptstyle #1\\)}\\protect\\settodepth{\\idxmathdepth}{\\(\\scriptstyle #1\\)}\\protect\\settowidth{\\idxmathwidth}{\\(\\scriptstyle#1\\)}\\protect\\addtolength{\\idxmathtotal}{\\idxmathdepth}\\protect\\setlength{\\idxraiseme}{\\idxmathtotal/2-\\idxmathdepth}}").nl();
            laTeXDocumentPortion2.append("\\newcommand{\\idxssheight}[1]{\\protect\\settoheight{\\idxmathtotal}{\\(\\scriptscriptstyle #1\\)}\\protect\\settodepth{\\idxmathdepth}{\\(\\scriptscriptstyle #1\\)}\\protect\\settowidth{\\idxmathwidth}{\\(\\scriptscriptstyle#1\\)}\\protect\\addtolength{\\idxmathtotal}{\\idxmathdepth}\\protect\\setlength{\\idxraiseme}{\\idxmathtotal/2-\\idxmathdepth}}").nl();
        }
        if (this.bMultiscripts) {
            laTeXDocumentPortion2.append("\\newcommand\\multiscripts[5]{\\mathchoice").append("{\\idxdheight{#4}\\rule[-\\idxmathdepth]{0mm}{\\idxmathtotal}#1\\underset{#2}{\\overset{#3}{#4}}\\rule[-\\idxmathdepth]{0mm}{\\idxmathtotal}#5}").append("{\\idxtheight{#4}\\rule[-\\idxmathdepth]{0mm}{\\idxmathtotal}#1\\underset{#2}{\\overset{#3}{#4}}\\rule[-\\idxmathdepth]{0mm}{\\idxmathtotal}#5}").append("{\\idxsheight{#4}\\rule[-\\idxmathdepth]{0mm}{\\idxmathtotal}#1\\underset{#2}{\\overset{#3}{#4}}\\rule[-\\idxmathdepth]{0mm}{\\idxmathtotal}#5}").append("{\\idxssheight{#4}\\rule[-\\idxmathdepth]{0mm}{\\idxmathtotal}#1\\underset{#2}{\\overset{#3}{#4}}\\rule[-\\idxmathdepth]{0mm}{\\idxmathtotal}#5}}").nl();
        }
        if (this.bMathoverstrike) {
            laTeXDocumentPortion2.append("\\newcommand\\mathoverstrike[1]{\\mathchoice").append("{\\idxdheight{#1}\\rlap{\\rule[\\idxraiseme]{\\idxmathwidth}{0.4pt}}{#1}}").append("{\\idxtheight{#1}\\rlap{\\rule[\\idxraiseme]{\\idxmathwidth}{0.4pt}}{#1}}").append("{\\idxsheight{#1}\\rlap{\\rule[\\idxraiseme]{\\idxmathwidth}{0.4pt}}{#1}}").append("{\\idxssheight{#1}\\rlap{\\rule[\\idxraiseme]{\\idxmathwidth}{0.4pt}}{#1}}}").nl();
        }
    }

    private boolean tokenInGroup(TGroup tGroup) {
        return this.curToken.eGroup1 == tGroup || this.curToken.eGroup2 == tGroup;
    }

    private void skipWhiteSpaces() {
        while (Character.isWhitespace(this.buffer.peekChar())) {
            this.buffer.getChar();
        }
    }

    private void skipComment() {
        if (this.buffer.peekChar() != '%' || this.buffer.peekFollowingChar() != '%') {
            return;
        }
        while (!CharClasses.isEndOrLineEnd(this.buffer.peekChar())) {
            this.buffer.getChar();
        }
    }

    private void nextToken() {
        int n;
        do {
            n = this.buffer.getIndex();
            this.skipWhiteSpaces();
            this.skipComment();
        } while (n < this.buffer.getIndex());
        if (this.buffer.peekChar() == '\u0000') {
            this.curToken.assign(Token.END, "", 0);
            return;
        }
        if (this.buffer.peekChar() == '\"') {
            String string = "";
            this.buffer.getChar();
            while (this.buffer.peekChar() != '\"' && this.buffer.peekChar() != '\u0000') {
                string = string + this.buffer.getChar();
            }
            this.buffer.getChar();
            this.curToken.assign(Token.TEXT, this.i18n.convert(string, false, "en"), 5);
            return;
        }
        if (this.buffer.peekChar() == '%') {
            this.buffer.getChar();
            String string = this.buffer.getIdentifier();
            if (this.configSymbols.containsKey(string)) {
                this.curToken.assign(Token.SPECIAL, (String)this.configSymbols.get(string), 5);
            } else if (!this.symbols.lookup(string, false, this.curToken)) {
                this.curToken.assign(Token.IDENT, this.i18n.convert(string, true, "en"), 5);
            }
        } else {
            if (Character.isLetter(this.buffer.peekChar())) {
                String string = this.buffer.getIdentifier();
                if (!this.keywords.lookup(string, true, this.curToken)) {
                    this.curToken.assign(Token.IDENT, this.i18n.convert(string, true, "en"), 5);
                }
                return;
            }
            if (CharClasses.isDigitOrDot(this.buffer.peekChar())) {
                String string = this.buffer.getNumber();
                this.curToken.assign(Token.NUMBER, string, 5);
                return;
            }
            char c = this.buffer.getChar();
            switch (c) {
                case '<': {
                    if (this.buffer.peekChar() == '<') {
                        this.buffer.getChar();
                        this.curToken.assign(Token.LL, "\\ll ", TGroup.RELATION, 0);
                    } else if (this.buffer.peekChar() == '=') {
                        this.buffer.getChar();
                        this.curToken.assign(Token.LE, "\\le ", TGroup.RELATION, 0);
                    } else if (this.buffer.peekChar() == '>') {
                        this.buffer.getChar();
                        this.curToken.assign(Token.NEQ, "\\neq ", TGroup.RELATION, 0);
                    } else if (this.buffer.peekChar() == '?' && this.buffer.peekFollowingChar() == '>') {
                        this.buffer.getChar();
                        this.buffer.getChar();
                        this.curToken.assign(Token.PLACE, "\\Box ", TGroup.STANDALONE, 5);
                    } else {
                        this.curToken.assign(Token.LT, "<", TGroup.RELATION, 0);
                    }
                    return;
                }
                case '>': {
                    if (this.buffer.peekChar() == '>') {
                        this.buffer.getChar();
                        this.curToken.assign(Token.GG, "\\gg ", TGroup.RELATION, 0);
                    } else if (this.buffer.peekChar() == '=') {
                        this.buffer.getChar();
                        this.curToken.assign(Token.GE, "\\ge ", TGroup.RELATION, 0);
                    } else {
                        this.curToken.assign(Token.GT, ">", TGroup.RELATION, 0);
                    }
                    return;
                }
                case '[': {
                    this.curToken.assign(Token.LBRACKET, "[", TGroup.LBRACES, 5);
                    return;
                }
                case '\\': {
                    this.curToken.assign(Token.ESCAPE, "", 5);
                    return;
                }
                case ']': {
                    this.curToken.assign(Token.RBRACKET, "]", TGroup.RBRACES, 0);
                    return;
                }
                case '^': {
                    this.curToken.assign(Token.RSUP, "", TGroup.POWER, 0);
                    return;
                }
                case '_': {
                    this.curToken.assign(Token.RSUB, "", TGroup.POWER, 0);
                    return;
                }
                case '`': {
                    this.curToken.assign(Token.SBLANK, "\\;", TGroup.BLANK, 5);
                    return;
                }
                case '{': {
                    this.curToken.assign(Token.LGROUP, "{", 5);
                    return;
                }
                case '|': {
                    this.curToken.assign(Token.OR, "\\vee ", TGroup.SUM, 0);
                    return;
                }
                case '}': {
                    this.curToken.assign(Token.RGROUP, "}", 0);
                    return;
                }
                case '~': {
                    this.curToken.assign(Token.BLANK, "\\ ", TGroup.BLANK, 5);
                    return;
                }
                case '#': {
                    if (this.buffer.peekChar() == '#') {
                        this.buffer.getChar();
                        this.curToken.assign(Token.DPOUND, "", 0);
                    } else {
                        this.curToken.assign(Token.POUND, "", 0);
                    }
                    return;
                }
                case '&': {
                    this.curToken.assign(Token.AND, "\\wedge ", TGroup.PRODUCT, 0);
                    return;
                }
                case '(': {
                    this.curToken.assign(Token.LPARENT, "(", TGroup.LBRACES, 5);
                    return;
                }
                case ')': {
                    this.curToken.assign(Token.RPARENT, ")", TGroup.RBRACES, 0);
                    return;
                }
                case '*': {
                    this.curToken.assign(Token.MULTIPLY, "\\ast ", TGroup.PRODUCT, 0);
                    return;
                }
                case '+': {
                    if (this.buffer.peekChar() == '-') {
                        this.buffer.getChar();
                        this.curToken.assign(Token.PLUSMINUS, "\\pm ", TGroup.UNOPER, TGroup.SUM, 5);
                    } else {
                        this.curToken.assign(Token.PLUS, "+", TGroup.UNOPER, TGroup.SUM, 5);
                    }
                    return;
                }
                case '-': {
                    if (this.buffer.peekChar() == '+') {
                        this.buffer.getChar();
                        this.curToken.assign(Token.MINUSPLUS, "\\mp ", TGroup.UNOPER, TGroup.SUM, 5);
                    } else {
                        this.curToken.assign(Token.MINUS, "-", TGroup.UNOPER, TGroup.SUM, 5);
                    }
                    return;
                }
                case '/': {
                    this.curToken.assign(Token.DIVIDEBY, "/", TGroup.PRODUCT, 0);
                    return;
                }
                case '=': {
                    this.curToken.assign(Token.ASSIGN, "=", TGroup.RELATION, 0);
                    return;
                }
            }
            Character c2 = new Character(c);
            this.curToken.assign(Token.CHARACTER, this.i18n.convert(c2.toString(), true, "en"), 5);
            return;
        }
    }

    private String table(float f, Token token) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.line(f, token);
        if (this.curToken.eType == Token.NEWLINE) {
            stringBuffer.append("\\begin{gathered}").append(string);
            while (this.curToken.eType == Token.NEWLINE) {
                this.nextToken();
                stringBuffer.append("\\\\").append(this.line(f, token));
            }
            return stringBuffer.append("\\end{gathered}").toString();
        }
        return string;
    }

    private String align(float f, Token token, boolean bl, boolean bl2) {
        if (this.tokenInGroup(TGroup.ALIGN)) {
            token = this.curToken.eType;
            this.nextToken();
        }
        if (bl && token == Token.ALIGNL) {
            if (bl2) {
                return this.expression(f, token) + "\\hfill\\null ";
            }
            return this.expression(f, token) + "\\hfill ";
        }
        if (bl && token == Token.ALIGNR) {
            return "\\hfill " + this.expression(f, token);
        }
        return this.expression(f, token);
    }

    private String line(float f, Token token) {
        if (this.curToken.eType != Token.NEWLINE && this.curToken.eType != Token.END) {
            if (this.curToken.eType == Token.TEXT) {
                return this.expression(f, token) + "\\hfill ";
            }
            return this.align(f, token, true, false);
        }
        return "{}";
    }

    private String expression(float f, Token token) {
        StringBuffer stringBuffer = new StringBuffer().append(this.relation(f, token));
        while (this.curToken.nLevel >= 5) {
            stringBuffer.append(this.relation(f, token));
        }
        return stringBuffer.toString();
    }

    private String relation(float f, Token token) {
        StringBuffer stringBuffer = new StringBuffer().append(this.sum(f, token));
        while (this.tokenInGroup(TGroup.RELATION)) {
            if (this.curToken.eType == Token.TRANSL) {
                this.bMultimapdotbothA = true;
            } else if (this.curToken.eType == Token.TRANSR) {
                this.bMultimapdotbothB = true;
            } else if (this.curToken.eType == Token.DEF) {
                this.bDefeq = true;
            }
            stringBuffer.append(this.opsubsup(f, token)).append(this.sum(f, token));
        }
        return stringBuffer.toString();
    }

    private String sum(float f, Token token) {
        StringBuffer stringBuffer = new StringBuffer().append(this.product(f, token));
        while (this.tokenInGroup(TGroup.SUM)) {
            stringBuffer.append(this.opsubsup(f, token)).append(this.product(f, token));
        }
        return stringBuffer.toString();
    }

    private String product(float f, Token token) {
        String string = this.power(f, token, true);
        string = string.substring(1, string.length() - 1);
        while (this.tokenInGroup(TGroup.PRODUCT)) {
            if (this.curToken.eType == Token.OVER) {
                this.nextToken();
                string = "\\frac{" + string + "}" + this.power(f, token, true);
                continue;
            }
            if (this.curToken.eType == Token.BOPER) {
                this.nextToken();
                string = string + this.special() + this.power(f, token, false);
                continue;
            }
            if (this.curToken.eType == Token.OVERBRACE) {
                this.nextToken();
                string = "\\overbrace{" + string + "}^" + this.power(f, token, true);
                continue;
            }
            if (this.curToken.eType == Token.UNDERBRACE) {
                this.nextToken();
                string = "\\underbrace{" + string + "}_" + this.power(f, token, true);
                continue;
            }
            if (this.curToken.eType == Token.WIDESLASH) {
                this.bWideslash = true;
                this.nextToken();
                string = "\\wideslash{" + string + "}" + this.power(f, token, true);
                continue;
            }
            if (this.curToken.eType == Token.WIDEBACKSLASH) {
                this.bWidebslash = true;
                this.nextToken();
                string = "\\widebslash{" + string + "}" + this.power(f, token, true);
                continue;
            }
            string = string + this.opsubsup(f, token) + this.power(f, token, false);
        }
        return string;
    }

    private String tosub(String string) {
        return string != null ? "_" + string : "";
    }

    private String tosup(String string) {
        return string != null ? "^" + string : "";
    }

    private String subsup(float f, Token token, String string, TGroup tGroup) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        while (this.tokenInGroup(tGroup)) {
            Token token2 = this.curToken.eType;
            this.nextToken();
            if (token2 == Token.FROM) {
                string4 = "{" + this.relation(f, token) + "}";
                continue;
            }
            if (token2 == Token.TO) {
                string5 = "{" + this.relation(f, token) + "}";
                continue;
            }
            if (token2 == Token.LSUB) {
                string2 = this.term(f, token, true);
                continue;
            }
            if (token2 == Token.LSUP) {
                string3 = this.term(f, token, true);
                continue;
            }
            if (token2 == Token.CSUB) {
                string4 = this.term(f, token, true);
                continue;
            }
            if (token2 == Token.CSUP) {
                string5 = this.term(f, token, true);
                continue;
            }
            if (token2 == Token.RSUB) {
                string6 = this.term(f, token, true);
                continue;
            }
            if (token2 != Token.RSUP) continue;
            string7 = this.term(f, token, true);
        }
        if (string2 == null && string3 == null && string4 == null && string5 == null && string6 == null && string7 == null) {
            return string;
        }
        if (tGroup == TGroup.LIMIT) {
            if (string2 == null && string3 == null && string6 == null && string7 == null) {
                return string + this.tosub(string4) + this.tosup(string5);
            }
            return "\\sideset{" + this.tosub(string2) + this.tosup(string3) + "}{" + this.tosub(string6) + this.tosup(string7) + "}" + string + "\\limits" + this.tosub(string4) + this.tosup(string5);
        }
        if (string2 == null && string3 == null && string4 == null && string5 == null) {
            return string + this.tosub(string6) + this.tosup(string7);
        }
        if (string2 == null && string3 == null && string6 == null && string7 == null) {
            if (string4 == null) {
                return "\\overset" + string5 + "{" + string + "}";
            }
            if (string5 == null) {
                return "\\underset" + string4 + "{" + string + "}";
            }
            return "\\overset" + string5 + "{\\underset" + string4 + "{" + string + "}}";
        }
        this.bMultiscripts = true;
        if (string4 == null) {
            string4 = "{}";
        }
        if (string5 == null) {
            string5 = "{}";
        }
        return "\\multiscripts{" + this.tosub(string2) + this.tosup(string3) + "}" + string4 + string5 + "{" + string + "}{" + this.tosub(string6) + this.tosup(string7) + "}";
    }

    private String opsubsup(float f, Token token) {
        String string = this.curToken.sLaTeX;
        this.nextToken();
        return this.subsup(f, token, string, TGroup.POWER);
    }

    private String power(float f, Token token, boolean bl) {
        boolean bl2 = this.curToken.eType == Token.LGROUP;
        String string = this.term(f, token);
        if (bl && (!bl2 || this.tokenInGroup(TGroup.POWER))) {
            return "{" + this.subsup(f, token, string, TGroup.POWER) + "}";
        }
        return this.subsup(f, token, string, TGroup.POWER);
    }

    private String blank() {
        StringBuffer stringBuffer = new StringBuffer();
        while (this.tokenInGroup(TGroup.BLANK)) {
            stringBuffer.append(this.curToken.sLaTeX);
            this.nextToken();
        }
        return stringBuffer.toString();
    }

    private String term(float f, Token token, boolean bl) {
        if (bl && this.curToken.eType != Token.LGROUP) {
            return "{" + this.term(f, token) + "}";
        }
        return this.term(f, token);
    }

    private String term(float f, Token token) {
        if (this.curToken.eType == Token.ESCAPE) {
            return this.escape();
        }
        if (this.curToken.eType == Token.LGROUP) {
            this.nextToken();
            String string = this.curToken.eType != Token.RGROUP ? this.align(f, token, false, false) : "";
            if (this.curToken.eType == Token.RGROUP) {
                this.nextToken();
            }
            return "{" + string + "}";
        }
        if (this.curToken.eType == Token.LEFT) {
            return this.scalebrace(f, token);
        }
        if (this.tokenInGroup(TGroup.BLANK)) {
            return this.blank();
        }
        if (this.curToken.eType == Token.TEXT) {
            String string = this.curToken.sLaTeX;
            this.nextToken();
            return "\\text{" + string + "}";
        }
        if (this.curToken.eType == Token.CHARACTER || this.curToken.eType == Token.NUMBER || this.tokenInGroup(TGroup.STANDALONE)) {
            if (this.curToken.eType == Token.LAMBDABAR) {
                this.bLambdabar = true;
            }
            if (this.curToken.eType == Token.DOTSUP) {
                this.bDdotsup = true;
            }
            String string = this.curToken.sLaTeX;
            this.nextToken();
            return string;
        }
        if (this.curToken.eType == Token.IDENT) {
            String string = this.curToken.sLaTeX;
            this.nextToken();
            return string.length() > 1 ? "\\mathit{" + string + "}" : string;
        }
        if (this.curToken.eType == Token.SPECIAL) {
            return this.special();
        }
        if (this.curToken.eType == Token.BINOM) {
            return this.binom(f, token);
        }
        if (this.curToken.eType == Token.STACK) {
            return this.stack(f, token);
        }
        if (this.curToken.eType == Token.MATRIX) {
            return this.matrix(f, token);
        }
        if (this.tokenInGroup(TGroup.LBRACES)) {
            return this.brace(f, token);
        }
        if (this.tokenInGroup(TGroup.OPER)) {
            return this.operator(f, token);
        }
        if (this.tokenInGroup(TGroup.UNOPER)) {
            return this.unoper(f, token);
        }
        if (this.tokenInGroup(TGroup.ATTRIBUT) || this.tokenInGroup(TGroup.FONTATTR)) {
            return this.attributes(f, token);
        }
        if (this.tokenInGroup(TGroup.FUNCTION)) {
            return this.function();
        }
        this.nextToken();
        return "?";
    }

    private String escape() {
        String string;
        this.nextToken();
        if ((this.tokenInGroup(TGroup.LBRACES) || this.tokenInGroup(TGroup.RBRACES)) && this.curToken.eType != Token.NONE) {
            string = this.curToken.sLaTeX;
            this.nextToken();
        } else if (this.curToken.eType == Token.LGROUP) {
            string = "\\{";
            this.nextToken();
        } else if (this.curToken.eType == Token.RGROUP) {
            string = "\\}";
            this.nextToken();
        } else {
            string = "";
        }
        return string;
    }

    private String operator(float f, Token token) {
        String string = this.oper();
        if (this.tokenInGroup(TGroup.LIMIT) || this.tokenInGroup(TGroup.POWER)) {
            return this.subsup(f, token, string, this.curToken.eGroup1) + this.power(f, token, false);
        }
        return string + this.power(f, token, false);
    }

    private String oper() {
        String string;
        if (this.curToken.eType == Token.LLINT) {
            this.bOiint = true;
        } else if (this.curToken.eType == Token.LLLINT) {
            this.bOiiint = true;
        }
        if (this.curToken.eType == Token.OPER) {
            this.nextToken();
            string = this.curToken.eType == Token.SPECIAL ? "\\operatornamewithlimits{" + this.curToken.sLaTeX + "}" : "\\operatornamewithlimits{?}";
        } else {
            string = this.curToken.sLaTeX;
        }
        this.nextToken();
        return string;
    }

    private String unoper(float f, Token token) {
        if (this.curToken.eType == Token.ABS) {
            this.nextToken();
            return "\\left|" + this.power(f, token, false) + "\\right|";
        }
        if (this.curToken.eType == Token.SQRT) {
            this.nextToken();
            return "\\sqrt" + this.power(f, token, true);
        }
        if (this.curToken.eType == Token.NROOT) {
            this.nextToken();
            return "\\sqrt[" + this.power(f, token, false) + "]" + this.power(f, token, true);
        }
        if (this.curToken.eType == Token.UOPER) {
            this.nextToken();
            return this.special() + this.power(f, token, false);
        }
        if (this.curToken.eType == Token.FACT) {
            String string = this.opsubsup(f, token);
            return this.power(f, token, false) + string;
        }
        return this.opsubsup(f, token) + this.power(f, token, false);
    }

    private String attributes(float f, Token token) {
        if (this.curToken.eType == Token.FONT) {
            this.nextToken();
            if (this.tokenInGroup(TGroup.FONT)) {
                String string = this.curToken.sLaTeX;
                this.nextToken();
                return string + "{" + this.term(f, token) + "}";
            }
            return "?";
        }
        if (this.curToken.eType == Token.COLOR) {
            this.nextToken();
            if (this.tokenInGroup(TGroup.COLOR)) {
                String string = this.curToken.sLaTeX;
                this.nextToken();
                if (this.bUseColor) {
                    return "\\textcolor{" + string + "}{" + this.term(f, token) + "}";
                }
                return this.term(f, token);
            }
            return "?";
        }
        if (this.curToken.eType == Token.SIZE) {
            this.nextToken();
            if (this.curToken.eType == Token.PLUS) {
                this.nextToken();
                if (this.curToken.eType == Token.NUMBER) {
                    f += Misc.getFloat(this.curToken.sLaTeX, 0.0f);
                    this.nextToken();
                }
            } else if (this.curToken.eType == Token.MINUS) {
                this.nextToken();
                if (this.curToken.eType == Token.NUMBER) {
                    f -= Misc.getFloat(this.curToken.sLaTeX, 0.0f);
                    this.nextToken();
                }
            } else if (this.curToken.eType == Token.MULTIPLY) {
                this.nextToken();
                if (this.curToken.eType == Token.NUMBER) {
                    f *= Misc.getFloat(this.curToken.sLaTeX, 1.0f);
                    this.nextToken();
                }
            } else if (this.curToken.eType == Token.DIVIDEBY) {
                this.nextToken();
                if (this.curToken.eType == Token.NUMBER) {
                    float f2 = Misc.getFloat(this.curToken.sLaTeX, 1.0f);
                    if (f2 != 0.0f) {
                        f /= f2;
                    }
                    this.nextToken();
                }
            } else if (this.curToken.eType == Token.NUMBER) {
                f = Misc.getFloat(this.curToken.sLaTeX, f);
                this.nextToken();
            }
            return this.term(f, token);
        }
        if (this.curToken.eType == Token.OVERSTRIKE) {
            this.bMathoverstrike = true;
        } else if (this.curToken.eType == Token.BOLD) {
            this.bBoldsubformula = true;
        } else if (this.curToken.eType == Token.NBOLD) {
            this.bNormalsubformula = true;
        }
        String string = this.curToken.sLaTeX;
        this.nextToken();
        return string + "{" + this.term(f, token) + "}";
    }

    private String scalebrace(float f, Token token) {
        this.nextToken();
        if (this.tokenInGroup(TGroup.LBRACES) || this.tokenInGroup(TGroup.RBRACES)) {
            String string;
            if (this.curToken.eType == Token.LDBRACKET) {
                this.bLlbracket = true;
            } else if (this.curToken.eType == Token.RDBRACKET) {
                this.bRrbracket = true;
            }
            String string2 = new String(this.curToken.sLaTeX);
            this.nextToken();
            String string3 = this.scalebracebody(f, token);
            if (this.curToken.eType == Token.RIGHT) {
                this.nextToken();
                if (this.tokenInGroup(TGroup.LBRACES) || this.tokenInGroup(TGroup.RBRACES)) {
                    if (this.curToken.eType == Token.LDBRACKET) {
                        this.bLlbracket = true;
                    } else if (this.curToken.eType == Token.RDBRACKET) {
                        this.bRrbracket = true;
                    }
                    string = new String(this.curToken.sLaTeX);
                    this.nextToken();
                } else {
                    string = ".";
                }
            } else {
                return ".";
            }
            return "\\left" + string2 + string3 + "\\right" + string;
        }
        return "?";
    }

    private String brace(float f, Token token) {
        if (this.curToken.eType == Token.LDBRACKET) {
            this.bLlbracket = true;
        }
        String string = new String(this.curToken.sLaTeX);
        this.nextToken();
        String string2 = this.bracebody(f, token);
        if (this.tokenInGroup(TGroup.RBRACES)) {
            if (this.curToken.eType == Token.RDBRACKET) {
                this.bRrbracket = true;
            }
            String string3 = new String(this.curToken.sLaTeX);
            this.nextToken();
            return string + string2 + string3;
        }
        return string + string2;
    }

    private String scalebracebody(float f, Token token) {
        if (this.curToken.eType == Token.MLINE) {
            this.nextToken();
            return "\\left|" + this.scalebracebody(f, token) + "\\right.";
        }
        if (this.curToken.eType != Token.RIGHT && this.curToken.eType != Token.END) {
            return this.align(f, token, false, false) + this.scalebracebody(f, token);
        }
        return "";
    }

    private String bracebody(float f, Token token) {
        if (this.curToken.eType == Token.MLINE) {
            this.nextToken();
            return "|" + this.bracebody(f, token);
        }
        if (!this.tokenInGroup(TGroup.RBRACES) && this.curToken.eType != Token.END) {
            return this.align(f, token, false, false) + this.bracebody(f, token);
        }
        return "";
    }

    private String function() {
        String string;
        if (this.curToken.eType == Token.FUNC) {
            this.nextToken();
            if (this.curToken.eType == Token.IDENT) {
                string = "\\operatorname{" + this.curToken.sLaTeX + "}";
                this.nextToken();
            } else {
                string = "";
            }
        } else {
            string = this.curToken.sLaTeX;
            this.nextToken();
        }
        return string;
    }

    private String binom(float f, Token token) {
        this.nextToken();
        return "\\genfrac{}{}{0pt}{0}{" + this.sum(f, token) + "}{" + this.sum(f, token) + "}";
    }

    private String stack(float f, Token token) {
        this.nextToken();
        if (this.curToken.eType == Token.LGROUP) {
            StringBuffer stringBuffer = new StringBuffer().append("\\begin{matrix}");
            do {
                this.nextToken();
                stringBuffer.append(this.align(f, token, true, true));
                if (this.curToken.eType != Token.POUND) continue;
                stringBuffer.append("\\\\");
            } while (this.curToken.eType == Token.POUND);
            if (this.curToken.eType == Token.RGROUP) {
                this.nextToken();
            }
            return stringBuffer.append("\\end{matrix}").toString();
        }
        return "";
    }

    private String matrix(float f, Token token) {
        this.nextToken();
        if (this.curToken.eType == Token.LGROUP) {
            StringBuffer stringBuffer = new StringBuffer().append("\\begin{matrix}");
            do {
                this.nextToken();
                stringBuffer.append(this.align(f, token, true, true));
                if (this.curToken.eType == Token.POUND) {
                    stringBuffer.append("&");
                    continue;
                }
                if (this.curToken.eType != Token.DPOUND) continue;
                stringBuffer.append("\\\\");
            } while (this.curToken.eType == Token.POUND || this.curToken.eType == Token.DPOUND);
            if (this.curToken.eType == Token.RGROUP) {
                this.nextToken();
            }
            return stringBuffer.append("\\end{matrix}").toString();
        }
        return "";
    }

    private String special() {
        String string = this.curToken.sLaTeX;
        this.nextToken();
        return string;
    }

    public String convert(String string) {
        String string2 = "";
        this.buffer = new SimpleInputBuffer(string);
        this.nextToken();
        string2 = this.table(12.0f, Token.ALIGNC);
        return string2.length() == 0 ? " " : string2;
    }
}

