#!/usr/bin/env bash
## Test for inherit-default mechanism

. lib
rm -rf U V R1 R2 R3 S

echo 'ALL inherit-default' >> .darcs/defaults

# upstream repos
darcs init U
darcs init V

# branches of U
darcs clone U R1
darcs clone R1 R2
darcs clone R2 R3

# branches of V
darcs clone V S

not test -e U/_darcs/prefs/defaultrepo
not test -e V/_darcs/prefs/defaultrepo
grep '/U$' R1/_darcs/prefs/defaultrepo
grep '/U$' R2/_darcs/prefs/defaultrepo
grep '/U$' R3/_darcs/prefs/defaultrepo
grep '/V$' S/_darcs/prefs/defaultrepo

cd R3
for cmd in pull push send; do
  # set-default works by setting the defaultrepo of the remote repo
  darcs $cmd ../S --set-default
  grep '/V$' _darcs/prefs/defaultrepo
  # but not if remote repo has no defaultrepo
  darcs $cmd ../U --set-default
  grep '/U$' _darcs/prefs/defaultrepo
done
cd ..
