# coding: utf-8

"""
    Debian Code Search

    OpenAPI for https://codesearch.debian.net/  # noqa: E501

    OpenAPI spec version: 1.4.0
    Contact: stapelberg@debian.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from debian_codesearch_client.swagger_client.configuration import Configuration


class PackageSearchResult(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {"package": "str", "results": "list[SearchResult]"}

    attribute_map = {"package": "package", "results": "results"}

    def __init__(self, package=None, results=None, _configuration=None):  # noqa: E501
        """PackageSearchResult - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._package = None
        self._results = None
        self.discriminator = None

        self.package = package
        self.results = results

    @property
    def package(self):
        """Gets the package of this PackageSearchResult.  # noqa: E501

        The Debian source package for which up to 2 search results have been aggregated in `results`.  # noqa: E501

        :return: The package of this PackageSearchResult.  # noqa: E501
        :rtype: str
        """
        return self._package

    @package.setter
    def package(self, package):
        """Sets the package of this PackageSearchResult.

        The Debian source package for which up to 2 search results have been aggregated in `results`.  # noqa: E501

        :param package: The package of this PackageSearchResult.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and package is None:
            raise ValueError(
                "Invalid value for `package`, must not be `None`"
            )  # noqa: E501

        self._package = package

    @property
    def results(self):
        """Gets the results of this PackageSearchResult.  # noqa: E501


        :return: The results of this PackageSearchResult.  # noqa: E501
        :rtype: list[SearchResult]
        """
        return self._results

    @results.setter
    def results(self, results):
        """Sets the results of this PackageSearchResult.


        :param results: The results of this PackageSearchResult.  # noqa: E501
        :type: list[SearchResult]
        """
        if self._configuration.client_side_validation and results is None:
            raise ValueError(
                "Invalid value for `results`, must not be `None`"
            )  # noqa: E501

        self._results = results

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (
                            (item[0], item[1].to_dict())
                            if hasattr(item[1], "to_dict")
                            else item
                        ),
                        value.items(),
                    )
                )
            else:
                result[attr] = value
        if issubclass(PackageSearchResult, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PackageSearchResult):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PackageSearchResult):
            return True

        return self.to_dict() != other.to_dict()
