
#line 1 "src/http11/http11_parser.rl"
/**
 *
 * Copyright (c) 2010, Zed A. Shaw and Mongrel2 Project Contributors.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 * 
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 * 
 *     * Neither the name of the Mongrel2 Project, Zed A. Shaw, nor the names
 *       of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written
 *       permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 * IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "http11_parser.h"
#include <stdio.h>
#include <assert.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <dbg.h>

#define LEN(AT, FPC) (FPC - buffer - parser->AT)
#define MARK(M,FPC) (parser->M = (FPC) - buffer)
#define PTR_TO(F) (buffer + parser->F)

/** Machine **/


#line 255 "src/http11/http11_parser.rl"


/** Data **/

#line 58 "src/http11/http11_parser.c"
static const char _http_parser_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 7, 1, 
	8, 1, 10, 1, 11, 1, 12, 2, 
	0, 7, 2, 0, 11, 2, 1, 12, 
	2, 3, 4, 2, 9, 6, 2, 11, 
	6, 2, 13, 12, 2, 14, 12, 3, 
	0, 11, 6, 3, 8, 9, 6
};

static const char _http_parser_cond_offsets[] = {
	0, 0, 0, 0, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 6, 9, 12, 12, 
	12, 12, 12, 15, 15, 15, 18, 21, 
	21, 21, 24, 27, 30, 30, 30, 33, 
	36, 36, 36, 39, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 45, 48, 51, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 57, 
	57, 57, 57, 60, 60, 60, 63, 63, 
	63, 66, 69, 72, 72, 72, 75, 78, 
	78, 78, 81, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 87, 90, 90
};

static const char _http_parser_cond_lengths[] = {
	0, 0, 0, 3, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 3, 3, 3, 0, 0, 
	0, 0, 3, 0, 0, 3, 3, 0, 
	0, 3, 3, 3, 0, 0, 3, 3, 
	0, 0, 3, 3, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 3, 3, 3, 3, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 3, 0, 
	0, 0, 3, 0, 0, 3, 0, 0, 
	3, 3, 3, 0, 0, 3, 3, 0, 
	0, 3, 3, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 3, 3, 0, 0
};

static const short _http_parser_cond_keys[] = {
	94, 94, 123, 123, 125, 125, 94, 94, 
	123, 123, 125, 125, 94, 94, 123, 123, 
	125, 125, 94, 94, 123, 123, 125, 125, 
	94, 94, 123, 123, 125, 125, 94, 94, 
	123, 123, 125, 125, 94, 94, 123, 123, 
	125, 125, 94, 94, 123, 123, 125, 125, 
	94, 94, 123, 123, 125, 125, 94, 94, 
	123, 123, 125, 125, 94, 94, 123, 123, 
	125, 125, 94, 94, 123, 123, 125, 125, 
	94, 94, 123, 123, 125, 125, 94, 94, 
	123, 123, 125, 125, 94, 94, 123, 123, 
	125, 125, 94, 94, 123, 123, 125, 125, 
	94, 94, 123, 123, 125, 125, 94, 94, 
	123, 123, 125, 125, 94, 94, 123, 123, 
	125, 125, 94, 94, 123, 123, 125, 125, 
	94, 94, 123, 123, 125, 125, 94, 94, 
	123, 123, 125, 125, 94, 94, 123, 123, 
	125, 125, 94, 94, 123, 123, 125, 125, 
	94, 94, 123, 123, 125, 125, 94, 94, 
	123, 123, 125, 125, 94, 94, 123, 123, 
	125, 125, 94, 94, 123, 123, 125, 125, 
	94, 94, 123, 123, 125, 125, 94, 94, 
	123, 123, 125, 125, 0
};

static const char _http_parser_cond_spaces[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0
};

static const short _http_parser_key_offsets[] = {
	0, 0, 6, 11, 31, 32, 33, 34, 
	35, 36, 37, 38, 40, 42, 63, 83, 
	89, 93, 94, 115, 134, 149, 164, 170, 
	176, 182, 188, 205, 211, 217, 233, 249, 
	255, 261, 279, 300, 320, 326, 332, 355, 
	372, 378, 384, 404, 423, 429, 435, 441, 
	450, 456, 463, 470, 477, 478, 486, 494, 
	498, 499, 503, 504, 508, 509, 514, 517, 
	520, 523, 525, 526, 529, 532, 535, 537, 
	538, 541, 544, 547, 549, 550, 557, 564, 
	565, 571, 578, 585, 592, 600, 608, 616, 
	626, 633, 641, 648, 655, 662, 669, 670, 
	677, 684, 691, 698, 699, 706, 713, 720, 
	727, 728, 735, 742, 749, 756, 757, 764, 
	771, 778, 785, 786, 793, 800, 807, 814, 
	815, 822, 829, 836, 843, 844, 851, 862, 
	871, 879, 887, 889, 897, 906, 914, 922, 
	924, 933, 942, 951, 962, 970, 979, 987, 
	996, 1005, 1014, 1025, 1033, 1042, 1050, 1060, 
	1070, 1078, 1085, 1092, 1093, 1101, 1109, 1117, 
	1127, 1134, 1142, 1149, 1157, 1159, 1160, 1161, 
	1162, 1173, 1179, 1186, 1202, 1219, 1243, 1261, 
	1266, 1271, 1276, 1281, 1286, 1291, 1296, 1301, 
	1306, 1311, 1316, 1321, 1326, 1331, 1336, 1341, 
	1346, 1351, 1352, 1360, 1371, 1372, 1374, 1391, 
	1392, 1393, 1395, 1412, 1418, 1424, 1439, 1445, 
	1451, 1467, 1486, 1504, 1510, 1516, 1537, 1554, 
	1560, 1566, 1584, 1601, 1607, 1613, 1617, 1626, 
	1632, 1639, 1646, 1653, 1654, 1662, 1670, 1674, 
	1675, 1679, 1680, 1684, 1685, 1688, 1691, 1694, 
	1697, 1699, 1700, 1703, 1706, 1709, 1711, 1712, 
	1715, 1718, 1721, 1723, 1724, 1731, 1738, 1739, 
	1745, 1752, 1759, 1766, 1774, 1782, 1790, 1800, 
	1807, 1815, 1822, 1829, 1836, 1843, 1844, 1851, 
	1858, 1865, 1872, 1873, 1880, 1887, 1894, 1901, 
	1902, 1909, 1916, 1923, 1930, 1931, 1938, 1945, 
	1952, 1959, 1960, 1967, 1974, 1981, 1988, 1989, 
	1996, 2003, 2010, 2017, 2018, 2025, 2036, 2045, 
	2053, 2061, 2063, 2071, 2080, 2088, 2096, 2098, 
	2107, 2116, 2125, 2136, 2144, 2153, 2161, 2170, 
	2179, 2188, 2199, 2207, 2216, 2224, 2234, 2244, 
	2252, 2259, 2266, 2267, 2275, 2283, 2291, 2301, 
	2308, 2316, 2323, 2331, 2333, 2334, 2335, 2336, 
	2347, 2353, 2360, 2376, 2393, 2413
};

static const short _http_parser_trans_keys[] = {
	60, 64, 48, 57, 65, 90, 32, 48, 
	57, 65, 90, 32, 33, 35, 37, 47, 
	59, 61, 63, 64, 95, 126, 606, 635, 
	637, 36, 57, 65, 90, 97, 122, 72, 
	84, 84, 80, 47, 49, 46, 48, 49, 
	10, 13, 10, 13, 33, 124, 126, 1, 
	8, 11, 31, 35, 39, 42, 43, 45, 
	46, 48, 57, 65, 90, 94, 122, 33, 
	58, 124, 126, 1, 8, 10, 31, 35, 
	39, 42, 43, 45, 46, 48, 57, 65, 
	90, 94, 122, 0, 9, 10, 13, 32, 
	127, 0, 10, 13, 127, 10, 10, 33, 
	58, 124, 126, 1, 8, 11, 31, 35, 
	39, 42, 43, 45, 46, 48, 57, 65, 
	90, 94, 122, 32, 33, 35, 37, 47, 
	59, 61, 63, 95, 126, 606, 635, 637, 
	36, 57, 64, 90, 97, 122, 32, 33, 
	37, 61, 95, 126, 606, 635, 637, 36, 
	59, 63, 90, 97, 122, 32, 33, 37, 
	61, 95, 126, 606, 635, 637, 36, 59, 
	63, 90, 97, 122, 48, 57, 65, 70, 
	97, 102, 48, 57, 65, 70, 97, 102, 
	48, 57, 65, 70, 97, 102, 48, 57, 
	65, 70, 97, 102, 32, 33, 35, 37, 
	61, 63, 95, 126, 606, 635, 637, 36, 
	59, 64, 90, 97, 122, 48, 57, 65, 
	70, 97, 102, 48, 57, 65, 70, 97, 
	102, 32, 33, 35, 37, 61, 95, 126, 
	606, 635, 637, 36, 59, 63, 90, 97, 
	122, 32, 33, 35, 37, 61, 95, 126, 
	606, 635, 637, 36, 59, 63, 90, 97, 
	122, 48, 57, 65, 70, 97, 102, 48, 
	57, 65, 70, 97, 102, 32, 33, 35, 
	37, 47, 61, 63, 95, 126, 606, 635, 
	637, 36, 59, 64, 90, 97, 122, 32, 
	33, 35, 37, 47, 58, 61, 63, 64, 
	91, 95, 126, 606, 635, 637, 36, 59, 
	65, 90, 97, 122, 32, 33, 35, 37, 
	47, 58, 61, 63, 64, 95, 126, 606, 
	635, 637, 36, 59, 65, 90, 97, 122, 
	48, 57, 65, 70, 97, 102, 48, 57, 
	65, 70, 97, 102, 32, 33, 35, 37, 
	47, 61, 63, 64, 95, 126, 606, 635, 
	637, 36, 46, 48, 57, 58, 59, 65, 
	90, 97, 122, 33, 37, 61, 64, 95, 
	126, 606, 635, 637, 36, 46, 48, 59, 
	65, 90, 97, 122, 48, 57, 65, 70, 
	97, 102, 48, 57, 65, 70, 97, 102, 
	32, 33, 35, 37, 47, 58, 61, 63, 
	91, 95, 126, 606, 635, 637, 36, 59, 
	65, 90, 97, 122, 32, 33, 35, 37, 
	47, 58, 61, 63, 95, 126, 606, 635, 
	637, 36, 59, 65, 90, 97, 122, 48, 
	57, 65, 70, 97, 102, 48, 57, 65, 
	70, 97, 102, 32, 35, 47, 63, 48, 
	57, 6, 58, 118, 48, 57, 65, 70, 
	97, 102, 48, 57, 65, 70, 97, 102, 
	58, 48, 57, 65, 70, 97, 102, 58, 
	48, 57, 65, 70, 97, 102, 58, 48, 
	57, 65, 70, 97, 102, 58, 49, 50, 
	48, 57, 65, 70, 97, 102, 46, 58, 
	48, 57, 65, 70, 97, 102, 49, 50, 
	48, 57, 46, 49, 50, 48, 57, 46, 
	49, 50, 48, 57, 93, 32, 35, 47, 
	58, 63, 93, 48, 57, 93, 48, 57, 
	48, 53, 93, 48, 57, 48, 46, 48, 
	57, 46, 48, 57, 46, 48, 53, 48, 
	57, 48, 46, 48, 57, 46, 48, 57, 
	46, 48, 53, 48, 57, 48, 58, 48, 
	57, 65, 70, 97, 102, 58, 48, 57, 
	65, 70, 97, 102, 58, 48, 57, 65, 
	70, 97, 102, 93, 48, 57, 65, 70, 
	97, 102, 93, 48, 57, 65, 70, 97, 
	102, 93, 48, 57, 65, 70, 97, 102, 
	46, 58, 48, 57, 65, 70, 97, 102, 
	46, 58, 48, 57, 65, 70, 97, 102, 
	46, 58, 48, 57, 65, 70, 97, 102, 
	46, 48, 53, 58, 49, 57, 65, 70, 
	97, 102, 58, 48, 57, 65, 70, 97, 
	102, 48, 58, 49, 57, 65, 70, 97, 
	102, 58, 48, 57, 65, 70, 97, 102, 
	58, 48, 57, 65, 70, 97, 102, 58, 
	48, 57, 65, 70, 97, 102, 58, 48, 
	57, 65, 70, 97, 102, 58, 58, 48, 
	57, 65, 70, 97, 102, 58, 48, 57, 
	65, 70, 97, 102, 58, 48, 57, 65, 
	70, 97, 102, 58, 48, 57, 65, 70, 
	97, 102, 58, 58, 48, 57, 65, 70, 
	97, 102, 58, 48, 57, 65, 70, 97, 
	102, 58, 48, 57, 65, 70, 97, 102, 
	58, 48, 57, 65, 70, 97, 102, 58, 
	58, 48, 57, 65, 70, 97, 102, 58, 
	48, 57, 65, 70, 97, 102, 58, 48, 
	57, 65, 70, 97, 102, 58, 48, 57, 
	65, 70, 97, 102, 58, 58, 48, 57, 
	65, 70, 97, 102, 58, 48, 57, 65, 
	70, 97, 102, 58, 48, 57, 65, 70, 
	97, 102, 58, 48, 57, 65, 70, 97, 
	102, 58, 58, 48, 57, 65, 70, 97, 
	102, 58, 48, 57, 65, 70, 97, 102, 
	58, 48, 57, 65, 70, 97, 102, 58, 
	48, 57, 65, 70, 97, 102, 58, 58, 
	48, 57, 65, 70, 97, 102, 58, 48, 
	57, 65, 70, 97, 102, 58, 48, 57, 
	65, 70, 97, 102, 58, 48, 57, 65, 
	70, 97, 102, 58, 58, 48, 57, 65, 
	70, 97, 102, 49, 50, 93, 2, 3, 
	48, 57, 65, 70, 97, 102, 46, 58, 
	93, 48, 57, 65, 70, 97, 102, 58, 
	93, 48, 57, 65, 70, 97, 102, 58, 
	93, 48, 57, 65, 70, 97, 102, 58, 
	93, 49, 50, 48, 57, 65, 70, 97, 
	102, 46, 58, 93, 48, 57, 65, 70, 
	97, 102, 58, 93, 48, 57, 65, 70, 
	97, 102, 58, 93, 48, 57, 65, 70, 
	97, 102, 58, 93, 46, 58, 93, 48, 
	57, 65, 70, 97, 102, 46, 58, 93, 
	48, 57, 65, 70, 97, 102, 46, 58, 
	93, 48, 57, 65, 70, 97, 102, 46, 
	48, 53, 58, 93, 49, 57, 65, 70, 
	97, 102, 58, 93, 48, 57, 65, 70, 
	97, 102, 48, 58, 93, 49, 57, 65, 
	70, 97, 102, 58, 93, 48, 57, 65, 
	70, 97, 102, 46, 58, 93, 48, 57, 
	65, 70, 97, 102, 46, 58, 93, 48, 
	57, 65, 70, 97, 102, 46, 58, 93, 
	48, 57, 65, 70, 97, 102, 46, 48, 
	53, 58, 93, 49, 57, 65, 70, 97, 
	102, 58, 93, 48, 57, 65, 70, 97, 
	102, 48, 58, 93, 49, 57, 65, 70, 
	97, 102, 58, 93, 48, 57, 65, 70, 
	97, 102, 49, 50, 2, 3, 48, 57, 
	65, 70, 97, 102, 49, 50, 2, 3, 
	48, 57, 65, 70, 97, 102, 46, 58, 
	48, 57, 65, 70, 97, 102, 58, 48, 
	57, 65, 70, 97, 102, 58, 48, 57, 
	65, 70, 97, 102, 58, 46, 58, 48, 
	57, 65, 70, 97, 102, 46, 58, 48, 
	57, 65, 70, 97, 102, 46, 58, 48, 
	57, 65, 70, 97, 102, 46, 48, 53, 
	58, 49, 57, 65, 70, 97, 102, 58, 
	48, 57, 65, 70, 97, 102, 48, 58, 
	49, 57, 65, 70, 97, 102, 58, 48, 
	57, 65, 70, 97, 102, 2, 3, 48, 
	57, 65, 70, 97, 102, 2, 3, 3, 
	4, 58, 49, 50, 93, 2, 5, 48, 
	57, 65, 70, 97, 102, 48, 57, 65, 
	70, 97, 102, 46, 48, 57, 65, 70, 
	97, 102, 33, 36, 61, 95, 126, 606, 
	635, 637, 38, 46, 48, 59, 65, 90, 
	97, 122, 33, 36, 61, 93, 95, 126, 
	606, 635, 637, 38, 46, 48, 59, 65, 
	90, 97, 122, 32, 33, 35, 37, 43, 
	47, 58, 59, 61, 63, 64, 95, 126, 
	606, 635, 637, 36, 44, 45, 57, 65, 
	90, 97, 122, 32, 33, 35, 37, 47, 
	61, 63, 95, 126, 606, 635, 637, 36, 
	59, 64, 90, 97, 122, 32, 48, 57, 
	65, 90, 32, 48, 57, 65, 90, 32, 
	48, 57, 65, 90, 32, 48, 57, 65, 
	90, 32, 48, 57, 65, 90, 32, 48, 
	57, 65, 90, 32, 48, 57, 65, 90, 
	32, 48, 57, 65, 90, 32, 48, 57, 
	65, 90, 32, 48, 57, 65, 90, 32, 
	48, 57, 65, 90, 32, 48, 57, 65, 
	90, 32, 48, 57, 65, 90, 32, 48, 
	57, 65, 90, 32, 48, 57, 65, 90, 
	32, 48, 57, 65, 90, 32, 48, 57, 
	65, 90, 32, 48, 57, 65, 90, 32, 
	45, 46, 48, 57, 65, 90, 97, 122, 
	32, 47, 62, 9, 13, 45, 57, 65, 
	90, 97, 122, 62, 0, 62, 32, 33, 
	37, 47, 59, 61, 95, 126, 606, 635, 
	637, 36, 57, 64, 90, 97, 122, 123, 
	125, 0, 125, 32, 33, 37, 47, 59, 
	61, 95, 126, 606, 635, 637, 36, 57, 
	64, 90, 97, 122, 48, 57, 65, 70, 
	97, 102, 48, 57, 65, 70, 97, 102, 
	32, 33, 37, 61, 95, 126, 606, 635, 
	637, 36, 59, 64, 90, 97, 122, 48, 
	57, 65, 70, 97, 102, 48, 57, 65, 
	70, 97, 102, 32, 33, 37, 47, 61, 
	95, 126, 606, 635, 637, 36, 59, 64, 
	90, 97, 122, 32, 33, 37, 47, 58, 
	61, 64, 91, 95, 126, 606, 635, 637, 
	36, 59, 65, 90, 97, 122, 32, 33, 
	37, 47, 58, 61, 64, 95, 126, 606, 
	635, 637, 36, 59, 65, 90, 97, 122, 
	48, 57, 65, 70, 97, 102, 48, 57, 
	65, 70, 97, 102, 32, 33, 37, 47, 
	61, 64, 95, 126, 606, 635, 637, 36, 
	46, 48, 57, 58, 59, 65, 90, 97, 
	122, 33, 37, 61, 64, 95, 126, 606, 
	635, 637, 36, 46, 48, 59, 65, 90, 
	97, 122, 48, 57, 65, 70, 97, 102, 
	48, 57, 65, 70, 97, 102, 32, 33, 
	37, 47, 58, 61, 91, 95, 126, 606, 
	635, 637, 36, 59, 65, 90, 97, 122, 
	32, 33, 37, 47, 58, 61, 95, 126, 
	606, 635, 637, 36, 59, 65, 90, 97, 
	122, 48, 57, 65, 70, 97, 102, 48, 
	57, 65, 70, 97, 102, 32, 47, 48, 
	57, 6, 58, 118, 48, 57, 65, 70, 
	97, 102, 48, 57, 65, 70, 97, 102, 
	58, 48, 57, 65, 70, 97, 102, 58, 
	48, 57, 65, 70, 97, 102, 58, 48, 
	57, 65, 70, 97, 102, 58, 49, 50, 
	48, 57, 65, 70, 97, 102, 46, 58, 
	48, 57, 65, 70, 97, 102, 49, 50, 
	48, 57, 46, 49, 50, 48, 57, 46, 
	49, 50, 48, 57, 93, 32, 47, 58, 
	93, 48, 57, 93, 48, 57, 48, 53, 
	93, 48, 57, 48, 46, 48, 57, 46, 
	48, 57, 46, 48, 53, 48, 57, 48, 
	46, 48, 57, 46, 48, 57, 46, 48, 
	53, 48, 57, 48, 58, 48, 57, 65, 
	70, 97, 102, 58, 48, 57, 65, 70, 
	97, 102, 58, 48, 57, 65, 70, 97, 
	102, 93, 48, 57, 65, 70, 97, 102, 
	93, 48, 57, 65, 70, 97, 102, 93, 
	48, 57, 65, 70, 97, 102, 46, 58, 
	48, 57, 65, 70, 97, 102, 46, 58, 
	48, 57, 65, 70, 97, 102, 46, 58, 
	48, 57, 65, 70, 97, 102, 46, 48, 
	53, 58, 49, 57, 65, 70, 97, 102, 
	58, 48, 57, 65, 70, 97, 102, 48, 
	58, 49, 57, 65, 70, 97, 102, 58, 
	48, 57, 65, 70, 97, 102, 58, 48, 
	57, 65, 70, 97, 102, 58, 48, 57, 
	65, 70, 97, 102, 58, 48, 57, 65, 
	70, 97, 102, 58, 58, 48, 57, 65, 
	70, 97, 102, 58, 48, 57, 65, 70, 
	97, 102, 58, 48, 57, 65, 70, 97, 
	102, 58, 48, 57, 65, 70, 97, 102, 
	58, 58, 48, 57, 65, 70, 97, 102, 
	58, 48, 57, 65, 70, 97, 102, 58, 
	48, 57, 65, 70, 97, 102, 58, 48, 
	57, 65, 70, 97, 102, 58, 58, 48, 
	57, 65, 70, 97, 102, 58, 48, 57, 
	65, 70, 97, 102, 58, 48, 57, 65, 
	70, 97, 102, 58, 48, 57, 65, 70, 
	97, 102, 58, 58, 48, 57, 65, 70, 
	97, 102, 58, 48, 57, 65, 70, 97, 
	102, 58, 48, 57, 65, 70, 97, 102, 
	58, 48, 57, 65, 70, 97, 102, 58, 
	58, 48, 57, 65, 70, 97, 102, 58, 
	48, 57, 65, 70, 97, 102, 58, 48, 
	57, 65, 70, 97, 102, 58, 48, 57, 
	65, 70, 97, 102, 58, 58, 48, 57, 
	65, 70, 97, 102, 58, 48, 57, 65, 
	70, 97, 102, 58, 48, 57, 65, 70, 
	97, 102, 58, 48, 57, 65, 70, 97, 
	102, 58, 58, 48, 57, 65, 70, 97, 
	102, 49, 50, 93, 2, 3, 48, 57, 
	65, 70, 97, 102, 46, 58, 93, 48, 
	57, 65, 70, 97, 102, 58, 93, 48, 
	57, 65, 70, 97, 102, 58, 93, 48, 
	57, 65, 70, 97, 102, 58, 93, 49, 
	50, 48, 57, 65, 70, 97, 102, 46, 
	58, 93, 48, 57, 65, 70, 97, 102, 
	58, 93, 48, 57, 65, 70, 97, 102, 
	58, 93, 48, 57, 65, 70, 97, 102, 
	58, 93, 46, 58, 93, 48, 57, 65, 
	70, 97, 102, 46, 58, 93, 48, 57, 
	65, 70, 97, 102, 46, 58, 93, 48, 
	57, 65, 70, 97, 102, 46, 48, 53, 
	58, 93, 49, 57, 65, 70, 97, 102, 
	58, 93, 48, 57, 65, 70, 97, 102, 
	48, 58, 93, 49, 57, 65, 70, 97, 
	102, 58, 93, 48, 57, 65, 70, 97, 
	102, 46, 58, 93, 48, 57, 65, 70, 
	97, 102, 46, 58, 93, 48, 57, 65, 
	70, 97, 102, 46, 58, 93, 48, 57, 
	65, 70, 97, 102, 46, 48, 53, 58, 
	93, 49, 57, 65, 70, 97, 102, 58, 
	93, 48, 57, 65, 70, 97, 102, 48, 
	58, 93, 49, 57, 65, 70, 97, 102, 
	58, 93, 48, 57, 65, 70, 97, 102, 
	49, 50, 2, 3, 48, 57, 65, 70, 
	97, 102, 49, 50, 2, 3, 48, 57, 
	65, 70, 97, 102, 46, 58, 48, 57, 
	65, 70, 97, 102, 58, 48, 57, 65, 
	70, 97, 102, 58, 48, 57, 65, 70, 
	97, 102, 58, 46, 58, 48, 57, 65, 
	70, 97, 102, 46, 58, 48, 57, 65, 
	70, 97, 102, 46, 58, 48, 57, 65, 
	70, 97, 102, 46, 48, 53, 58, 49, 
	57, 65, 70, 97, 102, 58, 48, 57, 
	65, 70, 97, 102, 48, 58, 49, 57, 
	65, 70, 97, 102, 58, 48, 57, 65, 
	70, 97, 102, 2, 3, 48, 57, 65, 
	70, 97, 102, 2, 3, 3, 4, 58, 
	49, 50, 93, 2, 5, 48, 57, 65, 
	70, 97, 102, 48, 57, 65, 70, 97, 
	102, 46, 48, 57, 65, 70, 97, 102, 
	33, 36, 61, 95, 126, 606, 635, 637, 
	38, 46, 48, 59, 65, 90, 97, 122, 
	33, 36, 61, 93, 95, 126, 606, 635, 
	637, 38, 46, 48, 59, 65, 90, 97, 
	122, 33, 58, 124, 126, 1, 8, 10, 
	31, 35, 39, 42, 43, 45, 46, 48, 
	57, 65, 90, 94, 122, 0
};

static const char _http_parser_single_lengths[] = {
	0, 2, 1, 14, 1, 1, 1, 1, 
	1, 1, 1, 0, 2, 5, 4, 6, 
	4, 1, 5, 13, 9, 9, 0, 0, 
	0, 0, 11, 0, 0, 10, 10, 0, 
	0, 12, 15, 14, 0, 0, 13, 9, 
	0, 0, 14, 13, 0, 0, 4, 3, 
	0, 1, 1, 1, 1, 2, 2, 2, 
	1, 2, 1, 2, 1, 5, 1, 1, 
	3, 0, 1, 1, 1, 3, 0, 1, 
	1, 1, 3, 0, 1, 1, 1, 1, 
	0, 1, 1, 1, 2, 2, 2, 4, 
	1, 2, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 3, 3, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	3, 3, 3, 5, 2, 3, 2, 3, 
	3, 3, 5, 2, 3, 2, 2, 2, 
	2, 1, 1, 1, 2, 2, 2, 4, 
	1, 2, 1, 0, 0, 1, 1, 1, 
	3, 0, 1, 8, 9, 16, 12, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 0, 3, 1, 2, 11, 1, 
	1, 2, 11, 0, 0, 9, 0, 0, 
	10, 13, 12, 0, 0, 11, 9, 0, 
	0, 12, 11, 0, 0, 2, 3, 0, 
	1, 1, 1, 1, 2, 2, 2, 1, 
	2, 1, 2, 1, 3, 1, 1, 3, 
	0, 1, 1, 1, 3, 0, 1, 1, 
	1, 3, 0, 1, 1, 1, 1, 0, 
	1, 1, 1, 2, 2, 2, 4, 1, 
	2, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 3, 3, 2, 
	2, 2, 2, 3, 2, 2, 2, 3, 
	3, 3, 5, 2, 3, 2, 3, 3, 
	3, 5, 2, 3, 2, 2, 2, 2, 
	1, 1, 1, 2, 2, 2, 4, 1, 
	2, 1, 0, 0, 1, 1, 1, 3, 
	0, 1, 8, 9, 4, 0
};

static const char _http_parser_range_lengths[] = {
	0, 2, 2, 3, 0, 0, 0, 0, 
	0, 0, 0, 1, 0, 8, 8, 0, 
	0, 0, 8, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 5, 4, 
	3, 3, 3, 3, 3, 3, 1, 3, 
	3, 3, 3, 3, 0, 3, 3, 1, 
	0, 1, 0, 1, 0, 0, 1, 1, 
	0, 1, 0, 1, 1, 0, 1, 0, 
	1, 1, 0, 1, 0, 3, 3, 0, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 0, 3, 
	3, 3, 3, 0, 3, 3, 3, 3, 
	0, 3, 3, 3, 3, 0, 3, 3, 
	3, 3, 0, 3, 3, 3, 3, 0, 
	3, 3, 3, 3, 0, 3, 4, 3, 
	3, 3, 0, 3, 3, 3, 3, 0, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 4, 4, 
	3, 3, 3, 0, 3, 3, 3, 3, 
	3, 3, 3, 4, 1, 0, 0, 0, 
	4, 3, 3, 4, 4, 4, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 0, 4, 4, 0, 0, 3, 0, 
	0, 0, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 5, 4, 3, 
	3, 3, 3, 3, 3, 1, 3, 3, 
	3, 3, 3, 0, 3, 3, 1, 0, 
	1, 0, 1, 0, 0, 1, 1, 0, 
	1, 0, 1, 1, 0, 1, 0, 1, 
	1, 0, 1, 0, 3, 3, 0, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 0, 3, 3, 
	3, 3, 0, 3, 3, 3, 3, 0, 
	3, 3, 3, 3, 0, 3, 3, 3, 
	3, 0, 3, 3, 3, 3, 0, 3, 
	3, 3, 3, 0, 3, 4, 3, 3, 
	3, 0, 3, 3, 3, 3, 0, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 4, 4, 3, 
	3, 3, 0, 3, 3, 3, 3, 3, 
	3, 3, 4, 1, 0, 0, 0, 4, 
	3, 3, 4, 4, 8, 0
};

static const short _http_parser_index_offsets[] = {
	0, 0, 5, 9, 27, 29, 31, 33, 
	35, 37, 39, 41, 43, 46, 60, 73, 
	80, 85, 87, 101, 118, 131, 144, 148, 
	152, 156, 160, 175, 179, 183, 197, 211, 
	215, 219, 235, 254, 272, 276, 280, 299, 
	313, 317, 321, 339, 356, 360, 364, 370, 
	377, 381, 386, 391, 396, 398, 404, 410, 
	414, 416, 420, 422, 426, 428, 434, 437, 
	440, 444, 446, 448, 451, 454, 458, 460, 
	462, 465, 468, 472, 474, 476, 481, 486, 
	488, 492, 497, 502, 507, 513, 519, 525, 
	533, 538, 544, 549, 554, 559, 564, 566, 
	571, 576, 581, 586, 588, 593, 598, 603, 
	608, 610, 615, 620, 625, 630, 632, 637, 
	642, 647, 652, 654, 659, 664, 669, 674, 
	676, 681, 686, 691, 696, 698, 703, 711, 
	718, 724, 730, 733, 739, 746, 752, 758, 
	761, 768, 775, 782, 791, 797, 804, 810, 
	817, 824, 831, 840, 846, 853, 859, 866, 
	873, 879, 884, 889, 891, 897, 903, 909, 
	917, 922, 928, 933, 938, 940, 942, 944, 
	946, 954, 958, 963, 976, 990, 1011, 1027, 
	1031, 1035, 1039, 1043, 1047, 1051, 1055, 1059, 
	1063, 1067, 1071, 1075, 1079, 1083, 1087, 1091, 
	1095, 1099, 1101, 1106, 1114, 1116, 1119, 1134, 
	1136, 1138, 1141, 1156, 1160, 1164, 1177, 1181, 
	1185, 1199, 1216, 1232, 1236, 1240, 1257, 1271, 
	1275, 1279, 1295, 1310, 1314, 1318, 1322, 1329, 
	1333, 1338, 1343, 1348, 1350, 1356, 1362, 1366, 
	1368, 1372, 1374, 1378, 1380, 1384, 1387, 1390, 
	1394, 1396, 1398, 1401, 1404, 1408, 1410, 1412, 
	1415, 1418, 1422, 1424, 1426, 1431, 1436, 1438, 
	1442, 1447, 1452, 1457, 1463, 1469, 1475, 1483, 
	1488, 1494, 1499, 1504, 1509, 1514, 1516, 1521, 
	1526, 1531, 1536, 1538, 1543, 1548, 1553, 1558, 
	1560, 1565, 1570, 1575, 1580, 1582, 1587, 1592, 
	1597, 1602, 1604, 1609, 1614, 1619, 1624, 1626, 
	1631, 1636, 1641, 1646, 1648, 1653, 1661, 1668, 
	1674, 1680, 1683, 1689, 1696, 1702, 1708, 1711, 
	1718, 1725, 1732, 1741, 1747, 1754, 1760, 1767, 
	1774, 1781, 1790, 1796, 1803, 1809, 1816, 1823, 
	1829, 1834, 1839, 1841, 1847, 1853, 1859, 1867, 
	1872, 1878, 1883, 1888, 1890, 1892, 1894, 1896, 
	1904, 1908, 1913, 1926, 1940, 1953
};

static const short _http_parser_indicies[] = {
	2, 3, 0, 0, 1, 4, 5, 5, 
	1, 6, 7, 8, 9, 10, 7, 7, 
	11, 7, 7, 7, 7, 7, 7, 7, 
	12, 12, 1, 13, 1, 14, 1, 15, 
	1, 16, 1, 17, 1, 18, 1, 19, 
	1, 20, 1, 21, 22, 1, 24, 25, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 1, 26, 27, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	1, 1, 29, 30, 31, 29, 1, 28, 
	1, 33, 34, 1, 32, 35, 1, 36, 
	26, 27, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 1, 37, 38, 39, 
	40, 41, 38, 38, 42, 38, 38, 38, 
	38, 38, 38, 38, 38, 1, 43, 44, 
	45, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 1, 46, 47, 48, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 1, 
	49, 49, 49, 1, 47, 47, 47, 1, 
	50, 50, 50, 1, 38, 38, 38, 1, 
	37, 41, 39, 51, 41, 42, 41, 41, 
	41, 41, 41, 41, 41, 41, 1, 52, 
	52, 52, 1, 41, 41, 41, 1, 53, 
	54, 55, 56, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 1, 57, 58, 59, 
	60, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 1, 61, 61, 61, 1, 58, 
	58, 58, 1, 37, 41, 39, 51, 62, 
	41, 42, 41, 41, 41, 41, 41, 41, 
	41, 41, 1, 37, 63, 39, 64, 41, 
	65, 63, 42, 66, 67, 63, 63, 63, 
	63, 63, 63, 63, 63, 1, 37, 63, 
	39, 64, 41, 65, 63, 42, 66, 63, 
	63, 63, 63, 63, 63, 63, 63, 1, 
	68, 68, 68, 1, 63, 63, 63, 1, 
	37, 69, 39, 70, 41, 69, 42, 66, 
	69, 69, 69, 69, 69, 69, 65, 69, 
	69, 69, 1, 69, 70, 69, 66, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	1, 71, 71, 71, 1, 69, 69, 69, 
	1, 37, 72, 39, 73, 41, 74, 72, 
	42, 67, 72, 72, 72, 72, 72, 72, 
	72, 72, 1, 37, 72, 39, 73, 41, 
	74, 72, 42, 72, 72, 72, 72, 72, 
	72, 72, 72, 1, 75, 75, 75, 1, 
	72, 72, 72, 1, 37, 39, 41, 42, 
	74, 1, 76, 78, 79, 77, 77, 77, 
	1, 80, 80, 80, 1, 82, 81, 81, 
	81, 1, 82, 83, 83, 83, 1, 82, 
	84, 84, 84, 1, 82, 1, 86, 87, 
	85, 88, 88, 1, 89, 91, 90, 90, 
	90, 1, 93, 94, 92, 1, 95, 1, 
	97, 98, 96, 1, 99, 1, 101, 102, 
	100, 1, 103, 1, 37, 39, 41, 74, 
	42, 1, 103, 104, 1, 103, 100, 1, 
	105, 106, 103, 1, 100, 1, 100, 1, 
	99, 107, 1, 99, 96, 1, 99, 108, 
	109, 1, 96, 1, 96, 1, 95, 110, 
	1, 95, 92, 1, 95, 111, 112, 1, 
	92, 1, 92, 1, 91, 113, 113, 113, 
	1, 91, 114, 114, 114, 1, 91, 1, 
	115, 115, 115, 1, 103, 116, 116, 116, 
	1, 103, 117, 117, 117, 1, 103, 100, 
	100, 100, 1, 89, 91, 118, 90, 90, 
	1, 89, 91, 119, 113, 113, 1, 89, 
	91, 114, 114, 114, 1, 89, 120, 121, 
	91, 90, 90, 90, 1, 91, 119, 113, 
	113, 1, 119, 91, 113, 113, 113, 1, 
	91, 90, 90, 90, 1, 123, 122, 122, 
	122, 1, 123, 124, 124, 124, 1, 123, 
	125, 125, 125, 1, 123, 1, 127, 126, 
	126, 126, 1, 129, 128, 128, 128, 1, 
	129, 130, 130, 130, 1, 129, 131, 131, 
	131, 1, 129, 1, 133, 132, 132, 132, 
	1, 135, 134, 134, 134, 1, 135, 136, 
	136, 136, 1, 135, 137, 137, 137, 1, 
	135, 1, 139, 138, 138, 138, 1, 141, 
	140, 140, 140, 1, 141, 142, 142, 142, 
	1, 141, 143, 143, 143, 1, 141, 1, 
	145, 144, 144, 144, 1, 147, 146, 146, 
	146, 1, 147, 148, 148, 148, 1, 147, 
	149, 149, 149, 1, 147, 1, 151, 150, 
	150, 150, 1, 153, 152, 152, 152, 1, 
	153, 154, 154, 154, 1, 153, 155, 155, 
	155, 1, 153, 1, 157, 156, 156, 156, 
	1, 159, 158, 158, 158, 1, 159, 160, 
	160, 160, 1, 159, 161, 161, 161, 1, 
	159, 1, 162, 156, 156, 156, 1, 164, 
	165, 103, 76, 163, 166, 166, 1, 89, 
	168, 103, 167, 167, 167, 1, 168, 103, 
	169, 169, 169, 1, 168, 103, 170, 170, 
	170, 1, 168, 103, 1, 172, 173, 171, 
	174, 174, 1, 89, 91, 103, 175, 175, 
	175, 1, 91, 103, 176, 176, 176, 1, 
	91, 103, 177, 177, 177, 1, 91, 103, 
	1, 89, 91, 103, 178, 175, 175, 1, 
	89, 91, 103, 179, 176, 176, 1, 89, 
	91, 103, 177, 177, 177, 1, 89, 180, 
	181, 91, 103, 175, 175, 175, 1, 91, 
	103, 179, 176, 176, 1, 179, 91, 103, 
	176, 176, 176, 1, 91, 103, 175, 175, 
	175, 1, 89, 168, 103, 182, 167, 167, 
	1, 89, 168, 103, 183, 169, 169, 1, 
	89, 168, 103, 170, 170, 170, 1, 89, 
	184, 185, 168, 103, 167, 167, 167, 1, 
	168, 103, 183, 169, 169, 1, 183, 168, 
	103, 169, 169, 169, 1, 168, 103, 167, 
	167, 167, 1, 164, 165, 76, 163, 166, 
	166, 1, 187, 188, 76, 186, 189, 189, 
	1, 89, 168, 190, 190, 190, 1, 168, 
	191, 191, 191, 1, 168, 192, 192, 192, 
	1, 168, 1, 89, 168, 193, 190, 190, 
	1, 89, 168, 194, 191, 191, 1, 89, 
	168, 192, 192, 192, 1, 89, 195, 196, 
	168, 190, 190, 190, 1, 168, 194, 191, 
	191, 1, 194, 168, 191, 191, 191, 1, 
	168, 190, 190, 190, 1, 76, 80, 80, 
	80, 1, 76, 1, 76, 1, 76, 1, 
	197, 1, 164, 165, 103, 76, 163, 166, 
	166, 1, 198, 198, 198, 1, 199, 198, 
	198, 198, 1, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 1, 
	200, 200, 200, 103, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 1, 37, 38, 
	39, 40, 201, 41, 202, 38, 38, 42, 
	38, 38, 38, 38, 38, 38, 38, 201, 
	201, 201, 1, 6, 203, 8, 204, 10, 
	203, 11, 203, 203, 203, 203, 203, 203, 
	203, 203, 1, 4, 205, 205, 1, 4, 
	206, 206, 1, 4, 207, 207, 1, 4, 
	208, 208, 1, 4, 209, 209, 1, 4, 
	210, 210, 1, 4, 211, 211, 1, 4, 
	212, 212, 1, 4, 213, 213, 1, 4, 
	214, 214, 1, 4, 215, 215, 1, 4, 
	216, 216, 1, 4, 217, 217, 1, 4, 
	218, 218, 1, 4, 219, 219, 1, 4, 
	220, 220, 1, 4, 221, 221, 1, 4, 
	222, 222, 1, 4, 1, 223, 223, 223, 
	223, 1, 224, 224, 224, 224, 223, 223, 
	223, 1, 226, 225, 227, 226, 225, 228, 
	229, 230, 231, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 1, 232, 1, 
	234, 233, 235, 234, 233, 228, 229, 230, 
	236, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 1, 237, 237, 237, 1, 
	229, 229, 229, 1, 228, 236, 238, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	1, 239, 239, 239, 1, 236, 236, 236, 
	1, 228, 236, 238, 240, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 1, 228, 
	241, 242, 236, 243, 241, 244, 245, 241, 
	241, 241, 241, 241, 241, 241, 241, 1, 
	228, 241, 242, 236, 243, 241, 244, 241, 
	241, 241, 241, 241, 241, 241, 241, 1, 
	246, 246, 246, 1, 241, 241, 241, 1, 
	228, 247, 248, 236, 247, 244, 247, 247, 
	247, 247, 247, 247, 243, 247, 247, 247, 
	1, 247, 248, 247, 244, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 1, 249, 
	249, 249, 1, 247, 247, 247, 1, 228, 
	250, 251, 236, 252, 250, 245, 250, 250, 
	250, 250, 250, 250, 250, 250, 1, 228, 
	250, 251, 236, 252, 250, 250, 250, 250, 
	250, 250, 250, 250, 250, 1, 253, 253, 
	253, 1, 250, 250, 250, 1, 228, 236, 
	252, 1, 254, 256, 257, 255, 255, 255, 
	1, 258, 258, 258, 1, 260, 259, 259, 
	259, 1, 260, 261, 261, 261, 1, 260, 
	262, 262, 262, 1, 260, 1, 264, 265, 
	263, 266, 266, 1, 267, 269, 268, 268, 
	268, 1, 271, 272, 270, 1, 273, 1, 
	275, 276, 274, 1, 277, 1, 279, 280, 
	278, 1, 281, 1, 228, 236, 252, 1, 
	281, 282, 1, 281, 278, 1, 283, 284, 
	281, 1, 278, 1, 278, 1, 277, 285, 
	1, 277, 274, 1, 277, 286, 287, 1, 
	274, 1, 274, 1, 273, 288, 1, 273, 
	270, 1, 273, 289, 290, 1, 270, 1, 
	270, 1, 269, 291, 291, 291, 1, 269, 
	292, 292, 292, 1, 269, 1, 293, 293, 
	293, 1, 281, 294, 294, 294, 1, 281, 
	295, 295, 295, 1, 281, 278, 278, 278, 
	1, 267, 269, 296, 268, 268, 1, 267, 
	269, 297, 291, 291, 1, 267, 269, 292, 
	292, 292, 1, 267, 298, 299, 269, 268, 
	268, 268, 1, 269, 297, 291, 291, 1, 
	297, 269, 291, 291, 291, 1, 269, 268, 
	268, 268, 1, 301, 300, 300, 300, 1, 
	301, 302, 302, 302, 1, 301, 303, 303, 
	303, 1, 301, 1, 305, 304, 304, 304, 
	1, 307, 306, 306, 306, 1, 307, 308, 
	308, 308, 1, 307, 309, 309, 309, 1, 
	307, 1, 311, 310, 310, 310, 1, 313, 
	312, 312, 312, 1, 313, 314, 314, 314, 
	1, 313, 315, 315, 315, 1, 313, 1, 
	317, 316, 316, 316, 1, 319, 318, 318, 
	318, 1, 319, 320, 320, 320, 1, 319, 
	321, 321, 321, 1, 319, 1, 323, 322, 
	322, 322, 1, 325, 324, 324, 324, 1, 
	325, 326, 326, 326, 1, 325, 327, 327, 
	327, 1, 325, 1, 329, 328, 328, 328, 
	1, 331, 330, 330, 330, 1, 331, 332, 
	332, 332, 1, 331, 333, 333, 333, 1, 
	331, 1, 335, 334, 334, 334, 1, 337, 
	336, 336, 336, 1, 337, 338, 338, 338, 
	1, 337, 339, 339, 339, 1, 337, 1, 
	340, 334, 334, 334, 1, 342, 343, 281, 
	254, 341, 344, 344, 1, 267, 346, 281, 
	345, 345, 345, 1, 346, 281, 347, 347, 
	347, 1, 346, 281, 348, 348, 348, 1, 
	346, 281, 1, 350, 351, 349, 352, 352, 
	1, 267, 269, 281, 353, 353, 353, 1, 
	269, 281, 354, 354, 354, 1, 269, 281, 
	355, 355, 355, 1, 269, 281, 1, 267, 
	269, 281, 356, 353, 353, 1, 267, 269, 
	281, 357, 354, 354, 1, 267, 269, 281, 
	355, 355, 355, 1, 267, 358, 359, 269, 
	281, 353, 353, 353, 1, 269, 281, 357, 
	354, 354, 1, 357, 269, 281, 354, 354, 
	354, 1, 269, 281, 353, 353, 353, 1, 
	267, 346, 281, 360, 345, 345, 1, 267, 
	346, 281, 361, 347, 347, 1, 267, 346, 
	281, 348, 348, 348, 1, 267, 362, 363, 
	346, 281, 345, 345, 345, 1, 346, 281, 
	361, 347, 347, 1, 361, 346, 281, 347, 
	347, 347, 1, 346, 281, 345, 345, 345, 
	1, 342, 343, 254, 341, 344, 344, 1, 
	365, 366, 254, 364, 367, 367, 1, 267, 
	346, 368, 368, 368, 1, 346, 369, 369, 
	369, 1, 346, 370, 370, 370, 1, 346, 
	1, 267, 346, 371, 368, 368, 1, 267, 
	346, 372, 369, 369, 1, 267, 346, 370, 
	370, 370, 1, 267, 373, 374, 346, 368, 
	368, 368, 1, 346, 372, 369, 369, 1, 
	372, 346, 369, 369, 369, 1, 346, 368, 
	368, 368, 1, 254, 258, 258, 258, 1, 
	254, 1, 254, 1, 254, 1, 375, 1, 
	342, 343, 281, 254, 341, 344, 344, 1, 
	376, 376, 376, 1, 377, 376, 376, 376, 
	1, 378, 378, 378, 378, 378, 378, 378, 
	378, 378, 378, 378, 378, 1, 378, 378, 
	378, 281, 378, 378, 378, 378, 378, 378, 
	378, 378, 378, 1, 26, 27, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	1, 1, 0
};

static const short _http_parser_trans_targs[] = {
	2, 0, 194, 198, 3, 175, 4, 19, 
	20, 24, 33, 29, 173, 5, 6, 7, 
	8, 9, 10, 11, 12, 13, 17, 14, 
	348, 18, 14, 15, 16, 15, 13, 17, 
	16, 13, 17, 13, 348, 4, 19, 20, 
	24, 26, 29, 4, 21, 22, 4, 21, 
	22, 23, 25, 27, 28, 4, 30, 20, 
	31, 4, 30, 20, 31, 32, 34, 35, 
	36, 38, 42, 47, 37, 39, 40, 41, 
	43, 44, 46, 45, 48, 91, 167, 169, 
	49, 50, 53, 51, 52, 54, 84, 87, 
	90, 55, 77, 80, 56, 72, 74, 57, 
	58, 67, 69, 59, 60, 62, 64, 61, 
	63, 65, 66, 68, 70, 71, 73, 75, 
	76, 78, 79, 81, 82, 83, 85, 86, 
	88, 89, 92, 95, 93, 94, 96, 166, 
	97, 100, 98, 99, 101, 165, 102, 105, 
	103, 104, 106, 164, 107, 110, 108, 109, 
	111, 163, 112, 115, 113, 114, 116, 151, 
	117, 120, 118, 119, 121, 150, 122, 125, 
	123, 124, 126, 127, 143, 146, 149, 128, 
	131, 129, 130, 132, 136, 139, 142, 133, 
	134, 135, 137, 138, 140, 141, 144, 145, 
	147, 148, 152, 156, 159, 162, 153, 154, 
	155, 157, 158, 160, 161, 168, 170, 171, 
	172, 173, 174, 26, 27, 176, 177, 178, 
	179, 180, 181, 182, 183, 184, 185, 186, 
	187, 188, 189, 190, 191, 192, 193, 195, 
	196, 196, 197, 349, 199, 202, 203, 208, 
	200, 200, 201, 349, 205, 204, 206, 207, 
	209, 210, 211, 213, 217, 222, 212, 214, 
	215, 216, 218, 219, 221, 220, 223, 266, 
	342, 344, 224, 225, 228, 226, 227, 229, 
	259, 262, 265, 230, 252, 255, 231, 247, 
	249, 232, 233, 242, 244, 234, 235, 237, 
	239, 236, 238, 240, 241, 243, 245, 246, 
	248, 250, 251, 253, 254, 256, 257, 258, 
	260, 261, 263, 264, 267, 270, 268, 269, 
	271, 341, 272, 275, 273, 274, 276, 340, 
	277, 280, 278, 279, 281, 339, 282, 285, 
	283, 284, 286, 338, 287, 290, 288, 289, 
	291, 326, 292, 295, 293, 294, 296, 325, 
	297, 300, 298, 299, 301, 302, 318, 321, 
	324, 303, 306, 304, 305, 307, 311, 314, 
	317, 308, 309, 310, 312, 313, 315, 316, 
	319, 320, 322, 323, 327, 331, 334, 337, 
	328, 329, 330, 332, 333, 335, 336, 343, 
	345, 346, 347
};

static const char _http_parser_trans_actions[] = {
	1, 0, 1, 1, 11, 0, 47, 1, 
	47, 1, 1, 26, 1, 1, 0, 0, 
	0, 0, 0, 0, 0, 17, 17, 3, 
	29, 3, 0, 5, 7, 7, 32, 32, 
	0, 9, 9, 0, 21, 38, 0, 38, 
	0, 0, 19, 23, 1, 1, 13, 0, 
	0, 0, 0, 0, 0, 51, 15, 51, 
	15, 35, 0, 35, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	19, 0, 0, 41, 19, 0, 0, 0, 
	1, 0, 0, 44, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0
};

static const int http_parser_start = 1;
static const int http_parser_first_final = 348;
static const int http_parser_error = 0;

static const int http_parser_en_main = 1;


#line 259 "src/http11/http11_parser.rl"

int http_parser_init(http_parser *parser) {
  int cs = 0;
  
#line 1059 "src/http11/http11_parser.c"
	{
	cs = http_parser_start;
	}

#line 263 "src/http11/http11_parser.rl"
  parser->cs = cs;
  parser->body_start = 0;
  parser->content_len = 0;
  parser->mark = 0;
  parser->nread = 0;
  parser->field_len = 0;
  parser->field_start = 0;
  parser->xml_sent = 0;
  parser->json_sent = 0;

  return(1);
}


/** exec **/
size_t http_parser_execute(http_parser *parser, const char *buffer, size_t len, size_t off)  
{
  if(len == 0) return 0;

  const char *p, *pe;
  int cs = parser->cs;

  assert(off <= len && "offset past end of buffer");

  p = buffer+off;
  pe = buffer+len;

  assert(pe - p == (int)len - (int)off && "pointers aren't same distance");

  
#line 1095 "src/http11/http11_parser.c"
	{
	int _klen;
	unsigned int _trans;
	short _widec;
	const char *_acts;
	unsigned int _nacts;
	const short *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_widec = (*p);
	_klen = _http_parser_cond_lengths[cs];
	_keys = _http_parser_cond_keys + (_http_parser_cond_offsets[cs]*2);
	if ( _klen > 0 ) {
		const short *_lower = _keys;
		const short *_mid;
		const short *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( _widec < _mid[0] )
				_upper = _mid - 2;
			else if ( _widec > _mid[1] )
				_lower = _mid + 2;
			else {
				switch ( _http_parser_cond_spaces[_http_parser_cond_offsets[cs] + ((_mid - _keys)>>1)] ) {
	case 0: {
		_widec = (short)(128 + ((*p) - -128));
		if ( 
#line 129 "src/http11/http11_parser.rl"
 parser->uri_relaxed  ) _widec += 256;
		break;
	}
				}
				break;
			}
		}
	}

	_keys = _http_parser_trans_keys + _http_parser_key_offsets[cs];
	_trans = _http_parser_index_offsets[cs];

	_klen = _http_parser_single_lengths[cs];
	if ( _klen > 0 ) {
		const short *_lower = _keys;
		const short *_mid;
		const short *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( _widec < *_mid )
				_upper = _mid - 1;
			else if ( _widec > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (unsigned int)(_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _http_parser_range_lengths[cs];
	if ( _klen > 0 ) {
		const short *_lower = _keys;
		const short *_mid;
		const short *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( _widec < _mid[0] )
				_upper = _mid - 2;
			else if ( _widec > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += (unsigned int)((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	_trans = _http_parser_indicies[_trans];
	cs = _http_parser_trans_targs[_trans];

	if ( _http_parser_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _http_parser_actions + _http_parser_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 53 "src/http11/http11_parser.rl"
	{MARK(mark, p); }
	break;
	case 1:
#line 56 "src/http11/http11_parser.rl"
	{ MARK(field_start, p); }
	break;
	case 2:
#line 57 "src/http11/http11_parser.rl"
	{ 
    parser->field_len = LEN(field_start, p);
  }
	break;
	case 3:
#line 61 "src/http11/http11_parser.rl"
	{ MARK(mark, p); }
	break;
	case 4:
#line 63 "src/http11/http11_parser.rl"
	{
    if(parser->http_field != NULL) {
      parser->http_field(parser->data, PTR_TO(field_start), parser->field_len, PTR_TO(mark), LEN(mark, p));
    }
  }
	break;
	case 5:
#line 69 "src/http11/http11_parser.rl"
	{ 
    if(parser->request_method != NULL) 
      parser->request_method(parser->data, PTR_TO(mark), LEN(mark, p));
  }
	break;
	case 6:
#line 74 "src/http11/http11_parser.rl"
	{ 
    if(parser->request_uri != NULL)
      parser->request_uri(parser->data, PTR_TO(mark), LEN(mark, p));
  }
	break;
	case 7:
#line 79 "src/http11/http11_parser.rl"
	{
    if(parser->fragment != NULL)
      parser->fragment(parser->data, PTR_TO(mark), LEN(mark, p));
  }
	break;
	case 8:
#line 84 "src/http11/http11_parser.rl"
	{MARK(query_start, p); }
	break;
	case 9:
#line 85 "src/http11/http11_parser.rl"
	{ 
    if(parser->query_string != NULL)
      parser->query_string(parser->data, PTR_TO(query_start), LEN(query_start, p));
  }
	break;
	case 10:
#line 90 "src/http11/http11_parser.rl"
	{	
    if(parser->http_version != NULL)
      parser->http_version(parser->data, PTR_TO(mark), LEN(mark, p));
  }
	break;
	case 11:
#line 95 "src/http11/http11_parser.rl"
	{
    if(parser->request_path != NULL)
      parser->request_path(parser->data, PTR_TO(mark), LEN(mark,p));
  }
	break;
	case 12:
#line 100 "src/http11/http11_parser.rl"
	{
      if(parser->xml_sent || parser->json_sent) {
        parser->body_start = PTR_TO(mark) - buffer;
        // +1 includes the \0
        parser->content_len = p - buffer - parser->body_start + 1;
      } else {
        parser->body_start = p - buffer + 1;

        if(parser->header_done != NULL) {
          parser->header_done(parser->data, p + 1, pe - p - 1);
        }
      }
    {p++; goto _out; }
  }
	break;
	case 13:
#line 115 "src/http11/http11_parser.rl"
	{
      parser->xml_sent = 1;
  }
	break;
	case 14:
#line 119 "src/http11/http11_parser.rl"
	{
      parser->json_sent = 1;
  }
	break;
#line 1302 "src/http11/http11_parser.c"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	_out: {}
	}

#line 293 "src/http11/http11_parser.rl"

  assert(p <= pe && "Buffer overflow after parsing.");

  if (!http_parser_has_error(parser)) {
      parser->cs = cs;
  }

  parser->nread += p - (buffer + off);

  assert(parser->nread <= len && "nread longer than length");
  assert(parser->body_start <= len && "body starts after buffer end");
  assert(parser->mark < len && "mark is after buffer end");
  assert(parser->field_len <= len && "field has length longer than whole buffer");
  assert(parser->field_start < len && "field starts after buffer end");

  return(parser->nread);
}

int http_parser_finish(http_parser *parser)
{
  if (http_parser_has_error(parser) ) {
    return -1;
  } else if (http_parser_is_finished(parser) ) {
    return 1;
  } else {
    return 0;
  }
}

int http_parser_has_error(http_parser *parser) {
  return parser->cs == http_parser_error;
}

int http_parser_is_finished(http_parser *parser) {
  return parser->cs >= http_parser_first_final;
}
