// Generated by LiveScript 1.6.0
var ref$, id, ref1$, even, odd, floor, isItNaN, each, map, filter, compact, reject, remove, partition, find, head, first, tail, last, initial, empty, reverse, difference, intersection, union, countBy, groupBy, fold, fold1, foldl, foldl1, foldr, foldr1, unfoldr, andList, orList, any, all, unique, uniqueBy, sort, sortWith, sortBy, sum, product, mean, average, concat, concatMap, flatten, maximum, minimum, maximumBy, minimumBy, scan, scan1, scanl, scanl1, scanr, scanr1, slice, take, drop, splitAt, takeWhile, dropWhile, span, breakList, zip, zipWith, zipAll, zipAllWith, at, elemIndex, elemIndices, findIndex, findIndices, eq, deepEq, ok;
ref$ = require('../..'), id = ref$.id, ref1$ = ref$.Num, even = ref1$.even, odd = ref1$.odd, floor = ref1$.floor, isItNaN = ref1$.isItNaN, ref1$ = ref$.List, each = ref1$.each, map = ref1$.map, filter = ref1$.filter, compact = ref1$.compact, reject = ref1$.reject, remove = ref1$.remove, partition = ref1$.partition, find = ref1$.find, head = ref1$.head, first = ref1$.first, tail = ref1$.tail, last = ref1$.last, initial = ref1$.initial, empty = ref1$.empty, reverse = ref1$.reverse, difference = ref1$.difference, intersection = ref1$.intersection, union = ref1$.union, countBy = ref1$.countBy, groupBy = ref1$.groupBy, fold = ref1$.fold, fold1 = ref1$.fold1, foldl = ref1$.foldl, foldl1 = ref1$.foldl1, foldr = ref1$.foldr, foldr1 = ref1$.foldr1, unfoldr = ref1$.unfoldr, andList = ref1$.andList, orList = ref1$.orList, any = ref1$.any, all = ref1$.all, unique = ref1$.unique, uniqueBy = ref1$.uniqueBy, sort = ref1$.sort, sortWith = ref1$.sortWith, sortBy = ref1$.sortBy, sum = ref1$.sum, product = ref1$.product, mean = ref1$.mean, average = ref1$.average, concat = ref1$.concat, concatMap = ref1$.concatMap, flatten = ref1$.flatten, maximum = ref1$.maximum, minimum = ref1$.minimum, maximumBy = ref1$.maximumBy, minimumBy = ref1$.minimumBy, scan = ref1$.scan, scan1 = ref1$.scan1, scanl = ref1$.scanl, scanl1 = ref1$.scanl1, scanr = ref1$.scanr, scanr1 = ref1$.scanr1, slice = ref1$.slice, take = ref1$.take, drop = ref1$.drop, splitAt = ref1$.splitAt, takeWhile = ref1$.takeWhile, dropWhile = ref1$.dropWhile, span = ref1$.span, breakList = ref1$.breakList, zip = ref1$.zip, zipWith = ref1$.zipWith, zipAll = ref1$.zipAll, zipAllWith = ref1$.zipAllWith, at = ref1$.at, elemIndex = ref1$.elemIndex, elemIndices = ref1$.elemIndices, findIndex = ref1$.findIndex, findIndices = ref1$.findIndices;
ref$ = require('assert'), eq = ref$.strictEqual, deepEq = ref$.deepEqual, ok = ref$.ok;
suite('each', function(){
  test('empty list as input', function(){
    return deepEq([], each(id, []));
  });
  test('side effects affect input (and thus result)', function(){
    return deepEq([[1], [2]], each(function(it){
      return it.pop();
    }, [[1, 5], [2, 6]]));
  });
  return test('curried', function(){
    var f;
    f = each(function(it){
      return it.pop();
    });
    return deepEq([[1], [2]], f([[1, 5], [2, 6]]));
  });
});
suite('map', function(){
  test('empty list as input', function(){
    return deepEq([], map(id, []));
  });
  test('mapping over array', function(){
    return deepEq([2, 3, 4], map((function(it){
      return it + 1;
    }), [1, 2, 3]));
  });
  return test('curried', function(){
    var f;
    f = map((function(it){
      return it + 1;
    }));
    return deepEq([2, 3, 4], f([1, 2, 3]));
  });
});
suite('compact', function(){
  test('empty list as input', function(){
    return deepEq([], compact([]));
  });
  return test('compacting array', function(){
    return deepEq([1, true, 'ha'], compact([0, 1, false, true, '', 'ha']));
  });
});
suite('filter', function(){
  test('empty list as input', function(){
    return deepEq([], filter(id, []));
  });
  test('filtering array', function(){
    return deepEq([2, 4], filter(even, [1, 2, 3, 4, 5]));
  });
  test('filter on true returns original list', function(){
    return deepEq([1, 2, 3], filter(function(){
      return true;
    }, [1, 2, 3]));
  });
  test('filter on false returns empty list', function(){
    return deepEq([], filter(function(){
      return false;
    }, [1, 2, 3]));
  });
  return test('curried', function(){
    var f;
    f = filter(even);
    return deepEq([2, 4], f([1, 2, 3, 4, 5]));
  });
});
suite('reject', function(){
  test('empty list as input', function(){
    return deepEq([], reject(id, []));
  });
  test('reject list', function(){
    return deepEq([1, 3, 5], reject(even, [1, 2, 3, 4, 5]));
  });
  test('reject on true returns empty list', function(){
    return deepEq([], reject(function(){
      return true;
    }, [1, 2, 3]));
  });
  test('reject on true returns original list', function(){
    return deepEq([1, 2, 3], reject(function(){
      return false;
    }, [1, 2, 3]));
  });
  return test('curried', function(){
    var f;
    f = reject(even);
    return deepEq([1, 3, 5], f([1, 2, 3, 4, 5]));
  });
});
suite('remove', function(){
  test('empty list as input', function(){
    return deepEq([], remove(2, []));
  });
  test('basic', function(){
    return deepEq([1, 3], remove(2, [1, 2, 3]));
  });
  test('multiple', function(){
    return deepEq([1, 3, 2], remove(2, [1, 2, 3, 2]));
  });
  test('not there', function(){
    return deepEq([1, 2, 3], remove(5, [1, 2, 3]));
  });
  return test('curried', function(){
    var f;
    f = remove(2);
    return deepEq([1, 3], f([1, 2, 3]));
  });
});
suite('partition', function(){
  test('empty list as input', function(){
    return deepEq([[], []], partition(id, []));
  });
  test('partition list', function(){
    return deepEq([[76, 88, 77, 90], [49, 58, 43]], partition((function(it){
      return it > 60;
    }), [49, 58, 76, 43, 88, 77, 90]));
  });
  test('partition on true returns original list as passing, empty list as failing', function(){
    return deepEq([[1, 2, 3], []], partition(function(){
      return true;
    }, [1, 2, 3]));
  });
  test('partition on false returns empty list as failing, empty list as passing', function(){
    return deepEq([[], [1, 2, 3]], partition(function(){
      return false;
    }, [1, 2, 3]));
  });
  return test('curried', function(){
    var f;
    f = partition((function(it){
      return it > 60;
    }));
    return deepEq([[76, 88, 77, 90], [49, 58, 43]], f([49, 58, 76, 43, 88, 77, 90]));
  });
});
suite('find', function(){
  test('empty list as input', function(){
    return eq(void 8, find(id, []));
  });
  test('find from list', function(){
    return eq(4, find(even, [3, 1, 4, 8, 6]));
  });
  test('finding nothing when function always false', function(){
    return eq(void 8, find(function(){
      return false;
    }, [1, 2, 3]));
  });
  test('find first item when function always true', function(){
    return eq(1, find(function(){
      return true;
    }, [1, 2, 3]));
  });
  return test('curried', function(){
    var f;
    f = find(even);
    return eq(4, f([3, 1, 4, 8, 6]));
  });
});
suite('list portions', function(){
  var list;
  list = [1, 2, 3, 4, 5];
  suite('head', function(){
    test('empty list as input', function(){
      return eq(void 8, head([]));
    });
    test('list', function(){
      return eq(1, head(list));
    });
    return test('first as alias', function(){
      return eq(first, head);
    });
  });
  suite('tail', function(){
    test('empty list as input', function(){
      return eq(void 8, tail([]));
    });
    test('list', function(){
      return deepEq([2, 3, 4, 5], tail(list));
    });
    return test('one element list', function(){
      return deepEq([], tail([1]));
    });
  });
  suite('last', function(){
    test('empty list as input', function(){
      return eq(void 8, last([]));
    });
    test('list', function(){
      return eq(5, last(list));
    });
    return test('one element list', function(){
      return eq(1, last([1]));
    });
  });
  return suite('initial', function(){
    test('empty list as input', function(){
      return eq(void 8, initial([]));
    });
    test('list', function(){
      return deepEq([1, 2, 3, 4], initial(list));
    });
    return test('one element list', function(){
      return deepEq([], initial([1]));
    });
  });
});
suite('empty', function(){
  test('empty list as input', function(){
    return ok(empty([]));
  });
  return test('non-empty list as input', function(){
    return ok(!empty([1]));
  });
});
suite('reverse', function(){
  test('empty list as input', function(){
    return deepEq([], reverse([]));
  });
  return test('reverse list, it is unmodified', function(){
    var list;
    list = [1, 2, 3, 4, 5];
    deepEq([5, 4, 3, 2, 1], reverse(list));
    return deepEq([1, 2, 3, 4, 5], list);
  });
});
suite('unique', function(){
  test('empty list as input', function(){
    return deepEq([], unique([]));
  });
  test('unique list', function(){
    return deepEq([1, 2, 3, 4, 5, 6], unique([1, 1, 2, 3, 3, 4, 5, 5, 5, 5, 5, 6, 6, 6, 6]));
  });
  return test('mixed string/num', function(){
    return deepEq(['1', 1, 2, 4, 5], unique(['1', 1, 2, 4, 5, 5]));
  });
});
suite('unique-by', function(){
  test('empty list as input', function(){
    return deepEq([], uniqueBy(id, []));
  });
  test('basic', function(){
    return deepEq([1, 2, 3, 4, 5, 6], uniqueBy(id, [1, 1, 2, 3, 3, 4, 5, 5, 5, 5, 5, 6, 6, 6, 6]));
  });
  test('accessor', function(){
    return deepEq([[], [1, 2, 3], [4], [5, 6]], uniqueBy(function(it){
      return it.length;
    }, [[], [1, 2, 3], [4], [5, 6], [7], [8, 9, 10]]));
  });
  return test('curried', function(){
    return deepEq([1, 2, 3, 4, 5, 6], uniqueBy(id)([1, 1, 2, 3, 3, 4, 5, 5, 5, 5, 5, 6, 6, 6, 6]));
  });
});
suite('fold', function(){
  test('empty list as input', function(){
    return eq(0, fold(curry$(function(x$, y$){
      return x$ + y$;
    }), 0, []));
  });
  test('list as input', function(){
    return eq(12, fold(curry$(function(x$, y$){
      return x$ + y$;
    }), 0, [1, 2, 3, 6]));
  });
  test('foldl is alias', function(){
    return eq(fold, foldl);
  });
  return test('curried', function(){
    var f, g;
    f = fold(curry$(function(x$, y$){
      return x$ + y$;
    }));
    eq(12, f(0, [1, 2, 3, 6]));
    g = fold(curry$(function(x$, y$){
      return x$ + y$;
    }), 0);
    return eq(12, g([1, 2, 3, 6]));
  });
});
suite('fold1', function(){
  test('empty list as input', function(){
    return eq(void 8, fold1(curry$(function(x$, y$){
      return x$ + y$;
    }), []));
  });
  test('list as input', function(){
    return eq(12, fold1(curry$(function(x$, y$){
      return x$ + y$;
    }), [1, 2, 3, 6]));
  });
  test('foldl1 as alais', function(){
    return eq(fold1, foldl1);
  });
  return test('curried', function(){
    var f;
    f = fold1(curry$(function(x$, y$){
      return x$ + y$;
    }));
    return eq(12, f([1, 2, 3, 6]));
  });
});
suite('foldr', function(){
  test('empty list as input', function(){
    return eq(0, foldr(curry$(function(x$, y$){
      return x$ + y$;
    }), 0, []));
  });
  test('list as input', function(){
    eq(7, foldr(curry$(function(x$, y$){
      return x$ - y$;
    }), 9, [1, 2, 3, 4]));
    return eq('abcde', foldr(curry$(function(x$, y$){
      return x$ + y$;
    }), 'e', ['a', 'b', 'c', 'd']));
  });
  return test('curried', function(){
    var f, g;
    f = foldr(curry$(function(x$, y$){
      return x$ - y$;
    }));
    eq(7, f(9, [1, 2, 3, 4]));
    g = foldr(curry$(function(x$, y$){
      return x$ - y$;
    }), 9);
    return eq(7, g([1, 2, 3, 4]));
  });
});
suite('foldr1', function(){
  test('empty list as input', function(){
    return eq(void 8, foldr1(curry$(function(x$, y$){
      return x$ + y$;
    }), []));
  });
  test('list as input', function(){
    eq(7, foldr1(curry$(function(x$, y$){
      return x$ - y$;
    }), [1, 2, 3, 4, 9]));
    return eq('abcde', foldr1(curry$(function(x$, y$){
      return x$ + y$;
    }), ['a', 'b', 'c', 'd', 'e']));
  });
  return test('curried', function(){
    var f;
    f = foldr1(curry$(function(x$, y$){
      return x$ - y$;
    }));
    return eq(7, f([1, 2, 3, 4, 9]));
  });
});
suite('unfoldr', function(){
  test('complex case', function(){
    return deepEq([10, 9, 8, 7, 6, 5, 4, 3, 2, 1], unfoldr(function(it){
      if (it === 0) {
        return null;
      } else {
        return [it, it - 1];
      }
    }, 10));
  });
  test('returning null right away results in a one item list', function(){
    return deepEq([], unfoldr(function(){
      return null;
    }, 'a'));
  });
  return test('curried', function(){
    var f;
    f = unfoldr(function(it){
      if (it === 0) {
        return null;
      } else {
        return [it, it - 1];
      }
    });
    return deepEq([10, 9, 8, 7, 6, 5, 4, 3, 2, 1], f(10));
  });
});
suite('concat', function(){
  test('empty list as input', function(){
    return deepEq([], concat([]));
  });
  return test('multiple lists', function(){
    return deepEq([1, 2, 3, 4, 5, 6], concat([[1, 2], [3, 4], [5, 6]]));
  });
});
suite('concat-map', function(){
  test('empty list as input', function(){
    return deepEq([], concatMap(id, []));
  });
  test('using mapping and concatinating', function(){
    return deepEq([1, 1, 2, 1, 2, 3], concatMap(function(it){
      var i$, results$ = [];
      for (i$ = 1; i$ <= it; ++i$) {
        results$.push(i$);
      }
      return results$;
    }, [1, 2, 3]));
  });
  return test('curried', function(){
    var f;
    f = concatMap(function(it){
      var i$, results$ = [];
      for (i$ = 1; i$ <= it; ++i$) {
        results$.push(i$);
      }
      return results$;
    });
    return deepEq([1, 1, 2, 1, 2, 3], f([1, 2, 3]));
  });
});
suite('flatten', function(){
  test('empty list as input', function(){
    return deepEq([], flatten([]));
  });
  test('nested lists as input', function(){
    return deepEq([1, 2, 3, 4, 5], flatten([1, [[2], 3], [4, [[5]]]]));
  });
  return test('lists with strings', function(){
    return deepEq(['a', 'b', 'c', 'd', 'e'], flatten(['a', [['b'], 'c'], ['d', [['e']]]]));
  });
});
suite('difference', function(){
  test('empty list(s) as input', function(){
    deepEq([], difference([]));
    return deepEq([], difference([], []));
  });
  test('subtract nothing', function(){
    deepEq([1, 2, 3], difference([1, 2, 3]));
    return deepEq([1, 2, 3], difference([1, 2, 3], []));
  });
  test('subtract single element', function(){
    return deepEq([2, 3], difference([1, 2, 3], [1]));
  });
  return test('subtract multiple elements', function(){
    return deepEq([1, 3, 4], difference([1, 2, 3, 4, 5], [5, 2, 10], [9]));
  });
});
suite('intersection', function(){
  test('empty list(s) as input', function(){
    deepEq([], intersection([]));
    return deepEq([], intersection([], []));
  });
  test('no common elements', function(){
    return deepEq([], intersection([2, 3], [9, 8], [12, 1], [99]));
  });
  test('some common elements', function(){
    return deepEq([1, 2], intersection([1, 2, 3], [101, 2, 1, 10], [2, 1], [-1, 0, 1, 2]));
  });
  return test('all common elements', function(){
    return deepEq([1, 2, 3], intersection([1, 2, 3], [2, 1, 3], [3, 1, 2]));
  });
});
suite('union', function(){
  test('empty list(s) as input', function(){
    deepEq([], union([]));
    return deepEq([], union([], []));
  });
  test('list and empty list', function(){
    return deepEq([1, 2, 3], union([1, 2, 3], []));
  });
  return test('with various', function(){
    return deepEq([1, 5, 7, 3], union([1, 5, 7], [3, 5], []));
  });
});
suite('count-by', function(){
  test('empty list as input', function(){
    return deepEq({}, countBy(id, []));
  });
  test('list of numbers', function(){
    return deepEq({
      4: 1,
      6: 2
    }, countBy(floor, [4.2, 6.1, 6.4]));
  });
  test('list of strings', function(){
    return deepEq({
      3: 2,
      5: 1
    }, countBy(function(it){
      return it.length;
    }, ['one', 'two', 'three']));
  });
  return test('curried', function(){
    var f;
    f = countBy(floor);
    return deepEq({
      4: 1,
      6: 2
    }, f([4.2, 6.1, 6.4]));
  });
});
suite('group-by', function(){
  test('empty list as input', function(){
    return deepEq({}, groupBy(id, []));
  });
  test('list of numbers', function(){
    return deepEq({
      4: [4.2],
      6: [6.1, 6.4]
    }, groupBy(floor, [4.2, 6.1, 6.4]));
  });
  test('list of strings', function(){
    return deepEq({
      3: ['one', 'two'],
      5: ['three']
    }, groupBy(function(it){
      return it.length;
    }, ['one', 'two', 'three']));
  });
  return test('curried', function(){
    var f;
    f = groupBy(floor);
    return deepEq({
      4: [4.2],
      6: [6.1, 6.4]
    }, f([4.2, 6.1, 6.4]));
  });
});
suite('and-list', function(){
  test('empty list as input', function(){
    return ok(andList([]));
  });
  test('true', function(){
    return ok(andList([true, 2 + 2 === 4]));
  });
  return test('false', function(){
    return ok(!andList([true, true, false, true]));
  });
});
suite('or-list', function(){
  test('empty list as input', function(){
    return ok(!orList([]));
  });
  test('true', function(){
    return ok(orList([false, false, false, true, false]));
  });
  return test('false', function(){
    return ok(!orList([false, 2 + 2 === 3]));
  });
});
suite('any', function(){
  test('empty list as input', function(){
    return ok(!any(id, []));
  });
  test('true', function(){
    return ok(any(even, [1, 4, 3]));
  });
  test('false', function(){
    return ok(!any(even, [1, 3, 7, 5]));
  });
  return test('curried', function(){
    var f;
    f = any(even);
    return ok(f([1, 4, 3]));
  });
});
suite('all', function(){
  test('empty list as input', function(){
    return ok(all(even, []));
  });
  test('true', function(){
    return ok(all(even, [2, 4, 6]));
  });
  test('false', function(){
    return ok(!all(even, [2, 5, 6]));
  });
  return test('curried', function(){
    var f;
    f = all(even);
    return ok(f([2, 4, 6]));
  });
});
suite('sort', function(){
  test('empty list as input', function(){
    return deepEq([], sort([]));
  });
  test('single digit numbers', function(){
    return deepEq([1, 2, 3, 4, 5, 6], sort([3, 1, 5, 2, 4, 6]));
  });
  test('multi digit numbers', function(){
    return deepEq([2, 5, 6, 12, 334, 4999], sort([334, 12, 5, 2, 4999, 6]));
  });
  return test('same digits', function(){
    return deepEq([1, 2, 2, 2, 3], sort([2, 3, 2, 1, 2]));
  });
});
suite('sort-with', function(){
  var f;
  f = function(x, y){
    switch (false) {
    case !(x.length > y.length):
      return 1;
    case !(x.length < y.length):
      return -1;
    default:
      return 0;
    }
  };
  test('empty list as input', function(){
    return deepEq([], sortWith(id, []));
  });
  test('complex case', function(){
    return deepEq(['one', 'two', 'three'], sortWith(f, ['three', 'one', 'two']));
  });
  return test('curried', function(){
    var g;
    g = sortWith(f);
    return deepEq(['one', 'two', 'three'], g(['three', 'one', 'two']));
  });
});
suite('sort-by', function(){
  var arr;
  arr = ['hey', 'a', 'there', 'hey', 'ha'];
  test('empty list as input', function(){
    return deepEq([], sortBy(id, []));
  });
  test('complex case', function(){
    return deepEq(['a', 'ha', 'hey', 'hey', 'there'], sortBy(function(it){
      return it.length;
    }, arr));
  });
  return test('curried', function(){
    var f;
    f = sortBy(function(it){
      return it.length;
    });
    return deepEq(['a', 'ha', 'hey', 'hey', 'there'], f(arr));
  });
});
suite('sum', function(){
  test('empty list as input', function(){
    return eq(0, sum([]));
  });
  test('list as input', function(){
    return eq(10, sum([1, 2, 3, 4]));
  });
  return test('negative numbers', function(){
    return eq(-2, sum([1, -2, 3, -4]));
  });
});
suite('product', function(){
  test('empty list as input', function(){
    return eq(1, product([]));
  });
  test('list as input', function(){
    return eq(24, product([1, 2, 3, 4]));
  });
  return test('negative numbers', function(){
    return eq(-6, product([1, -2, 3]));
  });
});
suite('mean', function(){
  test('empty list as input', function(){
    return ok(isItNaN(mean([])));
  });
  test('list as input', function(){
    return eq(4, mean([2, 3, 4, 5, 6]));
  });
  return test('average as alias', function(){
    return eq(mean, average);
  });
});
suite('maximum', function(){
  test('empty list as input', function(){
    return eq(void 8, maximum([]));
  });
  test('single element list', function(){
    return eq(1, maximum([1]));
  });
  return test('multi element list', function(){
    return eq(6, maximum([1, 2, 6, 4, 5]));
  });
});
suite('minimum', function(){
  test('empty list as input', function(){
    return eq(void 8, minimum([]));
  });
  test('single element list', function(){
    return eq(1, minimum([1]));
  });
  test('multi element list', function(){
    return eq(2, minimum([4, 3, 2, 6, 9]));
  });
  return test('list of strings', function(){
    return eq('a', minimum(['c', 'e', 'a', 'd', 'b']));
  });
});
suite('maximum-by', function(){
  test('empty list as input', function(){
    return eq(void 8, maximumBy(id, []));
  });
  test('single element list', function(){
    return eq(1, maximumBy(id, [1]));
  });
  test('multi element list', function(){
    return eq('long-string', maximumBy(function(it){
      return it.length;
    }, ['hi', 'there', 'I', 'am', 'a', 'really', 'long-string']));
  });
  return test('curried', function(){
    return eq(2, maximumBy(id)([1, 2, 0]));
  });
});
suite('minimum-by', function(){
  test('empty list as input', function(){
    return eq(void 8, minimumBy(id, []));
  });
  test('single element list', function(){
    return eq(1, minimumBy(id, [1]));
  });
  test('multi element list', function(){
    return eq('I', minimumBy(function(it){
      return it.length;
    }, ['hi', 'there', 'I', 'am', 'a', 'really', 'long-string']));
  });
  return test('curried', function(){
    return eq(0, minimumBy(id)([1, 2, 0]));
  });
});
suite('scan', function(){
  test('empty list as input', function(){
    return deepEq([null], scan(id, null, []));
  });
  test('complex case', function(){
    return deepEq([4, 9, 20, 43], scan(function(x, y){
      return 2 * x + y;
    }, 4, [1, 2, 3]));
  });
  test('scanl as alias', function(){
    return eq(scan, scanl);
  });
  return test('curried', function(){
    var f, g;
    f = scan(function(x, y){
      return 2 * x + y;
    });
    deepEq([4, 9, 20, 43], f(4, [1, 2, 3]));
    g = scan(function(x, y){
      return 2 * x + y;
    }, 4);
    return deepEq([4, 9, 20, 43], g([1, 2, 3]));
  });
});
suite('scan1', function(){
  test('empty list as input', function(){
    return deepEq(void 8, scan1(id, []));
  });
  test('complex case', function(){
    return deepEq([1, 3, 6, 10], scan1(curry$(function(x$, y$){
      return x$ + y$;
    }), [1, 2, 3, 4]));
  });
  test('scanl1 as alias', function(){
    return eq(scan1, scanl1);
  });
  return test('curried', function(){
    var f;
    f = scan1(curry$(function(x$, y$){
      return x$ + y$;
    }));
    return deepEq([1, 3, 6, 10], f([1, 2, 3, 4]));
  });
});
suite('scanr', function(){
  test('empty list as input', function(){
    return deepEq([null], scanr(id, null, []));
  });
  test('complex case', function(){
    return deepEq([15, 14, 12, 9, 5], scanr(curry$(function(x$, y$){
      return x$ + y$;
    }), 5, [1, 2, 3, 4]));
  });
  return test('curried', function(){
    var f, g;
    f = scanr(curry$(function(x$, y$){
      return x$ + y$;
    }));
    deepEq([15, 14, 12, 9, 5], f(5, [1, 2, 3, 4]));
    g = scanr(curry$(function(x$, y$){
      return x$ + y$;
    }), 5);
    return deepEq([15, 14, 12, 9, 5], g([1, 2, 3, 4]));
  });
});
suite('scanr1', function(){
  test('empty list as input', function(){
    return deepEq(void 8, scanr1(id, []));
  });
  test('complex case', function(){
    return deepEq([10, 9, 7, 4], scanr1(curry$(function(x$, y$){
      return x$ + y$;
    }), [1, 2, 3, 4]));
  });
  return test('curried', function(){
    var f;
    f = scanr1(curry$(function(x$, y$){
      return x$ + y$;
    }));
    return deepEq([10, 9, 7, 4], f([1, 2, 3, 4]));
  });
});
suite('slice', function(){
  test('zero to zero', function(){
    return deepEq([], slice(0, 0, [1, 2, 3, 4, 5]));
  });
  test('empty lsit as input', function(){
    return deepEq([], slice(2, 3, []));
  });
  test('parts', function(){
    return deepEq([3, 4], slice(2, 4, [1, 2, 3, 4, 5]));
  });
  return test('curried', function(){
    var f, g;
    f = slice(2);
    deepEq([3, 4], f(4, [1, 2, 3, 4, 5]));
    g = slice(2, 4);
    return deepEq([3, 4], g([1, 2, 3, 4, 5]));
  });
});
suite('take', function(){
  test('empty list as input', function(){
    return deepEq([], take(3, []));
  });
  test('zero on list', function(){
    return deepEq([], take(0, [1, 2, 3, 4, 5]));
  });
  test('negative number', function(){
    return deepEq([], take(-1, [1, 2, 3, 4, 5]));
  });
  test('too big number', function(){
    return deepEq([1, 2, 3, 4, 5], take(9, [1, 2, 3, 4, 5]));
  });
  test('list', function(){
    return deepEq([1, 2, 3], take(3, [1, 2, 3, 4, 5]));
  });
  return test('curried', function(){
    var f;
    f = take(3);
    return deepEq([1, 2, 3], f([1, 2, 3, 4, 5]));
  });
});
suite('drop', function(){
  test('empty list as input', function(){
    return deepEq([], drop(3, []));
  });
  test('zero on list', function(){
    return deepEq([1, 2, 3, 4, 5], drop(0, [1, 2, 3, 4, 5]));
  });
  test('negative number', function(){
    return deepEq([1, 2, 3, 4, 5], drop(-1, [1, 2, 3, 4, 5]));
  });
  test('too big number', function(){
    return deepEq([], drop(9, [1, 2, 3, 4, 5]));
  });
  test('list', function(){
    return deepEq([4, 5], drop(3, [1, 2, 3, 4, 5]));
  });
  return test('curried', function(){
    var f;
    f = drop(3);
    return deepEq([4, 5], f([1, 2, 3, 4, 5]));
  });
});
suite('split-at', function(){
  test('empty list as input', function(){
    return deepEq([[], []], splitAt(3, []));
  });
  test('zero on list', function(){
    return deepEq([[], [1, 2, 3, 4, 5]], splitAt(0, [1, 2, 3, 4, 5]));
  });
  test('negative number', function(){
    return deepEq([[], [1, 2, 3, 4, 5]], splitAt(-1, [1, 2, 3, 4, 5]));
  });
  test('too big number', function(){
    return deepEq([[1, 2, 3, 4, 5], []], splitAt(9, [1, 2, 3, 4, 5]));
  });
  test('list', function(){
    return deepEq([[1, 2, 3], [4, 5]], splitAt(3, [1, 2, 3, 4, 5]));
  });
  return test('curried', function(){
    var f;
    f = splitAt(3);
    return deepEq([[1, 2, 3], [4, 5]], f([1, 2, 3, 4, 5]));
  });
});
suite('take-while', function(){
  test('empty list as input', function(){
    return deepEq([], takeWhile(id, []));
  });
  test('list', function(){
    return deepEq([1, 3, 5], takeWhile(odd, [1, 3, 5, 4, 8, 7, 9]));
  });
  test('all pass', function(){
    deepEq([42], takeWhile((function(it){
      return it === 42;
    }), [42]));
    return deepEq([2, 4, 8], takeWhile(even, [2, 4, 8]));
  });
  test('all fail', function(){
    deepEq([], takeWhile((function(it){
      return it === 7;
    }), [42]));
    return deepEq([], takeWhile(odd, [2, 4, 8]));
  });
  return test('curried', function(){
    var f;
    f = takeWhile(odd);
    return deepEq([1, 3, 5], f([1, 3, 5, 4, 8, 7, 9]));
  });
});
suite('drop-while', function(){
  test('empty list as input', function(){
    return deepEq([], dropWhile(id, []));
  });
  test('list', function(){
    return deepEq([7, 9, 10], dropWhile(even, [2, 4, 6, 7, 9, 10]));
  });
  test('all pass', function(){
    deepEq([], dropWhile((function(it){
      return it === 42;
    }), [42]));
    return deepEq([], dropWhile(even, [2, 4, 8]));
  });
  test('all-fail', function(){
    deepEq([42], dropWhile((function(it){
      return it === 7;
    }), [42]));
    return deepEq([2, 4, 8], dropWhile(odd, [2, 4, 8]));
  });
  return test('curried', function(){
    var f;
    f = dropWhile(even);
    return deepEq([7, 9, 10], f([2, 4, 6, 7, 9, 10]));
  });
});
suite('span', function(){
  test('empty list as input', function(){
    return deepEq([[], []], span(id, []));
  });
  test('list', function(){
    return deepEq([[2, 4, 6], [7, 9, 10]], span(even, [2, 4, 6, 7, 9, 10]));
  });
  return test('curried', function(){
    var f;
    f = span(even);
    return deepEq([[2, 4, 6], [7, 9, 10]], f([2, 4, 6, 7, 9, 10]));
  });
});
suite('break-list', function(){
  test('empty list as input', function(){
    return deepEq([[], []], breakList(id, []));
  });
  test('list', function(){
    return deepEq([[1, 2], [3, 4, 5]], breakList((function(it){
      return it === 3;
    }), [1, 2, 3, 4, 5]));
  });
  return test('curried', function(){
    var f;
    f = breakList((function(it){
      return it === 3;
    }));
    return deepEq([[1, 2], [3, 4, 5]], f([1, 2, 3, 4, 5]));
  });
});
suite('zip', function(){
  test('empty lists as input', function(){
    return deepEq([], zip([], []));
  });
  test('equal length lists', function(){
    return deepEq([[1, 4], [2, 5]], zip([1, 2], [4, 5]));
  });
  test('first list shorter', function(){
    return deepEq([[1, 4], [2, 5]], zip([1, 2], [4, 5, 6]));
  });
  test('second list shorter', function(){
    return deepEq([[1, 4], [2, 5]], zip([1, 2, 3], [4, 5]));
  });
  return test('curried', function(){
    var f;
    f = zip([1, 2]);
    return deepEq([[1, 4], [2, 5]], f([4, 5]));
  });
});
suite('zip-with', function(){
  test('empty lists as input', function(){
    return deepEq([], zipWith(id, [], []));
  });
  test('equal length lists', function(){
    return deepEq([4, 4, 4], zipWith(curry$(function(x$, y$){
      return x$ + y$;
    }), [1, 2, 3], [3, 2, 1]));
  });
  test('first list shorter', function(){
    return deepEq([5, 7], zipWith(curry$(function(x$, y$){
      return x$ + y$;
    }), [1, 2], [4, 5, 6]));
  });
  test('second list shorter', function(){
    return deepEq([5, 7], zipWith(curry$(function(x$, y$){
      return x$ + y$;
    }), [1, 2, 3], [4, 5]));
  });
  return test('curried', function(){
    var f, g;
    f = zipWith(curry$(function(x$, y$){
      return x$ + y$;
    }));
    deepEq([4, 4, 4], f([1, 2, 3], [3, 2, 1]));
    g = zipWith(curry$(function(x$, y$){
      return x$ + y$;
    }), [1, 2, 3]);
    return deepEq([4, 4, 4], g([3, 2, 1]));
  });
});
suite('zip-all', function(){
  test('no lists as input', function(){
    return deepEq([], zipAll());
  });
  test('empty lists as input', function(){
    return deepEq([], zipAll([], [], []));
  });
  test('equal length lists', function(){
    return deepEq([[1, 4, 7], [2, 5, 8], [3, 6, 9]], zipAll([1, 2, 3], [4, 5, 6], [7, 8, 9]));
  });
  test('first list shorter', function(){
    return deepEq([[1, 4, 7], [2, 5, 8]], zipAll([1, 2], [4, 5, 6], [7, 8, 9]));
  });
  test('second list shorter', function(){
    return deepEq([[1, 4, 7], [2, 5, 8]], zipAll([1, 2, 3], [4, 5], [7, 8, 9]));
  });
  return test('third list shorter', function(){
    return deepEq([[1, 4, 7], [2, 5, 8]], zipAll([1, 2, 3], [4, 5, 6], [7, 8]));
  });
});
suite('zip-all-with', function(){
  test('nothing as input', function(){
    return deepEq([], zipAllWith());
  });
  test('no lists as input', function(){
    return deepEq([], zipAllWith(id));
  });
  test('empty lists as input', function(){
    return deepEq([], zipAllWith(id, [], []));
  });
  test('equal length lists', function(){
    return deepEq([5, 5, 5], zipAllWith(function(){
      return arguments[0] + arguments[1] + arguments[2];
    }, [1, 2, 3], [3, 2, 1], [1, 1, 1]));
  });
  test('first list shorter', function(){
    return deepEq([5, 7], zipAllWith(curry$(function(x$, y$){
      return x$ + y$;
    }), [1, 2], [4, 5, 6]));
  });
  return test('second list shorter', function(){
    return deepEq([5, 7], zipAllWith(curry$(function(x$, y$){
      return x$ + y$;
    }), [1, 2, 3], [4, 5]));
  });
});
suite('at', function(){
  test('empty list as input', function(){
    return eq(void 8, at(0, []));
  });
  test('positive n', function(){
    return eq(2, at(1, [1, 2, 3]));
  });
  test('negative n', function(){
    return eq(3, at(-1, [1, 2, 3]));
  });
  test('not defined at index', function(){
    return eq(void 8, at(10, [1, 2, 3]));
  });
  return test('curried', function(){
    return eq(2, at(1)([1, 2, 3]));
  });
});
suite('elem-index', function(){
  test('empty list as input', function(){
    return eq(void 8, elemIndex(2, []));
  });
  test('basic', function(){
    return eq(1, elemIndex(2, [1, 2, 3]));
  });
  test('multiple', function(){
    return eq(1, elemIndex(2, [1, 2, 3, 2, 1]));
  });
  test('not there', function(){
    return eq(void 8, elemIndex(5, [1, 2, 3]));
  });
  return test('curried', function(){
    return eq(1, elemIndex(2)([1, 2, 3]));
  });
});
suite('elem-indices', function(){
  test('empty list as input', function(){
    return deepEq([], elemIndices(2, []));
  });
  test('single', function(){
    return deepEq([1], elemIndices(2, [1, 2, 3]));
  });
  test('multiple', function(){
    return deepEq([1, 3], elemIndices(2, [1, 2, 3, 2, 1]));
  });
  test('not there', function(){
    return deepEq([], elemIndices(5, [1, 2, 3]));
  });
  return test('curried', function(){
    return deepEq([1], elemIndices(2)([1, 2, 3]));
  });
});
suite('find-index', function(){
  test('empty list as input', function(){
    return eq(void 8, findIndex(id, []));
  });
  test('basic', function(){
    return eq(1, findIndex((function(it){
      return it === 2;
    }), [1, 2, 3]));
  });
  test('multiple', function(){
    return eq(1, findIndex(even, [1, 2, 3, 4]));
  });
  test('not there', function(){
    return eq(void 8, findIndex(odd, [2, 4, 6]));
  });
  return test('curried', function(){
    return eq(1, findIndex((function(it){
      return it === 2;
    }))([1, 2, 3]));
  });
});
suite('find-indices', function(){
  test('empty list as input', function(){
    return deepEq([], findIndices(id, []));
  });
  test('basic', function(){
    return deepEq([1], findIndices((function(it){
      return it === 2;
    }), [1, 2, 3]));
  });
  test('multiple', function(){
    return deepEq([1, 3], findIndices(even, [1, 2, 3, 4]));
  });
  test('not there', function(){
    return deepEq([], findIndices(odd, [2, 4, 6]));
  });
  return test('curried', function(){
    return deepEq([1], findIndices((function(it){
      return it === 2;
    }))([1, 2, 3]));
  });
});
function curry$(f, bound){
  var context,
  _curry = function(args) {
    return f.length > 1 ? function(){
      var params = args ? args.concat() : [];
      context = bound ? context || this : this;
      return params.push.apply(params, arguments) <
          f.length && arguments.length ?
        _curry.call(context, params) : f.apply(context, params);
    } : f;
  };
  return _curry();
}
