# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.batch import BatchManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-batch
# USAGE
    python create_pool__full_cloud_service_configuration.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = BatchManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="subid",
    )

    response = client.pool.create(
        resource_group_name="default-azurebatch-japaneast",
        account_name="sampleacct",
        pool_name="testpool",
        parameters={
            "properties": {
                "applicationLicenses": ["app-license0", "app-license1"],
                "applicationPackages": [
                    {
                        "id": "/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Batch/batchAccounts/sampleacct/pools/testpool/applications/app_1234",
                        "version": "asdf",
                    }
                ],
                "certificates": [
                    {
                        "id": "/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Batch/batchAccounts/sampleacct/pools/testpool/certificates/sha1-1234567",
                        "storeLocation": "LocalMachine",
                        "storeName": "MY",
                        "visibility": ["RemoteUser"],
                    }
                ],
                "deploymentConfiguration": {
                    "cloudServiceConfiguration": {"osFamily": "4", "osVersion": "WA-GUEST-OS-4.45_201708-01"}
                },
                "displayName": "my-pool-name",
                "interNodeCommunication": "Enabled",
                "metadata": [{"name": "metadata-1", "value": "value-1"}, {"name": "metadata-2", "value": "value-2"}],
                "networkConfiguration": {
                    "publicIPAddressConfiguration": {
                        "ipAddressIds": [
                            "/subscriptions/subid1/resourceGroups/rg13/providers/Microsoft.Network/publicIPAddresses/ip135",
                            "/subscriptions/subid2/resourceGroups/rg24/providers/Microsoft.Network/publicIPAddresses/ip268",
                        ],
                        "provision": "UserManaged",
                    },
                    "subnetId": "/subscriptions/subid/resourceGroups/rg1234/providers/Microsoft.Network/virtualNetworks/network1234/subnets/subnet123",
                },
                "scaleSettings": {
                    "fixedScale": {
                        "nodeDeallocationOption": "TaskCompletion",
                        "resizeTimeout": "PT8M",
                        "targetDedicatedNodes": 6,
                        "targetLowPriorityNodes": 28,
                    }
                },
                "startTask": {
                    "commandLine": "cmd /c SET",
                    "environmentSettings": [{"name": "MYSET", "value": "1234"}],
                    "maxTaskRetryCount": 6,
                    "resourceFiles": [
                        {
                            "fileMode": "777",
                            "filePath": "c:\\temp\\gohere",
                            "httpUrl": "https://testaccount.blob.core.windows.net/example-blob-file",
                        }
                    ],
                    "userIdentity": {"autoUser": {"elevationLevel": "Admin", "scope": "Pool"}},
                    "waitForSuccess": True,
                },
                "taskSchedulingPolicy": {"nodeFillType": "Pack"},
                "taskSlotsPerNode": 13,
                "userAccounts": [
                    {
                        "elevationLevel": "Admin",
                        "linuxUserConfiguration": {"gid": 4567, "sshPrivateKey": "sshprivatekeyvalue", "uid": 1234},
                        "name": "username1",
                        "password": "<ExamplePassword>",
                    }
                ],
                "vmSize": "STANDARD_D4",
            }
        },
    )
    print(response)


# x-ms-original-file: specification/batch/resource-manager/Microsoft.Batch/stable/2022-10-01/examples/PoolCreate_CloudServiceConfiguration.json
if __name__ == "__main__":
    main()
