# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from six import with_metaclass
from azure.core import CaseInsensitiveEnumMeta


class AccessRights(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    MANAGE = "Manage"
    SEND = "Send"
    LISTEN = "Listen"

class ClusterSkuName(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Name of this SKU.
    """

    DEDICATED = "Dedicated"

class CreatedByType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of identity that created the resource.
    """

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"

class DefaultAction(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Default Action for Network Rule Set
    """

    ALLOW = "Allow"
    DENY = "Deny"

class EncodingCaptureDescription(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Enumerates the possible values for the encoding format of capture description. Note:
    'AvroDeflate' will be deprecated in New API Version
    """

    AVRO = "Avro"
    AVRO_DEFLATE = "AvroDeflate"

class EndPointProvisioningState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Provisioning state of the Private Endpoint Connection.
    """

    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    CANCELED = "Canceled"
    FAILED = "Failed"

class EntityStatus(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Enumerates the possible values for the status of the Event Hub.
    """

    ACTIVE = "Active"
    DISABLED = "Disabled"
    RESTORING = "Restoring"
    SEND_DISABLED = "SendDisabled"
    RECEIVE_DISABLED = "ReceiveDisabled"
    CREATING = "Creating"
    DELETING = "Deleting"
    RENAMING = "Renaming"
    UNKNOWN = "Unknown"

class KeyType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The access key to regenerate.
    """

    PRIMARY_KEY = "PrimaryKey"
    SECONDARY_KEY = "SecondaryKey"

class ManagedServiceIdentityType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Type of managed service identity.
    """

    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned, UserAssigned"
    NONE = "None"

class NetworkRuleIPAction(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The IP Filter Action
    """

    ALLOW = "Allow"

class PrivateLinkConnectionStatus(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Status of the connection.
    """

    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"
    DISCONNECTED = "Disconnected"

class ProvisioningStateDR(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Provisioning state of the Alias(Disaster Recovery configuration) - possible values 'Accepted'
    or 'Succeeded' or 'Failed'
    """

    ACCEPTED = "Accepted"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"

class PublicNetworkAccessFlag(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """This determines if traffic is allowed over public network. By default it is enabled.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class RoleDisasterRecovery(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """role of namespace in GEO DR - possible values 'Primary' or 'PrimaryNotReplicating' or
    'Secondary'
    """

    PRIMARY = "Primary"
    PRIMARY_NOT_REPLICATING = "PrimaryNotReplicating"
    SECONDARY = "Secondary"

class SkuName(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Name of this SKU.
    """

    BASIC = "Basic"
    STANDARD = "Standard"
    PREMIUM = "Premium"

class SkuTier(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The billing tier of this particular SKU.
    """

    BASIC = "Basic"
    STANDARD = "Standard"
    PREMIUM = "Premium"

class UnavailableReason(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Specifies the reason for the unavailability of the service.
    """

    NONE = "None"
    INVALID_NAME = "InvalidName"
    SUBSCRIPTION_IS_DISABLED = "SubscriptionIsDisabled"
    NAME_IN_USE = "NameInUse"
    NAME_IN_LOCKDOWN = "NameInLockdown"
    TOO_MANY_NAMESPACE_IN_CURRENT_SUBSCRIPTION = "TooManyNamespaceInCurrentSubscription"
