# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AnalysisInput(_serialization.Model):
    """AnalysisInput.

    All required parameters must be populated in order to send to Azure.

    :ivar analysis_input: Contains a set of input documents to be analyzed by the service.
     Required.
    :vartype analysis_input: ~azure.ai.textanalytics.v3_1.models.MultiLanguageBatchInput
    """

    _validation = {
        'analysis_input': {'required': True},
    }

    _attribute_map = {
        "analysis_input": {"key": "analysisInput", "type": "MultiLanguageBatchInput"},
    }

    def __init__(
        self,
        *,
        analysis_input: "_models.MultiLanguageBatchInput",
        **kwargs
    ):
        """
        :keyword analysis_input: Contains a set of input documents to be analyzed by the service.
         Required.
        :paramtype analysis_input: ~azure.ai.textanalytics.v3_1.models.MultiLanguageBatchInput
        """
        super().__init__(**kwargs)
        self.analysis_input = analysis_input


class JobManifest(_serialization.Model):
    """JobManifest.

    All required parameters must be populated in order to send to Azure.

    :ivar tasks: The set of tasks to execute on the input documents. Cannot specify the same task
     more than once. Required.
    :vartype tasks: ~azure.ai.textanalytics.v3_1.models.JobManifestTasks
    """

    _validation = {
        'tasks': {'required': True},
    }

    _attribute_map = {
        "tasks": {"key": "tasks", "type": "JobManifestTasks"},
    }

    def __init__(
        self,
        *,
        tasks: "_models.JobManifestTasks",
        **kwargs
    ):
        """
        :keyword tasks: The set of tasks to execute on the input documents. Cannot specify the same
         task more than once. Required.
        :paramtype tasks: ~azure.ai.textanalytics.v3_1.models.JobManifestTasks
        """
        super().__init__(**kwargs)
        self.tasks = tasks


class JobDescriptor(_serialization.Model):
    """JobDescriptor.

    :ivar display_name: Optional display name for the analysis job.
    :vartype display_name: str
    """

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword display_name: Optional display name for the analysis job.
        :paramtype display_name: str
        """
        super().__init__(**kwargs)
        self.display_name = display_name


class AnalyzeBatchInput(JobDescriptor, AnalysisInput, JobManifest):
    """AnalyzeBatchInput.

    All required parameters must be populated in order to send to Azure.

    :ivar tasks: The set of tasks to execute on the input documents. Cannot specify the same task
     more than once. Required.
    :vartype tasks: ~azure.ai.textanalytics.v3_1.models.JobManifestTasks
    :ivar analysis_input: Contains a set of input documents to be analyzed by the service.
     Required.
    :vartype analysis_input: ~azure.ai.textanalytics.v3_1.models.MultiLanguageBatchInput
    :ivar display_name: Optional display name for the analysis job.
    :vartype display_name: str
    """

    _validation = {
        'tasks': {'required': True},
        'analysis_input': {'required': True},
    }

    _attribute_map = {
        "tasks": {"key": "tasks", "type": "JobManifestTasks"},
        "analysis_input": {"key": "analysisInput", "type": "MultiLanguageBatchInput"},
        "display_name": {"key": "displayName", "type": "str"},
    }

    def __init__(
        self,
        *,
        tasks: "_models.JobManifestTasks",
        analysis_input: "_models.MultiLanguageBatchInput",
        display_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tasks: The set of tasks to execute on the input documents. Cannot specify the same
         task more than once. Required.
        :paramtype tasks: ~azure.ai.textanalytics.v3_1.models.JobManifestTasks
        :keyword analysis_input: Contains a set of input documents to be analyzed by the service.
         Required.
        :paramtype analysis_input: ~azure.ai.textanalytics.v3_1.models.MultiLanguageBatchInput
        :keyword display_name: Optional display name for the analysis job.
        :paramtype display_name: str
        """
        super().__init__(display_name=display_name, analysis_input=analysis_input, tasks=tasks, **kwargs)
        self.tasks = tasks
        self.analysis_input = analysis_input
        self.display_name = display_name


class AnalyzeJobDisplayName(_serialization.Model):
    """AnalyzeJobDisplayName.

    :ivar display_name:
    :vartype display_name: str
    """

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword display_name:
        :paramtype display_name: str
        """
        super().__init__(**kwargs)
        self.display_name = display_name


class AnalyzeJobErrorsAndStatistics(_serialization.Model):
    """AnalyzeJobErrorsAndStatistics.

    :ivar errors:
    :vartype errors: list[~azure.ai.textanalytics.v3_1.models.TextAnalyticsError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_1.models.RequestStatistics
    """

    _attribute_map = {
        "errors": {"key": "errors", "type": "[TextAnalyticsError]"},
        "statistics": {"key": "statistics", "type": "RequestStatistics"},
    }

    def __init__(
        self,
        *,
        errors: Optional[List["_models.TextAnalyticsError"]] = None,
        statistics: Optional["_models.RequestStatistics"] = None,
        **kwargs
    ):
        """
        :keyword errors:
        :paramtype errors: list[~azure.ai.textanalytics.v3_1.models.TextAnalyticsError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_1.models.RequestStatistics
        """
        super().__init__(**kwargs)
        self.errors = errors
        self.statistics = statistics


class JobMetadata(_serialization.Model):
    """JobMetadata.

    All required parameters must be populated in order to send to Azure.

    :ivar created_date_time: Required.
    :vartype created_date_time: ~datetime.datetime
    :ivar expiration_date_time:
    :vartype expiration_date_time: ~datetime.datetime
    :ivar job_id: Required.
    :vartype job_id: str
    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
     "rejected", "cancelled", and "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.v3_1.models.State
    """

    _validation = {
        'created_date_time': {'required': True},
        'job_id': {'required': True},
        'last_update_date_time': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        "created_date_time": {"key": "createdDateTime", "type": "iso-8601"},
        "expiration_date_time": {"key": "expirationDateTime", "type": "iso-8601"},
        "job_id": {"key": "jobId", "type": "str"},
        "last_update_date_time": {"key": "lastUpdateDateTime", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        created_date_time: datetime.datetime,
        job_id: str,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.State"],
        expiration_date_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_date_time: Required.
        :paramtype created_date_time: ~datetime.datetime
        :keyword expiration_date_time:
        :paramtype expiration_date_time: ~datetime.datetime
        :keyword job_id: Required.
        :paramtype job_id: str
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
         "rejected", "cancelled", and "cancelling".
        :paramtype status: str or ~azure.ai.textanalytics.v3_1.models.State
        """
        super().__init__(**kwargs)
        self.created_date_time = created_date_time
        self.expiration_date_time = expiration_date_time
        self.job_id = job_id
        self.last_update_date_time = last_update_date_time
        self.status = status


class AnalyzeJobMetadata(JobMetadata, AnalyzeJobDisplayName):
    """AnalyzeJobMetadata.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name:
    :vartype display_name: str
    :ivar created_date_time: Required.
    :vartype created_date_time: ~datetime.datetime
    :ivar expiration_date_time:
    :vartype expiration_date_time: ~datetime.datetime
    :ivar job_id: Required.
    :vartype job_id: str
    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
     "rejected", "cancelled", and "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.v3_1.models.State
    """

    _validation = {
        'created_date_time': {'required': True},
        'job_id': {'required': True},
        'last_update_date_time': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "created_date_time": {"key": "createdDateTime", "type": "iso-8601"},
        "expiration_date_time": {"key": "expirationDateTime", "type": "iso-8601"},
        "job_id": {"key": "jobId", "type": "str"},
        "last_update_date_time": {"key": "lastUpdateDateTime", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        created_date_time: datetime.datetime,
        job_id: str,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.State"],
        display_name: Optional[str] = None,
        expiration_date_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword display_name:
        :paramtype display_name: str
        :keyword created_date_time: Required.
        :paramtype created_date_time: ~datetime.datetime
        :keyword expiration_date_time:
        :paramtype expiration_date_time: ~datetime.datetime
        :keyword job_id: Required.
        :paramtype job_id: str
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
         "rejected", "cancelled", and "cancelling".
        :paramtype status: str or ~azure.ai.textanalytics.v3_1.models.State
        """
        super().__init__(created_date_time=created_date_time, expiration_date_time=expiration_date_time, job_id=job_id, last_update_date_time=last_update_date_time, status=status, display_name=display_name, **kwargs)
        self.display_name = display_name
        self.created_date_time = created_date_time
        self.expiration_date_time = expiration_date_time
        self.job_id = job_id
        self.last_update_date_time = last_update_date_time
        self.status = status


class Pagination(_serialization.Model):
    """Pagination.

    :ivar next_link:
    :vartype next_link: str
    """

    _attribute_map = {
        "next_link": {"key": "@nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword next_link:
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.next_link = next_link


class TasksState(_serialization.Model):
    """TasksState.

    All required parameters must be populated in order to send to Azure.

    :ivar tasks: Required.
    :vartype tasks: ~azure.ai.textanalytics.v3_1.models.TasksStateTasks
    """

    _validation = {
        'tasks': {'required': True},
    }

    _attribute_map = {
        "tasks": {"key": "tasks", "type": "TasksStateTasks"},
    }

    def __init__(
        self,
        *,
        tasks: "_models.TasksStateTasks",
        **kwargs
    ):
        """
        :keyword tasks: Required.
        :paramtype tasks: ~azure.ai.textanalytics.v3_1.models.TasksStateTasks
        """
        super().__init__(**kwargs)
        self.tasks = tasks


class AnalyzeJobState(AnalyzeJobMetadata, TasksState, AnalyzeJobErrorsAndStatistics, Pagination):
    """AnalyzeJobState.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link:
    :vartype next_link: str
    :ivar errors:
    :vartype errors: list[~azure.ai.textanalytics.v3_1.models.TextAnalyticsError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_1.models.RequestStatistics
    :ivar tasks: Required.
    :vartype tasks: ~azure.ai.textanalytics.v3_1.models.TasksStateTasks
    :ivar display_name:
    :vartype display_name: str
    :ivar created_date_time: Required.
    :vartype created_date_time: ~datetime.datetime
    :ivar expiration_date_time:
    :vartype expiration_date_time: ~datetime.datetime
    :ivar job_id: Required.
    :vartype job_id: str
    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
     "rejected", "cancelled", and "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.v3_1.models.State
    """

    _validation = {
        'tasks': {'required': True},
        'created_date_time': {'required': True},
        'job_id': {'required': True},
        'last_update_date_time': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        "next_link": {"key": "@nextLink", "type": "str"},
        "errors": {"key": "errors", "type": "[TextAnalyticsError]"},
        "statistics": {"key": "statistics", "type": "RequestStatistics"},
        "tasks": {"key": "tasks", "type": "TasksStateTasks"},
        "display_name": {"key": "displayName", "type": "str"},
        "created_date_time": {"key": "createdDateTime", "type": "iso-8601"},
        "expiration_date_time": {"key": "expirationDateTime", "type": "iso-8601"},
        "job_id": {"key": "jobId", "type": "str"},
        "last_update_date_time": {"key": "lastUpdateDateTime", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        tasks: "_models.TasksStateTasks",
        created_date_time: datetime.datetime,
        job_id: str,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.State"],
        next_link: Optional[str] = None,
        errors: Optional[List["_models.TextAnalyticsError"]] = None,
        statistics: Optional["_models.RequestStatistics"] = None,
        display_name: Optional[str] = None,
        expiration_date_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword next_link:
        :paramtype next_link: str
        :keyword errors:
        :paramtype errors: list[~azure.ai.textanalytics.v3_1.models.TextAnalyticsError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_1.models.RequestStatistics
        :keyword tasks: Required.
        :paramtype tasks: ~azure.ai.textanalytics.v3_1.models.TasksStateTasks
        :keyword display_name:
        :paramtype display_name: str
        :keyword created_date_time: Required.
        :paramtype created_date_time: ~datetime.datetime
        :keyword expiration_date_time:
        :paramtype expiration_date_time: ~datetime.datetime
        :keyword job_id: Required.
        :paramtype job_id: str
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
         "rejected", "cancelled", and "cancelling".
        :paramtype status: str or ~azure.ai.textanalytics.v3_1.models.State
        """
        super().__init__(display_name=display_name, created_date_time=created_date_time, expiration_date_time=expiration_date_time, job_id=job_id, last_update_date_time=last_update_date_time, status=status, tasks=tasks, errors=errors, statistics=statistics, next_link=next_link, **kwargs)
        self.next_link = next_link
        self.errors = errors
        self.statistics = statistics
        self.tasks = tasks
        self.display_name = display_name
        self.created_date_time = created_date_time
        self.expiration_date_time = expiration_date_time
        self.job_id = job_id
        self.last_update_date_time = last_update_date_time
        self.status = status


class DetectedLanguage(_serialization.Model):
    """DetectedLanguage.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Long name of a detected language (e.g. English, French). Required.
    :vartype name: str
    :ivar iso6391_name: A two letter representation of the detected language according to the ISO
     639-1 standard (e.g. en, fr). Required.
    :vartype iso6391_name: str
    :ivar confidence_score: A confidence score between 0 and 1. Scores close to 1 indicate 100%
     certainty that the identified language is true. Required.
    :vartype confidence_score: float
    """

    _validation = {
        'name': {'required': True},
        'iso6391_name': {'required': True},
        'confidence_score': {'required': True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "iso6391_name": {"key": "iso6391Name", "type": "str"},
        "confidence_score": {"key": "confidenceScore", "type": "float"},
    }

    def __init__(
        self,
        *,
        name: str,
        iso6391_name: str,
        confidence_score: float,
        **kwargs
    ):
        """
        :keyword name: Long name of a detected language (e.g. English, French). Required.
        :paramtype name: str
        :keyword iso6391_name: A two letter representation of the detected language according to the
         ISO 639-1 standard (e.g. en, fr). Required.
        :paramtype iso6391_name: str
        :keyword confidence_score: A confidence score between 0 and 1. Scores close to 1 indicate 100%
         certainty that the identified language is true. Required.
        :paramtype confidence_score: float
        """
        super().__init__(**kwargs)
        self.name = name
        self.iso6391_name = iso6391_name
        self.confidence_score = confidence_score


class DocumentEntities(_serialization.Model):
    """DocumentEntities.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar entities: Recognized entities in the document. Required.
    :vartype entities: list[~azure.ai.textanalytics.v3_1.models.Entity]
    :ivar warnings: Warnings encountered while processing document. Required.
    :vartype warnings: list[~azure.ai.textanalytics.v3_1.models.TextAnalyticsWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_1.models.DocumentStatistics
    """

    _validation = {
        'id': {'required': True},
        'entities': {'required': True},
        'warnings': {'required': True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "entities": {"key": "entities", "type": "[Entity]"},
        "warnings": {"key": "warnings", "type": "[TextAnalyticsWarning]"},
        "statistics": {"key": "statistics", "type": "DocumentStatistics"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        entities: List["_models.Entity"],
        warnings: List["_models.TextAnalyticsWarning"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Unique, non-empty document identifier. Required.
        :paramtype id: str
        :keyword entities: Recognized entities in the document. Required.
        :paramtype entities: list[~azure.ai.textanalytics.v3_1.models.Entity]
        :keyword warnings: Warnings encountered while processing document. Required.
        :paramtype warnings: list[~azure.ai.textanalytics.v3_1.models.TextAnalyticsWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_1.models.DocumentStatistics
        """
        super().__init__(**kwargs)
        self.id = id
        self.entities = entities
        self.warnings = warnings
        self.statistics = statistics


class DocumentError(_serialization.Model):
    """DocumentError.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Document Id. Required.
    :vartype id: str
    :ivar error: Document Error. Required.
    :vartype error: ~azure.ai.textanalytics.v3_1.models.TextAnalyticsError
    """

    _validation = {
        'id': {'required': True},
        'error': {'required': True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "error": {"key": "error", "type": "TextAnalyticsError"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        error: "_models.TextAnalyticsError",
        **kwargs
    ):
        """
        :keyword id: Document Id. Required.
        :paramtype id: str
        :keyword error: Document Error. Required.
        :paramtype error: ~azure.ai.textanalytics.v3_1.models.TextAnalyticsError
        """
        super().__init__(**kwargs)
        self.id = id
        self.error = error


class DocumentHealthcareEntities(_serialization.Model):
    """DocumentHealthcareEntities.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar entities: Healthcare entities. Required.
    :vartype entities: list[~azure.ai.textanalytics.v3_1.models.HealthcareEntity]
    :ivar relations: Healthcare entity relations. Required.
    :vartype relations: list[~azure.ai.textanalytics.v3_1.models.HealthcareRelation]
    :ivar warnings: Warnings encountered while processing document. Required.
    :vartype warnings: list[~azure.ai.textanalytics.v3_1.models.TextAnalyticsWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_1.models.DocumentStatistics
    """

    _validation = {
        'id': {'required': True},
        'entities': {'required': True},
        'relations': {'required': True},
        'warnings': {'required': True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "entities": {"key": "entities", "type": "[HealthcareEntity]"},
        "relations": {"key": "relations", "type": "[HealthcareRelation]"},
        "warnings": {"key": "warnings", "type": "[TextAnalyticsWarning]"},
        "statistics": {"key": "statistics", "type": "DocumentStatistics"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        entities: List["_models.HealthcareEntity"],
        relations: List["_models.HealthcareRelation"],
        warnings: List["_models.TextAnalyticsWarning"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Unique, non-empty document identifier. Required.
        :paramtype id: str
        :keyword entities: Healthcare entities. Required.
        :paramtype entities: list[~azure.ai.textanalytics.v3_1.models.HealthcareEntity]
        :keyword relations: Healthcare entity relations. Required.
        :paramtype relations: list[~azure.ai.textanalytics.v3_1.models.HealthcareRelation]
        :keyword warnings: Warnings encountered while processing document. Required.
        :paramtype warnings: list[~azure.ai.textanalytics.v3_1.models.TextAnalyticsWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_1.models.DocumentStatistics
        """
        super().__init__(**kwargs)
        self.id = id
        self.entities = entities
        self.relations = relations
        self.warnings = warnings
        self.statistics = statistics


class DocumentKeyPhrases(_serialization.Model):
    """DocumentKeyPhrases.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar key_phrases: A list of representative words or phrases. The number of key phrases
     returned is proportional to the number of words in the input document. Required.
    :vartype key_phrases: list[str]
    :ivar warnings: Warnings encountered while processing document. Required.
    :vartype warnings: list[~azure.ai.textanalytics.v3_1.models.TextAnalyticsWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_1.models.DocumentStatistics
    """

    _validation = {
        'id': {'required': True},
        'key_phrases': {'required': True},
        'warnings': {'required': True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "key_phrases": {"key": "keyPhrases", "type": "[str]"},
        "warnings": {"key": "warnings", "type": "[TextAnalyticsWarning]"},
        "statistics": {"key": "statistics", "type": "DocumentStatistics"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        key_phrases: List[str],
        warnings: List["_models.TextAnalyticsWarning"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Unique, non-empty document identifier. Required.
        :paramtype id: str
        :keyword key_phrases: A list of representative words or phrases. The number of key phrases
         returned is proportional to the number of words in the input document. Required.
        :paramtype key_phrases: list[str]
        :keyword warnings: Warnings encountered while processing document. Required.
        :paramtype warnings: list[~azure.ai.textanalytics.v3_1.models.TextAnalyticsWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_1.models.DocumentStatistics
        """
        super().__init__(**kwargs)
        self.id = id
        self.key_phrases = key_phrases
        self.warnings = warnings
        self.statistics = statistics


class DocumentLanguage(_serialization.Model):
    """DocumentLanguage.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar detected_language: Detected Language. Required.
    :vartype detected_language: ~azure.ai.textanalytics.v3_1.models.DetectedLanguage
    :ivar warnings: Warnings encountered while processing document. Required.
    :vartype warnings: list[~azure.ai.textanalytics.v3_1.models.TextAnalyticsWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_1.models.DocumentStatistics
    """

    _validation = {
        'id': {'required': True},
        'detected_language': {'required': True},
        'warnings': {'required': True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "detected_language": {"key": "detectedLanguage", "type": "DetectedLanguage"},
        "warnings": {"key": "warnings", "type": "[TextAnalyticsWarning]"},
        "statistics": {"key": "statistics", "type": "DocumentStatistics"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        detected_language: "_models.DetectedLanguage",
        warnings: List["_models.TextAnalyticsWarning"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Unique, non-empty document identifier. Required.
        :paramtype id: str
        :keyword detected_language: Detected Language. Required.
        :paramtype detected_language: ~azure.ai.textanalytics.v3_1.models.DetectedLanguage
        :keyword warnings: Warnings encountered while processing document. Required.
        :paramtype warnings: list[~azure.ai.textanalytics.v3_1.models.TextAnalyticsWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_1.models.DocumentStatistics
        """
        super().__init__(**kwargs)
        self.id = id
        self.detected_language = detected_language
        self.warnings = warnings
        self.statistics = statistics


class DocumentLinkedEntities(_serialization.Model):
    """DocumentLinkedEntities.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar entities: Recognized well known entities in the document. Required.
    :vartype entities: list[~azure.ai.textanalytics.v3_1.models.LinkedEntity]
    :ivar warnings: Warnings encountered while processing document. Required.
    :vartype warnings: list[~azure.ai.textanalytics.v3_1.models.TextAnalyticsWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_1.models.DocumentStatistics
    """

    _validation = {
        'id': {'required': True},
        'entities': {'required': True},
        'warnings': {'required': True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "entities": {"key": "entities", "type": "[LinkedEntity]"},
        "warnings": {"key": "warnings", "type": "[TextAnalyticsWarning]"},
        "statistics": {"key": "statistics", "type": "DocumentStatistics"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        entities: List["_models.LinkedEntity"],
        warnings: List["_models.TextAnalyticsWarning"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Unique, non-empty document identifier. Required.
        :paramtype id: str
        :keyword entities: Recognized well known entities in the document. Required.
        :paramtype entities: list[~azure.ai.textanalytics.v3_1.models.LinkedEntity]
        :keyword warnings: Warnings encountered while processing document. Required.
        :paramtype warnings: list[~azure.ai.textanalytics.v3_1.models.TextAnalyticsWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_1.models.DocumentStatistics
        """
        super().__init__(**kwargs)
        self.id = id
        self.entities = entities
        self.warnings = warnings
        self.statistics = statistics


class DocumentSentiment(_serialization.Model):
    """DocumentSentiment.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar sentiment: Predicted sentiment for document (Negative, Neutral, Positive, or Mixed).
     Required. Known values are: "positive", "neutral", "negative", and "mixed".
    :vartype sentiment: str or ~azure.ai.textanalytics.v3_1.models.DocumentSentimentValue
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_1.models.DocumentStatistics
    :ivar confidence_scores: Document level sentiment confidence scores between 0 and 1 for each
     sentiment class. Required.
    :vartype confidence_scores:
     ~azure.ai.textanalytics.v3_1.models.SentimentConfidenceScorePerLabel
    :ivar sentences: Sentence level sentiment analysis. Required.
    :vartype sentences: list[~azure.ai.textanalytics.v3_1.models.SentenceSentiment]
    :ivar warnings: Warnings encountered while processing document. Required.
    :vartype warnings: list[~azure.ai.textanalytics.v3_1.models.TextAnalyticsWarning]
    """

    _validation = {
        'id': {'required': True},
        'sentiment': {'required': True},
        'confidence_scores': {'required': True},
        'sentences': {'required': True},
        'warnings': {'required': True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "sentiment": {"key": "sentiment", "type": "str"},
        "statistics": {"key": "statistics", "type": "DocumentStatistics"},
        "confidence_scores": {"key": "confidenceScores", "type": "SentimentConfidenceScorePerLabel"},
        "sentences": {"key": "sentences", "type": "[SentenceSentiment]"},
        "warnings": {"key": "warnings", "type": "[TextAnalyticsWarning]"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        sentiment: Union[str, "_models.DocumentSentimentValue"],
        confidence_scores: "_models.SentimentConfidenceScorePerLabel",
        sentences: List["_models.SentenceSentiment"],
        warnings: List["_models.TextAnalyticsWarning"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Unique, non-empty document identifier. Required.
        :paramtype id: str
        :keyword sentiment: Predicted sentiment for document (Negative, Neutral, Positive, or Mixed).
         Required. Known values are: "positive", "neutral", "negative", and "mixed".
        :paramtype sentiment: str or ~azure.ai.textanalytics.v3_1.models.DocumentSentimentValue
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_1.models.DocumentStatistics
        :keyword confidence_scores: Document level sentiment confidence scores between 0 and 1 for each
         sentiment class. Required.
        :paramtype confidence_scores:
         ~azure.ai.textanalytics.v3_1.models.SentimentConfidenceScorePerLabel
        :keyword sentences: Sentence level sentiment analysis. Required.
        :paramtype sentences: list[~azure.ai.textanalytics.v3_1.models.SentenceSentiment]
        :keyword warnings: Warnings encountered while processing document. Required.
        :paramtype warnings: list[~azure.ai.textanalytics.v3_1.models.TextAnalyticsWarning]
        """
        super().__init__(**kwargs)
        self.id = id
        self.sentiment = sentiment
        self.statistics = statistics
        self.confidence_scores = confidence_scores
        self.sentences = sentences
        self.warnings = warnings


class DocumentStatistics(_serialization.Model):
    """if showStats=true was specified in the request this field will contain information about the document payload.

    All required parameters must be populated in order to send to Azure.

    :ivar characters_count: Number of text elements recognized in the document. Required.
    :vartype characters_count: int
    :ivar transactions_count: Number of transactions for the document. Required.
    :vartype transactions_count: int
    """

    _validation = {
        'characters_count': {'required': True},
        'transactions_count': {'required': True},
    }

    _attribute_map = {
        "characters_count": {"key": "charactersCount", "type": "int"},
        "transactions_count": {"key": "transactionsCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        characters_count: int,
        transactions_count: int,
        **kwargs
    ):
        """
        :keyword characters_count: Number of text elements recognized in the document. Required.
        :paramtype characters_count: int
        :keyword transactions_count: Number of transactions for the document. Required.
        :paramtype transactions_count: int
        """
        super().__init__(**kwargs)
        self.characters_count = characters_count
        self.transactions_count = transactions_count


class EntitiesResult(_serialization.Model):
    """EntitiesResult.

    All required parameters must be populated in order to send to Azure.

    :ivar documents: Response by document. Required.
    :vartype documents: list[~azure.ai.textanalytics.v3_1.models.DocumentEntities]
    :ivar errors: Errors by document id. Required.
    :vartype errors: list[~azure.ai.textanalytics.v3_1.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_1.models.RequestStatistics
    :ivar model_version: This field indicates which model is used for scoring. Required.
    :vartype model_version: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        "documents": {"key": "documents", "type": "[DocumentEntities]"},
        "errors": {"key": "errors", "type": "[DocumentError]"},
        "statistics": {"key": "statistics", "type": "RequestStatistics"},
        "model_version": {"key": "modelVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        documents: List["_models.DocumentEntities"],
        errors: List["_models.DocumentError"],
        model_version: str,
        statistics: Optional["_models.RequestStatistics"] = None,
        **kwargs
    ):
        """
        :keyword documents: Response by document. Required.
        :paramtype documents: list[~azure.ai.textanalytics.v3_1.models.DocumentEntities]
        :keyword errors: Errors by document id. Required.
        :paramtype errors: list[~azure.ai.textanalytics.v3_1.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_1.models.RequestStatistics
        :keyword model_version: This field indicates which model is used for scoring. Required.
        :paramtype model_version: str
        """
        super().__init__(**kwargs)
        self.documents = documents
        self.errors = errors
        self.statistics = statistics
        self.model_version = model_version


class EntitiesTask(_serialization.Model):
    """EntitiesTask.

    :ivar parameters:
    :vartype parameters: ~azure.ai.textanalytics.v3_1.models.EntitiesTaskParameters
    :ivar task_name:
    :vartype task_name: str
    """

    _attribute_map = {
        "parameters": {"key": "parameters", "type": "EntitiesTaskParameters"},
        "task_name": {"key": "taskName", "type": "str"},
    }

    def __init__(
        self,
        *,
        parameters: Optional["_models.EntitiesTaskParameters"] = None,
        task_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword parameters:
        :paramtype parameters: ~azure.ai.textanalytics.v3_1.models.EntitiesTaskParameters
        :keyword task_name:
        :paramtype task_name: str
        """
        super().__init__(**kwargs)
        self.parameters = parameters
        self.task_name = task_name


class EntitiesTaskParameters(_serialization.Model):
    """EntitiesTaskParameters.

    :ivar model_version:
    :vartype model_version: str
    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    :ivar string_index_type: Known values are: "TextElement_v8", "UnicodeCodePoint", and
     "Utf16CodeUnit".
    :vartype string_index_type: str or ~azure.ai.textanalytics.v3_1.models.StringIndexType
    """

    _attribute_map = {
        "model_version": {"key": "model-version", "type": "str"},
        "logging_opt_out": {"key": "loggingOptOut", "type": "bool"},
        "string_index_type": {"key": "stringIndexType", "type": "str"},
    }

    def __init__(
        self,
        *,
        model_version: str = "latest",
        logging_opt_out: bool = False,
        string_index_type: Optional[Union[str, "_models.StringIndexType"]] = None,
        **kwargs
    ):
        """
        :keyword model_version:
        :paramtype model_version: str
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        :keyword string_index_type: Known values are: "TextElement_v8", "UnicodeCodePoint", and
         "Utf16CodeUnit".
        :paramtype string_index_type: str or ~azure.ai.textanalytics.v3_1.models.StringIndexType
        """
        super().__init__(**kwargs)
        self.model_version = model_version
        self.logging_opt_out = logging_opt_out
        self.string_index_type = string_index_type


class EntitiesTaskResult(_serialization.Model):
    """EntitiesTaskResult.

    :ivar results:
    :vartype results: ~azure.ai.textanalytics.v3_1.models.EntitiesResult
    """

    _attribute_map = {
        "results": {"key": "results", "type": "EntitiesResult"},
    }

    def __init__(
        self,
        *,
        results: Optional["_models.EntitiesResult"] = None,
        **kwargs
    ):
        """
        :keyword results:
        :paramtype results: ~azure.ai.textanalytics.v3_1.models.EntitiesResult
        """
        super().__init__(**kwargs)
        self.results = results


class Entity(_serialization.Model):
    """Entity.

    All required parameters must be populated in order to send to Azure.

    :ivar text: Entity text as appears in the request. Required.
    :vartype text: str
    :ivar category: Entity type. Required.
    :vartype category: str
    :ivar subcategory: (Optional) Entity sub type.
    :vartype subcategory: str
    :ivar offset: Start position for the entity text. Use of different 'stringIndexType' values can
     affect the offset returned. Required.
    :vartype offset: int
    :ivar length: Length for the entity text. Use of different 'stringIndexType' values can affect
     the length returned. Required.
    :vartype length: int
    :ivar confidence_score: Confidence score between 0 and 1 of the extracted entity. Required.
    :vartype confidence_score: float
    """

    _validation = {
        'text': {'required': True},
        'category': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
        'confidence_score': {'required': True},
    }

    _attribute_map = {
        "text": {"key": "text", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "subcategory": {"key": "subcategory", "type": "str"},
        "offset": {"key": "offset", "type": "int"},
        "length": {"key": "length", "type": "int"},
        "confidence_score": {"key": "confidenceScore", "type": "float"},
    }

    def __init__(
        self,
        *,
        text: str,
        category: str,
        offset: int,
        length: int,
        confidence_score: float,
        subcategory: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword text: Entity text as appears in the request. Required.
        :paramtype text: str
        :keyword category: Entity type. Required.
        :paramtype category: str
        :keyword subcategory: (Optional) Entity sub type.
        :paramtype subcategory: str
        :keyword offset: Start position for the entity text. Use of different 'stringIndexType' values
         can affect the offset returned. Required.
        :paramtype offset: int
        :keyword length: Length for the entity text. Use of different 'stringIndexType' values can
         affect the length returned. Required.
        :paramtype length: int
        :keyword confidence_score: Confidence score between 0 and 1 of the extracted entity. Required.
        :paramtype confidence_score: float
        """
        super().__init__(**kwargs)
        self.text = text
        self.category = category
        self.subcategory = subcategory
        self.offset = offset
        self.length = length
        self.confidence_score = confidence_score


class EntityLinkingResult(_serialization.Model):
    """EntityLinkingResult.

    All required parameters must be populated in order to send to Azure.

    :ivar documents: Response by document. Required.
    :vartype documents: list[~azure.ai.textanalytics.v3_1.models.DocumentLinkedEntities]
    :ivar errors: Errors by document id. Required.
    :vartype errors: list[~azure.ai.textanalytics.v3_1.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_1.models.RequestStatistics
    :ivar model_version: This field indicates which model is used for scoring. Required.
    :vartype model_version: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        "documents": {"key": "documents", "type": "[DocumentLinkedEntities]"},
        "errors": {"key": "errors", "type": "[DocumentError]"},
        "statistics": {"key": "statistics", "type": "RequestStatistics"},
        "model_version": {"key": "modelVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        documents: List["_models.DocumentLinkedEntities"],
        errors: List["_models.DocumentError"],
        model_version: str,
        statistics: Optional["_models.RequestStatistics"] = None,
        **kwargs
    ):
        """
        :keyword documents: Response by document. Required.
        :paramtype documents: list[~azure.ai.textanalytics.v3_1.models.DocumentLinkedEntities]
        :keyword errors: Errors by document id. Required.
        :paramtype errors: list[~azure.ai.textanalytics.v3_1.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_1.models.RequestStatistics
        :keyword model_version: This field indicates which model is used for scoring. Required.
        :paramtype model_version: str
        """
        super().__init__(**kwargs)
        self.documents = documents
        self.errors = errors
        self.statistics = statistics
        self.model_version = model_version


class EntityLinkingTask(_serialization.Model):
    """EntityLinkingTask.

    :ivar parameters:
    :vartype parameters: ~azure.ai.textanalytics.v3_1.models.EntityLinkingTaskParameters
    :ivar task_name:
    :vartype task_name: str
    """

    _attribute_map = {
        "parameters": {"key": "parameters", "type": "EntityLinkingTaskParameters"},
        "task_name": {"key": "taskName", "type": "str"},
    }

    def __init__(
        self,
        *,
        parameters: Optional["_models.EntityLinkingTaskParameters"] = None,
        task_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword parameters:
        :paramtype parameters: ~azure.ai.textanalytics.v3_1.models.EntityLinkingTaskParameters
        :keyword task_name:
        :paramtype task_name: str
        """
        super().__init__(**kwargs)
        self.parameters = parameters
        self.task_name = task_name


class EntityLinkingTaskParameters(_serialization.Model):
    """EntityLinkingTaskParameters.

    :ivar model_version:
    :vartype model_version: str
    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    :ivar string_index_type: Known values are: "TextElement_v8", "UnicodeCodePoint", and
     "Utf16CodeUnit".
    :vartype string_index_type: str or ~azure.ai.textanalytics.v3_1.models.StringIndexType
    """

    _attribute_map = {
        "model_version": {"key": "model-version", "type": "str"},
        "logging_opt_out": {"key": "loggingOptOut", "type": "bool"},
        "string_index_type": {"key": "stringIndexType", "type": "str"},
    }

    def __init__(
        self,
        *,
        model_version: str = "latest",
        logging_opt_out: bool = False,
        string_index_type: Optional[Union[str, "_models.StringIndexType"]] = None,
        **kwargs
    ):
        """
        :keyword model_version:
        :paramtype model_version: str
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        :keyword string_index_type: Known values are: "TextElement_v8", "UnicodeCodePoint", and
         "Utf16CodeUnit".
        :paramtype string_index_type: str or ~azure.ai.textanalytics.v3_1.models.StringIndexType
        """
        super().__init__(**kwargs)
        self.model_version = model_version
        self.logging_opt_out = logging_opt_out
        self.string_index_type = string_index_type


class EntityLinkingTaskResult(_serialization.Model):
    """EntityLinkingTaskResult.

    :ivar results:
    :vartype results: ~azure.ai.textanalytics.v3_1.models.EntityLinkingResult
    """

    _attribute_map = {
        "results": {"key": "results", "type": "EntityLinkingResult"},
    }

    def __init__(
        self,
        *,
        results: Optional["_models.EntityLinkingResult"] = None,
        **kwargs
    ):
        """
        :keyword results:
        :paramtype results: ~azure.ai.textanalytics.v3_1.models.EntityLinkingResult
        """
        super().__init__(**kwargs)
        self.results = results


class ErrorResponse(_serialization.Model):
    """ErrorResponse.

    All required parameters must be populated in order to send to Azure.

    :ivar error: Document Error. Required.
    :vartype error: ~azure.ai.textanalytics.v3_1.models.TextAnalyticsError
    """

    _validation = {
        'error': {'required': True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "TextAnalyticsError"},
    }

    def __init__(
        self,
        *,
        error: "_models.TextAnalyticsError",
        **kwargs
    ):
        """
        :keyword error: Document Error. Required.
        :paramtype error: ~azure.ai.textanalytics.v3_1.models.TextAnalyticsError
        """
        super().__init__(**kwargs)
        self.error = error


class HealthcareAssertion(_serialization.Model):
    """HealthcareAssertion.

    :ivar conditionality: Describes any conditionality on the entity. Known values are:
     "hypothetical" and "conditional".
    :vartype conditionality: str or ~azure.ai.textanalytics.v3_1.models.Conditionality
    :ivar certainty: Describes the entities certainty and polarity. Known values are: "positive",
     "positivePossible", "neutralPossible", "negativePossible", and "negative".
    :vartype certainty: str or ~azure.ai.textanalytics.v3_1.models.Certainty
    :ivar association: Describes if the entity is the subject of the text or if it describes
     someone else. Known values are: "subject" and "other".
    :vartype association: str or ~azure.ai.textanalytics.v3_1.models.Association
    """

    _attribute_map = {
        "conditionality": {"key": "conditionality", "type": "str"},
        "certainty": {"key": "certainty", "type": "str"},
        "association": {"key": "association", "type": "str"},
    }

    def __init__(
        self,
        *,
        conditionality: Optional[Union[str, "_models.Conditionality"]] = None,
        certainty: Optional[Union[str, "_models.Certainty"]] = None,
        association: Optional[Union[str, "_models.Association"]] = None,
        **kwargs
    ):
        """
        :keyword conditionality: Describes any conditionality on the entity. Known values are:
         "hypothetical" and "conditional".
        :paramtype conditionality: str or ~azure.ai.textanalytics.v3_1.models.Conditionality
        :keyword certainty: Describes the entities certainty and polarity. Known values are:
         "positive", "positivePossible", "neutralPossible", "negativePossible", and "negative".
        :paramtype certainty: str or ~azure.ai.textanalytics.v3_1.models.Certainty
        :keyword association: Describes if the entity is the subject of the text or if it describes
         someone else. Known values are: "subject" and "other".
        :paramtype association: str or ~azure.ai.textanalytics.v3_1.models.Association
        """
        super().__init__(**kwargs)
        self.conditionality = conditionality
        self.certainty = certainty
        self.association = association


class HealthcareLinkingProperties(_serialization.Model):
    """HealthcareLinkingProperties.

    :ivar assertion:
    :vartype assertion: ~azure.ai.textanalytics.v3_1.models.HealthcareAssertion
    :ivar name: Preferred name for the entity. Example: 'histologically' would have a 'name' of
     'histologic'.
    :vartype name: str
    :ivar links: Entity references in known data sources.
    :vartype links: list[~azure.ai.textanalytics.v3_1.models.HealthcareEntityLink]
    """

    _attribute_map = {
        "assertion": {"key": "assertion", "type": "HealthcareAssertion"},
        "name": {"key": "name", "type": "str"},
        "links": {"key": "links", "type": "[HealthcareEntityLink]"},
    }

    def __init__(
        self,
        *,
        assertion: Optional["_models.HealthcareAssertion"] = None,
        name: Optional[str] = None,
        links: Optional[List["_models.HealthcareEntityLink"]] = None,
        **kwargs
    ):
        """
        :keyword assertion:
        :paramtype assertion: ~azure.ai.textanalytics.v3_1.models.HealthcareAssertion
        :keyword name: Preferred name for the entity. Example: 'histologically' would have a 'name' of
         'histologic'.
        :paramtype name: str
        :keyword links: Entity references in known data sources.
        :paramtype links: list[~azure.ai.textanalytics.v3_1.models.HealthcareEntityLink]
        """
        super().__init__(**kwargs)
        self.assertion = assertion
        self.name = name
        self.links = links


class HealthcareEntityProperties(_serialization.Model):
    """HealthcareEntityProperties.

    All required parameters must be populated in order to send to Azure.

    :ivar text: Entity text as appears in the request. Required.
    :vartype text: str
    :ivar category: Healthcare Entity Category. Required. Known values are: "BodyStructure", "Age",
     "Gender", "ExaminationName", "Date", "Direction", "Frequency", "MeasurementValue",
     "MeasurementUnit", "RelationalOperator", "Time", "GeneOrProtein", "Variant",
     "AdministrativeEvent", "CareEnvironment", "HealthcareProfession", "Diagnosis", "SymptomOrSign",
     "ConditionQualifier", "MedicationClass", "MedicationName", "Dosage", "MedicationForm",
     "MedicationRoute", "FamilyRelation", and "TreatmentName".
    :vartype category: str or ~azure.ai.textanalytics.v3_1.models.HealthcareEntityCategory
    :ivar subcategory: (Optional) Entity sub type.
    :vartype subcategory: str
    :ivar offset: Start position for the entity text. Use of different 'stringIndexType' values can
     affect the offset returned. Required.
    :vartype offset: int
    :ivar length: Length for the entity text. Use of different 'stringIndexType' values can affect
     the length returned. Required.
    :vartype length: int
    :ivar confidence_score: Confidence score between 0 and 1 of the extracted entity. Required.
    :vartype confidence_score: float
    """

    _validation = {
        'text': {'required': True},
        'category': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
        'confidence_score': {'required': True},
    }

    _attribute_map = {
        "text": {"key": "text", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "subcategory": {"key": "subcategory", "type": "str"},
        "offset": {"key": "offset", "type": "int"},
        "length": {"key": "length", "type": "int"},
        "confidence_score": {"key": "confidenceScore", "type": "float"},
    }

    def __init__(
        self,
        *,
        text: str,
        category: Union[str, "_models.HealthcareEntityCategory"],
        offset: int,
        length: int,
        confidence_score: float,
        subcategory: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword text: Entity text as appears in the request. Required.
        :paramtype text: str
        :keyword category: Healthcare Entity Category. Required. Known values are: "BodyStructure",
         "Age", "Gender", "ExaminationName", "Date", "Direction", "Frequency", "MeasurementValue",
         "MeasurementUnit", "RelationalOperator", "Time", "GeneOrProtein", "Variant",
         "AdministrativeEvent", "CareEnvironment", "HealthcareProfession", "Diagnosis", "SymptomOrSign",
         "ConditionQualifier", "MedicationClass", "MedicationName", "Dosage", "MedicationForm",
         "MedicationRoute", "FamilyRelation", and "TreatmentName".
        :paramtype category: str or ~azure.ai.textanalytics.v3_1.models.HealthcareEntityCategory
        :keyword subcategory: (Optional) Entity sub type.
        :paramtype subcategory: str
        :keyword offset: Start position for the entity text. Use of different 'stringIndexType' values
         can affect the offset returned. Required.
        :paramtype offset: int
        :keyword length: Length for the entity text. Use of different 'stringIndexType' values can
         affect the length returned. Required.
        :paramtype length: int
        :keyword confidence_score: Confidence score between 0 and 1 of the extracted entity. Required.
        :paramtype confidence_score: float
        """
        super().__init__(**kwargs)
        self.text = text
        self.category = category
        self.subcategory = subcategory
        self.offset = offset
        self.length = length
        self.confidence_score = confidence_score


class HealthcareEntity(HealthcareEntityProperties, HealthcareLinkingProperties):
    """HealthcareEntity.

    All required parameters must be populated in order to send to Azure.

    :ivar assertion:
    :vartype assertion: ~azure.ai.textanalytics.v3_1.models.HealthcareAssertion
    :ivar name: Preferred name for the entity. Example: 'histologically' would have a 'name' of
     'histologic'.
    :vartype name: str
    :ivar links: Entity references in known data sources.
    :vartype links: list[~azure.ai.textanalytics.v3_1.models.HealthcareEntityLink]
    :ivar text: Entity text as appears in the request. Required.
    :vartype text: str
    :ivar category: Healthcare Entity Category. Required. Known values are: "BodyStructure", "Age",
     "Gender", "ExaminationName", "Date", "Direction", "Frequency", "MeasurementValue",
     "MeasurementUnit", "RelationalOperator", "Time", "GeneOrProtein", "Variant",
     "AdministrativeEvent", "CareEnvironment", "HealthcareProfession", "Diagnosis", "SymptomOrSign",
     "ConditionQualifier", "MedicationClass", "MedicationName", "Dosage", "MedicationForm",
     "MedicationRoute", "FamilyRelation", and "TreatmentName".
    :vartype category: str or ~azure.ai.textanalytics.v3_1.models.HealthcareEntityCategory
    :ivar subcategory: (Optional) Entity sub type.
    :vartype subcategory: str
    :ivar offset: Start position for the entity text. Use of different 'stringIndexType' values can
     affect the offset returned. Required.
    :vartype offset: int
    :ivar length: Length for the entity text. Use of different 'stringIndexType' values can affect
     the length returned. Required.
    :vartype length: int
    :ivar confidence_score: Confidence score between 0 and 1 of the extracted entity. Required.
    :vartype confidence_score: float
    """

    _validation = {
        'text': {'required': True},
        'category': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
        'confidence_score': {'required': True},
    }

    _attribute_map = {
        "assertion": {"key": "assertion", "type": "HealthcareAssertion"},
        "name": {"key": "name", "type": "str"},
        "links": {"key": "links", "type": "[HealthcareEntityLink]"},
        "text": {"key": "text", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "subcategory": {"key": "subcategory", "type": "str"},
        "offset": {"key": "offset", "type": "int"},
        "length": {"key": "length", "type": "int"},
        "confidence_score": {"key": "confidenceScore", "type": "float"},
    }

    def __init__(
        self,
        *,
        text: str,
        category: Union[str, "_models.HealthcareEntityCategory"],
        offset: int,
        length: int,
        confidence_score: float,
        assertion: Optional["_models.HealthcareAssertion"] = None,
        name: Optional[str] = None,
        links: Optional[List["_models.HealthcareEntityLink"]] = None,
        subcategory: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword assertion:
        :paramtype assertion: ~azure.ai.textanalytics.v3_1.models.HealthcareAssertion
        :keyword name: Preferred name for the entity. Example: 'histologically' would have a 'name' of
         'histologic'.
        :paramtype name: str
        :keyword links: Entity references in known data sources.
        :paramtype links: list[~azure.ai.textanalytics.v3_1.models.HealthcareEntityLink]
        :keyword text: Entity text as appears in the request. Required.
        :paramtype text: str
        :keyword category: Healthcare Entity Category. Required. Known values are: "BodyStructure",
         "Age", "Gender", "ExaminationName", "Date", "Direction", "Frequency", "MeasurementValue",
         "MeasurementUnit", "RelationalOperator", "Time", "GeneOrProtein", "Variant",
         "AdministrativeEvent", "CareEnvironment", "HealthcareProfession", "Diagnosis", "SymptomOrSign",
         "ConditionQualifier", "MedicationClass", "MedicationName", "Dosage", "MedicationForm",
         "MedicationRoute", "FamilyRelation", and "TreatmentName".
        :paramtype category: str or ~azure.ai.textanalytics.v3_1.models.HealthcareEntityCategory
        :keyword subcategory: (Optional) Entity sub type.
        :paramtype subcategory: str
        :keyword offset: Start position for the entity text. Use of different 'stringIndexType' values
         can affect the offset returned. Required.
        :paramtype offset: int
        :keyword length: Length for the entity text. Use of different 'stringIndexType' values can
         affect the length returned. Required.
        :paramtype length: int
        :keyword confidence_score: Confidence score between 0 and 1 of the extracted entity. Required.
        :paramtype confidence_score: float
        """
        super().__init__(text=text, category=category, subcategory=subcategory, offset=offset, length=length, confidence_score=confidence_score, assertion=assertion, name=name, links=links, **kwargs)
        self.assertion = assertion
        self.name = name
        self.links = links
        self.text = text
        self.category = category
        self.subcategory = subcategory
        self.offset = offset
        self.length = length
        self.confidence_score = confidence_score


class HealthcareEntityLink(_serialization.Model):
    """HealthcareEntityLink.

    All required parameters must be populated in order to send to Azure.

    :ivar data_source: Entity Catalog. Examples include: UMLS, CHV, MSH, etc. Required.
    :vartype data_source: str
    :ivar id: Entity id in the given source catalog. Required.
    :vartype id: str
    """

    _validation = {
        'data_source': {'required': True},
        'id': {'required': True},
    }

    _attribute_map = {
        "data_source": {"key": "dataSource", "type": "str"},
        "id": {"key": "id", "type": "str"},
    }

    def __init__(
        self,
        *,
        data_source: str,
        id: str,  # pylint: disable=redefined-builtin
        **kwargs
    ):
        """
        :keyword data_source: Entity Catalog. Examples include: UMLS, CHV, MSH, etc. Required.
        :paramtype data_source: str
        :keyword id: Entity id in the given source catalog. Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.data_source = data_source
        self.id = id


class HealthcareTaskResult(_serialization.Model):
    """HealthcareTaskResult.

    :ivar results:
    :vartype results: ~azure.ai.textanalytics.v3_1.models.HealthcareResult
    :ivar errors:
    :vartype errors: list[~azure.ai.textanalytics.v3_1.models.TextAnalyticsError]
    """

    _attribute_map = {
        "results": {"key": "results", "type": "HealthcareResult"},
        "errors": {"key": "errors", "type": "[TextAnalyticsError]"},
    }

    def __init__(
        self,
        *,
        results: Optional["_models.HealthcareResult"] = None,
        errors: Optional[List["_models.TextAnalyticsError"]] = None,
        **kwargs
    ):
        """
        :keyword results:
        :paramtype results: ~azure.ai.textanalytics.v3_1.models.HealthcareResult
        :keyword errors:
        :paramtype errors: list[~azure.ai.textanalytics.v3_1.models.TextAnalyticsError]
        """
        super().__init__(**kwargs)
        self.results = results
        self.errors = errors


class HealthcareJobState(JobMetadata, HealthcareTaskResult, Pagination):
    """HealthcareJobState.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link:
    :vartype next_link: str
    :ivar results:
    :vartype results: ~azure.ai.textanalytics.v3_1.models.HealthcareResult
    :ivar errors:
    :vartype errors: list[~azure.ai.textanalytics.v3_1.models.TextAnalyticsError]
    :ivar created_date_time: Required.
    :vartype created_date_time: ~datetime.datetime
    :ivar expiration_date_time:
    :vartype expiration_date_time: ~datetime.datetime
    :ivar job_id: Required.
    :vartype job_id: str
    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
     "rejected", "cancelled", and "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.v3_1.models.State
    """

    _validation = {
        'created_date_time': {'required': True},
        'job_id': {'required': True},
        'last_update_date_time': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        "next_link": {"key": "@nextLink", "type": "str"},
        "results": {"key": "results", "type": "HealthcareResult"},
        "errors": {"key": "errors", "type": "[TextAnalyticsError]"},
        "created_date_time": {"key": "createdDateTime", "type": "iso-8601"},
        "expiration_date_time": {"key": "expirationDateTime", "type": "iso-8601"},
        "job_id": {"key": "jobId", "type": "str"},
        "last_update_date_time": {"key": "lastUpdateDateTime", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        created_date_time: datetime.datetime,
        job_id: str,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.State"],
        next_link: Optional[str] = None,
        results: Optional["_models.HealthcareResult"] = None,
        errors: Optional[List["_models.TextAnalyticsError"]] = None,
        expiration_date_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword next_link:
        :paramtype next_link: str
        :keyword results:
        :paramtype results: ~azure.ai.textanalytics.v3_1.models.HealthcareResult
        :keyword errors:
        :paramtype errors: list[~azure.ai.textanalytics.v3_1.models.TextAnalyticsError]
        :keyword created_date_time: Required.
        :paramtype created_date_time: ~datetime.datetime
        :keyword expiration_date_time:
        :paramtype expiration_date_time: ~datetime.datetime
        :keyword job_id: Required.
        :paramtype job_id: str
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
         "rejected", "cancelled", and "cancelling".
        :paramtype status: str or ~azure.ai.textanalytics.v3_1.models.State
        """
        super().__init__(created_date_time=created_date_time, expiration_date_time=expiration_date_time, job_id=job_id, last_update_date_time=last_update_date_time, status=status, results=results, errors=errors, next_link=next_link, **kwargs)
        self.next_link = next_link
        self.results = results
        self.errors = errors
        self.created_date_time = created_date_time
        self.expiration_date_time = expiration_date_time
        self.job_id = job_id
        self.last_update_date_time = last_update_date_time
        self.status = status


class HealthcareRelation(_serialization.Model):
    """Every relation is an entity graph of a certain relationType, where all entities are connected and have specific roles within the relation context.

    All required parameters must be populated in order to send to Azure.

    :ivar relation_type: Type of relation. Examples include: ``DosageOfMedication`` or
     'FrequencyOfMedication', etc. Required. Known values are: "Abbreviation",
     "DirectionOfBodyStructure", "DirectionOfCondition", "DirectionOfExamination",
     "DirectionOfTreatment", "DosageOfMedication", "FormOfMedication", "FrequencyOfMedication",
     "FrequencyOfTreatment", "QualifierOfCondition", "RelationOfExamination", "RouteOfMedication",
     "TimeOfCondition", "TimeOfEvent", "TimeOfExamination", "TimeOfMedication", "TimeOfTreatment",
     "UnitOfCondition", "UnitOfExamination", "ValueOfCondition", and "ValueOfExamination".
    :vartype relation_type: str or ~azure.ai.textanalytics.v3_1.models.RelationType
    :ivar entities: The entities in the relation. Required.
    :vartype entities: list[~azure.ai.textanalytics.v3_1.models.HealthcareRelationEntity]
    """

    _validation = {
        'relation_type': {'required': True},
        'entities': {'required': True},
    }

    _attribute_map = {
        "relation_type": {"key": "relationType", "type": "str"},
        "entities": {"key": "entities", "type": "[HealthcareRelationEntity]"},
    }

    def __init__(
        self,
        *,
        relation_type: Union[str, "_models.RelationType"],
        entities: List["_models.HealthcareRelationEntity"],
        **kwargs
    ):
        """
        :keyword relation_type: Type of relation. Examples include: ``DosageOfMedication`` or
         'FrequencyOfMedication', etc. Required. Known values are: "Abbreviation",
         "DirectionOfBodyStructure", "DirectionOfCondition", "DirectionOfExamination",
         "DirectionOfTreatment", "DosageOfMedication", "FormOfMedication", "FrequencyOfMedication",
         "FrequencyOfTreatment", "QualifierOfCondition", "RelationOfExamination", "RouteOfMedication",
         "TimeOfCondition", "TimeOfEvent", "TimeOfExamination", "TimeOfMedication", "TimeOfTreatment",
         "UnitOfCondition", "UnitOfExamination", "ValueOfCondition", and "ValueOfExamination".
        :paramtype relation_type: str or ~azure.ai.textanalytics.v3_1.models.RelationType
        :keyword entities: The entities in the relation. Required.
        :paramtype entities: list[~azure.ai.textanalytics.v3_1.models.HealthcareRelationEntity]
        """
        super().__init__(**kwargs)
        self.relation_type = relation_type
        self.entities = entities


class HealthcareRelationEntity(_serialization.Model):
    """HealthcareRelationEntity.

    All required parameters must be populated in order to send to Azure.

    :ivar ref: Reference link object, using a JSON pointer RFC 6901 (URI Fragment Identifier
     Representation), pointing to the entity . Required.
    :vartype ref: str
    :ivar role: Role of entity in the relationship. For example: 'CD20-positive diffuse large
     B-cell lymphoma' has the following entities with their roles in parenthesis:  CD20
     (GeneOrProtein), Positive (Expression), diffuse large B-cell lymphoma (Diagnosis). Required.
    :vartype role: str
    """

    _validation = {
        'ref': {'required': True},
        'role': {'required': True},
    }

    _attribute_map = {
        "ref": {"key": "ref", "type": "str"},
        "role": {"key": "role", "type": "str"},
    }

    def __init__(
        self,
        *,
        ref: str,
        role: str,
        **kwargs
    ):
        """
        :keyword ref: Reference link object, using a JSON pointer RFC 6901 (URI Fragment Identifier
         Representation), pointing to the entity . Required.
        :paramtype ref: str
        :keyword role: Role of entity in the relationship. For example: 'CD20-positive diffuse large
         B-cell lymphoma' has the following entities with their roles in parenthesis:  CD20
         (GeneOrProtein), Positive (Expression), diffuse large B-cell lymphoma (Diagnosis). Required.
        :paramtype role: str
        """
        super().__init__(**kwargs)
        self.ref = ref
        self.role = role


class HealthcareResult(_serialization.Model):
    """HealthcareResult.

    All required parameters must be populated in order to send to Azure.

    :ivar documents: Response by document. Required.
    :vartype documents: list[~azure.ai.textanalytics.v3_1.models.DocumentHealthcareEntities]
    :ivar errors: Errors by document id. Required.
    :vartype errors: list[~azure.ai.textanalytics.v3_1.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_1.models.RequestStatistics
    :ivar model_version: This field indicates which model is used for scoring. Required.
    :vartype model_version: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        "documents": {"key": "documents", "type": "[DocumentHealthcareEntities]"},
        "errors": {"key": "errors", "type": "[DocumentError]"},
        "statistics": {"key": "statistics", "type": "RequestStatistics"},
        "model_version": {"key": "modelVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        documents: List["_models.DocumentHealthcareEntities"],
        errors: List["_models.DocumentError"],
        model_version: str,
        statistics: Optional["_models.RequestStatistics"] = None,
        **kwargs
    ):
        """
        :keyword documents: Response by document. Required.
        :paramtype documents: list[~azure.ai.textanalytics.v3_1.models.DocumentHealthcareEntities]
        :keyword errors: Errors by document id. Required.
        :paramtype errors: list[~azure.ai.textanalytics.v3_1.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_1.models.RequestStatistics
        :keyword model_version: This field indicates which model is used for scoring. Required.
        :paramtype model_version: str
        """
        super().__init__(**kwargs)
        self.documents = documents
        self.errors = errors
        self.statistics = statistics
        self.model_version = model_version


class InnerError(_serialization.Model):
    """InnerError.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Error code. Required. Known values are: "InvalidParameterValue",
     "InvalidRequestBodyFormat", "EmptyRequest", "MissingInputRecords", "InvalidDocument",
     "ModelVersionIncorrect", "InvalidDocumentBatch", "UnsupportedLanguageCode", and
     "InvalidCountryHint".
    :vartype code: str or ~azure.ai.textanalytics.v3_1.models.InnerErrorCodeValue
    :ivar message: Error message. Required.
    :vartype message: str
    :ivar details: Error details.
    :vartype details: dict[str, str]
    :ivar target: Error target.
    :vartype target: str
    :ivar innererror: Inner error contains more specific information.
    :vartype innererror: ~azure.ai.textanalytics.v3_1.models.InnerError
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "details": {"key": "details", "type": "{str}"},
        "target": {"key": "target", "type": "str"},
        "innererror": {"key": "innererror", "type": "InnerError"},
    }

    def __init__(
        self,
        *,
        code: Union[str, "_models.InnerErrorCodeValue"],
        message: str,
        details: Optional[Dict[str, str]] = None,
        target: Optional[str] = None,
        innererror: Optional["_models.InnerError"] = None,
        **kwargs
    ):
        """
        :keyword code: Error code. Required. Known values are: "InvalidParameterValue",
         "InvalidRequestBodyFormat", "EmptyRequest", "MissingInputRecords", "InvalidDocument",
         "ModelVersionIncorrect", "InvalidDocumentBatch", "UnsupportedLanguageCode", and
         "InvalidCountryHint".
        :paramtype code: str or ~azure.ai.textanalytics.v3_1.models.InnerErrorCodeValue
        :keyword message: Error message. Required.
        :paramtype message: str
        :keyword details: Error details.
        :paramtype details: dict[str, str]
        :keyword target: Error target.
        :paramtype target: str
        :keyword innererror: Inner error contains more specific information.
        :paramtype innererror: ~azure.ai.textanalytics.v3_1.models.InnerError
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.details = details
        self.target = target
        self.innererror = innererror


class JobManifestTasks(_serialization.Model):
    """The set of tasks to execute on the input documents. Cannot specify the same task more than once.

    :ivar entity_recognition_tasks:
    :vartype entity_recognition_tasks: list[~azure.ai.textanalytics.v3_1.models.EntitiesTask]
    :ivar entity_recognition_pii_tasks:
    :vartype entity_recognition_pii_tasks: list[~azure.ai.textanalytics.v3_1.models.PiiTask]
    :ivar key_phrase_extraction_tasks:
    :vartype key_phrase_extraction_tasks: list[~azure.ai.textanalytics.v3_1.models.KeyPhrasesTask]
    :ivar entity_linking_tasks:
    :vartype entity_linking_tasks: list[~azure.ai.textanalytics.v3_1.models.EntityLinkingTask]
    :ivar sentiment_analysis_tasks:
    :vartype sentiment_analysis_tasks:
     list[~azure.ai.textanalytics.v3_1.models.SentimentAnalysisTask]
    """

    _attribute_map = {
        "entity_recognition_tasks": {"key": "entityRecognitionTasks", "type": "[EntitiesTask]"},
        "entity_recognition_pii_tasks": {"key": "entityRecognitionPiiTasks", "type": "[PiiTask]"},
        "key_phrase_extraction_tasks": {"key": "keyPhraseExtractionTasks", "type": "[KeyPhrasesTask]"},
        "entity_linking_tasks": {"key": "entityLinkingTasks", "type": "[EntityLinkingTask]"},
        "sentiment_analysis_tasks": {"key": "sentimentAnalysisTasks", "type": "[SentimentAnalysisTask]"},
    }

    def __init__(
        self,
        *,
        entity_recognition_tasks: Optional[List["_models.EntitiesTask"]] = None,
        entity_recognition_pii_tasks: Optional[List["_models.PiiTask"]] = None,
        key_phrase_extraction_tasks: Optional[List["_models.KeyPhrasesTask"]] = None,
        entity_linking_tasks: Optional[List["_models.EntityLinkingTask"]] = None,
        sentiment_analysis_tasks: Optional[List["_models.SentimentAnalysisTask"]] = None,
        **kwargs
    ):
        """
        :keyword entity_recognition_tasks:
        :paramtype entity_recognition_tasks: list[~azure.ai.textanalytics.v3_1.models.EntitiesTask]
        :keyword entity_recognition_pii_tasks:
        :paramtype entity_recognition_pii_tasks: list[~azure.ai.textanalytics.v3_1.models.PiiTask]
        :keyword key_phrase_extraction_tasks:
        :paramtype key_phrase_extraction_tasks:
         list[~azure.ai.textanalytics.v3_1.models.KeyPhrasesTask]
        :keyword entity_linking_tasks:
        :paramtype entity_linking_tasks: list[~azure.ai.textanalytics.v3_1.models.EntityLinkingTask]
        :keyword sentiment_analysis_tasks:
        :paramtype sentiment_analysis_tasks:
         list[~azure.ai.textanalytics.v3_1.models.SentimentAnalysisTask]
        """
        super().__init__(**kwargs)
        self.entity_recognition_tasks = entity_recognition_tasks
        self.entity_recognition_pii_tasks = entity_recognition_pii_tasks
        self.key_phrase_extraction_tasks = key_phrase_extraction_tasks
        self.entity_linking_tasks = entity_linking_tasks
        self.sentiment_analysis_tasks = sentiment_analysis_tasks


class KeyPhraseResult(_serialization.Model):
    """KeyPhraseResult.

    All required parameters must be populated in order to send to Azure.

    :ivar documents: Response by document. Required.
    :vartype documents: list[~azure.ai.textanalytics.v3_1.models.DocumentKeyPhrases]
    :ivar errors: Errors by document id. Required.
    :vartype errors: list[~azure.ai.textanalytics.v3_1.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_1.models.RequestStatistics
    :ivar model_version: This field indicates which model is used for scoring. Required.
    :vartype model_version: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        "documents": {"key": "documents", "type": "[DocumentKeyPhrases]"},
        "errors": {"key": "errors", "type": "[DocumentError]"},
        "statistics": {"key": "statistics", "type": "RequestStatistics"},
        "model_version": {"key": "modelVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        documents: List["_models.DocumentKeyPhrases"],
        errors: List["_models.DocumentError"],
        model_version: str,
        statistics: Optional["_models.RequestStatistics"] = None,
        **kwargs
    ):
        """
        :keyword documents: Response by document. Required.
        :paramtype documents: list[~azure.ai.textanalytics.v3_1.models.DocumentKeyPhrases]
        :keyword errors: Errors by document id. Required.
        :paramtype errors: list[~azure.ai.textanalytics.v3_1.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_1.models.RequestStatistics
        :keyword model_version: This field indicates which model is used for scoring. Required.
        :paramtype model_version: str
        """
        super().__init__(**kwargs)
        self.documents = documents
        self.errors = errors
        self.statistics = statistics
        self.model_version = model_version


class KeyPhrasesTask(_serialization.Model):
    """KeyPhrasesTask.

    :ivar parameters:
    :vartype parameters: ~azure.ai.textanalytics.v3_1.models.KeyPhrasesTaskParameters
    :ivar task_name:
    :vartype task_name: str
    """

    _attribute_map = {
        "parameters": {"key": "parameters", "type": "KeyPhrasesTaskParameters"},
        "task_name": {"key": "taskName", "type": "str"},
    }

    def __init__(
        self,
        *,
        parameters: Optional["_models.KeyPhrasesTaskParameters"] = None,
        task_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword parameters:
        :paramtype parameters: ~azure.ai.textanalytics.v3_1.models.KeyPhrasesTaskParameters
        :keyword task_name:
        :paramtype task_name: str
        """
        super().__init__(**kwargs)
        self.parameters = parameters
        self.task_name = task_name


class KeyPhrasesTaskParameters(_serialization.Model):
    """KeyPhrasesTaskParameters.

    :ivar model_version:
    :vartype model_version: str
    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    """

    _attribute_map = {
        "model_version": {"key": "model-version", "type": "str"},
        "logging_opt_out": {"key": "loggingOptOut", "type": "bool"},
    }

    def __init__(
        self,
        *,
        model_version: str = "latest",
        logging_opt_out: bool = False,
        **kwargs
    ):
        """
        :keyword model_version:
        :paramtype model_version: str
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        """
        super().__init__(**kwargs)
        self.model_version = model_version
        self.logging_opt_out = logging_opt_out


class KeyPhraseTaskResult(_serialization.Model):
    """KeyPhraseTaskResult.

    :ivar results:
    :vartype results: ~azure.ai.textanalytics.v3_1.models.KeyPhraseResult
    """

    _attribute_map = {
        "results": {"key": "results", "type": "KeyPhraseResult"},
    }

    def __init__(
        self,
        *,
        results: Optional["_models.KeyPhraseResult"] = None,
        **kwargs
    ):
        """
        :keyword results:
        :paramtype results: ~azure.ai.textanalytics.v3_1.models.KeyPhraseResult
        """
        super().__init__(**kwargs)
        self.results = results


class LanguageBatchInput(_serialization.Model):
    """LanguageBatchInput.

    All required parameters must be populated in order to send to Azure.

    :ivar documents: Required.
    :vartype documents: list[~azure.ai.textanalytics.v3_1.models.LanguageInput]
    """

    _validation = {
        'documents': {'required': True},
    }

    _attribute_map = {
        "documents": {"key": "documents", "type": "[LanguageInput]"},
    }

    def __init__(
        self,
        *,
        documents: List["_models.LanguageInput"],
        **kwargs
    ):
        """
        :keyword documents: Required.
        :paramtype documents: list[~azure.ai.textanalytics.v3_1.models.LanguageInput]
        """
        super().__init__(**kwargs)
        self.documents = documents


class LanguageInput(_serialization.Model):
    """LanguageInput.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar text: Required.
    :vartype text: str
    :ivar country_hint:
    :vartype country_hint: str
    """

    _validation = {
        'id': {'required': True},
        'text': {'required': True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "text": {"key": "text", "type": "str"},
        "country_hint": {"key": "countryHint", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        text: str,
        country_hint: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Unique, non-empty document identifier. Required.
        :paramtype id: str
        :keyword text: Required.
        :paramtype text: str
        :keyword country_hint:
        :paramtype country_hint: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.text = text
        self.country_hint = country_hint


class LanguageResult(_serialization.Model):
    """LanguageResult.

    All required parameters must be populated in order to send to Azure.

    :ivar documents: Response by document. Required.
    :vartype documents: list[~azure.ai.textanalytics.v3_1.models.DocumentLanguage]
    :ivar errors: Errors by document id. Required.
    :vartype errors: list[~azure.ai.textanalytics.v3_1.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_1.models.RequestStatistics
    :ivar model_version: This field indicates which model is used for scoring. Required.
    :vartype model_version: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        "documents": {"key": "documents", "type": "[DocumentLanguage]"},
        "errors": {"key": "errors", "type": "[DocumentError]"},
        "statistics": {"key": "statistics", "type": "RequestStatistics"},
        "model_version": {"key": "modelVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        documents: List["_models.DocumentLanguage"],
        errors: List["_models.DocumentError"],
        model_version: str,
        statistics: Optional["_models.RequestStatistics"] = None,
        **kwargs
    ):
        """
        :keyword documents: Response by document. Required.
        :paramtype documents: list[~azure.ai.textanalytics.v3_1.models.DocumentLanguage]
        :keyword errors: Errors by document id. Required.
        :paramtype errors: list[~azure.ai.textanalytics.v3_1.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_1.models.RequestStatistics
        :keyword model_version: This field indicates which model is used for scoring. Required.
        :paramtype model_version: str
        """
        super().__init__(**kwargs)
        self.documents = documents
        self.errors = errors
        self.statistics = statistics
        self.model_version = model_version


class LinkedEntity(_serialization.Model):
    """LinkedEntity.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Entity Linking formal name. Required.
    :vartype name: str
    :ivar matches: List of instances this entity appears in the text. Required.
    :vartype matches: list[~azure.ai.textanalytics.v3_1.models.Match]
    :ivar language: Language used in the data source. Required.
    :vartype language: str
    :ivar id: Unique identifier of the recognized entity from the data source.
    :vartype id: str
    :ivar url: URL for the entity's page from the data source. Required.
    :vartype url: str
    :ivar data_source: Data source used to extract entity linking, such as Wiki/Bing etc. Required.
    :vartype data_source: str
    :ivar bing_id: Bing Entity Search API unique identifier of the recognized entity.
    :vartype bing_id: str
    """

    _validation = {
        'name': {'required': True},
        'matches': {'required': True},
        'language': {'required': True},
        'url': {'required': True},
        'data_source': {'required': True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "matches": {"key": "matches", "type": "[Match]"},
        "language": {"key": "language", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "url": {"key": "url", "type": "str"},
        "data_source": {"key": "dataSource", "type": "str"},
        "bing_id": {"key": "bingId", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        matches: List["_models.Match"],
        language: str,
        url: str,
        data_source: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        bing_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Entity Linking formal name. Required.
        :paramtype name: str
        :keyword matches: List of instances this entity appears in the text. Required.
        :paramtype matches: list[~azure.ai.textanalytics.v3_1.models.Match]
        :keyword language: Language used in the data source. Required.
        :paramtype language: str
        :keyword id: Unique identifier of the recognized entity from the data source.
        :paramtype id: str
        :keyword url: URL for the entity's page from the data source. Required.
        :paramtype url: str
        :keyword data_source: Data source used to extract entity linking, such as Wiki/Bing etc.
         Required.
        :paramtype data_source: str
        :keyword bing_id: Bing Entity Search API unique identifier of the recognized entity.
        :paramtype bing_id: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.matches = matches
        self.language = language
        self.id = id
        self.url = url
        self.data_source = data_source
        self.bing_id = bing_id


class Match(_serialization.Model):
    """Match.

    All required parameters must be populated in order to send to Azure.

    :ivar confidence_score: If a well known item is recognized, a decimal number denoting the
     confidence level between 0 and 1 will be returned. Required.
    :vartype confidence_score: float
    :ivar text: Entity text as appears in the request. Required.
    :vartype text: str
    :ivar offset: Start position for the entity match text. Required.
    :vartype offset: int
    :ivar length: Length for the entity match text. Required.
    :vartype length: int
    """

    _validation = {
        'confidence_score': {'required': True},
        'text': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
    }

    _attribute_map = {
        "confidence_score": {"key": "confidenceScore", "type": "float"},
        "text": {"key": "text", "type": "str"},
        "offset": {"key": "offset", "type": "int"},
        "length": {"key": "length", "type": "int"},
    }

    def __init__(
        self,
        *,
        confidence_score: float,
        text: str,
        offset: int,
        length: int,
        **kwargs
    ):
        """
        :keyword confidence_score: If a well known item is recognized, a decimal number denoting the
         confidence level between 0 and 1 will be returned. Required.
        :paramtype confidence_score: float
        :keyword text: Entity text as appears in the request. Required.
        :paramtype text: str
        :keyword offset: Start position for the entity match text. Required.
        :paramtype offset: int
        :keyword length: Length for the entity match text. Required.
        :paramtype length: int
        """
        super().__init__(**kwargs)
        self.confidence_score = confidence_score
        self.text = text
        self.offset = offset
        self.length = length


class MultiLanguageBatchInput(_serialization.Model):
    """Contains a set of input documents to be analyzed by the service.

    All required parameters must be populated in order to send to Azure.

    :ivar documents: The set of documents to process as part of this batch. Required.
    :vartype documents: list[~azure.ai.textanalytics.v3_1.models.MultiLanguageInput]
    """

    _validation = {
        'documents': {'required': True},
    }

    _attribute_map = {
        "documents": {"key": "documents", "type": "[MultiLanguageInput]"},
    }

    def __init__(
        self,
        *,
        documents: List["_models.MultiLanguageInput"],
        **kwargs
    ):
        """
        :keyword documents: The set of documents to process as part of this batch. Required.
        :paramtype documents: list[~azure.ai.textanalytics.v3_1.models.MultiLanguageInput]
        """
        super().__init__(**kwargs)
        self.documents = documents


class MultiLanguageInput(_serialization.Model):
    """Contains an input document to be analyzed by the service.

    All required parameters must be populated in order to send to Azure.

    :ivar id: A unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar text: The input text to process. Required.
    :vartype text: str
    :ivar language: (Optional) This is the 2 letter ISO 639-1 representation of a language. For
     example, use "en" for English; "es" for Spanish etc. If not set, use "en" for English as
     default.
    :vartype language: str
    """

    _validation = {
        'id': {'required': True},
        'text': {'required': True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "text": {"key": "text", "type": "str"},
        "language": {"key": "language", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        text: str,
        language: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: A unique, non-empty document identifier. Required.
        :paramtype id: str
        :keyword text: The input text to process. Required.
        :paramtype text: str
        :keyword language: (Optional) This is the 2 letter ISO 639-1 representation of a language. For
         example, use "en" for English; "es" for Spanish etc. If not set, use "en" for English as
         default.
        :paramtype language: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.text = text
        self.language = language


class PiiDocumentEntities(_serialization.Model):
    """PiiDocumentEntities.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar redacted_text: Returns redacted text. Required.
    :vartype redacted_text: str
    :ivar entities: Recognized entities in the document. Required.
    :vartype entities: list[~azure.ai.textanalytics.v3_1.models.Entity]
    :ivar warnings: Warnings encountered while processing document. Required.
    :vartype warnings: list[~azure.ai.textanalytics.v3_1.models.TextAnalyticsWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_1.models.DocumentStatistics
    """

    _validation = {
        'id': {'required': True},
        'redacted_text': {'required': True},
        'entities': {'required': True},
        'warnings': {'required': True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "redacted_text": {"key": "redactedText", "type": "str"},
        "entities": {"key": "entities", "type": "[Entity]"},
        "warnings": {"key": "warnings", "type": "[TextAnalyticsWarning]"},
        "statistics": {"key": "statistics", "type": "DocumentStatistics"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        redacted_text: str,
        entities: List["_models.Entity"],
        warnings: List["_models.TextAnalyticsWarning"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Unique, non-empty document identifier. Required.
        :paramtype id: str
        :keyword redacted_text: Returns redacted text. Required.
        :paramtype redacted_text: str
        :keyword entities: Recognized entities in the document. Required.
        :paramtype entities: list[~azure.ai.textanalytics.v3_1.models.Entity]
        :keyword warnings: Warnings encountered while processing document. Required.
        :paramtype warnings: list[~azure.ai.textanalytics.v3_1.models.TextAnalyticsWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_1.models.DocumentStatistics
        """
        super().__init__(**kwargs)
        self.id = id
        self.redacted_text = redacted_text
        self.entities = entities
        self.warnings = warnings
        self.statistics = statistics


class PiiResult(_serialization.Model):
    """PiiResult.

    All required parameters must be populated in order to send to Azure.

    :ivar documents: Response by document. Required.
    :vartype documents: list[~azure.ai.textanalytics.v3_1.models.PiiDocumentEntities]
    :ivar errors: Errors by document id. Required.
    :vartype errors: list[~azure.ai.textanalytics.v3_1.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_1.models.RequestStatistics
    :ivar model_version: This field indicates which model is used for scoring. Required.
    :vartype model_version: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        "documents": {"key": "documents", "type": "[PiiDocumentEntities]"},
        "errors": {"key": "errors", "type": "[DocumentError]"},
        "statistics": {"key": "statistics", "type": "RequestStatistics"},
        "model_version": {"key": "modelVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        documents: List["_models.PiiDocumentEntities"],
        errors: List["_models.DocumentError"],
        model_version: str,
        statistics: Optional["_models.RequestStatistics"] = None,
        **kwargs
    ):
        """
        :keyword documents: Response by document. Required.
        :paramtype documents: list[~azure.ai.textanalytics.v3_1.models.PiiDocumentEntities]
        :keyword errors: Errors by document id. Required.
        :paramtype errors: list[~azure.ai.textanalytics.v3_1.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_1.models.RequestStatistics
        :keyword model_version: This field indicates which model is used for scoring. Required.
        :paramtype model_version: str
        """
        super().__init__(**kwargs)
        self.documents = documents
        self.errors = errors
        self.statistics = statistics
        self.model_version = model_version


class PiiTask(_serialization.Model):
    """PiiTask.

    :ivar parameters:
    :vartype parameters: ~azure.ai.textanalytics.v3_1.models.PiiTaskParameters
    :ivar task_name:
    :vartype task_name: str
    """

    _attribute_map = {
        "parameters": {"key": "parameters", "type": "PiiTaskParameters"},
        "task_name": {"key": "taskName", "type": "str"},
    }

    def __init__(
        self,
        *,
        parameters: Optional["_models.PiiTaskParameters"] = None,
        task_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword parameters:
        :paramtype parameters: ~azure.ai.textanalytics.v3_1.models.PiiTaskParameters
        :keyword task_name:
        :paramtype task_name: str
        """
        super().__init__(**kwargs)
        self.parameters = parameters
        self.task_name = task_name


class PiiTaskParameters(_serialization.Model):
    """PiiTaskParameters.

    :ivar domain: Known values are: "phi" and "none".
    :vartype domain: str or ~azure.ai.textanalytics.v3_1.models.PiiTaskParametersDomain
    :ivar model_version:
    :vartype model_version: str
    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    :ivar pii_categories: (Optional) describes the PII categories to return.
    :vartype pii_categories: list[str or ~azure.ai.textanalytics.v3_1.models.PiiCategory]
    :ivar string_index_type: Known values are: "TextElement_v8", "UnicodeCodePoint", and
     "Utf16CodeUnit".
    :vartype string_index_type: str or ~azure.ai.textanalytics.v3_1.models.StringIndexType
    """

    _validation = {
        'pii_categories': {'unique': True},
    }

    _attribute_map = {
        "domain": {"key": "domain", "type": "str"},
        "model_version": {"key": "model-version", "type": "str"},
        "logging_opt_out": {"key": "loggingOptOut", "type": "bool"},
        "pii_categories": {"key": "piiCategories", "type": "[str]"},
        "string_index_type": {"key": "stringIndexType", "type": "str"},
    }

    def __init__(
        self,
        *,
        domain: Union[str, "_models.PiiTaskParametersDomain"] = "none",
        model_version: str = "latest",
        logging_opt_out: bool = True,
        pii_categories: Optional[List[Union[str, "_models.PiiCategory"]]] = None,
        string_index_type: Optional[Union[str, "_models.StringIndexType"]] = None,
        **kwargs
    ):
        """
        :keyword domain: Known values are: "phi" and "none".
        :paramtype domain: str or ~azure.ai.textanalytics.v3_1.models.PiiTaskParametersDomain
        :keyword model_version:
        :paramtype model_version: str
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        :keyword pii_categories: (Optional) describes the PII categories to return.
        :paramtype pii_categories: list[str or ~azure.ai.textanalytics.v3_1.models.PiiCategory]
        :keyword string_index_type: Known values are: "TextElement_v8", "UnicodeCodePoint", and
         "Utf16CodeUnit".
        :paramtype string_index_type: str or ~azure.ai.textanalytics.v3_1.models.StringIndexType
        """
        super().__init__(**kwargs)
        self.domain = domain
        self.model_version = model_version
        self.logging_opt_out = logging_opt_out
        self.pii_categories = pii_categories
        self.string_index_type = string_index_type


class PiiTaskResult(_serialization.Model):
    """PiiTaskResult.

    :ivar results:
    :vartype results: ~azure.ai.textanalytics.v3_1.models.PiiResult
    """

    _attribute_map = {
        "results": {"key": "results", "type": "PiiResult"},
    }

    def __init__(
        self,
        *,
        results: Optional["_models.PiiResult"] = None,
        **kwargs
    ):
        """
        :keyword results:
        :paramtype results: ~azure.ai.textanalytics.v3_1.models.PiiResult
        """
        super().__init__(**kwargs)
        self.results = results


class RequestStatistics(_serialization.Model):
    """if showStats=true was specified in the request this field will contain information about the request payload.

    All required parameters must be populated in order to send to Azure.

    :ivar documents_count: Number of documents submitted in the request. Required.
    :vartype documents_count: int
    :ivar valid_documents_count: Number of valid documents. This excludes empty, over-size limit or
     non-supported languages documents. Required.
    :vartype valid_documents_count: int
    :ivar erroneous_documents_count: Number of invalid documents. This includes empty, over-size
     limit or non-supported languages documents. Required.
    :vartype erroneous_documents_count: int
    :ivar transactions_count: Number of transactions for the request. Required.
    :vartype transactions_count: int
    """

    _validation = {
        'documents_count': {'required': True},
        'valid_documents_count': {'required': True},
        'erroneous_documents_count': {'required': True},
        'transactions_count': {'required': True},
    }

    _attribute_map = {
        "documents_count": {"key": "documentsCount", "type": "int"},
        "valid_documents_count": {"key": "validDocumentsCount", "type": "int"},
        "erroneous_documents_count": {"key": "erroneousDocumentsCount", "type": "int"},
        "transactions_count": {"key": "transactionsCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        documents_count: int,
        valid_documents_count: int,
        erroneous_documents_count: int,
        transactions_count: int,
        **kwargs
    ):
        """
        :keyword documents_count: Number of documents submitted in the request. Required.
        :paramtype documents_count: int
        :keyword valid_documents_count: Number of valid documents. This excludes empty, over-size limit
         or non-supported languages documents. Required.
        :paramtype valid_documents_count: int
        :keyword erroneous_documents_count: Number of invalid documents. This includes empty, over-size
         limit or non-supported languages documents. Required.
        :paramtype erroneous_documents_count: int
        :keyword transactions_count: Number of transactions for the request. Required.
        :paramtype transactions_count: int
        """
        super().__init__(**kwargs)
        self.documents_count = documents_count
        self.valid_documents_count = valid_documents_count
        self.erroneous_documents_count = erroneous_documents_count
        self.transactions_count = transactions_count


class SentenceAssessment(_serialization.Model):
    """SentenceAssessment.

    All required parameters must be populated in order to send to Azure.

    :ivar sentiment: Assessment sentiment in the sentence. Required. Known values are: "positive",
     "mixed", and "negative".
    :vartype sentiment: str or ~azure.ai.textanalytics.v3_1.models.TokenSentimentValue
    :ivar confidence_scores: Assessment sentiment confidence scores in the sentence. Required.
    :vartype confidence_scores: ~azure.ai.textanalytics.v3_1.models.TargetConfidenceScoreLabel
    :ivar offset: The assessment offset from the start of the sentence. Required.
    :vartype offset: int
    :ivar length: The length of the assessment. Required.
    :vartype length: int
    :ivar text: The assessment text detected. Required.
    :vartype text: str
    :ivar is_negated: The indicator representing if the assessment is negated. Required.
    :vartype is_negated: bool
    """

    _validation = {
        'sentiment': {'required': True},
        'confidence_scores': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
        'text': {'required': True},
        'is_negated': {'required': True},
    }

    _attribute_map = {
        "sentiment": {"key": "sentiment", "type": "str"},
        "confidence_scores": {"key": "confidenceScores", "type": "TargetConfidenceScoreLabel"},
        "offset": {"key": "offset", "type": "int"},
        "length": {"key": "length", "type": "int"},
        "text": {"key": "text", "type": "str"},
        "is_negated": {"key": "isNegated", "type": "bool"},
    }

    def __init__(
        self,
        *,
        sentiment: Union[str, "_models.TokenSentimentValue"],
        confidence_scores: "_models.TargetConfidenceScoreLabel",
        offset: int,
        length: int,
        text: str,
        is_negated: bool,
        **kwargs
    ):
        """
        :keyword sentiment: Assessment sentiment in the sentence. Required. Known values are:
         "positive", "mixed", and "negative".
        :paramtype sentiment: str or ~azure.ai.textanalytics.v3_1.models.TokenSentimentValue
        :keyword confidence_scores: Assessment sentiment confidence scores in the sentence. Required.
        :paramtype confidence_scores: ~azure.ai.textanalytics.v3_1.models.TargetConfidenceScoreLabel
        :keyword offset: The assessment offset from the start of the sentence. Required.
        :paramtype offset: int
        :keyword length: The length of the assessment. Required.
        :paramtype length: int
        :keyword text: The assessment text detected. Required.
        :paramtype text: str
        :keyword is_negated: The indicator representing if the assessment is negated. Required.
        :paramtype is_negated: bool
        """
        super().__init__(**kwargs)
        self.sentiment = sentiment
        self.confidence_scores = confidence_scores
        self.offset = offset
        self.length = length
        self.text = text
        self.is_negated = is_negated


class SentenceSentiment(_serialization.Model):
    """SentenceSentiment.

    All required parameters must be populated in order to send to Azure.

    :ivar text: The sentence text. Required.
    :vartype text: str
    :ivar sentiment: The predicted Sentiment for the sentence. Required. Known values are:
     "positive", "neutral", and "negative".
    :vartype sentiment: str or ~azure.ai.textanalytics.v3_1.models.SentenceSentimentValue
    :ivar confidence_scores: The sentiment confidence score between 0 and 1 for the sentence for
     all classes. Required.
    :vartype confidence_scores:
     ~azure.ai.textanalytics.v3_1.models.SentimentConfidenceScorePerLabel
    :ivar offset: The sentence offset from the start of the document. Required.
    :vartype offset: int
    :ivar length: The length of the sentence. Required.
    :vartype length: int
    :ivar targets: The array of sentence targets for the sentence.
    :vartype targets: list[~azure.ai.textanalytics.v3_1.models.SentenceTarget]
    :ivar assessments: The array of assessments for the sentence.
    :vartype assessments: list[~azure.ai.textanalytics.v3_1.models.SentenceAssessment]
    """

    _validation = {
        'text': {'required': True},
        'sentiment': {'required': True},
        'confidence_scores': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
    }

    _attribute_map = {
        "text": {"key": "text", "type": "str"},
        "sentiment": {"key": "sentiment", "type": "str"},
        "confidence_scores": {"key": "confidenceScores", "type": "SentimentConfidenceScorePerLabel"},
        "offset": {"key": "offset", "type": "int"},
        "length": {"key": "length", "type": "int"},
        "targets": {"key": "targets", "type": "[SentenceTarget]"},
        "assessments": {"key": "assessments", "type": "[SentenceAssessment]"},
    }

    def __init__(
        self,
        *,
        text: str,
        sentiment: Union[str, "_models.SentenceSentimentValue"],
        confidence_scores: "_models.SentimentConfidenceScorePerLabel",
        offset: int,
        length: int,
        targets: Optional[List["_models.SentenceTarget"]] = None,
        assessments: Optional[List["_models.SentenceAssessment"]] = None,
        **kwargs
    ):
        """
        :keyword text: The sentence text. Required.
        :paramtype text: str
        :keyword sentiment: The predicted Sentiment for the sentence. Required. Known values are:
         "positive", "neutral", and "negative".
        :paramtype sentiment: str or ~azure.ai.textanalytics.v3_1.models.SentenceSentimentValue
        :keyword confidence_scores: The sentiment confidence score between 0 and 1 for the sentence for
         all classes. Required.
        :paramtype confidence_scores:
         ~azure.ai.textanalytics.v3_1.models.SentimentConfidenceScorePerLabel
        :keyword offset: The sentence offset from the start of the document. Required.
        :paramtype offset: int
        :keyword length: The length of the sentence. Required.
        :paramtype length: int
        :keyword targets: The array of sentence targets for the sentence.
        :paramtype targets: list[~azure.ai.textanalytics.v3_1.models.SentenceTarget]
        :keyword assessments: The array of assessments for the sentence.
        :paramtype assessments: list[~azure.ai.textanalytics.v3_1.models.SentenceAssessment]
        """
        super().__init__(**kwargs)
        self.text = text
        self.sentiment = sentiment
        self.confidence_scores = confidence_scores
        self.offset = offset
        self.length = length
        self.targets = targets
        self.assessments = assessments


class SentenceTarget(_serialization.Model):
    """SentenceTarget.

    All required parameters must be populated in order to send to Azure.

    :ivar sentiment: Targeted sentiment in the sentence. Required. Known values are: "positive",
     "mixed", and "negative".
    :vartype sentiment: str or ~azure.ai.textanalytics.v3_1.models.TokenSentimentValue
    :ivar confidence_scores: Target sentiment confidence scores for the target in the sentence.
     Required.
    :vartype confidence_scores: ~azure.ai.textanalytics.v3_1.models.TargetConfidenceScoreLabel
    :ivar offset: The target offset from the start of the sentence. Required.
    :vartype offset: int
    :ivar length: The length of the target. Required.
    :vartype length: int
    :ivar text: The target text detected. Required.
    :vartype text: str
    :ivar relations: The array of either assessment or target objects which is related to the
     target. Required.
    :vartype relations: list[~azure.ai.textanalytics.v3_1.models.TargetRelation]
    """

    _validation = {
        'sentiment': {'required': True},
        'confidence_scores': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
        'text': {'required': True},
        'relations': {'required': True},
    }

    _attribute_map = {
        "sentiment": {"key": "sentiment", "type": "str"},
        "confidence_scores": {"key": "confidenceScores", "type": "TargetConfidenceScoreLabel"},
        "offset": {"key": "offset", "type": "int"},
        "length": {"key": "length", "type": "int"},
        "text": {"key": "text", "type": "str"},
        "relations": {"key": "relations", "type": "[TargetRelation]"},
    }

    def __init__(
        self,
        *,
        sentiment: Union[str, "_models.TokenSentimentValue"],
        confidence_scores: "_models.TargetConfidenceScoreLabel",
        offset: int,
        length: int,
        text: str,
        relations: List["_models.TargetRelation"],
        **kwargs
    ):
        """
        :keyword sentiment: Targeted sentiment in the sentence. Required. Known values are: "positive",
         "mixed", and "negative".
        :paramtype sentiment: str or ~azure.ai.textanalytics.v3_1.models.TokenSentimentValue
        :keyword confidence_scores: Target sentiment confidence scores for the target in the sentence.
         Required.
        :paramtype confidence_scores: ~azure.ai.textanalytics.v3_1.models.TargetConfidenceScoreLabel
        :keyword offset: The target offset from the start of the sentence. Required.
        :paramtype offset: int
        :keyword length: The length of the target. Required.
        :paramtype length: int
        :keyword text: The target text detected. Required.
        :paramtype text: str
        :keyword relations: The array of either assessment or target objects which is related to the
         target. Required.
        :paramtype relations: list[~azure.ai.textanalytics.v3_1.models.TargetRelation]
        """
        super().__init__(**kwargs)
        self.sentiment = sentiment
        self.confidence_scores = confidence_scores
        self.offset = offset
        self.length = length
        self.text = text
        self.relations = relations


class SentimentAnalysisTask(_serialization.Model):
    """SentimentAnalysisTask.

    :ivar parameters:
    :vartype parameters: ~azure.ai.textanalytics.v3_1.models.SentimentAnalysisTaskParameters
    :ivar task_name:
    :vartype task_name: str
    """

    _attribute_map = {
        "parameters": {"key": "parameters", "type": "SentimentAnalysisTaskParameters"},
        "task_name": {"key": "taskName", "type": "str"},
    }

    def __init__(
        self,
        *,
        parameters: Optional["_models.SentimentAnalysisTaskParameters"] = None,
        task_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword parameters:
        :paramtype parameters: ~azure.ai.textanalytics.v3_1.models.SentimentAnalysisTaskParameters
        :keyword task_name:
        :paramtype task_name: str
        """
        super().__init__(**kwargs)
        self.parameters = parameters
        self.task_name = task_name


class SentimentAnalysisTaskParameters(_serialization.Model):
    """SentimentAnalysisTaskParameters.

    :ivar model_version:
    :vartype model_version: str
    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    :ivar opinion_mining:
    :vartype opinion_mining: bool
    :ivar string_index_type: Known values are: "TextElement_v8", "UnicodeCodePoint", and
     "Utf16CodeUnit".
    :vartype string_index_type: str or ~azure.ai.textanalytics.v3_1.models.StringIndexType
    """

    _attribute_map = {
        "model_version": {"key": "model-version", "type": "str"},
        "logging_opt_out": {"key": "loggingOptOut", "type": "bool"},
        "opinion_mining": {"key": "opinionMining", "type": "bool"},
        "string_index_type": {"key": "stringIndexType", "type": "str"},
    }

    def __init__(
        self,
        *,
        model_version: str = "latest",
        logging_opt_out: bool = False,
        opinion_mining: bool = False,
        string_index_type: Optional[Union[str, "_models.StringIndexType"]] = None,
        **kwargs
    ):
        """
        :keyword model_version:
        :paramtype model_version: str
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        :keyword opinion_mining:
        :paramtype opinion_mining: bool
        :keyword string_index_type: Known values are: "TextElement_v8", "UnicodeCodePoint", and
         "Utf16CodeUnit".
        :paramtype string_index_type: str or ~azure.ai.textanalytics.v3_1.models.StringIndexType
        """
        super().__init__(**kwargs)
        self.model_version = model_version
        self.logging_opt_out = logging_opt_out
        self.opinion_mining = opinion_mining
        self.string_index_type = string_index_type


class SentimentConfidenceScorePerLabel(_serialization.Model):
    """Represents the confidence scores between 0 and 1 across all sentiment classes: positive, neutral, negative.

    All required parameters must be populated in order to send to Azure.

    :ivar positive: Required.
    :vartype positive: float
    :ivar neutral: Required.
    :vartype neutral: float
    :ivar negative: Required.
    :vartype negative: float
    """

    _validation = {
        'positive': {'required': True},
        'neutral': {'required': True},
        'negative': {'required': True},
    }

    _attribute_map = {
        "positive": {"key": "positive", "type": "float"},
        "neutral": {"key": "neutral", "type": "float"},
        "negative": {"key": "negative", "type": "float"},
    }

    def __init__(
        self,
        *,
        positive: float,
        neutral: float,
        negative: float,
        **kwargs
    ):
        """
        :keyword positive: Required.
        :paramtype positive: float
        :keyword neutral: Required.
        :paramtype neutral: float
        :keyword negative: Required.
        :paramtype negative: float
        """
        super().__init__(**kwargs)
        self.positive = positive
        self.neutral = neutral
        self.negative = negative


class SentimentResponse(_serialization.Model):
    """SentimentResponse.

    All required parameters must be populated in order to send to Azure.

    :ivar documents: Sentiment analysis per document. Required.
    :vartype documents: list[~azure.ai.textanalytics.v3_1.models.DocumentSentiment]
    :ivar errors: Errors by document id. Required.
    :vartype errors: list[~azure.ai.textanalytics.v3_1.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_1.models.RequestStatistics
    :ivar model_version: This field indicates which model is used for scoring. Required.
    :vartype model_version: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        "documents": {"key": "documents", "type": "[DocumentSentiment]"},
        "errors": {"key": "errors", "type": "[DocumentError]"},
        "statistics": {"key": "statistics", "type": "RequestStatistics"},
        "model_version": {"key": "modelVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        documents: List["_models.DocumentSentiment"],
        errors: List["_models.DocumentError"],
        model_version: str,
        statistics: Optional["_models.RequestStatistics"] = None,
        **kwargs
    ):
        """
        :keyword documents: Sentiment analysis per document. Required.
        :paramtype documents: list[~azure.ai.textanalytics.v3_1.models.DocumentSentiment]
        :keyword errors: Errors by document id. Required.
        :paramtype errors: list[~azure.ai.textanalytics.v3_1.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_1.models.RequestStatistics
        :keyword model_version: This field indicates which model is used for scoring. Required.
        :paramtype model_version: str
        """
        super().__init__(**kwargs)
        self.documents = documents
        self.errors = errors
        self.statistics = statistics
        self.model_version = model_version


class SentimentTaskResult(_serialization.Model):
    """SentimentTaskResult.

    :ivar results:
    :vartype results: ~azure.ai.textanalytics.v3_1.models.SentimentResponse
    """

    _attribute_map = {
        "results": {"key": "results", "type": "SentimentResponse"},
    }

    def __init__(
        self,
        *,
        results: Optional["_models.SentimentResponse"] = None,
        **kwargs
    ):
        """
        :keyword results:
        :paramtype results: ~azure.ai.textanalytics.v3_1.models.SentimentResponse
        """
        super().__init__(**kwargs)
        self.results = results


class TargetConfidenceScoreLabel(_serialization.Model):
    """Represents the confidence scores across all sentiment classes: positive, neutral, negative.

    All required parameters must be populated in order to send to Azure.

    :ivar positive: Required.
    :vartype positive: float
    :ivar negative: Required.
    :vartype negative: float
    """

    _validation = {
        'positive': {'required': True},
        'negative': {'required': True},
    }

    _attribute_map = {
        "positive": {"key": "positive", "type": "float"},
        "negative": {"key": "negative", "type": "float"},
    }

    def __init__(
        self,
        *,
        positive: float,
        negative: float,
        **kwargs
    ):
        """
        :keyword positive: Required.
        :paramtype positive: float
        :keyword negative: Required.
        :paramtype negative: float
        """
        super().__init__(**kwargs)
        self.positive = positive
        self.negative = negative


class TargetRelation(_serialization.Model):
    """TargetRelation.

    All required parameters must be populated in order to send to Azure.

    :ivar relation_type: The type related to the target. Required. Known values are: "assessment"
     and "target".
    :vartype relation_type: str or ~azure.ai.textanalytics.v3_1.models.TargetRelationType
    :ivar ref: The JSON pointer indicating the linked object. Required.
    :vartype ref: str
    """

    _validation = {
        'relation_type': {'required': True},
        'ref': {'required': True},
    }

    _attribute_map = {
        "relation_type": {"key": "relationType", "type": "str"},
        "ref": {"key": "ref", "type": "str"},
    }

    def __init__(
        self,
        *,
        relation_type: Union[str, "_models.TargetRelationType"],
        ref: str,
        **kwargs
    ):
        """
        :keyword relation_type: The type related to the target. Required. Known values are:
         "assessment" and "target".
        :paramtype relation_type: str or ~azure.ai.textanalytics.v3_1.models.TargetRelationType
        :keyword ref: The JSON pointer indicating the linked object. Required.
        :paramtype ref: str
        """
        super().__init__(**kwargs)
        self.relation_type = relation_type
        self.ref = ref


class TasksStateTasks(_serialization.Model):
    """TasksStateTasks.

    All required parameters must be populated in order to send to Azure.

    :ivar completed: Required.
    :vartype completed: int
    :ivar failed: Required.
    :vartype failed: int
    :ivar in_progress: Required.
    :vartype in_progress: int
    :ivar total: Required.
    :vartype total: int
    :ivar entity_recognition_tasks:
    :vartype entity_recognition_tasks:
     list[~azure.ai.textanalytics.v3_1.models.TasksStateTasksEntityRecognitionTasksItem]
    :ivar entity_recognition_pii_tasks:
    :vartype entity_recognition_pii_tasks:
     list[~azure.ai.textanalytics.v3_1.models.TasksStateTasksEntityRecognitionPiiTasksItem]
    :ivar key_phrase_extraction_tasks:
    :vartype key_phrase_extraction_tasks:
     list[~azure.ai.textanalytics.v3_1.models.TasksStateTasksKeyPhraseExtractionTasksItem]
    :ivar entity_linking_tasks:
    :vartype entity_linking_tasks:
     list[~azure.ai.textanalytics.v3_1.models.TasksStateTasksEntityLinkingTasksItem]
    :ivar sentiment_analysis_tasks:
    :vartype sentiment_analysis_tasks:
     list[~azure.ai.textanalytics.v3_1.models.TasksStateTasksSentimentAnalysisTasksItem]
    """

    _validation = {
        'completed': {'required': True},
        'failed': {'required': True},
        'in_progress': {'required': True},
        'total': {'required': True},
    }

    _attribute_map = {
        "completed": {"key": "completed", "type": "int"},
        "failed": {"key": "failed", "type": "int"},
        "in_progress": {"key": "inProgress", "type": "int"},
        "total": {"key": "total", "type": "int"},
        "entity_recognition_tasks": {"key": "entityRecognitionTasks", "type": "[TasksStateTasksEntityRecognitionTasksItem]"},
        "entity_recognition_pii_tasks": {"key": "entityRecognitionPiiTasks", "type": "[TasksStateTasksEntityRecognitionPiiTasksItem]"},
        "key_phrase_extraction_tasks": {"key": "keyPhraseExtractionTasks", "type": "[TasksStateTasksKeyPhraseExtractionTasksItem]"},
        "entity_linking_tasks": {"key": "entityLinkingTasks", "type": "[TasksStateTasksEntityLinkingTasksItem]"},
        "sentiment_analysis_tasks": {"key": "sentimentAnalysisTasks", "type": "[TasksStateTasksSentimentAnalysisTasksItem]"},
    }

    def __init__(
        self,
        *,
        completed: int,
        failed: int,
        in_progress: int,
        total: int,
        entity_recognition_tasks: Optional[List["_models.TasksStateTasksEntityRecognitionTasksItem"]] = None,
        entity_recognition_pii_tasks: Optional[List["_models.TasksStateTasksEntityRecognitionPiiTasksItem"]] = None,
        key_phrase_extraction_tasks: Optional[List["_models.TasksStateTasksKeyPhraseExtractionTasksItem"]] = None,
        entity_linking_tasks: Optional[List["_models.TasksStateTasksEntityLinkingTasksItem"]] = None,
        sentiment_analysis_tasks: Optional[List["_models.TasksStateTasksSentimentAnalysisTasksItem"]] = None,
        **kwargs
    ):
        """
        :keyword completed: Required.
        :paramtype completed: int
        :keyword failed: Required.
        :paramtype failed: int
        :keyword in_progress: Required.
        :paramtype in_progress: int
        :keyword total: Required.
        :paramtype total: int
        :keyword entity_recognition_tasks:
        :paramtype entity_recognition_tasks:
         list[~azure.ai.textanalytics.v3_1.models.TasksStateTasksEntityRecognitionTasksItem]
        :keyword entity_recognition_pii_tasks:
        :paramtype entity_recognition_pii_tasks:
         list[~azure.ai.textanalytics.v3_1.models.TasksStateTasksEntityRecognitionPiiTasksItem]
        :keyword key_phrase_extraction_tasks:
        :paramtype key_phrase_extraction_tasks:
         list[~azure.ai.textanalytics.v3_1.models.TasksStateTasksKeyPhraseExtractionTasksItem]
        :keyword entity_linking_tasks:
        :paramtype entity_linking_tasks:
         list[~azure.ai.textanalytics.v3_1.models.TasksStateTasksEntityLinkingTasksItem]
        :keyword sentiment_analysis_tasks:
        :paramtype sentiment_analysis_tasks:
         list[~azure.ai.textanalytics.v3_1.models.TasksStateTasksSentimentAnalysisTasksItem]
        """
        super().__init__(**kwargs)
        self.completed = completed
        self.failed = failed
        self.in_progress = in_progress
        self.total = total
        self.entity_recognition_tasks = entity_recognition_tasks
        self.entity_recognition_pii_tasks = entity_recognition_pii_tasks
        self.key_phrase_extraction_tasks = key_phrase_extraction_tasks
        self.entity_linking_tasks = entity_linking_tasks
        self.sentiment_analysis_tasks = sentiment_analysis_tasks


class TaskState(_serialization.Model):
    """TaskState.

    All required parameters must be populated in order to send to Azure.

    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar task_name: Required.
    :vartype task_name: str
    :ivar status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
     "rejected", "cancelled", and "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.v3_1.models.State
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'task_name': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        "last_update_date_time": {"key": "lastUpdateDateTime", "type": "iso-8601"},
        "task_name": {"key": "taskName", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        task_name: str,
        status: Union[str, "_models.State"],
        **kwargs
    ):
        """
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword task_name: Required.
        :paramtype task_name: str
        :keyword status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
         "rejected", "cancelled", and "cancelling".
        :paramtype status: str or ~azure.ai.textanalytics.v3_1.models.State
        """
        super().__init__(**kwargs)
        self.last_update_date_time = last_update_date_time
        self.task_name = task_name
        self.status = status


class TasksStateTasksEntityLinkingTasksItem(TaskState, EntityLinkingTaskResult):
    """TasksStateTasksEntityLinkingTasksItem.

    All required parameters must be populated in order to send to Azure.

    :ivar results:
    :vartype results: ~azure.ai.textanalytics.v3_1.models.EntityLinkingResult
    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar task_name: Required.
    :vartype task_name: str
    :ivar status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
     "rejected", "cancelled", and "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.v3_1.models.State
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'task_name': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        "results": {"key": "results", "type": "EntityLinkingResult"},
        "last_update_date_time": {"key": "lastUpdateDateTime", "type": "iso-8601"},
        "task_name": {"key": "taskName", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        task_name: str,
        status: Union[str, "_models.State"],
        results: Optional["_models.EntityLinkingResult"] = None,
        **kwargs
    ):
        """
        :keyword results:
        :paramtype results: ~azure.ai.textanalytics.v3_1.models.EntityLinkingResult
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword task_name: Required.
        :paramtype task_name: str
        :keyword status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
         "rejected", "cancelled", and "cancelling".
        :paramtype status: str or ~azure.ai.textanalytics.v3_1.models.State
        """
        super().__init__(last_update_date_time=last_update_date_time, task_name=task_name, status=status, results=results, **kwargs)
        self.results = results
        self.last_update_date_time = last_update_date_time
        self.task_name = task_name
        self.status = status


class TasksStateTasksEntityRecognitionPiiTasksItem(TaskState, PiiTaskResult):
    """TasksStateTasksEntityRecognitionPiiTasksItem.

    All required parameters must be populated in order to send to Azure.

    :ivar results:
    :vartype results: ~azure.ai.textanalytics.v3_1.models.PiiResult
    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar task_name: Required.
    :vartype task_name: str
    :ivar status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
     "rejected", "cancelled", and "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.v3_1.models.State
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'task_name': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        "results": {"key": "results", "type": "PiiResult"},
        "last_update_date_time": {"key": "lastUpdateDateTime", "type": "iso-8601"},
        "task_name": {"key": "taskName", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        task_name: str,
        status: Union[str, "_models.State"],
        results: Optional["_models.PiiResult"] = None,
        **kwargs
    ):
        """
        :keyword results:
        :paramtype results: ~azure.ai.textanalytics.v3_1.models.PiiResult
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword task_name: Required.
        :paramtype task_name: str
        :keyword status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
         "rejected", "cancelled", and "cancelling".
        :paramtype status: str or ~azure.ai.textanalytics.v3_1.models.State
        """
        super().__init__(last_update_date_time=last_update_date_time, task_name=task_name, status=status, results=results, **kwargs)
        self.results = results
        self.last_update_date_time = last_update_date_time
        self.task_name = task_name
        self.status = status


class TasksStateTasksEntityRecognitionTasksItem(TaskState, EntitiesTaskResult):
    """TasksStateTasksEntityRecognitionTasksItem.

    All required parameters must be populated in order to send to Azure.

    :ivar results:
    :vartype results: ~azure.ai.textanalytics.v3_1.models.EntitiesResult
    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar task_name: Required.
    :vartype task_name: str
    :ivar status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
     "rejected", "cancelled", and "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.v3_1.models.State
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'task_name': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        "results": {"key": "results", "type": "EntitiesResult"},
        "last_update_date_time": {"key": "lastUpdateDateTime", "type": "iso-8601"},
        "task_name": {"key": "taskName", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        task_name: str,
        status: Union[str, "_models.State"],
        results: Optional["_models.EntitiesResult"] = None,
        **kwargs
    ):
        """
        :keyword results:
        :paramtype results: ~azure.ai.textanalytics.v3_1.models.EntitiesResult
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword task_name: Required.
        :paramtype task_name: str
        :keyword status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
         "rejected", "cancelled", and "cancelling".
        :paramtype status: str or ~azure.ai.textanalytics.v3_1.models.State
        """
        super().__init__(last_update_date_time=last_update_date_time, task_name=task_name, status=status, results=results, **kwargs)
        self.results = results
        self.last_update_date_time = last_update_date_time
        self.task_name = task_name
        self.status = status


class TasksStateTasksKeyPhraseExtractionTasksItem(TaskState, KeyPhraseTaskResult):
    """TasksStateTasksKeyPhraseExtractionTasksItem.

    All required parameters must be populated in order to send to Azure.

    :ivar results:
    :vartype results: ~azure.ai.textanalytics.v3_1.models.KeyPhraseResult
    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar task_name: Required.
    :vartype task_name: str
    :ivar status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
     "rejected", "cancelled", and "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.v3_1.models.State
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'task_name': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        "results": {"key": "results", "type": "KeyPhraseResult"},
        "last_update_date_time": {"key": "lastUpdateDateTime", "type": "iso-8601"},
        "task_name": {"key": "taskName", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        task_name: str,
        status: Union[str, "_models.State"],
        results: Optional["_models.KeyPhraseResult"] = None,
        **kwargs
    ):
        """
        :keyword results:
        :paramtype results: ~azure.ai.textanalytics.v3_1.models.KeyPhraseResult
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword task_name: Required.
        :paramtype task_name: str
        :keyword status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
         "rejected", "cancelled", and "cancelling".
        :paramtype status: str or ~azure.ai.textanalytics.v3_1.models.State
        """
        super().__init__(last_update_date_time=last_update_date_time, task_name=task_name, status=status, results=results, **kwargs)
        self.results = results
        self.last_update_date_time = last_update_date_time
        self.task_name = task_name
        self.status = status


class TasksStateTasksSentimentAnalysisTasksItem(TaskState, SentimentTaskResult):
    """TasksStateTasksSentimentAnalysisTasksItem.

    All required parameters must be populated in order to send to Azure.

    :ivar results:
    :vartype results: ~azure.ai.textanalytics.v3_1.models.SentimentResponse
    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar task_name: Required.
    :vartype task_name: str
    :ivar status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
     "rejected", "cancelled", and "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.v3_1.models.State
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'task_name': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        "results": {"key": "results", "type": "SentimentResponse"},
        "last_update_date_time": {"key": "lastUpdateDateTime", "type": "iso-8601"},
        "task_name": {"key": "taskName", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        task_name: str,
        status: Union[str, "_models.State"],
        results: Optional["_models.SentimentResponse"] = None,
        **kwargs
    ):
        """
        :keyword results:
        :paramtype results: ~azure.ai.textanalytics.v3_1.models.SentimentResponse
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword task_name: Required.
        :paramtype task_name: str
        :keyword status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
         "rejected", "cancelled", and "cancelling".
        :paramtype status: str or ~azure.ai.textanalytics.v3_1.models.State
        """
        super().__init__(last_update_date_time=last_update_date_time, task_name=task_name, status=status, results=results, **kwargs)
        self.results = results
        self.last_update_date_time = last_update_date_time
        self.task_name = task_name
        self.status = status


class TextAnalyticsError(_serialization.Model):
    """TextAnalyticsError.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Error code. Required. Known values are: "InvalidRequest", "InvalidArgument",
     "InternalServerError", "ServiceUnavailable", and "NotFound".
    :vartype code: str or ~azure.ai.textanalytics.v3_1.models.ErrorCodeValue
    :ivar message: Error message. Required.
    :vartype message: str
    :ivar target: Error target.
    :vartype target: str
    :ivar innererror: Inner error contains more specific information.
    :vartype innererror: ~azure.ai.textanalytics.v3_1.models.InnerError
    :ivar details: Details about specific errors that led to this reported error.
    :vartype details: list[~azure.ai.textanalytics.v3_1.models.TextAnalyticsError]
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "innererror": {"key": "innererror", "type": "InnerError"},
        "details": {"key": "details", "type": "[TextAnalyticsError]"},
    }

    def __init__(
        self,
        *,
        code: Union[str, "_models.ErrorCodeValue"],
        message: str,
        target: Optional[str] = None,
        innererror: Optional["_models.InnerError"] = None,
        details: Optional[List["_models.TextAnalyticsError"]] = None,
        **kwargs
    ):
        """
        :keyword code: Error code. Required. Known values are: "InvalidRequest", "InvalidArgument",
         "InternalServerError", "ServiceUnavailable", and "NotFound".
        :paramtype code: str or ~azure.ai.textanalytics.v3_1.models.ErrorCodeValue
        :keyword message: Error message. Required.
        :paramtype message: str
        :keyword target: Error target.
        :paramtype target: str
        :keyword innererror: Inner error contains more specific information.
        :paramtype innererror: ~azure.ai.textanalytics.v3_1.models.InnerError
        :keyword details: Details about specific errors that led to this reported error.
        :paramtype details: list[~azure.ai.textanalytics.v3_1.models.TextAnalyticsError]
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.innererror = innererror
        self.details = details


class TextAnalyticsWarning(_serialization.Model):
    """TextAnalyticsWarning.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Error code. Required. Known values are: "LongWordsInDocument" and
     "DocumentTruncated".
    :vartype code: str or ~azure.ai.textanalytics.v3_1.models.WarningCodeValue
    :ivar message: Warning message. Required.
    :vartype message: str
    :ivar target_ref: A JSON pointer reference indicating the target object.
    :vartype target_ref: str
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target_ref": {"key": "targetRef", "type": "str"},
    }

    def __init__(
        self,
        *,
        code: Union[str, "_models.WarningCodeValue"],
        message: str,
        target_ref: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword code: Error code. Required. Known values are: "LongWordsInDocument" and
         "DocumentTruncated".
        :paramtype code: str or ~azure.ai.textanalytics.v3_1.models.WarningCodeValue
        :keyword message: Warning message. Required.
        :paramtype message: str
        :keyword target_ref: A JSON pointer reference indicating the target object.
        :paramtype target_ref: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target_ref = target_ref
