
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <gp_Pnt2d.hxx>
#include <gp_Vec2d.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <gp_Pnt2d.hxx>
#include <gp_Vec2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <Geom2dEvaluator.hxx>
#include <Geom2dEvaluator_Curve.hxx>
#include <Geom2dEvaluator_OffsetCurve.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_Geom2dEvaluator(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("Geom2dEvaluator"));
py::object klass;

//Python trampoline classes
    class Py_Geom2dEvaluator_Curve : public Geom2dEvaluator_Curve{
    public:
        using Geom2dEvaluator_Curve::Geom2dEvaluator_Curve;


        // public pure virtual
        void D0( const Standard_Real theU,gp_Pnt2d & theValue) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Geom2dEvaluator_Curve,D0,theU,theValue) };
        void D1( const Standard_Real theU,gp_Pnt2d & theValue,gp_Vec2d & theD1) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Geom2dEvaluator_Curve,D1,theU,theValue,theD1) };
        void D2( const Standard_Real theU,gp_Pnt2d & theValue,gp_Vec2d & theD1,gp_Vec2d & theD2) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Geom2dEvaluator_Curve,D2,theU,theValue,theD1,theD2) };
        void D3( const Standard_Real theU,gp_Pnt2d & theValue,gp_Vec2d & theD1,gp_Vec2d & theD2,gp_Vec2d & theD3) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Geom2dEvaluator_Curve,D3,theU,theValue,theD1,theD2,theD3) };
        gp_Vec2d DN( const Standard_Real theU, const Standard_Integer theDerU) const  override { using return_type = gp_Vec2d;
    PYBIND11_OVERLOAD_PURE(return_type,Geom2dEvaluator_Curve,DN,theU,theDerU) };
        handle<Geom2dEvaluator_Curve> ShallowCopy() const  override { using return_type = handle<Geom2dEvaluator_Curve>;
    PYBIND11_OVERLOAD_PURE(return_type,Geom2dEvaluator_Curve,ShallowCopy,) };


        // protected pure virtual


        // private pure virtual

    };

// classes

    // Class Geom2dEvaluator from ./opencascade/Geom2dEvaluator.hxx
    klass = m.attr("Geom2dEvaluator");

    // default constructor
    register_default_constructor<Geom2dEvaluator , shared_ptr<Geom2dEvaluator>>(m,"Geom2dEvaluator");

    // nested enums

    static_cast<py::class_<Geom2dEvaluator , shared_ptr<Geom2dEvaluator>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("CalculateD0_s",
                    (void (*)( gp_Pnt2d & ,   const gp_Vec2d & ,   const Standard_Real  ) ) static_cast<void (*)( gp_Pnt2d & ,   const gp_Vec2d & ,   const Standard_Real  ) >(&Geom2dEvaluator::CalculateD0),
                    R"#(Recalculate D1 values of base curve into D0 value of offset curve)#"  , py::arg("theValue"),  py::arg("theD1"),  py::arg("theOffset")
          )
        .def_static("CalculateD1_s",
                    (void (*)( gp_Pnt2d & ,  gp_Vec2d & ,   const gp_Vec2d & ,   const Standard_Real  ) ) static_cast<void (*)( gp_Pnt2d & ,  gp_Vec2d & ,   const gp_Vec2d & ,   const Standard_Real  ) >(&Geom2dEvaluator::CalculateD1),
                    R"#(Recalculate D2 values of base curve into D1 values of offset curve)#"  , py::arg("theValue"),  py::arg("theD1"),  py::arg("theD2"),  py::arg("theOffset")
          )
        .def_static("CalculateD2_s",
                    (void (*)( gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d & ,   const gp_Vec2d & ,   const Standard_Boolean ,   const Standard_Real  ) ) static_cast<void (*)( gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d & ,   const gp_Vec2d & ,   const Standard_Boolean ,   const Standard_Real  ) >(&Geom2dEvaluator::CalculateD2),
                    R"#(Recalculate D3 values of base curve into D2 values of offset curve)#"  , py::arg("theValue"),  py::arg("theD1"),  py::arg("theD2"),  py::arg("theD3"),  py::arg("theIsDirChange"),  py::arg("theOffset")
          )
        .def_static("CalculateD3_s",
                    (void (*)( gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d & ,  gp_Vec2d & ,   const gp_Vec2d & ,   const Standard_Boolean ,   const Standard_Real  ) ) static_cast<void (*)( gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d & ,  gp_Vec2d & ,   const gp_Vec2d & ,   const Standard_Boolean ,   const Standard_Real  ) >(&Geom2dEvaluator::CalculateD3),
                    R"#(Recalculate D3 values of base curve into D3 values of offset curve)#"  , py::arg("theValue"),  py::arg("theD1"),  py::arg("theD2"),  py::arg("theD3"),  py::arg("theD4"),  py::arg("theIsDirChange"),  py::arg("theOffset")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class Geom2dEvaluator_Curve from ./opencascade/Geom2dEvaluator_Curve.hxx
    klass = m.attr("Geom2dEvaluator_Curve");


    // nested enums

    static_cast<py::class_<Geom2dEvaluator_Curve ,opencascade::handle<Geom2dEvaluator_Curve> ,Py_Geom2dEvaluator_Curve , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("D0",
             (void (Geom2dEvaluator_Curve::*)(  const Standard_Real ,  gp_Pnt2d &  ) const) static_cast<void (Geom2dEvaluator_Curve::*)(  const Standard_Real ,  gp_Pnt2d &  ) const>(&Geom2dEvaluator_Curve::D0),
             R"#(Value of 2D curve)#"  , py::arg("theU"),  py::arg("theValue")
          )
        .def("D1",
             (void (Geom2dEvaluator_Curve::*)(  const Standard_Real ,  gp_Pnt2d & ,  gp_Vec2d &  ) const) static_cast<void (Geom2dEvaluator_Curve::*)(  const Standard_Real ,  gp_Pnt2d & ,  gp_Vec2d &  ) const>(&Geom2dEvaluator_Curve::D1),
             R"#(Value and first derivatives of curve)#"  , py::arg("theU"),  py::arg("theValue"),  py::arg("theD1")
          )
        .def("D2",
             (void (Geom2dEvaluator_Curve::*)(  const Standard_Real ,  gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d &  ) const) static_cast<void (Geom2dEvaluator_Curve::*)(  const Standard_Real ,  gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d &  ) const>(&Geom2dEvaluator_Curve::D2),
             R"#(Value, first and second derivatives of curve)#"  , py::arg("theU"),  py::arg("theValue"),  py::arg("theD1"),  py::arg("theD2")
          )
        .def("D3",
             (void (Geom2dEvaluator_Curve::*)(  const Standard_Real ,  gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d & ,  gp_Vec2d &  ) const) static_cast<void (Geom2dEvaluator_Curve::*)(  const Standard_Real ,  gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d & ,  gp_Vec2d &  ) const>(&Geom2dEvaluator_Curve::D3),
             R"#(Value, first, second and third derivatives of curve)#"  , py::arg("theU"),  py::arg("theValue"),  py::arg("theD1"),  py::arg("theD2"),  py::arg("theD3")
          )
        .def("DN",
             (gp_Vec2d (Geom2dEvaluator_Curve::*)(  const Standard_Real ,   const Standard_Integer  ) const) static_cast<gp_Vec2d (Geom2dEvaluator_Curve::*)(  const Standard_Real ,   const Standard_Integer  ) const>(&Geom2dEvaluator_Curve::DN),
             R"#(Calculates N-th derivatives of curve, where N = theDerU. Raises if N < 1)#"  , py::arg("theU"),  py::arg("theDerU")
          )
        .def("ShallowCopy",
             (handle<Geom2dEvaluator_Curve> (Geom2dEvaluator_Curve::*)() const) static_cast<handle<Geom2dEvaluator_Curve> (Geom2dEvaluator_Curve::*)() const>(&Geom2dEvaluator_Curve::ShallowCopy),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&Geom2dEvaluator_Curve::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&Geom2dEvaluator_Curve::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (Geom2dEvaluator_Curve::*)() const) static_cast< const handle<Standard_Type> & (Geom2dEvaluator_Curve::*)() const>(&Geom2dEvaluator_Curve::DynamicType),
             R"#()#"
             
         )
;

    // Class Geom2dEvaluator_OffsetCurve from ./opencascade/Geom2dEvaluator_OffsetCurve.hxx
    klass = m.attr("Geom2dEvaluator_OffsetCurve");


    // nested enums

    static_cast<py::class_<Geom2dEvaluator_OffsetCurve ,opencascade::handle<Geom2dEvaluator_OffsetCurve>  , Geom2dEvaluator_Curve >>(klass)
    // constructors
        .def(py::init<  const handle<Geom2d_Curve> &, const Standard_Real >()  , py::arg("theBase"),  py::arg("theOffset") )
        .def(py::init<  const handle<Geom2dAdaptor_Curve> &, const Standard_Real >()  , py::arg("theBase"),  py::arg("theOffset") )
    // custom constructors
    // methods
        .def("SetOffsetValue",
             (void (Geom2dEvaluator_OffsetCurve::*)( Standard_Real  ) ) static_cast<void (Geom2dEvaluator_OffsetCurve::*)( Standard_Real  ) >(&Geom2dEvaluator_OffsetCurve::SetOffsetValue),
             R"#(Change the offset value)#"  , py::arg("theOffset")
          )
        .def("D0",
             (void (Geom2dEvaluator_OffsetCurve::*)(  const Standard_Real ,  gp_Pnt2d &  ) const) static_cast<void (Geom2dEvaluator_OffsetCurve::*)(  const Standard_Real ,  gp_Pnt2d &  ) const>(&Geom2dEvaluator_OffsetCurve::D0),
             R"#(Value of curve)#"  , py::arg("theU"),  py::arg("theValue")
          )
        .def("D1",
             (void (Geom2dEvaluator_OffsetCurve::*)(  const Standard_Real ,  gp_Pnt2d & ,  gp_Vec2d &  ) const) static_cast<void (Geom2dEvaluator_OffsetCurve::*)(  const Standard_Real ,  gp_Pnt2d & ,  gp_Vec2d &  ) const>(&Geom2dEvaluator_OffsetCurve::D1),
             R"#(Value and first derivatives of curve)#"  , py::arg("theU"),  py::arg("theValue"),  py::arg("theD1")
          )
        .def("D2",
             (void (Geom2dEvaluator_OffsetCurve::*)(  const Standard_Real ,  gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d &  ) const) static_cast<void (Geom2dEvaluator_OffsetCurve::*)(  const Standard_Real ,  gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d &  ) const>(&Geom2dEvaluator_OffsetCurve::D2),
             R"#(Value, first and second derivatives of curve)#"  , py::arg("theU"),  py::arg("theValue"),  py::arg("theD1"),  py::arg("theD2")
          )
        .def("D3",
             (void (Geom2dEvaluator_OffsetCurve::*)(  const Standard_Real ,  gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d & ,  gp_Vec2d &  ) const) static_cast<void (Geom2dEvaluator_OffsetCurve::*)(  const Standard_Real ,  gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d & ,  gp_Vec2d &  ) const>(&Geom2dEvaluator_OffsetCurve::D3),
             R"#(Value, first, second and third derivatives of curve)#"  , py::arg("theU"),  py::arg("theValue"),  py::arg("theD1"),  py::arg("theD2"),  py::arg("theD3")
          )
        .def("DN",
             (gp_Vec2d (Geom2dEvaluator_OffsetCurve::*)(  const Standard_Real ,   const Standard_Integer  ) const) static_cast<gp_Vec2d (Geom2dEvaluator_OffsetCurve::*)(  const Standard_Real ,   const Standard_Integer  ) const>(&Geom2dEvaluator_OffsetCurve::DN),
             R"#(Calculates N-th derivatives of curve, where N = theDeriv. Raises if N < 1)#"  , py::arg("theU"),  py::arg("theDeriv")
          )
        .def("ShallowCopy",
             (handle<Geom2dEvaluator_Curve> (Geom2dEvaluator_OffsetCurve::*)() const) static_cast<handle<Geom2dEvaluator_Curve> (Geom2dEvaluator_OffsetCurve::*)() const>(&Geom2dEvaluator_OffsetCurve::ShallowCopy),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&Geom2dEvaluator_OffsetCurve::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&Geom2dEvaluator_OffsetCurve::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (Geom2dEvaluator_OffsetCurve::*)() const) static_cast< const handle<Standard_Type> & (Geom2dEvaluator_OffsetCurve::*)() const>(&Geom2dEvaluator_OffsetCurve::DynamicType),
             R"#()#"
             
         )
;

// functions

// ./opencascade/Geom2dEvaluator.hxx
// ./opencascade/Geom2dEvaluator_Curve.hxx
// ./opencascade/Geom2dEvaluator_OffsetCurve.hxx

// Additional functions


// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
