#ifndef _FTPFS_CACHE_H_
#define _FTPFS_CACHE_H_

#define FTP_CACHE_LEN	5
#define FTP_CACHE_HASH	5
#define FTP_CACHE_TTL 30

struct ftp_dir_entry{
	umode_t		mode;
	char*		name;
	off_t		size;
	nlink_t		nlink;
	unsigned long	blocksize;
	unsigned long	blocks;
	time_t		atime;
};

struct ftp_dirlist_node{
	struct ftp_dirlist_node *prev, *next;
	struct ftp_dir_entry entry;
};

struct ftp_directory{
	struct ftp_dirlist_node *head;
	int			valid;
	time_t			time;
	char			*name;
};

struct ftp_hashlist_node{
	struct ftp_hashlist_node *prev, *next;
	struct ftp_directory	 directory;
};

struct ftp_dir_cache{
	struct ftp_hashlist_node *hash[FTP_CACHE_HASH];
	unsigned len[FTP_CACHE_HASH];
};

struct ftp_sb_info;

void ftp_cache_init(struct ftp_sb_info*);
int ftp_cache_empty(struct ftp_sb_info*);
int ftp_cache_get(struct ftp_sb_info*, char*, struct ftp_directory**);
void ftp_cache_invalidate(struct dentry*);

#endif
