/* 
 * linux/fs/supermount/init.c
 *
 *  (C) Copyright 2001-2002 Juan Quintela <quintela@mandrakesoft.com>
 *      Released unde GPL v2.
 *  Rewritten for kernel 2.4.21 (C) 2003 Andrey Borzenkov
 *                                       (arvidjaar@mail.ru)
 *
 *  $Id: init.c,v 1.7 2003/07/22 17:07:30 bor Exp $
 */

#include "supermount.h"
#include <linux/init.h>

DECLARE_FSTYPE(supermount_fs_type, "supermount",
		      supermount_read_super, FS_NO_SUBMNT);

static int __init
init_supermount_fs(void)
{
	int rc = register_filesystem(&supermount_fs_type);
	
	if (!rc) {
		supermount_proc_register();
	}

	return rc;
}

static void __exit
exit_supermount_fs(void)
{
	supermount_proc_unregister();
	unregister_filesystem(&supermount_fs_type);
}

EXPORT_NO_SYMBOLS;

MODULE_AUTHOR("Stephen Tweedie, Alexis Mikhailov, Juan Quintela, Andrey Borzenkov and others");
MODULE_DESCRIPTION("Supermount");
MODULE_LICENSE("GPL");
module_init(init_supermount_fs);
module_exit(exit_supermount_fs);
