/********************************** */
/* Rule Set Based Access Control    */
/* Author and (c) 1999-2001:        */
/*   Amon Ott <ao@rsbac.org>        */
/* Getname functions for CAP module */
/* Last modified: 03/Sep/2001       */
/********************************** */

#ifndef __KERNEL__

#include <rsbac/getname.h>
#include <rsbac/cap_getname.h>
#include <rsbac/helpers.h>
#include <rsbac/error.h>

#include <string.h>

static char  cap_list[RSBAC_CAP_MAX+1][17] = {
   "CHOWN",
   "DAC_OVERRIDE",
   "DAC_READ_SEARCH",
   "FOWNER",
   "FSETID",
   "KILL",
   "SETGID",
   "SETUID",
   "SETPCAP",
   "LINUX_IMMUTABLE",
   "NET_BIND_SERVICE",
   "NET_BROADCAST",
   "NET_ADMIN",
   "NET_RAW",
   "IPC_LOCK",
   "IPC_OWNER",
   "SYS_MODULE",
   "SYS_RAWIO",
   "SYS_CHROOT",
   "SYS_PTRACE",
   "SYS_PACCT",
   "SYS_ADMIN",
   "SYS_BOOT",
   "SYS_NICE",
   "SYS_RESOURCE",
   "SYS_TIME",
   "SYS_TTY_CONFIG",
   "MKNOD",
   "LEASE",
   "NONE" };

/*****************************************/

char * get_cap_name(char * name,
                    u_int value)
  {
    if(!name)
      return(NULL);
    if(value > CAP_NONE)
      strcpy(name, "ERROR!");
    else
      strcpy(name, cap_list[value]);
    return(name);
  };

int get_cap_nr(const char * name)
  {
    int i;
    
    if(!name)
      return(RT_NONE);
    for (i = 0; i < CAP_NONE; i++)
      {
        if (!strcmp(name, cap_list[i]))
          {
            return(i);
          }
      }
    return(CAP_NONE);
  };

#endif /* !__KERNEL__ */
