/* $Id: cap.in,v 1.3 2002/07/08 11:14:33 karol Exp $
 * cap - interface for CPU patch; setting CPU limit
 *
 * Copyright (c) 2002 Karol 'Broege' Golab, TLS-Technologies
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/resource.h>
#include <linux/unistd.h>

/* ugly hack - syscall number is not constant so it will be set by make */
#ifndef __NR_setcpucap
#define __NR_setcpucap      260
#endif

_syscall3(int, setcpucap, int, which, int, who, int, cap);

void show_help(void)
{
	printf("Usage: cap <pid> <CPU percentage>\n");

	exit(0);
}


void show_version(void)
{
	printf("This is cap - CPU patch utility, $version: $\n\n");
	printf("Written by Karol 'Broege' Golab\n");
	printf("Copyright (c) 2002 TLS-Technologies\n\n");
	printf("This is free software; see the source for copying conditions.\n");
	printf("There is NO warranty; not even for MERCHANTABILITY\n");
	printf("or FITNESS FOR A PARTICULAR PURPOSE.\n");

	exit(0);
}


void error(const char *msg)
{
	fprintf(stderr, "%s\n", msg);

	exit(1);
}


int main(int argc, const char *argv[])
{
	int pid, perc;
	int ret;
	char *bad;

	if (argc<3) show_help();
	if (! strcmp(argv[1], "--version")) show_version();
	if (argc!=3) show_help();

	pid=strtol(argv[1], &bad, 10);
	if (! argv[1][0] || bad[0]) error("Cannot parse argument 1");
	perc=strtol(argv[2], &bad, 10);
	if (! argv[2][0] || bad[0]) error("Cannot parse argument 2");

	ret=setcpucap(PRIO_PROCESS, pid, perc);
	if (ret!=0) error("Priority was not changed");
	return 0;
}


