#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/kernel_stat.h>

#include <asm/system.h>
#include <asm/irq.h>
#include <asm/traps.h>
#include <asm/page.h>
#include <asm/machdep.h>
#include <asm/apollohw.h>

static irq_handler_t dn_irqs[16];

extern void write_keyb_cmd(u_short length, u_char *cmd);
static char BellOnCommand[] =  { 0xFF, 0x21, 0x81 },
		    BellOffCommand[] = { 0xFF, 0x21, 0x82 };

void dn_process_int(int irq, struct pt_regs *fp) {

#if 0
  unsigned char x;
#endif 

#if 0
  printk("Aha DN interrupt ! : %d\n",irq);
#endif

  if(dn_irqs[irq-160].handler) {
    dn_irqs[irq-160].handler(irq,dn_irqs[irq-160].dev_id,fp);
  }
  else {
    printk("spurious irq %d occured\n",irq);
  }

#if 0  
  printk("*(0x10803) %02x\n",*(volatile unsigned char *)(IO_BASE+0x10803));
  x=*(volatile unsigned char *)(IO_BASE+0x10805);
#endif

  *(volatile unsigned char *)(IO_BASE+0x11000)=0x20;
  *(volatile unsigned char *)(IO_BASE+0x11100)=0x20;

}

void dn_init_IRQ(void) {

  int i;

  printk("Init IRQ\n");

  for(i=0;i<16;i++) {
    dn_irqs[i].handler=NULL;
    dn_irqs[i].flags=IRQ_FLG_STD;
    dn_irqs[i].dev_id=NULL;
    dn_irqs[i].devname=NULL;
  }
  
}

int dn_request_irq(unsigned int irq, void (*handler)(int, void *, struct pt_regs *), unsigned long flags, const char *devname, void *dev_id) {

  printk("dn request IRQ\n");

  if((irq<0) || (irq>15)) {
    printk("Trying to request illegal IRQ\n");
    return -ENXIO;
  }

  if(!dn_irqs[irq].handler) {
    dn_irqs[irq].handler=handler;
    dn_irqs[irq].flags=IRQ_FLG_STD;
    dn_irqs[irq].dev_id=dev_id;
    dn_irqs[irq].devname=devname;
    if(irq<8)
      *(volatile unsigned char *)(IO_BASE+PICA+1)&=~(1<<irq);
    else
      *(volatile unsigned char *)(IO_BASE+PICB+1)&=~(1<<(irq-8));
    return 0;
  }
  else {
    printk("Trying to request already assigned irq %d\n",irq);
    return -ENXIO;
  }

}

void dn_free_irq(unsigned int irq, void *dev_id) {

  printk("dn free irq\n");

  if((irq<0) || (irq>15)) {
    printk("Trying to free illegal IRQ\n");
    return ;
  }

  if(irq<8)
    *(volatile unsigned char *)(IO_BASE+PICA+1)|=(1<<irq);
  else
    *(volatile unsigned char *)(IO_BASE+PICB+1)|=(1<<(irq-8));  

  dn_irqs[irq].handler=NULL;
  dn_irqs[irq].flags=IRQ_FLG_STD;
  dn_irqs[irq].dev_id=NULL;
  dn_irqs[irq].devname=NULL;

  return ;

}

void dn_enable_irq(unsigned int irq) {

  printk("dn enable irq\n");

}

void dn_disable_irq(unsigned int irq) {

  printk("dn disable irq\n");

}

int dn_get_irq_list(char *buf) {

  printk("dn get irq list\n");

  return 0;

}

struct fb_info *dn_dummy_fb_init(long *mem_start) {

  printk("fb init\n");

  return NULL;

}

static void dn_nosound (unsigned long ignored) {

	write_keyb_cmd(sizeof(BellOffCommand),BellOffCommand);

}

void dn_mksound( unsigned int count, unsigned int ticks ) {

	static struct timer_list sound_timer = { NULL, NULL, 0, 0,
       										 dn_nosound };

	del_timer( &sound_timer );
	if(count) {
		write_keyb_cmd(sizeof(BellOnCommand),BellOnCommand);
		if (ticks) {
       		sound_timer.expires = jiffies + ticks;
			add_timer( &sound_timer );
		}
	}
	else
		write_keyb_cmd(sizeof(BellOffCommand),BellOffCommand);
}

void dn_dummy_video_setup(char *options,int *ints) {

  printk("no video yet\n");

}
