/*
 * Copyright (C) 2013 Freescale Semiconductor, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <linux/err.h>
#include <linux/init.h>
#include <linux/io.h>
#include <linux/module.h>
#include <linux/of.h>
#include <linux/of_device.h>
#include <linux/pinctrl/pinctrl.h>

#include "pinctrl-imx.h"

enum imx6sl_pads {
	MX6SL_PAD_RESERVE0 = 0,
	MX6SL_PAD_RESERVE1 = 1,
	MX6SL_PAD_RESERVE2 = 2,
	MX6SL_PAD_RESERVE3 = 3,
	MX6SL_PAD_RESERVE4 = 4,
	MX6SL_PAD_RESERVE5 = 5,
	MX6SL_PAD_RESERVE6 = 6,
	MX6SL_PAD_RESERVE7 = 7,
	MX6SL_PAD_RESERVE8 = 8,
	MX6SL_PAD_RESERVE9 = 9,
	MX6SL_PAD_RESERVE10 = 10,
	MX6SL_PAD_RESERVE11 = 11,
	MX6SL_PAD_RESERVE12 = 12,
	MX6SL_PAD_RESERVE13 = 13,
	MX6SL_PAD_RESERVE14 = 14,
	MX6SL_PAD_RESERVE15 = 15,
	MX6SL_PAD_RESERVE16 = 16,
	MX6SL_PAD_RESERVE17 = 17,
	MX6SL_PAD_RESERVE18 = 18,
	MX6SL_PAD_AUD_MCLK = 19,
	MX6SL_PAD_AUD_RXC = 20,
	MX6SL_PAD_AUD_RXD = 21,
	MX6SL_PAD_AUD_RXFS = 22,
	MX6SL_PAD_AUD_TXC = 23,
	MX6SL_PAD_AUD_TXD = 24,
	MX6SL_PAD_AUD_TXFS = 25,
	MX6SL_PAD_ECSPI1_MISO = 26,
	MX6SL_PAD_ECSPI1_MOSI = 27,
	MX6SL_PAD_ECSPI1_SCLK = 28,
	MX6SL_PAD_ECSPI1_SS0 = 29,
	MX6SL_PAD_ECSPI2_MISO = 30,
	MX6SL_PAD_ECSPI2_MOSI = 31,
	MX6SL_PAD_ECSPI2_SCLK = 32,
	MX6SL_PAD_ECSPI2_SS0 = 33,
	MX6SL_PAD_EPDC_BDR0 = 34,
	MX6SL_PAD_EPDC_BDR1 = 35,
	MX6SL_PAD_EPDC_D0 = 36,
	MX6SL_PAD_EPDC_D1 = 37,
	MX6SL_PAD_EPDC_D10 = 38,
	MX6SL_PAD_EPDC_D11 = 39,
	MX6SL_PAD_EPDC_D12 = 40,
	MX6SL_PAD_EPDC_D13 = 41,
	MX6SL_PAD_EPDC_D14 = 42,
	MX6SL_PAD_EPDC_D15 = 43,
	MX6SL_PAD_EPDC_D2 = 44,
	MX6SL_PAD_EPDC_D3 = 45,
	MX6SL_PAD_EPDC_D4 = 46,
	MX6SL_PAD_EPDC_D5 = 47,
	MX6SL_PAD_EPDC_D6 = 48,
	MX6SL_PAD_EPDC_D7 = 49,
	MX6SL_PAD_EPDC_D8 = 50,
	MX6SL_PAD_EPDC_D9 = 51,
	MX6SL_PAD_EPDC_GDCLK = 52,
	MX6SL_PAD_EPDC_GDOE = 53,
	MX6SL_PAD_EPDC_GDRL = 54,
	MX6SL_PAD_EPDC_GDSP = 55,
	MX6SL_PAD_EPDC_PWRCOM = 56,
	MX6SL_PAD_EPDC_PWRCTRL0 = 57,
	MX6SL_PAD_EPDC_PWRCTRL1 = 58,
	MX6SL_PAD_EPDC_PWRCTRL2 = 59,
	MX6SL_PAD_EPDC_PWRCTRL3 = 60,
	MX6SL_PAD_EPDC_PWRINT = 61,
	MX6SL_PAD_EPDC_PWRSTAT = 62,
	MX6SL_PAD_EPDC_PWRWAKEUP = 63,
	MX6SL_PAD_EPDC_SDCE0 = 64,
	MX6SL_PAD_EPDC_SDCE1 = 65,
	MX6SL_PAD_EPDC_SDCE2 = 66,
	MX6SL_PAD_EPDC_SDCE3 = 67,
	MX6SL_PAD_EPDC_SDCLK = 68,
	MX6SL_PAD_EPDC_SDLE = 69,
	MX6SL_PAD_EPDC_SDOE = 70,
	MX6SL_PAD_EPDC_SDSHR = 71,
	MX6SL_PAD_EPDC_VCOM0 = 72,
	MX6SL_PAD_EPDC_VCOM1 = 73,
	MX6SL_PAD_FEC_CRS_DV = 74,
	MX6SL_PAD_FEC_MDC = 75,
	MX6SL_PAD_FEC_MDIO = 76,
	MX6SL_PAD_FEC_REF_CLK = 77,
	MX6SL_PAD_FEC_RX_ER = 78,
	MX6SL_PAD_FEC_RXD0 = 79,
	MX6SL_PAD_FEC_RXD1 = 80,
	MX6SL_PAD_FEC_TX_CLK = 81,
	MX6SL_PAD_FEC_TX_EN = 82,
	MX6SL_PAD_FEC_TXD0 = 83,
	MX6SL_PAD_FEC_TXD1 = 84,
	MX6SL_PAD_HSIC_DAT = 85,
	MX6SL_PAD_HSIC_STROBE = 86,
	MX6SL_PAD_I2C1_SCL = 87,
	MX6SL_PAD_I2C1_SDA = 88,
	MX6SL_PAD_I2C2_SCL = 89,
	MX6SL_PAD_I2C2_SDA = 90,
	MX6SL_PAD_KEY_COL0 = 91,
	MX6SL_PAD_KEY_COL1 = 92,
	MX6SL_PAD_KEY_COL2 = 93,
	MX6SL_PAD_KEY_COL3 = 94,
	MX6SL_PAD_KEY_COL4 = 95,
	MX6SL_PAD_KEY_COL5 = 96,
	MX6SL_PAD_KEY_COL6 = 97,
	MX6SL_PAD_KEY_COL7 = 98,
	MX6SL_PAD_KEY_ROW0 = 99,
	MX6SL_PAD_KEY_ROW1 = 100,
	MX6SL_PAD_KEY_ROW2 = 101,
	MX6SL_PAD_KEY_ROW3 = 102,
	MX6SL_PAD_KEY_ROW4 = 103,
	MX6SL_PAD_KEY_ROW5 = 104,
	MX6SL_PAD_KEY_ROW6 = 105,
	MX6SL_PAD_KEY_ROW7 = 106,
	MX6SL_PAD_LCD_CLK = 107,
	MX6SL_PAD_LCD_DAT0 = 108,
	MX6SL_PAD_LCD_DAT1 = 109,
	MX6SL_PAD_LCD_DAT10 = 110,
	MX6SL_PAD_LCD_DAT11 = 111,
	MX6SL_PAD_LCD_DAT12 = 112,
	MX6SL_PAD_LCD_DAT13 = 113,
	MX6SL_PAD_LCD_DAT14 = 114,
	MX6SL_PAD_LCD_DAT15 = 115,
	MX6SL_PAD_LCD_DAT16 = 116,
	MX6SL_PAD_LCD_DAT17 = 117,
	MX6SL_PAD_LCD_DAT18 = 118,
	MX6SL_PAD_LCD_DAT19 = 119,
	MX6SL_PAD_LCD_DAT2 = 120,
	MX6SL_PAD_LCD_DAT20 = 121,
	MX6SL_PAD_LCD_DAT21 = 122,
	MX6SL_PAD_LCD_DAT22 = 123,
	MX6SL_PAD_LCD_DAT23 = 124,
	MX6SL_PAD_LCD_DAT3 = 125,
	MX6SL_PAD_LCD_DAT4 = 126,
	MX6SL_PAD_LCD_DAT5 = 127,
	MX6SL_PAD_LCD_DAT6 = 128,
	MX6SL_PAD_LCD_DAT7 = 129,
	MX6SL_PAD_LCD_DAT8 = 130,
	MX6SL_PAD_LCD_DAT9 = 131,
	MX6SL_PAD_LCD_ENABLE = 132,
	MX6SL_PAD_LCD_HSYNC = 133,
	MX6SL_PAD_LCD_RESET = 134,
	MX6SL_PAD_LCD_VSYNC = 135,
	MX6SL_PAD_PWM1 = 136,
	MX6SL_PAD_REF_CLK_24M = 137,
	MX6SL_PAD_REF_CLK_32K = 138,
	MX6SL_PAD_SD1_CLK = 139,
	MX6SL_PAD_SD1_CMD = 140,
	MX6SL_PAD_SD1_DAT0 = 141,
	MX6SL_PAD_SD1_DAT1 = 142,
	MX6SL_PAD_SD1_DAT2 = 143,
	MX6SL_PAD_SD1_DAT3 = 144,
	MX6SL_PAD_SD1_DAT4 = 145,
	MX6SL_PAD_SD1_DAT5 = 146,
	MX6SL_PAD_SD1_DAT6 = 147,
	MX6SL_PAD_SD1_DAT7 = 148,
	MX6SL_PAD_SD2_CLK = 149,
	MX6SL_PAD_SD2_CMD = 150,
	MX6SL_PAD_SD2_DAT0 = 151,
	MX6SL_PAD_SD2_DAT1 = 152,
	MX6SL_PAD_SD2_DAT2 = 153,
	MX6SL_PAD_SD2_DAT3 = 154,
	MX6SL_PAD_SD2_DAT4 = 155,
	MX6SL_PAD_SD2_DAT5 = 156,
	MX6SL_PAD_SD2_DAT6 = 157,
	MX6SL_PAD_SD2_DAT7 = 158,
	MX6SL_PAD_SD2_RST = 159,
	MX6SL_PAD_SD3_CLK = 160,
	MX6SL_PAD_SD3_CMD = 161,
	MX6SL_PAD_SD3_DAT0 = 162,
	MX6SL_PAD_SD3_DAT1 = 163,
	MX6SL_PAD_SD3_DAT2 = 164,
	MX6SL_PAD_SD3_DAT3 = 165,
	MX6SL_PAD_UART1_RXD = 166,
	MX6SL_PAD_UART1_TXD = 167,
	MX6SL_PAD_WDOG_B = 168,
};

/* Pad names for the pinmux subsystem */
static const struct pinctrl_pin_desc imx6sl_pinctrl_pads[] = {
	IMX_PINCTRL_PIN(MX6SL_PAD_RESERVE0),
	IMX_PINCTRL_PIN(MX6SL_PAD_RESERVE1),
	IMX_PINCTRL_PIN(MX6SL_PAD_RESERVE2),
	IMX_PINCTRL_PIN(MX6SL_PAD_RESERVE3),
	IMX_PINCTRL_PIN(MX6SL_PAD_RESERVE4),
	IMX_PINCTRL_PIN(MX6SL_PAD_RESERVE5),
	IMX_PINCTRL_PIN(MX6SL_PAD_RESERVE6),
	IMX_PINCTRL_PIN(MX6SL_PAD_RESERVE7),
	IMX_PINCTRL_PIN(MX6SL_PAD_RESERVE8),
	IMX_PINCTRL_PIN(MX6SL_PAD_RESERVE9),
	IMX_PINCTRL_PIN(MX6SL_PAD_RESERVE10),
	IMX_PINCTRL_PIN(MX6SL_PAD_RESERVE11),
	IMX_PINCTRL_PIN(MX6SL_PAD_RESERVE12),
	IMX_PINCTRL_PIN(MX6SL_PAD_RESERVE13),
	IMX_PINCTRL_PIN(MX6SL_PAD_RESERVE14),
	IMX_PINCTRL_PIN(MX6SL_PAD_RESERVE15),
	IMX_PINCTRL_PIN(MX6SL_PAD_RESERVE16),
	IMX_PINCTRL_PIN(MX6SL_PAD_RESERVE17),
	IMX_PINCTRL_PIN(MX6SL_PAD_RESERVE18),
	IMX_PINCTRL_PIN(MX6SL_PAD_AUD_MCLK),
	IMX_PINCTRL_PIN(MX6SL_PAD_AUD_RXC),
	IMX_PINCTRL_PIN(MX6SL_PAD_AUD_RXD),
	IMX_PINCTRL_PIN(MX6SL_PAD_AUD_RXFS),
	IMX_PINCTRL_PIN(MX6SL_PAD_AUD_TXC),
	IMX_PINCTRL_PIN(MX6SL_PAD_AUD_TXD),
	IMX_PINCTRL_PIN(MX6SL_PAD_AUD_TXFS),
	IMX_PINCTRL_PIN(MX6SL_PAD_ECSPI1_MISO),
	IMX_PINCTRL_PIN(MX6SL_PAD_ECSPI1_MOSI),
	IMX_PINCTRL_PIN(MX6SL_PAD_ECSPI1_SCLK),
	IMX_PINCTRL_PIN(MX6SL_PAD_ECSPI1_SS0),
	IMX_PINCTRL_PIN(MX6SL_PAD_ECSPI2_MISO),
	IMX_PINCTRL_PIN(MX6SL_PAD_ECSPI2_MOSI),
	IMX_PINCTRL_PIN(MX6SL_PAD_ECSPI2_SCLK),
	IMX_PINCTRL_PIN(MX6SL_PAD_ECSPI2_SS0),
	IMX_PINCTRL_PIN(MX6SL_PAD_EPDC_BDR0),
	IMX_PINCTRL_PIN(MX6SL_PAD_EPDC_BDR1),
	IMX_PINCTRL_PIN(MX6SL_PAD_EPDC_D0),
	IMX_PINCTRL_PIN(MX6SL_PAD_EPDC_D1),
	IMX_PINCTRL_PIN(MX6SL_PAD_EPDC_D10),
	IMX_PINCTRL_PIN(MX6SL_PAD_EPDC_D11),
	IMX_PINCTRL_PIN(MX6SL_PAD_EPDC_D12),
	IMX_PINCTRL_PIN(MX6SL_PAD_EPDC_D13),
	IMX_PINCTRL_PIN(MX6SL_PAD_EPDC_D14),
	IMX_PINCTRL_PIN(MX6SL_PAD_EPDC_D15),
	IMX_PINCTRL_PIN(MX6SL_PAD_EPDC_D2),
	IMX_PINCTRL_PIN(MX6SL_PAD_EPDC_D3),
	IMX_PINCTRL_PIN(MX6SL_PAD_EPDC_D4),
	IMX_PINCTRL_PIN(MX6SL_PAD_EPDC_D5),
	IMX_PINCTRL_PIN(MX6SL_PAD_EPDC_D6),
	IMX_PINCTRL_PIN(MX6SL_PAD_EPDC_D7),
	IMX_PINCTRL_PIN(MX6SL_PAD_EPDC_D8),
	IMX_PINCTRL_PIN(MX6SL_PAD_EPDC_D9),
	IMX_PINCTRL_PIN(MX6SL_PAD_EPDC_GDCLK),
	IMX_PINCTRL_PIN(MX6SL_PAD_EPDC_GDOE),
	IMX_PINCTRL_PIN(MX6SL_PAD_EPDC_GDRL),
	IMX_PINCTRL_PIN(MX6SL_PAD_EPDC_GDSP),
	IMX_PINCTRL_PIN(MX6SL_PAD_EPDC_PWRCOM),
	IMX_PINCTRL_PIN(MX6SL_PAD_EPDC_PWRCTRL0),
	IMX_PINCTRL_PIN(MX6SL_PAD_EPDC_PWRCTRL1),
	IMX_PINCTRL_PIN(MX6SL_PAD_EPDC_PWRCTRL2),
	IMX_PINCTRL_PIN(MX6SL_PAD_EPDC_PWRCTRL3),
	IMX_PINCTRL_PIN(MX6SL_PAD_EPDC_PWRINT),
	IMX_PINCTRL_PIN(MX6SL_PAD_EPDC_PWRSTAT),
	IMX_PINCTRL_PIN(MX6SL_PAD_EPDC_PWRWAKEUP),
	IMX_PINCTRL_PIN(MX6SL_PAD_EPDC_SDCE0),
	IMX_PINCTRL_PIN(MX6SL_PAD_EPDC_SDCE1),
	IMX_PINCTRL_PIN(MX6SL_PAD_EPDC_SDCE2),
	IMX_PINCTRL_PIN(MX6SL_PAD_EPDC_SDCE3),
	IMX_PINCTRL_PIN(MX6SL_PAD_EPDC_SDCLK),
	IMX_PINCTRL_PIN(MX6SL_PAD_EPDC_SDLE),
	IMX_PINCTRL_PIN(MX6SL_PAD_EPDC_SDOE),
	IMX_PINCTRL_PIN(MX6SL_PAD_EPDC_SDSHR),
	IMX_PINCTRL_PIN(MX6SL_PAD_EPDC_VCOM0),
	IMX_PINCTRL_PIN(MX6SL_PAD_EPDC_VCOM1),
	IMX_PINCTRL_PIN(MX6SL_PAD_FEC_CRS_DV),
	IMX_PINCTRL_PIN(MX6SL_PAD_FEC_MDC),
	IMX_PINCTRL_PIN(MX6SL_PAD_FEC_MDIO),
	IMX_PINCTRL_PIN(MX6SL_PAD_FEC_REF_CLK),
	IMX_PINCTRL_PIN(MX6SL_PAD_FEC_RX_ER),
	IMX_PINCTRL_PIN(MX6SL_PAD_FEC_RXD0),
	IMX_PINCTRL_PIN(MX6SL_PAD_FEC_RXD1),
	IMX_PINCTRL_PIN(MX6SL_PAD_FEC_TX_CLK),
	IMX_PINCTRL_PIN(MX6SL_PAD_FEC_TX_EN),
	IMX_PINCTRL_PIN(MX6SL_PAD_FEC_TXD0),
	IMX_PINCTRL_PIN(MX6SL_PAD_FEC_TXD1),
	IMX_PINCTRL_PIN(MX6SL_PAD_HSIC_DAT),
	IMX_PINCTRL_PIN(MX6SL_PAD_HSIC_STROBE),
	IMX_PINCTRL_PIN(MX6SL_PAD_I2C1_SCL),
	IMX_PINCTRL_PIN(MX6SL_PAD_I2C1_SDA),
	IMX_PINCTRL_PIN(MX6SL_PAD_I2C2_SCL),
	IMX_PINCTRL_PIN(MX6SL_PAD_I2C2_SDA),
	IMX_PINCTRL_PIN(MX6SL_PAD_KEY_COL0),
	IMX_PINCTRL_PIN(MX6SL_PAD_KEY_COL1),
	IMX_PINCTRL_PIN(MX6SL_PAD_KEY_COL2),
	IMX_PINCTRL_PIN(MX6SL_PAD_KEY_COL3),
	IMX_PINCTRL_PIN(MX6SL_PAD_KEY_COL4),
	IMX_PINCTRL_PIN(MX6SL_PAD_KEY_COL5),
	IMX_PINCTRL_PIN(MX6SL_PAD_KEY_COL6),
	IMX_PINCTRL_PIN(MX6SL_PAD_KEY_COL7),
	IMX_PINCTRL_PIN(MX6SL_PAD_KEY_ROW0),
	IMX_PINCTRL_PIN(MX6SL_PAD_KEY_ROW1),
	IMX_PINCTRL_PIN(MX6SL_PAD_KEY_ROW2),
	IMX_PINCTRL_PIN(MX6SL_PAD_KEY_ROW3),
	IMX_PINCTRL_PIN(MX6SL_PAD_KEY_ROW4),
	IMX_PINCTRL_PIN(MX6SL_PAD_KEY_ROW5),
	IMX_PINCTRL_PIN(MX6SL_PAD_KEY_ROW6),
	IMX_PINCTRL_PIN(MX6SL_PAD_KEY_ROW7),
	IMX_PINCTRL_PIN(MX6SL_PAD_LCD_CLK),
	IMX_PINCTRL_PIN(MX6SL_PAD_LCD_DAT0),
	IMX_PINCTRL_PIN(MX6SL_PAD_LCD_DAT1),
	IMX_PINCTRL_PIN(MX6SL_PAD_LCD_DAT10),
	IMX_PINCTRL_PIN(MX6SL_PAD_LCD_DAT11),
	IMX_PINCTRL_PIN(MX6SL_PAD_LCD_DAT12),
	IMX_PINCTRL_PIN(MX6SL_PAD_LCD_DAT13),
	IMX_PINCTRL_PIN(MX6SL_PAD_LCD_DAT14),
	IMX_PINCTRL_PIN(MX6SL_PAD_LCD_DAT15),
	IMX_PINCTRL_PIN(MX6SL_PAD_LCD_DAT16),
	IMX_PINCTRL_PIN(MX6SL_PAD_LCD_DAT17),
	IMX_PINCTRL_PIN(MX6SL_PAD_LCD_DAT18),
	IMX_PINCTRL_PIN(MX6SL_PAD_LCD_DAT19),
	IMX_PINCTRL_PIN(MX6SL_PAD_LCD_DAT2),
	IMX_PINCTRL_PIN(MX6SL_PAD_LCD_DAT20),
	IMX_PINCTRL_PIN(MX6SL_PAD_LCD_DAT21),
	IMX_PINCTRL_PIN(MX6SL_PAD_LCD_DAT22),
	IMX_PINCTRL_PIN(MX6SL_PAD_LCD_DAT23),
	IMX_PINCTRL_PIN(MX6SL_PAD_LCD_DAT3),
	IMX_PINCTRL_PIN(MX6SL_PAD_LCD_DAT4),
	IMX_PINCTRL_PIN(MX6SL_PAD_LCD_DAT5),
	IMX_PINCTRL_PIN(MX6SL_PAD_LCD_DAT6),
	IMX_PINCTRL_PIN(MX6SL_PAD_LCD_DAT7),
	IMX_PINCTRL_PIN(MX6SL_PAD_LCD_DAT8),
	IMX_PINCTRL_PIN(MX6SL_PAD_LCD_DAT9),
	IMX_PINCTRL_PIN(MX6SL_PAD_LCD_ENABLE),
	IMX_PINCTRL_PIN(MX6SL_PAD_LCD_HSYNC),
	IMX_PINCTRL_PIN(MX6SL_PAD_LCD_RESET),
	IMX_PINCTRL_PIN(MX6SL_PAD_LCD_VSYNC),
	IMX_PINCTRL_PIN(MX6SL_PAD_PWM1),
	IMX_PINCTRL_PIN(MX6SL_PAD_REF_CLK_24M),
	IMX_PINCTRL_PIN(MX6SL_PAD_REF_CLK_32K),
	IMX_PINCTRL_PIN(MX6SL_PAD_SD1_CLK),
	IMX_PINCTRL_PIN(MX6SL_PAD_SD1_CMD),
	IMX_PINCTRL_PIN(MX6SL_PAD_SD1_DAT0),
	IMX_PINCTRL_PIN(MX6SL_PAD_SD1_DAT1),
	IMX_PINCTRL_PIN(MX6SL_PAD_SD1_DAT2),
	IMX_PINCTRL_PIN(MX6SL_PAD_SD1_DAT3),
	IMX_PINCTRL_PIN(MX6SL_PAD_SD1_DAT4),
	IMX_PINCTRL_PIN(MX6SL_PAD_SD1_DAT5),
	IMX_PINCTRL_PIN(MX6SL_PAD_SD1_DAT6),
	IMX_PINCTRL_PIN(MX6SL_PAD_SD1_DAT7),
	IMX_PINCTRL_PIN(MX6SL_PAD_SD2_CLK),
	IMX_PINCTRL_PIN(MX6SL_PAD_SD2_CMD),
	IMX_PINCTRL_PIN(MX6SL_PAD_SD2_DAT0),
	IMX_PINCTRL_PIN(MX6SL_PAD_SD2_DAT1),
	IMX_PINCTRL_PIN(MX6SL_PAD_SD2_DAT2),
	IMX_PINCTRL_PIN(MX6SL_PAD_SD2_DAT3),
	IMX_PINCTRL_PIN(MX6SL_PAD_SD2_DAT4),
	IMX_PINCTRL_PIN(MX6SL_PAD_SD2_DAT5),
	IMX_PINCTRL_PIN(MX6SL_PAD_SD2_DAT6),
	IMX_PINCTRL_PIN(MX6SL_PAD_SD2_DAT7),
	IMX_PINCTRL_PIN(MX6SL_PAD_SD2_RST),
	IMX_PINCTRL_PIN(MX6SL_PAD_SD3_CLK),
	IMX_PINCTRL_PIN(MX6SL_PAD_SD3_CMD),
	IMX_PINCTRL_PIN(MX6SL_PAD_SD3_DAT0),
	IMX_PINCTRL_PIN(MX6SL_PAD_SD3_DAT1),
	IMX_PINCTRL_PIN(MX6SL_PAD_SD3_DAT2),
	IMX_PINCTRL_PIN(MX6SL_PAD_SD3_DAT3),
	IMX_PINCTRL_PIN(MX6SL_PAD_UART1_RXD),
	IMX_PINCTRL_PIN(MX6SL_PAD_UART1_TXD),
	IMX_PINCTRL_PIN(MX6SL_PAD_WDOG_B),
};

static struct imx_pinctrl_soc_info imx6sl_pinctrl_info = {
	.pins = imx6sl_pinctrl_pads,
	.npins = ARRAY_SIZE(imx6sl_pinctrl_pads),
	.gpr_compatible = "fsl,imx6sl-iomuxc-gpr",
};

static const struct of_device_id imx6sl_pinctrl_of_match[] = {
	{ .compatible = "fsl,imx6sl-iomuxc", },
	{ /* sentinel */ }
};
MODULE_DEVICE_TABLE(of, imx6sl_pinctrl_of_match);

static int imx6sl_pinctrl_probe(struct platform_device *pdev)
{
	return imx_pinctrl_probe(pdev, &imx6sl_pinctrl_info);
}

static struct platform_driver imx6sl_pinctrl_driver = {
	.driver = {
		.name = "imx6sl-pinctrl",
		.of_match_table = imx6sl_pinctrl_of_match,
	},
	.probe = imx6sl_pinctrl_probe,
};

static int __init imx6sl_pinctrl_init(void)
{
	return platform_driver_register(&imx6sl_pinctrl_driver);
}
arch_initcall(imx6sl_pinctrl_init);

static void __exit imx6sl_pinctrl_exit(void)
{
	platform_driver_unregister(&imx6sl_pinctrl_driver);
}
module_exit(imx6sl_pinctrl_exit);

MODULE_AUTHOR("Shawn Guo <shawn.guo@linaro.org>");
MODULE_DESCRIPTION("Freescale imx6sl pinctrl driver");
MODULE_LICENSE("GPL v2");
