/* SPDX-License-Identifier: (GPL-2.0 OR MIT) */
/*
 * Copyright (c) 2018 BayLibre, SAS.
 * Author: Jerome Brunet <jbrunet@baylibre.com>
 */

#ifndef __AXG_AUDIO_CLKC_H
#define __AXG_AUDIO_CLKC_H

/*
 * Audio Clock  register offsets
 *
 * Register offsets from the datasheet must be multiplied by 4 before
 * to get the right offset
 */
#define AUDIO_CLK_GATE_EN	0x000
#define AUDIO_MCLK_A_CTRL	0x004
#define AUDIO_MCLK_B_CTRL	0x008
#define AUDIO_MCLK_C_CTRL	0x00C
#define AUDIO_MCLK_D_CTRL	0x010
#define AUDIO_MCLK_E_CTRL	0x014
#define AUDIO_MCLK_F_CTRL	0x018
#define AUDIO_MST_PAD_CTRL0	0x01c
#define AUDIO_MST_PAD_CTRL1	0x020
#define AUDIO_SW_RESET		0x024
#define AUDIO_MST_A_SCLK_CTRL0	0x040
#define AUDIO_MST_A_SCLK_CTRL1	0x044
#define AUDIO_MST_B_SCLK_CTRL0	0x048
#define AUDIO_MST_B_SCLK_CTRL1	0x04C
#define AUDIO_MST_C_SCLK_CTRL0	0x050
#define AUDIO_MST_C_SCLK_CTRL1	0x054
#define AUDIO_MST_D_SCLK_CTRL0	0x058
#define AUDIO_MST_D_SCLK_CTRL1	0x05C
#define AUDIO_MST_E_SCLK_CTRL0	0x060
#define AUDIO_MST_E_SCLK_CTRL1	0x064
#define AUDIO_MST_F_SCLK_CTRL0	0x068
#define AUDIO_MST_F_SCLK_CTRL1	0x06C
#define AUDIO_CLK_TDMIN_A_CTRL	0x080
#define AUDIO_CLK_TDMIN_B_CTRL	0x084
#define AUDIO_CLK_TDMIN_C_CTRL	0x088
#define AUDIO_CLK_TDMIN_LB_CTRL 0x08C
#define AUDIO_CLK_TDMOUT_A_CTRL 0x090
#define AUDIO_CLK_TDMOUT_B_CTRL 0x094
#define AUDIO_CLK_TDMOUT_C_CTRL 0x098
#define AUDIO_CLK_SPDIFIN_CTRL	0x09C
#define AUDIO_CLK_SPDIFOUT_CTRL 0x0A0
#define AUDIO_CLK_RESAMPLE_CTRL 0x0A4
#define AUDIO_CLK_LOCKER_CTRL	0x0A8
#define AUDIO_CLK_PDMIN_CTRL0	0x0AC
#define AUDIO_CLK_PDMIN_CTRL1	0x0B0
#define AUDIO_CLK_SPDIFOUT_B_CTRL 0x0B4

/* SM1 introduce new register and some shifts :( */
#define AUDIO_CLK_GATE_EN1	0x004
#define AUDIO_SM1_MCLK_A_CTRL	0x008
#define AUDIO_SM1_MCLK_B_CTRL	0x00C
#define AUDIO_SM1_MCLK_C_CTRL	0x010
#define AUDIO_SM1_MCLK_D_CTRL	0x014
#define AUDIO_SM1_MCLK_E_CTRL	0x018
#define AUDIO_SM1_MCLK_F_CTRL	0x01C
#define AUDIO_SM1_MST_PAD_CTRL0	0x020
#define AUDIO_SM1_MST_PAD_CTRL1	0x024
#define AUDIO_SM1_SW_RESET0	0x028
#define AUDIO_SM1_SW_RESET1	0x02C
#define AUDIO_CLK81_CTRL	0x030
#define AUDIO_CLK81_EN		0x034

#endif /*__AXG_AUDIO_CLKC_H */
