/*
 * $Id: unixdefs.h,v 1.24 1999/05/10 17:22:11 bob Exp $
 *
 * author:
 *  M.A. Borza, L. Hamid
 *  95.08.23
 *  DEW Engineering and Development Limited
 *  Ottawa, Ontario, Canada
 *  (c) Copyright 1995, all rights reserved.
 *
 * contents:
 *
 */

/* Change Log:

 */

#ifndef __UNIXDEFS_H__
#define __UNIXDEFS_H__


/*-------------------------------------------- */
/*Windows 32 declarations: */
#ifdef WIN32
#ifndef DEVICE_DRIVER
#include <windows.h>
#endif
#define ABC_DECL1 __declspec(dllexport)
#define ABC_DECL2 __stdcall
#define ABC_DECL ABC_DECL1 ABC_DECL2

#define _fmemset    memset
#define _fmemcpy    memcpy
#define _fmemcpy    memcpy
#define _fmemset    memset
#define hmemcpy     memcpy
#define far
#define huge
#ifndef DWORD
#define DWORD unsigned long
#endif
#ifndef WORD
#define WORD unsigned short
#endif

#endif /* WIN32 */

/*-------------------------------------------- */
/*Unix declarations: */
#if UNIX 
/*  Suppress all this windows stuff */
#define ABC_DECL1
#define ABC_DECL2
#define ABC_DECL ABC_DECL1 ABC_DECL2
#define BYTE unsigned char
#define far
#define huge
#define FAR
#define PASCAL
#define HWND unsigned long
#define WORD unsigned short
#define DWORD unsigned long
#define COLORREF unsigned long
#define RGB(r,g,b)          ((COLORREF)(((BYTE)(r)|((WORD)(g)<<8))|(((DWORD)(BYTE)(b))<<16)))
#define HDRVR void *
#define HGLOBAL unsigned long
#define LPARAM  void *
#define LPVOID  void *
#define LPBYTE  unsigned char *
#define UINT  unsigned int
#define DRV_USER  1
#define GHND  1
#define HDC  1
#define BOOL  int
#define CALLBACK
#ifndef NULL
# define NULL  ((void *)0)
#endif
#define FALSE 0
#define TRUE 1
#define MAX_PATH   512

#ifndef max
# define max(a,b)            (((a) > (b)) ? (a) : (b))
#endif
#ifndef min
# define min(a,b)            (((a) < (b)) ? (a) : (b))
#endif

#define _fmemset    memset
#define _fmemcpy    memcpy
#define _fmemcpy    memcpy
#define _fmemset    memset
#define hmemcpy     memcpy

#endif /*  Unix */

/*-------------------------------------------- */
/*Windows 16 (3.x) */
#if ((defined _WINDOWS) && (!defined WIN32))

#include <windows.h>


#ifndef MAX_PATH
#define MAX_PATH        256
#endif
#define ABC_DECL1 __export
#define ABC_DECL2 WINAPI
#define ABC_DECL ABC_DECL1 ABC_DECL2

#define WCHAR   char

#define MB_ICONWARNING  MB_ICONEXCLAMATION
#endif /* Windows */

/*-------------------------------------------- */
/* Dos */
#ifdef _DOS
#ifndef MAX_PATH
#define MAX_PATH        256
#endif
#define ABC_DECL1
#define ABC_DECL2 FAR
#define ABC_DECL ABC_DECL1 ABC_DECL2
#define hmemcpy _fmemcpy
#define WCHAR   char
#define BYTE unsigned char
#define HWND unsigned long
#define WORD unsigned int
#define DWORD unsigned long
#define FAR __far
#define NEAR __near
#define LPVOID  void __far *
#define LPBYTE  unsigned char __far *
#define UINT  unsigned int
#define BOOL  int
#define LPARAM  long
#define FALSE 0
#define TRUE 1
#define HGLOBAL unsigned long
#define huge __huge
#ifndef max
# define max(a,b)            (((a) > (b)) ? (a) : (b))
#endif
#ifndef min
# define min(a,b)            (((a) < (b)) ? (a) : (b))
#endif
typedef struct tagRECT {        /* rc */
   int             left;
   int             top;
   int             right;
   int             bottom;
} RECT;

#endif /* _Dos */

// Definitions common to all platforms
#define DBI_SC_MAX_ATR    32

#endif /* UNIXDEFS */
