[indent=4]

uses 
    Gtk
    Pango

init
    Gtk.init (ref args)
    Intl.textdomain(Config.GETTEXT_PACKAGE)
    Intl.bindtextdomain(Config.GETTEXT_PACKAGE, Config.LOCALEDIR)
    Intl.bind_textdomain_codeset(Config.GETTEXT_PACKAGE, "UTF-8")
    Environment.set_application_name(Config.GETTEXT_PACKAGE)
    var nicoedit = new NicoEdit ()
    if (args.length == 2)
        nicoedit.open_file(args[1])
    nicoedit.show_all ()
    nicoedit.restore_stats ()
    Gtk.main ()

class NicoEdit : Window
    toolbar : Toolbar
    text_view : SourceView
    status_bar : Statusbar
    status_hbox : HBox
    scrool : ScrolledWindow
    document_modified : bool = false
    reloadmenu : MenuItem
    separator_menu_item : SeparatorMenuItem
    image_menu_item : ImageMenuItem
    image_menu_item1 : ImageMenuItem
    image_menu_item2 : ImageMenuItem
    image_menu_item3 : ImageMenuItem
    check_menu_item : CheckMenuItem
    toolbarmenu2 : MenuItem
    check_menu_item2 : CheckMenuItem
    check_menu_item3 : CheckMenuItem
    check_menu_item4 : CheckMenuItem
    check_menu_item5 : CheckMenuItem
    check_menu_item6 : CheckMenuItem
    check_menu_item7 : CheckMenuItem
    image_menu_item4 : ImageMenuItem
    image_menu_item5 : ImageMenuItem
    radio_menu_item : RadioMenuItem
    radio_menu_item1 : RadioMenuItem
    radio_menu_item2 : RadioMenuItem    
    radio_menu_item3 : RadioMenuItem
    radio_menu_item4 : RadioMenuItem
    radio_menu_item5 : RadioMenuItem    
    radio_menu_item6 : RadioMenuItem
    radio_menu_item7 : RadioMenuItem
    radio_menu_item8 : RadioMenuItem    
    radio_menu_item9 : RadioMenuItem
    radio_menu_item10 : RadioMenuItem
    radio_menu_item11 : RadioMenuItem    
    radio_menu_item12 : RadioMenuItem
    radio_menu_item13 : RadioMenuItem
    radio_menu_item14 : RadioMenuItem
    radio_menu_item15 : RadioMenuItem
    radio_menu_item16 : RadioMenuItem
    radio_menu_item17 : RadioMenuItem
    radio_menu_item18 : RadioMenuItem
    radio_menu_item19 : RadioMenuItem
    radio_menu_item20 : RadioMenuItem
    radio_menu_item21 : RadioMenuItem
    radio_menu_item22 : RadioMenuItem
    radio_menu_item23 : RadioMenuItem
    radio_menu_item24 : RadioMenuItem
    radio_menu_item25 : RadioMenuItem
    radio_menu_item26 : RadioMenuItem
    radio_menu_item27 : RadioMenuItem
    radio_menu_item28 : RadioMenuItem
    radio_tab_item1 : RadioMenuItem
    radio_tab_item2 : RadioMenuItem
    radio_tab_item3 : RadioMenuItem
    radio_indent_item1 : RadioMenuItem
    radio_indent_item2 : RadioMenuItem
    radio_indent_item3 : RadioMenuItem
    toolbar_tab_item1 : RadioMenuItem
    toolbar_tab_item2 : RadioMenuItem
    toolbar_tab_item3 : RadioMenuItem
    fullscreen_button : ToolButton
    bar : MenuBar
    mylist : SList
    mylist2 : SList
    mylist3 : SList
    mylist4 : SList
    mylist5 : SList
    save : Dialog
    search_dialog : Dialog
    menu_item : MenuItem
    messagedialog : MessageDialog
    gototext : Entry
    buf : SourceBuffer
    thefile : string = ""
    info : Dialog
    search_entry : Entry
    match_case : CheckButton
    find_backwards : CheckButton
    find_button : Widget
    search_flags : SourceSearchFlags
    color : Gdk.Color
    newfont : FontSelectionDialog
    newcolor : ColorSelectionDialog
    font_desc : FontDescription
    manager : SourceLanguageManager
    thedefaultsyntax : string
    default_window_height : int
    default_window_width : int
    thebackgroundcolor : string
    thetextcolor : string
    thefont : string
    viewtoolbar : string
    linenumber : string
    insertspace : string
    highlightcurrentline : string
    highlightsyntax : string
    tabwidth : string
    activatedfullscreen : bool = false
    toolbarstyle : string
    indentwidth : string
    autoindent : string
    indentontab : string
    cancelclicked : bool
    theaction : string
    fileexecutable : bool = false
    context : PrintContext
    op : PrintOperation
    thecompositor : SourcePrintCompositor
    recentmanager : RecentManager
    recentmanager2 : RecentManager
    recent_menu_chooser : RecentChooserMenu
    searchhbox : HBox
    gotohbox : HBox
    printvbox : VBox
    printlabel : Label
    printprogress : ProgressBar
    undo_button : ToolButton
    redo_button : ToolButton
    undo_menu_item : ImageMenuItem
    redo_menu_item : ImageMenuItem
    quit_button : Button
    search_info_label : Label
    match_word_only : CheckButton
    replaceentry1 : Entry
    replaceentry2 : Entry
    replacehbox : HBox
    replace_match_case : CheckButton
    replace_match_word_only : CheckButton

    init
        restore_window_size()
        title = _("new file") + " - NicoEdit"
        default_height = default_window_height
        default_width = default_window_width
        window_position = WindowPosition.CENTER
        try
            set_icon_from_file(Config.PIXMAPS_DIR + "/nicoedit.png")
        except e : GLib.Error
            print "Unable to load program icon"
        delete_event += exit_program
        key_press_event.connect(nicoedit_key_press_event)

        /* Menus */
        bar = new MenuBar()
        var aGroup = new AccelGroup()
        add_accel_group(aGroup)
        key : uint
        mod : Gdk.ModifierType
        var menu1 = new Menu()
        image_menu_item = new ImageMenuItem.from_stock(STOCK_NEW, aGroup)
        image_menu_item.activate += new_text
        menu1.append(image_menu_item)
        image_menu_item = new ImageMenuItem.from_stock(STOCK_OPEN, aGroup)
        image_menu_item.activate += on_open_clicked
        menu1.append(image_menu_item)
        reloadmenu = new ImageMenuItem.from_stock(STOCK_REFRESH, aGroup)
        accelerator_parse("<Shift><Ctrl>O", out key, out mod)
        reloadmenu.add_accelerator("activate", aGroup, key, mod, AccelFlags.VISIBLE)
        reloadmenu.activate += def (s)
            reload_file()
        reloadmenu.sensitive = false
        menu1.append(reloadmenu)
        separator_menu_item = new SeparatorMenuItem()
        menu1.append(separator_menu_item)
        image_menu_item = new ImageMenuItem.from_stock(STOCK_SAVE, aGroup)
        image_menu_item.activate += save_clicked
        menu1.append(image_menu_item)
        image_menu_item = new ImageMenuItem.from_stock(STOCK_SAVE_AS, aGroup)
        accelerator_parse("<Shift><Ctrl>S", out key, out mod)
        image_menu_item.add_accelerator("activate", aGroup, key, mod, AccelFlags.VISIBLE)
        image_menu_item.activate += on_save_as_clicked
        menu1.append(image_menu_item)
        separator_menu_item = new SeparatorMenuItem()
        menu1.append(separator_menu_item)
        menu_item = new MenuItem.with_label(_("Export as PDF"))
        accelerator_parse("<Ctrl>E", out key, out mod)
        menu_item.add_accelerator("activate", aGroup, key, mod, AccelFlags.VISIBLE)
        menu_item.activate += def (s)
            initialize_printer("export")
        menu1.append(menu_item)
        separator_menu_item = new SeparatorMenuItem()
        menu1.append(separator_menu_item)
        image_menu_item = new ImageMenuItem.from_stock(STOCK_PRINT_PREVIEW, aGroup)
        accelerator_parse("<Shift><Ctrl>P", out key, out mod)
        image_menu_item.add_accelerator("activate", aGroup, key, mod, AccelFlags.VISIBLE)
        image_menu_item.activate += def (s)
            initialize_printer("preview")
        menu1.append(image_menu_item)
        image_menu_item = new ImageMenuItem.from_stock(STOCK_PRINT, aGroup)
        accelerator_parse("<Ctrl>P", out key, out mod)
        image_menu_item.add_accelerator("activate", aGroup, key, mod, AccelFlags.VISIBLE)
        image_menu_item.activate += def (s)
            initialize_printer("print")
        menu1.append(image_menu_item)
        separator_menu_item = new SeparatorMenuItem()
        menu1.append(separator_menu_item)
        image_menu_item = new ImageMenuItem.from_stock(STOCK_QUIT, aGroup)
        image_menu_item.activate += exit_clicked
        menu1.append(image_menu_item)
        var launcher = new MenuItem.with_mnemonic(_("_File"))
        launcher.set_submenu(menu1)
        bar.append(launcher)
        /* *************** */
        var menu2 = new Menu()
        undo_menu_item = new ImageMenuItem.from_stock(STOCK_UNDO, aGroup)
        accelerator_parse("<Ctrl>Z", out key, out mod)
        undo_menu_item.add_accelerator("activate", aGroup, key, mod, AccelFlags.VISIBLE)
        undo_menu_item.sensitive = false
        undo_menu_item.activate += def (s)
            undo_clicked()
            check_undo_redo()
        menu2.append(undo_menu_item)
        redo_menu_item = new ImageMenuItem.from_stock(STOCK_REDO, aGroup)
        accelerator_parse("<Shift><Ctrl>Z", out key, out mod)
        redo_menu_item.add_accelerator("activate", aGroup, key, mod, AccelFlags.VISIBLE)
        redo_menu_item.sensitive = false
        redo_menu_item.activate += def (s)
            redo_clicked()
            check_undo_redo()
        menu2.append(redo_menu_item)
        separator_menu_item = new SeparatorMenuItem()
        menu2.append(separator_menu_item)
        image_menu_item2 = new ImageMenuItem.from_stock(STOCK_CUT, aGroup)
        image_menu_item2.activate += cut_clipboard
        menu2.append(image_menu_item2)
        image_menu_item2 = new ImageMenuItem.from_stock(STOCK_COPY, aGroup)
        image_menu_item2.activate += copy_clipboard
        menu2.append(image_menu_item2)
        image_menu_item2 = new ImageMenuItem.from_stock(STOCK_PASTE, aGroup)
        image_menu_item2.activate += paste_clipboard
        menu2.append(image_menu_item2)
        separator_menu_item = new SeparatorMenuItem()
        menu2.append(separator_menu_item)
        image_menu_item2 = new ImageMenuItem.from_stock(STOCK_SELECT_ALL, aGroup)
        accelerator_parse("<Ctrl>A", out key, out mod)
        image_menu_item2.add_accelerator("activate", aGroup, key, mod, AccelFlags.VISIBLE)
        image_menu_item2.activate += select_all
        menu2.append(image_menu_item2)
        var launcher2 = new MenuItem.with_mnemonic(_("E_dit"))
        launcher2.set_submenu(menu2)
        bar.append(launcher2)
        /* *************** */
        var menu3 = new Menu()
        check_menu_item = new CheckMenuItem.with_label(_("Show Toolbar"))
        accelerator_parse("<Ctrl>T", out key, out mod)
        check_menu_item.add_accelerator("activate", aGroup, key, mod, AccelFlags.VISIBLE)
        check_menu_item.set_active(true)
        check_menu_item.toggled += on_check
        menu3.append(check_menu_item)
        var toolbarmenu = new Menu()
        toolbarmenu2 = new MenuItem.with_label(_("Toolbar Style"))
        toolbarmenu2.set_submenu(toolbarmenu)
        toolbar_tab_item1 = new RadioMenuItem.with_label(mylist3, _("Both"))
        toolbarmenu.append(toolbar_tab_item1)
        toolbar_tab_item1.toggled += def (s)
            toolbar.set_style(ToolbarStyle.BOTH)
            toolbarstyle = "both"
        toolbar_tab_item2 = new RadioMenuItem.with_label(toolbar_tab_item1.get_group(), _("Icons only"))
        toolbarmenu.append(toolbar_tab_item2)
        toolbar_tab_item2.toggled += def (s)
            toolbar.set_style(ToolbarStyle.ICONS)
            toolbarstyle = "icons"
        toolbar_tab_item3 = new RadioMenuItem.with_label(toolbar_tab_item1.get_group(), _("Text only"))
        toolbarmenu.append(toolbar_tab_item3)
        toolbar_tab_item3.toggled += def (s)
            toolbar.set_style(ToolbarStyle.TEXT)
            toolbarstyle = "text"
        menu3.append(toolbarmenu2)
        separator_menu_item = new SeparatorMenuItem()
        menu3.append(separator_menu_item)
        check_menu_item6 = new CheckMenuItem.with_label(_("Auto indent"))
        accelerator_parse("<Ctrl>M", out key, out mod)
        check_menu_item6.add_accelerator("activate", aGroup, key, mod, AccelFlags.VISIBLE)
        menu3.append(check_menu_item6)
        check_menu_item6.toggled += on_check6
        check_menu_item7 = new CheckMenuItem.with_label(_("Indent on tab"))
        accelerator_parse("<Ctrl>D", out key, out mod)
        check_menu_item7.add_accelerator("activate", aGroup, key, mod, AccelFlags.VISIBLE)
        menu3.append(check_menu_item7)
        check_menu_item7.toggled += on_check7
        var indentmenu = new Menu()
        var indentmenu2 = new MenuItem.with_label(_("Indent width"))
        indentmenu2.set_submenu(indentmenu)
        radio_indent_item1 = new RadioMenuItem.with_label(mylist4, "2")
        indentmenu.append(radio_indent_item1)
        radio_indent_item1.toggled += def (s)
            text_view.set_indent_width(2)
            indentwidth = "2"
        radio_indent_item2 = new RadioMenuItem.with_label(radio_indent_item1.get_group(), "4")
        indentmenu.append(radio_indent_item2)
        radio_indent_item2.toggled += def (s)
            text_view.set_indent_width(4)
            indentwidth = "4"
        radio_indent_item3 = new RadioMenuItem.with_label(radio_indent_item1.get_group(), "8")
        indentmenu.append(radio_indent_item3)
        radio_indent_item3.toggled += def (s)
            text_view.set_indent_width(8)
            indentwidth = "8"
        menu3.append(indentmenu2)
        separator_menu_item = new SeparatorMenuItem()
        menu3.append(separator_menu_item)
        check_menu_item2 = new CheckMenuItem.with_label(_("Insert spaces instead of tabs"))
        accelerator_parse("<Ctrl>I", out key, out mod)
        check_menu_item2.add_accelerator("activate", aGroup, key, mod, AccelFlags.VISIBLE)
        menu3.append(check_menu_item2)
        check_menu_item2.toggled += on_check2
        var tabmenu = new Menu()
        var tabmenu2 = new MenuItem.with_label(_("Tabs width"))
        tabmenu2.set_submenu(tabmenu)
        radio_tab_item1 = new RadioMenuItem.with_label(mylist2, "2")
        tabmenu.append(radio_tab_item1)
        radio_tab_item1.toggled += def (s)
            text_view.set_tab_width(2)
            tabwidth = "2"
        radio_tab_item2 = new RadioMenuItem.with_label(radio_tab_item1.get_group(), "4")
        tabmenu.append(radio_tab_item2)
        radio_tab_item2.toggled += def (s)
            text_view.set_tab_width(4)
            tabwidth = "4"
        radio_tab_item3 = new RadioMenuItem.with_label(radio_tab_item1.get_group(), "8")
        tabmenu.append(radio_tab_item3)
        radio_tab_item3.toggled += def (s)
            text_view.set_tab_width(8)
            tabwidth = "8"
        menu3.append(tabmenu2)
        separator_menu_item = new SeparatorMenuItem()
        menu3.append(separator_menu_item)
        check_menu_item5 = new CheckMenuItem.with_label(_("Highlight syntax"))
        accelerator_parse("<Ctrl>H", out key, out mod)
        check_menu_item5.add_accelerator("activate", aGroup, key, mod, AccelFlags.VISIBLE)
        menu3.append(check_menu_item5)
        check_menu_item5.set_active(true)
        check_menu_item5.toggled += on_check5
        /* *************** */
        /*  Extended Menu  */
        /* *************** */
        var cmenu = new Menu()
        var colormenu = new MenuItem.with_label(_("Coloration mode"))
        colormenu.set_submenu(cmenu)
        radio_menu_item = new RadioMenuItem.with_label(mylist, _("Text"))
        cmenu.append(radio_menu_item)
        radio_menu_item.toggled += def (s)
            buf.language = manager.get_language ("text")
            thedefaultsyntax = "text/plain"
        separator_menu_item = new SeparatorMenuItem()
        cmenu.append(separator_menu_item)
        radio_menu_item1 = new RadioMenuItem.with_label(radio_menu_item.get_group(), "Asp")
        cmenu.append(radio_menu_item1)
        radio_menu_item1.toggled += def (s)
            buf.language = manager.get_language ("asp")
            thedefaultsyntax = "application/x-asp"
        radio_menu_item26 = new RadioMenuItem.with_label(radio_menu_item.get_group(), "C")
        cmenu.append(radio_menu_item26)
        radio_menu_item26.toggled += def (s)
            buf.language = manager.get_language ("c")
            thedefaultsyntax = "text/x-csrc"
        radio_menu_item2 = new RadioMenuItem.with_label(radio_menu_item.get_group(), "C++")
        cmenu.append(radio_menu_item2)
        radio_menu_item2.toggled += def (s)
            buf.language = manager.get_language ("cpp")
            thedefaultsyntax = "x-c++src"
        radio_menu_item3 = new RadioMenuItem.with_label(radio_menu_item.get_group(), "C#")
        cmenu.append(radio_menu_item3)
        radio_menu_item3.toggled += def (s)
            buf.language = manager.get_language ("csharp")
            thedefaultsyntax = "text/x-csharp"
        radio_menu_item18 = new RadioMenuItem.with_label(radio_menu_item.get_group(), "CSS")
        cmenu.append(radio_menu_item18)
        radio_menu_item18.toggled += def (s)
            buf.language = manager.get_language ("css")
            thedefaultsyntax = "text/css"
        radio_menu_item19 = new RadioMenuItem.with_label(radio_menu_item.get_group(), "Diff")
        cmenu.append(radio_menu_item19)
        radio_menu_item19.toggled += def (s)
            buf.language = manager.get_language ("diff")
            thedefaultsyntax = "text/x-patch"
        radio_menu_item4 = new RadioMenuItem.with_label(radio_menu_item.get_group(), "Genie")
        cmenu.append(radio_menu_item4)
        radio_menu_item4.toggled += def (s)
            buf.language = manager.get_language ("genie")
            thedefaultsyntax = "text/x-genie"
        radio_menu_item14 = new RadioMenuItem.with_label(radio_menu_item.get_group(), "HTML")
        cmenu.append(radio_menu_item14)
        radio_menu_item14.toggled += def (s)
            buf.language = manager.get_language ("html")
            thedefaultsyntax = "text/html"
        radio_menu_item5 = new RadioMenuItem.with_label(radio_menu_item.get_group(), "Java")
        cmenu.append(radio_menu_item5)
        radio_menu_item5.toggled += def (s)
            buf.language = manager.get_language ("java")
            thedefaultsyntax = "application/x-java"
        radio_menu_item15 = new RadioMenuItem.with_label(radio_menu_item.get_group(), "Java Script")
        cmenu.append(radio_menu_item15)
        radio_menu_item15.toggled += def (s)
            buf.language = manager.get_language ("javascript")
            thedefaultsyntax = "application/javascript"
        radio_menu_item16 = new RadioMenuItem.with_label(radio_menu_item.get_group(), "LaTex")
        cmenu.append(radio_menu_item16)
        radio_menu_item16.toggled += def (s)
            buf.language = manager.get_language ("latex")
            thedefaultsyntax = "text/x-tex"
        radio_menu_item22 = new RadioMenuItem.with_label(radio_menu_item.get_group(), "Lua")
        cmenu.append(radio_menu_item22)
        radio_menu_item22.toggled += def (s)
            buf.language = manager.get_language ("lua")
            thedefaultsyntax = "text/x-lua"
        radio_menu_item6 = new RadioMenuItem.with_label(radio_menu_item.get_group(), "Pascal")
        cmenu.append(radio_menu_item6)
        radio_menu_item6.toggled += def (s)
            buf.language = manager.get_language ("pascal")
            thedefaultsyntax = "text/x-pascal"
        radio_menu_item7 = new RadioMenuItem.with_label(radio_menu_item.get_group(), "Perl")
        cmenu.append(radio_menu_item7)
        radio_menu_item7.toggled += def (s)
            buf.language = manager.get_language ("perl")
            thedefaultsyntax = "application/x-perl"
        radio_menu_item8 = new RadioMenuItem.with_label(radio_menu_item.get_group(), "PHP")
        cmenu.append(radio_menu_item8)
        radio_menu_item8.toggled += def (s)
            buf.language = manager.get_language ("php")
            thedefaultsyntax = "application/x-php"
        radio_menu_item24 = new RadioMenuItem.with_label(radio_menu_item.get_group(), _("Lang File"))
        cmenu.append(radio_menu_item24)
        radio_menu_item24.toggled += def (s)
            buf.language = manager.get_language ("gettext-translation")
            thedefaultsyntax = "text/x-gettext-translation"
        radio_menu_item9 = new RadioMenuItem.with_label(radio_menu_item.get_group(), "Python")
        cmenu.append(radio_menu_item9)
        radio_menu_item9.toggled += def (s)
            buf.language = manager.get_language ("python")
            thedefaultsyntax = "text/x-python"
        /*
        radio_menu_item21 = new RadioMenuItem.with_label(radio_menu_item.get_group(), "R")
        cmenu.append(radio_menu_item21)
        radio_menu_item21.toggled += def (s)
            buf.language = manager.get_language ("r")
            thedefaultsyntax = "r"
        */
        radio_menu_item10 = new RadioMenuItem.with_label(radio_menu_item.get_group(), "Ruby")
        cmenu.append(radio_menu_item10)
        radio_menu_item10.toggled += def (s)
            buf.language = manager.get_language ("ruby")
            thedefaultsyntax = "application/x-ruby"
        radio_menu_item25 = new RadioMenuItem.with_label(radio_menu_item.get_group(), "Sh")
        cmenu.append(radio_menu_item25)
        radio_menu_item25.toggled += def (s)
            buf.language = manager.get_language ("sh")
            thedefaultsyntax = "application/x-shellscript"
        radio_menu_item11 = new RadioMenuItem.with_label(radio_menu_item.get_group(), "SQL")
        cmenu.append(radio_menu_item11)
        radio_menu_item11.toggled += def (s)
            buf.language = manager.get_language ("sql")
            thedefaultsyntax = "text/x-sql"
        radio_menu_item17 = new RadioMenuItem.with_label(radio_menu_item.get_group(), "Tcl")
        cmenu.append(radio_menu_item17)
        radio_menu_item17.toggled += def (s)
            buf.language = manager.get_language ("tcl")
            thedefaultsyntax = "text/x-tcl"
        radio_menu_item12 = new RadioMenuItem.with_label(radio_menu_item.get_group(), "Vala")
        cmenu.append(radio_menu_item12)
        radio_menu_item12.toggled += def (s)
            buf.language = manager.get_language ("vala")
            thedefaultsyntax = "text/x-vala"
        /*
        radio_menu_item23 = new RadioMenuItem.with_label(radio_menu_item.get_group(), "VB.NET")
        cmenu.append(radio_menu_item23)
        radio_menu_item23.toggled += def (s)
            buf.language = manager.get_language ("vbnet")
            thedefaultsyntax = "vbnet"
        */
        radio_menu_item13 = new RadioMenuItem.with_label(radio_menu_item.get_group(), "XML")
        cmenu.append(radio_menu_item13)
        radio_menu_item13.toggled += def (s)
            buf.language = manager.get_language ("xml")
            thedefaultsyntax = "application/xml"
        radio_menu_item20 = new RadioMenuItem.with_label(radio_menu_item.get_group(), "XSLT")
        cmenu.append(radio_menu_item20)
        radio_menu_item20.toggled += def (s)
            buf.language = manager.get_language ("xslt")
            thedefaultsyntax = "application/x-xml+xslt"
        separator_menu_item = new SeparatorMenuItem()
        cmenu.append(separator_menu_item)
        radio_menu_item27 = new RadioMenuItem.with_label(radio_menu_item.get_group(), ".desktop")
        cmenu.append(radio_menu_item27)
        radio_menu_item27.toggled += def (s)
            buf.language = manager.get_language ("desktop")
            thedefaultsyntax = "application/x-desktop"
        /*
        radio_menu_item28 = new RadioMenuItem.with_label(radio_menu_item.get_group(), ".ini")
        cmenu.append(radio_menu_item28)
        radio_menu_item28.toggled += def (s)
            buf.language = manager.get_language ("ini")
            thedefaultsyntax = "ini"
        */
        menu3.append(colormenu)
        separator_menu_item = new SeparatorMenuItem()
        menu3.append(separator_menu_item)
        check_menu_item3 = new CheckMenuItem.with_label(_("Highlight current line"))
        accelerator_parse("<Ctrl>J", out key, out mod)
        check_menu_item3.add_accelerator("activate", aGroup, key, mod, AccelFlags.VISIBLE)
        menu3.append(check_menu_item3)
        check_menu_item3.toggled += on_check3
        separator_menu_item = new SeparatorMenuItem()
        menu3.append(separator_menu_item)
        check_menu_item4 = new CheckMenuItem.with_label(_("Show line number"))
        accelerator_parse("<Ctrl>L", out key, out mod)
        check_menu_item4.add_accelerator("activate", aGroup, key, mod, AccelFlags.VISIBLE)
        menu3.append(check_menu_item4)
        check_menu_item4.toggled += on_check4
        separator_menu_item = new SeparatorMenuItem()
        menu3.append(separator_menu_item)
        var menu_item_history = new MenuItem.with_label(_("Clear 'History'"))
        accelerator_parse("<Ctrl>B", out key, out mod)
        menu_item_history.add_accelerator("activate", aGroup, key, mod, AccelFlags.VISIBLE)
        menu_item_history.activate += def (s)
            try
                recentmanager.purge_items ()
            except e : GLib.Error
                print "Unable to purge items"
        menu3.append(menu_item_history)
        separator_menu_item = new SeparatorMenuItem()
        menu3.append(separator_menu_item)
        image_menu_item = new ImageMenuItem.from_stock(STOCK_FULLSCREEN, aGroup)
        accelerator_parse("F11", out key, out mod)
        image_menu_item.add_accelerator("activate", aGroup, key, mod, AccelFlags.VISIBLE)
        image_menu_item.activate += fullscreenmode
        menu3.append(image_menu_item)
        /* ***************** */
        /* End Extended Menu */
        /* ***************** */
        var launcher3 = new MenuItem.with_mnemonic(_("_View"))
        launcher3.set_submenu(menu3)
        bar.append(launcher3)
        /* *************** */
        recentmanager = new RecentManager()
        var manager2 = recentmanager.get_default()
        var filter = new RecentFilter()
        filter.add_application("NicoEdit")
        recent_menu_chooser = new RecentChooserMenu.for_manager(manager2)
        recent_menu_chooser.set_show_tips(true)
        recent_menu_chooser.set_limit(21)
        recent_menu_chooser.set_show_numbers(true)
        recent_menu_chooser.set_local_only(true)
        recent_menu_chooser.set_show_not_found(false)
        recent_menu_chooser.set_sort_type(RecentSortType.MRU)
        recent_menu_chooser.set_filter(filter)
        recent_menu_chooser.item_activated += recent_item_activated
        var launcher7 = new MenuItem.with_label(_("History"))
        launcher7.set_submenu(recent_menu_chooser)
        bar.append(launcher7)
        /* *************** */
        var menu4 = new Menu()
        image_menu_item4 = new ImageMenuItem.from_stock(STOCK_FIND, aGroup)
        image_menu_item4.activate += def (s)
            gotohbox.hide()
            replacehbox.hide()
            searchhbox.show()
            search_entry.grab_focus ()
        menu4.append(image_menu_item4)
        image_menu_item4 = new ImageMenuItem.from_stock(STOCK_FIND_AND_REPLACE, aGroup)
        image_menu_item4.activate += def (s)
            gotohbox.hide()
            searchhbox.hide()
            replacehbox.show()
            replaceentry1.grab_focus ()
        menu4.append(image_menu_item4)
        separator_menu_item = new SeparatorMenuItem()
        menu4.append(separator_menu_item)
        image_menu_item4 = new ImageMenuItem.from_stock(STOCK_JUMP_TO, aGroup)
        accelerator_parse("<Ctrl>G", out key, out mod)
        image_menu_item4.add_accelerator("activate", aGroup, key, mod, AccelFlags.VISIBLE)
        image_menu_item4.activate += def (s)
            searchhbox.hide()
            replacehbox.hide()
            gotohbox.show()
            gototext.grab_focus ()
        menu4.append(image_menu_item4)
        var launcher4 = new MenuItem.with_mnemonic(_("_Search"))
        launcher4.set_submenu(menu4)
        bar.append(launcher4)
        /* *************** */
        var menu5 = new Menu()
        /*
        menu_item = new MenuItem.with_label(_("Change Background Color"))
        accelerator_parse("F7", out key, out mod)
        menu_item.add_accelerator("activate", aGroup, key, mod, AccelFlags.VISIBLE)
        menu_item.activate += change_background_color
        menu5.append(menu_item)
        menu_item = new MenuItem.with_label(_("Change Text Color"))
        accelerator_parse("F6", out key, out mod)
        menu_item.add_accelerator("activate", aGroup, key, mod, AccelFlags.VISIBLE)
        menu_item.activate += change_text_color
        menu5.append(menu_item)
        */
        menu_item = new MenuItem.with_label(_("Change Font"))
        accelerator_parse("F8", out key, out mod)
        menu_item.add_accelerator("activate", aGroup, key, mod, AccelFlags.VISIBLE)
        menu_item.activate += change_font
        menu5.append(menu_item)
        separator_menu_item = new SeparatorMenuItem()
        menu5.append(separator_menu_item)
        menu5.append(menu_item = new MenuItem.with_label(_("Document Stats")))
        accelerator_parse("F9", out key, out mod)
        menu_item.add_accelerator("activate", aGroup, key, mod, AccelFlags.VISIBLE)
        menu_item.activate += info_clicked
        var launcher5 = new MenuItem.with_mnemonic(_("_Tools"))
        launcher5.set_submenu(menu5)
        bar.append(launcher5)
        /* *************** */
        var menu6 = new Menu()
        image_menu_item5 = new ImageMenuItem.from_stock(STOCK_ABOUT, aGroup)
        accelerator_parse("F1", out key, out mod)
        image_menu_item5.add_accelerator("activate", aGroup, key, mod, AccelFlags.VISIBLE)
        image_menu_item5.activate += about_clicked
        menu6.append(image_menu_item5)
        var launcher6 = new MenuItem.with_label(_("Help"))
        launcher6.set_submenu(menu6)
        bar.append(launcher6)

        /* Toolbar */
        var bGroup = new AccelGroup()
        add_accel_group(bGroup)
        toolbar = new Toolbar ()
        var separator = new SeparatorToolItem ()
        var separator2 = new SeparatorToolItem ()
        var separator3 = new SeparatorToolItem ()
        var separator4 = new SeparatorToolItem ()
        var separator5 = new SeparatorToolItem ()
        var new_button = new ToolButton.from_stock (STOCK_NEW)
        new_button.set_tooltip_text(_("New"))
        accelerator_parse("<Ctrl>N", out key, out mod)
        new_button.add_accelerator("clicked", bGroup, key, mod, AccelFlags.VISIBLE)
        var open_button = new ToolButton.from_stock (STOCK_OPEN)
        open_button.set_tooltip_text(_("Open"))
        accelerator_parse("<Ctrl>O", out key, out mod)
        open_button.add_accelerator("clicked", bGroup, key, mod, AccelFlags.VISIBLE)
        var save_button = new ToolButton.from_stock (STOCK_SAVE)
        save_button.set_tooltip_text(_("Save"))
        accelerator_parse("<Ctrl>S", out key, out mod)
        save_button.add_accelerator("clicked", bGroup, key, mod, AccelFlags.VISIBLE)
        var print_button = new ToolButton.from_stock (STOCK_PRINT)
        print_button.set_tooltip_text(_("Print"))
        accelerator_parse("<Ctrl>P", out key, out mod)
        print_button.add_accelerator("clicked", bGroup, key, mod, AccelFlags.VISIBLE)
        undo_button = new ToolButton.from_stock (STOCK_UNDO)
        undo_button.set_tooltip_text(_("Undo"))
        undo_button.sensitive = false
        accelerator_parse("<Ctrl>Z", out key, out mod)
        undo_button.add_accelerator("clicked", bGroup, key, mod, AccelFlags.VISIBLE)
        redo_button = new ToolButton.from_stock (STOCK_REDO)
        redo_button.set_tooltip_text(_("Redo"))
        redo_button.sensitive = false
        accelerator_parse("<Shift><Ctrl>Z", out key, out mod)
        redo_button.add_accelerator("clicked", bGroup, key, mod, AccelFlags.VISIBLE)
        var cut_button = new ToolButton.from_stock (STOCK_CUT)
        cut_button.set_tooltip_text(_("Cut"))
        accelerator_parse("<Ctrl>X", out key, out mod)
        cut_button.add_accelerator("clicked", bGroup, key, mod, AccelFlags.VISIBLE)
        var copy_button = new ToolButton.from_stock (STOCK_COPY)
        copy_button.set_tooltip_text(_("Copy"))
        accelerator_parse("<Ctrl>C", out key, out mod)
        copy_button.add_accelerator("clicked", bGroup, key, mod, AccelFlags.VISIBLE)
        var paste_button = new ToolButton.from_stock (STOCK_PASTE)
        paste_button.set_tooltip_text(_("Paste"))
        accelerator_parse("<Ctrl>V", out key, out mod)
        paste_button.add_accelerator("clicked", bGroup, key, mod, AccelFlags.VISIBLE)
        var find_button = new ToolButton.from_stock (STOCK_FIND)
        find_button.set_tooltip_text(_("Find"))
        accelerator_parse("<Ctrl>F", out key, out mod)
        find_button.add_accelerator("clicked", bGroup, key, mod, AccelFlags.VISIBLE)
        var replace_button = new ToolButton.from_stock (STOCK_FIND_AND_REPLACE)
        replace_button.set_tooltip_text(_("Replace Text"))
        accelerator_parse("<Ctrl>R", out key, out mod)
        replace_button.add_accelerator("clicked", bGroup, key, mod, AccelFlags.VISIBLE)
        fullscreen_button = new ToolButton.from_stock (STOCK_FULLSCREEN)
        fullscreen_button.set_tooltip_text(_("Fullscreen"))
        accelerator_parse("F11", out key, out mod)
        fullscreen_button.add_accelerator("clicked", bGroup, key, mod, AccelFlags.VISIBLE)
        toolbar.add (new_button)
        toolbar.add (open_button)
        toolbar.add (save_button)
        toolbar.add (separator)
        toolbar.add (print_button)
        toolbar.add (separator2)
        toolbar.add (undo_button)
        toolbar.add (redo_button)
        toolbar.add (separator3)
        toolbar.add (cut_button)
        toolbar.add (copy_button)
        toolbar.add (paste_button)
        toolbar.add (separator4)
        toolbar.add (find_button)
        toolbar.add (replace_button)
        toolbar.add (separator5)
        toolbar.add (fullscreen_button)
        new_button.clicked += new_text
        open_button.clicked += on_open_clicked
        save_button.clicked += save_clicked
        print_button.clicked += def (s)
            initialize_printer("print")
        undo_button.clicked += def (s)
            undo_clicked()
            check_undo_redo()
        redo_button.clicked += def (s)
            redo_clicked()
            check_undo_redo()
        cut_button.clicked += cut_clipboard
        copy_button.clicked += copy_clipboard
        paste_button.clicked += paste_clipboard
        find_button.clicked += def (s)
            gotohbox.hide()
            replacehbox.hide()
            searchhbox.show()
            search_entry.grab_focus ()
        replace_button.clicked += def (s)
            gotohbox.hide()
            searchhbox.hide()
            replacehbox.show()
            replaceentry1.grab_focus ()
        fullscreen_button.clicked += fullscreenmode

        /* Go to line */
        gototext = new Entry ()
        gototext.activate += def (s)
            go_to_line(gototext.get_text().to_int())
            this.gotohbox.hide()
            text_view.grab_focus ()
        var goto_close_button = create_image_button (Gtk.STOCK_CLOSE, _("Close"))
        goto_close_button.clicked += def (s)
            gotohbox.hide()
        var gotolabel = new Label.with_mnemonic (_("Go to line :"))
        gototext.focus_out_event.connect(gototext_event)

        /* Go to line HBox */
        gotohbox = new HBox (false, 0)
        gotohbox.pack_start (goto_close_button, false, true, 5)
        gotohbox.pack_start (gotolabel, false, true, 5)
        gotohbox.pack_start (gototext, false, true, 3)

        /* Print */
        printlabel = new Label(_("Preparing, please wait..."))
        printprogress = new ProgressBar()

        /* Print VBox */
        printvbox = new VBox (false, 0)
        printvbox.pack_start (printlabel, false, true, 5)
        printvbox.pack_start (printprogress, false, true, 2)

        /* Textview */
        manager = new SourceLanguageManager()
        var none = new TextTagTable()
        buf = new SourceBuffer(none)
        text_view = new SourceView.with_buffer(buf)
        text_view.set_insert_spaces_instead_of_tabs(false)
        text_view.buffer.changed += def (s)
            text_changed()
            check_undo_redo()
            check_line_and_col()
        buf.set_highlight_syntax (true)
        buf.set_highlight_matching_brackets (false)
        text_view.grab_focus ()
        text_view.event.connect(text_view_event)

        /* Scrolled Window */
        var scroll = new ScrolledWindow (null, null)
        scroll.set_policy (PolicyType.AUTOMATIC, PolicyType.AUTOMATIC)
        scroll.add (text_view)

        /* Rapid Search */
        search_entry = new Entry ()
        search_entry.activate += def (s)
            findtext("", "search")
        var search_close_button = create_image_button (Gtk.STOCK_CLOSE, _("Close"))
        search_close_button.clicked += def (s)
            searchhbox.hide()
        var search_label = new Label.with_mnemonic (_("_Search for:"))
        var button_next = create_image_button (Gtk.STOCK_GO_FORWARD, _("Find next"))
        button_next.clicked += def (s)
            findtext("next", "search")
        var button_prev = create_image_button (Gtk.STOCK_GO_BACK, _("Find previous"))
        button_prev.clicked += def (s)
            findtext("prev", "search")
        match_case = new CheckButton.with_mnemonic (_("_Match case"))
        match_word_only = new CheckButton.with_mnemonic (_("Match _entire word only"))
        var button2 = new Button.from_stock (STOCK_CLOSE)
        button2.clicked += def (s)
            this.searchhbox.hide()
            text_view.grab_focus ()
        search_info_label = new Label("")

        /* Search HBox */
        searchhbox = new HBox (false, 0)
        searchhbox.pack_start (search_close_button, false, true, 2)
        searchhbox.pack_start (search_label, false, true, 5)
        searchhbox.pack_start (search_entry, false, true, 5)
        searchhbox.pack_start (match_case, false, true, 5)
        searchhbox.pack_start (match_word_only, false, true, 5)
        searchhbox.pack_start (button_prev, false, true, 5)
        searchhbox.pack_start (button_next, false, true, 5)
        searchhbox.pack_start (search_info_label, false, true, 2)

        /* Replace */
        replaceentry1 = new Entry ()
        replaceentry2 = new Entry ()
        var replace_close_button = create_image_button (Gtk.STOCK_CLOSE, _("Close"))
        replace_close_button.clicked += def (s)
            replacehbox.hide()
        var replace_search_label = new Label.with_mnemonic (_("_Replace: "))
        var replace_search_label2 = new Label (_("by: "))
        var button_replace_next = create_image_button (Gtk.STOCK_GO_FORWARD, _("Replace next"))
        button_replace_next.clicked += def (s)
            replace_next ()
        var button_replace_prev = create_image_button (Gtk.STOCK_GO_BACK, _("Replace previous"))
        button_replace_prev.clicked += def (s)
            replace_prev ()
        replace_match_case = new CheckButton.with_mnemonic (_("_Match case"))
        replace_match_word_only = new CheckButton.with_mnemonic (_("Match _entire word only"))
        var closereplace = new Button.from_stock(STOCK_CLOSE)
        closereplace.clicked += def (s)
            replacehbox.hide()
            text_view.grab_focus ()

        /* Replace HBox */
        replacehbox = new HBox (false, 0)
        replacehbox.pack_start (replace_close_button, false, true, 2)
        replacehbox.pack_start (replace_search_label, false, true, 5)
        replacehbox.pack_start (replaceentry1, false, true, 2)
        replacehbox.pack_start (replace_search_label2, false, true, 5)
        replacehbox.pack_start (replaceentry2, false, true, 2)
        replacehbox.pack_start (replace_match_case, false, true, 5)
        replacehbox.pack_start (replace_match_word_only, false, true, 5)
        replacehbox.pack_start (button_replace_prev, false, true, 5)
        replacehbox.pack_start (button_replace_next, false, true, 5)

        /* Status Bar */
        status_bar = new Statusbar ()
        status_bar.set_has_resize_grip (true)
        status_bar.pop(0)

        /* HBox */
        status_hbox = new HBox (false, 0)
        status_hbox.pack_start (status_bar, true, true, 0)

        /* VBox */
        var vbox = new VBox (false, 0)
        vbox.pack_start (bar, false, true, 0)
        vbox.pack_start (toolbar, false, true, 0)
        vbox.pack_start (printvbox, false, true, 0)
        vbox.pack_start (scroll, true, true, 0)
        vbox.pack_start (searchhbox, false, true, 1)
        vbox.pack_start (gotohbox, false, true, 1)
        vbox.pack_start (replacehbox, false, true, 1)
        vbox.pack_start (status_hbox, false, true, 0)
        add (vbox)

        resize (default_window_width, default_window_height)

    /* ********************************* */
    /*       Create Button Function      */
    /* ********************************* */

    def create_image_button(stock_id : string, tooltip : string) : Button
        button : Button
        image : Image
        image = new Gtk.Image.from_stock (stock_id, Gtk.IconSize.BUTTON)
        button = new Gtk.Button ()
        button.add (image)
        button.set_relief (Gtk.ReliefStyle.NONE)
        button.set_tooltip_text (tooltip)
        button.can_focus = false
        return button

    /* ********************************* */
    /*          Key Press Signal         */
    /* ********************************* */

    def nicoedit_key_press_event (widget : Gtk.Widget, event : Gdk.EventKey) : bool
        if (event.keyval == Gdk.KeySyms.Escape)
            searchhbox.hide()
            gotohbox.hide()
            replacehbox.hide()
            text_view.grab_focus ()
        if (event.keyval == Gdk.KeySyms.Up)
            text_view.grab_focus ()
        if (event.keyval == Gdk.KeySyms.F3)
            findtext ("next", "search")
        if (event.keyval == Gdk.KeySyms.F2)
            findtext ("prev", "search")
        if (event.keyval == Gdk.KeySyms.F11)
            fullscreenmode ()
        if (event.keyval == Gdk.KeySyms.F1)
            about_clicked ()
        return false

    def text_view_event (widget : Gtk.Widget, event : Gdk.Event) : bool
        check_line_and_col()
        return false

    def gototext_event (widget : Gtk.Widget, event : Gdk.EventFocus) : bool
        gotohbox.hide()
        return false

    /* ********************************* */
    /*   Recent Item Clicked Function    */
    /* ********************************* */

    def recent_item_activated ()
        uri : string
        uri = recent_menu_chooser.get_current_item().get_uri()
        file : File = File.new_for_uri (uri)
        filename : string = file.get_path()
        if document_modified is true
            messagedialog = new MessageDialog (this, Gtk.DialogFlags.DESTROY_WITH_PARENT | Gtk.DialogFlags.MODAL, Gtk.MessageType.QUESTION, Gtk.ButtonsType.YES_NO, (_("The file is unregistered, do you want to save it ?")))
            var response = messagedialog.run()
            if response is ResponseType.YES
                save_clicked ()
                messagedialog.destroy()
                open_file(filename)
            else if response is ResponseType.NO
                open_file(filename)
                messagedialog.destroy()
        else
            open_file(filename)

    /* ********************************* */
    /*       Save Settings Function      */
    /* ********************************* */

    def save_stats ()
        width : int
        height : int
        get_size (out width, out height)
        try
            var file = File.new_for_path(Environment.get_home_dir() + "/.NicoEdit.rc")
            var renamed = file.set_display_name ("samplefile.bak", null)
            var thefile_stream = file.create (FileCreateFlags.NONE, null)
            var data_stream = new DataOutputStream (thefile_stream)
            data_stream.put_string ("default_window_height=" + height.to_string() + "|default_window_width=" + width.to_string() + "|viewtoolbar=" + viewtoolbar + "|linenumber=" + linenumber + "|insertspace=" + insertspace + "|highlightcurrentline=" + highlightcurrentline +"|highlightsyntax=" + highlightsyntax + "|defaultsyntax=" + thedefaultsyntax + "|backgroundcolor=" + thebackgroundcolor + "|textcolor=" + thetextcolor + "|font=" + thefont + "|tabwidth=" + tabwidth + "|toolbarstyle=" + toolbarstyle + "|autoindent=" + autoindent + "|indentontab=" + indentontab + "|indentwidth=" + indentwidth, null)
            renamed.delete(null)
        except e : GLib.Error
            print "Unable to save stats"

    /* ********************************* */
    /*    Restore Settings Function      */
    /* ********************************* */

    def restore_stats ()
        this.searchhbox.hide()
        this.gotohbox.hide()
        this.replacehbox.hide()
        this.printvbox.hide()
        try
            text : string
            length : ulong
            FileUtils.get_contents (Environment.get_home_dir() + "/.NicoEdit.rc", out text, out length)
            var textlist = text.split("|")
            for var s in textlist
                if s.contains("insertspace")
                    var s1 = s.split("=")
                    var value = s1[1].strip()
                    if value == "true"
                        check_menu_item2.set_active(true)
                        text_view.set_insert_spaces_instead_of_tabs(true)
                    else
                        check_menu_item2.set_active(false)
                        text_view.set_insert_spaces_instead_of_tabs(false)
                    insertspace = value
                if s.contains("highlightsyntax")
                    var s2 = s.split("=")
                    var value = s2[1].strip()
                    if value == "true"
                        check_menu_item5.set_active(true)
                        buf.set_highlight_syntax (true)
                    else
                        check_menu_item5.set_active(false)
                        buf.set_highlight_syntax (false)
                    highlightsyntax = value
                if s.contains("viewtoolbar")
                    var s3 = s.split("=")
                    var value = s3[1].strip()
                    if value == "true"
                        check_menu_item.set_active(true)
                        toolbar.show()
                    else
                        check_menu_item.set_active(false)
                        toolbar.hide()
                    viewtoolbar = value
                if s.contains("linenumber")
                    var s4 = s.split("=")
                    var value = s4[1].strip()
                    if value == "true"
                        check_menu_item4.set_active(true)
                        text_view.set_show_line_numbers(true)
                    else
                        check_menu_item4.set_active(false)
                        text_view.set_show_line_numbers(false)
                    linenumber = value
                if s.contains("highlightcurrentline")
                    var s5 = s.split("=")
                    var value = s5[1].strip()
                    if value == "true"
                        check_menu_item3.set_active(true)
                        text_view.set_highlight_current_line(true)
                    else
                        check_menu_item3.set_active(false)
                        text_view.set_highlight_current_line(false)
                    highlightcurrentline = value
                if s.contains("backgroundcolor")
                    var s6 = s.split("=")
                    var value = s6[1].strip()
                    thebackgroundcolor = value
                    Gdk.Color.parse (value, out color)
                    text_view.modify_base (Gtk.StateType.NORMAL, color)
                if s.contains("textcolor")
                    var s7 = s.split("=")
                    var value = s7[1].strip()
                    thetextcolor = value
                    Gdk.Color.parse (value, out color)
                    text_view.modify_text (Gtk.StateType.NORMAL, color)
                if s.contains("font")
                    var s8 = s.split("=")
                    var value = s8[1].strip()
                    thefont = value
                    font_desc = FontDescription.from_string(value)
                    text_view.modify_font(font_desc)
                if s.contains("defaultsyntax")
                    var s9 = s.split("=")
                    var value = s9[1].strip()
                    thedefaultsyntax = value
                    check_correct_lang(value)
                if s.contains("tabwidth")
                    var s10 = s.split("=")
                    var value = s10[1].strip()
                    if value is "2"
                        radio_tab_item1.set_active(true)
                    if value is "4"
                        radio_tab_item2.set_active(true)
                    if value is "8"
                        radio_tab_item3.set_active(true)
                    tabwidth = value
                if s.contains("toolbarstyle")
                    var s11 = s.split("=")
                    var value = s11[1].strip()
                    if value is "text"
                        toolbar_tab_item3.set_active(true)
                    if value is "icons"
                        toolbar_tab_item2.set_active(true)
                    if value is "both"
                        toolbar_tab_item1.set_active(true)
                    toolbarstyle = value
                if s.contains("indentwidth")
                    var s12 = s.split("=")
                    var value = s12[1].strip()
                    if value is "2"
                        radio_indent_item1.set_active(true)
                    if value is "4"
                        radio_indent_item2.set_active(true)
                    if value is "8"
                        radio_indent_item3.set_active(true)
                    indentwidth = value
                if s.contains("autoindent")
                    var s13 = s.split("=")
                    var value = s13[1].strip()
                    if value == "true"
                        check_menu_item6.set_active(true)
                        text_view.set_auto_indent(true)
                    else
                        check_menu_item6.set_active(false)
                        text_view.set_auto_indent(false)
                    autoindent = value
                if s.contains("indentontab")
                    var s14 = s.split("=")
                    var value = s14[1].strip()
                    if value == "true"
                        check_menu_item7.set_active(true)
                        text_view.set_indent_on_tab(true)
                    else
                        check_menu_item7.set_active(false)
                        text_view.set_indent_on_tab(false)
                    indentontab = value
        except e : GLib.Error
            thebackgroundcolor = "#ffffffffffff"
            thetextcolor = "#000000000000"
            thefont = "Sans 12"
            linenumber = "false"
            insertspace = "false"
            highlightcurrentline = "false"
            highlightsyntax = "true"
            viewtoolbar = "true"
            thedefaultsyntax = "text/plain"
            tabwidth = "4"
            toolbarstyle = "both"
            indentwidth = "2"
            autoindent = "false"
            indentontab = "false"
            this.searchhbox.hide()
            this.gotohbox.hide()
            this.printvbox.hide()
            var file = File.new_for_path(Environment.get_home_dir() + "/.NicoEdit.rc")
            try
                var thefile_stream = file.create (FileCreateFlags.NONE, null)
                var data_stream = new DataOutputStream (thefile_stream)
                try
                    data_stream.put_string ("default_window_height=560|default_window_width=792|viewtoolbar=true|insertspace=false|highlightcurrentline=false|linenumber=false|highlightsyntax=false|defaultsyntax=text/plain|backgroundcolor=#ffffffffffff|textcolor=#000000000000|font=Sans 12|tabwidth=4|toolbarstyle=both|indentwidth=2|autoindent=false|indentontab=false", null)
                except e : GLib.Error
                    print "Unable to put string in text file"
            except e : GLib.Error
                print "Unable to create stream for file"

    def restore_window_size ()
        try
            text : string
            length : ulong
            FileUtils.get_contents (Environment.get_home_dir() + "/.NicoEdit.rc", out text, out length)
            var textlist = text.split("|")
            for var s in textlist
                if s.contains("window_height=")
                    var s1 = s.split("=")
                    default_window_height = s1[1].strip().to_int()
                if s.contains("window_width")
                    var s2 = s.split("=")
                    default_window_width = s2[1].strip().to_int()
        except e : GLib.Error
            default_window_height = 560
            default_window_width = 792        

    /* ********************************* */
    /*    Autodetect Syntax Function     */
    /* ********************************* */

    def auto_detect_syntax ()
        try
            var fileopened = File.new_for_path (thefile)
            var file_info = fileopened.query_info ("*", FileQueryInfoFlags.NONE, null)
            check_correct_lang (file_info.get_content_type ())
        except e : GLib.Error
            print "Unable to detect file type"

    def check_correct_lang (value : string)
        b : string = value
        case b
            when "text/plain"
                radio_menu_item.set_active(true)
            when "text/x-makefile"
                radio_menu_item.set_active(true)
            when "text/x-authors"
                radio_menu_item.set_active(true)
            when "application/x-trash"
                radio_menu_item.set_active(true)
            when "application/x-copying"
                radio_menu_item.set_active(true)
            when "application/x-changelog"
                radio_menu_item.set_active(true)
            when "application/x-asp"
                radio_menu_item1.set_active(true)
            when "text/x-csrc"
                radio_menu_item26.set_active(true)
            when "text/x-chdr"
                radio_menu_item26.set_active(true)
            when "text/x-c++src"
                radio_menu_item2.set_active(true)
            when "text/x-c++hdr"
                radio_menu_item2.set_active(true)
            when "text/x-csharp"
                radio_menu_item3.set_active(true)
            when "text/css"
                radio_menu_item18.set_active(true)
            when "text/x-patch"
                radio_menu_item19.set_active(true)
            when "text/x-genie"
                radio_menu_item4.set_active(true)
            when "text/html"
                radio_menu_item14.set_active(true)
            when "application/x-java"
                radio_menu_item5.set_active(true)
            when "application/javascript"
                radio_menu_item15.set_active(true)
            when "text/x-tex"
                radio_menu_item16.set_active(true)
            when "text/x-lua"
                radio_menu_item22.set_active(true)
            when "text/x-pascal"
                radio_menu_item6.set_active(true)
            when "application/x-perl"
                radio_menu_item7.set_active(true)
            when "application/x-php"
                radio_menu_item8.set_active(true)
            when "text/x-gettext-translation"
                radio_menu_item24.set_active(true)
            when "text/x-python"
                radio_menu_item9.set_active(true)
            //when "r"
            //    radio_menu_item21.set_active(true)
            when "application/x-ruby"
                radio_menu_item10.set_active(true)
            when "application/x-shellscript"
                radio_menu_item25.set_active(true)
            when "application/x-shar"
                radio_menu_item25.set_active(true)
            when "application/x-csh"
                radio_menu_item25.set_active(true)
            when "text/x-sql"
                radio_menu_item11.set_active(true)
            when "application/x-sql2"
                radio_menu_item11.set_active(true)
            when "application/x-sql3"
                radio_menu_item11.set_active(true)
            when "text/x-tcl"
                radio_menu_item17.set_active(true)
            when "text/x-vala"
                radio_menu_item12.set_active(true)
            //when "vb.net"
            //    radio_menu_item23.set_active(true)
            when "application/xml"
                radio_menu_item13.set_active(true)
            when "application/docbook+xml"
                radio_menu_item13.set_active(true)
            when "application/xhtml+xml"
                radio_menu_item13.set_active(true)
            when "application/xml-dtd"
                radio_menu_item13.set_active(true)
            when "application/rss+xml"
                radio_menu_item13.set_active(true)
            when "application/rdf+xml"
                radio_menu_item13.set_active(true)
            when "application/x-xbel"
                radio_menu_item13.set_active(true)
            when "application/x-glade"
                radio_menu_item13.set_active(true)
            when "application/x-xml+xslt"
                radio_menu_item20.set_active(true)
            when "application/x-desktop"
                radio_menu_item27.set_active(true)
            //when "ini"
            //    radio_menu_item28.set_active(true)
        b = ""

    /* ********************************* */
    /*          Some Functions           */
    /* ********************************* */

    def on_check ()
        checked : bool = check_menu_item.get_active()
        if checked is true
            toolbar.show()
            viewtoolbar = "true"
        else
            toolbar.hide()
            viewtoolbar = "false"

    def on_check2 ()
        checked : bool = check_menu_item2.get_active()
        if checked is true
            text_view.set_insert_spaces_instead_of_tabs(true)
            insertspace = "true"
        else
            text_view.set_insert_spaces_instead_of_tabs(false)
            insertspace = "false"

    def on_check3 ()
        checked : bool = check_menu_item3.get_active()
        if checked is true
            buf.language = manager.get_language (thedefaultsyntax)
            text_view.set_highlight_current_line(true)
            highlightcurrentline = "true"
        else
            text_view.set_highlight_current_line(false)
            highlightcurrentline = "false"

    def on_check4 ()
        checked : bool = check_menu_item4.get_active()
        if checked is true
            text_view.set_show_line_numbers(true)
            linenumber = "true"
        else
            text_view.set_show_line_numbers(false)
            linenumber = "false"

    def on_check5 ()
        checked : bool = check_menu_item5.get_active()
        if checked is true
            buf.set_highlight_syntax (true)
            highlightsyntax = "true"
        else
            buf.set_highlight_syntax (false)
            highlightsyntax = "false"

    def on_check6 ()
        checked : bool = check_menu_item6.get_active()
        if checked is true
            text_view.set_auto_indent (true)
            autoindent = "true"
        else
            text_view.set_auto_indent (true)
            autoindent = "false"

    def on_check7 ()
        checked : bool = check_menu_item7.get_active()
        if checked is true
            text_view.set_indent_on_tab (true)
            indentontab = "true"
        else
            text_view.set_indent_on_tab (true)
            indentontab = "false"

    /* ********************************* */
    /*        Fullscreen Function        */
    /* ********************************* */

    def fullscreenmode ()
        if activatedfullscreen is false
            fullscreen ()
            bar.hide()
            this.status_bar.hide()
            quit_button.hide()
            fullscreen_button.set_tooltip_text(_("Leave Fullscreen"))
            activatedfullscreen = true
            fullscreen_button.set_stock_id (STOCK_LEAVE_FULLSCREEN)
        else
            unfullscreen ()
            bar.show()
            this.status_bar.show()
            quit_button.show()
            fullscreen_button.set_tooltip_text(_("Fullscreen"))
            activatedfullscreen = false
            fullscreen_button.set_stock_id (STOCK_FULLSCREEN)

    /* ********************************* */
    /*   Check for Undo/Redo Function    */
    /* ********************************* */

    def check_undo_redo()
        undo_button.sensitive = buf.can_undo
        undo_menu_item.sensitive = buf.can_undo
        redo_button.sensitive = buf.can_redo
        redo_menu_item.sensitive = buf.can_redo

    /* ********************************* */
    /*       Text Change Function        */
    /* ********************************* */

    def text_changed ()
        document_modified = true
        if thefile is not ""
            title = thefile + "* - " + _("unregistered") + " - NicoEdit"
        else
            title = _("new file") + "* - " + _("unregistered") + " - NicoEdit"

    /* ********************************* */
    /*         New Text Function         */
    /* ********************************* */

    def new_text ()
        if document_modified is true
            messagedialog = new MessageDialog (this, Gtk.DialogFlags.DESTROY_WITH_PARENT | Gtk.DialogFlags.MODAL, Gtk.MessageType.QUESTION, Gtk.ButtonsType.YES_NO, (_("The file is unregistered, do you want to save it ?")))
            messagedialog.add_button (STOCK_CANCEL, ResponseType.CANCEL)
            var response = messagedialog.run()
            if response is ResponseType.YES
                messagedialog.destroy()
                save_clicked ()
                clear_text()
                reloadmenu.sensitive = false
            else if response is ResponseType.NO
                clear_text()
                reloadmenu.sensitive = false
                messagedialog.destroy()
            else if response is ResponseType.CANCEL
                messagedialog.destroy()
        else
            reloadmenu.sensitive = false
            clear_text()

    /* ********************************* */
    /*        Clear Text Function        */
    /* ********************************* */

    def clear_text()
        text_view.buffer.set_text ("", 0)
        title = _("new file") + " - NicoEdit"
        document_modified = false
        thefile = ""

    /* ********************************* */
    /*          Some Functions           */
    /* ********************************* */

    def select_all ()
        text_view.select_all (true)

    def undo_clicked ()
        text_view.undo()

    def redo_clicked ()
        text_view.redo()

    def cut_clipboard ()
        text_view.cut_clipboard()

    def copy_clipboard ()
        text_view.copy_clipboard()

    def paste_clipboard ()
        text_view.paste_clipboard()

    def current_line () : int
        iter : TextIter
        text_view.buffer.get_iter_at_mark (out iter, text_view.buffer.get_insert ())
        return iter.get_line()

    def line_count () : int
        return text_view.buffer.get_line_count ()

    def info_clicked ()
        var messagedialog = new Gtk.MessageDialog (this, Gtk.DialogFlags.DESTROY_WITH_PARENT | Gtk.DialogFlags.MODAL, Gtk.MessageType.INFO, Gtk.ButtonsType.OK, (_("Your text have ")) + line_count ().to_string() + (_(" line(s)")))
        messagedialog.run()
        messagedialog.destroy()

    /* ********************************* */
    /*     Check Line/Colum Function     */
    /* ********************************* */

    def check_line_and_col()
        iter : TextIter
        start : TextIter
        tab_size : uint
        this.text_view.buffer.get_iter_at_mark (out iter, this.text_view.buffer.get_insert ())
        row : int = iter.get_line ()
        start = iter
        start.set_line_offset (0)
        col : int = 0
        tab_size = this.text_view.get_tab_width ()
        while (!start.equal (iter))
            if (start.get_char () == '\t')
                col += (int)(tab_size - (col  % tab_size))
            else
                col++
            start.forward_char()
        show_cursor_position (row + 1, col + 1)

    def show_cursor_position (line : int, col : int)
        if (line != -1 and col != -1)
            message : string = _("Line: %d, Colum: %d").printf (line, col)
            status_bar.push (0, message)

    /* ********************************* */
    /*          Search Function          */
    /* ********************************* */

    def findtext (typeofaction : string, searchorreplace : string)
        match_start : TextIter
        match_end : TextIter
        iter : TextIter
        found : bool = false
        search_flags = SourceSearchFlags.TEXT_ONLY
        text_view.buffer.get_start_iter (out match_start)
        text_view.buffer.get_end_iter (out match_end)
        text_view.buffer.get_selection_bounds (null, out iter)
        if searchorreplace is "search"
            if (!match_case.get_active())
                search_flags |= SourceSearchFlags.CASE_INSENSITIVE
        if searchorreplace is "replace"
            if (!replace_match_case.get_active())
                search_flags |= SourceSearchFlags.CASE_INSENSITIVE
        match_start = Gtk.TextIter ()
        match_end = Gtk.TextIter ()
        if typeofaction is "next"
            if searchorreplace is "search"
                found = source_iter_forward_search (iter, search_entry.get_text(), search_flags, out match_start, out match_end, null)
            if searchorreplace is "replace"
                found = source_iter_forward_search (iter, replaceentry1.get_text(), search_flags, out match_start, out match_end, null)
        if typeofaction is "prev"
            if searchorreplace is "search"
                iter.backward_word_start()
                found = source_iter_backward_search (iter, search_entry.get_text(), search_flags, out match_start, out match_end, null)
            if searchorreplace is "replace"
                iter.backward_word_start()
                found = source_iter_backward_search (iter, replaceentry1.get_text(), search_flags, out match_start, out match_end, null)
        if searchorreplace is "search"
            if (found && match_word_only.get_active() is true)
                found = match_start.starts_word () &&  match_end.ends_word ()
        if searchorreplace is "replace"
            if (found && replace_match_word_only.get_active() is true)
                found = match_start.starts_word () &&  match_end.ends_word ()
        if (found)
            text_view.buffer.place_cursor (iter)
            text_view.buffer.select_range(match_start, match_end)
            text_view.scroll_to_iter (iter, 0.25, false, 0.0, 0.0)
            text_view.scroll_to_mark (text_view.buffer.get_insert (), 0.25, false, 0.0, 0.0)
        else
            if typeofaction is "next"
                search_info_label.set_text(_("Bottom of the page reached, continuing to the top"))
                text_view.buffer.get_start_iter (out iter)
                text_view.buffer.place_cursor (iter)
                text_view.scroll_to_iter (iter, 0.25, false, 0.0, 0.0)
                text_view.scroll_to_mark (text_view.buffer.get_insert (), 0.25, false, 0.0, 0.0)
                search_info_label.set_text("")
            if typeofaction is "prev"
                search_info_label.set_text(_("Top of the page reached, continuing to the bottom"))
                text_view.buffer.get_end_iter (out iter)
                text_view.buffer.place_cursor (iter)
                text_view.scroll_to_iter (iter, 0.25, false, 0.0, 0.0)
                text_view.scroll_to_mark (text_view.buffer.get_insert (), 0.25, false, 0.0, 0.0)
                search_info_label.set_text("")
    
    /* ********************************* */
    /*         Replace Function          */
    /* ********************************* */

    def replace_next ()
        text : string = ""
        start : Gtk.TextIter
        end : Gtk.TextIter
        buffer : Gtk.TextBuffer = text_view.buffer
        findtext("next", "replace")
        if (buffer.get_selection_bounds (out start, out end))
            text = buffer.get_text (start, end, false)
        if (text != "" && text == replaceentry1.get_text())
            buffer.delete (start, end)
            buffer.insert (start, replaceentry2.get_text(), -1)

    def replace_prev ()
        text : string = ""
        start : Gtk.TextIter
        end : Gtk.TextIter
        buffer : Gtk.TextBuffer = text_view.buffer
        findtext("next", "prev")
        if (buffer.get_selection_bounds (out start, out end))
            text = buffer.get_text (start, end, false)
        if (text != "" && text == replaceentry1.get_text())
            buffer.delete (start, end)
            buffer.insert (start, replaceentry2.get_text(), -1)


    /* ********************************* */
    /*        GoToLine Function          */
    /* ********************************* */
      
    def go_to_line (line_number : int)
        iter : TextIter
        text_view.buffer.get_iter_at_line (out iter, line_number)
        iter.set_line (line_number - 1)
        text_view.scroll_to_iter (iter, 0, false, 0, 0)
        text_view.buffer.place_cursor (iter)

    /* ********************************* */
    /* Change Background Color Function  */
    /* ********************************* */
    /*
    def change_background_color ()
        newcolor = new ColorSelectionDialog (_("Choose your prefered background color:"))
        var response = newcolor.run()
        if response is ResponseType.OK
            var colorsel = (ColorSelection) newcolor.colorsel
            colorsel.get_current_color (out color)
            thebackgroundcolor = color.to_string()
            text_view.modify_base (Gtk.StateType.NORMAL, color)
            newcolor.destroy()
        if response is ResponseType.CANCEL
            newcolor.destroy()
        if response is ResponseType.HELP
            messagedialog = new MessageDialog (this, Gtk.DialogFlags.DESTROY_WITH_PARENT | Gtk.DialogFlags.MODAL, Gtk.MessageType.INFO, Gtk.ButtonsType.CLOSE, (_("Choose your color and click 'Ok'")))
            messagedialog.run()
            messagedialog.destroy()
    */

    /* ********************************* */
    /*    Change Text Color Function     */
    /* ********************************* */
    /*
    def change_text_color ()
        newcolor = new ColorSelectionDialog (_("Choose your prefered text color:"))
        var response = newcolor.run()
        if response is ResponseType.OK
            var colorsel = (ColorSelection) newcolor.colorsel
            colorsel.get_current_color (out color)
            thetextcolor = color.to_string()
            text_view.modify_text (Gtk.StateType.NORMAL, color)
            newcolor.destroy()
        if response is ResponseType.CANCEL
            newcolor.destroy()
        if response is ResponseType.HELP
            messagedialog = new MessageDialog (this, Gtk.DialogFlags.DESTROY_WITH_PARENT | Gtk.DialogFlags.MODAL, Gtk.MessageType.INFO, Gtk.ButtonsType.CLOSE, (_("Choose your color and click 'Ok'")))
            messagedialog.run()
            messagedialog.destroy()
    */

    /* ********************************* */
    /*       Change Font Function        */
    /* ********************************* */

    def change_font ()
        newfont = new FontSelectionDialog(_("Select your prefered font:"))
        newfont.set_font_name(thefont)
        var response = newfont.run()
        if response is ResponseType.OK
            font_desc = FontDescription.from_string(newfont.get_font_name())
            thefont = font_desc.to_string()
            text_view.modify_font(font_desc)
            newfont.destroy()
        if response is ResponseType.CANCEL
            newfont.destroy()

    /* ********************************* */
    /*          Print Function           */
    /* ********************************* */

    def initialize_printer (defaultaction : string)
        theaction = defaultaction
        op = new PrintOperation ()
        context = new PrintContext ()
        thecompositor = new SourcePrintCompositor.from_view(text_view)
        thecompositor.set_wrap_mode(Gtk.WrapMode.WORD)
        var paper_size = new PaperSize(PAPER_NAME_A4)
        var setup = new PageSetup()
        setup.set_paper_size_and_default_margins(paper_size)
        op.set_default_page_setup(setup)
        op.set_job_name("NicoEdit")
        thecompositor.set_body_font_name(thefont)
        if linenumber is "true"
            thecompositor.set_print_line_numbers(1)
            thecompositor.set_line_numbers_font_name("Sans 10")
        if highlightsyntax is "true"
            thecompositor.set_highlight_syntax(true)
        else if highlightsyntax is "false"
            thecompositor.set_highlight_syntax(false)
        op.paginate += paginate
        op.draw_page += draw_page
        op.end_print += end_print
        if theaction is "preview"
            try
                this.printvbox.show()
                op.run (PrintOperationAction.PREVIEW, this)
            except e : GLib.Error
                this.printvbox.hide()
                messagedialog = new MessageDialog (this, Gtk.DialogFlags.DESTROY_WITH_PARENT | Gtk.DialogFlags.MODAL, Gtk.MessageType.ERROR, Gtk.ButtonsType.CLOSE, (_("Unable to create preview !")))
        else if theaction is "print"
            try
                op.run (PrintOperationAction.PRINT_DIALOG, this)
            except e : GLib.Error
                this.printvbox.hide()
                check_line_and_col()
                messagedialog = new MessageDialog (this, Gtk.DialogFlags.DESTROY_WITH_PARENT | Gtk.DialogFlags.MODAL, Gtk.MessageType.ERROR, Gtk.ButtonsType.CLOSE, (_("Unable to print !")))
        else if theaction is "export"
            var file_chooser = new FileChooserDialog ((_("Save File as PDF")), this, FileChooserAction.SAVE, STOCK_CANCEL, ResponseType.CANCEL, STOCK_SAVE, ResponseType.ACCEPT, null)
            var response = file_chooser.run ()
            if response is ResponseType.ACCEPT
                try
                    this.printvbox.show()
                    file_chooser.hide ()
                    op.set_export_filename(file_chooser.get_filename ())
                    op.run (PrintOperationAction.EXPORT, this)
                except e : GLib.Error
                    this.printvbox.hide()
                    check_line_and_col()
                    messagedialog = new MessageDialog (this, Gtk.DialogFlags.DESTROY_WITH_PARENT | Gtk.DialogFlags.MODAL, Gtk.MessageType.ERROR, Gtk.ButtonsType.CLOSE, (_("Unable to export as pdf !")))
            file_chooser.destroy ()

    def draw_page (context : PrintContext, page_nr : int)
        thecompositor.draw_page (context, page_nr)
        printprogress.set_fraction (page_nr / (2.0 * thecompositor.get_n_pages()) + 0.5)
        printprogress.set_text(_("Rendering page ") + (page_nr + 1).to_string() + _(" of ") + thecompositor.get_n_pages().to_string() + "...")
        if theaction == "print"
            this.printvbox.show()
            status_bar.push(0, _("Printing in progress..."))
        if theaction == "export"
            status_bar.push(0, _("Saving file as pdf"))

    def paginate (context : PrintContext) : bool
        if (thecompositor.paginate (context))
            n_pages : int
            n_pages = thecompositor.get_n_pages()
            op.set_n_pages (n_pages)
            return true
        return false

    def end_print (context : PrintContext)
        check_line_and_col()
        this.printvbox.hide()
        printprogress.set_fraction (0.0)
        printprogress.set_text("")
        check_line_and_col()

    /* ********************************* */
    /*          Exit Function            */
    /* ********************************* */

    def exit_clicked ()
        exit_program()
       
    def exit_program () : bool
        if document_modified is true
            messagedialog = new MessageDialog (this, Gtk.DialogFlags.DESTROY_WITH_PARENT | Gtk.DialogFlags.MODAL, Gtk.MessageType.QUESTION, Gtk.ButtonsType.YES_NO, (_("The file is unregistered, do you want to save it ?")))
            messagedialog.add_button (STOCK_CANCEL, ResponseType.CANCEL)
            var response = messagedialog.run()
            if response is ResponseType.YES
                messagedialog.destroy()
                save_clicked ()
                if cancelclicked is false
                    save_stats ()
                    delete_tmp_file()
                    Gtk.main_quit()
            else if response is ResponseType.NO
                messagedialog.destroy()
                save_stats ()
                delete_tmp_file()
                Gtk.main_quit()
            else if response is ResponseType.CANCEL
                messagedialog.destroy()
                return true
        else
            save_stats ()
            delete_tmp_file()
            Gtk.main_quit()
        return true

    def save_clicked ()
        if thefile is ""
            on_save_as_clicked ()
        else
            save_file()

    /* ********************************* */
    /*  Auto Save and Restore Function   */
    /* ********************************* */
    
    def auto_save_every_two_minutes () : bool
        delete_tmp_file()
        create_tmp_file() 
        return true

    def create_tmp_file ()
        end, start : TextIter
        text_view.buffer.get_bounds (out start, out end)
        try
            var file2 = File.new_for_path(thefile + ".bak~")
            var thefile_stream = file2.create (FileCreateFlags.NONE, null)
            var data_stream = new DataOutputStream (thefile_stream)
            data_stream.put_string (text_view.buffer.get_text(start, end, false), null)
        except e : GLib.Error
            print "Unable to save tmp file" 

    def delete_tmp_file ()
        try
            var destination = File.new_for_path (thefile + ".bak~")
            if (destination.query_exists (null))
                destination.delete(null)
        except ex : GLib.Error
            print "Unable to delete tmp file"

    def restore_text_after_crash ()
        var file = File.new_for_path (thefile + ".bak~")
        if (file.query_exists (null))
            messagedialog = new MessageDialog (this, Gtk.DialogFlags.DESTROY_WITH_PARENT | Gtk.DialogFlags.MODAL, Gtk.MessageType.QUESTION, Gtk.ButtonsType.YES_NO, (_("NicoEdit seems to have crashed while you edit this file, would you like to restore the text stored in the temporary file ?")))
            var response = messagedialog.run()
            if response is ResponseType.YES
                messagedialog.destroy()
                title = thefile + " - NicoEdit"
                text : string
                thetext : string
                try
                    FileUtils.get_contents (thefile + ".bak~", out text, null)
                    thetext = GLib.convert (text, -1, "UTF-8", "UTF-8")
                    text_view.buffer.set_text (thetext, -1)
                    document_modified = true
                except e : GLib.Error
                    print "Unable to restore file"
                GLib.Timeout.add(120000, (auto_save_every_two_minutes))
            else if response is ResponseType.NO
                messagedialog.destroy()
                GLib.Timeout.add(120000, (auto_save_every_two_minutes))
        else
            create_tmp_file ()
            GLib.Timeout.add(120000, (auto_save_every_two_minutes))

    /* ********************************* */
    /*          Save Function            */
    /* ********************************* */

    def on_save_as_clicked ()
        var file_chooser = new FileChooserDialog (_("Save File"), this, FileChooserAction.SAVE, STOCK_CANCEL, ResponseType.CANCEL, STOCK_SAVE, ResponseType.ACCEPT, null)
        var response = file_chooser.run ()
        if response is ResponseType.ACCEPT
            save_new_file (file_chooser.get_filename ())
            cancelclicked = false
        else if response is ResponseType.CANCEL
            cancelclicked = true
        file_chooser.destroy ()

    def save_new_file (filename : string)
        end, start : TextIter
        text_view.buffer.get_bounds (out start, out end)
        try
            status_bar.push(0, _("Saving file: ") + "'" + filename + "'")
            var file = File.new_for_path(filename)
            var thefile_stream = file.create (FileCreateFlags.NONE, null)
            var data_stream = new DataOutputStream (thefile_stream)
            data_stream.put_string (text_view.buffer.get_text(start, end, false), null)
            thefile = filename
            status_bar.push(0, "")
            title = filename + " - NicoEdit"
            document_modified = false
            if fileexecutable is true
                FileUtils.chmod (filename, 0755)
        except e : GLib.Error
            messagedialog = new MessageDialog (this, Gtk.DialogFlags.DESTROY_WITH_PARENT | Gtk.DialogFlags.MODAL, Gtk.MessageType.ERROR, Gtk.ButtonsType.CLOSE, (_("Unable to save file !")))
            messagedialog.run()
            messagedialog.destroy()

    def save_file()
        filename : string = thefile
        encoding : string
        end, start : TextIter
        text_view.buffer.get_bounds (out start, out end)
        try
            status_bar.push(0, _("Saving file: ") + "'" + filename + "'")
            var file = File.new_for_path(thefile)
            var renamed = file.set_display_name ("samplefile.bak", null)
            var thefile_stream = file.create (FileCreateFlags.NONE, null)
            var data_stream = new DataOutputStream (thefile_stream)
            encoding = GLib.convert (text_view.buffer.get_text(start, end, false), -1, "UTF-8", "UTF-8")
            data_stream.put_string (encoding, null)
            renamed.delete(null)
            thefile = filename
            title = filename + " - NicoEdit"
            document_modified = false
            status_bar.push(0, "")
            if fileexecutable is true
                FileUtils.chmod (filename, 0755)
        except e : GLib.Error
            messagedialog = new MessageDialog (this, Gtk.DialogFlags.DESTROY_WITH_PARENT | Gtk.DialogFlags.MODAL, Gtk.MessageType.ERROR, Gtk.ButtonsType.CLOSE, (_("Unable to save file !")))
            messagedialog.run()
            messagedialog.destroy()

    /* ********************************* */
    /*          Open Function            */
    /* ********************************* */

    def on_open_clicked ()
        if document_modified is true
            messagedialog = new MessageDialog (this, Gtk.DialogFlags.DESTROY_WITH_PARENT | Gtk.DialogFlags.MODAL, Gtk.MessageType.QUESTION, Gtk.ButtonsType.YES_NO, (_("The file is unregistered, do you want to save it ?")))
            var response = messagedialog.run()
            if response is ResponseType.YES
                save_clicked ()
                messagedialog.destroy()
            else if response is ResponseType.NO
                open_file_now()
                messagedialog.destroy()
        else
            open_file_now()

    def open_file_now ()
        var file_chooser = new FileChooserDialog ((_("Open File")), this, FileChooserAction.OPEN, STOCK_CANCEL, ResponseType.CANCEL, STOCK_OPEN, ResponseType.ACCEPT, null)
        if (file_chooser.run () == ResponseType.ACCEPT)
            open_file (file_chooser.get_filename ())
        file_chooser.destroy ()

    def open_file (filename : string)
        delete_tmp_file()
        text : string = ""
        thetext : string = ""
        try
            if filename is not null
                status_bar.push(0, _("Loading file: ") + "'" + filename + "'")
                buf.begin_not_undoable_action ()
                FileUtils.get_contents (filename, out text, null)
                thetext = GLib.convert (text, -1, "UTF-8", "UTF-8")
                text_view.buffer.set_text (thetext, -1)
                go_to_line(1)
                buf.end_not_undoable_action ()
                check_undo_redo()
                if filename is not (thefile + ".bak~")
                    reloadmenu.sensitive = true
                    title = filename + " - NicoEdit"
                    document_modified = false
                    thefile = filename
                    auto_detect_syntax()
                    status_bar.push(0, "")
                    restore_text_after_crash ()
                    delete_tmp_file()
                    create_tmp_file()
                    uri : string = "file://" + filename
                    var themanager = recentmanager.get_default()
                    themanager.add_item(uri)
                    if FileUtils.test (filename, FileTest.IS_EXECUTABLE) is true
                        fileexecutable = true
                    else
                        fileexecutable = false
                else
                    reloadmenu.sensitive = false
                    thefile = filename
                    title = thefile + "* - " + _("unregistered") + " - NicoEdit"
                    document_modified = true
                    check_correct_lang(text)
                    status_bar.push(0, "")
                text_view.grab_focus ()
        except e : GLib.Error
            messagedialog = new MessageDialog (this, Gtk.DialogFlags.DESTROY_WITH_PARENT | Gtk.DialogFlags.MODAL, Gtk.MessageType.ERROR, Gtk.ButtonsType.CLOSE, (_("Unable to open file !")))
            messagedialog.run()
            messagedialog.destroy()

    /* ********************************* */
    /*         Reload Function           */
    /* ********************************* */

    def reload_file()
        if thefile is not "" and document_modified is true
            messagedialog = new MessageDialog (this, Gtk.DialogFlags.DESTROY_WITH_PARENT | Gtk.DialogFlags.MODAL, Gtk.MessageType.QUESTION, Gtk.ButtonsType.YES_NO, (_("The file is unregistered, do you want to save it ?")))
            var response = messagedialog.run()
            if response is ResponseType.YES
                save_clicked ()
                messagedialog.destroy()
            else if response is ResponseType.NO
                open_file(thefile)
                messagedialog.destroy()
        else
            open_file(thefile)
        if document_modified is false
            open_file(thefile)

    /* ********************************* */
    /*           About Dialog            */
    /* ********************************* */

    def about_clicked ()
        var about = new AboutDialog ()
        about.set_version(Config.VERSION)
        about.set_program_name("NicoEdit")
        about.set_comments(_("Edit your text file with syntax highlighting !"))
        about.set_copyright(Config.COPYRIGHT)
        about.run()
        about.hide()

