/*  RipOff - Plugin based CD Ripper
 *  Copyright (C) 2006 Bobby Ryan Newberry
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef RIPOFFEXTRACTOR_H
#define RIPOFFEXTRACTOR_H
#include <cdio/cdda.h>
#include <cdio/paranoia.h>
#include "lib/RipOff.h"
#include "RipOffPlugin.h"
#include "RipOffTrackList.h"

struct RipOffExtractor_ 
{
	RipOffPlugin plugin;
	RipOffTrackList track_list;
	gchar *cd_device_path;
	gchar *output_folder;
	gchar *file_pattern;
	GtkWidget *main_window;
};
typedef struct RipOffExtractor_ * RipOffExtractor;

RipOffExtractor ripoff_extractor_new(	RipOffPlugin plugin, 
					RipOffTrackList track_list, 
					gchar *cd_device_path,
					gchar *output_folder, 
					gchar *file_pattern,
					GtkWidget *main_window);

gboolean ripoff_extractor_perform_operation(RipOffExtractor extractor);

void ripoff_extractor_destroy(RipOffExtractor extractor);

#endif

