/*	
 *   IPC package for CygWin32
 *
 *   Copyright (C) 1997 Philippe CHAPUY
 *   Copyright (C) 1998 Ludovic LANGE
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 *   HISTORY:
 *   --------
 *
 *   13/05/1998 : Version 1.00 released
 *                First public release
 *                adress any comments to llange@capgemini.fr
 *
 */
 
 


/************************************************************************/
/*									*/
/************************************************************************/

#ifndef CYGWIN32_IPCNT_LIT
#define CYGWIN32_IPCNT_LIT

#define CYGWIN32_IPCNT_BIT_IPC			0x0001

/************************************************************************/
/************************************************************************/
#define CYGWIN32_IPCNT_SEMCTL		"MultiSemCtl"
#define CYGWIN32_IPCNT_SEMSEM		"MultiSemSem"
#define CYGWIN32_IPCNT_SEMSHM		"MultiSemShm"
#define CYGWIN32_IPCNT_SEMMSG		"MultiSemMsg"
#define CYGWIN32_IPCNT_FILESEM		"/tmp/MultiFileSem"
#define CYGWIN32_IPCNT_FILESHM		"/tmp/MultiFileShm"
#define CYGWIN32_IPCNT_FILEMSG		"/tmp/MultiFileMsg"


/************************************************************************/
/* SEMAPHORE								*/
/************************************************************************/
#define CYGWIN32_IPCNT_RETURN(a) \
	{ \
	errno = 0 ; \
	if( a == -1 ) return (a) ; \
	if( a < 0 ) { errno = -a; return(-1) ; } \
	return (a) ; \
	}

#define CYGWIN32_IPCNT_RETURN_DECONNECT(a) \
	{ \
	sem_deconnect() ; \
	errno = 0 ; \
	if( a == -1 ) return (a) ; \
	if( a < 0 ) { errno = -a; return(-1) ; } \
	return (a) ; \
	}

#if SHMAT_LINUX

#define CYGWIN32_IPCNT_RETURN_DECONNECT_SHMAT(a) CYGWIN32_IPCNT_RETURN_DECONNECT(a)

#else

#define CYGWIN32_IPCNT_RETURN_DECONNECT_SHMAT(a) \
	{ \
	sem_deconnect() ; \
	errno = 0 ; \
	if( a == -1 ) return ((char *)a) ; \
	if( a < 0 ) { errno = -a; return((char *)-1) ; } \
	return (adr) ; \
	}
#endif

#define CYGWIN32_IPCNT_RETURN_DECONNECT_WAIT1(a) \
	{ \
	sem_deconnect() ; \
	sleep(1) ; \
	errno = 0 ; \
	if( a == -1 ) return (a) ; \
	if( a < 0 ) { errno = -a; return(-1) ; } \
	return (a) ; \
	}


/************************************************************************/
/* MEMOIRE PARTAGEE							*/
/************************************************************************/

/************************************************************************/
/* MESSAGE QUEUE							*/
/************************************************************************/


#endif
