.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "REVOKE" "l" "08 May 2000" "SQL - Language Statements" ""
.SH NAME
REVOKE \- Revokes access privilege from a user, a group or all users.
.SH SYNOPSIS
.sp
.nf
REVOKE \fIprivilege\fR [, ...]
    ON \fIobject\fR [, ...]
    FROM { PUBLIC | GROUP \fIgroupname\fR | \fIusername\fR }
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIprivilege\fB\fR
The possible privileges are:
.RS
.TP
\fBSELECT\fR
Privilege to access all of the columns of a specific
table/view.
.TP
\fBINSERT\fR
Privilege to insert data into all columns of a
specific table.
.TP
\fBUPDATE\fR
Privilege to update all columns of a specific
table.
.TP
\fBDELETE\fR
Privilege to delete rows from a specific table.
.TP
\fBRULE\fR
Privilege to define rules on table/view.
(See 
\fBcreate_rule\fR(l)).
.TP
\fBALL\fR
Rescind all privileges.
.RE
.PP
.TP
\fB\fIobject\fB\fR
The name of an object from which to revoke access.
The possible objects are:
.RS
.TP 0.2i
\(bu
table 
.TP 0.2i
\(bu
view 
.TP 0.2i
\(bu
sequence
.RE
.PP
.TP
\fB\fIgroup\fB\fR
The name of a group from whom to revoke privileges.
.TP
\fB\fIusername\fB\fR
The name of a user from whom revoke privileges. Use the PUBLIC keyword
to specify all users.
.TP
\fBPUBLIC\fR
Rescind the specified privilege(s) for all users.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBCHANGE\fR
Message returned if successfully.
.TP
\fBERROR\fR
Message returned if object is not available or impossible
to revoke privileges from a group or users.
.PP
.SH "DESCRIPTION"
.PP
\fBREVOKE\fR allows creator of an object to revoke permissions granted
before, from all users (via PUBLIC) or a certain user or group.
.SS "NOTES"
.PP
Refer to psql \\z command for further information about permissions 
on existing objects:
.sp
.nf
Database    = lusitania
+------------------+---------------------------------------------+
|  Relation        |        Grant/Revoke Permissions             |
+------------------+---------------------------------------------+
| mytable          | {"=rw","miriam=arwR","group todos=rw"}      |
+------------------+---------------------------------------------+
Legend:
     uname=arwR -- privileges granted to a user
     group gname=arwR -- privileges granted to a GROUP
     =arwR -- privileges granted to PUBLIC
		  
     r -- SELECT
     w -- UPDATE/DELETE
     a -- INSERT
     R -- RULE
     arwR -- ALL
    
.sp
.fi
.sp
.RS
.B "Tip:"
Currently, to create a GROUP you have to insert 
data manually into table pg_group as:
.sp
.nf
INSERT INTO pg_group VALUES ('todos');
CREATE USER miriam IN GROUP todos;
     
.sp
.fi
.RE
.sp
.SH "USAGE"
.PP
Revoke insert privilege from all users on table
films:
.sp
.nf
REVOKE INSERT ON films FROM PUBLIC;
  
.sp
.fi
.PP
Revoke all privileges from user manuel on view kinds:
.sp
.nf
  
REVOKE ALL ON kinds FROM manuel;
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
The SQL92 syntax for \fBREVOKE\fR
has additional capabilities for rescinding
privileges, including those on individual columns in tables:
.TP
\fB.sp\fR
Refer to
\fBgrant\fR(l)
for details on individual fields.
.TP
\fB.sp\fR
Rescinds authority for a user to grant the specified privilege
to others.
Refer to
\fBgrant\fR(l)
for details on individual fields.
.PP
.PP
The possible objects are:

[ TABLE ] table/view

CHARACTER SET character-set

COLLATION collation

TRANSLATION translation

DOMAIN domain
.PP
If user1 gives a privilege WITH GRANT OPTION to user2,
and user2 gives it to user3 then user1 can revoke
this privilege in cascade using the CASCADE keyword.
.PP
If user1 gives a privilege WITH GRANT OPTION to user2,
and user2 gives it to user3 then if user1 try revoke
this privilege it fails if he/she specify the RESTRICT
keyword.
