.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "CREATE TEXT SEARCH TEMPLATE" "" "2008-01-18" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE TEXT SEARCH TEMPLATE \- define a new text search template

.SH SYNOPSIS
.sp
.nf
CREATE TEXT SEARCH TEMPLATE \fIname\fR (
    [ INIT = \fIinit_function\fR , ]
    LEXIZE = \fIlexize_function\fR
)
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBCREATE TEXT SEARCH TEMPLATE\fR creates a new text search
template. Text search templates define the functions that implement
text search dictionaries. A template is not useful by itself, but must
be instantiated as a dictionary to be used. The dictionary typically
specifies parameters to be given to the template functions.
.PP
If a schema name is given then the text search template is created in the
specified schema. Otherwise it is created in the current schema.
.PP
You must be a superuser to use \fBCREATE TEXT SEARCH
TEMPLATE\fR. This restriction is made because an erroneous text
search template definition could confuse or even crash the server.
The reason for separating templates from dictionaries is that a template
encapsulates the ``unsafe'' aspects of defining a dictionary.
The parameters that can be set when defining a dictionary are safe for
unprivileged users to set, and so creating a dictionary need not be a
privileged operation.
.PP
Refer to in the documentation for further information.
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name of the text search template to be created. The name can be
schema-qualified.
.TP
\fB\fIinit_function\fB\fR
The name of the init function for the template.
.TP
\fB\fIlexize_function\fB\fR
The name of the lexize function for the template.
.PP
The function names can be schema-qualified if necessary. Argument types
are not given, since the argument list for each type of function is
predetermined. The lexize function is required, but the init function
is optional.
.PP
.PP
The arguments can appear in any order, not only the one shown above.
.PP
.SH "COMPATIBILITY"
.PP
There is no
\fBCREATE TEXT SEARCH TEMPLATE\fR statement in the SQL
standard.
.SH "SEE ALSO"
ALTER TEXT SEARCH TEMPLATE [\fBalter_text_search_template\fR(l)], DROP TEXT SEARCH TEMPLATE [\fBdrop_text_search_template\fR(l)]
