.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "DROP CAST" "" "2008-01-18" "SQL - Language Statements" "SQL Commands"
.SH NAME
DROP CAST \- remove a cast

.SH SYNOPSIS
.sp
.nf
DROP CAST [ IF EXISTS ] (\fIsourcetype\fR AS \fItargettype\fR) [ CASCADE | RESTRICT ]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBDROP CAST\fR removes a previously defined cast.
.PP
To be able to drop a cast, you must own the source or the target
data type. These are the same privileges that are required to
create a cast.
.SH "PARAMETERS"
.TP
\fBIF EXISTS\fR
Do not throw an error if the cast does not exist. A notice is issued 
in this case.
.TP
\fB\fIsourcetype\fB\fR
The name of the source data type of the cast.
.TP
\fB\fItargettype\fB\fR
The name of the target data type of the cast.
.TP
\fBCASCADE\fR
.TP
\fBRESTRICT\fR
These key words do not have any effect, since there are no
dependencies on casts.
.SH "EXAMPLES"
.PP
To drop the cast from type \fBtext\fR to type \fBint\fR:
.sp
.nf
DROP CAST (text AS int);
.sp
.fi
.SH "COMPATIBILITY"
.PP
The \fBDROP CAST\fR command conforms to the SQL standard.
.SH "SEE ALSO"
CREATE CAST [\fBcreate_cast\fR(l)]
