.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "SHOW" "" "2007-10-27" "SQL - Language Statements" "SQL Commands"
.SH NAME
SHOW \- show the value of a run-time parameter

.SH SYNOPSIS
.sp
.nf
SHOW \fIname\fR
SHOW ALL
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBSHOW\fR will display the current setting of
run-time parameters. These variables can be set using the
\fBSET\fR statement, by editing the
\fIpostgresql.conf\fR configuration file, through
the \fBPGOPTIONS\fR environmental variable (when using
\fBlibpq\fR or a \fBlibpq\fR-based
application), or through command-line flags when starting the
\fBpostgres\fR server. See in the documentation for details.
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name of a run-time parameter. Available parameters are
documented in in the documentation and on the SET [\fBset\fR(l)] reference page. In
addition, there are a few parameters that can be shown but not
set:
.RS
.TP
\fBSERVER_VERSION\fR
Shows the server's version number.
.TP
\fBSERVER_ENCODING\fR
Shows the server-side character set encoding. At present,
this parameter can be shown but not set, because the
encoding is determined at database creation time.
.TP
\fBLC_COLLATE\fR
Shows the database's locale setting for collation (text
ordering). At present, this parameter can be shown but not
set, because the setting is determined at
\fBinitdb\fR time.
.TP
\fBLC_CTYPE\fR
Shows the database's locale setting for character
classification. At present, this parameter can be shown but
not set, because the setting is determined at
\fBinitdb\fR time.
.TP
\fBIS_SUPERUSER\fR
True if the current session authorization identifier has
superuser privileges.
.RE
.PP
.TP
\fBALL\fR
Show the values of all configuration parameters, with descriptions.
.SH "NOTES"
.PP
The function \fBcurrent_setting\fR produces
equivalent output; see in the documentation.
Also, the
\fBpg_settings\fR
system view produces the same information.
.SH "EXAMPLES"
.PP
Show the current setting of the parameter DateStyle:
.sp
.nf
SHOW DateStyle;
 DateStyle
-----------
 ISO, MDY
(1 row)
.sp
.fi
.PP
Show the current setting of the parameter geqo:
.sp
.nf
SHOW geqo;
 geqo
------
 on
(1 row)
.sp
.fi
.PP
Show all settings:
.sp
.nf
SHOW ALL;
              name              |            setting             |                                         description                                          
--------------------------------+--------------------------------+----------------------------------------------------------------------------------------------
 add_missing_from               | off                            | Automatically adds missing table references to FROM clauses.
 allow_system_table_mods        | off                            | Allows modifications of the structure of system tables.
    .
    .
    .
 work_mem                       | 1024                           | Sets the maximum memory to be used for query workspaces.
 zero_damaged_pages             | off                            | Continues processing past damaged page headers.
(146 rows)
.sp
.fi
.SH "COMPATIBILITY"
.PP
The \fBSHOW\fR command is a
PostgreSQL extension.
.SH "SEE ALSO"
SET [\fBset\fR(l)], RESET [\fBreset\fR(l)]
